import pygame as pg

from sickulator.settings import *


class Player(pg.sprite.Sprite):
    def __init__(self, game, x, y):
        self.groups = game.camera_sprite
        pg.sprite.Sprite.__init__(self, self.groups)
        self.game = game
        self.image = pg.Surface((TILESIZE, TILESIZE))
        self.image.fill(YELLOW)
        self.image.set_alpha(0)
        self.rect = self.image.get_rect()
        self.vx, self.vy = 0, 0
        self.x = x * TILESIZE
        self.y = y * TILESIZE

    def get_keys(self):
        self.vx, self.vy = 0, 0
        keys = pg.key.get_pressed()
        if keys[pg.K_LEFT] or keys[pg.K_a]:
            if (self.game.camera_point != None):
                self.game.camera_point.selected = False
                self.game.camera_point = None
            self.vx = -CAMERA_SPEED
        if keys[pg.K_RIGHT] or keys[pg.K_d]:
            if (self.game.camera_point != None):
                self.game.camera_point.selected = False
                self.game.camera_point = None
            self.vx = CAMERA_SPEED
        if keys[pg.K_UP] or keys[pg.K_w]:
            if (self.game.camera_point != None):
                self.game.camera_point.selected = False
                self.game.camera_point = None
            self.vy = -CAMERA_SPEED
        if keys[pg.K_DOWN] or keys[pg.K_s]:
            if (self.game.camera_point != None):
                self.game.camera_point.selected = False
                self.game.camera_point = None

            self.vy = CAMERA_SPEED
        if self.vx != 0 and self.vy != 0:
            self.vx *= 0.7071
            self.vy *= 0.7071

    def collide_with_walls(self, dir):
        if dir == 'x':
            hits = pg.sprite.spritecollide(self, self.game.walls, False)
            if hits:
                if self.vx > 0:
                    self.x = hits[0].rect.left - self.rect.width
                if self.vx < 0:
                    self.x = hits[0].rect.right
                self.vx = 0
                self.rect.x = self.x
        if dir == 'y':
            hits = pg.sprite.spritecollide(self, self.game.walls, False)
            if hits:
                if self.vy > 0:
                    self.y = hits[0].rect.top - self.rect.height
                if self.vy < 0:
                    self.y = hits[0].rect.bottom
                self.vy = 0
                self.rect.y = self.y

    def update(self):
        self.get_keys()
        if self.game.camera_point != None:
            x = self.game.camera_point.rect.x
            y = self.game.camera_point.rect.y
        else:
            x = self.x + self.vx * self.game.true_dt
            y = self.y + self.vy * self.game.true_dt
        x = min(992, x)  # right
        y = min(430, y)  # bottom
        x = max(512, x)  # left
        y = max(384, y)  # top
        self.x = x
        self.y = y
        self.rect.x = self.x
        self.collide_with_walls('x')
        self.rect.y = self.y
        self.collide_with_walls('y')

class Wall(pg.sprite.Sprite):
    def __init__(self, game, x, y):
        self.groups = game.all_sprites, game.walls
        pg.sprite.Sprite.__init__(self, self.groups)
        self.game = game
        self.image = pg.Surface((TILESIZE, TILESIZE))
        self.image.fill(GREEN)
        self.rect = self.image.get_rect()
        self.x = x
        self.y = y
        self.rect.x = x * TILESIZE
        self.rect.y = y * TILESIZE


class Obstacle(pg.sprite.Sprite):
    def __init__(self, game, x, y, w, h):
        self.groups = game.walls
        pg.sprite.Sprite.__init__(self, self.groups)
        self.game = game
        self.rect = pg.Rect(x, y, w, h)
        self.hit_rect = self.rect
        self.x = x
        self.y = y
        self.rect.x = x
        self.rect.y = y

