/*
 * Decompiled with CFR 0.152.
 */
package upack;

import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import upack.Arr;
import upack.Binary;
import upack.Ext;
import upack.False$;
import upack.Float32;
import upack.Float64;
import upack.Int32;
import upack.Int64;
import upack.Msg;
import upack.MsgVisitor;
import upack.Null$;
import upack.Obj;
import upack.Str;
import upack.True$;
import upack.UInt64;
import upickle.core.ArrVisitor;
import upickle.core.ObjArrVisitor;
import upickle.core.ObjVisitor;
import upickle.core.Visitor;

public final class Msg$
implements MsgVisitor<Msg, Msg> {
    public static final Msg$ MODULE$ = new Msg$();

    static {
        Visitor.$init$(MODULE$);
        MsgVisitor.$init$(MODULE$);
    }

    @Override
    public Object visitFloat64String(String s, int index) {
        return MsgVisitor.visitFloat64String$(this, s, index);
    }

    @Override
    public Object visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
        return MsgVisitor.visitFloat64StringParts$(this, s, decIndex, expIndex, index);
    }

    @Override
    public <Z> Visitor<Msg, Z> map(Function1<Msg, Z> f) {
        return Visitor.map$(this, f);
    }

    @Override
    public <Z> Visitor<Msg, Z> mapNulls(Function1<Msg, Z> f) {
        return Visitor.mapNulls$(this, f);
    }

    public <T> T transform(Msg j, Visitor<?, T> f) {
        T t;
        Msg msg = j;
        if (Null$.MODULE$.equals(msg)) {
            t = f.visitNull(-1);
        } else if (True$.MODULE$.equals(msg)) {
            t = f.visitTrue(-1);
        } else if (False$.MODULE$.equals(msg)) {
            t = f.visitFalse(-1);
        } else if (msg instanceof Int32) {
            Int32 int32 = (Int32)msg;
            int value = int32.value();
            t = f.visitInt32(value, -1);
        } else if (msg instanceof Int64) {
            Int64 int64 = (Int64)msg;
            long value = int64.value();
            t = f.visitInt64(value, -1);
        } else if (msg instanceof UInt64) {
            UInt64 uInt64 = (UInt64)msg;
            long value = uInt64.value();
            t = f.visitUInt64(value, -1);
        } else if (msg instanceof Float32) {
            Float32 float32 = (Float32)msg;
            float value = float32.value();
            t = f.visitFloat32(value, -1);
        } else if (msg instanceof Float64) {
            Float64 float64 = (Float64)msg;
            double value = float64.value();
            t = f.visitFloat64(value, -1);
        } else if (msg instanceof Str) {
            Str str = (Str)msg;
            String value = str.value();
            t = f.visitString(value, -1);
        } else if (msg instanceof Binary) {
            Binary binary = (Binary)msg;
            byte[] value = binary.value();
            t = f.visitBinary(value, 0, value.length, -1);
        } else if (msg instanceof Arr) {
            Arr arr = (Arr)msg;
            ArrayBuffer<Msg> items = arr.value();
            t = this.visitArrContents(f, items);
        } else if (msg instanceof Obj) {
            Obj obj = (Obj)msg;
            LinkedHashMap<Msg, Msg> items = obj.value();
            t = this.visitObjContents(f, items);
        } else if (msg instanceof Ext) {
            Ext ext = (Ext)msg;
            byte tag2 = ext.tag();
            byte[] data = ext.data();
            t = f.visitExt(tag2, data, 0, data.length, -1);
        } else {
            throw new MatchError(msg);
        }
        return t;
    }

    private <T> T visitObjContents(Visitor<?, T> f, LinkedHashMap<Msg, Msg> items) {
        ObjVisitor<?, T> obj = f.visitObject(items.size(), true, -1);
        Iterator<Tuple2<Msg, Msg>> kvs = items.iterator();
        while (kvs.hasNext()) {
            Tuple2<Msg, Msg> kv = kvs.next();
            Msg k = kv._1();
            Msg v = kv._2();
            Visitor<?, ?> keyVisitor = obj.visitKey(-1);
            obj.visitKeyValue(k.transform(keyVisitor));
            obj.narrow().visitValue(this.transform(v, obj.subVisitor()), -1);
        }
        return (T)obj.visitEnd(-1);
    }

    private <T> T visitArrContents(Visitor<?, T> f, ArrayBuffer<Msg> items) {
        ArrVisitor<?, T> arr = f.visitArray(items.length(), -1);
        int itemsLength = items.length();
        for (int i = 0; i < itemsLength; ++i) {
            arr.narrow().visitValue(this.transform(items.apply(i), arr.subVisitor()), -1);
        }
        return (T)arr.visitEnd(-1);
    }

    @Override
    public ArrVisitor<Msg, Msg> visitArray(int length, int index) {
        return new ArrVisitor<Msg, Msg>(){
            private final ArrayBuffer<Msg> arr;

            public boolean isObj() {
                return ArrVisitor.isObj$(this);
            }

            public ArrVisitor<Object, Msg> narrow() {
                return ArrVisitor.narrow$(this);
            }

            private ArrayBuffer<Msg> arr() {
                return this.arr;
            }

            public Msg$ subVisitor() {
                return Msg$.MODULE$;
            }

            public void visitValue(Msg v, int index) {
                this.arr().append(v);
            }

            public Arr visitEnd(int index) {
                return new Arr(this.arr());
            }
            {
                ObjArrVisitor.$init$(this);
                ArrVisitor.$init$(this);
                this.arr = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        };
    }

    @Override
    public ObjVisitor<Msg, Msg> visitObject(int length, boolean jsonableKeys, int index) {
        return new ObjVisitor<Msg, Msg>(){
            private final LinkedHashMap<Msg, Msg> map;
            private Msg lastKey;

            public boolean isObj() {
                return ObjVisitor.isObj$(this);
            }

            public ObjVisitor<Object, Msg> narrow() {
                return ObjVisitor.narrow$(this);
            }

            private LinkedHashMap<Msg, Msg> map() {
                return this.map;
            }

            private Msg lastKey() {
                return this.lastKey;
            }

            private void lastKey_$eq(Msg x$1) {
                this.lastKey = x$1;
            }

            public Msg$ subVisitor() {
                return Msg$.MODULE$;
            }

            public void visitValue(Msg v, int index) {
                this.map().update(this.lastKey(), v);
            }

            public Obj visitEnd(int index) {
                return new Obj(this.map());
            }

            public Msg$ visitKey(int index) {
                return Msg$.MODULE$;
            }

            public void visitKeyValue(Object s) {
                this.lastKey_$eq((Msg)s);
            }
            {
                ObjArrVisitor.$init$(this);
                ObjVisitor.$init$(this);
                this.map = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                this.lastKey = null;
            }
        };
    }

    @Override
    public Null$ visitNull(int index) {
        return Null$.MODULE$;
    }

    @Override
    public False$ visitFalse(int index) {
        return False$.MODULE$;
    }

    @Override
    public True$ visitTrue(int index) {
        return True$.MODULE$;
    }

    @Override
    public Float64 visitFloat64(double d, int index) {
        return new Float64(d);
    }

    @Override
    public Float32 visitFloat32(float d, int index) {
        return new Float32(d);
    }

    @Override
    public Int32 visitInt32(int i, int index) {
        return new Int32(i);
    }

    @Override
    public Int64 visitInt64(long i, int index) {
        return new Int64(i);
    }

    @Override
    public UInt64 visitUInt64(long i, int index) {
        return new UInt64(i);
    }

    @Override
    public Str visitString(CharSequence s, int index) {
        return new Str(((Object)s).toString());
    }

    @Override
    public Binary visitBinary(byte[] bytes, int offset, int len, int index) {
        return new Binary((byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(bytes), offset, offset + len));
    }

    @Override
    public Ext visitExt(byte tag2, byte[] bytes, int offset, int len, int index) {
        return new Ext(tag2, (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(bytes), offset, offset + len));
    }

    @Override
    public Int32 visitChar(char s, int index) {
        return new Int32(s);
    }

    private Msg$() {
    }
}

