/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.objects;

import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.util.Random;
import textworldexpress.objects.Door;

@ScalaSignature(bytes="\u0006\u0005i3A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!9\u0011\u0004\u0001b\u0001\n\u0003Q\u0002BB\u0019\u0001A\u0003%1\u0004C\u00033\u0001\u0011%1\u0007C\u00039\u0001\u0011%\u0011\bC\u0003B\u0001\u0011%!\tC\u0003D\u0001\u0011\u0005AIA\u0005E_>\u0014X*Y6fe*\u0011!bC\u0001\b_\nTWm\u0019;t\u0015\u0005a\u0011\u0001\u0005;fqR<xN\u001d7eKb\u0004(/Z:t\u0007\u0001\u0019\"\u0001A\b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t\u0011\"A\u0002mkR,\u0012a\u0007\t\u00059\u0005\u001ac&D\u0001\u001e\u0015\tqr$A\u0004nkR\f'\r\\3\u000b\u0005\u0001\n\u0012AC2pY2,7\r^5p]&\u0011!%\b\u0002\u0004\u001b\u0006\u0004\bC\u0001\u0013,\u001d\t)\u0013\u0006\u0005\u0002'#5\tqE\u0003\u0002)\u001b\u00051AH]8pizJ!AK\t\u0002\rA\u0013X\rZ3g\u0013\taSF\u0001\u0004TiJLgn\u001a\u0006\u0003UE\u00012\u0001E\u0018$\u0013\t\u0001\u0014CA\u0003BeJ\f\u00170\u0001\u0003mkR\u0004\u0013!B7l\u0017\u0016LHcA\u00125m!)Q\u0007\u0002a\u0001G\u0005IAn\\2bi&|g.\r\u0005\u0006o\u0011\u0001\raI\u0001\nY>\u001c\u0017\r^5p]J\n\u0001\"\u00193e)>dU\u000b\u0016\u000b\u0005uurt\b\u0005\u0002\u0011w%\u0011A(\u0005\u0002\u0005+:LG\u000fC\u00036\u000b\u0001\u00071\u0005C\u00038\u000b\u0001\u00071\u0005C\u0003A\u000b\u0001\u0007a&A\u0003wC2,X-\u0001\u0003j]&$H#\u0001\u001e\u0002\r5\\Gi\\8s)\u0015)5j\u0015+V!\r\u0001b\tS\u0005\u0003\u000fF\u0011aa\u00149uS>t\u0007C\u0001\rJ\u0013\tQ\u0015B\u0001\u0003E_>\u0014\b\"\u0002'\b\u0001\u0004i\u0015!\u0001:\u0011\u00059\u000bV\"A(\u000b\u0005A\u000b\u0012\u0001B;uS2L!AU(\u0003\rI\u000bg\u000eZ8n\u0011\u0015)t\u00011\u0001$\u0011\u00159t\u00011\u0001$\u0011\u00151v\u00011\u0001X\u0003\u0019I7o\u00149f]B\u0011\u0001\u0003W\u0005\u00033F\u0011qAQ8pY\u0016\fg\u000e")
public class DoorMaker {
    private final Map<String, String[]> lut = (Map)Map$.MODULE$.apply(Nil$.MODULE$);

    public Map<String, String[]> lut() {
        return this.lut;
    }

    private String mkKey(String location1, String location2) {
        String key2 = new StringBuilder(1).append(location1).append("+").append(location2).toString();
        return key2;
    }

    private void addToLUT(String location1, String location2, String[] value) {
        String key2 = this.mkKey(location1, location2);
        this.lut().update(key2, value);
    }

    private void init() {
        this.addToLUT("pantry", "kitchen", (String[])((Object[])new String[]{"frosted-glass door", "plain door"}));
        this.addToLUT("kitchen", "backyard", (String[])((Object[])new String[]{"sliding patio door", "patio door", "screen door"}));
        this.addToLUT("corridor", "backyard", (String[])((Object[])new String[]{"sliding patio door", "patio door", "screen door"}));
        this.addToLUT("living room", "backyard", (String[])((Object[])new String[]{"sliding patio door", "patio door", "screen door"}));
        this.addToLUT("living room", "driveway", (String[])((Object[])new String[]{"front door", "fiberglass door"}));
        this.addToLUT("corridor", "driveway", (String[])((Object[])new String[]{"front door", "fiberglass door"}));
        this.addToLUT("supermarket", "street", (String[])((Object[])new String[]{"sliding door", "commercial glass door"}));
        String[] genericDoors = (String[])((Object[])new String[]{"wood door"});
        this.addToLUT("bedroom", "living room", genericDoors);
        this.addToLUT("bedroom", "bathroom", genericDoors);
        this.addToLUT("bedroom", "corridor", genericDoors);
        this.addToLUT("bathroom", "living room", genericDoors);
        this.addToLUT("bathroom", "bathroom", genericDoors);
        this.addToLUT("bathroom", "corridor", genericDoors);
        this.addToLUT("bathroom", "kitchen", genericDoors);
        this.addToLUT("laundry room", "kitchen", genericDoors);
        this.addToLUT("laundry room", "bathroom", genericDoors);
        this.addToLUT("laundry room", "corridor", genericDoors);
    }

    public Option<Door> mkDoor(Random r, String location1, String location2, boolean isOpen) {
        String key2 = this.mkKey(location1, location2);
        if (!this.lut().contains(key2)) {
            return None$.MODULE$;
        }
        String[] possibleDoors = (String[])this.lut().apply(key2);
        int randIdx = r.nextInt(possibleDoors.length);
        String description = possibleDoors[randIdx];
        Door door = new Door(description, isOpen);
        return new Some<Door>(door);
    }

    public DoorMaker() {
        this.init();
    }
}

