/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.goldagent;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.games.TWCGame;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Room;
import textworldexpress.struct.ActionHistory;
import textworldexpress.struct.StepResult;

@ScalaSignature(bytes="\u0006\u000514A\u0001D\u0007\u0001%!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\t\ri\u0002\u0001\u0015!\u0003(\u0011\u001dY\u0004A1A\u0005\u0002\u0019Ba\u0001\u0010\u0001!\u0002\u00139\u0003\"B\u001f\u0001\t\u0013q\u0004bB)\u0001#\u0003%IA\u0015\u0005\b;\u0002\t\n\u0011\"\u0003_\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0011\u0015\u0019\u0007\u0001\"\u0001e\u00051!vkQ$pY\u0012\fu-\u001a8u\u0015\tqq\"A\u0005h_2$\u0017mZ3oi*\t\u0001#\u0001\tuKb$xo\u001c:mI\u0016D\bO]3tg\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fM\u0006!q-Y7f!\tYb$D\u0001\u001d\u0015\tir\"A\u0003hC6,7/\u0003\u0002 9\t9AkV\"HC6,\u0017A\u0002\u001fj]&$h\b\u0006\u0002#IA\u00111\u0005A\u0007\u0002\u001b!)\u0011D\u0001a\u00015\u0005q1N\\8x]2{7-\u0019;j_:\u001cX#A\u0014\u0011\u0007!js&D\u0001*\u0015\tQ3&A\u0004nkR\f'\r\\3\u000b\u00051*\u0012AC2pY2,7\r^5p]&\u0011a&\u000b\u0002\u0004'\u0016$\bC\u0001\u00198\u001d\t\tT\u0007\u0005\u00023+5\t1G\u0003\u00025#\u00051AH]8pizJ!AN\u000b\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003mU\tqb\u001b8po:dunY1uS>t7\u000fI\u0001\u000ea2\f7-\u001a3PE*,7\r^:\u0002\u001dAd\u0017mY3e\u001f\nTWm\u0019;tA\u0005A\u0002/\u001e;Bo\u0006LxJ\u00196fGR\u001c(+\u00198e_6<\u0016\r\\6\u0015\t}\u0012%j\u0014\t\u0003)\u0001K!!Q\u000b\u0003\u000f\t{w\u000e\\3b]\")1i\u0002a\u0001\t\u0006\t!\u000f\u0005\u0002F\u00116\taI\u0003\u0002H+\u0005!Q\u000f^5m\u0013\tIeI\u0001\u0004SC:$w.\u001c\u0005\b\u0017\u001e\u0001\n\u00111\u0001M\u00035qW/\\%uKJ\fG/[8ogB\u0011A#T\u0005\u0003\u001dV\u00111!\u00138u\u0011\u001d\u0001v\u0001%AA\u0002=\nA\u0002\\1ti2{7-\u0019;j_:\f!\u0005];u\u0003^\f\u0017p\u00142kK\u000e$8OU1oI>lw+\u00197lI\u0011,g-Y;mi\u0012\u0012T#A*+\u00051#6&A+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016!C;oG\",7m[3e\u0015\tQV#\u0001\u0006b]:|G/\u0019;j_:L!\u0001X,\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0012qkR\fu/Y=PE*,7\r^:SC:$w.\\,bY.$C-\u001a4bk2$HeM\u000b\u0002?*\u0012q\u0006V\u0001\u000e[.<u\u000e\u001c3QCRDGkV\"\u0015\u0005}\u0012\u0007\"B\"\u000b\u0001\u0004!\u0015AC7l\u000f>dG\rU1uQR\u0011Qm\u001b\t\u0005)\u0019|\u0004.\u0003\u0002h+\t1A+\u001e9mKJ\u00022\u0001F50\u0013\tQWCA\u0003BeJ\f\u0017\u0010C\u0003D\u0017\u0001\u0007A\t")
public class TWCGoldAgent {
    private final TWCGame game;
    private final Set<String> knownLocations;
    private final Set<String> placedObjects;

    public Set<String> knownLocations() {
        return this.knownLocations;
    }

    public Set<String> placedObjects() {
        return this.placedObjects;
    }

    private boolean putAwayObjectsRandomWalk(Random r, int numIterations, String lastLocation) {
        while (true) {
            Object object;
            int MAX_ITERATIONS = 25;
            Room agentLocation = this.game.agentLocation();
            if (this.game.getScore().scoreNormalized() >= 1.0) {
                return true;
            }
            this.knownLocations().add(agentLocation.name());
            ListBuffer<FastObject> visibleObjects = agentLocation.collectVisibleObjects(agentLocation.collectVisibleObjects$default$1());
            visibleObjects.foreach((Function1<FastObject, Object> & Serializable)obj -> obj.isMovable() && !this.placedObjects().contains(obj.name()) ? $this.game.step(new StringBuilder(5).append("take ").append(obj.name()).toString()) : BoxedUnit.UNIT);
            this.game.agentInventory().contents().foreach((Function1<FastObject, Object> & Serializable)iObj -> {
                TWCGoldAgent.$anonfun$putAwayObjectsRandomWalk$2(this, visibleObjects, iObj);
                return BoxedUnit.UNIT;
            });
            if (this.game.locations().length > 1) {
                Object object2 = agentLocation.doorNorth() != null && !agentLocation.doorNorth().isOpen() ? this.game.step("open door to north") : BoxedUnit.UNIT;
                Object object3 = agentLocation.doorSouth() != null && !agentLocation.doorSouth().isOpen() ? this.game.step("open door to south") : BoxedUnit.UNIT;
                Object object4 = agentLocation.doorEast() != null && !agentLocation.doorEast().isOpen() ? this.game.step("open door to east") : BoxedUnit.UNIT;
                Object object5 = agentLocation.doorWest() != null && !agentLocation.doorWest().isOpen() ? this.game.step("open door to west") : BoxedUnit.UNIT;
                ArrayBuffer<String> validDirections = new ArrayBuffer<String>();
                Object object6 = agentLocation.locationNorth() != null ? validDirections.append("north") : BoxedUnit.UNIT;
                Object object7 = agentLocation.locationSouth() != null ? validDirections.append("south") : BoxedUnit.UNIT;
                Object object8 = agentLocation.locationEast() != null ? validDirections.append("east") : BoxedUnit.UNIT;
                Object object9 = agentLocation.locationWest() != null ? validDirections.append("west") : BoxedUnit.UNIT;
                if (validDirections.length() > 1) {
                    int randIdx = r.nextInt(validDirections.length());
                    while (true) {
                        Object a = validDirections.apply(randIdx);
                        String string = lastLocation;
                        if (a != null ? !a.equals(string) : string != null) break;
                        randIdx = r.nextInt(validDirections.length());
                    }
                    object = this.game.step(new StringBuilder(5).append("move ").append(validDirections.apply(randIdx)).toString());
                } else {
                    object = this.game.step(new StringBuilder(5).append("move ").append(validDirections.apply(0)).toString());
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            if (numIterations >= MAX_ITERATIONS) break;
            lastLocation = agentLocation.name();
            ++numIterations;
        }
        return false;
    }

    private int putAwayObjectsRandomWalk$default$2() {
        return 0;
    }

    private String putAwayObjectsRandomWalk$default$3() {
        return "";
    }

    private boolean mkGoldPathTWC(Random r) {
        StepResult stepResult = this.game.initalStep();
        boolean success = this.putAwayObjectsRandomWalk(r, this.putAwayObjectsRandomWalk$default$2(), this.putAwayObjectsRandomWalk$default$3());
        return success;
    }

    public Tuple2<Object, String[]> mkGoldPath(Random r) {
        boolean success = this.mkGoldPathTWC(r);
        if (!success) {
            return new Tuple2<Boolean, Object>(BoxesRunTime.boxToBoolean(false), Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        }
        String[] path = (String[])((IterableOnceOps)this.game.history().map((Function1<ActionHistory, String> & Serializable)x$1 -> x$1.actionStr())).toArray(ClassTag$.MODULE$.apply(String.class));
        return new Tuple2<Object, String[]>(BoxesRunTime.boxToBoolean(true), path);
    }

    public static final /* synthetic */ void $anonfun$putAwayObjectsRandomWalk$4(TWCGoldAgent $this, String[] cannonicalLocations$1, FastObject iObj$1, FastObject vObj) {
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cannonicalLocations$1), vObj.name())) {
            Object object = vObj.isContainer() && !vObj.isOpen() && vObj.isOpenable() ? $this.game.step(new StringBuilder(5).append("open ").append(vObj.name()).toString()) : BoxedUnit.UNIT;
            $this.game.step(new StringBuilder(8).append("put ").append(iObj$1.name()).append(" in ").append(vObj.name()).toString());
            $this.placedObjects().add(iObj$1.name());
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$putAwayObjectsRandomWalk$2(TWCGoldAgent $this, ListBuffer visibleObjects$1, FastObject iObj) {
        String[] cannonicalLocations = iObj.canonicalLocations();
        Breaks$.MODULE$.breakable(() -> visibleObjects$1.foreach((Function1<FastObject, Object> & Serializable)vObj -> {
            TWCGoldAgent.$anonfun$putAwayObjectsRandomWalk$4($this, cannonicalLocations, iObj, vObj);
            return BoxedUnit.UNIT;
        }));
    }

    public TWCGoldAgent(TWCGame game) {
        this.game = game;
        this.knownLocations = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
        this.placedObjects = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
    }
}

