/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import textworldexpress.data.RecipeIngredient;
import textworldexpress.objects.FastObject;
import textworldexpress.struct.GameScore;
import textworldexpress.struct.Scorer;

@ScalaSignature(bytes="\u0006\u0005q3Aa\u0004\t\u0001+!AA\u0004\u0001BC\u0002\u0013\u0005Q\u0004\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003\u001f\u0011!y\u0003A!b\u0001\n\u0003\u0001\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000be\u0002A\u0011\u0001\u001e\t\u000f}\u0002\u0001\u0019!C\u0001\u0001\"9Q\t\u0001a\u0001\n\u00031\u0005B\u0002'\u0001A\u0003&\u0011\tC\u0004N\u0001\u0001\u0007I\u0011\u0001(\t\u000fI\u0003\u0001\u0019!C\u0001'\"1Q\u000b\u0001Q!\n=CQA\u0016\u0001\u0005\u0002]CQA\u0016\u0001\u0005\u0002eCQA\u0017\u0001\u0005\u0002m\u0013!cS5uG\",gnR1nKN\u001bwN]5oO*\u0011\u0011CE\u0001\u0006O\u0006lWm\u001d\u0006\u0002'\u0005\u0001B/\u001a=uo>\u0014H\u000eZ3yaJ,7o]\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a%\u000511\u000f\u001e:vGRL!a\u0007\r\u0003\rM\u001bwN]3s\u0003\u0019\u0011XmY5qKV\ta\u0004E\u0002 M!j\u0011\u0001\t\u0006\u0003C\t\nq!\\;uC\ndWM\u0003\u0002$I\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0011\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003S1j\u0011A\u000b\u0006\u0003WI\tA\u0001Z1uC&\u0011QF\u000b\u0002\u0011%\u0016\u001c\u0017\u000e]3J]\u001e\u0014X\rZ5f]R\fqA]3dSB,\u0007%A\u0006uCN\\wJ\u00196fGR\u001cX#A\u0019\u0011\u0007}1#\u0007\u0005\u00024m5\tAG\u0003\u00026%\u00059qN\u00196fGR\u001c\u0018BA\u001c5\u0005)1\u0015m\u001d;PE*,7\r^\u0001\ri\u0006\u001c8n\u00142kK\u000e$8\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007mjd\b\u0005\u0002=\u00015\t\u0001\u0003C\u0003\u001d\u000b\u0001\u0007a\u0004C\u00030\u000b\u0001\u0007\u0011'\u0001\tnCb\u001c6m\u001c:f\rJ|W\u000e\u0015:faV\t\u0011\t\u0005\u0002C\u00076\tA%\u0003\u0002EI\t1Ai\\;cY\u0016\fA#\\1y'\u000e|'/\u001a$s_6\u0004&/\u001a9`I\u0015\fHCA$K!\t\u0011\u0005*\u0003\u0002JI\t!QK\\5u\u0011\u001dYu!!AA\u0002\u0005\u000b1\u0001\u001f\u00132\u0003Ei\u0017\r_*d_J,gI]8n!J,\u0007\u000fI\u0001\raJ,\u0007/\u0019:fI6+\u0017\r\\\u000b\u0002\u001fB\u0019!\t\u0015\u001a\n\u0005E##AB(qi&|g.\u0001\tqe\u0016\u0004\u0018M]3e\u001b\u0016\fGn\u0018\u0013fcR\u0011q\t\u0016\u0005\b\u0017*\t\t\u00111\u0001P\u00035\u0001(/\u001a9be\u0016$W*Z1mA\u0005IAm\\*d_JLgn\u001a\u000b\u0003\u000fbCQ!\u0014\u0007A\u0002=#\u0012aR\u0001\u0012G\u0006d7-\u001e7bi\u0016l\u0015\r_*d_J,G#A!")
public class KitchenGameScoring
extends Scorer {
    private final ArrayBuffer<RecipeIngredient> recipe;
    private final ArrayBuffer<FastObject> taskObjects;
    private double maxScoreFromPrep;
    private Option<FastObject> preparedMeal;

    public ArrayBuffer<RecipeIngredient> recipe() {
        return this.recipe;
    }

    public ArrayBuffer<FastObject> taskObjects() {
        return this.taskObjects;
    }

    public double maxScoreFromPrep() {
        return this.maxScoreFromPrep;
    }

    public void maxScoreFromPrep_$eq(double x$1) {
        this.maxScoreFromPrep = x$1;
    }

    public Option<FastObject> preparedMeal() {
        return this.preparedMeal;
    }

    public void preparedMeal_$eq(Option<FastObject> x$1) {
        this.preparedMeal = x$1;
    }

    public void doScoring(Option<FastObject> preparedMeal) {
        this.preparedMeal_$eq(preparedMeal);
        this.doScoring();
    }

    @Override
    public void doScoring() {
        DoubleRef curScore = DoubleRef.create(0.0);
        BooleanRef taskFailure = BooleanRef.create(false);
        boolean taskSuccess = false;
        if (this.preparedMeal().isEmpty()) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.recipe().length()).foreach$mVc$sp(i -> {
                block4: {
                    if (this.taskObjects().apply(i).isDeleted()) {
                        taskFailure$1.elem = true;
                    }
                    if (this.taskObjects().apply(i).isPreparedIncorrectly(this.recipe().apply(i).preparation())) {
                        taskFailure$1.elem = true;
                    }
                    if (this.taskObjects().apply(i).currentContainer() != null) {
                        String string = this.taskObjects().apply(i).currentContainer().name();
                        String string2 = "inventory";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            curScore$1.elem += 1.0;
                        }
                    }
                    if (!this.recipe().apply(i).requiresPrep()) break block4;
                    curScore$1.elem += this.taskObjects().apply(i).scorePreparedCorrectly(this.recipe().apply(i).preparation());
                }
            });
            this.maxScoreFromPrep_$eq(curScore.elem);
        } else {
            curScore.elem = this.maxScoreFromPrep() + 1.0;
            if (this.preparedMeal().get().isEaten()) {
                curScore.elem += 1.0;
                taskSuccess = true;
            }
        }
        double normalizedScore = curScore.elem / this.maxScore();
        GameScore scores = new GameScore(curScore.elem, normalizedScore, taskSuccess, taskFailure.elem);
        this.curScore_$eq(scores);
    }

    @Override
    public double calculateMaxScore() {
        DoubleRef maxScore = DoubleRef.create(0.0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.recipe().length()).foreach$mVc$sp(i -> {
            block1: {
                Set<String> ingredient = this.recipe().apply(i).preparation();
                maxScore$1.elem += 1.0;
                if (!this.recipe().apply(i).preparation().contains("uncut")) {
                    maxScore$1.elem += 1.0;
                }
                if (this.recipe().apply(i).preparation().contains("raw")) break block1;
                maxScore$1.elem += 1.0;
            }
        });
        maxScore.elem += 2.0;
        return maxScore.elem;
    }

    public KitchenGameScoring(ArrayBuffer<RecipeIngredient> recipe, ArrayBuffer<FastObject> taskObjects) {
        this.recipe = recipe;
        this.taskObjects = taskObjects;
        this.maxScoreFromPrep = 0.0;
        this.preparedMeal = None$.MODULE$;
    }
}

