/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$StringFormat$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.data.LoadTWCDataJSON;
import textworldexpress.data.LoadTWCDataJSON$;
import textworldexpress.data.LoadTWKitchenDataJSON;
import textworldexpress.data.LoadTWKitchenDataJSON$;
import textworldexpress.data.RecipeIngredient;
import textworldexpress.games.KitchenGame;
import textworldexpress.games.KitchenGame$;
import textworldexpress.goldagent.KitchenGoldAgent;
import textworldexpress.objects.Backyard;
import textworldexpress.objects.Bathroom;
import textworldexpress.objects.Bedroom;
import textworldexpress.objects.Cookbook;
import textworldexpress.objects.Corridor;
import textworldexpress.objects.Door;
import textworldexpress.objects.DoorMaker;
import textworldexpress.objects.Driveway;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Kitchen;
import textworldexpress.objects.Kitchen$;
import textworldexpress.objects.LaundryRoom;
import textworldexpress.objects.LivingRoom;
import textworldexpress.objects.Pantry;
import textworldexpress.objects.Room;
import textworldexpress.objects.Street;
import textworldexpress.objects.Supermarket;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001\u0002\u0010 \u0001\u0011BQa\u000b\u0001\u0005\u00021Bqa\f\u0001C\u0002\u0013\u0005\u0001\u0007\u0003\u00048\u0001\u0001\u0006I!\r\u0005\bq\u0001\u0011\r\u0011\"\u0001:\u0011\u0019i\u0004\u0001)A\u0005u!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002$\u0001A\u0003%\u0001\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u0016\u0001\u0011\u0005\u0011Q\u0006\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002p\u0001!\t!!\u001d\t\u0013\u0005E\u0005!%A\u0005\u0002\u0005M\u0005\"CAU\u0001E\u0005I\u0011AAJ\u0011%\tY\u000bAI\u0001\n\u0003\t\u0019\nC\u0005\u0002.\u0002\t\n\u0011\"\u0001\u00020\"I\u00111\u0017\u0001\u0012\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003k\u0003\u0011\u0013!C\u0001\u0003oCq!a/\u0001\t\u0003\ti\fC\u0005\u0002R\u0002\t\n\u0011\"\u0001\u0002\u0014\"I\u00111\u001b\u0001\u0012\u0002\u0013\u0005\u00111\u0013\u0005\n\u0003+\u0004\u0011\u0013!C\u0001\u0003'C\u0011\"a6\u0001#\u0003%\t!a,\t\u0013\u0005e\u0007!%A\u0005\u0002\u0005=\u0006\"CAn\u0001E\u0005I\u0011AA\\\u0005QY\u0015\u000e^2iK:<\u0015-\\3HK:,'/\u0019;pe*\u0011\u0001%I\u0001\u0006O\u0006lWm\u001d\u0006\u0002E\u0005\u0001B/\u001a=uo>\u0014H\u000eZ3yaJ,7o]\u0002\u0001'\t\u0001Q\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003}\t\u0011\u0003V,D\u001f\nTWm\u0019;ECR\f'-Y:f+\u0005\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\"\u0003\u0011!\u0017\r^1\n\u0005Y\u001a$a\u0004'pC\u0012$vk\u0011#bi\u0006T5k\u0014(\u0002%Q;6i\u00142kK\u000e$H)\u0019;bE\u0006\u001cX\rI\u0001\u0018)^[\u0015\u000e^2iK:|%M[3di\u0012\u000bG/\u00192bg\u0016,\u0012A\u000f\t\u0003emJ!\u0001P\u001a\u0003+1{\u0017\r\u001a+X\u0017&$8\r[3o\t\u0006$\u0018MS*P\u001d\u0006ABkV&ji\u000eDWM\\(cU\u0016\u001cG\u000fR1uC\n\f7/\u001a\u0011\u0002\u0013\u0011|wN]'bW\u0016\u0014X#\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u000b\u0013aB8cU\u0016\u001cGo]\u0005\u0003\u000b\n\u0013\u0011\u0002R8pe6\u000b7.\u001a:\u0002\u0015\u0011|wN]'bW\u0016\u0014\b%A\u0007nW\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\b\u0013~;GN\u001c9v!\u00151#\nT,\\\u0013\tYuE\u0001\u0004UkBdWm\r\t\u0004\u001bJ#V\"\u0001(\u000b\u0005=\u0003\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003#\u001e\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0019fJA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bCA!V\u0013\t1&I\u0001\u0003S_>l\u0007cA'S1B\u0011!'W\u0005\u00035N\u0012\u0001CU3dSB,\u0017J\\4sK\u0012LWM\u001c;\u0011\u00075\u0013F\f\u0005\u0002B;&\u0011aL\u0011\u0002\u000b\r\u0006\u001cHo\u00142kK\u000e$\b\"\u00021\t\u0001\u0004\t\u0017!\u0001:\u0011\u0005\t,W\"A2\u000b\u0005\u0011<\u0013\u0001B;uS2L!AZ2\u0003\rI\u000bg\u000eZ8n\u0011\u0015A\u0007\u00021\u0001j\u00031qW/\u001c'pG\u0006$\u0018n\u001c8t!\t1#.\u0003\u0002lO\t\u0019\u0011J\u001c;\t\u000b5D\u0001\u0019A5\u0002%9,X\u000eR5tiJ\f7\r^8s\u0013R,Wn\u001d\u0005\u0006_\"\u0001\r![\u0001\u000f]Vl\u0017J\\4sK\u0012LWM\u001c;t\u0011\u0015\t\b\u00021\u0001s\u00031Ign\u00197vI\u0016$un\u001c:t!\t13/\u0003\u0002uO\t9!i\\8mK\u0006t\u0007\"\u0002<\t\u0001\u00049\u0018\u0001\u00024pY\u0012\u0004\"\u0001_@\u000f\u0005el\bC\u0001>(\u001b\u0005Y(B\u0001?$\u0003\u0019a$o\\8u}%\u0011apJ\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00111\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y<\u0013AC7l\u0007>|7NY8pWR\u0019A,!\u0003\t\r\u0005-\u0011\u00021\u0001X\u0003E\u0011XmY5qK&swM]3eS\u0016tGo]\u0001\u0013C\u0012$\u0017J\\4sK\u0012LWM\u001c;Ji\u0016l7\u000fF\u0004\\\u0003#\t\u0019\"a\u0006\t\u000b\u0001T\u0001\u0019A1\t\r\u0005U!\u00021\u0001M\u0003%awnY1uS>t7\u000f\u0003\u0004\u0002\f)\u0001\raV\u0001\u0013C\u0012$G)[:ue\u0006\u001cGo\u001c:Ji\u0016l7\u000f\u0006\u0006\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003O\u00012!\u0014*x\u0011\u0015\u00017\u00021\u0001b\u0011\u0019\t)b\u0003a\u0001\u0019\"1\u0011QE\u0006A\u0002%\f\u0001B\\;n)>\fE\r\u001a\u0005\u0007\u0003SY\u0001\u0019A.\u0002\u0017Q\f7o[(cU\u0016\u001cGo]\u0001\u0014G>tg.Z2u%>|Wn\u001d$s_6l\u0015\r\u001d\u000b\t\u0003_\t)$a\u000e\u0002DA\u0019a%!\r\n\u0007\u0005MrE\u0001\u0003V]&$\b\"\u00021\r\u0001\u0004\t\u0007bBA\u001d\u0019\u0001\u0007\u00111H\u0001\u0004[\u0006\u0004\b#\u0002\u0014\u0002>\u0005\u0005\u0013bAA O\t)\u0011I\u001d:bsB!a%!\u0010U\u0011\u0015\tH\u00021\u0001s\u0003)!\u0017n\u001d9mCfl\u0015\r\u001d\u000b\u0004o\u0006%\u0003bBA\u001d\u001b\u0001\u0007\u00111H\u0001\u0013M&tG-R7qif$\u0015N]3di&|g\u000e\u0006\u0006\u0002P\u0005U\u0013qKA-\u0003;\u0002RAJA)S&L1!a\u0015(\u0005\u0019!V\u000f\u001d7fe!)\u0001M\u0004a\u0001C\"9\u0011\u0011\b\bA\u0002\u0005m\u0002BBA.\u001d\u0001\u0007\u0011.\u0001\u0003m_\u000eD\u0006BBA0\u001d\u0001\u0007\u0011.\u0001\u0003m_\u000eL\u0016!D7l\u0007>tg.Z2uS>t7\u000f\u0006\u0004\u0002f\u0005-\u0014Q\u000e\t\u0006M\u0005\u001d\u00141H\u0005\u0004\u0003S:#AB(qi&|g\u000eC\u0003a\u001f\u0001\u0007\u0011\r\u0003\u0004\u0002\u0016=\u0001\r\u0001T\u0001\u0007[.<\u0015-\\3\u0015!\u0005M\u0014\u0011PAB\u0003\u000b\u000b9)!#\u0002\f\u0006=\u0005c\u0001\u0018\u0002v%\u0019\u0011qO\u0010\u0003\u0017-KGo\u00195f]\u001e\u000bW.\u001a\u0005\b\u0003w\u0002\u0002\u0019AA?\u0003\u0011\u0019X-\u001a3\u0011\u0007\u0019\ny(C\u0002\u0002\u0002\u001e\u0012A\u0001T8oO\"9\u0001\u000e\u0005I\u0001\u0002\u0004I\u0007bB7\u0011!\u0003\u0005\r!\u001b\u0005\b_B\u0001\n\u00111\u0001j\u0011\u001d\t\b\u0003%AA\u0002ID\u0001\"!$\u0011!\u0003\u0005\rA]\u0001\u0013Y&l\u0017\u000e^%om\u0016tGo\u001c:z'&TX\rC\u0004w!A\u0005\t\u0019A<\u0002!5\\w)Y7fI\u0011,g-Y;mi\u0012\u0012TCAAKU\rI\u0017qS\u0016\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+A\u0005v]\u000eDWmY6fI*\u0019\u00111U\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002(\u0006u%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001Rn[$b[\u0016$C-\u001a4bk2$HeM\u0001\u0011[.<\u0015-\\3%I\u00164\u0017-\u001e7uIQ\n\u0001#\\6HC6,G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005E&f\u0001:\u0002\u0018\u0006\u0001Rn[$b[\u0016$C-\u001a4bk2$HEN\u0001\u0011[.<\u0015-\\3%I\u00164\u0017-\u001e7uI]*\"!!/+\u0007]\f9*\u0001\nnW\u001e\u000bW.Z,ji\"<u\u000e\u001c3QCRDG\u0003EA`\u0003\u0007\f)-a2\u0002J\u0006-\u0017QZAh!\u001d1\u0013\u0011KA:\u0003\u0003\u0004BAJA\u001fo\"9\u00111P\fA\u0002\u0005u\u0004b\u00025\u0018!\u0003\u0005\r!\u001b\u0005\b[^\u0001\n\u00111\u0001j\u0011\u001dyw\u0003%AA\u0002%Dq!]\f\u0011\u0002\u0003\u0007!\u000f\u0003\u0005\u0002\u000e^\u0001\n\u00111\u0001s\u0011\u001d1x\u0003%AA\u0002]\fA$\\6HC6,w+\u001b;i\u000f>dG\rU1uQ\u0012\"WMZ1vYR$#'\u0001\u000fnW\u001e\u000bW.Z,ji\"<u\u000e\u001c3QCRDG\u0005Z3gCVdG\u000fJ\u001a\u000295\\w)Y7f/&$\bnR8mIB\u000bG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%i\u0005aRn[$b[\u0016<\u0016\u000e\u001e5H_2$\u0007+\u0019;iI\u0011,g-Y;mi\u0012*\u0014\u0001H7l\u000f\u0006lWmV5uQ\u001e{G\u000e\u001a)bi\"$C-\u001a4bk2$HEN\u0001\u001d[.<\u0015-\\3XSRDwi\u001c7e!\u0006$\b\u000e\n3fM\u0006,H\u000e\u001e\u00138\u0001")
public class KitchenGameGenerator {
    private final LoadTWCDataJSON TWCObjectDatabase = new LoadTWCDataJSON(LoadTWCDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final LoadTWKitchenDataJSON TWKitchenObjectDatabase = new LoadTWKitchenDataJSON(LoadTWKitchenDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final DoorMaker doorMaker = new DoorMaker();

    public LoadTWCDataJSON TWCObjectDatabase() {
        return this.TWCObjectDatabase;
    }

    public LoadTWKitchenDataJSON TWKitchenObjectDatabase() {
        return this.TWKitchenObjectDatabase;
    }

    public DoorMaker doorMaker() {
        return this.doorMaker;
    }

    public Tuple3<ArrayBuffer<Room>, ArrayBuffer<RecipeIngredient>, ArrayBuffer<FastObject>> mkEnvironment(Random r, int numLocations, int numDistractorItems, int numIngredients, boolean includeDoors, String fold) {
        ArrayBuffer<Room> locations = new ArrayBuffer<Room>();
        Kitchen kitchen = new Kitchen(r, Kitchen$.MODULE$.$lessinit$greater$default$2());
        locations.append(kitchen);
        Object object = numLocations >= 2 ? locations.append(new Pantry(r)) : BoxedUnit.UNIT;
        Object object2 = numLocations >= 3 ? locations.append(new Backyard(r)) : BoxedUnit.UNIT;
        Object object3 = numLocations >= 4 ? locations.append(new Corridor(r)) : BoxedUnit.UNIT;
        Object object4 = numLocations >= 5 ? locations.append(new Bedroom(r)) : BoxedUnit.UNIT;
        Object object5 = numLocations >= 6 ? locations.append(new LivingRoom(r)) : BoxedUnit.UNIT;
        Object object6 = numLocations >= 7 ? locations.append(new Bathroom(r)) : BoxedUnit.UNIT;
        Object object7 = numLocations >= 8 ? locations.append(new LaundryRoom(r)) : BoxedUnit.UNIT;
        Object object8 = numLocations >= 9 ? locations.append(new Driveway(r)) : BoxedUnit.UNIT;
        Object object9 = numLocations >= 10 ? locations.append(new Street(r)) : BoxedUnit.UNIT;
        Object object10 = numLocations >= 11 ? locations.append(new Supermarket(r)) : BoxedUnit.UNIT;
        Option map = None$.MODULE$;
        for (int attempts = 0; map.isEmpty() && attempts < 50; ++attempts) {
            map = this.mkConnections(r, locations);
        }
        if (map.isEmpty()) {
            throw new RuntimeException("ERROR: Could not generate connection map");
        }
        this.connectRoomsFromMap(r, (Room[][])((Option)map).get(), includeDoors);
        ArrayBuffer<RecipeIngredient> recipeIngredients = this.TWKitchenObjectDatabase().mkRandomRecipe(r, numIngredients, fold);
        ArrayBuffer<FastObject> taskObjects = this.addIngredientItems(r, locations, recipeIngredients);
        ArrayBuffer<String> addedDistractorNames = this.addDistractorItems(r, locations, numDistractorItems, taskObjects);
        FastObject cookbook = this.mkCookbook(recipeIngredients);
        Set<FastObject> kitchenObjects = kitchen.contents();
        Breaks$.MODULE$.breakable(() -> kitchenObjects.foreach((Function1<FastObject, Object> & Serializable)obj -> {
            KitchenGameGenerator.$anonfun$mkEnvironment$2(cookbook, obj);
            return BoxedUnit.UNIT;
        }));
        return new Tuple3<ArrayBuffer<Room>, ArrayBuffer<RecipeIngredient>, ArrayBuffer<FastObject>>(locations, recipeIngredients, taskObjects);
    }

    public FastObject mkCookbook(ArrayBuffer<RecipeIngredient> recipeIngredients) {
        StringBuilder os = new StringBuilder();
        os.append("Gather all following ingredients and follow the directions to prepare this tasty meal.\n\n");
        os.append("Ingredients:\n");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), recipeIngredients.length()).foreach((Function1<Object, StringBuilder> & Serializable)i -> os.append(new java.lang.StringBuilder(3).append("  ").append(((RecipeIngredient)recipeIngredients.apply(BoxesRunTime.unboxToInt(i))).name()).append("\n").toString()));
        os.append("\n");
        os.append("Directions:\n");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), recipeIngredients.length()).foreach((Function1<Object, Object> & Serializable)i -> KitchenGameGenerator.$anonfun$mkCookbook$2(recipeIngredients, os, BoxesRunTime.unboxToInt(i)));
        os.append("  prepare meal\n\n");
        Cookbook book = new Cookbook();
        book.readText_$eq(os.toString());
        return book;
    }

    public ArrayBuffer<FastObject> addIngredientItems(Random r, ArrayBuffer<Room> locations, ArrayBuffer<RecipeIngredient> recipeIngredients) {
        boolean attempts = false;
        ArrayBuffer objectNamesAdded = new ArrayBuffer();
        Map allObjects = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        locations.foreach((Function1<Room, Object> & Serializable)location -> {
            KitchenGameGenerator.$anonfun$addIngredientItems$1(allObjects, location);
            return BoxedUnit.UNIT;
        });
        ArrayBuffer<FastObject> objectsAdded = new ArrayBuffer<FastObject>();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), recipeIngredients.length()).foreach$mVc$sp(i -> {
            RecipeIngredient ingredient = (RecipeIngredient)recipeIngredients.apply(i);
            FastObject recipeItem = this.TWKitchenObjectDatabase().mkFastObjectByName(ingredient.name());
            String[] validLocations = recipeItem.canonicalLocations();
            Breaks$.MODULE$.breakable((Function0<BoxedUnit>)(Function0<Nothing$> & Serializable)() -> {
                int attempts = 0;
                while (attempts < 100) {
                    int randLocationIdx = r.nextInt(validLocations.length);
                    String generationLocation = validLocations[randLocationIdx];
                    if (!allObjects.contains(generationLocation)) continue;
                    ((FastObject)allObjects.apply(generationLocation)).addObject(recipeItem);
                    objectsAdded.append(recipeItem);
                    throw Breaks$.MODULE$.break();
                }
                throw new RuntimeException(new java.lang.StringBuilder(42).append("ERROR: Unable to place recipe ingredient: ").append(recipeItem.toString()).toString());
            });
        });
        return objectsAdded;
    }

    public ArrayBuffer<String> addDistractorItems(Random r, ArrayBuffer<Room> locations, int numToAdd, ArrayBuffer<FastObject> taskObjects) {
        ArrayBuffer<String> objectNamesAdded = new ArrayBuffer<String>();
        taskObjects.foreach((Function1<FastObject, ArrayBuffer> & Serializable)taskObject -> (ArrayBuffer)objectNamesAdded.append(taskObject.name()));
        for (int attempts = 0; objectNamesAdded.length() < numToAdd + taskObjects.length() && attempts < 100; ++attempts) {
            Object object;
            int randLocIdx = r.nextInt(locations.length());
            Room location = locations.apply(randLocIdx);
            FastObject[] objects = (FastObject[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])location.contents().toArray(ClassTag$.MODULE$.apply(FastObject.class))), (Function1<FastObject, String> & Serializable)x$2 -> x$2.name(), Ordering$String$.MODULE$);
            if (objects.length > 0) {
                int randObjIdx = r.nextInt(objects.length);
                FastObject container = objects[randObjIdx];
                Option<FastObject> distractorItem = this.TWKitchenObjectDatabase().mkRandomObjectByLocation(r, container.name());
                if (distractorItem.isDefined()) {
                    if (!objectNamesAdded.contains(distractorItem.get().name())) {
                        container.addObject(distractorItem.get());
                        object = objectNamesAdded.append(distractorItem.get().name());
                        continue;
                    }
                    object = BoxedUnit.UNIT;
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return objectNamesAdded;
    }

    public void connectRoomsFromMap(Random r, Room[][] map, boolean includeDoors) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), map.length).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), map[i].length).foreach$mVc$sp(j -> {
            block8: {
                Room queryLoc;
                Room queryLoc2;
                Room queryLoc3;
                Room queryLoc4;
                Room cell = map[i][j];
                if (cell == null) break block8;
                if (i < map.length - 1 && (queryLoc4 = map[i + 1][j]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc4.name())) {
                    Option<Door> door;
                    cell.locationNorth_$eq(queryLoc4);
                    queryLoc4.locationSouth_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc4.name(), false)).isDefined()) {
                        cell.doorNorth_$eq(door.get());
                        queryLoc4.doorSouth_$eq(door.get());
                    }
                }
                if (i >= 1 && (queryLoc3 = map[i - 1][j]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc3.name())) {
                    Option<Door> door;
                    cell.locationSouth_$eq(queryLoc3);
                    queryLoc3.locationNorth_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc3.name(), false)).isDefined()) {
                        cell.doorSouth_$eq(door.get());
                        queryLoc3.doorNorth_$eq(door.get());
                    }
                }
                if (j >= 1 && (queryLoc2 = map[i][j - 1]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc2.name())) {
                    Option<Door> door;
                    cell.locationEast_$eq(queryLoc2);
                    queryLoc2.locationWest_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc2.name(), false)).isDefined()) {
                        cell.doorEast_$eq(door.get());
                        queryLoc2.doorWest_$eq(door.get());
                    }
                }
                if (j < map[i].length - 1 && (queryLoc = map[i][j + 1]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc.name())) {
                    Option<Door> door;
                    cell.locationWest_$eq(queryLoc);
                    queryLoc.locationEast_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc.name(), false)).isDefined()) {
                        cell.doorWest_$eq(door.get());
                        queryLoc.doorEast_$eq(door.get());
                    }
                }
            }
        }));
    }

    public String displayMap(Room[][] map) {
        StringBuilder os = new StringBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])map))).foreach((Function1<Object, StringBuilder> & Serializable)i -> KitchenGameGenerator.$anonfun$displayMap$1(map, os, BoxesRunTime.unboxToInt(i)));
        os.append("Connections:");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])map))).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(map[i]))).foreach((Function1<Object, Object> & Serializable)j -> KitchenGameGenerator.$anonfun$displayMap$4(map, i, os, BoxesRunTime.unboxToInt(j))));
        return os.toString();
    }

    public Tuple2<Object, Object> findEmptyDirection(Random r, Room[][] map, int locX, int locY) {
        Object object = new Object();
        try {
            ArrayBuffer orderToCheck = (ArrayBuffer)r.shuffle((IterableOnce)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), BuildFrom$.MODULE$.buildFromIterableOps());
            orderToCheck.foreach(directionRef -> {
                if (directionRef == 0) {
                    if (locX - 1 >= 0 && map[locX - 1][locY] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX - 1, locY));
                    }
                } else if (directionRef == 1) {
                    if (locX + 1 < map.length && map[locX + 1][locY] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX + 1, locY));
                    }
                } else if (directionRef == 2) {
                    if (locY - 1 >= 0 && map[locX][locY - 1] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX, locY - 1));
                    }
                } else if (directionRef == 3 && locY + 1 < map.length && map[locX][locY + 1] == null) {
                    throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX, locY + 1));
                }
            });
            return new Tuple2$mcII$sp(-1, -1);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public Option<Room[][]> mkConnections(Random r, ArrayBuffer<Room> locations) {
        int GRID_SIZE = 7;
        Room[][] map = (Room[][])Array$.MODULE$.ofDim(GRID_SIZE, GRID_SIZE, ClassTag$.MODULE$.apply(Room.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), GRID_SIZE).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), GRID_SIZE).foreach$mVc$sp(j -> {
            map$4[i$4][j] = null;
        }));
        ArrayBuffer locationsLeft = new ArrayBuffer();
        locationsLeft.insertAll(0, (IterableOnce)r.shuffle(locations, BuildFrom$.MODULE$.buildFromIterableOps()));
        IntRef lastX = IntRef.create(3);
        IntRef lastY = IntRef.create(3);
        map[lastX.elem][lastY.elem] = (Room)locationsLeft.last();
        locationsLeft.remove(locationsLeft.size() - 1);
        ObjectRef<Room> lastLocation = ObjectRef.create(map[lastX.elem][lastY.elem]);
        IntRef attempts = IntRef.create(0);
        ArrayBuffer<Tuple2$mcII$sp> populatedLocations = new ArrayBuffer<Tuple2$mcII$sp>();
        populatedLocations.append(new Tuple2$mcII$sp(lastX.elem, lastY.elem));
        Breaks$.MODULE$.breakable(() -> {
            while (locationsLeft.length() > 0) {
                Object object;
                int refIdx = r.nextInt(populatedLocations.length());
                lastX$1.elem = ((Tuple2)populatedLocations.apply(refIdx))._1$mcI$sp();
                lastY$1.elem = ((Tuple2)populatedLocations.apply(refIdx))._2$mcI$sp();
                lastLocation$1.elem = map[lastX$1.elem][lastY$1.elem];
                int locationIdx = r.nextInt(locationsLeft.length());
                Room location = (Room)locationsLeft.apply(locationIdx);
                if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(location.prefersConnectingTo()), ((Room)lastLocation$1.elem).name())) {
                    Tuple2<Object, Object> tuple2 = this.findEmptyDirection(r, map, lastX$1.elem, lastY$1.elem);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int newX = tuple2._1$mcI$sp();
                    int newY = tuple2._2$mcI$sp();
                    Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(newX, newY);
                    Tuple2$mcII$sp tuple2$mcII$sp2 = tuple2$mcII$sp;
                    int newX2 = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
                    int newY2 = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
                    if (newX2 != -1) {
                        map$4[newX2][newY2] = location;
                        locationsLeft.remove(locationIdx);
                        object = populatedLocations.append(new Tuple2$mcII$sp(newX2, newY2));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                ++attempts$1.elem;
                if (attempts$1.elem <= 100) continue;
                throw Breaks$.MODULE$.break();
            }
        });
        if (locationsLeft.length() > 0) {
            return None$.MODULE$;
        }
        return new Some<Room[][]>(map);
    }

    public KitchenGame mkGame(long seed, int numLocations, int numDistractorItems, int numIngredients, boolean includeDoors, boolean limitInventorySize, String fold) {
        Integer n;
        Map props = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        props.update("seed", BoxesRunTime.boxToInteger((int)seed));
        props.update("numLocations", BoxesRunTime.boxToInteger(numLocations));
        props.update("numDistractorItems", BoxesRunTime.boxToInteger(numDistractorItems));
        props.update("numIngredients", BoxesRunTime.boxToInteger(numIngredients));
        props.update("includeDoors", includeDoors ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0));
        props.update("limitInventorySize", limitInventorySize ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0));
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            n = BoxesRunTime.boxToInteger(1);
        } else {
            String string3 = fold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                n = BoxesRunTime.boxToInteger(2);
            } else {
                String string5 = fold;
                String string6 = "test";
                n = !(string5 != null ? !string5.equals(string6) : string6 != null) ? BoxesRunTime.boxToInteger(3) : BoxesRunTime.boxToInteger(-1);
            }
        }
        props.update("gameSet", n);
        Random r = new Random(seed);
        Tuple3<ArrayBuffer<Room>, ArrayBuffer<RecipeIngredient>, ArrayBuffer<FastObject>> tuple3 = this.mkEnvironment(r, numLocations, numDistractorItems, numIngredients, includeDoors, fold);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ArrayBuffer<Room> locations = tuple3._1();
        ArrayBuffer<RecipeIngredient> recipe = tuple3._2();
        ArrayBuffer<FastObject> taskObjects = tuple3._3();
        Tuple3<ArrayBuffer<Room>, ArrayBuffer<RecipeIngredient>, ArrayBuffer<FastObject>> tuple32 = new Tuple3<ArrayBuffer<Room>, ArrayBuffer<RecipeIngredient>, ArrayBuffer<FastObject>>(locations, recipe, taskObjects);
        Tuple3<ArrayBuffer<Room>, ArrayBuffer<RecipeIngredient>, ArrayBuffer<FastObject>> tuple33 = tuple32;
        ArrayBuffer<Room> locations2 = tuple33._1();
        ArrayBuffer<RecipeIngredient> recipe2 = tuple33._2();
        ArrayBuffer<FastObject> taskObjects2 = tuple33._3();
        Room[] x$1 = (Room[])locations2.toArray(ClassTag$.MODULE$.apply(Room.class));
        ArrayBuffer<RecipeIngredient> x$2 = recipe2;
        ArrayBuffer<FastObject> x$3 = taskObjects2;
        boolean x$4 = limitInventorySize;
        scala.collection.immutable.Map<String, Object> x$5 = props.toMap($less$colon$less$.MODULE$.refl());
        long x$6 = KitchenGame$.MODULE$.$lessinit$greater$default$5();
        KitchenGame game = new KitchenGame(x$1, x$2, x$3, x$4, x$6, x$5);
        return game;
    }

    public int mkGame$default$2() {
        return 12;
    }

    public int mkGame$default$3() {
        return 10;
    }

    public int mkGame$default$4() {
        return 3;
    }

    public boolean mkGame$default$5() {
        return true;
    }

    public boolean mkGame$default$6() {
        return true;
    }

    public String mkGame$default$7() {
        return "train";
    }

    public Tuple2<KitchenGame, String[]> mkGameWithGoldPath(long seed, int numLocations, int numDistractorItems, int numIngredients, boolean includeDoors, boolean limitInventorySize, String fold) {
        int MAX_ATTEMPTS = 50;
        Random rg = new Random(seed);
        IntRef attempts = IntRef.create(0);
        ObjectRef<String[]> goldPath = ObjectRef.create((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Breaks$.MODULE$.breakable(() -> {
            while (attempts$2.elem < MAX_ATTEMPTS) {
                KitchenGame game = this.mkGame(seed, numLocations, numDistractorItems, numIngredients, includeDoors, limitInventorySize, fold);
                KitchenGoldAgent goldAgent = new KitchenGoldAgent(game);
                Tuple2<Object, String[]> tuple2 = goldAgent.mkGoldPath(rg);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean success = tuple2._1$mcZ$sp();
                String[] _goldPath = tuple2._2();
                Tuple2<Boolean, String[]> tuple22 = new Tuple2<Boolean, String[]>(BoxesRunTime.boxToBoolean(success), _goldPath);
                Tuple2<Boolean, String[]> tuple23 = tuple22;
                boolean success2 = tuple23._1$mcZ$sp();
                String[] _goldPath2 = tuple23._2();
                if (success2) {
                    goldPath$1.elem = _goldPath2;
                }
                if (success2) {
                    throw Breaks$.MODULE$.break();
                }
                ++attempts$2.elem;
            }
            Predef$.MODULE$.println(new java.lang.StringBuilder(91).append("ERROR: Unknown error: Gold path could not be generated after maximum number of attempts (").append(MAX_ATTEMPTS).append(").").toString());
        });
        KitchenGame game = this.mkGame(seed, numLocations, numDistractorItems, numIngredients, includeDoors, limitInventorySize, fold);
        return new Tuple2<KitchenGame, String[]>(game, (String[])goldPath.elem);
    }

    public int mkGameWithGoldPath$default$2() {
        return 12;
    }

    public int mkGameWithGoldPath$default$3() {
        return 10;
    }

    public int mkGameWithGoldPath$default$4() {
        return 3;
    }

    public boolean mkGameWithGoldPath$default$5() {
        return true;
    }

    public boolean mkGameWithGoldPath$default$6() {
        return true;
    }

    public String mkGameWithGoldPath$default$7() {
        return "train";
    }

    public static final /* synthetic */ void $anonfun$mkEnvironment$2(FastObject cookbook$1, FastObject obj) {
        String string = obj.name();
        String string2 = "counter";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            obj.addObject(cookbook$1);
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ Object $anonfun$mkCookbook$2(ArrayBuffer recipeIngredients$1, StringBuilder os$2, int i) {
        Serializable serializable = ((RecipeIngredient)recipeIngredients$1.apply(i)).preparation().contains("chopped") ? os$2.append(new java.lang.StringBuilder(12).append("  chop the ").append(((RecipeIngredient)recipeIngredients$1.apply(i)).name()).append("\n").toString()) : BoxedUnit.UNIT;
        Serializable serializable2 = ((RecipeIngredient)recipeIngredients$1.apply(i)).preparation().contains("sliced") ? os$2.append(new java.lang.StringBuilder(13).append("  slice the ").append(((RecipeIngredient)recipeIngredients$1.apply(i)).name()).append("\n").toString()) : BoxedUnit.UNIT;
        Serializable serializable3 = ((RecipeIngredient)recipeIngredients$1.apply(i)).preparation().contains("diced") ? os$2.append(new java.lang.StringBuilder(12).append("  dice the ").append(((RecipeIngredient)recipeIngredients$1.apply(i)).name()).append("\n").toString()) : BoxedUnit.UNIT;
        Serializable serializable4 = ((RecipeIngredient)recipeIngredients$1.apply(i)).preparation().contains("fried") ? os$2.append(new java.lang.StringBuilder(11).append("  fry the ").append(((RecipeIngredient)recipeIngredients$1.apply(i)).name()).append("\n").toString()) : BoxedUnit.UNIT;
        Serializable serializable5 = ((RecipeIngredient)recipeIngredients$1.apply(i)).preparation().contains("roasted") ? os$2.append(new java.lang.StringBuilder(13).append("  roast the ").append(((RecipeIngredient)recipeIngredients$1.apply(i)).name()).append("\n").toString()) : BoxedUnit.UNIT;
        return ((RecipeIngredient)recipeIngredients$1.apply(i)).preparation().contains("grilled") ? os$2.append(new java.lang.StringBuilder(16).append("  barbeque the ").append(((RecipeIngredient)recipeIngredients$1.apply(i)).name()).append("\n").toString()) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$addIngredientItems$1(Map allObjects$1, Room location) {
        ListBuffer<FastObject> objs = location.collectVisibleObjects(location.collectVisibleObjects$default$1());
        objs.foreach((Function1<FastObject, Object> & Serializable)obj -> {
            allObjects$1.update(obj.name(), obj);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ StringBuilder $anonfun$displayMap$2(Room[][] map$2, int i$2, StringBuilder os$3, int j) {
        String cellStr = "--";
        Room cell = map$2[i$2][j];
        if (cell != null) {
            cellStr = cell.name();
        }
        return os$3.append(new java.lang.StringBuilder(1).append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(cellStr), "%20s")).append(" ").toString());
    }

    public static final /* synthetic */ StringBuilder $anonfun$displayMap$1(Room[][] map$2, StringBuilder os$3, int i) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(map$2[i]))).foreach((Function1<Object, StringBuilder> & Serializable)j -> KitchenGameGenerator.$anonfun$displayMap$2(map$2, i, os$3, BoxesRunTime.unboxToInt(j)));
        return os$3.append("\n");
    }

    public static final /* synthetic */ Object $anonfun$displayMap$4(Room[][] map$2, int i$3, StringBuilder os$3, int j) {
        Serializable serializable;
        Room cell = map$2[i$3][j];
        if (cell != null) {
            Serializable serializable2 = cell.locationNorth() != null ? os$3.append(new java.lang.StringBuilder(4).append(cell.name()).append("-> ").append(cell.locationNorth().name()).append("\n").toString()) : BoxedUnit.UNIT;
            Serializable serializable3 = cell.locationSouth() != null ? os$3.append(new java.lang.StringBuilder(4).append(cell.name()).append("-> ").append(cell.locationSouth().name()).append("\n").toString()) : BoxedUnit.UNIT;
            Serializable serializable4 = cell.locationEast() != null ? os$3.append(new java.lang.StringBuilder(4).append(cell.name()).append("-> ").append(cell.locationEast().name()).append("\n").toString()) : BoxedUnit.UNIT;
            serializable = cell.locationWest() != null ? os$3.append(new java.lang.StringBuilder(4).append(cell.name()).append("-> ").append(cell.locationWest().name()).append("\n").toString()) : BoxedUnit.UNIT;
        } else {
            serializable = BoxedUnit.UNIT;
        }
        return serializable;
    }
}

