/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.games;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$StringFormat$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.collection.ArrayOps$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;
import scala.util.control.Breaks$;
import textworldexpress.data.LoadTWCDataJSON;
import textworldexpress.data.LoadTWCDataJSON$;
import textworldexpress.data.LoadTWKitchenDataJSON;
import textworldexpress.data.LoadTWKitchenDataJSON$;
import textworldexpress.games.CoinGame;
import textworldexpress.games.CoinGame$;
import textworldexpress.goldagent.CoinGoldAgent;
import textworldexpress.objects.Backyard;
import textworldexpress.objects.Bathroom;
import textworldexpress.objects.Bedroom;
import textworldexpress.objects.Coin;
import textworldexpress.objects.Corridor;
import textworldexpress.objects.Door;
import textworldexpress.objects.DoorMaker;
import textworldexpress.objects.Driveway;
import textworldexpress.objects.FastObject;
import textworldexpress.objects.Kitchen;
import textworldexpress.objects.LaundryRoom;
import textworldexpress.objects.LivingRoom;
import textworldexpress.objects.Pantry;
import textworldexpress.objects.Room;
import textworldexpress.objects.Street;
import textworldexpress.objects.Supermarket;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0011\u0019I\u0004\u0001)A\u0005m!9!\b\u0001b\u0001\n\u0003Y\u0004B\u0002\"\u0001A\u0003%A\bC\u0003D\u0001\u0011\u0005A\tC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011%\t9\u0007AI\u0001\n\u0003\tI\u0007C\u0005\u0002\u0000\u0001\t\n\u0011\"\u0001\u0002j!I\u0011\u0011\u0011\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u0003\u000f\u0003\u0011\u0013!C\u0001\u0003\u0007C\u0011\"!#\u0001#\u0003%\t!a#\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"I\u00111\u0015\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0003K\u0003\u0011\u0013!C\u0001\u0003SB\u0011\"a*\u0001#\u0003%\t!a!\t\u0013\u0005%\u0006!%A\u0005\u0002\u0005\r\u0005\"CAV\u0001E\u0005I\u0011AAF\u0005E\u0019u.\u001b8HC6,w)\u001a8fe\u0006$xN\u001d\u0006\u00039u\tQaZ1nKNT\u0011AH\u0001\u0011i\u0016DHo^8sY\u0012,\u0007\u0010\u001d:fgN\u001c\u0001a\u0005\u0002\u0001CA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0015\u0011\u0005)\u0002Q\"A\u000e\u0002#Q;6i\u00142kK\u000e$H)\u0019;bE\u0006\u001cX-F\u0001.!\tq\u0013'D\u00010\u0015\t\u0001T$\u0001\u0003eCR\f\u0017B\u0001\u001a0\u0005=au.\u00193U/\u000e#\u0015\r^1K'>s\u0015A\u0005+X\u0007>\u0013'.Z2u\t\u0006$\u0018MY1tK\u0002\nq\u0003V,LSR\u001c\u0007.\u001a8PE*,7\r\u001e#bi\u0006\u0014\u0017m]3\u0016\u0003Y\u0002\"AL\u001c\n\u0005az#!\u0006'pC\u0012$vkS5uG\",g\u000eR1uC*\u001bvJT\u0001\u0019)^[\u0015\u000e^2iK:|%M[3di\u0012\u000bG/\u00192bg\u0016\u0004\u0013!\u00033p_Jl\u0015m[3s+\u0005a\u0004CA\u001fA\u001b\u0005q$BA \u001e\u0003\u001dy'M[3diNL!!\u0011 \u0003\u0013\u0011{wN]'bW\u0016\u0014\u0018A\u00033p_Jl\u0015m[3sA\u0005iQn[#om&\u0014xN\\7f]R$b!R,`I\u001a\\\u0007\u0003\u0002\u0012G\u0011NK!aR\u0012\u0003\rQ+\b\u000f\\33!\rIe\nU\u0007\u0002\u0015*\u00111\nT\u0001\b[V$\u0018M\u00197f\u0015\ti5%\u0001\u0006d_2dWm\u0019;j_:L!a\u0014&\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003{EK!A\u0015 \u0003\tI{w.\u001c\t\u0004\u0013:#\u0006CA\u001fV\u0013\t1fH\u0001\u0006GCN$xJ\u00196fGRDQ\u0001\u0017\u0005A\u0002e\u000b\u0011A\u001d\t\u00035vk\u0011a\u0017\u0006\u00039\u000e\nA!\u001e;jY&\u0011al\u0017\u0002\u0007%\u0006tGm\\7\t\u000b\u0001D\u0001\u0019A1\u0002\u00199,X\u000eT8dCRLwN\\:\u0011\u0005\t\u0012\u0017BA2$\u0005\rIe\u000e\u001e\u0005\u0006K\"\u0001\r!Y\u0001\u0013]VlG)[:ue\u0006\u001cGo\u001c:Ji\u0016l7\u000fC\u0003h\u0011\u0001\u0007\u0001.\u0001\u0007j]\u000edW\u000fZ3E_>\u00148\u000f\u0005\u0002#S&\u0011!n\t\u0002\b\u0005>|G.Z1o\u0011\u0015a\u0007\u00021\u0001n\u0003\u00111w\u000e\u001c3\u0011\u00059,hBA8t!\t\u00018%D\u0001r\u0015\t\u0011x$\u0001\u0004=e>|GOP\u0005\u0003i\u000e\na\u0001\u0015:fI\u00164\u0017B\u0001<x\u0005\u0019\u0019FO]5oO*\u0011AoI\u0001\u0013C\u0012$G)[:ue\u0006\u001cGo\u001c:Ji\u0016l7\u000f\u0006\u0005{wrt\u0018\u0011AA\u0003!\rIe*\u001c\u0005\u00061&\u0001\r!\u0017\u0005\u0006{&\u0001\r\u0001S\u0001\nY>\u001c\u0017\r^5p]NDQa`\u0005A\u0002\u0005\f\u0001B\\;n)>\fE\r\u001a\u0005\u0007\u0003\u0007I\u0001\u0019A*\u0002\u0017Q\f7o[(cU\u0016\u001cGo\u001d\u0005\u0006Y&\u0001\r!\\\u0001\u0014G>tg.Z2u%>|Wn\u001d$s_6l\u0015\r\u001d\u000b\t\u0003\u0017\t\t\"a\u0005\u0002 A\u0019!%!\u0004\n\u0007\u0005=1E\u0001\u0003V]&$\b\"\u0002-\u000b\u0001\u0004I\u0006bBA\u000b\u0015\u0001\u0007\u0011qC\u0001\u0004[\u0006\u0004\b#\u0002\u0012\u0002\u001a\u0005u\u0011bAA\u000eG\t)\u0011I\u001d:bsB!!%!\u0007Q\u0011\u00159'\u00021\u0001i\u0003)!\u0017n\u001d9mCfl\u0015\r\u001d\u000b\u0004[\u0006\u0015\u0002bBA\u000b\u0017\u0001\u0007\u0011qC\u0001\u0013M&tG-R7qif$\u0015N]3di&|g\u000e\u0006\u0006\u0002,\u00055\u0012qFA\u0019\u0003k\u0001BA\t$bC\")\u0001\f\u0004a\u00013\"9\u0011Q\u0003\u0007A\u0002\u0005]\u0001BBA\u001a\u0019\u0001\u0007\u0011-\u0001\u0003m_\u000eD\u0006BBA\u001c\u0019\u0001\u0007\u0011-\u0001\u0003m_\u000eL\u0016!D7l\u0007>tg.Z2uS>t7\u000f\u0006\u0004\u0002>\u0005\r\u0013Q\t\t\u0006E\u0005}\u0012qC\u0005\u0004\u0003\u0003\u001a#AB(qi&|g\u000eC\u0003Y\u001b\u0001\u0007\u0011\fC\u0003~\u001b\u0001\u0007\u0001*\u0001\u0004nW\u001e\u000bW.\u001a\u000b\u000f\u0003\u0017\n\t&a\u0017\u0002^\u0005}\u0013\u0011MA3!\rQ\u0013QJ\u0005\u0004\u0003\u001fZ\"\u0001C\"pS:<\u0015-\\3\t\u000f\u0005Mc\u00021\u0001\u0002V\u0005!1/Z3e!\r\u0011\u0013qK\u0005\u0004\u00033\u001a#\u0001\u0002'p]\u001eDq\u0001\u0019\b\u0011\u0002\u0003\u0007\u0011\rC\u0004f\u001dA\u0005\t\u0019A1\t\u000f\u001dt\u0001\u0013!a\u0001Q\"A\u00111\r\b\u0011\u0002\u0003\u0007\u0001.\u0001\nmS6LG/\u00138wK:$xN]=TSj,\u0007b\u00027\u000f!\u0003\u0005\r!\\\u0001\u0011[.<\u0015-\\3%I\u00164\u0017-\u001e7uII*\"!a\u001b+\u0007\u0005\fig\u000b\u0002\u0002pA!\u0011\u0011OA>\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014!C;oG\",7m[3e\u0015\r\tIhI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA?\u0003g\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Ai7nR1nK\u0012\"WMZ1vYR$3'\u0001\tnW\u001e\u000bW.\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011Q\u0011\u0016\u0004Q\u00065\u0014\u0001E7l\u000f\u0006lW\r\n3fM\u0006,H\u000e\u001e\u00136\u0003Ai7nR1nK\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\u000e*\u001aQ.!\u001c\u0002%5\\w)Y7f/&$\bnR8mIB\u000bG\u000f\u001b\u000b\u000f\u0003'\u000b9*!'\u0002\u001c\u0006u\u0015qTAQ!\u0019\u0011c)a\u0013\u0002\u0016B!!%!\u0007n\u0011\u001d\t\u0019\u0006\u0006a\u0001\u0003+Bq\u0001\u0019\u000b\u0011\u0002\u0003\u0007\u0011\rC\u0004f)A\u0005\t\u0019A1\t\u000f\u001d$\u0002\u0013!a\u0001Q\"A\u00111\r\u000b\u0011\u0002\u0003\u0007\u0001\u000eC\u0004m)A\u0005\t\u0019A7\u000295\\w)Y7f/&$\bnR8mIB\u000bG\u000f\u001b\u0013eK\u001a\fW\u000f\u001c;%e\u0005aRn[$b[\u0016<\u0016\u000e\u001e5H_2$\u0007+\u0019;iI\u0011,g-Y;mi\u0012\u001a\u0014\u0001H7l\u000f\u0006lWmV5uQ\u001e{G\u000e\u001a)bi\"$C-\u001a4bk2$H\u0005N\u0001\u001d[.<\u0015-\\3XSRDwi\u001c7e!\u0006$\b\u000e\n3fM\u0006,H\u000e\u001e\u00136\u0003qi7nR1nK^KG\u000f[$pY\u0012\u0004\u0016\r\u001e5%I\u00164\u0017-\u001e7uIY\u0002")
public class CoinGameGenerator {
    private final LoadTWCDataJSON TWCObjectDatabase = new LoadTWCDataJSON(LoadTWCDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final LoadTWKitchenDataJSON TWKitchenObjectDatabase = new LoadTWKitchenDataJSON(LoadTWKitchenDataJSON$.MODULE$.$lessinit$greater$default$1());
    private final DoorMaker doorMaker = new DoorMaker();

    public LoadTWCDataJSON TWCObjectDatabase() {
        return this.TWCObjectDatabase;
    }

    public LoadTWKitchenDataJSON TWKitchenObjectDatabase() {
        return this.TWKitchenObjectDatabase;
    }

    public DoorMaker doorMaker() {
        return this.doorMaker;
    }

    public Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> mkEnvironment(Random r, int numLocations, int numDistractorItems, boolean includeDoors, String fold) {
        ArrayBuffer<Room> locations = new ArrayBuffer<Room>();
        Kitchen kitchen = new Kitchen(r, false);
        locations.append(kitchen);
        Object object = numLocations >= 2 ? locations.append(new Pantry(r)) : BoxedUnit.UNIT;
        Object object2 = numLocations >= 3 ? locations.append(new Corridor(r)) : BoxedUnit.UNIT;
        Object object3 = numLocations >= 4 ? locations.append(new Bedroom(r)) : BoxedUnit.UNIT;
        Object object4 = numLocations >= 5 ? locations.append(new Backyard(r)) : BoxedUnit.UNIT;
        Object object5 = numLocations >= 6 ? locations.append(new LivingRoom(r)) : BoxedUnit.UNIT;
        Object object6 = numLocations >= 7 ? locations.append(new Bathroom(r)) : BoxedUnit.UNIT;
        Object object7 = numLocations >= 8 ? locations.append(new LaundryRoom(r)) : BoxedUnit.UNIT;
        Object object8 = numLocations >= 9 ? locations.append(new Driveway(r)) : BoxedUnit.UNIT;
        Object object9 = numLocations >= 10 ? locations.append(new Street(r)) : BoxedUnit.UNIT;
        Object object10 = numLocations >= 11 ? locations.append(new Supermarket(r)) : BoxedUnit.UNIT;
        Option map = None$.MODULE$;
        for (int attempts = 0; map.isEmpty() && attempts < 50; ++attempts) {
            map = this.mkConnections(r, locations);
        }
        if (map.isEmpty()) {
            throw new RuntimeException("ERROR: Could not generate connection map");
        }
        this.connectRoomsFromMap(r, (Room[][])((Option)map).get(), includeDoors);
        int randomLocationIdx = r.nextInt(locations.length());
        Coin coin = new Coin();
        ((FastObject)locations.apply(randomLocationIdx)).addObject(coin);
        ArrayBuffer<Coin> taskObjects = new ArrayBuffer<Coin>();
        taskObjects.append(coin);
        ArrayBuffer<String> addedDistractorNames = this.addDistractorItems(r, locations, numDistractorItems, (ArrayBuffer<FastObject>)ArrayBuffer$.MODULE$.empty(), fold);
        return new Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>>(locations, taskObjects);
    }

    public ArrayBuffer<String> addDistractorItems(Random r, ArrayBuffer<Room> locations, int numToAdd, ArrayBuffer<FastObject> taskObjects, String fold) {
        ArrayBuffer<String> objectNamesAdded = new ArrayBuffer<String>();
        taskObjects.foreach((Function1<FastObject, ArrayBuffer> & Serializable)taskObject -> (ArrayBuffer)objectNamesAdded.append(taskObject.name()));
        for (int attempts = 0; objectNamesAdded.length() < numToAdd + taskObjects.length() && attempts < 100; ++attempts) {
            Object object;
            int randLocIdx = r.nextInt(locations.length());
            Room location = locations.apply(randLocIdx);
            FastObject[] objects = (FastObject[])location.contents().toArray(ClassTag$.MODULE$.apply(FastObject.class));
            if (objects.length > 0) {
                int randObjIdx = r.nextInt(objects.length);
                FastObject container = objects[randObjIdx];
                Option<FastObject> distractorItem = this.TWCObjectDatabase().mkRandomObjectByLocation(r, container.name(), fold);
                if (distractorItem.isDefined()) {
                    if (!objectNamesAdded.contains(distractorItem.get().name())) {
                        container.addObject(distractorItem.get());
                        object = objectNamesAdded.append(distractorItem.get().name());
                        continue;
                    }
                    object = BoxedUnit.UNIT;
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            object = BoxedUnit.UNIT;
        }
        return objectNamesAdded;
    }

    public void connectRoomsFromMap(Random r, Room[][] map, boolean includeDoors) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), map.length).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), map[i].length).foreach$mVc$sp(j -> {
            block8: {
                Room queryLoc;
                Room queryLoc2;
                Room queryLoc3;
                Room queryLoc4;
                Room cell = map[i][j];
                if (cell == null) break block8;
                if (i < map.length - 1 && (queryLoc4 = map[i + 1][j]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc4.name())) {
                    Option<Door> door;
                    cell.locationNorth_$eq(queryLoc4);
                    queryLoc4.locationSouth_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc4.name(), false)).isDefined()) {
                        cell.doorNorth_$eq(door.get());
                        queryLoc4.doorSouth_$eq(door.get());
                    }
                }
                if (i >= 1 && (queryLoc3 = map[i - 1][j]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc3.name())) {
                    Option<Door> door;
                    cell.locationSouth_$eq(queryLoc3);
                    queryLoc3.locationNorth_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc3.name(), false)).isDefined()) {
                        cell.doorSouth_$eq(door.get());
                        queryLoc3.doorNorth_$eq(door.get());
                    }
                }
                if (j >= 1 && (queryLoc2 = map[i][j - 1]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc2.name())) {
                    Option<Door> door;
                    cell.locationEast_$eq(queryLoc2);
                    queryLoc2.locationWest_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc2.name(), false)).isDefined()) {
                        cell.doorEast_$eq(door.get());
                        queryLoc2.doorWest_$eq(door.get());
                    }
                }
                if (j < map[i].length - 1 && (queryLoc = map[i][j + 1]) != null && ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(cell.prefersConnectingTo()), queryLoc.name())) {
                    Option<Door> door;
                    cell.locationWest_$eq(queryLoc);
                    queryLoc.locationEast_$eq(cell);
                    if (includeDoors && (door = this.doorMaker().mkDoor(r, cell.name(), queryLoc.name(), false)).isDefined()) {
                        cell.doorWest_$eq(door.get());
                        queryLoc.doorEast_$eq(door.get());
                    }
                }
            }
        }));
    }

    public String displayMap(Room[][] map) {
        StringBuilder os = new StringBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])map))).foreach((Function1<Object, StringBuilder> & Serializable)i -> CoinGameGenerator.$anonfun$displayMap$1(map, os, BoxesRunTime.unboxToInt(i)));
        return os.toString();
    }

    public Tuple2<Object, Object> findEmptyDirection(Random r, Room[][] map, int locX, int locY) {
        Object object = new Object();
        try {
            ArrayBuffer orderToCheck = (ArrayBuffer)r.shuffle((IterableOnce)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), BuildFrom$.MODULE$.buildFromIterableOps());
            orderToCheck.foreach(directionRef -> {
                if (directionRef == 0) {
                    if (locX - 1 >= 0 && map[locX - 1][locY] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX - 1, locY));
                    }
                } else if (directionRef == 1) {
                    if (locX + 1 < map.length && map[locX + 1][locY] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX + 1, locY));
                    }
                } else if (directionRef == 2) {
                    if (locY - 1 >= 0 && map[locX][locY - 1] == null) {
                        throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX, locY - 1));
                    }
                } else if (directionRef == 3 && locY + 1 < map.length && map[locX][locY + 1] == null) {
                    throw new NonLocalReturnControl<Tuple2$mcII$sp>(object, new Tuple2$mcII$sp(locX, locY + 1));
                }
            });
            return new Tuple2$mcII$sp(-1, -1);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (Tuple2)ex.value();
        }
    }

    public Option<Room[][]> mkConnections(Random r, ArrayBuffer<Room> locations) {
        int GRID_SIZE = 7;
        Room[][] map = (Room[][])Array$.MODULE$.ofDim(GRID_SIZE, GRID_SIZE, ClassTag$.MODULE$.apply(Room.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), GRID_SIZE).foreach$mVc$sp(i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), GRID_SIZE).foreach$mVc$sp(j -> {
            map$4[i$3][j] = null;
        }));
        ArrayBuffer locationsLeft = new ArrayBuffer();
        locationsLeft.insertAll(0, (IterableOnce)r.shuffle(locations, BuildFrom$.MODULE$.buildFromIterableOps()));
        IntRef lastX = IntRef.create(3);
        IntRef lastY = IntRef.create(3);
        map[lastX.elem][lastY.elem] = (Room)locationsLeft.last();
        locationsLeft.remove(locationsLeft.size() - 1);
        ObjectRef<Room> lastLocation = ObjectRef.create(map[lastX.elem][lastY.elem]);
        IntRef attempts = IntRef.create(0);
        ArrayBuffer<Tuple2$mcII$sp> populatedLocations = new ArrayBuffer<Tuple2$mcII$sp>();
        populatedLocations.append(new Tuple2$mcII$sp(lastX.elem, lastY.elem));
        Breaks$.MODULE$.breakable(() -> {
            while (locationsLeft.length() > 0) {
                Object object;
                int refIdx = r.nextInt(populatedLocations.length());
                lastX$1.elem = ((Tuple2)populatedLocations.apply(refIdx))._1$mcI$sp();
                lastY$1.elem = ((Tuple2)populatedLocations.apply(refIdx))._2$mcI$sp();
                lastLocation$1.elem = map[lastX$1.elem][lastY$1.elem];
                int locationIdx = r.nextInt(locationsLeft.length());
                Room location = (Room)locationsLeft.apply(locationIdx);
                if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(location.prefersConnectingTo()), ((Room)lastLocation$1.elem).name())) {
                    Tuple2<Object, Object> tuple2 = this.findEmptyDirection(r, map, lastX$1.elem, lastY$1.elem);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    int newX = tuple2._1$mcI$sp();
                    int newY = tuple2._2$mcI$sp();
                    Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(newX, newY);
                    Tuple2$mcII$sp tuple2$mcII$sp2 = tuple2$mcII$sp;
                    int newX2 = ((Tuple2)tuple2$mcII$sp2)._1$mcI$sp();
                    int newY2 = ((Tuple2)tuple2$mcII$sp2)._2$mcI$sp();
                    if (newX2 != -1) {
                        map$4[newX2][newY2] = location;
                        locationsLeft.remove(locationIdx);
                        object = populatedLocations.append(new Tuple2$mcII$sp(newX2, newY2));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                ++attempts$1.elem;
                if (attempts$1.elem <= 100) continue;
                throw Breaks$.MODULE$.break();
            }
        });
        if (locationsLeft.length() > 0) {
            return None$.MODULE$;
        }
        return new Some<Room[][]>(map);
    }

    public CoinGame mkGame(long seed, int numLocations, int numDistractorItems, boolean includeDoors, boolean limitInventorySize, String fold) {
        Integer n;
        Map props = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        props.update("seed", BoxesRunTime.boxToInteger((int)seed));
        props.update("numLocations", BoxesRunTime.boxToInteger(numLocations));
        props.update("numDistractorItems", BoxesRunTime.boxToInteger(numDistractorItems));
        props.update("includeDoors", includeDoors ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0));
        props.update("limitInventorySize", limitInventorySize ? BoxesRunTime.boxToInteger(1) : BoxesRunTime.boxToInteger(0));
        String string = fold;
        String string2 = "train";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            n = BoxesRunTime.boxToInteger(1);
        } else {
            String string3 = fold;
            String string4 = "dev";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                n = BoxesRunTime.boxToInteger(2);
            } else {
                String string5 = fold;
                String string6 = "test";
                n = !(string5 != null ? !string5.equals(string6) : string6 != null) ? BoxesRunTime.boxToInteger(3) : BoxesRunTime.boxToInteger(-1);
            }
        }
        props.update("gameSet", n);
        Random r = new Random(seed);
        Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> tuple2 = this.mkEnvironment(r, numLocations, numDistractorItems, includeDoors, fold);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ArrayBuffer<Room> locations = tuple2._1();
        ArrayBuffer<FastObject> taskObjects = tuple2._2();
        Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> tuple22 = new Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>>(locations, taskObjects);
        Tuple2<ArrayBuffer<Room>, ArrayBuffer<FastObject>> tuple23 = tuple22;
        ArrayBuffer<Room> locations2 = tuple23._1();
        ArrayBuffer<FastObject> taskObjects2 = tuple23._2();
        Room[] x$1 = (Room[])locations2.toArray(ClassTag$.MODULE$.apply(Room.class));
        ArrayBuffer<FastObject> x$2 = taskObjects2;
        boolean x$3 = limitInventorySize;
        scala.collection.immutable.Map<String, Object> x$4 = props.toMap($less$colon$less$.MODULE$.refl());
        long x$5 = CoinGame$.MODULE$.$lessinit$greater$default$4();
        CoinGame game = new CoinGame(x$1, x$2, x$3, x$5, x$4);
        return game;
    }

    public int mkGame$default$2() {
        return 12;
    }

    public int mkGame$default$3() {
        return 0;
    }

    public boolean mkGame$default$4() {
        return false;
    }

    public boolean mkGame$default$5() {
        return false;
    }

    public String mkGame$default$6() {
        return "train";
    }

    public Tuple2<CoinGame, String[]> mkGameWithGoldPath(long seed, int numLocations, int numDistractorItems, boolean includeDoors, boolean limitInventorySize, String fold) {
        int MAX_ATTEMPTS = 50;
        Random rg = new Random();
        IntRef attempts = IntRef.create(0);
        ObjectRef<String[]> goldPath = ObjectRef.create((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        Breaks$.MODULE$.breakable(() -> {
            while (attempts$2.elem < MAX_ATTEMPTS) {
                CoinGame game = this.mkGame(seed, numLocations, numDistractorItems, includeDoors, limitInventorySize, fold);
                CoinGoldAgent goldAgent = new CoinGoldAgent(game);
                Tuple2<Object, String[]> tuple2 = goldAgent.mkGoldPath(rg);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean success = tuple2._1$mcZ$sp();
                String[] _goldPath = tuple2._2();
                Tuple2<Boolean, String[]> tuple22 = new Tuple2<Boolean, String[]>(BoxesRunTime.boxToBoolean(success), _goldPath);
                Tuple2<Boolean, String[]> tuple23 = tuple22;
                boolean success2 = tuple23._1$mcZ$sp();
                String[] _goldPath2 = tuple23._2();
                if (success2) {
                    goldPath$1.elem = _goldPath2;
                }
                if (success2) {
                    throw Breaks$.MODULE$.break();
                }
                ++attempts$2.elem;
            }
            Predef$.MODULE$.println(new java.lang.StringBuilder(91).append("ERROR: Unknown error: Gold path could not be generated after maximum number of attempts (").append(MAX_ATTEMPTS).append(").").toString());
        });
        CoinGame game = this.mkGame(seed, numLocations, numDistractorItems, includeDoors, limitInventorySize, this.mkGame$default$6());
        return new Tuple2<CoinGame, String[]>(game, (String[])goldPath.elem);
    }

    public int mkGameWithGoldPath$default$2() {
        return 12;
    }

    public int mkGameWithGoldPath$default$3() {
        return 10;
    }

    public boolean mkGameWithGoldPath$default$4() {
        return true;
    }

    public boolean mkGameWithGoldPath$default$5() {
        return true;
    }

    public String mkGameWithGoldPath$default$6() {
        return "train";
    }

    public static final /* synthetic */ StringBuilder $anonfun$displayMap$2(Room[][] map$2, int i$2, StringBuilder os$2, int j) {
        String cellStr = "--";
        Room cell = map$2[i$2][j];
        if (cell != null) {
            cellStr = cell.name();
        }
        return os$2.append(new java.lang.StringBuilder(1).append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(cellStr), "%20s")).append(" ").toString());
    }

    public static final /* synthetic */ StringBuilder $anonfun$displayMap$1(Room[][] map$2, StringBuilder os$2, int i) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(map$2[i]))).foreach((Function1<Object, StringBuilder> & Serializable)j -> CoinGameGenerator.$anonfun$displayMap$2(map$2, i, os$2, BoxesRunTime.unboxToInt(j)));
        return os$2.append("\n");
    }
}

