/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.benchmark;

import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random$;
import scala.util.control.Breaks$;
import textworldexpress.benchmark.RandomAgentThreadRunner$;
import textworldexpress.pathcrawler.PrecrawledNode;
import textworldexpress.pathcrawler.PrecrawledPath;
import textworldexpress.pathcrawler.StepResultHashed;
import textworldexpress.struct.StepResult;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\u0011#\u0001\u001dB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!A\u0011\t\u0001B\u0001B\u0003%\u0011\u0007C\u0003C\u0001\u0011\u00051\tC\u0004J\u0001\u0001\u0007I\u0011\u0002&\t\u000f9\u0003\u0001\u0019!C\u0005\u001f\"1Q\u000b\u0001Q!\n-CqA\u0016\u0001A\u0002\u0013%!\nC\u0004X\u0001\u0001\u0007I\u0011\u0002-\t\ri\u0003\u0001\u0015)\u0003L\u0011\u001dY\u0006\u00011A\u0005\n)Cq\u0001\u0018\u0001A\u0002\u0013%Q\f\u0003\u0004`\u0001\u0001\u0006Ka\u0013\u0005\bA\u0002\u0011\r\u0011\"\u0003K\u0011\u0019\t\u0007\u0001)A\u0005\u0017\"9!\r\u0001a\u0001\n\u0013\u0019\u0007bB4\u0001\u0001\u0004%I\u0001\u001b\u0005\u0007U\u0002\u0001\u000b\u0015\u00023\t\u000f-\u0004\u0001\u0019!C\u0005Y\"9Q\u000e\u0001a\u0001\n\u0013q\u0007B\u00029\u0001A\u0003&\u0011\u0007C\u0003r\u0001\u0011\u0005!\u000fC\u0003t\u0001\u0011\u0005A\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0003z\u0001\u0011%!\u0010C\u0005\u0002\u0004\u0001\t\n\u0011\"\u0003\u0002\u0006!I\u00111\u0004\u0001\u0012\u0002\u0013%\u0011QD\u0004\n\u0003C\u0011\u0013\u0011!E\u0001\u0003G1\u0001\"\t\u0012\u0002\u0002#\u0005\u0011Q\u0005\u0005\u0007\u0005z!\t!!\f\t\u0013\u0005=b$%A\u0005\u0002\u0005\u0015!a\u0006*b]\u0012|W.Q4f]R$\u0006N]3bIJ+hN\\3s\u0015\t\u0019C%A\u0005cK:\u001c\u0007.\\1sW*\tQ%\u0001\tuKb$xo\u001c:mI\u0016D\bO]3tg\u000e\u00011C\u0001\u0001)!\tIc&D\u0001+\u0015\tYC&\u0001\u0003mC:<'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u0012a\u0001\u00165sK\u0006$\u0017AA5e!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\rIe\u000e^\u0001\u0010aJ,7M]1xY\u0016$\u0007+\u0019;igB\u0019!'O\u001e\n\u0005i\u001a$!B!se\u0006L\bC\u0001\u001f@\u001b\u0005i$B\u0001 %\u0003-\u0001\u0018\r\u001e5de\u0006<H.\u001a:\n\u0005\u0001k$A\u0004)sK\u000e\u0014\u0018m\u001e7fIB\u000bG\u000f[\u0001\u0011]VlW\t]5t_\u0012,7\u000fV8Sk:\fa\u0001P5oSRtD\u0003\u0002#G\u000f\"\u0003\"!\u0012\u0001\u000e\u0003\tBQ\u0001\r\u0003A\u0002EBQa\u000e\u0003A\u0002aBq!\u0011\u0003\u0011\u0002\u0003\u0007\u0011'A\u0005jgJ+hN\\5oOV\t1\n\u0005\u00023\u0019&\u0011Qj\r\u0002\b\u0005>|G.Z1o\u00035I7OU;o]&twm\u0018\u0013fcR\u0011\u0001k\u0015\t\u0003eEK!AU\u001a\u0003\tUs\u0017\u000e\u001e\u0005\b)\u001a\t\t\u00111\u0001L\u0003\rAH%M\u0001\u000bSN\u0014VO\u001c8j]\u001e\u0004\u0013!C5t/&tg.\u001b8h\u00035I7oV5o]&twm\u0018\u0013fcR\u0011\u0001+\u0017\u0005\b)&\t\t\u00111\u0001L\u0003)I7oV5o]&tw\rI\u0001\fSN\u001cu.\u001c9mKR,G-A\bjg\u000e{W\u000e\u001d7fi\u0016$w\fJ3r)\t\u0001f\fC\u0004U\u0019\u0005\u0005\t\u0019A&\u0002\u0019%\u001c8i\\7qY\u0016$X\r\u001a\u0011\u0002%Y,'OY8tK\u0012+'-^4PkR\u0004X\u000f^\u0001\u0014m\u0016\u0014(m\\:f\t\u0016\u0014WoZ(viB,H\u000fI\u0001\u000bi>$\u0018\r\\*uKB\u001cX#\u00013\u0011\u0005I*\u0017B\u000144\u0005\u0011auN\\4\u0002\u001dQ|G/\u00197Ti\u0016\u00048o\u0018\u0013fcR\u0011\u0001+\u001b\u0005\b)F\t\t\u00111\u0001e\u0003-!x\u000e^1m'R,\u0007o\u001d\u0011\u0002\u001bQ|G/\u00197Fa&\u001cx\u000eZ3t+\u0005\t\u0014!\u0005;pi\u0006dW\t]5t_\u0012,7o\u0018\u0013fcR\u0011\u0001k\u001c\u0005\b)R\t\t\u00111\u00012\u00039!x\u000e^1m\u000bBL7o\u001c3fg\u0002\nq\"[:UQJ,\u0017\r\u001a*v]:Lgn\u001a\u000b\u0002\u0017\u0006\u0001r-\u001a;U_R\fGn\u0015;faN\u0014VO\u001c\u000b\u0002I\u0006\u0019r-\u001a;U_R\fG.\u00129jg>$Wm\u001d*v]R\t\u0011'A\u0002sk:$\u0012\u0001U\u0001\u0016e\u0006tGm\\7BO\u0016tG\u000f\u0015:fGJ\fw\u000f\\3e)\u0011\t40`@\t\u000bqT\u0002\u0019A\u001e\u0002\u001dA\u0014Xm\u0019:bo2,G\rU1uQ\"9aP\u0007I\u0001\u0002\u0004\t\u0014\u0001C7bqN#X\r]:\t\u0011\u0005\u0005!\u0004%AA\u0002-\u000bqA^3sE>\u001cX-A\u0010sC:$w.\\!hK:$\bK]3de\u0006<H.\u001a3%I\u00164\u0017-\u001e7uII*\"!a\u0002+\u0007E\nIa\u000b\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011!C;oG\",7m[3e\u0015\r\t)bM\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\r\u0003\u001f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003}\u0011\u0018M\u001c3p[\u0006;WM\u001c;Qe\u0016\u001c'/Y<mK\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0003?Q3aSA\u0005\u0003]\u0011\u0016M\u001c3p[\u0006;WM\u001c;UQJ,\u0017\r\u001a*v]:,'\u000f\u0005\u0002F=M\u0019a$a\n\u0011\u0007I\nI#C\u0002\u0002,M\u0012a!\u00118z%\u00164GCAA\u0012\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0001")
public class RandomAgentThreadRunner
extends Thread {
    private final PrecrawledPath[] precrawledPaths;
    private final int numEpisodesToRun;
    private boolean isRunning;
    private boolean isWinning;
    private boolean isCompleted;
    private final boolean verboseDebugOutput;
    private long totalSteps;
    private int totalEpisodes;

    public static int $lessinit$greater$default$3() {
        return RandomAgentThreadRunner$.MODULE$.$lessinit$greater$default$3();
    }

    private boolean isRunning() {
        return this.isRunning;
    }

    private void isRunning_$eq(boolean x$1) {
        this.isRunning = x$1;
    }

    private boolean isWinning() {
        return this.isWinning;
    }

    private void isWinning_$eq(boolean x$1) {
        this.isWinning = x$1;
    }

    private boolean isCompleted() {
        return this.isCompleted;
    }

    private void isCompleted_$eq(boolean x$1) {
        this.isCompleted = x$1;
    }

    private boolean verboseDebugOutput() {
        return this.verboseDebugOutput;
    }

    private long totalSteps() {
        return this.totalSteps;
    }

    private void totalSteps_$eq(long x$1) {
        this.totalSteps = x$1;
    }

    private int totalEpisodes() {
        return this.totalEpisodes;
    }

    private void totalEpisodes_$eq(int x$1) {
        this.totalEpisodes = x$1;
    }

    public boolean isThreadRunning() {
        return this.isRunning();
    }

    public long getTotalStepsRun() {
        return this.totalSteps();
    }

    public int getTotalEpisodesRun() {
        return this.totalEpisodes();
    }

    @Override
    public void run() {
        this.isRunning_$eq(true);
        if (this.verboseDebugOutput()) {
            Predef$.MODULE$.println(new StringBuilder(19).append("Thread ").append(Thread.currentThread().getName()).append(" is running.").toString());
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.numEpisodesToRun).foreach$mVc$sp(i -> {
            PrecrawledPath precrawledPath;
            PrecrawledPath x$1 = precrawledPath = $this.precrawledPaths[i % $this.precrawledPaths.length];
            boolean x$2 = false;
            int x$3 = this.randomAgentPrecrawled$default$2();
            this.totalSteps_$eq(this.totalSteps() + (long)this.randomAgentPrecrawled(x$1, x$3, false));
            this.totalEpisodes_$eq(this.totalEpisodes() + 1);
        });
        if (this.verboseDebugOutput()) {
            Predef$.MODULE$.println(new StringBuilder(21).append("Thread ").append(Thread.currentThread().getName()).append(" is completed.").toString());
        }
        this.isRunning_$eq(false);
        this.isCompleted_$eq(true);
    }

    private int randomAgentPrecrawled(PrecrawledPath precrawledPath, int maxSteps, boolean verbose) {
        ObjectRef<PrecrawledNode> curNode = ObjectRef.create(precrawledPath.getStartNode());
        IntRef curSteps = IntRef.create(0);
        Breaks$.MODULE$.breakable(() -> {
            while (curSteps$1.elem < maxSteps) {
                if (((PrecrawledNode)curNode$1.elem).steps().size() == 0) {
                    throw Breaks$.MODULE$.break();
                }
                StepResultHashed qual$1 = ((PrecrawledNode)curNode$1.elem).result();
                String[] x$1 = precrawledPath.stringLUT();
                int x$2 = qual$1.toStepResult$default$2();
                StepResult curNodeStrs = qual$1.toStepResult(x$1, x$2);
                String[] validActionsStrs = curNodeStrs.validActions();
                int randIdx = Random$.MODULE$.nextInt(validActionsStrs.length);
                String randomAction = validActionsStrs[randIdx];
                if (verbose) {
                    Predef$.MODULE$.println(((PrecrawledNode)curNode$1.elem).toString());
                    Predef$.MODULE$.println(new StringBuilder(5).append("Obs: ").append(curNodeStrs.observationStr()).toString());
                    Predef$.MODULE$.println(new StringBuilder(7).append("Score: ").append(curNodeStrs.scoreNormalized()).toString());
                    Predef$.MODULE$.println(new StringBuilder(15).append("Valid Actions: ").append(Predef$.MODULE$.wrapRefArray((Object[])validActionsStrs).mkString(", ")).toString());
                    Predef$.MODULE$.println(new StringBuilder(15).append("Random Action: ").append(randomAction).toString());
                    Predef$.MODULE$.println("");
                    Predef$.MODULE$.println("-------------------------------------------------------------");
                }
                int actionLUTIdx = BoxesRunTime.unboxToInt(precrawledPath.stringToIDXLUT().apply(randomAction));
                int nodeToMoveTo = BoxesRunTime.unboxToInt(((PrecrawledNode)curNode$1.elem).steps().apply(BoxesRunTime.boxToInteger(actionLUTIdx)));
                curNode$1.elem = precrawledPath.getNode(nodeToMoveTo);
                ++curSteps$1.elem;
            }
        });
        return curSteps.elem;
    }

    private int randomAgentPrecrawled$default$2() {
        return 50;
    }

    private boolean randomAgentPrecrawled$default$3() {
        return false;
    }

    public RandomAgentThreadRunner(int id, PrecrawledPath[] precrawledPaths, int numEpisodesToRun) {
        this.precrawledPaths = precrawledPaths;
        this.numEpisodesToRun = numEpisodesToRun;
        this.isRunning = false;
        this.isWinning = false;
        this.isCompleted = false;
        this.verboseDebugOutput = false;
        this.totalSteps = 0L;
        this.totalEpisodes = 0;
    }
}

