/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.benchmark;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Predef$StringFormat$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import textworldexpress.benchmark.RandomAgentThreadRunner;
import textworldexpress.pathcrawler.PrecrawledPath;
import textworldexpress.pathcrawler.PrecrawledPath$;

public final class BenchmarkPrecrawledPathThreaded$ {
    public static final BenchmarkPrecrawledPathThreaded$ MODULE$ = new BenchmarkPrecrawledPathThreaded$();

    public void printUsage() {
        Predef$.MODULE$.println("Usage: BenchmarkPrecrawledPathThreaded <numThreads>");
    }

    public void main(String[] args) {
        boolean verboseOutput = false;
        int numThreads = 32;
        int numEpsiodesToRun = 1000000;
        if (args.length == 0) {
            this.printUsage();
            Predef$.MODULE$.println("Missing argument defining number of threads to run.  Defaulting to 32.");
        } else if (args.length == 1) {
            try {
                numThreads = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[0]));
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println(new StringBuilder(66).append("Unable to parse (").append(args[0]).append(") into <numThreads> argument.  Expected integer. ").toString());
                this.printUsage();
            }
        } else {
            this.printUsage();
            throw scala.sys.package$.MODULE$.exit(1);
        }
        int numPerFold = 5;
        PrecrawledPath[] precrawledPaths = new PrecrawledPath[numPerFold];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPerFold).foreach$mVc$sp(i -> {
            PrecrawledPath precrawledPath;
            String path = "/home/peter/github/sciworld-synth/";
            String filename = new StringBuilder(115).append(path).append("savetest-gamecoin-var").append(i).append("-foldtrain-maxDepth10-includeDoors0-limitInventorySize0-numDistractorItems0-numLocations4.json").toString();
            precrawledPaths$1[i] = precrawledPath = PrecrawledPath$.MODULE$.loadFromJSON(filename).get();
        });
        Predef$.MODULE$.println("Starting Random Agents");
        long startTime = System.currentTimeMillis();
        LongRef totalSteps = LongRef.create(0L);
        IntRef totalEpisodes = IntRef.create(0);
        RandomAgentThreadRunner[] runners = new RandomAgentThreadRunner[numThreads];
        Predef$.MODULE$.println(new StringBuilder(21).append("Starting ").append(numThreads).append(" threads... ").toString());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp(i -> {
            runners$1[i] = new RandomAgentThreadRunner(i, precrawledPaths, numEpsiodesToRun);
            runners[i].start();
        });
        ObjectRef stillRunning = ObjectRef.create(new ArrayBuffer());
        ((ArrayBuffer)stillRunning.elem).append(BoxesRunTime.boxToInteger(-1));
        while (((ArrayBuffer)stillRunning.elem).length() > 0) {
            ((ArrayBuffer)stillRunning.elem).clear();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach((Function1<Object, Object> & Serializable)i -> BenchmarkPrecrawledPathThreaded$.$anonfun$main$3(runners, stillRunning, BoxesRunTime.unboxToInt(i)));
            Thread.sleep(250L);
            double deltaTime = (double)(System.currentTimeMillis() - startTime) / (double)1000;
            Predef$.MODULE$.println(new StringBuilder(30).append("(").append(package$.MODULE$.round(deltaTime)).append(" sec) Threads still running: ").append(((ArrayBuffer)stillRunning.elem).mkString(" ")).toString());
        }
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp(i -> {
            totalSteps$1.elem += runners[i].getTotalStepsRun();
            totalEpisodes$1.elem += runners[i].getTotalEpisodesRun();
        });
        double deltaTime = (double)(System.currentTimeMillis() - startTime) / (double)1000;
        Predef$.MODULE$.println(new StringBuilder(20).append("Number of threads : ").append(numThreads).toString());
        Predef$.MODULE$.println(new StringBuilder(20).append("Total Episodes    : ").append(totalEpisodes.elem).toString());
        Predef$.MODULE$.println(new StringBuilder(20).append("Total Steps       : ").append(totalSteps.elem).toString());
        Predef$.MODULE$.println(new StringBuilder(24).append("Total Time        : ").append(deltaTime).append(" sec").toString());
        double rate = (double)totalSteps.elem / deltaTime;
        Predef$.MODULE$.println(new StringBuilder(30).append("Rate              : ").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToDouble(rate)), "%3.3f")).append(" steps/sec").toString());
        double timeTo1BSteps = 1.0E9 / rate;
        Predef$.MODULE$.println(new StringBuilder(28).append("Time to 1B steps  : ").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToDouble(timeTo1BSteps)), "%3.3f")).append(" seconds").toString());
    }

    public static final /* synthetic */ Object $anonfun$main$3(RandomAgentThreadRunner[] runners$1, ObjectRef stillRunning$1, int i) {
        return runners$1[i].isThreadRunning() ? ((ArrayBuffer)stillRunning$1.elem).append(BoxesRunTime.boxToInteger(i)) : BoxedUnit.UNIT;
    }

    private BenchmarkPrecrawledPathThreaded$() {
    }
}

