/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.benchmark;

import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Predef$StringFormat$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random$;
import scala.util.control.Breaks$;
import textworldexpress.pathcrawler.PrecrawledNode;
import textworldexpress.pathcrawler.PrecrawledPath;
import textworldexpress.pathcrawler.PrecrawledPath$;
import textworldexpress.pathcrawler.StepResultHashed;
import textworldexpress.struct.StepResult;

public final class BenchmarkPrecrawledPath$ {
    public static final BenchmarkPrecrawledPath$ MODULE$ = new BenchmarkPrecrawledPath$();

    public int randomAgentPrecrawled(PrecrawledPath precrawledPath, int maxSteps, boolean verbose) {
        ObjectRef<PrecrawledNode> curNode = ObjectRef.create(precrawledPath.getStartNode());
        IntRef curSteps = IntRef.create(0);
        Breaks$.MODULE$.breakable(() -> {
            while (curSteps$1.elem < maxSteps) {
                if (((PrecrawledNode)curNode$1.elem).steps().size() == 0) {
                    throw Breaks$.MODULE$.break();
                }
                StepResultHashed qual$1 = ((PrecrawledNode)curNode$1.elem).result();
                String[] x$1 = precrawledPath.stringLUT();
                int x$2 = qual$1.toStepResult$default$2();
                StepResult curNodeStrs = qual$1.toStepResult(x$1, x$2);
                String[] validActionsStrs = curNodeStrs.validActions();
                int randIdx = Random$.MODULE$.nextInt(validActionsStrs.length);
                String randomAction = validActionsStrs[randIdx];
                if (verbose) {
                    Predef$.MODULE$.println(((PrecrawledNode)curNode$1.elem).toString());
                    Predef$.MODULE$.println(new StringBuilder(5).append("Obs: ").append(curNodeStrs.observationStr()).toString());
                    Predef$.MODULE$.println(new StringBuilder(7).append("Score: ").append(curNodeStrs.scoreNormalized()).toString());
                    Predef$.MODULE$.println(new StringBuilder(15).append("Valid Actions: ").append(Predef$.MODULE$.wrapRefArray((Object[])validActionsStrs).mkString(", ")).toString());
                    Predef$.MODULE$.println(new StringBuilder(15).append("Random Action: ").append(randomAction).toString());
                    Predef$.MODULE$.println("");
                    Predef$.MODULE$.println("-------------------------------------------------------------");
                }
                int actionLUTIdx = BoxesRunTime.unboxToInt(precrawledPath.stringToIDXLUT().apply(randomAction));
                int nodeToMoveTo = BoxesRunTime.unboxToInt(((PrecrawledNode)curNode$1.elem).steps().apply(BoxesRunTime.boxToInteger(actionLUTIdx)));
                curNode$1.elem = precrawledPath.getNode(nodeToMoveTo);
                ++curSteps$1.elem;
            }
        });
        return curSteps.elem;
    }

    public int randomAgentPrecrawled$default$2() {
        return 50;
    }

    public boolean randomAgentPrecrawled$default$3() {
        return false;
    }

    public void main(String[] args) {
        boolean verboseOutput = false;
        int numPerFold = 5;
        ArrayBuffer precrawledPaths = new ArrayBuffer();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPerFold).foreach((Function1<Object, ArrayBuffer> & Serializable)i -> BenchmarkPrecrawledPath$.$anonfun$main$1(precrawledPaths, BoxesRunTime.unboxToInt(i)));
        Predef$.MODULE$.println("Starting Random Agents");
        long startTime = System.currentTimeMillis();
        LongRef totalSteps = LongRef.create(0L);
        IntRef totalEpisodes = IntRef.create(0);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100000).foreach$mVc$sp(i -> precrawledPaths.foreach((Function1<PrecrawledPath, Object> & Serializable)precrawledPath -> {
            BenchmarkPrecrawledPath$.$anonfun$main$3(totalSteps, verboseOutput, totalEpisodes, precrawledPath);
            return BoxedUnit.UNIT;
        }));
        double deltaTime = (double)(System.currentTimeMillis() - startTime) / (double)1000;
        Predef$.MODULE$.println(new StringBuilder(20).append("Total Episodes    : ").append(totalEpisodes.elem).toString());
        Predef$.MODULE$.println(new StringBuilder(20).append("Total Steps       : ").append(totalSteps.elem).toString());
        Predef$.MODULE$.println(new StringBuilder(24).append("Total Time        : ").append(deltaTime).append(" sec").toString());
        double rate = (double)totalSteps.elem / deltaTime;
        Predef$.MODULE$.println(new StringBuilder(30).append("Rate              : ").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToDouble(rate)), "%3.3f")).append(" steps/sec").toString());
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$main$1(ArrayBuffer precrawledPaths$1, int i) {
        String path = "precrawledpaths/";
        String filename = new StringBuilder(117).append(path).append("precrawled-gamecoin-var").append(i).append("-foldtrain-maxDepth10-includeDoors0-limitInventorySize0-numDistractorItems0-numLocations4.json").toString();
        PrecrawledPath precrawledPath = PrecrawledPath$.MODULE$.loadFromJSON(filename).get();
        return (ArrayBuffer)precrawledPaths$1.append(precrawledPath);
    }

    public static final /* synthetic */ void $anonfun$main$3(LongRef totalSteps$1, boolean verboseOutput$1, IntRef totalEpisodes$1, PrecrawledPath precrawledPath) {
        PrecrawledPath x$1 = precrawledPath;
        boolean x$2 = verboseOutput$1;
        int x$3 = MODULE$.randomAgentPrecrawled$default$2();
        totalSteps$1.elem += (long)MODULE$.randomAgentPrecrawled(x$1, x$3, x$2);
        ++totalEpisodes$1.elem;
    }

    private BenchmarkPrecrawledPath$() {
    }
}

