/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress.benchmark;

import scala.Predef$;
import scala.Predef$StringFormat$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.sys.package$;
import scala.util.Random$;
import textworldexpress.runtime.PythonInterface;
import textworldexpress.struct.StepResult;

public final class BenchmarkOnline$ {
    public static final BenchmarkOnline$ MODULE$ = new BenchmarkOnline$();

    public void printUsage() {
        Predef$.MODULE$.println("Usage: BenchmarkOnline <gameName>");
        PythonInterface twx = new PythonInterface();
        Predef$.MODULE$.println(new StringBuilder(18).append("Valid game names: ").append(Predef$.MODULE$.wrapRefArray(twx.getGameNames().toArray()).mkString(", ")).toString());
    }

    public void main(String[] args) {
        int numEnvs = 100000;
        IntRef numStepsPerEnv = IntRef.create(50);
        boolean generateGoldPath = false;
        boolean verbose = false;
        PythonInterface twx = new PythonInterface();
        String gameName = "coin";
        if (args.length == 0) {
            this.printUsage();
            Predef$.MODULE$.println("Missing argument defining game name.  Defaulting to: coin.");
        } else if (args.length == 1) {
            gameName = args[0].toLowerCase().trim();
            if (!ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps(twx.getGameNames().toArray()), gameName)) {
                Predef$.MODULE$.println(new StringBuilder(26).append("Unrecognized game name (").append(gameName).append(").").toString());
                this.printUsage();
                throw package$.MODULE$.exit(1);
            }
        } else {
            this.printUsage();
            throw package$.MODULE$.exit(1);
        }
        String gameFold = "train";
        String paramStr = "";
        Map properties = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Predef$.MODULE$.println("Starting Benchmark...");
        StepResult env = twx.load(gameName, gameFold, 0, paramStr, generateGoldPath);
        LongRef totalSteps = LongRef.create(0L);
        long startTime = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numEnvs).foreach$mVc$sp(i -> {
            ObjectRef<StepResult> obs = ObjectRef.create(twx.resetWithRandomSeed(gameFold, generateGoldPath));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numStepsPerEnv$1.elem).foreach$mVc$sp(stepNum -> {
                if (verbose) {
                    Predef$.MODULE$.print(((StepResult)obs$1.elem).toString());
                }
                String[] validActions = ((StepResult)obs$1.elem).validActions();
                int randIdx = Random$.MODULE$.nextInt(validActions.length);
                String validActionStr = validActions[randIdx];
                obs$1.elem = twx.step(validActionStr);
                ++totalSteps$1.elem;
            });
        });
        double deltaTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        Predef$.MODULE$.println(new StringBuilder(13).append("Environment: ").append(gameName).toString());
        Predef$.MODULE$.println(new StringBuilder(82).append("Tested with: ").append(numEnvs).append(" generated environments, with ").append(numStepsPerEnv.elem).append(" randomly chosen steps per environment.").toString());
        Predef$.MODULE$.println(new StringBuilder(16).append("Delta time: ").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToDouble(deltaTime)), "%3.3f")).append(" sec").toString());
        Predef$.MODULE$.println(new StringBuilder(14).append("Rate: ").append(deltaTime / (double)numEnvs).append(" sec/env").toString());
        Predef$.MODULE$.println(new StringBuilder(15).append("Rate: ").append((double)numEnvs / deltaTime).append(" envs/sec").toString());
        Predef$.MODULE$.println(new StringBuilder(55).append("Rate: ").append((double)totalSteps.elem / deltaTime).append(" steps/sec (including environment initialization)").toString());
    }

    private BenchmarkOnline$() {
    }
}

