/*
 * Decompiled with CFR 0.152.
 */
package textworldexpress;

import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Predef$StringFormat$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.io.StdIn$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.Random$;
import textworldexpress.games.CoinGame;
import textworldexpress.generator.GameGenerator;
import textworldexpress.generator.GameGenerator$;
import textworldexpress.struct.ActionHistory;
import textworldexpress.struct.GameScore;
import textworldexpress.struct.StepResult;
import textworldexpress.struct.TextGame;

public final class EntryPointCloned$ {
    public static final EntryPointCloned$ MODULE$ = new EntryPointCloned$();

    public void main(String[] args) {
        int numEnvs = 100;
        IntRef numStepsPerEnv = IntRef.create(50);
        boolean verifyGoldPaths = true;
        boolean debugOutput = false;
        boolean console = false;
        if (console) {
            numStepsPerEnv.elem = 1000;
        }
        DoubleRef actionsPerStep = DoubleRef.create(0.0);
        IntRef numFailedGoldPaths = IntRef.create(0);
        String gameName = "kitchen";
        String gameFold = "train";
        Map properties = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("numLocations"), BoxesRunTime.boxToInteger(3))}));
        Tuple2<Object, GameGenerator> tuple2 = GameGenerator$.MODULE$.mkGameGenerator(gameName, properties);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean success = tuple2._1$mcZ$sp();
        GameGenerator gameGenerator = tuple2._2();
        Tuple2<Boolean, GameGenerator> tuple22 = new Tuple2<Boolean, GameGenerator>(BoxesRunTime.boxToBoolean(success), gameGenerator);
        Tuple2<Boolean, GameGenerator> tuple23 = tuple22;
        boolean success2 = tuple23._1$mcZ$sp();
        GameGenerator gameGenerator2 = tuple23._2();
        if (!success2) {
            Predef$.MODULE$.println("ERROR creating Game Generator: ");
            Predef$.MODULE$.println(gameGenerator2.errorStr());
            throw package$.MODULE$.exit(1);
        }
        int numCachedGames = 25;
        ArrayBuffer cachedGames = new ArrayBuffer();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numCachedGames).foreach((Function1<Object, ArrayBuffer> & Serializable)i -> EntryPointCloned$.$anonfun$main$1(gameGenerator2, gameFold, cachedGames, BoxesRunTime.unboxToInt(i)));
        long startTime = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numEnvs).foreach$mVc$sp(i -> {
            TextGame textGame;
            ObjectRef<Object> game = ObjectRef.create(null);
            String[] goldPath = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            int gameIdx = i % numCachedGames;
            game.elem = ((TextGame)((Tuple2)cachedGames.apply(gameIdx))._1()).deepCopy();
            goldPath = (String[])((Tuple2)cachedGames.apply(gameIdx))._2();
            if (verifyGoldPaths) {
                StepResult initInfo = ((TextGame)game.elem).initalStep();
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(goldPath), (Function1<String, StepResult> & Serializable)actionStr -> ((TextGame)game$1.elem).step((String)actionStr));
                GameScore scores = ((TextGame)game.elem).getScore();
                if (scores.scoreNormalized() != 1.0) {
                    Predef$.MODULE$.println(new StringBuilder(17).append("ERROR ON GAME ").append(i).append(" / ").append(numEnvs).toString());
                    Predef$.MODULE$.println(new StringBuilder(7).append("Score: ").append(scores.scoreNormalized()).toString());
                    Predef$.MODULE$.println(new StringBuilder(21).append("PLAYTHROUGH: (").append(((TextGame)game.elem).getHistory().length()).append(" steps)").toString());
                    ((TextGame)game.elem).getHistory().foreach((Function1<ActionHistory, Object> & Serializable)hStep -> {
                        EntryPointCloned$.$anonfun$main$4(hStep);
                        return BoxedUnit.UNIT;
                    });
                    ++numFailedGoldPaths$1.elem;
                }
                game.elem = gameGenerator2.mkGame(i, gameFold);
            }
            if ((textGame = (TextGame)game.elem) instanceof CoinGame) {
                CoinGame coinGame = (CoinGame)textGame;
                CoinGame clone = coinGame.deepCopy();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (debugOutput) {
                Predef$.MODULE$.println("\n-----------------------------------\n");
            }
            ObjectRef<Object> validActions = ObjectRef.create(null);
            StepResult stepResultInitial = ((TextGame)game.elem).initalStep();
            validActions.elem = stepResultInitial.validActions();
            if (debugOutput) {
                Predef$.MODULE$.println(new StringBuilder(16).append("observationStr: ").append(stepResultInitial.observationStr()).toString());
            }
            if (debugOutput) {
                Predef$.MODULE$.println(new StringBuilder(14).append("inventoryStr: ").append(stepResultInitial.inventoryStr()).toString());
            }
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numStepsPerEnv$1.elem).foreach$mVc$sp(j -> {
                if (!console) {
                    int randActionIdx = Random$.MODULE$.nextInt(((String[])validActions$1.elem).length);
                    if (debugOutput) {
                        Predef$.MODULE$.println(new StringBuilder(3).append(" > ").append(((String[])validActions$1.elem)[randActionIdx]).toString());
                        Predef$.MODULE$.println("");
                    }
                    StepResult stepResult = ((TextGame)game$1.elem).step(randActionIdx);
                    validActions$1.elem = stepResult.validActions();
                    actionsPerStep$1.elem += (double)((String[])validActions$1.elem).length;
                    if (debugOutput) {
                        Predef$.MODULE$.println(new StringBuilder(16).append("observationStr: ").append(stepResult.observationStr()).toString());
                        Predef$.MODULE$.println(new StringBuilder(13).append("freelookStr: ").append(stepResult.freeLookStr()).toString());
                        Predef$.MODULE$.println(new StringBuilder(14).append("inventoryStr: ").append(stepResult.inventoryStr()).toString());
                        Predef$.MODULE$.println(new StringBuilder(57).append("Score: ").append(stepResult.scoreRaw()).append("   normalizedScore: ").append(stepResult.scoreNormalized()).append("  taskSuccess: ").append(stepResult.taskSuccess()).append("  taskFailure: ").append(stepResult.taskFailure()).toString());
                    }
                } else {
                    Predef$.MODULE$.print("> ");
                    String inputStr = StdIn$.MODULE$.readLine().trim().toLowerCase();
                    StepResult stepResult = ((TextGame)game$1.elem).step(inputStr);
                    validActions$1.elem = stepResult.validActions();
                    Predef$.MODULE$.println("");
                    Predef$.MODULE$.println(new StringBuilder(16).append("observationStr: ").append(stepResult.observationStr()).toString());
                    Predef$.MODULE$.println(new StringBuilder(13).append("freelookStr: ").append(stepResult.freeLookStr()).toString());
                    Predef$.MODULE$.println(new StringBuilder(14).append("inventoryStr: ").append(stepResult.inventoryStr()).toString());
                    Predef$.MODULE$.println(new StringBuilder(57).append("Score: ").append(stepResult.scoreRaw()).append("   normalizedScore: ").append(stepResult.scoreNormalized()).append("  taskSuccess: ").append(stepResult.taskSuccess()).append("  taskFailure: ").append(stepResult.taskFailure()).toString());
                }
            });
        });
        actionsPerStep.elem /= (double)numEnvs * (double)numStepsPerEnv.elem;
        long deltaTime = System.currentTimeMillis() - startTime;
        Predef$.MODULE$.println(new StringBuilder(82).append("Tested with: ").append(numEnvs).append(" generated environments, with ").append(numStepsPerEnv.elem).append(" randomly chosen steps per environment.").toString());
        Predef$.MODULE$.println(new StringBuilder(17).append("Delta time: ").append(deltaTime).append(" msec").toString());
        Predef$.MODULE$.println(new StringBuilder(42).append("On average, each step has ").append(Predef$StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat(BoxesRunTime.boxToDouble(actionsPerStep.elem)), "%3.3f")).append(" valid actions. ").toString());
        Predef$.MODULE$.println(new StringBuilder(15).append("Rate: ").append((double)deltaTime / (double)numEnvs).append(" msec/env").toString());
        Predef$.MODULE$.println(new StringBuilder(15).append("Rate: ").append((double)numEnvs / ((double)deltaTime / 1000.0)).append(" envs/sec").toString());
        Predef$.MODULE$.println(new StringBuilder(55).append("Rate: ").append((double)numEnvs * (double)numStepsPerEnv.elem / ((double)deltaTime / 1000.0)).append(" steps/sec (including environment initialization)").toString());
        Predef$.MODULE$.println(new StringBuilder(29).append("Number of failed gold paths: ").append(numFailedGoldPaths.elem).toString());
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$main$1(GameGenerator gameGenerator$1, String gameFold$1, ArrayBuffer cachedGames$1, int i) {
        Tuple2<TextGame, String[]> tuple2 = gameGenerator$1.mkGameWithGoldPath(i, gameFold$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TextGame _game = tuple2._1();
        String[] _goldPath = tuple2._2();
        Tuple2<TextGame, String[]> tuple22 = new Tuple2<TextGame, String[]>(_game, _goldPath);
        Tuple2<TextGame, String[]> tuple23 = tuple22;
        TextGame _game2 = tuple23._1();
        String[] _goldPath2 = tuple23._2();
        return (ArrayBuffer)cachedGames$1.append(new Tuple2<TextGame, String[]>(_game2, _goldPath2));
    }

    public static final /* synthetic */ void $anonfun$main$4(ActionHistory hStep) {
        Predef$.MODULE$.println(new StringBuilder(2).append("> ").append(hStep.actionStr()).toString());
        Predef$.MODULE$.println("");
        Predef$.MODULE$.println(hStep.observationStr());
        Predef$.MODULE$.println(new StringBuilder(7).append("Score: ").append(hStep.scores().scoreRaw()).toString());
    }

    private EntryPointCloned$() {
    }
}

