/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;

public class Status {
    protected final AbstractTerminal terminal;
    protected final boolean supported;
    protected List<AttributedString> oldLines = Collections.emptyList();
    protected List<AttributedString> linesToRestore = Collections.emptyList();
    protected int rows;
    protected int columns;
    protected boolean force;
    protected boolean suspended = false;
    protected AttributedString borderString;
    protected int border = 0;

    public static Status getStatus(Terminal terminal2) {
        return Status.getStatus(terminal2, true);
    }

    public static Status getStatus(Terminal terminal2, boolean create2) {
        return terminal2 instanceof AbstractTerminal ? ((AbstractTerminal)terminal2).getStatus(create2) : null;
    }

    public Status(AbstractTerminal terminal2) {
        this.terminal = Objects.requireNonNull(terminal2, "terminal can not be null");
        boolean bl = this.supported = terminal2.getStringCapability(InfoCmp.Capability.change_scroll_region) != null && terminal2.getStringCapability(InfoCmp.Capability.save_cursor) != null && terminal2.getStringCapability(InfoCmp.Capability.restore_cursor) != null && terminal2.getStringCapability(InfoCmp.Capability.cursor_address) != null;
        if (this.supported) {
            char borderChar = '\u2500';
            AttributedStringBuilder bb = new AttributedStringBuilder();
            for (int i = 0; i < 200; ++i) {
                bb.append(borderChar);
            }
            this.borderString = bb.toAttributedString();
            this.resize();
        }
    }

    public void setBorder(boolean border) {
        this.border = border ? 1 : 0;
    }

    public void resize() {
        Size size2 = this.terminal.getSize();
        this.rows = size2.getRows();
        this.columns = size2.getColumns();
        this.force = true;
    }

    public void reset() {
        this.force = true;
    }

    public void hardReset() {
        if (this.suspended) {
            return;
        }
        ArrayList<AttributedString> lines = new ArrayList<AttributedString>(this.oldLines);
        int b = this.border;
        this.update(null);
        this.border = b;
        this.update(lines);
    }

    public void redraw() {
        if (this.suspended) {
            return;
        }
        this.update(this.oldLines);
    }

    public void clear() {
        this.privateClear(this.oldLines.size());
    }

    private void clearAll() {
        int b = this.border;
        this.border = 0;
        this.privateClear(this.oldLines.size() + b);
    }

    private void privateClear(int statusSize) {
        ArrayList<AttributedString> as = new ArrayList<AttributedString>();
        for (int i = 0; i < statusSize; ++i) {
            as.add(new AttributedString(""));
        }
        if (!as.isEmpty()) {
            this.update(as);
        }
    }

    public void update(List<AttributedString> lines) {
        int i;
        if (!this.supported) {
            return;
        }
        if (lines == null) {
            lines = Collections.emptyList();
        }
        if (this.suspended) {
            this.linesToRestore = new ArrayList<AttributedString>(lines);
            return;
        }
        if (lines.isEmpty()) {
            this.clearAll();
        }
        if (this.oldLines.equals(lines) && !this.force) {
            return;
        }
        int statusSize = lines.size() + (lines.size() == 0 ? 0 : this.border);
        int nb = statusSize - this.oldLines.size() - (this.oldLines.size() == 0 ? 0 : this.border);
        if (nb > 0) {
            for (i = 0; i < nb; ++i) {
                this.terminal.puts(InfoCmp.Capability.cursor_down, new Object[0]);
            }
            for (i = 0; i < nb; ++i) {
                this.terminal.puts(InfoCmp.Capability.cursor_up, new Object[0]);
            }
        }
        this.terminal.puts(InfoCmp.Capability.save_cursor, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - statusSize, 0);
        if (!this.terminal.puts(InfoCmp.Capability.clr_eos, new Object[0])) {
            for (i = this.rows - statusSize; i < this.rows; ++i) {
                this.terminal.puts(InfoCmp.Capability.cursor_address, i, 0);
                this.terminal.puts(InfoCmp.Capability.clr_eol, new Object[0]);
            }
        }
        if (this.border == 1 && lines.size() > 0) {
            this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - statusSize, 0);
            this.borderString.columnSubSequence(0, this.columns).print(this.terminal);
        }
        for (i = 0; i < lines.size(); ++i) {
            this.terminal.puts(InfoCmp.Capability.cursor_address, this.rows - lines.size() + i, 0);
            if (lines.get(i).length() > this.columns) {
                AttributedStringBuilder asb = new AttributedStringBuilder();
                asb.append(lines.get(i).substring(0, this.columns - 3)).append("...", new AttributedStyle(AttributedStyle.INVERSE));
                asb.toAttributedString().columnSubSequence(0, this.columns).print(this.terminal);
                continue;
            }
            lines.get(i).columnSubSequence(0, this.columns).print(this.terminal);
        }
        this.terminal.puts(InfoCmp.Capability.change_scroll_region, 0, this.rows - 1 - statusSize);
        this.terminal.puts(InfoCmp.Capability.restore_cursor, new Object[0]);
        this.terminal.flush();
        this.oldLines = new ArrayList<AttributedString>(lines);
        this.force = false;
    }

    public void suspend() {
        if (this.suspended) {
            return;
        }
        this.linesToRestore = new ArrayList<AttributedString>(this.oldLines);
        int b = this.border;
        this.update(null);
        this.border = b;
        this.suspended = true;
    }

    public void restore() {
        if (!this.suspended) {
            return;
        }
        this.suspended = false;
        this.update(this.linesToRestore);
        this.linesToRestore = Collections.emptyList();
    }

    public int size() {
        return this.oldLines.size() + this.border;
    }
}

