/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna;

import java.io.IOException;
import java.nio.charset.Charset;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.jna.JnaNativePty;
import org.jline.terminal.impl.jna.win.JnaWinSysTerminal;
import org.jline.terminal.spi.JnaSupport;
import org.jline.terminal.spi.Pty;
import org.jline.utils.OSUtils;

public class JnaSupportImpl
implements JnaSupport {
    @Override
    public Pty current() throws IOException {
        return JnaNativePty.current();
    }

    @Override
    public Pty open(Attributes attributes, Size size2) throws IOException {
        return JnaNativePty.open(attributes, size2);
    }

    @Override
    public Terminal winSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, int codepage, boolean nativeSignals, Terminal.SignalHandler signalHandler) throws IOException {
        return this.winSysTerminal(name, type, ansiPassThrough, encoding, codepage, nativeSignals, signalHandler, false);
    }

    @Override
    public Terminal winSysTerminal(String name, String type, boolean ansiPassThrough, Charset encoding, int codepage, boolean nativeSignals, Terminal.SignalHandler signalHandler, boolean paused) throws IOException {
        return JnaWinSysTerminal.createTerminal(name, type, ansiPassThrough, encoding, codepage, nativeSignals, signalHandler, paused);
    }

    @Override
    public boolean isWindowsConsole() {
        return JnaWinSysTerminal.isWindowsConsole();
    }

    @Override
    public boolean isConsoleOutput() {
        if (OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) {
            throw new UnsupportedOperationException();
        }
        if (OSUtils.IS_WINDOWS) {
            return JnaWinSysTerminal.isConsoleOutput();
        }
        return JnaNativePty.isConsoleOutput();
    }

    @Override
    public boolean isConsoleInput() {
        if (OSUtils.IS_CYGWIN || OSUtils.IS_MSYSTEM) {
            throw new UnsupportedOperationException();
        }
        if (OSUtils.IS_WINDOWS) {
            return JnaWinSysTerminal.isConsoleInput();
        }
        return JnaNativePty.isConsoleInput();
    }
}

