/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.Show;
import cats.Show$;
import cats.kernel.Eq;
import cats.package$;
import io.circe.Json;
import io.circe.Json$JNull$;
import io.circe.JsonBigDecimal;
import io.circe.JsonBiggerDecimal;
import io.circe.JsonDouble;
import io.circe.JsonFloat;
import io.circe.JsonLong;
import io.circe.JsonNumber;
import io.circe.JsonNumber$;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.numbers.BiggerDecimal$;
import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Json$
implements Serializable {
    public static final Json$ MODULE$ = new Json$();
    private static final Json Null = Json$JNull$.MODULE$;
    private static final Json True = new Json.JBoolean(true);
    private static final Json False = new Json.JBoolean(false);
    private static final Eq<Json> eqJson = package$.MODULE$.Eq().instance((Function2<Json, Json, Object> & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean(Json$.$anonfun$eqJson$1(x0$1, x1$1)));
    private static final Show<Json> showJson = Show$.MODULE$.fromToString();

    public final Json Null() {
        return Null;
    }

    public final Json True() {
        return True;
    }

    public final Json False() {
        return False;
    }

    public final Json obj(Seq<Tuple2<String, Json>> fields) {
        return this.fromFields(fields);
    }

    public final Json arr(Seq<Json> values2) {
        return this.fromValues(values2);
    }

    public final Json fromFields(Iterable<Tuple2<String, Json>> fields) {
        return new Json.JObject(JsonObject$.MODULE$.fromIterable(fields));
    }

    public final Json fromValues(Iterable<Json> values2) {
        return new Json.JArray(values2.toVector());
    }

    public final Json fromJsonObject(JsonObject value) {
        return new Json.JObject(value);
    }

    public final Json fromJsonNumber(JsonNumber value) {
        return new Json.JNumber(value);
    }

    public final Json fromString(String value) {
        return new Json.JString(value);
    }

    public final Json fromBoolean(boolean value) {
        return value ? this.True() : this.False();
    }

    public final Json fromInt(int value) {
        return new Json.JNumber(new JsonLong(value));
    }

    public final Json fromLong(long value) {
        return new Json.JNumber(new JsonLong(value));
    }

    public final Option<Json> fromDouble(double value) {
        return this.isReal(value) ? new Some<Json.JNumber>(new Json.JNumber(new JsonDouble(value))) : None$.MODULE$;
    }

    public final Option<Json> fromFloat(float value) {
        return this.isReal(value) ? new Some<Json.JNumber>(new Json.JNumber(new JsonFloat(value))) : None$.MODULE$;
    }

    public final Json fromDoubleOrNull(double value) {
        return this.isReal(value) ? new Json.JNumber(new JsonDouble(value)) : this.Null();
    }

    public final Json fromFloatOrNull(float value) {
        return this.isReal(value) ? new Json.JNumber(new JsonFloat(value)) : this.Null();
    }

    public final Json fromDoubleOrString(double value) {
        return this.isReal(value) ? new Json.JNumber(new JsonDouble(value)) : this.fromString(Double.toString(value));
    }

    public final Json fromFloatOrString(float value) {
        return this.isReal(value) ? new Json.JNumber(new JsonFloat(value)) : this.fromString(Float.toString(value));
    }

    public final Json fromBigInt(BigInt value) {
        return new Json.JNumber(new JsonBiggerDecimal(BiggerDecimal$.MODULE$.fromBigInteger(value.underlying()), value.toString()));
    }

    public final Json fromBigDecimal(BigDecimal value) {
        return new Json.JNumber(new JsonBigDecimal(value.underlying()));
    }

    private boolean isReal(double value) {
        return Double.isFinite(value);
    }

    private boolean isReal(float value) {
        return Float.isFinite(value);
    }

    private final boolean arrayEq(Seq<Json> x, Seq<Json> y) {
        Iterator it0 = x.iterator();
        Iterator it1 = y.iterator();
        while (it0.hasNext() && it1.hasNext()) {
            if (!this.eqJson().neqv((Json)it0.next(), (Json)it1.next())) continue;
            return false;
        }
        return it0.hasNext() == it1.hasNext();
    }

    public final Eq<Json> eqJson() {
        return eqJson;
    }

    public final Show<Json> showJson() {
        return showJson;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Json$.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$eqJson$1(Json x0$1, Json x1$1) {
        Tuple2<Json, Json> tuple2 = new Tuple2<Json, Json>(x0$1, x1$1);
        if (tuple2 != null) {
            Json json = tuple2._1();
            Json json2 = tuple2._2();
            if (json instanceof Json.JObject) {
                Json.JObject jObject = (Json.JObject)json;
                JsonObject a = jObject.value();
                if (json2 instanceof Json.JObject) {
                    Json.JObject jObject2 = (Json.JObject)json2;
                    JsonObject b = jObject2.value();
                    return JsonObject$.MODULE$.eqJsonObject().eqv(a, b);
                }
            }
        }
        if (tuple2 != null) {
            Json json = tuple2._1();
            Json json3 = tuple2._2();
            if (json instanceof Json.JString) {
                Json.JString jString = (Json.JString)json;
                String a = jString.value();
                if (json3 instanceof Json.JString) {
                    Json.JString jString2 = (Json.JString)json3;
                    String b = jString2.value();
                    String string = a;
                    String string2 = b;
                    if (string != null) {
                        if (!string.equals(string2)) return false;
                        return true;
                    }
                    if (string2 == null) return true;
                    return false;
                }
            }
        }
        if (tuple2 != null) {
            Json json = tuple2._1();
            Json json4 = tuple2._2();
            if (json instanceof Json.JNumber) {
                Json.JNumber jNumber = (Json.JNumber)json;
                JsonNumber a = jNumber.value();
                if (json4 instanceof Json.JNumber) {
                    Json.JNumber jNumber2 = (Json.JNumber)json4;
                    JsonNumber b = jNumber2.value();
                    return JsonNumber$.MODULE$.eqJsonNumber().eqv(a, b);
                }
            }
        }
        if (tuple2 != null) {
            Json json = tuple2._1();
            Json json5 = tuple2._2();
            if (json instanceof Json.JBoolean) {
                Json.JBoolean jBoolean = (Json.JBoolean)json;
                boolean a = jBoolean.value();
                if (json5 instanceof Json.JBoolean) {
                    Json.JBoolean jBoolean2 = (Json.JBoolean)json5;
                    boolean b = jBoolean2.value();
                    if (a != b) return false;
                    return true;
                }
            }
        }
        if (tuple2 != null) {
            Json json = tuple2._1();
            Json json6 = tuple2._2();
            if (json instanceof Json.JArray) {
                Json.JArray jArray = (Json.JArray)json;
                Vector<Json> a = jArray.value();
                if (json6 instanceof Json.JArray) {
                    Json.JArray jArray2 = (Json.JArray)json6;
                    Vector<Json> b = jArray2.value();
                    return MODULE$.arrayEq(a, b);
                }
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Json x = tuple2._1();
        Json y = tuple2._2();
        if (!x.isNull()) return false;
        if (!y.isNull()) return false;
        return true;
    }

    private Json$() {
    }
}

