"""Data downloaded from NCBI Gene data converted into Python data."""

# Copyright (C) 2014-2018, DV Klopfenstein. All rights reserved

downloaded = "2016_02_22" # 13919 items

# Downloaded as a tsv from NCBI Gene. Then translated to Python:
#
# http://www.ncbi.nlm.nih.gov/gene/?term=genetype+protein+coding%5BProperties%5D+AND+%227227%22%5BTaxonomy+ID%5D+AND+alive%5Bproperty%5D
# 
# or follow link to "Search for Fruit Fly Protein-Coding Genes" found here:
# 
# https://github.com/dvklopfenstein/biocode/blob/master/biodownloads/README.md

import collections as cx

NtData = cx.namedtuple('NtData', 'tax_id Org_name GeneID CurrentID Status Symbol Aliases description other_designations map_location chromosome genomic_nucleotide_accession_version start_position_on_the_genomic_accession end_position_on_the_genomic_accession orientation exon_count OMIM no_hdr0')
GENEID2NT = {
  32768 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32768, CurrentID=0, Status='live', Symbol='CG6762', Aliases='Dmel_ Dmel\\CG6762', description='CG6762 gene product from transcript CG6762-RD', other_designations='CG6762-PA|CG6762-PB|CG6762-PC|CG6762-PD', map_location='16E2-16E2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17856974, end_position_on_the_genomic_accession=17858610, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32769 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32769, CurrentID=0, Status='live', Symbol='Arp8', Aliases='Dmel_CG7846, CG7846, Dmel\\CG7846, arp8, dArp8', description='Actin-related protein 8', other_designations='Arp8-PA|CG7846-PA|actin related protein 8', map_location='16E2-16E2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17858379, end_position_on_the_genomic_accession=17860800, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32770 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32770, CurrentID=0, Status='live', Symbol='CG6769', Aliases='Dmel_ Dmel\\CG6769', description='CG6769 gene product from transcript CG6769-RB', other_designations='CG6769-PA|CG6769-PB', map_location='16E2-16E2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17861002, end_position_on_the_genomic_accession=17862775, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32771 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32771, CurrentID=0, Status='live', Symbol='mnb', Aliases='Dmel_CG42273, CG42273, CG7826, CG7835, DYRK1, Dm1, DmDyrk1A, Dmel\\CG42273, Dmel_CG7826, Dmel_CG7835, Dyrk1, Dyrk1A, ME-IV, MNB, Mnb, min', description='minibrain', other_designations='CG42273-PE|CG42273-PF|CG42273-PG|CG42273-PH|CG42273-PI|Dual-specificity tyrosine phosphorylation-regulated kinase 1A|minibrain kinase|mnb-PE|mnb-PF|mnb-PG|mnb-PH|mnb-PI', map_location='1-58.2 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17862697, end_position_on_the_genomic_accession=17887222, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  32773 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32773, CurrentID=0, Status='live', Symbol='CG6788', Aliases='Dmel_ AAF48780, Dmel\\CG6788, FBpp0074269', description='CG6788 gene product from transcript CG6788-RA', other_designations='CG6788-PA|Fibrinogen-related protein', map_location='16F1-16F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17888177, end_position_on_the_genomic_accession=17889404, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32774 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32774, CurrentID=0, Status='live', Symbol='CG12985', Aliases='Dmel_ Dmel\\CG12985', description='CG12985 gene product from transcript CG12985-RA', other_designations='CG12985-PA|uncharacterized protein', map_location='16F1-16F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17883718, end_position_on_the_genomic_accession=17885238, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32775 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32775, CurrentID=0, Status='live', Symbol='GSS', Aliases='Dmel_CG6835, 6835, CG32497, CG33065, CG6835, Dmel\\CG6835, GS', description='Glutathione Synthetase', other_designations='CG6835-PE|CG6835-PF|CG6835-PG|CG6835-PH|CG6835-PI|CG6835-PJ|CG6835-PK|GSS-PE|GSS-PF|GSS-PG|GSS-PH|GSS-PI|GSS-PJ|GSS-PK|glutathione synthase|glutathione synthetase', map_location='16F1-16F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17889547, end_position_on_the_genomic_accession=17898603, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  32776 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32776, CurrentID=0, Status='live', Symbol='CG7772', Aliases='Dmel_ Dmel\\CG7772, bs13c01.y1', description='CG7772 gene product from transcript CG7772-RA', other_designations='CG7772-PA', map_location='16F1-16F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17906031, end_position_on_the_genomic_accession=17907261, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32777 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32777, CurrentID=0, Status='live', Symbol='Vps4', Aliases='Dmel_CG6842, 3B1, BcDNA:GH02678, CG6842, DmBcDNA.GH02678, Dmel\\CG6842, Dvps4B, bcDNA:GH02678, dvps4, vps4, Vps4', description='Vacuolar protein sorting 4', other_designations='CG6842-PA|CG6842-PB|Vps4-PA|Vps4-PB|vacuolar protein sorting 4', map_location='16F1-16F2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17907692, end_position_on_the_genomic_accession=17911097, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  32778 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32778, CurrentID=0, Status='live', Symbol='CG6847', Aliases='Dmel_ Dmel\\CG6847', description='CG6847 gene product from transcript CG6847-RB', other_designations='CG6847-PA|CG6847-PB', map_location='16F3-16F3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17911462, end_position_on_the_genomic_accession=17924163, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  32780 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32780, CurrentID=0, Status='live', Symbol='Sh', Aliases='Dmel_CG12348, BcDNA:GH03046, CG12348, CG17860, CG7640, Dmel\\CG12348, EKO, Eko, F-c, Kv1, SHa, Shw, V-I, minisleep, sh, sha, Sh', description='Shaker', other_designations='CG12348-PA|CG12348-PB|CG12348-PC|CG12348-PD|CG12348-PE|CG12348-PF|CG12348-PH|CG12348-PI|CG12348-PJ|CG12348-PK|CG12348-PL|CG12348-PM|CG12348-PQ|CG12348-PS|CG12348-PT|F-c transcription unit|Sh-PA|Sh-PB|Sh-PC|Sh-PD|Sh-PE|Sh-PF|Sh-PH|Sh-PI|Sh-PJ|Sh-PK|Sh-PL|Sh-PM|Sh-PQ|Sh-PS|Sh-PT|Shaker-downheld|shaker', map_location='1-57.6 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=17924307, end_position_on_the_genomic_accession=18063247, orientation='minus', exon_count=26, OMIM='', no_hdr0=''),
  32781 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32781, CurrentID=0, Status='live', Symbol='CG12672', Aliases='Dmel_ Dmel\\CG12672', description='CG12672 gene product from transcript CG12672-RA', other_designations='CG12672-PA|uncharacterized protein', map_location='16F4-16F4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18005897, end_position_on_the_genomic_accession=18007606, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32782 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32782, CurrentID=0, Status='live', Symbol='CG6867', Aliases='Dmel_ CT21241, Dmel\\CG6867', description='CG6867 gene product from transcript CG6867-RA', other_designations='CG6867-PA', map_location='16F5-16F5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18023870, end_position_on_the_genomic_accession=18028261, orientation='plus', exon_count=16, OMIM='', no_hdr0=''),
  32784 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32784, CurrentID=0, Status='live', Symbol='CG15373', Aliases='Dmel_ Dmel\\CG15373', description='CG15373 gene product from transcript CG15373-RB', other_designations='CG15373-PA|CG15373-PB|uncharacterized protein', map_location='16F5-16F5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18044071, end_position_on_the_genomic_accession=18048720, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  32785 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32785, CurrentID=0, Status='live', Symbol='Dhc16F', Aliases='Dmel_CG7092, CG7092, DHC, Dhc, Dmel\\CG7092, atoll, cvl-6, dhc', description='Dynein heavy chain at 16F', other_designations='CG7092-PA|Dhc16F-PA|crossveinless-like 6|dynein heavy chain at 16F|dynein-related heavy chain polypeptide', map_location='1-59.1 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18064483, end_position_on_the_genomic_accession=18078472, orientation='plus', exon_count=27, OMIM='', no_hdr0=''),
  32786 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32786, CurrentID=0, Status='live', Symbol='CG7536', Aliases='Dmel_ Dmel\\CG7536', description='CG7536 gene product from transcript CG7536-RC', other_designations='CG7536-PA|CG7536-PB|CG7536-PC|CG7536-PD', map_location='16F6-16F6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18078491, end_position_on_the_genomic_accession=18088532, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  32787 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32787, CurrentID=0, Status='live', Symbol='Ada3', Aliases='Dmel_CG7098, ADA3, CG7098, DADA3, Dmel\\CG7098, HL-XIV, dADA3, dAda3, dik', description='transcriptional Adaptor 3', other_designations='Ada3-PA|Ada3-PC|CG7098-PA|CG7098-PC|diskette|transcriptional adaptor 3', map_location='16F6-16F6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18085761, end_position_on_the_genomic_accession=18088418, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32788 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32788, CurrentID=0, Status='live', Symbol='CG7206', Aliases='Dmel_ Dmel\\CG7206', description='CG7206 gene product from transcript CG7206-RB', other_designations='CG7206-PB|CG7206-PC', map_location='16F6-16F6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18088725, end_position_on_the_genomic_accession=18090509, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32789 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32789, CurrentID=0, Status='live', Symbol='scu', Aliases='Dmel_CG7113, 17beta-HSD10, CG7113, Dmel\\CG7113, HL-X, HLII, Scu, l(1)16Fd, l(1)17Ad', description='scully', other_designations='3-hydroxyacyl-CoA dehydrogenase|CG7113-PA|CG7113-PB|haplo-lethal region II|lethal(1)17Ad|scu-PA|scu-PB', map_location='16F6-16F6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18091259, end_position_on_the_genomic_accession=18092853, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32790 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32790, CurrentID=0, Status='live', Symbol='RhoGAP16F', Aliases='Dmel_CG7122, CG7122, Dmel\\CG7122', description='Rho GTPase activating protein at 16F', other_designations='CG7122-PB|CG7122-PC|CG7122-PD|CG7122-PE|CG7122-PF|RhoGAP16F-PB|RhoGAP16F-PC|RhoGAP16F-PD|RhoGAP16F-PE|RhoGAP16F-PF', map_location='16F6-16F6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18093145, end_position_on_the_genomic_accession=18097413, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  32791 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32791, CurrentID=0, Status='live', Symbol='CG7192', Aliases='Dmel_ Dmel\\CG7192', description='CG7192 gene product from transcript CG7192-RA', other_designations='CG7192-PA|CG7192-PB|CG7192-PD', map_location='16F6-16F6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18097558, end_position_on_the_genomic_accession=18101314, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  32792 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32792, CurrentID=0, Status='live', Symbol='Taf8', Aliases='Dmel_CG7128, CG7128, Dmel\\CG7128, HL-VIII, Prodos, TAF, TAF8, TAF[[II]], TFIID, dmTAF8, l(1)16Fg, pds, pro, prod', description='TBP-associated factor 8', other_designations='CG7128-PA|TBP-associated factor|Taf8-PA|prodos', map_location='16F7-16F7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18101970, end_position_on_the_genomic_accession=18103482, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32793 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32793, CurrentID=0, Status='live', Symbol='CG7135', Aliases='Dmel_ Dmel\\CG7135', description='CG7135 gene product from transcript CG7135-RA', other_designations='CG7135-PA', map_location='16F7-16F7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18103653, end_position_on_the_genomic_accession=18105393, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32794 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32794, CurrentID=0, Status='live', Symbol='wupA', Aliases='Dmel_CG7178, CG7178, DROTROPONI, DmTpnI, Dmel\\CG7178, HDP, HL-I, HL08042, HLI, Tn I, TnI, TpnI, WupA, chrX:17947374..17947524, fliH, hdp, hdp-a, hdp2, wup-A', description='wings up A', other_designations='CG7178-PA|CG7178-PB|CG7178-PC|CG7178-PD|CG7178-PE|CG7178-PF|CG7178-PG|CG7178-PH|CG7178-PI|CG7178-PJ|CG7178-PK|CG7178-PL|CG7178-PM|flightless H|flightless-H|haplo-lethal region I|held up|held-up|held-up2|heldup|heldup-a|troponin|troponin I|troponin-I|wings up|wings-up A|wupA-PA|wupA-PB|wupA-PC|wupA-PD|wupA-PE|wupA-PF|wupA-PG|wupA-PH|wupA-PI|wupA-PJ|wupA-PK|wupA-PL|wupA-PM', map_location='1-57.69 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18105568, end_position_on_the_genomic_accession=18116922, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  32796 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32796, CurrentID=0, Status='live', Symbol='ari-1', Aliases='Dmel_CG5659, AAS65398.1, ARI1_DROME, Ari-1, CG5659, Dmel\\CG5659, HL-V, aria, l(1)16Fj, ari-1', description='ariadne 1', other_designations='Ariadne-1|CG5659-PA|CG5659-PB|CG5659-PC|CG5659-PD|CG5659-PE|CG5659-PF|ari-1-PA|ari-1-PB|ari-1-PC|ari-1-PD|ari-1-PE|ari-1-PF|ariadne', map_location='16F7-16F7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18130392, end_position_on_the_genomic_accession=18137784, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  32797 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32797, CurrentID=0, Status='live', Symbol='Frq1', Aliases='Dmel_CG5744, CG5744, Dmel\\CG5744, Frq, HL-II, frq, frq1', description='Frequenin 1', other_designations='CG5744-PB|CG5744-PC|CG5744-PD|CG5744-PE|Frq1-PB|Frq1-PC|Frq1-PD|Frq1-PE|frequenin|frequenin 1|frequentin|frequinin', map_location='16F7-17A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18155369, end_position_on_the_genomic_accession=18174744, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  32798 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32798, CurrentID=0, Status='live', Symbol='Andorra', Aliases='Dmel_CG12611, CG12611, Dmel\\CG12611, and, andorra', description='CG12611 gene product from transcript CG12611-RA', other_designations='Andorra-PA|CG12611-PA|andorra', map_location='17A1-17A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18178526, end_position_on_the_genomic_accession=18179472, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32799 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32799, CurrentID=0, Status='live', Symbol='Frq2', Aliases='Dmel_CG5907, CG5907, Dmel\\CG5907, Frq, frq, frq2', description='Frequenin 2', other_designations='CG5907-PA|CG5907-PB|CG5907-PC|CG5907-PD|Frq2-PA|Frq2-PB|Frq2-PC|Frq2-PD|frequenin|frequenin 2', map_location='17A1-17A2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18177612, end_position_on_the_genomic_accession=18204407, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  32800 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32800, CurrentID=0, Status='live', Symbol='Hesr', Aliases='Dmel_CG5927, CG5927, Dmel\\CG5927, Her, bHLHc21', description='HES-related', other_designations='CG5927-PA|Hesr-PA', map_location='17A2-17A2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18204403, end_position_on_the_genomic_accession=18205144, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32801 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32801, CurrentID=0, Status='live', Symbol='Him', Aliases='Dmel_CG15064, CG15064, Dmel\\CG15064, him', description='Holes in muscle', other_designations='CG15064-PA|Him-PA|holes in muscle|holes in muscles|holes-in-muscle', map_location='17A2-17A2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18209427, end_position_on_the_genomic_accession=18210741, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32803 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32803, CurrentID=0, Status='live', Symbol='CG33639', Aliases='Dmel_ CG16958, CG5936, Dmel\\CG33639, anon-WO0170980.40, anon-WO0170980.41', description='CG33639 gene product from transcript CG33639-RD', other_designations='CG33639-PA|CG33639-PB|CG33639-PC|CG33639-PD|uncharacterized protein', map_location='17A2-17A2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18210812, end_position_on_the_genomic_accession=18226076, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  5740834 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740834, CurrentID=0, Status='live', Symbol='CG16824', Aliases='Dmel_ Dmel\\CG16824', description='CG16824 gene product from transcript CG16824-RA', other_designations='CG16824-PA|uncharacterized protein', map_location='34B4-34B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13293009, end_position_on_the_genomic_accession=13293415, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32805 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32805, CurrentID=0, Status='live', Symbol='upd2', Aliases='Dmel_CG5988, CG5988, Dmel\\CG5988, UPD2, Upd-like, Upd2, Upd2/Leptin, cg5988', description='unpaired 2', other_designations='CG5988-PB|Unpaired2|upd homolog|upd2-PB', map_location='17A3-17A3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18240654, end_position_on_the_genomic_accession=18243284, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32806 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32806, CurrentID=0, Status='live', Symbol='CG15059', Aliases='Dmel_ Dmel\\CG15059', description='CG15059 gene product from transcript CG15059-RC', other_designations='CG15059-PB|CG15059-PC|uncharacterized protein', map_location='17A3-17A3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18258551, end_position_on_the_genomic_accession=18259517, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  19835569 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=19835569, CurrentID=0, Status='live', Symbol='CG45116', Aliases='Dmel_ Dmel\\CG45116', description='CG45116 gene product from transcript CG45116-RA', other_designations='CG45116-PA|uncharacterized protein', map_location='79F6-79F6', chromosome='3L', genomic_nucleotide_accession_version='NT_037436.4', start_position_on_the_genomic_accession=22699433, end_position_on_the_genomic_accession=22699870, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32813 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32813, CurrentID=0, Status='live', Symbol='upd1', Aliases='Dmel_CG5993, CG5993, Dmel\\CG5993, OS, Os, UPD, Upd, Upd1, l(1)YC43, l(1)YM55, od, odsy, os, sis-C, sis-c, sisC, sy, unp, upa, upd', description='unpaired 1', other_designations='CG5993-PA|CG5993-PB|CG5993-PC|Unpaired/Out-stretched|outstretched|outstretched small eye|outstretched-smalleye|sisterless c|small-eye|unpaired|upd homolog|upd1-PA|upd1-PB|upd1-PC', map_location='17A5-17A5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18305354, end_position_on_the_genomic_accession=18309291, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32814 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32814, CurrentID=0, Status='live', Symbol='CG6023', Aliases='Dmel_ Dmel\\CG6023', description='CG6023 gene product from transcript CG6023-RA', other_designations='CG6023-PA|CG6023-PC', map_location='17A5-17A5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18314124, end_position_on_the_genomic_accession=18321193, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  32815 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32815, CurrentID=0, Status='live', Symbol='CG6123', Aliases='Dmel_ Dmel\\CG6123', description='CG6123 gene product from transcript CG6123-RB', other_designations='CG6123-PA|CG6123-PB', map_location='17A5-17A6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18322958, end_position_on_the_genomic_accession=18356191, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32816 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32816, CurrentID=0, Status='live', Symbol='CG6106', Aliases='Dmel_ Dmel\\CG6106', description='CG6106 gene product from transcript CG6106-RB', other_designations='CG6106-PA|CG6106-PB', map_location='17A7-17A7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18358881, end_position_on_the_genomic_accession=18362527, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32817 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32817, CurrentID=0, Status='live', Symbol='CrebB', Aliases='Dmel_CG6103, CG6103, CRE-BP, CREB, CREB-B, CREB-b, CREB2, CREB2a, CREB2b, Creb, Creb B 17A, Creb17A, Creb2, Creb2-b, Creb2.b, Creb2b-17A, CrebB-17B, CrebB17-A, DM9, Dmel\\CG6103, S162, dCREB, dCREB-2, dCREB-2a, dCREB-B, dCREB2, dCREB2-a, dCREB2-b, dCREB2a, dCREB2b, dCbz, dCreb2, dCreb2-b, dCrebB2, dcreb2-b, l(1)17Af, CrebB', description='Cyclic-AMP response element binding protein B', other_designations='CG6103-PF|CG6103-PG|CG6103-PI|CG6103-PJ|CG6103-PM|CG6103-PN|CG6103-PO|CG6103-PP|CrebB-PF|CrebB-PG|CrebB-PI|CrebB-PJ|CrebB-PM|CrebB-PN|CrebB-PO|CrebB-PP|Cyclic-AMP response element binding protein B at 17A|Cyclic-AMP response element binding protein B at 17B|activator|blocker|cAMP response element-binding protein|cAMP response-element binding protein|cAMP-regulated enhancer-binding protein|cAMP-response element binding protein|cAMP-response element-binding protein|cyclic AMP response element binding protein|dCREB2|lethal(1)17Af', map_location='17B-17B', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18366357, end_position_on_the_genomic_accession=18377864, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  32818 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32818, CurrentID=0, Status='live', Symbol='por', Aliases='Dmel_CG6205, 15175, CG6205, Dmel\\CG6205, Porc, dmPorc, l(1)17Ac, pocc, por', description='porcupine', other_designations='CG6205-PA|CG6205-PB|CG6205-PC|por-PA|por-PB|por-PC', map_location='1-59 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18377521, end_position_on_the_genomic_accession=18379854, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32819 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32819, CurrentID=0, Status='live', Symbol='CG6179', Aliases='Dmel_ Dmel\\CG6179, NOSIPL', description='CG6179 gene product from transcript CG6179-RA', other_designations='CG6179-PA', map_location='17A9-17A9', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18380082, end_position_on_the_genomic_accession=18381479, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32820 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32820, CurrentID=0, Status='live', Symbol='betaCOP', Aliases='Dmel_CG6223, BcDNA.GH09317, BcDNA:GH09317, Beta Cop, BetaCop, CG6223, COPI, Dmel\\CG6223, bcop, beta-COP, beta-Cop, beta-CopII, betaCop', description='Coat Protein (coatomer) beta', other_designations='CG6223-PA|COPI beta subunit|beta coatomer protein|beta-coatomer protein|betaCOP-PA|betaCop|coat protein (coatomer) beta', map_location='17A9-17A9', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18381549, end_position_on_the_genomic_accession=18385242, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32821 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32821, CurrentID=0, Status='live', Symbol='Tsf1', Aliases='Dmel_CG6186, 143958_at, CG6186, Dmel\\CG6186, TSF1, Tf, Trf, anon-EST:Posey265, lincRNA.S9601, tsf1', description='Transferrin 1', other_designations='CG6186-PA|CG6186-PC|DTAF-transferrin|Transferrin1|Tsf1-PA|Tsf1-PC|transferrin|transferrin 1|transferrin precursor', map_location='17A9-17A9', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18387084, end_position_on_the_genomic_accession=18390344, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  32822 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32822, CurrentID=0, Status='live', Symbol='CG32549', Aliases='Dmel_ 24643014, 24643016, 45555989, 45555998, CG6247, CG6267, CG6278, Dmel\\CG32549', description='CG32549 gene product from transcript CG32549-RD', other_designations='CG32549-PB|CG32549-PD|CG32549-PE|CG32549-PF|CG32549-PG|CG32549-PH|uncharacterized protein', map_location='17A10-17A11', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18390498, end_position_on_the_genomic_accession=18410144, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  32824 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32824, CurrentID=0, Status='live', Symbol='CG15056', Aliases='Dmel_ Dmel\\CG15056', description='CG15056 gene product from transcript CG15056-RA', other_designations='CG15056-PA|uncharacterized protein', map_location='17A11-17A11', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18415415, end_position_on_the_genomic_accession=18416911, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32825 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32825, CurrentID=0, Status='live', Symbol='CG42323', Aliases='Dmel_ CG15055, CG32550, Dmel\\CG42323, Dmel_CG15055, Dmel_CG32550', description='CG42323 gene product from transcript CG42323-RE', other_designations='CG42323-PC|CG42323-PE|uncharacterized protein', map_location='17B1-17B1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18422413, end_position_on_the_genomic_accession=18427001, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  32826 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32826, CurrentID=0, Status='live', Symbol='CG32548', Aliases='Dmel_ CG15051, CG6306, Dmel\\CG32548, anon-WO0140519.88', description='CG32548 gene product from transcript CG32548-RB', other_designations='CG32548-PB|CG32548-PC|uncharacterized protein', map_location='17B1-17B1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18435719, end_position_on_the_genomic_accession=18440581, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32827 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32827, CurrentID=0, Status='live', Symbol='CG6290', Aliases='Dmel_ BcDNA:GH02837, Dmel\\CG6290', description='CG6290 gene product from transcript CG6290-RA', other_designations='CG6290-PA', map_location='17B1-17B1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18437490, end_position_on_the_genomic_accession=18438233, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32831 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32831, CurrentID=0, Status='live', Symbol='Hayan', Aliases='Dmel_CG6361, CG6361, Dmel\\CG6361, SP31, c-SP31', description='CG6361 gene product from transcript CG6361-RB', other_designations='CG6361-PA|CG6361-PB|CG6361-PD|Hayan-PA|Hayan-PB|Hayan-PD|hayan', map_location='17B4-17B5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18479983, end_position_on_the_genomic_accession=18483772, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  32832 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32832, CurrentID=0, Status='live', Symbol='psh', Aliases='Dmel_CG6367, CG6367, Dmel\\CG6367, Psh, SP28, c-SP28', description='persephone', other_designations='CG6367-PA|psh-PA', map_location='17B5-17B5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18484487, end_position_on_the_genomic_accession=18486921, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  32833 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32833, CurrentID=0, Status='live', Symbol='CG15046', Aliases='Dmel_ Dmel\\CG15046', description='CG15046 gene product from transcript CG15046-RA', other_designations='CG15046-PA|uncharacterized protein', map_location='17B5-17B5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18487450, end_position_on_the_genomic_accession=18489620, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32834 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32834, CurrentID=0, Status='live', Symbol='CG15044', Aliases='Dmel_ BcDNA:RE30049, Dmel\\CG15044', description='CG15044 gene product from transcript CG15044-RA', other_designations='CG15044-PA|uncharacterized protein', map_location='17B5-17B5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18491185, end_position_on_the_genomic_accession=18492006, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32835 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32835, CurrentID=0, Status='live', Symbol='CG15043', Aliases='Dmel_ BcDNA:RE41194, Dmel\\CG15043', description='CG15043 gene product from transcript CG15043-RB', other_designations='CG15043-PA|CG15043-PB|uncharacterized protein', map_location='17B5-17B5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18493193, end_position_on_the_genomic_accession=18494168, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32836 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32836, CurrentID=0, Status='live', Symbol='GalNAc-T2', Aliases='Dmel_CG6394, CG6394, Dmel\\CG6394, PGANT7, anon-WO02059370.15, dGalNAc-T2, pgant7', description='UDP-N-acetyl-alpha-D-galactosamine:polypeptide N-acetylgalactosaminyltransferase 2', other_designations='CG6394-PA|CG6394-PB|CG6394-PC|GalNAc-T2-PA|GalNAc-T2-PB|GalNAc-T2-PC|polypeptide GalNAc transferase 7', map_location='17B6-17B6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18495067, end_position_on_the_genomic_accession=18499986, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32837 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32837, CurrentID=0, Status='live', Symbol='Rad51D', Aliases='Dmel_CG6318, CG6318, Dm CG6318, Dmel\\CG6318, dm', description='CG6318 gene product from transcript CG6318-RA', other_designations='CG6318-PA|Rad51D-PA', map_location='17B6-17B6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18500127, end_position_on_the_genomic_accession=18501258, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32838 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32838, CurrentID=0, Status='live', Symbol='Wnt5', Aliases='Dmel_CG6407, CG6407, DWnt-3, DWnt-3/5, DWnt-5, DWnt3, DWnt3/5, DWnt5, Dm DWnt3/5, Dm-3, Dmel\\CG6407, Dwnt-3, Dwnt-5, Dwnt5, WNT5, Wnt, Wnt-3, Wnt3, Wnt3/5, anon-WO03040301.228, wnt3, wnt5', description='Wnt oncogene analog 5', other_designations='CG6407-PA|CG6407-PB|Wnt5-PA|Wnt5-PB|wnt-oncogene-analog-3', map_location='17B6-17C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18501401, end_position_on_the_genomic_accession=18505405, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32839 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32839, CurrentID=0, Status='live', Symbol='Ggt-1', Aliases='Dmel_CG6461, CG6461, Dmel\\CG6461, GGT-1', description='gamma-glutamyl transpeptidase', other_designations='CG6461-PA|CG6461-PB|Ggt-1-PA|Ggt-1-PB|gamma-glutamyl transferase', map_location='17C1-17C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18505883, end_position_on_the_genomic_accession=18512521, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32840 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32840, CurrentID=0, Status='live', Symbol='CG6470', Aliases='Dmel_ Dmel\\CG6470, anon-WO0140519.137', description='CG6470 gene product from transcript CG6470-RB', other_designations='CG6470-PA|CG6470-PB', map_location='17C1-17C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18512829, end_position_on_the_genomic_accession=18514867, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32841 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32841, CurrentID=0, Status='live', Symbol='Aats-his', Aliases='Dmel_CG6335, CG6335, Dmel\\CG6335, HRS, Harsl, HisRS, l(1)G0165, l(1)G0358', description='Histidyl-tRNA synthetase', other_designations='Aats-his-PA|Aats-his-PC|Aats-his-PD|Aats-his-PE|CG6335-PA|CG6335-PC|CG6335-PD|CG6335-PE', map_location='17C1-17C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18515428, end_position_on_the_genomic_accession=18520445, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  32843 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32843, CurrentID=0, Status='live', Symbol='CG6481', Aliases='Dmel_ Dmel\\CG6481', description='CG6481 gene product from transcript CG6481-RA', other_designations='CG6481-PA', map_location='17C1-17C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18521074, end_position_on_the_genomic_accession=18522445, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32844 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32844, CurrentID=0, Status='live', Symbol='CG15042', Aliases='Dmel_ Dmel\\CG15042', description='CG15042 gene product from transcript CG15042-RA', other_designations='CG15042-PA|uncharacterized protein', map_location='17C1-17C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18526862, end_position_on_the_genomic_accession=18528266, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32845 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32845, CurrentID=0, Status='live', Symbol='CG15047', Aliases='Dmel_ Dmel\\CG15047', description='CG15047 gene product from transcript CG15047-RA', other_designations='CG15047-PA|uncharacterized protein', map_location='17C1-17C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18528683, end_position_on_the_genomic_accession=18529593, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32846 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32846, CurrentID=0, Status='live', Symbol='Bx', Aliases='Dmel_CG44425, Bd, CG10548, CG15048, CG44425, CG6500, DLMO, Dlmo, Dmel\\CG44425, Dmel_CG15048, Dmel_CG6500, LMO, Lmo, Ptd, Rho, beadex/dLMO, dLMO, dLmo, dlmo, dttg, fliH, hdp, hdp-a, hld', description='Beadex', other_designations='Bx-PA|Bx-PB|Bx-PC|Bx-PD|Bx-PF|CG44425-PA|CG44425-PB|CG44425-PC|CG44425-PD|CG44425-PF|LIM-only|beadex|flightless-H|held-up|heldup a|pointedoid|rhombotin', map_location='1-59.4 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18515428, end_position_on_the_genomic_accession=18572809, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  2768909 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=2768909, CurrentID=0, Status='live', Symbol='CG15744', Aliases='Dmel_ CT35992, Dmel\\CG15744, Q7KV24_DROME', description='CG15744 gene product from transcript CG15744-RA', other_designations='CG15744-PA|uncharacterized protein', map_location='11E9-11E9', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=13288051, end_position_on_the_genomic_accession=13294433, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32848 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32848, CurrentID=0, Status='live', Symbol='CG15040', Aliases='Dmel_ Dmel\\CG15040', description='CG15040 gene product from transcript CG15040-RA', other_designations='CG15040-PA|uncharacterized protein', map_location='17C5-17C5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18606610, end_position_on_the_genomic_accession=18617589, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32849 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32849, CurrentID=0, Status='live', Symbol='wgn', Aliases='Dmel_CG6531, CG6531, Dmel\\CG6531, TNFR, Wgn, vader', description='wengen', other_designations='CG6531-PA|CG6531-PB|TNF-alpha receptor|wgn-PA|wgn-PB', map_location='17C5-17C6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18624042, end_position_on_the_genomic_accession=18634908, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32850 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32850, CurrentID=0, Status='live', Symbol='Rip11', Aliases='Dmel_CG6606, CG6606, Dmel\\CG6606, dRip11, l(1)G0003, l(1)G0070, l(1)G0092, l(1)G0205, l(1)G0297, l(1)G0434', description='Rab11 interacting protein', other_designations='CG6606-PA|CG6606-PB|CG6606-PC|CG6606-PD|CG6606-PE|Rip11-PA|Rip11-PB|Rip11-PC|Rip11-PD|Rip11-PE|lethal (1) G0003', map_location='17C6-17C7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18635642, end_position_on_the_genomic_accession=18647648, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  32851 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32851, CurrentID=0, Status='live', Symbol='CG6540', Aliases='Dmel_ Dmel\\CG6540, Nup35', description='CG6540 gene product from transcript CG6540-RA', other_designations='CG6540-PA', map_location='17C7-17C7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18648182, end_position_on_the_genomic_accession=18649489, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32852 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32852, CurrentID=0, Status='live', Symbol='CG6617', Aliases='Dmel_ Dmel\\CG6617, anon-EST:Posey180', description='CG6617 gene product from transcript CG6617-RA', other_designations='CG6617-PA', map_location='17C7-17C7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18649396, end_position_on_the_genomic_accession=18650444, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32853 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32853, CurrentID=0, Status='live', Symbol='Ing3', Aliases='Dmel_CG6632, CG6632, Dmel\\CG6632, ING3, dIng3', description='Inhibitor of growth family, member 3', other_designations='CG6632-PA|Ing3-PA|inhibitor of growth family, member 3', map_location='17C7-17C7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18650718, end_position_on_the_genomic_accession=18653091, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32854 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32854, CurrentID=0, Status='live', Symbol='CG6659', Aliases='Dmel_ Dmel\\CG6659', description='CG6659 gene product from transcript CG6659-RA', other_designations='CG6659-PA|CG6659-PB', map_location='17C7-17D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18653392, end_position_on_the_genomic_accession=18657286, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  32855 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32855, CurrentID=0, Status='live', Symbol='fu', Aliases='Dmel_CG6551, CG6551, Dm fu, Dmel\\CG6551, FU, Fu, dFu[mel], l(1)fu, fu', description='fused', other_designations='CG6551-PA|fu-PA', map_location='1-59.5 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18657755, end_position_on_the_genomic_accession=18661204, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32856 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32856, CurrentID=0, Status='live', Symbol='CG6696', Aliases='Dmel_ Dmel\\CG6696', description='CG6696 gene product from transcript CG6696-RA', other_designations='CG6696-PA', map_location='17D1-17D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18660472, end_position_on_the_genomic_accession=18662153, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32857 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32857, CurrentID=0, Status='live', Symbol='phm', Aliases='Dmel_CG6578, 306a1, CG6578, CYP306A1, Cyp306a1, Cyp306a1-Dm, Dmel\\CG6578, PHM, exo, ptm', description='phantom', other_designations='CG6578-PA|CG6578-PB|cytochrome P450|exocephalon|phm-PA|phm-PB', map_location='1-64 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18685766, end_position_on_the_genomic_accession=18688433, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32858 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32858, CurrentID=0, Status='live', Symbol='Cyp18a1', Aliases='Dmel_CG6816, 181H6T, 18a1, CG6816, CT20826, CYP18, CYP18A1-Dm, Cyp18, Cyp18A1, Cyt-P450-17C, CytP450, Dmel\\CG6816, ESTS:181H6T, Eig17-1, P-450, P450, cyp18, cyp18a1', description='Cytochrome P450-18a1', other_designations='CG6816-PA|CG6816-PB|Cyp18a1-PA|Cyp18a1-PB|cytochrome P450 17C|cytochrome P450-18a1', map_location='17D1-17D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18688538, end_position_on_the_genomic_accession=18693042, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  32859 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32859, CurrentID=0, Status='live', Symbol='Cyp308a1', Aliases='Dmel_CG6585, 308a1, CG6585, Dmel\\CG6585', description='CG6585 gene product from transcript CG6585-RA', other_designations='CG6585-PA|Cyp308a1-PA', map_location='17D1-17D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18709865, end_position_on_the_genomic_accession=18711638, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32860 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32860, CurrentID=0, Status='live', Symbol='CCKLR-17D1', Aliases='Dmel_CG42301, CCKLR, CCKLR-D1, CG42301, CG6857, DSK-R2, Dm CG6857, Dmel\\CG42301, Dmel_CG6857, DskR-2, anon-WO0170980.61, anon-WO0170980.62', description='Cholecystokinin-like receptor at 17D1', other_designations='CCK-like receptor at 17D1|CCKLR-17D1-PA|CG42301-PA|cholecystokinin-like receptor', map_location='17D1-17D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18707494, end_position_on_the_genomic_accession=18726572, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32861 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32861, CurrentID=0, Status='live', Symbol='CG6873', Aliases='Dmel_ Dmel\\CG6873, adf', description='CG6873 gene product from transcript CG6873-RA', other_designations='Adf/cofilin-like|CG6873-PA|cofilin homologue', map_location='17D3-17D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18739216, end_position_on_the_genomic_accession=18739895, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32862 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32862, CurrentID=0, Status='live', Symbol='CG12609', Aliases='Dmel_ Dmel\\CG12609', description='CG12609 gene product from transcript CG12609-RB', other_designations='CG12609-PB|uncharacterized protein', map_location='17D3-17D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18746367, end_position_on_the_genomic_accession=18748306, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32864 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32864, CurrentID=0, Status='live', Symbol='CCKLR-17D3', Aliases='Dmel_CG32540, CCKLR-D3, CG32540, CG6861, CG6881, CG6894, DSK-R1, Dmel\\CG32540, DskR-1, anon-WO0131005.21, anon-WO0170980.64, anon-WO0170980.65', description='Cholecystokinin-like receptor at 17D3', other_designations='CCK-like receptor at 17D3|CCKLR-17D3-PB|CG32540-PB|DSK-receptor2|sulfakinin receptor', map_location='17D3-17D4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18764483, end_position_on_the_genomic_accession=18774027, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  32865 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32865, CurrentID=0, Status='live', Symbol='CG6891', Aliases='Dmel_ Dmel\\CG6891', description='CG6891 gene product from transcript CG6891-RA', other_designations='CG6891-PA|CG6891-PB|CG6891-PC', map_location='17D4-17D5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18775228, end_position_on_the_genomic_accession=18781345, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  32866 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32866, CurrentID=0, Status='live', Symbol='CG18259', Aliases='Dmel_ Dmel\\CG18259', description='CG18259 gene product from transcript CG18259-RA', other_designations='CG18259-PA|uncharacterized protein', map_location='17D5-17D5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18781265, end_position_on_the_genomic_accession=18783494, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32869 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32869, CurrentID=0, Status='live', Symbol='CG6961', Aliases='Dmel_ Dmel\\CG6961, cg6961', description='CG6961 gene product from transcript CG6961-RA', other_designations='CG6961-PA', map_location='17D5-17D6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18786142, end_position_on_the_genomic_accession=18788210, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32871 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32871, CurrentID=0, Status='live', Symbol='Atg101', Aliases='Dmel_CG7053, CG7053, Dmel\\CG7053', description='Autophagy-related 101', other_designations='Atg101-PA|Autophagy-specific gene 101|CG7053-PA', map_location='17D6-17D6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18791668, end_position_on_the_genomic_accession=18793517, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32872 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32872, CurrentID=0, Status='live', Symbol='bnb', Aliases='Dmel_CG7088, Bnb, CG7088, Dmel\\CG7088, GAP43, Gap43', description='bangles and beads', other_designations='Bangles-n-beads|CG7088-PA|CG7088-PB|CG7088-PC|CG7088-PD|bnb-PA|bnb-PB|bnb-PC|bnb-PD', map_location='17D6-17D6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18794246, end_position_on_the_genomic_accession=18797687, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32873 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32873, CurrentID=0, Status='live', Symbol='CG7058', Aliases='Dmel_ Dmel\\CG7058', description='CG7058 gene product from transcript CG7058-RB', other_designations='CG7058-PB', map_location='17E1-17E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18806694, end_position_on_the_genomic_accession=18812002, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  32874 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32874, CurrentID=0, Status='live', Symbol='CG42450', Aliases='Dmel_ CG32543, CG7095, Dmel\\CG42450, Dmel_CG32543, Dmel_CG7095', description='CG42450 gene product from transcript CG42450-RB', other_designations='CG42450-PA|CG42450-PB|uncharacterized protein', map_location='17E1-17E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18813297, end_position_on_the_genomic_accession=18830406, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  32875 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32875, CurrentID=0, Status='live', Symbol='CG7101', Aliases='Dmel_ Dmel\\CG7101', description='CG7101 gene product from transcript CG7101-RA', other_designations='CG7101-PA', map_location='17E1-17E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18830591, end_position_on_the_genomic_accession=18832123, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32876 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32876, CurrentID=0, Status='live', Symbol='Pvf1', Aliases='Dmel_CG7103, CG7103, DmVEGF-1, Dmel\\CG7103, EP1624, PVF, PVF1, PVFs, Pvf, VEGF, VEGF2-B, Vegf17E, Vegf17e-a, Vegf17e-b, l(1)G0146, pvf1, vegf1', description='PDGF- and VEGF-related factor 1', other_designations='CG7103-PA|CG7103-PB|CG7103-PC|PDGF (platelet-derived growth factor)- and VEGF (vascular endothelial growth factor)-related factor 1|Pvf1-PA|Pvf1-PB|Pvf1-PC', map_location='17E1-17E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18832682, end_position_on_the_genomic_accession=18842901, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  32877 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32877, CurrentID=0, Status='live', Symbol='CG34422', Aliases='Dmel_ ARID4B, CG7274, CG7282, Dmel\\CG34422, Dmel_CG7274, Dmel_CG7282, Q9VWP3_DROME', description='CG34422 gene product from transcript CG34422-RD', other_designations='CG34422-PC|CG34422-PD|uncharacterized protein', map_location='17E1-17E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18843663, end_position_on_the_genomic_accession=18855858, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  32878 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32878, CurrentID=0, Status='live', Symbol='CG7280', Aliases='Dmel_ Dmel\\CG7280', description='CG7280 gene product from transcript CG7280-RA', other_designations='CG7280-PA', map_location='17E1-17E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18846389, end_position_on_the_genomic_accession=18848566, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32880 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32880, CurrentID=0, Status='live', Symbol='CG7322', Aliases='Dmel_ Dmel\\CG7322', description='CG7322 gene product from transcript CG7322-RA', other_designations='CG7322-PA|CG7322-PB|CG7322-PC', map_location='17E1-17E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18855873, end_position_on_the_genomic_accession=18857757, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32881 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32881, CurrentID=0, Status='live', Symbol='Usp39', Aliases='Dmel_CG7288, CG7288, Dmel\\CG7288, Q9VWP1', description='Ubiquitin specific protease 39', other_designations='CG7288-PA|Usp39-PA|ubiquitin specific protease 39', map_location='17F1-17F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18858203, end_position_on_the_genomic_accession=18860072, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32882 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32882, CurrentID=0, Status='live', Symbol='CG7326', Aliases='Dmel_ Dmel\\CG7326', description='CG7326 gene product from transcript CG7326-RB', other_designations='CG7326-PA|CG7326-PB', map_location='17F1-17F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18861197, end_position_on_the_genomic_accession=18863776, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32885 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32885, CurrentID=0, Status='live', Symbol='CG7332', Aliases='Dmel_ Dmel\\CG7332', description='CG7332 gene product from transcript CG7332-RB', other_designations='CG7332-PA|CG7332-PB', map_location='17F2-17F2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18884513, end_position_on_the_genomic_accession=18888860, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  32886 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32886, CurrentID=0, Status='live', Symbol='CG7358', Aliases='Dmel_ Dmel\\CG7358', description='CG7358 gene product from transcript CG7358-RB', other_designations='CG7358-PA|CG7358-PB|CG7358-PC', map_location='17F2-17F2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18888978, end_position_on_the_genomic_accession=18893636, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  32887 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32887, CurrentID=0, Status='live', Symbol='SdhBL', Aliases='Dmel_CG7349, CG7349, DHSB, Dmel\\CG7349', description='Succinate dehydrogenase, subunit B (iron-sulfur)-like', other_designations='CG7349-PA|CG7349-PC|SdhBL-PA|SdhBL-PC|ferredoxin|succinate dehydrogenase Iron-sulfur protein|succinate dehydrogenase [ubiquinone] iron-sulfur protein|succinate dehydrogenase, subunit B (iron-sulfur)-like', map_location='17F2-17F2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18894446, end_position_on_the_genomic_accession=18896581, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32888 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32888, CurrentID=0, Status='live', Symbol='CG7378', Aliases='Dmel_ BcDNA:RH25447, Dmel\\CG7378, MKP-like', description='CG7378 gene product from transcript CG7378-RC', other_designations='CG7378-PA|CG7378-PB|CG7378-PC|MKP-like', map_location='17F2-17F3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18900410, end_position_on_the_genomic_accession=18911843, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  32889 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32889, CurrentID=0, Status='live', Symbol='CG43759', Aliases='Dmel_ CG12527, CG14188, CG32541, CG42506, Dmel\\CG43759, Dmel_CG32541, Dmel_CG42506, EP(X)1644, LD15404', description='CG43759 gene product from transcript CG43759-RC', other_designations='CG43759-PA|CG43759-PB|CG43759-PC|CG43759-PD|uncharacterized protein', map_location='17F3-18A2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=18930335, end_position_on_the_genomic_accession=19028629, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  32891 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32891, CurrentID=0, Status='live', Symbol='CG14190', Aliases='Dmel_ Dmel\\CG14190', description='CG14190 gene product from transcript CG14190-RA', other_designations='CG14190-PA|uncharacterized protein', map_location='18A2-18A2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19056911, end_position_on_the_genomic_accession=19067792, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32892 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32892, CurrentID=0, Status='live', Symbol='CG7406', Aliases='Dmel_ Dmel\\CG7406', description='CG7406 gene product from transcript CG7406-RA', other_designations='CG7406-PA', map_location='18A3-18A3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19077720, end_position_on_the_genomic_accession=19078592, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32893 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32893, CurrentID=0, Status='live', Symbol='CG14191', Aliases='Dmel_ BcDNA:RE09269, Dmel\\CG14191', description='CG14191 gene product from transcript CG14191-RA', other_designations='CG14191-PA|uncharacterized protein', map_location='18A3-18A3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19081665, end_position_on_the_genomic_accession=19082566, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32894 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32894, CurrentID=0, Status='live', Symbol='CG7423', Aliases='Dmel_ Dmel\\CG7423', description='CG7423 gene product from transcript CG7423-RA', other_designations='CG7423-PA', map_location='18A3-18A3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19082609, end_position_on_the_genomic_accession=19083290, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32895 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32895, CurrentID=0, Status='live', Symbol='CG15882', Aliases='Dmel_ Dmel\\CG15882', description='CG15882 gene product from transcript CG15882-RA', other_designations='CG15882-PA|uncharacterized protein', map_location='18A3-18A3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19123755, end_position_on_the_genomic_accession=19124388, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32896 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32896, CurrentID=0, Status='live', Symbol='tgy', Aliases='Dmel_CG7440, CG7440, Dmel\\CG7440, Tgy, dC1GalT5', description='twiggy', other_designations='CG7440-PC|CG7440-PE|tgy-PC|tgy-PE', map_location='18A3-18A3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19125003, end_position_on_the_genomic_accession=19127316, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32897 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32897, CurrentID=0, Status='live', Symbol='Obp18a', Aliases='Dmel_CG15883, 18a, BcDNA:RH25665, CG15883, DmelObp18a, Dmel\\CG15883, obp18a', description='Odorant-binding protein 18a', other_designations='CG15883-PA|Obp18a-PA', map_location='18A3-18A3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19135081, end_position_on_the_genomic_accession=19135868, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32898 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32898, CurrentID=0, Status='live', Symbol='RhoGAP18B', Aliases='Dmel_CG42274, 5-131, CG17015, CG42274, CG7481, CG7502, CG7531, Dmel\\CG42274, Dmel_CG7481, Dmel_CG7502, whir', description='Rho GTPase activating protein at 18B', other_designations='CG42274-PB|CG42274-PC|CG42274-PD|CG42274-PF|CG42274-PH|RhoGAP18B-PB|RhoGAP18B-PC|RhoGAP18B-PD|RhoGAP18B-PF|RhoGAP18B-PH|white rabbit', map_location='18A3-18A4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19136107, end_position_on_the_genomic_accession=19167082, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  32901 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32901, CurrentID=0, Status='live', Symbol='Inx5', Aliases='Dmel_CG7537, CG7537, Dm-inx5, Dmel\\CG7537, FBpp0074467, inx-5, inx5', description='Innexin 5', other_designations='CG7537-PB|Innexin-5|Inx5-PB|innexin 5|inx5', map_location='18A4-18A4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19168777, end_position_on_the_genomic_accession=19170883, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32902 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32902, CurrentID=0, Status='live', Symbol='CG7556', Aliases='Dmel_ Dmel\\CG7556', description='CG7556 gene product from transcript CG7556-RB', other_designations='CG7556-PA|CG7556-PB', map_location='18A5-18A5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19176109, end_position_on_the_genomic_accession=19179830, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32903 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32903, CurrentID=0, Status='live', Symbol='CG7453', Aliases='Dmel_ Dmel\\CG7453', description='CG7453 gene product from transcript CG7453-RA', other_designations='CG7453-PA', map_location='18A5-18A5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19180173, end_position_on_the_genomic_accession=19182024, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32905 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32905, CurrentID=0, Status='live', Symbol='Mec2', Aliases='Dmel_CG7635, CG7635, D Dmel\\CG7635', description='CG7635 gene product from transcript CG7635-RA', other_designations='CG7635-PA|Mec2-PA', map_location='18A6-18A6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19188035, end_position_on_the_genomic_accession=19190193, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32906 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32906, CurrentID=0, Status='live', Symbol='HP1D3csd', Aliases='Dmel_CG14193, CG14193, Dmel\\CG14193', description='Heterochromatin Protein 1D3 chromoshadow domain', other_designations='CG14193-PA|HP1D3csd-PA|heterochromatin protein 1D3 chromoshadow domain', map_location='18A6-18A7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19190214, end_position_on_the_genomic_accession=19191029, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32907 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32907, CurrentID=0, Status='live', Symbol='CG7914', Aliases='Dmel_ Dmel\\CG7914', description='CG7914 gene product from transcript CG7914-RA', other_designations='CG7914-PA', map_location='18A7-18A7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19192219, end_position_on_the_genomic_accession=19193448, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32908 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32908, CurrentID=0, Status='live', Symbol='CG14194', Aliases='Dmel_ Dmel\\CG14194', description='CG14194 gene product from transcript CG14194-RA', other_designations='CG14194-PA|CG14194-PB|uncharacterized protein', map_location='18A7-18A7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19193555, end_position_on_the_genomic_accession=19196037, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32909 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32909, CurrentID=0, Status='live', Symbol='CG7990', Aliases='Dmel_ Dmel\\CG7990', description='CG7990 gene product from transcript CG7990-RA', other_designations='CG7990-PA|CG7990-PC|CG7990-PD', map_location='18A7-18B1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19196058, end_position_on_the_genomic_accession=19201979, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32910 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32910, CurrentID=0, Status='live', Symbol='Ulp1', Aliases='Dmel_CG12359, BcDNA:GH02751, CG12359, Dm Dmel\\CG12359, ulp1', description='CG12359 gene product from transcript CG12359-RA', other_designations='CG12359-PA|Ulp1-PA|ubiquitin-like protein-specific protease 1', map_location='18B1-18B1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19202103, end_position_on_the_genomic_accession=19208187, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32911 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32911, CurrentID=0, Status='live', Symbol='CG14195', Aliases='Dmel_ Dmel\\CG14195', description='CG14195 gene product from transcript CG14195-RB', other_designations='CG14195-PA|CG14195-PB|uncharacterized protein', map_location='18B1-18B1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19208694, end_position_on_the_genomic_accession=19212082, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  32912 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32912, CurrentID=0, Status='live', Symbol='Mur18B', Aliases='Dmel_CG7874, CG7874, Dmel\\CG7874, anon-WO0140519.120', description='Mucin related 18B', other_designations='CG7874-PA|Mur18B-PA|mucin related 18B', map_location='18B1-18B1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19213254, end_position_on_the_genomic_accession=19214938, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32913 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32913, CurrentID=0, Status='live', Symbol='Muc18B', Aliases='Dmel_CG7876, CG7876, Dmel\\CG7876', description='Mucin 18B', other_designations='CG7876-PA|CG7876-PB|Muc18B-PA|Muc18B-PB|mucin 18B', map_location='18B1-18B1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19215515, end_position_on_the_genomic_accession=19216660, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  5740440 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740440, CurrentID=0, Status='live', Symbol='CG34190', Aliases='Dmel_ Dmel\\CG34190', description='CG34190 gene product from transcript CG34190-RA', other_designations='CG34190-PA|uncharacterized protein', map_location='53E2-53E2', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=16946455, end_position_on_the_genomic_accession=16947554, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32915 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32915, CurrentID=0, Status='live', Symbol='CG14196', Aliases='Dmel_ Dmel\\CG14196', description='CG14196 gene product from transcript CG14196-RA', other_designations='CG14196-PA|uncharacterized protein', map_location='18B4-18B4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19236059, end_position_on_the_genomic_accession=19241840, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  32916 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32916, CurrentID=0, Status='live', Symbol='CG7889', Aliases='Dmel_ Dmel\\CG7889', description='CG7889 gene product from transcript CG7889-RA', other_designations='CG7889-PA', map_location='18B4-18B4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19243631, end_position_on_the_genomic_accession=19245224, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32917 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32917, CurrentID=0, Status='live', Symbol='CG7992', Aliases='Dmel_ Dmel\\CG7992', description='CG7992 gene product from transcript CG7992-RA', other_designations='CG7992-PA', map_location='18B4-18B5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19245158, end_position_on_the_genomic_accession=19247250, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32918 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32918, CurrentID=0, Status='live', Symbol='Hs3st-B', Aliases='Dmel_CG7890, CG7890, Dmel\\CG7890, dHS3OSTB, dHs3st-B', description='Heparan sulfate 3-O sulfotransferase-B', other_designations='3-O-sulfotransferase|CG7890-PA|CG7890-PB|Hs3st-B-PA|Hs3st-B-PB|heparan sulfate 3-O sulfotransferase-B', map_location='18B5-18B6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19248639, end_position_on_the_genomic_accession=19252045, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32919 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32919, CurrentID=0, Status='live', Symbol='rictor', Aliases='Dmel_CG8002, 8002, CG8002, Dmel\\CG8002, Rictor, dRic, dRictor', description='rapamycin-insensitive companion of Tor', other_designations='CG8002-PA|CG8002-PB|CG8002-PC|dRictor|rictor-PA|rictor-PB|rictor-PC', map_location='18B6-18B6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19252111, end_position_on_the_genomic_accession=19261240, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  32920 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32920, CurrentID=0, Status='live', Symbol='Vav', Aliases='Dmel_CG7893, BcDNA:GH01128, CG7893, DmVav, Dmel\\CG7893, DroVav, vav', description='Vav ortholog (H. sapiens)', other_designations='CG7893-PA|CG7893-PB|CG7893-PC|CG7893-PD|Vav ortholog|Vav-PA|Vav-PB|Vav-PC|Vav-PD|vav', map_location='18B6-18B7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19261820, end_position_on_the_genomic_accession=19273280, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  32921 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32921, CurrentID=0, Status='live', Symbol='CG8010', Aliases='Dmel_ Dmel\\CG8010', description='CG8010 gene product from transcript CG8010-RA', other_designations='CG8010-PA', map_location='18B7-18B7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19266656, end_position_on_the_genomic_accession=19268896, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32922 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32922, CurrentID=0, Status='live', Symbol='CG32536', Aliases='Dmel_ CG8020, Dmel\\CG32536', description='CG32536 gene product from transcript CG32536-RA', other_designations='CG32536-PA|uncharacterized protein', map_location='18B8-18B8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19275004, end_position_on_the_genomic_accession=19276898, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32923 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32923, CurrentID=0, Status='live', Symbol='CG8028', Aliases='Dmel_ Dmel\\CG8028, MCT', description='CG8028 gene product from transcript CG8028-RC', other_designations='CG8028-PC|CG8028-PD|monocarboxylate transporter', map_location='18B8-18B9', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19277176, end_position_on_the_genomic_accession=19280349, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  32924 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32924, CurrentID=0, Status='live', Symbol='CG8034', Aliases='Dmel_ Dmel\\CG8034', description='CG8034 gene product from transcript CG8034-RA', other_designations='CG8034-PA|CG8034-PB', map_location='18B9-18C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19281232, end_position_on_the_genomic_accession=19298162, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32925 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32925, CurrentID=0, Status='live', Symbol='CG8051', Aliases='Dmel_ Dmel\\CG8051, EP(X)1550, anon-WO03002137.1', description='CG8051 gene product from transcript CG8051-RA', other_designations='CG8051-PA|CG8051-PB', map_location='18C1-18C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19301330, end_position_on_the_genomic_accession=19307925, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32926 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32926, CurrentID=0, Status='live', Symbol='out', Aliases='Dmel_CG8062, BcDNA:LD28120, CG8062, Dmel\\CG8062', description='outsiders', other_designations='CG8062-PA|CG8062-PB|out-PA|out-PB|outsider', map_location='18C2-18C2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19310513, end_position_on_the_genomic_accession=19322106, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  32928 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32928, CurrentID=0, Status='live', Symbol='nAChRalpha7', Aliases='Dmel_CG32538, CG32538, CG8082, CG8109, CT24218, Da7, Dalpha7, Dalpha7 nAChR, Dalpha7-nAChR, Dmel\\CG32538, gfA, gfa, jpl, nAChR, nAChR-Dalpha7, nAcRalpha-18C, nAcRalpha-7, nj507, nj520, nj522, nj54, nj75', description='nicotinic Acetylcholine Receptor alpha7', other_designations='CG32538-PA|CG32538-PD|CG32538-PE|CG32538-PF|Dalpha7|Dalpha7 subunit of the acetylcholine receptor|Dalpha7 subunit of the nicotinic acetylcholine receptor|giant fiber A|giant fibre A|jumpless|nAChRalpha7-PA|nAChRalpha7-PD|nAChRalpha7-PE|nAChRalpha7-PF|nicotinic acetylcholine receptor alpha 18C|nicotinic acetylcholine receptor alpha7|non-jumper-507|non-jumper-520|non-jumper-522|non-jumper-54|non-jumper-75|shaker cognate L', map_location='1-62 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19327075, end_position_on_the_genomic_accession=19348447, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  32930 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32930, CurrentID=0, Status='live', Symbol='kek5', Aliases='Dmel_CG12199, CG12199, CT10486, Dmel\\CG12199, Kek5', description='kekkon5', other_designations='CG12199-PA|CG12199-PB|CG12199-PC|CG12199-PD|Kekkon5|kek5-PA|kek5-PB|kek5-PC|kek5-PD|kekkon-like', map_location='18C3-18C7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19353181, end_position_on_the_genomic_accession=19471914, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  32932 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32932, CurrentID=0, Status='live', Symbol='CG12200', Aliases='Dmel_ Dmel\\CG12200', description='CG12200 gene product from transcript CG12200-RA', other_designations='CG12200-PA|uncharacterized protein', map_location='18C7-18C7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19475063, end_position_on_the_genomic_accession=19476055, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32933 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32933, CurrentID=0, Status='live', Symbol='CG32533', Aliases='Dmel_ CG12211, CG14198, Dmel\\CG32533, cg12211', description='CG32533 gene product from transcript CG32533-RA', other_designations='CG32533-PA|CG32533-PB|uncharacterized protein', map_location='18C7-18C7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19474156, end_position_on_the_genomic_accession=19479411, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  32934 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32934, CurrentID=0, Status='live', Symbol='Nat1', Aliases='Dmel_CG12202, CG12202, Dmel\\CG12202, dNat1, l(1)G0311', description='NAT1 ortholog (S. cerevisiae)', other_designations='CG12202-PA|CG12202-PB|NAT1 ortholog|Nat1-PA|Nat1-PB', map_location='18C7-18C7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19479984, end_position_on_the_genomic_accession=19484643, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  32935 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32935, CurrentID=0, Status='live', Symbol='pcm', Aliases='Dmel_CG3291, CG3291, DmXrn1, Dmel\\CG3291, Pcm, XRN1, XRN1/pcm, Xrn1, Xrn1p', description='pacman', other_designations='CG3291-PA|CG3291-PB|pcm-PA|pcm-PB', map_location='18C7-18C7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19485759, end_position_on_the_genomic_accession=19492011, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  32936 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32936, CurrentID=0, Status='live', Symbol='ND-18', Aliases='Dmel_CG12203, CG12203, Dmel\\CG12203, IP11020p, NUYM', description='NADH dehydrogenase (ubiquinone) 18 kDa subunit', other_designations='CG12203-PA|FBpp0074481|NADH ubiquinone oxidoreductase 18 kDa|NADH-ubiquinone oxidoreductase 18 kDa subunit|NADH:ubiquinone oxidoreductase 18 kDa subunit|ND-18-PA', map_location='18C7-18C7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19492421, end_position_on_the_genomic_accession=19493337, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32937 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32937, CurrentID=0, Status='live', Symbol='CG12204', Aliases='Dmel_ Dmel\\CG12204', description='CG12204 gene product from transcript CG12204-RA', other_designations='CG12204-PA|uncharacterized protein', map_location='18C7-18C8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19493292, end_position_on_the_genomic_accession=19494401, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32938 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32938, CurrentID=0, Status='live', Symbol='Pfrx', Aliases='Dmel_CG3400, CG3400, Dmel\\CG3400, PFK2', description='6-phosphofructo-2-kinase', other_designations='CG3400-PA|CG3400-PB|CG3400-PD|CG3400-PE|CG3400-PF|CG3400-PG|CG3400-PH|CG3400-PI|CG3400-PJ|CG3400-PK|CG3400-PL|CG3400-PM|CG3400-PN|Pfrx-PA|Pfrx-PB|Pfrx-PD|Pfrx-PE|Pfrx-PF|Pfrx-PG|Pfrx-PH|Pfrx-PI|Pfrx-PJ|Pfrx-PK|Pfrx-PL|Pfrx-PM|Pfrx-PN|fi-phosphofructo-2-kinase|fructose 2,6 bisphosphatase|phosphofructokinase', map_location='18C8-18C8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19495505, end_position_on_the_genomic_accession=19509350, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  32939 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32939, CurrentID=0, Status='live', Symbol='CG14200', Aliases='Dmel_ Dmel\\CG14200', description='CG14200 gene product from transcript CG14200-RA', other_designations='CG14200-PA|CG14200-PB|CG14200-PC|uncharacterized protein', map_location='18C8-18C8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19495505, end_position_on_the_genomic_accession=19518402, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  32940 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32940, CurrentID=0, Status='live', Symbol='l(1)G0156', Aliases='Dmel_CG12233, CG12233, Dmel\\CG12233, FBgn0031024, l (1) G0156', description='lethal (1) G0156', other_designations='CG12233-PA|CG12233-PC|CG12233-PD|Lethal(1)G0156|isocitrate dehydrogenase|l(1)G0156-PA|l(1)G0156-PC|l(1)G0156-PD', map_location='18C8-18C8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19518428, end_position_on_the_genomic_accession=19521810, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32941 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32941, CurrentID=0, Status='live', Symbol='CoRest', Aliases='Dmel_CG42687, BcDNA:GH01486, BcDNA:LD11215, CG32534, CG32535, CG33525, CG3878, CG42687, CoREST, CoRESTG, Dmel\\CG42687, Dmel_CG32534, Dmel_CG33525, dCoREST, i169', description='CG42687 gene product from transcript CG42687-RC', other_designations='CG42687-PA|CG42687-PC|CG42687-PD|CG42687-PE|CG42687-PF|CG42687-PG|CG42687-PH|CG42687-PI|CG42687-PJ|CG42687-PK|CoRest-PA|CoRest-PC|CoRest-PD|CoRest-PE|CoRest-PF|CoRest-PG|CoRest-PH|CoRest-PI|CoRest-PJ|CoRest-PK', map_location='18C8-18C8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19521929, end_position_on_the_genomic_accession=19530896, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  32942 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32942, CurrentID=0, Status='live', Symbol='CG12231', Aliases='Dmel_ Dmel\\CG12231', description='CG12231 gene product from transcript CG12231-RA', other_designations='CG12231-PA|uncharacterized protein', map_location='18C8-18C8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19531032, end_position_on_the_genomic_accession=19531742, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32943 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32943, CurrentID=0, Status='live', Symbol='CG32532', Aliases='Dmel_ CG14201, CG14202, CG14203, Dmel\\CG32532', description='CG32532 gene product from transcript CG32532-RB', other_designations='CG32532-PB|CG32532-PC|CG32532-PD|uncharacterized protein', map_location='18C8-18C8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19531851, end_position_on_the_genomic_accession=19547482, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  32946 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32946, CurrentID=0, Status='live', Symbol='Grip84', Aliases='Dmel_CG3917, CG3917, DGrip84, Dgrip84, Dgrips84, Dmel\\CG3917, GCP2, grip84, l(1)[[t]]PG36, l(1)[[t]]PG66', description='Gamma-tubulin ring protein 84', other_designations='CG3917-PA|CG3917-PB|CG3917-PC|CG3917-PD|CG3917-PE|CG3917-PF|DGrip84|Grip84-PA|Grip84-PB|Grip84-PC|Grip84-PD|Grip84-PE|Grip84-PF|gamma-tubulin ring protein 84', map_location='18D1-18D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19559431, end_position_on_the_genomic_accession=19565764, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32947 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32947, CurrentID=0, Status='live', Symbol='car', Aliases='Dmel_CG12230, CG12230, Car, Dm-Vps33, Dmel\\CG12230, VPS33a, Vps33, Vps33/carnation, Vps33A, Vps33a, Vps33pn, l(1)G0447, car', description='carnation', other_designations='CG12230-PA|CG12230-PB|CG12230-PC|car-PA|car-PB|car-PC|vacuolar protein sorting protein 33', map_location='1-62.5 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19566019, end_position_on_the_genomic_accession=19569401, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32948 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32948, CurrentID=0, Status='live', Symbol='Tao', Aliases='Dmel_CG14217, AAF48973, CG14217, Dmel\\CG14217, MARKK, TAO1-1, dTao-1, tao, tao-1, tao1', description='CG14217 gene product from transcript CG14217-RF', other_designations='CG14217-PA|CG14217-PB|CG14217-PD|CG14217-PE|CG14217-PF|CG14217-PG|CG14217-PH|CG14217-PI|CG14217-PJ|Tao-1|Tao-PA|Tao-PB|Tao-PD|Tao-PE|Tao-PF|Tao-PG|Tao-PH|Tao-PI|Tao-PJ', map_location='18D2-18D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19569721, end_position_on_the_genomic_accession=19579800, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  32949 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32949, CurrentID=0, Status='live', Symbol='CG14218', Aliases='Dmel_ Dmel\\CG14218, SPH211', description='CG14218 gene product from transcript CG14218-RC', other_designations='CG14218-PB|CG14218-PC|uncharacterized protein', map_location='18D3-18D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19580350, end_position_on_the_genomic_accession=19581981, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32950 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32950, CurrentID=0, Status='live', Symbol='CG14204', Aliases='Dmel_ Dmel\\CG14204', description='CG14204 gene product from transcript CG14204-RB', other_designations='CG14204-PA|CG14204-PB|uncharacterized protein', map_location='18D3-18D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19583617, end_position_on_the_genomic_accession=19587057, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  32951 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32951, CurrentID=0, Status='live', Symbol='CG14219', Aliases='Dmel_ Dmel\\CG14219', description='CG14219 gene product from transcript CG14219-RA', other_designations='CG14219-PA|uncharacterized protein', map_location='18D3-18D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19587348, end_position_on_the_genomic_accession=19590170, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  32952 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32952, CurrentID=0, Status='live', Symbol='CG14205', Aliases='Dmel_ Dmel\\CG14205', description='CG14205 gene product from transcript CG14205-RA', other_designations='CG14205-PA|uncharacterized protein', map_location='18D3-18D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19592609, end_position_on_the_genomic_accession=19595548, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  32953 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32953, CurrentID=0, Status='live', Symbol='RpS10b', Aliases='Dmel_CG14206, CG14206, CT33819, Dmel\\CG14206, GM19176, M(1)18C, M(1)36f, M(1)n, M[[n]], Rp S10 b, S10b, i3, i73, l(1)carot13', description='Ribosomal protein S10b', other_designations='CG14206-PB|CG14206-PC|CG14206-PD|CG14206-PE|Minute-n|RpS10b-PB|RpS10b-PC|RpS10b-PD|RpS10b-PE|minute (1) 18C|ribosomal protein S10b', map_location='1-62.7 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19598031, end_position_on_the_genomic_accession=19599806, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32954 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32954, CurrentID=0, Status='live', Symbol='CG14220', Aliases='Dmel_ Dmel\\CG14220, SDS3, Sds3, cg14220', description='CG14220 gene product from transcript CG14220-RB', other_designations='CG14220-PA|CG14220-PB|uncharacterized protein', map_location='18D3-18D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19599803, end_position_on_the_genomic_accession=19601851, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32955 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32955, CurrentID=0, Status='live', Symbol='CG14207', Aliases='Dmel_ Dmel\\CG14207, Hsp20-like protein, HspB8, dHspB8', description='CG14207 gene product from transcript CG14207-RD', other_designations='CG14207-PA|CG14207-PB|CG14207-PC|CG14207-PD|HspB8|small heat shock protein hsp20 family|uncharacterized protein', map_location='18D3-18D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19605199, end_position_on_the_genomic_accession=19611413, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  19835594 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=19835594, CurrentID=0, Status='live', Symbol='CG44815', Aliases='Dmel_ Dmel\\CG44815', description='CG44815 gene product from transcript CG44815-RA', other_designations='CG44815-PA|uncharacterized protein', map_location='8E2-8E2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=9445815, end_position_on_the_genomic_accession=9446212, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32958 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32958, CurrentID=0, Status='live', Symbol='CG14210', Aliases='Dmel_ BcDNA:RE23450, Dmel\\CG14210', description='CG14210 gene product from transcript CG14210-RA', other_designations='CG14210-PA|CG14210-PB|uncharacterized protein', map_location='18D3-18D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19616196, end_position_on_the_genomic_accession=19616825, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32961 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32961, CurrentID=0, Status='live', Symbol='CG14221', Aliases='Dmel_ Dmel\\CG14221', description='CG14221 gene product from transcript CG14221-RC', other_designations='CG14221-PB|CG14221-PC|uncharacterized protein', map_location='18D7-18D7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19618819, end_position_on_the_genomic_accession=19621245, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  32962 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32962, CurrentID=0, Status='live', Symbol='NAA20', Aliases='Dmel_CG14222, CG14222, DmAAF48987, Dmel\\CG14222, dNAA20', description='N(alpha)-acetyltransferase 20', other_designations='CG14222-PA|CG14222-PB|CG14222-PC|CG14222-PD|NAA20 ortholog|NAA20-PA|NAA20-PB|NAA20-PC|NAA20-PD', map_location='18D7-18D7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19621451, end_position_on_the_genomic_accession=19623074, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  32963 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32963, CurrentID=0, Status='live', Symbol='MKP-4', Aliases='Dmel_CG14211, CG14211, DMKP-4, Dmel\\CG14211, Mkp4', description='MAPK Phosphatase 4', other_designations='CG14211-PB|CG14211-PC|MAPK phosphatase 4|MKP-4-PB|MKP-4-PC|MKP-like', map_location='18D7-18D8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19623114, end_position_on_the_genomic_accession=19625729, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  32964 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32964, CurrentID=0, Status='live', Symbol='CG14212', Aliases='Dmel_ 19527979, CG14122, Dmel\\CG14212', description='CG14212 gene product from transcript CG14212-RA', other_designations='CG14212-PA|uncharacterized protein', map_location='18D8-18D8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19625705, end_position_on_the_genomic_accession=19626601, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32965 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32965, CurrentID=0, Status='live', Symbol='e(y)3', Aliases='Dmel_CG12238, CG12238, Dmel\\CG12238, SAYP, e(y)[3], l(1)G0084, l(1)G0266, l(1)G0283, l(1)G0381, l(1)G0409, sayp', description='enhancer of yellow 3', other_designations='CG12238-PA|CG12238-PB|CG12238-PC|CG12238-PD|CG12238-PE|e(y)3-PA|e(y)3-PB|e(y)3-PC|e(y)3-PD|e(y)3-PE|lethal (1) G0084|supporter of activation of yellow protein', map_location='1-62.2 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19626548, end_position_on_the_genomic_accession=19638369, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  32966 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32966, CurrentID=0, Status='live', Symbol='Rcd-1', Aliases='Dmel_CG14213, CAF40, CG14213, Caf40, Dmel\\CG14213, Drcd-1', description='Required for cell differentiation 1 ortholog', other_designations='CG14213-PA|CG14213-PB|CG14213-PC|Rcd-1-PA|Rcd-1-PB|Rcd-1-PC|required for cell differentiation 1|required for cell differentiation 1 ortholog', map_location='18D11-18D11', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19638767, end_position_on_the_genomic_accession=19640746, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  32967 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32967, CurrentID=0, Status='live', Symbol='CG12237', Aliases='Dmel_ 16769716, Dmel\\CG12237', description='CG12237 gene product from transcript CG12237-RA', other_designations='CG12237-PA|uncharacterized protein', map_location='18D11-18D11', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19641191, end_position_on_the_genomic_accession=19642869, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32968 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32968, CurrentID=0, Status='live', Symbol='Sec61gamma', Aliases='Dmel_CG14214, CG14214, Dmel\\CG14214, Sec61', description='Sec61 gamma subunit', other_designations='CG14214-PA|CG14214-PB|CG14214-PC|Sec61gamma-PA|Sec61gamma-PB|Sec61gamma-PC', map_location='18D11-18D12', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19643327, end_position_on_the_genomic_accession=19644518, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  32969 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32969, CurrentID=0, Status='live', Symbol='Arp10', Aliases='Dmel_CG12235, ARP11, Arp11, CG12235, Dmel\\CG12235', description='Actin-related protein 10', other_designations='Arp10-PA|Arp10-PB|Arp11|CG12235-PA|CG12235-PB', map_location='18D12-18D12', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19644531, end_position_on_the_genomic_accession=19646176, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32970 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32970, CurrentID=0, Status='live', Symbol='Ranbp21', Aliases='Dmel_CG12234, CG12234, Dmel\\CG12234, Exp-5, Exp5, RanBP21, dmExp5', description='CG12234 gene product from transcript CG12234-RB', other_designations='CG12234-PA|CG12234-PB|Exportin-5|Ranbp21-PA|Ranbp21-PB|exportin 5', map_location='18D12-18D13', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19646306, end_position_on_the_genomic_accession=19652269, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32971 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32971, CurrentID=0, Status='live', Symbol='CG14215', Aliases='Dmel_ Dmel\\CG14215', description='CG14215 gene product from transcript CG14215-RA', other_designations='CG14215-PA|CG14215-PB|uncharacterized protein', map_location='18D13-18D13', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19652305, end_position_on_the_genomic_accession=19659407, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  32972 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32972, CurrentID=0, Status='live', Symbol='CG14223', Aliases='Dmel_ Dmel\\CG14223', description='CG14223 gene product from transcript CG14223-RA', other_designations='CG14223-PA|CG14223-PB|CG14223-PC|uncharacterized protein', map_location='18D13-18D13', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19659442, end_position_on_the_genomic_accession=19663971, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  32973 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32973, CurrentID=0, Status='live', Symbol='Ssu72', Aliases='Dmel_CG14216, BEST:CK01830, CG14216, Dmel\\CG14216, dSsu72', description='Ssu72 CTD phosphatase', other_designations='CG14216-PA|CG14216-PB|CG14216-PC|Ssu72 ortholog|Ssu72-PA|Ssu72-PB|Ssu72-PC', map_location='18D13-18D13', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19664561, end_position_on_the_genomic_accession=19666866, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32974 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32974, CurrentID=0, Status='live', Symbol='Zw', Aliases='Dmel_CG12529, CG12529, Dmel\\CG12529, G-6-PD, G-6-pdh, G-6PD, G-6pd, G6-PD, G6-pd, G6PD, G6PDH, G6pd, G6pdh, g6pd, zw', description='Zwischenferment', other_designations='CG12529-PA|CG12529-PB|CG12529-PC|Glucose-6-phosphate DH|Zw-PA|Zw-PB|Zw-PC|glucose-6-phosphate 1dehydrogenase|glucose-6-phosphate dehydrogenase|zwischenferment', map_location='1-62.9 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19667252, end_position_on_the_genomic_accession=19672353, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  32975 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32975, CurrentID=0, Status='live', Symbol='et', Aliases='Dmel_CG14225, CG14225, Dmel\\CG14225, ET, lat', description='eye transformer', other_designations='CG14225-PB|CG14225-PC|et-PB|et-PC|latran', map_location='18D13-18D13', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19672312, end_position_on_the_genomic_accession=19675891, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32976 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32976, CurrentID=0, Status='live', Symbol='dome', Aliases='Dmel_CG14226, 142932_at, CG14226, CT33841, DOME, Dmel\\CG14226, Dome, anon-18DEb, l(1)G0217, l(1)G0218, l(1)G0264, l(1)G0282, l(1)G0321, l(1)G0367, l(1)G0405, l(1)G0441, l(1)G0468, mom, vsp', description='domeless', other_designations='CG14226-PA|dome receptor|dome-PA|master of marelle|verstopft', map_location='18D13-18E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19676061, end_position_on_the_genomic_accession=19683518, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32977 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32977, CurrentID=0, Status='live', Symbol='Ubqn', Aliases='Dmel_CG14224, BEST:LD26923, CG14224, Chap, DSK2, Dmel\\CG14224, Dsk2, UBQLN homolog, UBQLN1, anon-18DEa, clone 5.42, dUbqln, dUbqn, ubqn', description='Ubiquilin', other_designations='CG14224-PA|CG14224-PB|Ubqn-PA|Ubqn-PB|ubiquilin|ubiquilin 1', map_location='18E1-18E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19683808, end_position_on_the_genomic_accession=19687658, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32978 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32978, CurrentID=0, Status='live', Symbol='CG14227', Aliases='Dmel_ Dmel\\CG14227, SPH158', description='CG14227 gene product from transcript CG14227-RB', other_designations='CG14227-PB|uncharacterized protein', map_location='18E1-18E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19687791, end_position_on_the_genomic_accession=19688948, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32979 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32979, CurrentID=0, Status='live', Symbol='Mer', Aliases='Dmel_CG14228, BG01543, CG14228, D-Mer, Dmel\\CG14228, Dmerlin, EMR2, Emr2, NF2, mer', description='Merlin', other_designations='BG01543|CG14228-PA|CG14228-PB|D merlin|Ezrin-moesin-radixin-2|Mer-PA|Mer-PB|Merlin/Neurofibromin 2|dmerlin|merlin', map_location='18E1-18E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19689697, end_position_on_the_genomic_accession=19693500, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  32980 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32980, CurrentID=0, Status='live', Symbol='CG14229', Aliases='Dmel_ BcDNA:RE31307, Dmel\\CG14229', description='CG14229 gene product from transcript CG14229-RB', other_designations='CG14229-PA|CG14229-PB|CG14229-PC|uncharacterized protein', map_location='18E1-18E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19693977, end_position_on_the_genomic_accession=19695250, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32981 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32981, CurrentID=0, Status='live', Symbol='Cdc42', Aliases='Dmel_CG12530, CDC42, CG12530Dm, D-CDC42, D-Cdc42, D-cdc42, DCDC42, DCdc42, Dcdc42, Dm Cdc42, DmCDC42, Dmcdc42, Dmel\\CG12530, P40793, cdc42', description='CG12530 gene product from transcript CG12530-RC', other_designations='CG12530-PA|CG12530-PC|CG12530-PD|Cdc42-PA|Cdc42-PC|Cdc42-PD|Cdc42-like', map_location='18E1-18E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19697091, end_position_on_the_genomic_accession=19699938, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32982 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32982, CurrentID=0, Status='live', Symbol='CG14231', Aliases='Dmel_ Dmel\\CG14231', description='CG14231 gene product from transcript CG14231-RB', other_designations='CG14231-PA|CG14231-PB|uncharacterized protein', map_location='18E1-18E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19699820, end_position_on_the_genomic_accession=19701755, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  32983 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32983, CurrentID=0, Status='live', Symbol='CG14232', Aliases='Dmel_ Dmel\\CG14232, anon-18DEc', description='CG14232 gene product from transcript CG14232-RA', other_designations='CG14232-PA|CG14232-PB|uncharacterized protein', map_location='18E1-18E2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19701927, end_position_on_the_genomic_accession=19704259, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32984 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32984, CurrentID=0, Status='live', Symbol='CG14230', Aliases='Dmel_ Dmel\\CG14230, Nol8, anon-18DEe, cg14230, clone 9.42', description='CG14230 gene product from transcript CG14230-RA', other_designations='CG14230-PA|uncharacterized protein', map_location='18E1-18E2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19704176, end_position_on_the_genomic_accession=19706417, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32986 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32986, CurrentID=0, Status='live', Symbol='CG12531', Aliases='Dmel_ Dmel\\CG12531', description='CG12531 gene product from transcript CG12531-RA', other_designations='CG12531-PA|CG12531-PB|uncharacterized protein', map_location='18E3-18E4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19718923, end_position_on_the_genomic_accession=19730199, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  32987 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32987, CurrentID=0, Status='live', Symbol='AP-1-2beta', Aliases='Dmel_CG12532, AP-1/2beta, AP-1beta1, AP-2beta, AP-beta1, AP1beta1, AP2beta2, BAD1, BAP, Bap, Beta-adaptin, CG12532, Dmel\\CG12532, apl1, apl2, bap, beta1/2, cg12532', description='Adaptor Protein complex 1/2, beta subunit', other_designations='AP-1-2beta-PA|CG12532-PA|adaptor protein complex 1/2, beta subunit|beta adaptin|beta adaptin drosophila 1|beta-adaptin', map_location='18E4-18E5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19731004, end_position_on_the_genomic_accession=19734581, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  32988 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32988, CurrentID=0, Status='live', Symbol='CG14234', Aliases='Dmel_ Dmel\\CG14234', description='CG14234 gene product from transcript CG14234-RA', other_designations='CG14234-PA|uncharacterized protein', map_location='18E5-18E5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19735570, end_position_on_the_genomic_accession=19740456, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  32989 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32989, CurrentID=0, Status='live', Symbol='COX6B', Aliases='Dmel_CG14235, CG14235, COXG, CcoVIb, CoVIb, Dmel\\CG14235, VIb', description='Cytochrome c oxidase subunit 6B', other_designations='CG14235-PA|CG14235-PB|CG14235-PC|CG14235-PD|COX6B-PA|COX6B-PB|COX6B-PC|COX6B-PD|cytochrome c oxidase VIb|cytochrome c oxidase polypeptide VIb|cytochrome c oxidase subunit 6B|cytochrome c oxidase subunit VIb|cytochrome c oxidase subunitVIb|subunit VIb', map_location='18E5-18E5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19740537, end_position_on_the_genomic_accession=19744335, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  32990 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32990, CurrentID=0, Status='live', Symbol='parvin', Aliases='Dmel_CG32528, CG12533, CG32528, Dmel\\CG32528', description='CG32528 gene product from transcript CG32528-RB', other_designations='CG32528-PA|CG32528-PB|parvin-PA|parvin-PB', map_location='18E5-18F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19746041, end_position_on_the_genomic_accession=19748458, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32991 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32991, CurrentID=0, Status='live', Symbol='Alr', Aliases='Dmel_CG12534, CG12534, Dmel\\CG12534, alr', description='Augmenter of liver regeneration', other_designations='Alr-PA|Alr-PB|CG12534-PA|CG12534-PB|augmenter of liver regeneration', map_location='18F1-18F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19748314, end_position_on_the_genomic_accession=19750167, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  32992 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32992, CurrentID=0, Status='live', Symbol='Pmp70', Aliases='Dmel_CG12703, CG12703, Dmel\\CG12703, PMP70, i17', description='CG12703 gene product from transcript CG12703-RD', other_designations='CG12703-PA|CG12703-PB|CG12703-PC|CG12703-PD|Pmp70-PA|Pmp70-PB|Pmp70-PC|Pmp70-PD', map_location='18F1-18F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19750770, end_position_on_the_genomic_accession=19759280, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  32993 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32993, CurrentID=0, Status='live', Symbol='CG12702', Aliases='Dmel_ Dmel\\CG12702, lincRNA.1023', description='CG12702 gene product from transcript CG12702-RC', other_designations='CG12702-PA|CG12702-PB|CG12702-PC|uncharacterized protein', map_location='18F1-18F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19759173, end_position_on_the_genomic_accession=19764874, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  32994 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32994, CurrentID=0, Status='live', Symbol='vfl', Aliases='Dmel_CG12701, CG12701, Dmel\\CG12701, EP1344, Vfl, ZLD, Zld, l(1)G0225, l(1)G0353, l(1)G0427, zld', description='vielfaltig', other_designations='CG12701-PA|CG12701-PB|CG12701-PD|CG12701-PF|CG12701-PG|EP1344|ZELDA|lethal (1) G0225|lethal (1) G0353|lethal (1) G0427|vfl-PA|vfl-PB|vfl-PD|vfl-PF|vfl-PG|vielfaltig/Zelda|zinc-finger early drosophila activator', map_location='18F-18F', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19766465, end_position_on_the_genomic_accession=19783548, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  32995 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32995, CurrentID=0, Status='live', Symbol='SkpD', Aliases='Dmel_CG12700, BcDNA:AT18217, CG12700, Dmel\\CG12700, Skp, dskpD, skpD', description='SKP1-related D', other_designations='CG12700-PA|SkpD-PA|skpD', map_location='18F2-18F2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19812729, end_position_on_the_genomic_accession=19813384, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32996 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32996, CurrentID=0, Status='live', Symbol='SkpC', Aliases='Dmel_CG11941, CG11941, Dmel\\CG11941, Skp, dskpC, skpC', description='SKP1-related C', other_designations='CG11941-PA|SkpC-PA|skpC', map_location='18F2-18F2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19816072, end_position_on_the_genomic_accession=19816700, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  32997 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32997, CurrentID=0, Status='live', Symbol='SkpE', Aliases='Dmel_CG11942, CG11942, Dmel\\CG11942, Skp, skpE', description='SKP1-related E', other_designations='CG11942-PA|SkpE-PA|skpE', map_location='18F2-18F2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19823368, end_position_on_the_genomic_accession=19824080, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  32999 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=32999, CurrentID=0, Status='live', Symbol='amn', Aliases='Dmel_CG11937, Amn, CG11937, Dmel\\CG11937, Drm-amn, EP(X)1442, PACAP, PACAP-38, PACAP-like, PACAP38, PACAP38-like, Pacap38, chpd', description='amnesiac', other_designations='CG11937-PA|amn-PA|cheap date|cheapdate|pituitary adenylyl cyclase-activating polypeptide|pituitary adenylyl cyclase-activating polypeptide-like', map_location='18F4-19A2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19886108, end_position_on_the_genomic_accession=19890060, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33000 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33000, CurrentID=0, Status='live', Symbol='Hers', Aliases='Dmel_CG32529, CG11936, CG15619, CG32529, Dmel\\CG32529, HERS', description='Histone gene-specific Epigenetic Repressor in late S phase', other_designations='CG32529-PA|CG32529-PC|CG32529-PD|CG32529-PE|CG32529-PF|CG32529-PG|CG32529-PH|CG32529-PI|Hers-PA|Hers-PC|Hers-PD|Hers-PE|Hers-PF|Hers-PG|Hers-PH|Hers-PI|histone gene-specific epigenetic repressor in late S phase', map_location='18F4-19A2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19866146, end_position_on_the_genomic_accession=19908108, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  33001 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33001, CurrentID=0, Status='live', Symbol='CG15618', Aliases='Dmel_ Dmel\\CG15618', description='CG15618 gene product from transcript CG15618-RB', other_designations='CG15618-PB|CG15618-PC|uncharacterized protein', map_location='18F4-18F4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19859743, end_position_on_the_genomic_accession=19865524, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33002 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33002, CurrentID=0, Status='live', Symbol='Nup205', Aliases='Dmel_CG11943, CG11943, Dmel\\CG11943, Ov4, anon-EST:Posey281, nup205', description='Nucleoporin 205kD', other_designations='CG11943-PA|CG11943-PB|Nup205-PA|Nup205-PB|nucleoporin 205|nucleoporin 205kD', map_location='18F4-18F4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19852214, end_position_on_the_genomic_accession=19859379, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  33003 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33003, CurrentID=0, Status='live', Symbol='pico', Aliases='Dmel_CG11940, BcDNA:LP01106, CG11940, Dmel\\CG11940, Pico, jog', description='CG11940 gene product from transcript CG11940-RB', other_designations='CG11940-PA|CG11940-PB|CG11940-PC|CG11940-PD|john glenn|pico-PA|pico-PB|pico-PC|pico-PD', map_location='18F2-18F4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19830215, end_position_on_the_genomic_accession=19852059, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33004 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33004, CurrentID=0, Status='live', Symbol='CG12655', Aliases='Dmel_ Dmel\\CG12655', description='CG12655 gene product from transcript CG12655-RA', other_designations='CG12655-PA|uncharacterized protein', map_location='19A3-19A3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19958393, end_position_on_the_genomic_accession=19959403, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33005 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33005, CurrentID=0, Status='live', Symbol='Nep3', Aliases='Dmel_CG9565, CEC, CG9565, DmeNEP3, Dmel\\CG9565, NEP3, dNEP3, nep3', description='Neprilysin 3', other_designations='CG9565-PA|CG9565-PB|CG9565-PC|Nep3-PA|Nep3-PB|Nep3-PC|neprilysin 3', map_location='19A3-19A3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=19961297, end_position_on_the_genomic_accession=19969323, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  33006 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33006, CurrentID=0, Status='live', Symbol='CG17003', Aliases='Dmel_ Dmel\\CG17003', description='CG17003 gene product from transcript CG17003-RA', other_designations='CG17003-PA|uncharacterized protein', map_location='19A4-19A4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20000968, end_position_on_the_genomic_accession=20002096, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33007 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33007, CurrentID=0, Status='live', Symbol='Dop2R', Aliases='Dmel_CG33517, CG17004, CG33517, CG9569, D2R, DD2R, Dmel\\CG33517, anon-WO0170980.130, anon-WO0170980.131, anon-WO0170980.31, anon-WO0170980.32, dD2R', description='Dopamine 2-like receptor', other_designations='CG33517-PB|CG33517-PF|CG33517-PG|CG33517-PH|CG33517-PI|CG33517-PJ|D2-like receptor|D[[2]] receptor|D[[2]]-like receptor|Dop2R-PB|Dop2R-PF|Dop2R-PG|Dop2R-PH|Dop2R-PI|Dop2R-PJ|dopamine 2-like receptor|dopamine D2 receptor', map_location='19A4-19A6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20004680, end_position_on_the_genomic_accession=20062706, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  33009 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33009, CurrentID=0, Status='live', Symbol='CG9570', Aliases='Dmel_ Dmel\\CG9570', description='CG9570 gene product from transcript CG9570-RA', other_designations='CG9570-PA', map_location='19A6-19A6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20051294, end_position_on_the_genomic_accession=20052519, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33010 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33010, CurrentID=0, Status='live', Symbol='fd19B', Aliases='Dmel_CG9571, CG9571, Dmcg9571, Dmel\\CG9571', description='forkhead domain 19B', other_designations='CG9571-PA|fd19B-PA', map_location='19B1-19B1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20091428, end_position_on_the_genomic_accession=20092408, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33011 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33011, CurrentID=0, Status='live', Symbol='CG34331', Aliases='Dmel_ Dmel\\CG34331', description='CG34331 gene product from transcript CG34331-RC', other_designations='CG34331-PB|CG34331-PC|uncharacterized protein', map_location='19B1-19B1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20122453, end_position_on_the_genomic_accession=20125271, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33012 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33012, CurrentID=0, Status='live', Symbol='CG15322', Aliases='Dmel_ Dmel\\CG15322', description='CG15322 gene product from transcript CG15322-RC', other_designations='CG15322-PB|CG15322-PC|uncharacterized protein', map_location='19B3-19B3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20133579, end_position_on_the_genomic_accession=20138878, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33013 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33013, CurrentID=0, Status='live', Symbol='CG9572', Aliases='Dmel_ CT17356, Dmel\\CG9572', description='CG9572 gene product from transcript CG9572-RA', other_designations='CG9572-PA|CG9572-PB|CG9572-PD', map_location='19B3-19B3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20148124, end_position_on_the_genomic_accession=20155514, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33014 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33014, CurrentID=0, Status='live', Symbol='Rab35', Aliases='Dmel_CG9575, CG9575, D DmRab35, Dmel\\CG9575, Q95RH7, dRab35, rab35', description='CG9575 gene product from transcript CG9575-RD', other_designations='CG9575-PA|CG9575-PB|CG9575-PC|CG9575-PD|Rab35-PA|Rab35-PB|Rab35-PC|Rab35-PD', map_location='19B3-19B3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20155766, end_position_on_the_genomic_accession=20159872, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33015 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33015, CurrentID=0, Status='live', Symbol='Phf7', Aliases='Dmel_CG9576, CG9576, Dmel\\CG9576', description='PHD finger protein 7 ortholog', other_designations='CG9576-PA|CG9576-PB|CG9576-PC|Phf7-PA|Phf7-PB|Phf7-PC', map_location='19B3-19C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20160355, end_position_on_the_genomic_accession=20165830, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33016 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33016, CurrentID=0, Status='live', Symbol='CG9577', Aliases='Dmel_ Dmel\\CG9577', description='CG9577 gene product from transcript CG9577-RA', other_designations='CG9577-PA', map_location='19C1-19C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20166673, end_position_on_the_genomic_accession=20168080, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33017 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33017, CurrentID=0, Status='live', Symbol='CG9581', Aliases='Dmel_ Dmel\\CG9581', description='CG9581 gene product from transcript CG9581-RA', other_designations='CG9581-PA', map_location='19C1-19C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20168042, end_position_on_the_genomic_accession=20169981, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33018 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33018, CurrentID=0, Status='live', Symbol='CG9578', Aliases='Dmel_ Dmel\\CG9578', description='CG9578 gene product from transcript CG9578-RA', other_designations='CG9578-PA', map_location='19C1-19C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20170222, end_position_on_the_genomic_accession=20171526, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33019 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33019, CurrentID=0, Status='live', Symbol='AnxB10', Aliases='Dmel_CG9579, ANXB10, Ann, AnnX, Annx, CG9579, Dmel\\CG9579, annexin, anxX', description='Annexin B10', other_designations='AnxB10-PA|AnxB10-PB|CG9579-PA|CG9579-PB|annexin B10|annexin X', map_location='19C1-19C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20171445, end_position_on_the_genomic_accession=20173514, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33022 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33022, CurrentID=0, Status='live', Symbol='obst-A', Aliases='Dmel_CG17052, CG17052, Dmel\\CG17052, obst', description='obstructor-A', other_designations='CG17052-PA|CG17052-PB|Obstructor-A|obst-A-PA|obst-A-PB|obstructor', map_location='19C1-19C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20239855, end_position_on_the_genomic_accession=20243209, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33023 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33023, CurrentID=0, Status='live', Symbol='Peritrophin-A', Aliases='Dmel_CG17058, CG17058, CG31559, Dmel\\CG17058, PeriA, obst-D', description='Peritrophin A', other_designations='CG17058-PA|CG17058-PB|CG17058-PC|Dm-peritrophin-A|Peritrophin-A-PA|Peritrophin-A-PB|Peritrophin-A-PC|peritrophin A', map_location='19C1-19C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20244647, end_position_on_the_genomic_accession=20248203, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33024 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33024, CurrentID=0, Status='live', Symbol='CG17068', Aliases='Dmel_ Dmel\\CG17068', description='CG17068 gene product from transcript CG17068-RA', other_designations='CG17068-PA|uncharacterized protein', map_location='19C1-19C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20248309, end_position_on_the_genomic_accession=20251093, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33025 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33025, CurrentID=0, Status='live', Symbol='Rab10', Aliases='Dmel_CG17060, AAF50924, CG17060, DRAB10, D DmRab10, Dmel\\CG17060, O15971, Rab-r10, rab10', description='CG17060 gene product from transcript CG17060-RA', other_designations='CG17060-PA|Rab-protein 10|Rab10-PA', map_location='19C1-19C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20251338, end_position_on_the_genomic_accession=20254691, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33026 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33026, CurrentID=0, Status='live', Symbol='CG17065', Aliases='Dmel_ Dmel\\CG17065', description='CG17065 gene product from transcript CG17065-RD', other_designations='CG17065-PA|CG17065-PB|CG17065-PD|uncharacterized protein', map_location='19C1-19C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20254692, end_position_on_the_genomic_accession=20257199, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33027 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33027, CurrentID=0, Status='live', Symbol='Inx7', Aliases='Dmel_CG2977, CG2977, CG32731, D-inx-7, Dm-inx7, Dmel\\CG2977, FBpp0070994, inx-7, inx7, prp7', description='Innexin 7', other_designations='CG2977-PA|Inx7-PA|innexin 7|innexin7|pas related protein 7', map_location='6E4-6E4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=6991612, end_position_on_the_genomic_accession=6993612, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33028 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33028, CurrentID=0, Status='live', Symbol='CG1504', Aliases='Dmel_ 1504, CT3673, Dmel\\CG1504', description='CG1504 gene product from transcript CG1504-RE', other_designations='CG1504-PB|CG1504-PC|CG1504-PD|CG1504-PE', map_location='19C3-19C4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20302015, end_position_on_the_genomic_accession=20330372, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33029 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33029, CurrentID=0, Status='live', Symbol='CG1631', Aliases='Dmel_ Dmel\\CG1631', description='CG1631 gene product from transcript CG1631-RA', other_designations='CG1631-PA', map_location='19C4-19C4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20327444, end_position_on_the_genomic_accession=20328680, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33031 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33031, CurrentID=0, Status='live', Symbol='CG12679', Aliases='Dmel_ Dmel\\CG12679', description='CG12679 gene product from transcript CG12679-RA', other_designations='CG12679-PA|uncharacterized protein', map_location='19C5-19C5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20375764, end_position_on_the_genomic_accession=20376522, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33032 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33032, CurrentID=0, Status='live', Symbol='jb', Aliases='Dmel_CG15460, CG15460, Dmel\\CG15460', description='jean-baptiste', other_designations='CG15460-PC|jb-PC', map_location='19C5-19C5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20390096, end_position_on_the_genomic_accession=20390806, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33033 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33033, CurrentID=0, Status='live', Symbol='l(1)G0004', Aliases='Dmel_CG11738, CG11738, Dmel\\CG11738, l(G0004)', description='lethal (1) G0004', other_designations='CG11738-PA|l(1)G0004-PA', map_location='19C5-19C6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20391447, end_position_on_the_genomic_accession=20392401, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33034 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33034, CurrentID=0, Status='live', Symbol='Syx16', Aliases='Dmel_CG1467, CG1467, Dm Syx16, DmSyx16, Dmel\\CG1467, SYX16, Syx, dSyx 16, dSyx16', description='Syntaxin 16', other_designations='CG1467-PA|Syntaxin16|Syx16-PA|dSyntaxin16|syntaxin|syntaxin 16', map_location='19C6-19C6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20392334, end_position_on_the_genomic_accession=20393751, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33035 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33035, CurrentID=0, Status='live', Symbol='HERC2', Aliases='Dmel_CG11734, AF189221.1, CG11734, Dmel\\CG11734', description='HECT and RLD domain containing protein 2', other_designations='CG11734-PC|HECT and RLD domain containing protein 2 ortholog|HERC2-PC', map_location='19C6-19C6', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20394395, end_position_on_the_genomic_accession=20412247, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  33036 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33036, CurrentID=0, Status='live', Symbol='CG15459', Aliases='Dmel_ Dmel\\CG15459', description='CG15459 gene product from transcript CG15459-RA', other_designations='CG15459-PA|uncharacterized protein', map_location='19C6-19D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20412341, end_position_on_the_genomic_accession=20413581, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33037 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33037, CurrentID=0, Status='live', Symbol='Obp19a', Aliases='Dmel_CG11748, 19a, CG11748, DmelObp19a, Dmel\\CG11748, OBP19a', description='Odorant-binding protein 19a', other_designations='CG11748-PC|Obp19a-PC', map_location='19D1-19D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20415744, end_position_on_the_genomic_accession=20416521, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33038 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33038, CurrentID=0, Status='live', Symbol='Obp19b', Aliases='Dmel_CG1670, 19b, CG1670, DmelObp19b, Dmel\\CG1670, anon-WO0140519.23, o19b', description='Odorant-binding protein 19b', other_designations='CG1670-PA|Obp19b-PA', map_location='19D1-19D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20416733, end_position_on_the_genomic_accession=20417812, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33039 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33039, CurrentID=0, Status='live', Symbol='Obp19c', Aliases='Dmel_CG15457, 19c, CG15457, DmelObp19c, Dmel\\CG15457', description='Odorant-binding protein 19c', other_designations='CG15457-PA|CG15457-PC|Obp19c-PA|Obp19c-PC|odorant binding protein 19c', map_location='19D1-19D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20417921, end_position_on_the_genomic_accession=20418964, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33040 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33040, CurrentID=0, Status='live', Symbol='Obp19d', Aliases='Dmel_CG1668, 19d, BcDNA:HL07789, BcDNA:RH68082, CG1668, DmelObp19d, Dmel\\CG1668, PB-PRP2, PBP2, PBPRP-2, PBPRP2, Pbprp2, pbprp-2, pbprp2', description='Odorant-binding protein 19d', other_designations='CG1668-PA|CG1668-PB|Obp19d-PA|Obp19d-PB|Pheromone-binding protein-related protein 2', map_location='19D1-19D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20419613, end_position_on_the_genomic_accession=20420979, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33043 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33043, CurrentID=0, Status='live', Symbol='cactin', Aliases='Dmel_CG1676, CG1676, Cactin, Dmel\\CG1676', description='CG1676 gene product from transcript CG1676-RB', other_designations='CG1676-PB|cactin-PB', map_location='19D1-19D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20424069, end_position_on_the_genomic_accession=20426402, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33044 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33044, CurrentID=0, Status='live', Symbol='CG11710', Aliases='Dmel_ Dmel\\CG11710', description='CG11710 gene product from transcript CG11710-RC', other_designations='CG11710-PA|CG11710-PB|CG11710-PC|uncharacterized protein', map_location='19D1-19D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20427411, end_position_on_the_genomic_accession=20429673, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33045 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33045, CurrentID=0, Status='live', Symbol='mal', Aliases='Dmel_CG1692, 5, CG1692, Dmel\\CG1692, SRF, bz, ma-l', description='maroon-like', other_designations='CG1692-PA|CG1692-PB|bronzy|mal-PA|mal-PB|maroonlike|section 5', map_location='1-64.8 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20429675, end_position_on_the_genomic_accession=20433210, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33046 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33046, CurrentID=0, Status='live', Symbol='CG1695', Aliases='Dmel_ Dmel\\CG1695', description='CG1695 gene product from transcript CG1695-RC', other_designations='CG1695-PC', map_location='19D1-19D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20433950, end_position_on_the_genomic_accession=20445599, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33047 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33047, CurrentID=0, Status='live', Symbol='GstT3', Aliases='Dmel_CG1702, CG1702, Dmel\\CG1702, GSTT3, cg1702, gstt3', description='Glutathione S transferase T3', other_designations='CG1702-PA|CG1702-PB|CG1702-PC|GstT3-PA|GstT3-PB|GstT3-PC|glutathione S transferase T3', map_location='19D1-19D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20467455, end_position_on_the_genomic_accession=20469796, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33048 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33048, CurrentID=0, Status='live', Symbol='RhoGAP19D', Aliases='Dmel_CG1412, 1412, CG1412, Dmel\\CG1412', description='Rho GTPase activating protein at 19D', other_designations='CG1412-PA|CG1412-PB|CG1412-PC|CG1412-PD|CG1412-PE|RhoGAP19D-PA|RhoGAP19D-PB|RhoGAP19D-PC|RhoGAP19D-PD|RhoGAP19D-PE', map_location='19D1-19D2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20469955, end_position_on_the_genomic_accession=20510694, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  33049 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33049, CurrentID=0, Status='live', Symbol='CG1812', Aliases='Dmel_ Dmel\\CG1812', description='CG1812 gene product from transcript CG1812-RA', other_designations='CG1812-PA', map_location='19D2-19D2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20511544, end_position_on_the_genomic_accession=20515828, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33051 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33051, CurrentID=0, Status='live', Symbol='RunxB', Aliases='Dmel_CG42267, CG15454, CG15455, CG42267, Dmel\\CG42267, Dmel_CG15454, Dmel_CG15455', description='CG42267 gene product from transcript CG42267-RC', other_designations='CG42267-PC|RunxB-PC', map_location='19D3-19D3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20538497, end_position_on_the_genomic_accession=20567097, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33056 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33056, CurrentID=0, Status='live', Symbol='Cyp6v1', Aliases='Dmel_CG1829, 6v1, CG1829, Dmel\\CG1829', description='CG1829 gene product from transcript CG1829-RB', other_designations='CG1829-PA|CG1829-PB|CG1829-PC|Cyp6v1-PA|Cyp6v1-PB|Cyp6v1-PC|cytochrome P450', map_location='19E1-19E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20657122, end_position_on_the_genomic_accession=20661425, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33057 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33057, CurrentID=0, Status='live', Symbol='CG1835', Aliases='Dmel_ BcDNA:GH25431, Dmel\\CG1835, anon-WO0140519.219', description='CG1835 gene product from transcript CG1835-RC', other_designations='CG1835-PA|CG1835-PC', map_location='19E1-19E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20661917, end_position_on_the_genomic_accession=20669669, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33058 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33058, CurrentID=0, Status='live', Symbol='hydra', Aliases='Dmel_CG1338, CG1338, Dmel\\CG1338', description='CG1338 gene product from transcript CG1338-RA', other_designations='CG1338-PA|CG1338-PB|CG1338-PD|CG1338-PF|CG1338-PG|CG1338-PH|CG1338-PI|CG1338-PJ|hydra-PA|hydra-PB|hydra-PD|hydra-PF|hydra-PG|hydra-PH|hydra-PI|hydra-PJ', map_location='19E1-19E1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20670832, end_position_on_the_genomic_accession=20677063, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  33059 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33059, CurrentID=0, Status='live', Symbol='run', Aliases='Dmel_CG1849, 1, 2, AA33, CG1849, Dmel\\CG1849, LB5, P235, RUN, Rnt, Run, Runt, l(1)19Ea, l(1)AA33, l(1)B2/13.1, l(1)LB9, lLB5, leg', description='runt', other_designations='CG1849-PA|CG1849-PB|CG1849-PC|legless|run-PA|run-PB|run-PC|section 1|section 2', map_location='1-65 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20690670, end_position_on_the_genomic_accession=20697321, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33060 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33060, CurrentID=0, Status='live', Symbol='CG1324', Aliases='Dmel_ Dmel\\CG1324, anon-WO0140519.192', description='CG1324 gene product from transcript CG1324-RC', other_designations='CG1324-PA|CG1324-PC', map_location='19E2-19E2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20734455, end_position_on_the_genomic_accession=20735960, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33061 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33061, CurrentID=0, Status='live', Symbol='CG15452', Aliases='Dmel_ Dmel\\CG15452', description='CG15452 gene product from transcript CG15452-RA', other_designations='CG15452-PA|uncharacterized protein', map_location='19E2-19E2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20744965, end_position_on_the_genomic_accession=20745965, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33062 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33062, CurrentID=0, Status='live', Symbol='shakB', Aliases='Dmel_CG34358, 2, 3, 6, CG12678, CG1321, CG15451, CG32508, CG34358, Dmel\\CG34358, Dmel_CG12678, Dmel_CG32508, E81, FBpp0111481, Pas, R-9-29, R9-29, Shak B, Shak-B, ShakB, W3, inx8, l(1)19Eb, l(1)LB21, l(1)R-10-14, l(1)R-10-3, l(1)R-10-7, l(1)R-9-29, l(1)TH73, l(1)W3, l(1)W3b, lincRNA.1031, nj-156, nj156, pas, pass, shB, shak-B, shkB', description='shaking B', other_designations='CG34358-PA|CG34358-PC|CG34358-PD|CG34358-PE|CG34358-PF|CG34358-PG|CG34358-PH|CG34358-PI|Shaking-B|non-jumper-156|passover|passover-vital protein|section 2|section 3|section 6|shakB-PA|shakB-PC|shakB-PD|shakB-PE|shakB-PF|shakB-PG|shakB-PH|shakB-PI', map_location='19E3-19E5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20761071, end_position_on_the_genomic_accession=20927050, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  33064 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33064, CurrentID=0, Status='live', Symbol='CG15450', Aliases='Dmel_ Dmel\\CG15450', description='CG15450 gene product from transcript CG15450-RA', other_designations='CG15450-PA|uncharacterized protein', map_location='19E3-19E3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20822146, end_position_on_the_genomic_accession=20825641, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33066 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33066, CurrentID=0, Status='live', Symbol='CG1314', Aliases='Dmel_ Dmel\\CG1314, anon-WO0140519.251', description='CG1314 gene product from transcript CG1314-RA', other_designations='CG1314-PA', map_location='19E4-19E4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20867989, end_position_on_the_genomic_accession=20869397, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33068 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33068, CurrentID=0, Status='live', Symbol='I-3', Aliases='Dmel_CG42707, CG11233, CG42707, Dmel\\CG42707, Dmel_CG11233', description='Inhibitor-3', other_designations='CG42707-PB|I-3-PB', map_location='19E4-19E4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20881814, end_position_on_the_genomic_accession=20882626, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33071 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33071, CurrentID=0, Status='live', Symbol='CG11227', Aliases='Dmel_ Dmel\\CG11227', description='CG11227 gene product from transcript CG11227-RC', other_designations='CG11227-PA|CG11227-PB|CG11227-PC|uncharacterized protein', map_location='19E5-19E5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20930972, end_position_on_the_genomic_accession=20933559, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33072 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33072, CurrentID=0, Status='live', Symbol='Npc1b', Aliases='Dmel_CG12092, 151, 4, 7, AF2/19, CG12092, Dmel\\CG12092, Dmel_CG11233, NPC1b, Q256, R-9-28, R9-28, dncp1b, l(1)19Ec, l(1)2-3, l(1)R-9-28, l151, l152, lN5, lt2-14a, npc1b', description='Niemann-Pick type C-1b', other_designations='CG12092-PA|NPC1b|Niemann-Pick|Npc1b-PA|lethal (1) 19Ec|section 4|section 7', map_location='19E5-19E5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20934869, end_position_on_the_genomic_accession=20939503, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33073 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33073, CurrentID=0, Status='live', Symbol='Ser6', Aliases='Dmel_CG2071, CG2071, Dmel\\CG2071, SP47', description='Serine protease 6', other_designations='CG2071-PA|Ser6-PA|serine protease 6', map_location='19E5-19E5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20962605, end_position_on_the_genomic_accession=20963505, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33074 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33074, CurrentID=0, Status='live', Symbol='CG1304', Aliases='Dmel_ Dmel\\CG1304, SP46', description='CG1304 gene product from transcript CG1304-RA', other_designations='CG1304-PA', map_location='19E5-19E5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=20964527, end_position_on_the_genomic_accession=20965419, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33075 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33075, CurrentID=0, Status='live', Symbol='r-cup', Aliases='Dmel_CG10998, CG10998, Dmel\\CG10998', description='ryder cup', other_designations='CG10998-PA|r-cup-PA|ryder-cup', map_location='19E7-19E7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21023390, end_position_on_the_genomic_accession=21025888, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33076 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33076, CurrentID=0, Status='live', Symbol='CG1532', Aliases='Dmel_ Dmel\\CG1532', description='CG1532 gene product from transcript CG1532-RB', other_designations='CG1532-PA|CG1532-PB', map_location='19E7-19E7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21026125, end_position_on_the_genomic_accession=21028361, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33077 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33077, CurrentID=0, Status='live', Symbol='CG1529', Aliases='Dmel_ Dmel\\CG1529', description='CG1529 gene product from transcript CG1529-RD', other_designations='CG1529-PA|CG1529-PC|CG1529-PD', map_location='19E7-19E7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21028652, end_position_on_the_genomic_accession=21031950, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33078 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33078, CurrentID=0, Status='live', Symbol='Ntf-2', Aliases='Dmel_CG1740, BcDNA:GM08921, CG1740, DNTF-2, Dmel\\CG1740, Dntf-2, Dntf2, NTF-2, Ntf2, dmNTF2, l(1)G0086, l(1)G0125, l(1)G0337, l(1)G0428, ntf-2, ntf2', description='Nuclear transport factor-2', other_designations='CG1740-PA|CG1740-PB|CG1740-PC|CG1740-PE|Ntf-2-PA|Ntf-2-PB|Ntf-2-PC|Ntf-2-PE|nuclear transport factor-2', map_location='19E7-19E7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21035469, end_position_on_the_genomic_accession=21041467, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33079 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33079, CurrentID=0, Status='live', Symbol='CG15449', Aliases='Dmel_ Dmel\\CG15449', description='CG15449 gene product from transcript CG15449-RA', other_designations='CG15449-PA|uncharacterized protein', map_location='19E7-19E7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21039514, end_position_on_the_genomic_accession=21040605, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33081 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33081, CurrentID=0, Status='live', Symbol='Cbs', Aliases='Dmel_CG1753, CBS, CG1753, DmCBS, Dmel\\CG1753, dCBS', description='Cystathionine beta-synthase', other_designations='CG1753-PA|CG1753-PB|CG1753-PC|Cbs-PA|Cbs-PB|Cbs-PC|cystathionine &bgr-synthase|cystathionine &grb;-synthase|cystathionine beta-synthase', map_location='19E7-19E7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21045138, end_position_on_the_genomic_accession=21049096, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33082 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33082, CurrentID=0, Status='live', Symbol='CG1518', Aliases='Dmel_ Dmel\\CG1518, STT', description='CG1518 gene product from transcript CG1518-RC', other_designations='CG1518-PA|CG1518-PC', map_location='19E7-19E7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21049885, end_position_on_the_genomic_accession=21053937, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33083 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33083, CurrentID=0, Status='live', Symbol='bves', Aliases='Dmel_CG32513, BcDNA:SD21670, CG15448, CG1754, CG32513, Dmel\\CG32513', description='CG32513 gene product from transcript CG32513-RA', other_designations='CG32513-PA|CG32513-PB|CG32513-PC|CG32513-PD|bves-PA|bves-PB|bves-PC|bves-PD', map_location='19E7-19E8', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21053963, end_position_on_the_genomic_accession=21082391, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  33085 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33085, CurrentID=0, Status='live', Symbol='CG32512', Aliases='Dmel_ CG15447, CG1739, Dmel\\CG32512', description='CG32512 gene product from transcript CG32512-RD', other_designations='CG32512-PA|CG32512-PB|CG32512-PC|CG32512-PD|uncharacterized protein', map_location='19E7-19E7', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21062277, end_position_on_the_genomic_accession=21067540, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33088 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33088, CurrentID=0, Status='live', Symbol='CG15446', Aliases='Dmel_ Dmel\\CG15446', description='CG15446 gene product from transcript CG15446-RD', other_designations='CG15446-PB|CG15446-PC|CG15446-PD|uncharacterized protein', map_location='19F1-19F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21095680, end_position_on_the_genomic_accession=21102206, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33090 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33090, CurrentID=0, Status='live', Symbol='CG1503', Aliases='Dmel_ Dmel\\CG1503', description='CG1503 gene product from transcript CG1503-RB', other_designations='CG1503-PA|CG1503-PB', map_location='19F1-19F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21104695, end_position_on_the_genomic_accession=21106369, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33093 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33093, CurrentID=0, Status='live', Symbol='unc', Aliases='Dmel_CG1501, 3, 4, 5, CG1501, Dmel\\CG1501, UNC, Unc, W5, l(1)19Ef, l(1)6-3-212, lLV7', description='uncoordinated', other_designations='CG1501-PA|CG1501-PB|section 3|section 4|section 5|unc-PA|unc-PB', map_location='19F1-19F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21111414, end_position_on_the_genomic_accession=21116914, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33094 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33094, CurrentID=0, Status='live', Symbol='CG15445', Aliases='Dmel_ Dmel\\CG15445, NUB1', description='CG15445 gene product from transcript CG15445-RA', other_designations='CG15445-PA|CG15445-PE|CG15445-PF|CG15445-PG|CG15445-PH|uncharacterized protein', map_location='19F1-19F1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21117159, end_position_on_the_genomic_accession=21120444, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33096 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33096, CurrentID=0, Status='live', Symbol='CG14579', Aliases='Dmel_ Dmel\\CG14579', description='CG14579 gene product from transcript CG14579-RA', other_designations='CG14579-PA|uncharacterized protein', map_location='19F2-19F2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21193253, end_position_on_the_genomic_accession=21194521, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33097 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33097, CurrentID=0, Status='live', Symbol='CG1724', Aliases='Dmel_ BcDNA:AT13347, Dmel\\CG1724', description='CG1724 gene product from transcript CG1724-RA', other_designations='CG1724-PA', map_location='19F2-19F2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21202499, end_position_on_the_genomic_accession=21203341, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33098 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33098, CurrentID=0, Status='live', Symbol='CG32521', Aliases='Dmel_ CG1726, CG1735, Dmel\\CG32521', description='CG32521 gene product from transcript CG32521-RA', other_designations='CG32521-PA|CG32521-PB|CG32521-PC|CG32521-PD|CG32521-PE|CG32521-PF|CG32521-PG|CG32521-PH|CG32521-PI|uncharacterized protein', map_location='19F2-19F3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21205310, end_position_on_the_genomic_accession=21281171, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  5740400 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740400, CurrentID=0, Status='live', Symbol='CG34169', Aliases='Dmel_ Dmel\\CG34169', description='CG34169 gene product from transcript CG34169-RA', other_designations='CG34169-PA|uncharacterized protein', map_location='36C2-36C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=17173481, end_position_on_the_genomic_accession=17174105, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33101 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33101, CurrentID=0, Status='live', Symbol='CG1722', Aliases='Dmel_ Dmel\\CG1722', description='CG1722 gene product from transcript CG1722-RA', other_designations='CG1722-PA', map_location='19F2-19F2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21249976, end_position_on_the_genomic_accession=21251148, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33102 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33102, CurrentID=0, Status='live', Symbol='CG1494', Aliases='Dmel_ Dmel\\CG1494', description='CG1494 gene product from transcript CG1494-RC', other_designations='CG1494-PB|CG1494-PC', map_location='19F3-19F3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21285301, end_position_on_the_genomic_accession=21292458, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  33103 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33103, CurrentID=0, Status='live', Symbol='CG1718', Aliases='Dmel_ Dmel\\CG1718', description='CG1718 gene product from transcript CG1718-RB', other_designations='CG1718-PB|CG1718-PC|CG1718-PD', map_location='19F3-19F3', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21292308, end_position_on_the_genomic_accession=21306665, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  33104 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33104, CurrentID=0, Status='live', Symbol='CG1801', Aliases='Dmel_ Dmel\\CG1801', description='CG1801 gene product from transcript CG1801-RC', other_designations='CG1801-PC', map_location='19F3-19F4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21307586, end_position_on_the_genomic_accession=21317522, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  33105 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33105, CurrentID=0, Status='live', Symbol='Rpt6', Aliases='Dmel_CG1489, 1489, CG1489, DUG, Dm_Rpt6a, Dmel\\CG1489, Dug, PRS8_DROME, Pros45, S8, Ug, dRpt6, p42C, pros45, sug-1, sug1', description='Regulatory particle triple-A ATPase 6', other_designations='26S proteasome regulatory subunit 8|CG1489-PA|Pros45|Rpt6-PA|p42C|proteasomal subunit 8|regulatory particle triple-A ATPase 6', map_location='19F4-19F4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21316052, end_position_on_the_genomic_accession=21317663, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33107 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33107, CurrentID=0, Status='live', Symbol='Dd', Aliases='Dmel_CG1696, 20151539, BcDNA:LD08201, CG1696, Dmel\\CG1696, anon-WO03040301.167, ddd, l(1)G0269', description='Dullard', other_designations='CG1696-PA|CG1696-PB|CG1696-PC|Dd-PA|Dd-PB|Dd-PC|d-dullard|dullard|lethal (1) G0269', map_location='19F4-19F4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21319791, end_position_on_the_genomic_accession=21324009, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33108 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33108, CurrentID=0, Status='live', Symbol='CG1486', Aliases='Dmel_ Dmel\\CG1486', description='CG1486 gene product from transcript CG1486-RA', other_designations='CG1486-PA|CG1486-PB', map_location='19F4-19F4', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21324046, end_position_on_the_genomic_accession=21328150, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33109 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33109, CurrentID=0, Status='live', Symbol='tty', Aliases='Dmel_CG1693, CG1693, Dmel\\CG1693, TTYH1, twe', description='tweety', other_designations='CG1693-PA|CG1693-PC|CG1693-PD|CG1693-PE|CG1693-PF|CG1693-PG|tty-PA|tty-PC|tty-PD|tty-PE|tty-PF|tty-PG', map_location='19F4-19F5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21328613, end_position_on_the_genomic_accession=21339676, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  33110 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33110, CurrentID=0, Status='live', Symbol='fliI', Aliases='Dmel_CG1484, 15, BcDNA:LD21753, CG1484, CT3691, DCA3-19, Dmel\\CG1484, EN3, FLI-I, Fli-I, W2, fli, fli I, fli-I, fltI, fltO, l(1)18-80, l(1)19Fd, l(1)ESHS53, l(1)W-2, lDCB2-19, sdby, w-2', description='flightless I', other_designations='CG1484-PA|Flightless-I|fliI-PA|flightless|gluful-2|lgluful-2|section 15|standby', map_location='1-65.8 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21339741, end_position_on_the_genomic_accession=21345088, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33111 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33111, CurrentID=0, Status='live', Symbol='dod', Aliases='Dmel_CG17051, CG17051, Dmel\\CG17051, Pin1', description='dodo', other_designations='CG17051-PA|dod-PA', map_location='19F5-19F5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21345358, end_position_on_the_genomic_accession=21346858, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33112 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33112, CurrentID=0, Status='live', Symbol='peng', Aliases='Dmel_CG1685, CG1685, Dmel\\CG1685, pen', description='penguin', other_designations='CG1685-PA|peng-PA', map_location='19F5-19F5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21346503, end_position_on_the_genomic_accession=21349843, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33114 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33114, CurrentID=0, Status='live', Symbol='Sep1', Aliases='Dmel_CG1403, 38960, CG1403, Diff6, Dmel\\CG1403, anon-19Fa, iby, sep1, tu1', description='Septin 1', other_designations='CG1403-PA|Sep1-PA|Septin-1|innocent bystander|septin|septin 1|septin1', map_location='19F5-19F5', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21358286, end_position_on_the_genomic_accession=21361688, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33117 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33117, CurrentID=0, Status='live', Symbol='slgA', Aliases='Dmel_CG1417, CG1417, Dmel\\CG1417, EE85, PRODH, sl, slg, tu3', description='sluggish A', other_designations='CG1417-PA|CG1417-PB|CG1417-PC|CG1417-PD|CG1417-PE|CG1417-PF|CG1417-PG|CG1417-PH|CG1417-PI|CG1417-PJ|CG1417-PK|CG1417-PL|CG1417-PM|CG1417-PN|proline dehydrogenase|slgA-PA|slgA-PB|slgA-PC|slgA-PD|slgA-PE|slgA-PF|slgA-PG|slgA-PH|slgA-PI|slgA-PJ|slgA-PK|slgA-PL|slgA-PM|slgA-PN|sluggish|sluggish-A|sluggishA', map_location='19F6-20A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21374002, end_position_on_the_genomic_accession=21385159, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  33118 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33118, CurrentID=0, Status='live', Symbol='Hlc', Aliases='Dmel_CG1666, 11P1, 14, 7, A112, CG1666, DmRH10, Dmel\\CG1666, HLC, HM-44, hlc, l(1)11P1, l(1)19Ff, l(1)8-1, l(1)A112, l(1)S-19F6, l11P1, lA112', description='Helicase', other_designations='CG1666-PA|CG1666-PB|Hlc-PA|Hlc-PB|RNA helicase gene|helicase|lethal(1)19Ff|section 14|section 7', map_location='20A1-20A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21385518, end_position_on_the_genomic_accession=21387946, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33119 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33119, CurrentID=0, Status='live', Symbol='mst', Aliases='Dmel_CG1424, CG1424, Dmel\\CG1424, LB-20, LB20, l(1)19Fg, l(1)LB14, l(1)LB20, lLB14', description='misato', other_designations='CG1424-PA|CG1424-PB|lethal(1)19Fg|mst-PA|mst-PB', map_location='20A1-20A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21388977, end_position_on_the_genomic_accession=21391533, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33120 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33120, CurrentID=0, Status='live', Symbol='lcs', Aliases='Dmel_CG12794, CG12794, Dmel\\CG12794', description='la costa', other_designations='CG12794-PA|lcs-PA|leader sequence, collagen-related repetitive motif and a serine/threonine-rich motif', map_location='20A1-20A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21396727, end_position_on_the_genomic_accession=21397316, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33121 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33121, CurrentID=0, Status='live', Symbol='CG1678', Aliases='Dmel_ BcDNA:GH04760, Dmel\\CG1678', description='CG1678 gene product from transcript CG1678-RB', other_designations='CG1678-PA|CG1678-PB', map_location='20A1-20A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21402339, end_position_on_the_genomic_accession=21402772, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33123 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33123, CurrentID=0, Status='live', Symbol='CG10918', Aliases='Dmel_ Dmel\\CG10918', description='CG10918 gene product from transcript CG10918-RA', other_designations='CG10918-PA|uncharacterized protein', map_location='20A1-20A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21428614, end_position_on_the_genomic_accession=21429256, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33125 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33125, CurrentID=0, Status='live', Symbol='DIP-beta', Aliases='Dmel_CG42343, 42343, BP1062, BcDNA:RE23430, CG12564, CG12565, CG14583, CG34019, CG42343, CT34319, Dmel\\CG42343, Dmel_CG12564, Dmel_CG12565, Dmel_CG14583, Dmel_CG34019, pp-CT34319, pp-CT34320, pp-CT34321', description='Dpr-interacting protein beta', other_designations='CG42343-PC|CG42343-PD|CG42343-PE|CG42343-PF|CG42343-PG|DIP-beta-PC|DIP-beta-PD|DIP-beta-PE|DIP-beta-PF|DIP-beta-PG', map_location='20A1-20A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21422115, end_position_on_the_genomic_accession=21457738, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33126 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33126, CurrentID=0, Status='live', Symbol='Ir20a', Aliases='Dmel_CG14584, CG14584, DmelIR20a, Dmel\\CG14584, IR20a', description='Ionotropic receptor 20a', other_designations='CG14584-PA|Ir20a-PA|ionotropic receptor 20a', map_location='20A1-20A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21477254, end_position_on_the_genomic_accession=21478945, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33127 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33127, CurrentID=0, Status='live', Symbol='Cyp6t1', Aliases='Dmel_CG1644, 6t1, CG1644, Dmel\\CG1644', description='CG1644 gene product from transcript CG1644-RA', other_designations='CG1644-PA|Cyp6t1-PA|cytochrome P450', map_location='20A1-20A1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=21517434, end_position_on_the_genomic_accession=21519218, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33128 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33128, CurrentID=0, Status='live', Symbol='CG14621', Aliases='Dmel_ Dmel\\CG14621, Slc35e1, lincRNA.1043', description='CG14621 gene product from transcript CG14621-RD', other_designations='CG14621-PA|CG14621-PB|CG14621-PC|CG14621-PD|uncharacterized protein', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22444227, end_position_on_the_genomic_accession=22447808, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33129 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33129, CurrentID=0, Status='live', Symbol='CG14615', Aliases='Dmel_ Dmel\\CG14615', description='CG14615 gene product from transcript CG14615-RB', other_designations='CG14615-PA|CG14615-PB|uncharacterized protein', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22447183, end_position_on_the_genomic_accession=22449491, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33130 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33130, CurrentID=0, Status='live', Symbol='tilB', Aliases='Dmel_CG14620, CG14620, Dmel\\CG14620', description='touch insensitive larva B', other_designations='CG14620-PA|TilB|tilB-PA|touch insensitive larvaeB|touch-insensitive-larva-B', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22449737, end_position_on_the_genomic_accession=22451463, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33131 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33131, CurrentID=0, Status='live', Symbol='wap', Aliases='Dmel_CG14614, 15, 16, 19, 20, 21, 22, BcDNA:GM08142, CG14614, Dmel\\CG14614, Q217, Q464, Riq, l(1)20Ab, l(1)A-200, l(1)HM33, l(1)Q217, l(1)Q464, riq', description='wings apart', other_designations='CG14614-PA|CG14614-PB|CG14614-PC|CG14614-PD|riquiqui|section 15|section 16|section 19|section 20|section 21|section 22|wap-PA|wap-PB|wap-PC|wap-PD|wings-apart', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22451445, end_position_on_the_genomic_accession=22455422, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33132 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33132, CurrentID=0, Status='live', Symbol='Usp2', Aliases='Dmel_CG14619, CG14619, Dmel\\CG14619, Q9VR54', description='Ubiquitin specific protease 2', other_designations='CG14619-PA|CG14619-PC|CG14619-PD|CG14619-PE|CG14619-PF|CG14619-PG|CG14619-PH|CG14619-PI|CG14619-PK|Usp2-PA|Usp2-PC|Usp2-PD|Usp2-PE|Usp2-PF|Usp2-PG|Usp2-PH|Usp2-PI|Usp2-PK|ubiquitin specific protease 2', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22455803, end_position_on_the_genomic_accession=22470146, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  33133 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33133, CurrentID=0, Status='live', Symbol='CG14613', Aliases='Dmel_ ADP/ATP translocase, CT34370, Dmel\\CG14613', description='CG14613 gene product from transcript CG14613-RB', other_designations='CG14613-PA|CG14613-PB|uncharacterized protein', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22469981, end_position_on_the_genomic_accession=22472021, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33134 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33134, CurrentID=0, Status='live', Symbol='CG14618', Aliases='Dmel_ Dmel\\CG14618', description='CG14618 gene product from transcript CG14618-RA', other_designations='CG14618-PA|uncharacterized protein', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22473698, end_position_on_the_genomic_accession=22474998, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33135 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33135, CurrentID=0, Status='live', Symbol='CG12576', Aliases='Dmel_ Dmel\\CG12576, anon-WO0140519.40', description='CG12576 gene product from transcript CG12576-RF', other_designations='CG12576-PA|CG12576-PB|CG12576-PE|CG12576-PF|uncharacterized protein', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22474851, end_position_on_the_genomic_accession=22482357, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33136 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33136, CurrentID=0, Status='live', Symbol='Cp110', Aliases='Dmel_CG14617, CG14617, CG32501, CP110, DCP110, Dmel\\CG14617', description='CG14617 gene product from transcript CG14617-RD', other_designations='CG14617-PA|CG14617-PB|CG14617-PC|CG14617-PD|CG14617-PE|CG14617-PF|CG14617-PG|CG14617-PH|Cp110-PA|Cp110-PB|Cp110-PC|Cp110-PD|Cp110-PE|Cp110-PF|Cp110-PG|Cp110-PH', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22482082, end_position_on_the_genomic_accession=22487458, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33137 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33137, CurrentID=0, Status='live', Symbol='l(1)G0196', Aliases='Dmel_CG14616, CG14616, CG32502, Dmel\\CG14616', description='lethal (1) G0196', other_designations='CG14616-PG|CG14616-PH|CG14616-PI|CG14616-PJ|CG14616-PK|CG14616-PL|CG14616-PM|CG14616-PN|CG14616-PO|CG14616-PP|l(1)G0196-PG|l(1)G0196-PH|l(1)G0196-PI|l(1)G0196-PJ|l(1)G0196-PK|l(1)G0196-PL|l(1)G0196-PM|l(1)G0196-PN|l(1)G0196-PO|l(1)G0196-PP', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22487180, end_position_on_the_genomic_accession=22508129, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  33139 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33139, CurrentID=0, Status='live', Symbol='S6kII', Aliases='Dmel_CG17596, CG17596, Dmel\\CG17596, RSK, Rsk, S6KII, dRSK, ign, rsk, rsk2', description='Ribosomal protein S6 kinase II', other_designations='CG17596-PA|CG17596-PB|RPS6-protein kinase-II|Ribosomal-S6-kinase|S6 kinase II|S6kII-PA|S6kII-PB|ignorant|p90 ribosomal S6 kinase|ribosomal protein S6 kinase II', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22529964, end_position_on_the_genomic_accession=22536371, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33140 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33140, CurrentID=0, Status='live', Symbol='CG17598', Aliases='Dmel_ Dmel\\CG17598, PP2C', description='CG17598 gene product from transcript CG17598-RB', other_designations='CG17598-PA|CG17598-PB|uncharacterized protein', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22534831, end_position_on_the_genomic_accession=22540383, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33141 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33141, CurrentID=0, Status='live', Symbol='CG17600', Aliases='Dmel_ CG17602, Dmel\\CG17600', description='CG17600 gene product from transcript CG17600-RA', other_designations='CG17600-PA|CG17600-PB|CG17600-PC|CG17600-PD|uncharacterized protein', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22515197, end_position_on_the_genomic_accession=22542024, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33142 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33142, CurrentID=0, Status='live', Symbol='CG17599', Aliases='Dmel_ CLUAP1, Dmel\\CG17599', description='CG17599 gene product from transcript CG17599-RA', other_designations='CG17599-PA|uncharacterized protein', map_location='20C1-20C1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22542386, end_position_on_the_genomic_accession=22544322, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33143 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33143, CurrentID=0, Status='live', Symbol='CG17601', Aliases='Dmel_ Dmel\\CG17601', description='CG17601 gene product from transcript CG17601-RA', other_designations='CG17601-PA|uncharacterized protein', map_location='20C2-20C2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22547097, end_position_on_the_genomic_accession=22548056, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33144 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33144, CurrentID=0, Status='live', Symbol='Cda4', Aliases='Dmel_CG32499, BcDNA:RE51076, CG12447, CG13238, CG32499, CG9557, CG9558, DmCDA4, Dmel\\CG32499', description='Chitin deacetylase-like 4', other_designations='CG32499-PA|Cda4-PA|chitin deacetylase-like 4', map_location='20C3-20D1', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22583634, end_position_on_the_genomic_accession=22632710, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33147 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33147, CurrentID=0, Status='live', Symbol='CG12446', Aliases='Dmel_ Dmel\\CG12446', description='CG12446 gene product from transcript CG12446-RA', other_designations='CG12446-PA|uncharacterized protein', map_location='20E2-20E2', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22809292, end_position_on_the_genomic_accession=22811935, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33148 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33148, CurrentID=0, Status='live', Symbol='fog', Aliases='Dmel_CG9559, 114, CG9559, CR41108, CR41109, CR41110, Dmel\\CG9559, Fog, M67, l(1)114, l(1)16-3-190, l(1)20Ba, l114', description='folded gastrulation', other_designations='CG9559-PA|CG9559-PB|CG9559-PC|CG9559-PD|CG9559-PE|CG9559-PF|fog-PA|fog-PB|fog-PC|fog-PD|fog-PE|fog-PF', map_location='1-65 cM', chromosome='X', genomic_nucleotide_accession_version='NC_004354.4', start_position_on_the_genomic_accession=22824317, end_position_on_the_genomic_accession=22855194, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33155 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33155, CurrentID=0, Status='live', Symbol='CG11023', Aliases='Dmel_ Dmel\\CG11023', description='CG11023 gene product from transcript CG11023-RB', other_designations='CG11023-PB|CG11023-PC|CG11023-PD|uncharacterized protein', map_location='21A5-21A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7529, end_position_on_the_genomic_accession=9484, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33156 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33156, CurrentID=0, Status='live', Symbol='l(2)gl', Aliases='Dmel_CG2671, CG2671, D-LGL, Dmel\\CG2671, L(2)GL, L(2)gl, LGL, Lgl, MENE (2L)-B, dlgl, gl, l(2), l(2) giant larva, l(2)giant larvae, l-gl, l[[2]]gl, lgl, p127, p127[l(2)gl], p127l(2)gl', description='lethal (2) giant larvae', other_designations='CG2671-PA|CG2671-PB|CG2671-PC|CG2671-PD|CG2671-PE|CG2671-PF|CG2671-PG|CG2671-PH|CG2671-PI|CG2671-PJ|CG2671-PK|complementation group 2.1|l(2) giant larvae|l(2)gl-PA|l(2)gl-PB|l(2)gl-PC|l(2)gl-PD|l(2)gl-PE|l(2)gl-PF|l(2)gl-PG|l(2)gl-PH|l(2)gl-PI|l(2)gl-PJ|l(2)gl-PK|lethal (2) giant larva|lethal giant larva|lethal giant larvae|lethal giant larve|lethal(2) giant larvae|lethal(2)-giant larvae|lethal(2)giant larvae|lethal- giant-larvae|lethal-2-giant larvae|lethal-giant-larvae', map_location='2-0.0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9839, end_position_on_the_genomic_accession=21376, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  33157 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33157, CurrentID=0, Status='live', Symbol='Ir21a', Aliases='Dmel_CG2657, CG2657, CT8983, DmelIR21a, Dmel\\CG2657, IR21a, ir21a', description='Ionotropic receptor 21a', other_designations='CG2657-PB|Ir21a-PB|ionotropic receptor 21a', map_location='21A5-21B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=21823, end_position_on_the_genomic_accession=25155, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33158 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33158, CurrentID=0, Status='live', Symbol='Cda5', Aliases='Dmel_CG31973, BcDNA:RH43162, CG2761, CG2776, CG31973, DmCDA5, Dmel\\CG31973', description='Chitin deacetylase-like 5', other_designations='CG31973-PA|CG31973-PB|CG31973-PE|CG31973-PF|CG31973-PG|CG31973-PH|CG31973-PI|CG31973-PJ|Cda5-PA|Cda5-PB|Cda5-PE|Cda5-PF|Cda5-PG|Cda5-PH|Cda5-PI|Cda5-PJ|chitin deacetylase-like 5', map_location='21B1-21B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=25402, end_position_on_the_genomic_accession=65404, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  33161 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33161, CurrentID=0, Status='live', Symbol='dbr', Aliases='Dmel_CG11371, BcDNA:LD26519, CG11371, Dbr, Debra, Dmel\\CG11371, EP0456, EP456', description='debra', other_designations='CG11371-PB|CG11371-PC|CG11371-PD|CG11371-PE|CG11371-PF|dbr-PB|dbr-PC|dbr-PD|dbr-PE|dbr-PF', map_location='21B1-21B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=66482, end_position_on_the_genomic_accession=71390, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33162 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33162, CurrentID=0, Status='live', Symbol='galectin', Aliases='Dmel_CG11372, CG11372, Dmel\\CG11372, Dmgal', description='CG11372 gene product from transcript CG11372-RD', other_designations='CG11372-PA|CG11372-PB|CG11372-PD|CG11372-PE|CG11372-PF|galectin-PA|galectin-PB|galectin-PD|galectin-PE|galectin-PF', map_location='21B1-21B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=71757, end_position_on_the_genomic_accession=76211, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33163 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33163, CurrentID=0, Status='live', Symbol='CG11374', Aliases='Dmel_ Dmel\\CG11374', description='CG11374 gene product from transcript CG11374-RC', other_designations='CG11374-PC|uncharacterized protein', map_location='21B1-21B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=76348, end_position_on_the_genomic_accession=77783, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33165 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33165, CurrentID=0, Status='live', Symbol='Zir', Aliases='Dmel_CG11376, CG11376, Dm zir, Dmel\\CG11376, FBgn 31216, anon-EST:Posey54', description='Zizimin-related', other_designations='CG11376-PA|Zir-PA', map_location='21B1-21B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=94739, end_position_on_the_genomic_accession=102086, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  33166 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33166, CurrentID=0, Status='live', Symbol='CG11377', Aliases='Dmel_ CT31762, Dmel\\CG11377', description='CG11377 gene product from transcript CG11377-RA', other_designations='CG11377-PA|CG11377-PB|uncharacterized protein', map_location='21B2-21B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=102380, end_position_on_the_genomic_accession=104142, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33167 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33167, CurrentID=0, Status='live', Symbol='Nhe1', Aliases='Dmel_CG12178, CG12178, DmNHE1, Dmel\\CG12178, NHE1, nhe1', description='Na[+]/H[+] hydrogen exchanger 1', other_designations='CG12178-PB|Nhe1-PB', map_location='21B2-21B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=103962, end_position_on_the_genomic_accession=106732, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33169 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33169, CurrentID=0, Status='live', Symbol='CG13694', Aliases='Dmel_ Dmel\\CG13694', description='CG13694 gene product from transcript CG13694-RA', other_designations='CG13694-PA|CG13694-PB|uncharacterized protein', map_location='21B2-21B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=115365, end_position_on_the_genomic_accession=116488, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33170 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33170, CurrentID=0, Status='live', Symbol='CG4822', Aliases='Dmel_ Dmel\\CG4822', description='CG4822 gene product from transcript CG4822-RE', other_designations='CG4822-PA|CG4822-PB|CG4822-PC|CG4822-PD|CG4822-PE|CG4822-PF|CG4822-PG|CG4822-PH|CG4822-PI', map_location='21B2-21B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=116970, end_position_on_the_genomic_accession=121754, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  33171 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33171, CurrentID=0, Status='live', Symbol='CG3164', Aliases='Dmel_ BEST:CK02656, CK02656, Dmel\\CG3164', description='CG3164 gene product from transcript CG3164-RA', other_designations='CG3164-PA|CG3164-PB|CG3164-PC|CG3164-PD', map_location='21B2-21B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=122624, end_position_on_the_genomic_accession=130791, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  33172 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33172, CurrentID=0, Status='live', Symbol='Gs1', Aliases='Dmel_CG2718, CG2718, Dmel\\CG2718, GS1, GSI, GsI, fs(2)P52, fs(2)throng, gs-m, gsI, l(2)21Bc, mt-gs, thg', description='Glutamine synthetase 1', other_designations='CG2718-PB|CG2718-PC|CG2718-PD|Glutamate-ammonia ligase|Gs1-PB|Gs1-PC|Gs1-PD|glutamine synthase 1|glutamine synthetase|glutamine synthetase 1|glutamine synthetase I|glutamine synthetase-1|mitochondrial glutamine synthetase|throng', map_location='21B2-21B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=132077, end_position_on_the_genomic_accession=134472, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33174 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33174, CurrentID=0, Status='live', Symbol='CG31974', Aliases='Dmel_ CG18501, Dmel\\CG31974', description='CG31974 gene product from transcript CG31974-RB', other_designations='CG31974-PB|CG31974-PC|CG31974-PD|uncharacterized protein', map_location='21B3-21B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=141077, end_position_on_the_genomic_accession=143091, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33175 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33175, CurrentID=0, Status='live', Symbol='CG11454', Aliases='Dmel_ Dmel\\CG11454, cg11454', description='CG11454 gene product from transcript CG11454-RA', other_designations='CG11454-PA|uncharacterized protein', map_location='21B3-21B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=143323, end_position_on_the_genomic_accession=144227, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33176 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33176, CurrentID=0, Status='live', Symbol='CG42399', Aliases='Dmel_ CG11620, CG4648, Dmel\\CG42399, Dmel_CG11620, Dmel_CG4648', description='CG42399 gene product from transcript CG42399-RC', other_designations='CG42399-PB|CG42399-PC|uncharacterized protein', map_location='21B3-21B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=144231, end_position_on_the_genomic_accession=153300, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  33178 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33178, CurrentID=0, Status='live', Symbol='CG3709', Aliases='Dmel_ Dmel\\CG3709, anon-WO0257455.7', description='CG3709 gene product from transcript CG3709-RA', other_designations='CG3709-PA', map_location='21B3-21B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=153539, end_position_on_the_genomic_accession=155305, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33179 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33179, CurrentID=0, Status='live', Symbol='ND-15', Aliases='Dmel_CG11455, CG11455, Dmel\\CG11455, NIPM', description='NADH dehydrogenase (ubiquinone) 15 kDa subunit', other_designations='CG11455-PA|CG11455-PB|CG11455-PC|CG11455-PD|CG11455-PF|CG11455-PG|CG11455-PH|CG11455-PI|CG11455-PJ|CG11455-PK|NADH ubiquinone oxidoreductase 15 kDa|NADH-ubiquinone oxidoreductase 15 kDa subunit|NADH:ubiquinone oxidoreductase 15 kDa subunit|ND-15-PA|ND-15-PB|ND-15-PC|ND-15-PD|ND-15-PF|ND-15-PG|ND-15-PH|ND-15-PI|ND-15-PJ|ND-15-PK', map_location='21B3-21B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=114726, end_position_on_the_genomic_accession=156030, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33180 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33180, CurrentID=0, Status='live', Symbol='CG3436', Aliases='Dmel_ Dmel\\CG3436', description='CG3436 gene product from transcript CG3436-RC', other_designations='CG3436-PA|CG3436-PC', map_location='21B3-21B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=156029, end_position_on_the_genomic_accession=157666, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33182 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33182, CurrentID=0, Status='live', Symbol='mRpL10', Aliases='Dmel_CG11488, CG11488, Dmel\\CG11488, L10', description='mitochondrial ribosomal protein L10', other_designations='CG11488-PA|mRpL10-PA', map_location='21B4-21B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=203779, end_position_on_the_genomic_accession=204782, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33183 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33183, CurrentID=0, Status='live', Symbol='CG11617', Aliases='Dmel_ Dmel\\CG11617, Mkx', description='CG11617 gene product from transcript CG11617-RA', other_designations='CG11617-PA|CG11617-PB|uncharacterized protein', map_location='21B4-21B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=204743, end_position_on_the_genomic_accession=207297, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33184 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33184, CurrentID=0, Status='live', Symbol='Tbc1d15-17', Aliases='Dmel_CG11490, CG11490, Dmel\\CG11490', description='TBC1 domain family, member 15/17 ortholog (H. sapiens)', other_designations='CG11490-PA|CG11490-PB|CG11490-PC|TBC1 domain family, member 15/17 ortholog|Tbc1d15-17-PA|Tbc1d15-17-PB|Tbc1d15-17-PC', map_location='21B4-21B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=207179, end_position_on_the_genomic_accession=210725, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33185 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33185, CurrentID=0, Status='live', Symbol='kis', Aliases='Dmel_CG3696, 136/31, 2532, 5841, BEST:GM02209, CG18326, CG3660, CG3696, DmelPex20, Dmel\\CG3696, EC2-7, EK2-4, EP(2)0474, EP474, FBtr0078144, GM02209, KIS, KIS-L, Kis, Pex20, Su(Pc)21AB, anon-WO0172774.164, anon-WO0257455.5s, l(2)07812, l(2)k08827, l(2)k11324, l(2)k13631, l(2)k14112, l(2)k16510, l(2)s3527, l(2)s4771, l(2)s4793, kis', description='kismet', other_designations='CG3696-PA|CG3696-PB|CG3696-PC|CG3696-PD|CG3696-PE|CG3696-PF|EP474|kis-PA|kis-PB|kis-PC|kis-PD|kis-PE|kis-PF|lethal (2) k11324|lethal (2) k16510|peroxin 20', map_location='2-0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=210735, end_position_on_the_genomic_accession=250823, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  33187 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33187, CurrentID=0, Status='live', Symbol='CG13693', Aliases='Dmel_ Dmel\\CG13693', description='CG13693 gene product from transcript CG13693-RA', other_designations='CG13693-PA|uncharacterized protein', map_location='21B5-21B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=232487, end_position_on_the_genomic_accession=234208, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33190 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33190, CurrentID=0, Status='live', Symbol='CG3645', Aliases='Dmel_ Dmel\\CG3645', description='CG3645 gene product from transcript CG3645-RA', other_designations='CG3645-PA|CG3645-PB|CG3645-PC', map_location='21B5-21B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=252589, end_position_on_the_genomic_accession=271744, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33191 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33191, CurrentID=0, Status='live', Symbol='CG17075', Aliases='Dmel_ Dmel\\CG17075', description='CG17075 gene product from transcript CG17075-RB', other_designations='CG17075-PA|CG17075-PB|uncharacterized protein', map_location='21B6-21B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=259949, end_position_on_the_genomic_accession=267505, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33192 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33192, CurrentID=0, Status='live', Symbol='CG3345', Aliases='Dmel_ Dmel\\CG3345, anon-WO0140519.207', description='CG3345 gene product from transcript CG3345-RA', other_designations='CG3345-PA', map_location='21B7-21B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=269088, end_position_on_the_genomic_accession=271626, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33193 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33193, CurrentID=0, Status='live', Symbol='CG11555', Aliases='Dmel_ Dmel\\CG11555, anon-21Ca', description='CG11555 gene product from transcript CG11555-RB', other_designations='CG11555-PA|CG11555-PB|anon-21Ca|uncharacterized protein', map_location='21B7-21B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=273836, end_position_on_the_genomic_accession=274766, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33194 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33194, CurrentID=0, Status='live', Symbol='mbm', Aliases='Dmel_CG11604, CG11604, Dmel\\CG11604, mus', description='mushroom body miniature', other_designations='CG11604-PA|MB miniature|mbm-PA|mushroom bodies miniature|mushroom bodies small|mushroom-body-miniature', map_location='21B7-21B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=271912, end_position_on_the_genomic_accession=273715, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33195 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33195, CurrentID=0, Status='live', Symbol='CG17078', Aliases='Dmel_ Dmel\\CG17078, anon-21Cb', description='CG17078 gene product from transcript CG17078-RE', other_designations='CG17078-PB|CG17078-PC|CG17078-PD|CG17078-PE|anon-21Cb|uncharacterized protein', map_location='21B7-21B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=274740, end_position_on_the_genomic_accession=278234, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33196 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33196, CurrentID=0, Status='live', Symbol='smo', Aliases='Dmel_CG11561, CG11561, Dmel\\CG11561, SMO, Smo, dSmo', description='smoothened', other_designations='CG11561-PA|smo-PA|smooth|smoothene', map_location='2-0.4 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=277582, end_position_on_the_genomic_accession=282167, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33197 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33197, CurrentID=0, Status='live', Symbol='CG11601', Aliases='Dmel_ Dmel\\CG11601', description='CG11601 gene product from transcript CG11601-RC', other_designations='CG11601-PA|CG11601-PB|CG11601-PC|uncharacterized protein', map_location='21B7-21B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=281670, end_position_on_the_genomic_accession=283269, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33198 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33198, CurrentID=0, Status='live', Symbol='CG3625', Aliases='Dmel_ Dmel\\CG3625', description='CG3625 gene product from transcript CG3625-RE', other_designations='CG3625-PA|CG3625-PB|CG3625-PC|CG3625-PE', map_location='21B7-21B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=283385, end_position_on_the_genomic_accession=291795, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33199 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33199, CurrentID=0, Status='live', Symbol='Amnionless', Aliases='Dmel_CG11592, BEST:CK02467, CG11592, CK02467, Dmel\\CG11592, dAMN', description='Amnionless ortholog', other_designations='Amnionless-PA|Amnionless-PB|CG11592-PA|CG11592-PB|amnionless ortholog', map_location='21B7-21B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=287252, end_position_on_the_genomic_accession=289144, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33200 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33200, CurrentID=0, Status='live', Symbol='CG11562', Aliases='Dmel_ BcDNA:RE44650, Dmel\\CG11562', description='CG11562 gene product from transcript CG11562-RA', other_designations='CG11562-PA|uncharacterized protein', map_location='21B7-21B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=292419, end_position_on_the_genomic_accession=293222, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33201 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33201, CurrentID=0, Status='live', Symbol='U2af38', Aliases='Dmel_CG3582, CG3582, DU2AF38, Dmel\\CG3582, U2AF, U2AF 38, U2AF38, dU2AF38, dU2AF[38], l(2)06751, u2af38', description='U2 small nuclear riboprotein auxiliary factor 38', other_designations='CG3582-PA|CG3582-PB|U2af38-PA|U2af38-PB', map_location='21B7-21B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=292959, end_position_on_the_genomic_accession=294681, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33202 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33202, CurrentID=0, Status='live', Symbol='Hop', Aliases='Dmel_CG2720, CG2720, Dmel\\CG2720, EP(2)0418, HOP, Sti1, dHop, dSTI1, dhop, dmSTI1, hop, l(2)k00616', description='Hsp70/Hsp90 organizing protein homolog', other_designations='CG2720-PA|Hop-PA|Hsp70(Hsp90) organizing protein|Hsp70-Hsp90 organizing protein|Hsp70/Hsp90 organizing protein|stress inducible protein 1', map_location='21B8-21B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=295122, end_position_on_the_genomic_accession=297449, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33203 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33203, CurrentID=0, Status='live', Symbol='Pi3K21B', Aliases='Dmel_CG2699, CG2699, Dmel\\CG2699, Dp60, PI(3)K, PI3K, PI3K-p60, PI3K21B, PI[[3]]K|p60, Pi3Kp60, dP60, dPI3K, droPIK57, p60', description='CG2699 gene product from transcript CG2699-RE', other_designations='CG2699-PB|CG2699-PC|CG2699-PD|CG2699-PE|PI 3-kinase|PI3 kinase|PI3-kinase|Pi3K21B-PB|Pi3K21B-PC|Pi3K21B-PD|Pi3K21B-PE|dPI 3-kinase', map_location='21B8-21B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=297880, end_position_on_the_genomic_accession=305233, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33204 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33204, CurrentID=0, Status='live', Symbol='Plc21C', Aliases='Dmel_CG4574, CG4574, Dmel\\CG4574, PLC, PLC-21, PLC-21C, PLC21C, PLC21c, PLC[[Beta]], Plc21, Plcbeta21C, plc-21, plc21, plc21C, plc21c, plcbeta21c', description='Phospholipase C at 21C', other_designations='CG4574-PA|CG4574-PB|CG4574-PC|CG4574-PD|CG4574-PG|CG4574-PH|Plc21C-PA|Plc21C-PB|Plc21C-PC|Plc21C-PD|Plc21C-PG|Plc21C-PH|phospholipase C|phospholipase C 21C|phospholipase C at 21C', map_location='21B8-21C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=305935, end_position_on_the_genomic_accession=355566, orientation='plus', exon_count=19, OMIM='', no_hdr0=''),
  33205 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33205, CurrentID=0, Status='live', Symbol='CG11912', Aliases='Dmel_ Dmel\\CG11912, SP140, anon-WO0140519.112', description='CG11912 gene product from transcript CG11912-RA', other_designations='CG11912-PA|uncharacterized protein', map_location='21B8-21B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=318362, end_position_on_the_genomic_accession=319259, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33206 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33206, CurrentID=0, Status='live', Symbol='CG11911', Aliases='Dmel_ Dmel\\CG11911, SP103', description='CG11911 gene product from transcript CG11911-RA', other_designations='CG11911-PA|uncharacterized protein', map_location='21B8-21B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=320279, end_position_on_the_genomic_accession=321248, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33207 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33207, CurrentID=0, Status='live', Symbol='Ent1', Aliases='Dmel_CG11907, CG11907, DmENT1, DmEnt1, Dmel\\CG11907, anon-EST:fe2G2, dENT1, ent1', description='Equilibrative nucleoside transporter 1', other_designations='CG11907-PA|CG11907-PB|CG11907-PC|Ent1-PA|Ent1-PB|Ent1-PC|anon-fast-evolving-2G2|equilibrative nucleoside transporter 1', map_location='21C1-21C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=355565, end_position_on_the_genomic_accession=357874, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33208 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33208, CurrentID=0, Status='live', Symbol='al', Aliases='Dmel_CG3935, A1, AL, CG3935, Dmel\\CG3935, L13-4, lambda13-4', description='aristaless', other_designations='CG3935-PA|al-PA', map_location='2-0.4 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=378112, end_position_on_the_genomic_accession=387439, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33209 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33209, CurrentID=0, Status='live', Symbol='CG4213', Aliases='Dmel_ Dmel\\CG4213', description='CG4213 gene product from transcript CG4213-RA', other_designations='CG4213-PA|CG4213-PB', map_location='21C2-21C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=396595, end_position_on_the_genomic_accession=402198, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33210 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33210, CurrentID=0, Status='live', Symbol='RpI135', Aliases='Dmel_CG4033, CG4033, DmRP135, Dmel\\CG4033, RP135, RPI135, RpIII135, Rpl135, l(2)k16513', description='RNA polymerase I 135kD subunit', other_designations='CG4033-PA|RNA polymerase I|RpI135-PA', map_location='21C2-21C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=404285, end_position_on_the_genomic_accession=407969, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33211 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33211, CurrentID=0, Status='live', Symbol='AP-2alpha', Aliases='Dmel_CG4260, AP-2, AP2, Alpha-Adaptin, CG31654, CG4260, D-Ada, D-alphaAda, Dmel\\CG4260, MENE (2L)-A, MENE(2L)-A, ada, alpha, alpha-Ada, alpha-Adaptin, alpha-ada, alpha-adaptin, apl3, cg4260, dAP-2a, l(2)06694, l(2)SH0460, l(2)SH2 0460', description='Adaptor Protein complex 2, alpha subunit', other_designations='AP-2alpha-PA|AP-2alpha-PB|Alpha-adaptin|CG4260-PA|CG4260-PB|adaptor protein complex 2, alpha subunit|alpha adaptin|alphaAdaptin|lethal (2) SH0460', map_location='21C2-21C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=408030, end_position_on_the_genomic_accession=414777, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33212 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33212, CurrentID=0, Status='live', Symbol='ebi', Aliases='Dmel_CG4063, CG4063, Dmel\\CG4063, E-2f, E-2g, Ebi, FBXW4, Tb11, Tbl1, l(2)k16213', description='CG4063 gene product from transcript CG4063-RA', other_designations='CG4063-PA|beta transducin-like 1 protein|ebi-PA|enhancer on chromosome 2-complementation group 2g', map_location='21C2-21C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=415067, end_position_on_the_genomic_accession=418536, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33213 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33213, CurrentID=0, Status='live', Symbol='CG13690', Aliases='Dmel_ Dmel\\CG13690', description='CG13690 gene product from transcript CG13690-RA', other_designations='CG13690-PA|uncharacterized protein', map_location='21C2-21C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=418434, end_position_on_the_genomic_accession=419652, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33214 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33214, CurrentID=0, Status='live', Symbol='RpLP1', Aliases='Dmel_CG4087, CG4087, Dmel\\CG4087, LP1, M(2)21C, M(2)21C1-2, RLA1_DROME, RpA2, RpP2, Rplp1, chr2L:420593..420726, rp21C, rpA2, rpP2, rpa2', description='Ribosomal protein LP1', other_designations='ACIDIC RIBOSOMAL PROTEIN LP1|CG4087-PA|CG4087-PB|Minute(2)21C|Ribosomal-protein-A2|RpLP1-PA|RpLP1-PB|ribosomal protein A2|ribosomal protein LP1|ribosomal protein P2', map_location='2-0.0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=419952, end_position_on_the_genomic_accession=420864, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33215 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33215, CurrentID=0, Status='live', Symbol='CG11885', Aliases='Dmel_ BcDNA:AT13539, Dmel\\CG11885', description='CG11885 gene product from transcript CG11885-RA', other_designations='CG11885-PA|uncharacterized protein', map_location='21C2-21C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=420895, end_position_on_the_genomic_accession=421450, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33216 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33216, CurrentID=0, Status='live', Symbol='CG13692', Aliases='Dmel_ Dmel\\CG13692', description='CG13692 gene product from transcript CG13692-RA', other_designations='CG13692-PA|uncharacterized protein', map_location='21C2-21C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=421771, end_position_on_the_genomic_accession=422489, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33217 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33217, CurrentID=0, Status='live', Symbol='BBS8', Aliases='Dmel_CG13691, BBS2, CG13691, Dmel\\CG13691', description='Bardet-Biedl syndrome 8 ortholog (H. sapiens)', other_designations='BBS8-PA|Bardet-Biedl syndrome 8 ortholog|CG13691-PA', map_location='21C2-21C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=422873, end_position_on_the_genomic_accession=425321, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33218 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33218, CurrentID=0, Status='live', Symbol='ex', Aliases='Dmel_CG4114, 1270, CG4114, Dmel\\CG4114, Ex, Expanded, brl, l(2)01270, l(2)ey', description='expanded', other_designations='CG4114-PA|CG4114-PB|braille|ex-PA|ex-PB', map_location='2-0.1 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=431227, end_position_on_the_genomic_accession=448701, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33219 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33219, CurrentID=0, Status='live', Symbol='crq', Aliases='Dmel_CG4280, CD36, CG31655, CG4280, CRQ, Cd36, Cqr, Crq, D-CD36, Dmel\\CG4280, anon-WO0140519.8, cqm, cqr', description='croquemort', other_designations='CD36-like|CG4280-PA|CG4280-PB|CG4280-PC|CG4280-PD|CG4280-PE|crq-PA|crq-PB|crq-PC|crq-PD|crq-PE', map_location='21C2-21C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=448254, end_position_on_the_genomic_accession=453024, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33220 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33220, CurrentID=0, Status='live', Symbol='CG4164', Aliases='Dmel_ Dmel\\CG4164', description='CG4164 gene product from transcript CG4164-RA', other_designations='CG4164-PA', map_location='21C2-21C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=453108, end_position_on_the_genomic_accession=454654, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33221 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33221, CurrentID=0, Status='live', Symbol='CG4133', Aliases='Dmel_ Dmel\\CG4133', description='CG4133 gene product from transcript CG4133-RC', other_designations='CG4133-PA|CG4133-PB|CG4133-PC', map_location='21C2-21C8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=455531, end_position_on_the_genomic_accession=458745, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33222 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33222, CurrentID=0, Status='live', Symbol='CG4297', Aliases='Dmel_ Dmel\\CG4297', description='CG4297 gene product from transcript CG4297-RC', other_designations='CG4297-PC|CG4297-PD', map_location='21C8-21D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=458876, end_position_on_the_genomic_accession=472200, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33223 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33223, CurrentID=0, Status='live', Symbol='MED15', Aliases='Dmel_CG4184, Arc105, BcDNA:GH03922, CG4184, Dmel\\CG4184, Med15, Med9/ARC105, dARC105, med15', description='Mediator complex subunit 15', other_designations='CG4184-PA|MED15-PA|mediator complex subunit 15|mediator15', map_location='21D1-21D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=473013, end_position_on_the_genomic_accession=476170, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33224 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33224, CurrentID=0, Status='live', Symbol='cbt', Aliases='Dmel_CG4427, CG4427, Cabot, Cabut, Dmel\\CG4427, EP(2)2237, EP2237, dTIEG', description='cabut', other_designations='CG4427-PA|CG4427-PB|CG4427-PC|TGF-beta-inducible early gene|cabot|cbt-PA|cbt-PB|cbt-PC', map_location='21D1-21D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=476446, end_position_on_the_genomic_accession=479688, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33225 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33225, CurrentID=0, Status='live', Symbol='ush', Aliases='Dmel_CG2762, CG2762, Dmel\\CG2762, FOG, Ush, ZFPM2, dFOG, l(2)19, u-shaped, ush', description='u-shaped', other_designations='CG2762-PA|CG2762-PB|CG2762-PC|CG2762-PD|CG2762-PE|U-shaped|drosophila friend of GATA|friend of GATA|ush-PA|ush-PB|ush-PC|ush-PD|ush-PE|ushaped', map_location='2-0.1 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=476220, end_position_on_the_genomic_accession=540560, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  33226 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33226, CurrentID=0, Status='live', Symbol='lwr', Aliases='Dmel_CG3018, CG3018, DUbc9, DmUbc9, Dmel\\CG3018, Dmubc9, FBgn0010602, Iwr, Lwr, UBC9, Ubc 9, Ubc-9, Ubc9, UbcD9, dUBC9, dUbc9, dip4, hbl, i105, i56, l(2)01519, l(2)02858, l(2)05486, l(2)05487, semi, ubc9', description='lesswright', other_designations='CG3018-PA|CG3018-PB|CG3018-PC|CG3018-PD|hunchback-like|lwr-PA|lwr-PB|lwr-PC|lwr-PD|semushi|ubiquitin conjugating enzyme 9|ubiquitin-conjugating enzyme 9', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=540599, end_position_on_the_genomic_accession=542580, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33227 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33227, CurrentID=0, Status='live', Symbol='Spp', Aliases='Dmel_CG11840, CG11840, DmSPP, Dmel\\CG11840, SPP, spp', description='Signal peptide peptidase', other_designations='CG11840-PA|Spp-PA|shanti|signal peptide peptidase|signal peptide protease', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=542786, end_position_on_the_genomic_accession=544653, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33228 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33228, CurrentID=0, Status='live', Symbol='nAChRbeta3', Aliases='Dmel_CG11822, CG11822, CT33131, Dbeta3, Dmel\\CG11822, nAChR, nAcR-21Beta, nAcRbeta-21C', description='nicotinic Acetylcholine Receptor beta3', other_designations='CG11822-PA|Dbeta3|nAChRbeta3-PA|nicotinic acetylcholine receptor beta 21C|nicotinic acetylcholine receptor beta3', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=545129, end_position_on_the_genomic_accession=547096, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33229 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33229, CurrentID=0, Status='live', Symbol='Ets21C', Aliases='Dmel_CG2914, CG2914, D-Ets-6, D-Ets6, D-ets-6, Dmel\\CG2914, ETS6, Ets, Ets6, ets21C, ets21c', description='Ets at 21C', other_designations='CG2914-PA|CG2914-PB|CG2914-PC|CG2914-PD|Ets21C-PA|Ets21C-PB|Ets21C-PC|Ets21C-PD', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=544925, end_position_on_the_genomic_accession=552923, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33230 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33230, CurrentID=0, Status='live', Symbol='rempA', Aliases='Dmel_CG11838, CG11838, CHE-11, Che-11, Dmel\\CG11838, IFT140, IFT40, OSEG, OSEG3, Oseg3, REMPA, oseg3, remp', description='reduced mechanoreceptor potential A', other_designations='CG11838-PB|CG11838-PC|Oseg3|RempA|reduced mechanoreceptor potentials|reduced mechanoreceptor potentials A|rempA-PB|rempA-PC', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=553742, end_position_on_the_genomic_accession=560310, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33231 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33231, CurrentID=0, Status='live', Symbol='Tspo', Aliases='Dmel_CG2789, CG2789, Dmel\\CG2789, anon-EST:Posey116, dTSPO, tspo', description='Translocator protein', other_designations='CG2789-PA|Tspo-PA|translocator protein', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=559612, end_position_on_the_genomic_accession=560523, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33232 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33232, CurrentID=0, Status='live', Symbol='CG11835', Aliases='Dmel_ Dmel\\CG11835', description='CG11835 gene product from transcript CG11835-RD', other_designations='CG11835-PA|CG11835-PB|CG11835-PC|CG11835-PD|uncharacterized protein', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=560568, end_position_on_the_genomic_accession=563819, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33233 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33233, CurrentID=0, Status='live', Symbol='CG2794', Aliases='Dmel_ Dmel\\CG2794', description='CG2794 gene product from transcript CG2794-RA', other_designations='CG2794-PA', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=564163, end_position_on_the_genomic_accession=566472, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33234 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33234, CurrentID=0, Status='live', Symbol='Nle', Aliases='Dmel_CG2863, CG2863, Dmel\\CG2863, anon-WO0026364, l(2)k13714', description='Notchless', other_designations='CG2863-PA|Nle-PA|notchless', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=566366, end_position_on_the_genomic_accession=568121, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33235 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33235, CurrentID=0, Status='live', Symbol='CG2807', Aliases='Dmel_ Dmel\\CG2807, SF3B, anon-21Cd', description='CG2807 gene product from transcript CG2807-RB', other_designations='CG2807-PA|CG2807-PB', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=568340, end_position_on_the_genomic_accession=572907, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33236 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33236, CurrentID=0, Status='live', Symbol='Ipk2', Aliases='Dmel_CG13688, CG13688, Dmel\\CG13688, dm', description='CG13688 gene product from transcript CG13688-RA', other_designations='CG13688-PA|Ipk2-PA', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=573033, end_position_on_the_genomic_accession=574264, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33237 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33237, CurrentID=0, Status='live', Symbol='cold', Aliases='Dmel_CG2813, CG2813, Dmel\\CG2813, cg2813, leaky4', description='coiled', other_designations='CG2813-PA|CG2813-PB|cold-PA|cold-PB', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=574291, end_position_on_the_genomic_accession=575734, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33238 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33238, CurrentID=0, Status='live', Symbol='Ptth', Aliases='Dmel_CG13687, CG13687, Dmel\\CG13687, PTTH, phm, ptth', description='Prothoracicotropic hormone', other_designations='CG13687-PE|CG13687-PF|CG13687-PG|Ptth-PE|Ptth-PF|Ptth-PG|prothoracicotopic hormone|prothoracicotropic hormone', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=575711, end_position_on_the_genomic_accession=576896, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33239 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33239, CurrentID=0, Status='live', Symbol='Pph13', Aliases='Dmel_CG2819, 60Mun1, CG2819, Dmel\\CG2819, Mu, PPH13, pph13', description='PvuII-PstI homology 13', other_designations='CG2819-PA|Pph13-PA|hazy|munster', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=577486, end_position_on_the_genomic_accession=579549, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33240 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33240, CurrentID=0, Status='live', Symbol='Gsc', Aliases='Dmel_CG2851, 60Mun1, 60Mun2, CG2851, D-Gsc, D-gsc, Dmel\\CG2851, M72, PPH25, Pph25, gsc, l(2)05341', description='Goosecoid', other_designations='CG2851-PC|CG2851-PD|CG2851-PE|Gsc-PC|Gsc-PD|Gsc-PE|goosecoid|muenster 72', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=583540, end_position_on_the_genomic_accession=594685, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33241 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33241, CurrentID=0, Status='live', Symbol='CG13689', Aliases='Dmel_ Dmel\\CG13689', description='CG13689 gene product from transcript CG13689-RB', other_designations='CG13689-PA|CG13689-PB|uncharacterized protein', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=602813, end_position_on_the_genomic_accession=604430, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33242 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33242, CurrentID=0, Status='live', Symbol='lectin-21Cb', Aliases='Dmel_CG13686, AC 004573B, AC004573b, CG13686, Dmel\\CG13686', description='CG13686 gene product from transcript CG13686-RB', other_designations='CG13686-PB|Lectin21Cb|lectin-21Cb-PB', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=620298, end_position_on_the_genomic_accession=621201, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33244 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33244, CurrentID=0, Status='live', Symbol='CG2839', Aliases='Dmel_ Dmel\\CG2839', description='CG2839 gene product from transcript CG2839-RA', other_designations='CG2839-PA', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=625652, end_position_on_the_genomic_accession=628200, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33245 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33245, CurrentID=0, Status='live', Symbol='ds', Aliases='Dmel_CG17941, CG17941, CT39575, Dmel\\CG17941, Ds, EP-822, cad2, dachs, l(2)05142', description='dachsous', other_designations='CG17941-PA|CG17941-PB|cadherin-2|daschous|ds-PA|ds-PB', map_location='2-0.3 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=640013, end_position_on_the_genomic_accession=714983, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  33247 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33247, CurrentID=0, Status='live', Symbol='Eaat2', Aliases='Dmel_CG3159, CG3159, Dmel\\CG3159, EAAT, dEAAT2, dEaat2', description='Excitatory amino acid transporter 2', other_designations='CG3159-PA|CG3159-PC|CG3159-PD|Eaat2-PA|Eaat2-PC|Eaat2-PD|excitatory amino acid transporter 2|sodium-dependent excitatory amino acid transporter 2', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=737212, end_position_on_the_genomic_accession=744395, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33248 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33248, CurrentID=0, Status='live', Symbol='GABA-B-R3', Aliases='Dmel_CG3022, CG3022, D-GABA[[B]]R3, D-Gaba3, Dmel\\CG3022, GABA B R3, GABA[[B]]-R3, GABA[[B]]R3, GB3, anon-WO0170980.13, anon-WO0170980.14', description='metabotropic GABA-B receptor subtype 3', other_designations='CG3022-PA|CG3022-PC|CG3022-PD|CG3022-PE|CG3022-PF|CG3022-PG|CG3022-PH|GABA-B receptor subtype 3|GABA-B-R3-PA|GABA-B-R3-PC|GABA-B-R3-PD|GABA-B-R3-PE|GABA-B-R3-PF|GABA-B-R3-PG|GABA-B-R3-PH', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=749945, end_position_on_the_genomic_accession=762399, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  33249 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33249, CurrentID=0, Status='live', Symbol='CG12506', Aliases='Dmel_ Dmel\\CG12506, cg12506', description='CG12506 gene product from transcript CG12506-RA', other_designations='CG12506-PA|uncharacterized protein', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=773547, end_position_on_the_genomic_accession=774017, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33250 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33250, CurrentID=0, Status='live', Symbol='CG13947', Aliases='Dmel_ Dmel\\CG13947', description='CG13947 gene product from transcript CG13947-RA', other_designations='CG13947-PA|uncharacterized protein', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=779173, end_position_on_the_genomic_accession=779655, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33251 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33251, CurrentID=0, Status='live', Symbol='Gr21a', Aliases='Dmel_CG13948, (GR) 21a, 21D.1, CG13948, DmGr21a, Dmel\\CG13948, GR21D.1, GR21D1, GR21a, Gr21D1, gr21a', description='Gustatory receptor 21a', other_designations='CG13948-PA|CG13948-PB|Gr21a-PA|Gr21a-PB|gustatory receptor 21D.1|gustatory receptor 21a', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=780482, end_position_on_the_genomic_accession=782885, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33252 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33252, CurrentID=0, Status='live', Symbol='CG3544', Aliases='Dmel_ Dmel\\CG3544', description='CG3544 gene product from transcript CG3544-RB', other_designations='CG3544-PA|CG3544-PB', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=784336, end_position_on_the_genomic_accession=788776, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33253 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33253, CurrentID=0, Status='live', Symbol='Pkg21D', Aliases='Dmel_CG3324, CG3324, DG1, Dg1, Dmel\\CG3324, PKG, PKG 21D, PKG-21D, Pkg1, cGMP, dg1, pkg21D', description='Protein kinase, cGMP-dependent at 21D', other_designations='CG3324-PA|Pkg21D-PA|cGMP-dependent protein kinase 21D|protein kinase, cGMP-dependent at 21D', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=786153, end_position_on_the_genomic_accession=790798, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33254 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33254, CurrentID=0, Status='live', Symbol='Dbp21E2', Aliases='Dmel_CG3561, CG3561, DmRH9, Dmel\\CG3561, KH1, cg3561', description='DEAD box protein 21E2', other_designations='CG3561-PA|Dbp21E2-PA|KH1', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=811584, end_position_on_the_genomic_accession=813380, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33255 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33255, CurrentID=0, Status='live', Symbol='Saf6', Aliases='Dmel_CG3883, CG3883, Dmel\\CG3883, SAF6, saf6', description='SAGA factor-like TAF6', other_designations='CG3883-PA|CG3883-PB|Saf6-PA|Saf6-PB', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=813314, end_position_on_the_genomic_accession=815950, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33256 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33256, CurrentID=0, Status='live', Symbol='Pex12', Aliases='Dmel_CG3639, CG3639, DmelPex12, Dmel\\CG3639, PEX12, pex12', description='Peroxin 12', other_designations='CG3639-PA|CG3639-PB|Pex12-PA|Pex12-PB|peroxin 12', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=815993, end_position_on_the_genomic_accession=818096, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33257 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33257, CurrentID=0, Status='live', Symbol='CG15880', Aliases='Dmel_ Dmel\\CG15880', description='CG15880 gene product from transcript CG15880-RA', other_designations='CG15880-PA|uncharacterized protein', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=816994, end_position_on_the_genomic_accession=817950, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33258 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33258, CurrentID=0, Status='live', Symbol='CG3876', Aliases='Dmel_ Dmel\\CG3876', description='CG3876 gene product from transcript CG3876-RA', other_designations='CG3876-PA', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=818079, end_position_on_the_genomic_accession=819508, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33259 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33259, CurrentID=0, Status='live', Symbol='Clp', Aliases='Dmel_CG3642, CG3642, CLP, CPSF30, Cpsf30, Dmel\\CG3642, Ssb-c6a, c6a, clp', description='Clipper', other_designations='CG3642-PA|Clp-PA|clipper|single stranded-binding protein c6a', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=819964, end_position_on_the_genomic_accession=821209, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33260 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33260, CurrentID=0, Status='live', Symbol='CG3662', Aliases='Dmel_ Dmel\\CG3662', description='CG3662 gene product from transcript CG3662-RD', other_designations='CG3662-PA|CG3662-PB|CG3662-PC|CG3662-PD', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=821289, end_position_on_the_genomic_accession=824337, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33261 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33261, CurrentID=0, Status='live', Symbol='CG3862', Aliases='Dmel_ Dmel\\CG3862', description='CG3862 gene product from transcript CG3862-RA', other_designations='CG3862-PA|RCC GEF-related protein', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=824329, end_position_on_the_genomic_accession=825861, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33262 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33262, CurrentID=0, Status='live', Symbol='dock', Aliases='Dmel_CG3727, CG3727, DOCK, Dm0447, Dmel\\CG3727, Dock, Nck, dck, doc, l(2)04723', description='dreadlocks', other_designations='CG3727-PA|CG3727-PB|CG3727-PC|CG3727-PD|dock-PA|dock-PB|dock-PC|dock-PD', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=825969, end_position_on_the_genomic_accession=833241, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33263 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33263, CurrentID=0, Status='live', Symbol='drongo', Aliases='Dmel_CG3365, CG3365, Dmel\\CG3365', description='CG3365 gene product from transcript CG3365-RH', other_designations='CG3365-PC|CG3365-PF|CG3365-PG|CG3365-PH|CG3365-PI|drongo-PC|drongo-PF|drongo-PG|drongo-PH|drongo-PI', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=833584, end_position_on_the_genomic_accession=851071, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33264 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33264, CurrentID=0, Status='live', Symbol='CG4291', Aliases='Dmel_ Dmel\\CG4291', description='CG4291 gene product from transcript CG4291-RB', other_designations='CG4291-PA|CG4291-PB', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=851251, end_position_on_the_genomic_accession=852730, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33265 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33265, CurrentID=0, Status='live', Symbol='kraken', Aliases='Dmel_CG3943, CG3943, Dmel\\CG3943, Kraken', description='CG3943 gene product from transcript CG3943-RA', other_designations='CG3943-PA|CG3943-PB|kraken-PA|kraken-PB', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=852768, end_position_on_the_genomic_accession=854539, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33266 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33266, CurrentID=0, Status='live', Symbol='CG13949', Aliases='Dmel_ BcDNA:AT06839, Dmel\\CG13949', description='CG13949 gene product from transcript CG13949-RA', other_designations='CG13949-PA|CG13949-PB|CG13949-PC|uncharacterized protein', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=855337, end_position_on_the_genomic_accession=856639, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33267 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33267, CurrentID=0, Status='live', Symbol='CG13950', Aliases='Dmel_ Dmel\\CG13950', description='CG13950 gene product from transcript CG13950-RA', other_designations='CG13950-PA|uncharacterized protein', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=860309, end_position_on_the_genomic_accession=861806, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33268 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33268, CurrentID=0, Status='live', Symbol='aru', Aliases='Dmel_CG4276, CG4276, Dmel\\CG4276, EPS8L3', description='arouser', other_designations='CG4276-PA|CG4276-PC|CG4276-PD|EPS8L3|aru-PA|aru-PC|aru-PD', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=861849, end_position_on_the_genomic_accession=868354, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  33269 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33269, CurrentID=0, Status='live', Symbol='dbe', Aliases='Dmel_CG4258, CG4258, DBE, Dmel\\CG4258, l(2)k05428, l(2)k06708', description='dribble', other_designations='CG4258-PA|dbe-PA', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=868673, end_position_on_the_genomic_accession=869857, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33270 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33270, CurrentID=0, Status='live', Symbol='PNUTS', Aliases='Dmel_CG33526, CG31657, CG33526, CG4124, Dmel\\CG33526-RB, PNUTSDm, Pnuts', description='CG33526 gene product from transcript CG33526-RD', other_designations='CG33526-PA|CG33526-PB|CG33526-PD|CG33526-PE|PNUTS-PA|PNUTS-PB|PNUTS-PD|PNUTS-PE', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=870465, end_position_on_the_genomic_accession=877038, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33271 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33271, CurrentID=0, Status='live', Symbol='ninaA', Aliases='Dmel_CG3966, CG3966, Dmel\\CG3966, NINAA, NinaA, ninA', description='neither inactivation nor afterpotential A', other_designations='CG3966-PA|either inactivation nor afterpotential A|neither inactivation nor after potential|ninaA-PA', map_location='2-1.4 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=877302, end_position_on_the_genomic_accession=878270, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33272 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33272, CurrentID=0, Status='live', Symbol='CG15824', Aliases='Dmel_ Dmel\\CG15824', description='CG15824 gene product from transcript CG15824-RC', other_designations='CG15824-PB|CG15824-PC|uncharacterized protein', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=877172, end_position_on_the_genomic_accession=885141, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  33274 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33274, CurrentID=0, Status='live', Symbol='Lsp1beta', Aliases='Dmel_CG4178, CG4178, DmeLSP1b, Dmel\\CG4178, LSP 1, LSP-1, LSP-1 beta, LSP-1beta, LSP1, LSP1beta, Lsp-1b, Lsp-1beta, Lsp1, Lsp1-beta, Lsp1[beta], Lsp1b', description='Larval serum protein 1 beta', other_designations='CG4178-PA|CG4178-PB|Lsp1beta-PA|Lsp1beta-PB|larval serum protein 1|larval serum protein 1 beta|larval serum protein 1[beta]|larval serum protein 1beta', map_location='2-1.9 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=898500, end_position_on_the_genomic_accession=901316, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33275 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33275, CurrentID=0, Status='live', Symbol='GluRIIC', Aliases='Dmel_CG4226, CG4226, CT13021, DGluR-IIC, DGluRIIC, DGluRIII, DmelGluRIIC, Dmel\\CG4226, GLURIIC, GluR, GluR3, GluRC, GluRII-C/III, GluRIII, GlutRIII, glutamate receptor III, GluRIIC', description='Glutamate receptor IIC', other_designations='CG4226-PD|GluRIIC-PD|common type III glutamate receptor subunit|essential glutamate receptor subunit III|glutamate receptor|glutamate receptor IIC|glutamate receptor III|glutamate receptor subunit III', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=914086, end_position_on_the_genomic_accession=917805, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  33276 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33276, CurrentID=0, Status='live', Symbol='CG4341', Aliases='Dmel_ BcDNA:GH12144, Dmel\\CG4341', description='CG4341 gene product from transcript CG4341-RA', other_designations='CG4341-PA|CG4341-PC', map_location='21E2-21E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=922793, end_position_on_the_genomic_accession=958098, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  33277 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33277, CurrentID=0, Status='live', Symbol='IA-2', Aliases='Dmel_CG31795, CG11344, CG31795, CG4355, Dmel\\CG31795, R-PTPX/1A2, anon-WO0153538.69, ia2', description='IA-2 protein tyrosine phosphatase', other_designations='CG31795-PC|CG31795-PD|CG31795-PE|IA-2 ortholog|IA-2-PC|IA-2-PD|IA-2-PE|ia2', map_location='21E3-21E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1008378, end_position_on_the_genomic_accession=1048053, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  33278 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33278, CurrentID=0, Status='live', Symbol='CG4375', Aliases='Dmel_ BcDNA:AT13819, Dmel\\CG4375', description='CG4375 gene product from transcript CG4375-RA', other_designations='CG4375-PA', map_location='21E3-21E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1026105, end_position_on_the_genomic_accession=1026897, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33279 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33279, CurrentID=0, Status='live', Symbol='CG4415', Aliases='Dmel_ Dmel\\CG4415', description='CG4415 gene product from transcript CG4415-RA', other_designations='CG4415-PA|CG4415-PB', map_location='21E3-21E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1037246, end_position_on_the_genomic_accession=1038685, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33281 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33281, CurrentID=0, Status='live', Symbol='S', Aliases='Dmel_CG4385, CG4385, Dmel\\CG4385, E(Raf)2B, EC2-2, EK2-2, ES2-4, EY2-4tar/asteroid, fltr, l(2)05671, l(2)07056, l(2)21Eb, l(2)c00080, l(2)k09538, l(2)rK134, star, S', description='Star', other_designations='CG4385-PA|CG4385-PB|S-PA|S-PB|enhancer of GMR-sina 2-4|floater|lethal (2) c00080|star', map_location='2-1.3 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1049674, end_position_on_the_genomic_accession=1077815, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33282 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33282, CurrentID=0, Status='live', Symbol='ast', Aliases='Dmel_CG4426, CG4426, Dmel\\CG4426, S[r], Star/asteroid', description='asteroid', other_designations='CG4426-PA|Star-recessive|ast-PA', map_location='21E4-21E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1077948, end_position_on_the_genomic_accession=1080803, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33283 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33283, CurrentID=0, Status='live', Symbol='Atg4a', Aliases='Dmel_CG4428, APG4, ATG4, AUT2, Atg4, CG4428, Dmel\\CG4428, atg4', description='Autophagy-related 4a', other_designations='Atg4a-PA|Atg4a-PB|Autophagy-specific gene 4|Autophagy-specific gene 4a|CG4428-PA|CG4428-PB', map_location='21E4-21E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1080911, end_position_on_the_genomic_accession=1085380, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33284 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33284, CurrentID=0, Status='live', Symbol='CG4629', Aliases='Dmel_ Dmel\\CG4629, anon-WO0257455.15', description='CG4629 gene product from transcript CG4629-RE', other_designations='CG4629-PE|CG4629-PF', map_location='21E4-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1083091, end_position_on_the_genomic_accession=1102504, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  33285 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33285, CurrentID=0, Status='live', Symbol='mtRNApol', Aliases='Dmel_CG4644, CG4644, Dmel\\CG4644, POLRMT, mt RNA pol, mtRNA-pol', description='mitochondrial RNA polymerase', other_designations='CG4644-PA|CG4644-PB|mtRNApol-PA|mtRNApol-PB', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1103254, end_position_on_the_genomic_accession=1108373, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33286 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33286, CurrentID=0, Status='live', Symbol='CG14339', Aliases='Dmel_ Dmel\\CG14339', description='CG14339 gene product from transcript CG14339-RA', other_designations='CG14339-PA|uncharacterized protein', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1108540, end_position_on_the_genomic_accession=1112694, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33287 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33287, CurrentID=0, Status='live', Symbol='CG14340', Aliases='Dmel_ Dmel\\CG14340', description='CG14340 gene product from transcript CG14340-RA', other_designations='CG14340-PA|uncharacterized protein', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1112941, end_position_on_the_genomic_accession=1114138, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33288 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33288, CurrentID=0, Status='live', Symbol='Pino', Aliases='Dmel_CG4710, CG4710, Dmel\\CG4710, anon-WO0118547.131, smi21F', description='Pinocchio', other_designations='CG4710-PA|CG4710-PB|CG4710-PC|Pino-PA|Pino-PB|Pino-PC|pinocchio|smell impaired 21 F|smell impaired 21F|smell imparied 21 F', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1114654, end_position_on_the_genomic_accession=1128953, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33289 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33289, CurrentID=0, Status='live', Symbol='CG4552', Aliases='Dmel_ Dmel\\CG4552', description='CG4552 gene product from transcript CG4552-RA', other_designations='CG4552-PA', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1129316, end_position_on_the_genomic_accession=1132411, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33290 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33290, CurrentID=0, Status='live', Symbol='Iris', Aliases='Dmel_CG4715, CG4715, CG4715-env, Dm-cF, Dmel\\CG4715', description='CG4715 gene product from transcript CG4715-RA', other_designations='CG4715-PA|Iris-PA|iris', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1132332, end_position_on_the_genomic_accession=1134098, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33291 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33291, CurrentID=0, Status='live', Symbol='CG4577', Aliases='Dmel_ Dmel\\CG4577', description='CG4577 gene product from transcript CG4577-RB', other_designations='CG4577-PA|CG4577-PB', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1134693, end_position_on_the_genomic_accession=1141156, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33292 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33292, CurrentID=0, Status='live', Symbol='MFS3', Aliases='Dmel_CG4726, CG4726, Dmel\\CG4726', description='Major Facilitator Superfamily Transporter 3', other_designations='CG4726-PA|MFS3-PA|major facilitator superfamily transporter 3', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1143201, end_position_on_the_genomic_accession=1147395, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33293 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33293, CurrentID=0, Status='live', Symbol='CG4749', Aliases='Dmel_ Dmel\\CG4749, anon-WO0118547.81', description='CG4749 gene product from transcript CG4749-RA', other_designations='CG4749-PA', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1147822, end_position_on_the_genomic_accession=1149449, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33294 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33294, CurrentID=0, Status='live', Symbol='Tfb4', Aliases='Dmel_CG5041, CG5041, Dmel\\CG5041, Dmp34, TFB4', description='TFB4 ortholog (S. cerevisiae)', other_designations='CG5041-PA|TFB4 ortholog|Tfb4-PA', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1149445, end_position_on_the_genomic_accession=1150677, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33295 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33295, CurrentID=0, Status='live', Symbol='Vps29', Aliases='Dmel_CG4764, CG4764, DmVps29, Dmel\\CG4764, VPS29', description='Vacuolar protein sorting 29', other_designations='CG4764-PA|Vps29-PA|vacuolar protein sorting 29', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1150766, end_position_on_the_genomic_accession=1151764, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33298 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33298, CurrentID=0, Status='live', Symbol='Tango14', Aliases='Dmel_CG4775, BcDNA:SD10843, CG4775, Dmel\\CG4775, TANGO14, Tango 14, l(2)k00619', description='Transport and Golgi organization 14', other_designations='CG4775-PA|CG4775-PB|Tango14-PA|Tango14-PB|lethal (2) k00619|transport and golgi organization 14', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1158661, end_position_on_the_genomic_accession=1160220, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33299 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33299, CurrentID=0, Status='live', Symbol='CG5080', Aliases='Dmel_ CT16297, Dmel\\CG5080', description='CG5080 gene product from transcript CG5080-RB', other_designations='CG5080-PA|CG5080-PB|CG5080-PC', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1160290, end_position_on_the_genomic_accession=1163886, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33300 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33300, CurrentID=0, Status='live', Symbol='IntS14', Aliases='Dmel_CG4785, CG4785, Dmel\\CG4785, Q9VPY0', description='Integrator 14', other_designations='CG4785-PA|IntS14-PA|integrator 14', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1164443, end_position_on_the_genomic_accession=1166425, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33301 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33301, CurrentID=0, Status='live', Symbol='CG14341', Aliases='Dmel_ Dmel\\CG14341', description='CG14341 gene product from transcript CG14341-RB', other_designations='CG14341-PB|uncharacterized protein', map_location='21F1-21F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1166506, end_position_on_the_genomic_accession=1167211, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33303 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33303, CurrentID=0, Status='live', Symbol='CG5118', Aliases='Dmel_ Dmel\\CG5118, anon-WO0140519.11', description='CG5118 gene product from transcript CG5118-RA', other_designations='CG5118-PA', map_location='21F2-21F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1170753, end_position_on_the_genomic_accession=1172805, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33304 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33304, CurrentID=0, Status='live', Symbol='CG4887', Aliases='Dmel_ Dmel\\CG4887, cg4887', description='CG4887 gene product from transcript CG4887-RB', other_designations='CG4887-PA|CG4887-PB', map_location='21F2-21F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1173009, end_position_on_the_genomic_accession=1177589, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  33305 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33305, CurrentID=0, Status='live', Symbol='CG4896', Aliases='Dmel_ Dmel\\CG4896, cg4896', description='CG4896 gene product from transcript CG4896-RJ', other_designations='CG4896-PD|CG4896-PG|CG4896-PI|CG4896-PJ|CG4896-PK', map_location='21F2-21F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1177690, end_position_on_the_genomic_accession=1182454, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  33306 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33306, CurrentID=0, Status='live', Symbol='CG5126', Aliases='Dmel_ Dmel\\CG5126', description='CG5126 gene product from transcript CG5126-RA', other_designations='CG5126-PA', map_location='21F2-21F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1182297, end_position_on_the_genomic_accession=1184020, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33307 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33307, CurrentID=0, Status='live', Symbol='Tgt', Aliases='Dmel_CG4947, CG4947, Dmel\\CG4947, TGT, tgt', description='tRNA-guanine transglycosylase', other_designations='CG4947-PA|Tgt-PA', map_location='21F2-21F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1184065, end_position_on_the_genomic_accession=1185698, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33308 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33308, CurrentID=0, Status='live', Symbol='CG5001', Aliases='Dmel_ Dmel\\CG5001', description='CG5001 gene product from transcript CG5001-RB', other_designations='CG5001-PA|CG5001-PB|CG5001-PC|CG5001-PD', map_location='21F2-21F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1185757, end_position_on_the_genomic_accession=1196807, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33309 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33309, CurrentID=0, Status='live', Symbol='CG5139', Aliases='Dmel_ Dmel\\CG5139', description='CG5139 gene product from transcript CG5139-RA', other_designations='CG5139-PA', map_location='21F2-21F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1198465, end_position_on_the_genomic_accession=1199266, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33310 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33310, CurrentID=0, Status='live', Symbol='CG14342', Aliases='Dmel_ Dmel\\CG14342', description='CG14342 gene product from transcript CG14342-RB', other_designations='CG14342-PB|uncharacterized protein', map_location='21F2-21F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1204215, end_position_on_the_genomic_accession=1205250, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33312 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33312, CurrentID=0, Status='live', Symbol='CG42329', Aliases='Dmel_ CG14343, CG5156, CT16503, Dmel\\CG42329, Dmel_CG14343, Dmel_CG5156', description='CG42329 gene product from transcript CG42329-RA', other_designations='CG42329-PA|uncharacterized protein', map_location='21F2-21F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1219293, end_position_on_the_genomic_accession=1229802, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33313 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33313, CurrentID=0, Status='live', Symbol='CG5397', Aliases='Dmel_ CT16527, Dmel\\CG5397', description='CG5397 gene product from transcript CG5397-RB', other_designations='CG5397-PA|CG5397-PB', map_location='21F3-21F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1240036, end_position_on_the_genomic_accession=1243018, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33314 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33314, CurrentID=0, Status='live', Symbol='robo3', Aliases='Dmel_CG5423, CG14345, CG5423, CT17158, Dmel\\CG5423, ROBO3, Robo 3, Robo-3, Robo3, dRobo-3', description='roundabout 3', other_designations='CG5423-PA|CG5423-PB|robo3-PA|robo3-PB', map_location='21F3-21F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1256417, end_position_on_the_genomic_accession=1296596, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  33317 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33317, CurrentID=0, Status='live', Symbol='a5', Aliases='Dmel_CG5430, A5, CG5430, Dmel\\CG5430', description='antennal protein 5', other_designations='CG5430-PA|a5-PA', map_location='22A1-22A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1329161, end_position_on_the_genomic_accession=1329993, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33318 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33318, CurrentID=0, Status='live', Symbol='CG5440', Aliases='Dmel_ Dmel\\CG5440', description='CG5440 gene product from transcript CG5440-RC', other_designations='CG5440-PB|CG5440-PC', map_location='22A1-22A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1334128, end_position_on_the_genomic_accession=1335514, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33319 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33319, CurrentID=0, Status='live', Symbol='Cdlc2', Aliases='Dmel_CG5450, CG5450, Cdcl2, Dmel\\CG5450, anon-WO0140519.117, dlc', description='Cytoplasmic dynein light chain 2', other_designations='8kd dynein light chain|CG5450-PA|CG5450-PB|CG5450-PC|Cdlc2-PA|Cdlc2-PB|Cdlc2-PC|cyto dynein light chain 2|cytoplasmic dynein|cytoplasmic dynein light chain 2|dynein', map_location='22A1-22A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1344400, end_position_on_the_genomic_accession=1345135, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33320 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33320, CurrentID=0, Status='live', Symbol='CG5556', Aliases='Dmel_ Dmel\\CG5556', description='CG5556 gene product from transcript CG5556-RA', other_designations='CG5556-PA|CG5556-PB', map_location='22A1-22A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1351728, end_position_on_the_genomic_accession=1352868, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33321 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33321, CurrentID=0, Status='live', Symbol='CG5561', Aliases='Dmel_ Dmel\\CG5561', description='CG5561 gene product from transcript CG5561-RA', other_designations='CG5561-PA', map_location='22A1-22A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1352970, end_position_on_the_genomic_accession=1354109, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33323 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33323, CurrentID=0, Status='live', Symbol='CG5565', Aliases='Dmel_ 28557659, Dmel\\CG5565', description='CG5565 gene product from transcript CG5565-RA', other_designations='CG5565-PA', map_location='22A1-22A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1354911, end_position_on_the_genomic_accession=1355924, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33324 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33324, CurrentID=0, Status='live', Symbol='NLaz', Aliases='Dmel_CG33126, BcDNA:RE67583, CG16933, CG33126, CT33980, DNLaz, Dmel\\CG33126, Nlaz', description='Neural Lazarillo', other_designations='CG33126-PA|CG33126-PB|CG33126-PC|NLaz-PA|NLaz-PB|NLaz-PC|neural lazarillo', map_location='22A1-22A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1359837, end_position_on_the_genomic_accession=1361821, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33325 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33325, CurrentID=0, Status='live', Symbol='CG14346', Aliases='Dmel_ Dmel\\CG14346', description='CG14346 gene product from transcript CG14346-RC', other_designations='CG14346-PA|CG14346-PC|CG14346-PD|uncharacterized protein', map_location='22A1-22A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1367996, end_position_on_the_genomic_accession=1369050, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  2768989 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=2768989, CurrentID=0, Status='live', Symbol='CG33284', Aliases='Dmel_ Dmel\\CG33284, NEST:bs10b10', description='CG33284 gene product from transcript CG33284-RA', other_designations='CG33284-PA|uncharacterized protein', map_location='78B2-78B2', chromosome='3L', genomic_nucleotide_accession_version='NT_037436.4', start_position_on_the_genomic_accession=21123753, end_position_on_the_genomic_accession=21124884, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33330 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33330, CurrentID=0, Status='live', Symbol='CG31661', Aliases='Dmel_ CG10872, Dmel\\CG31661', description='CG31661 gene product from transcript CG31661-RA', other_designations='CG31661-PA|aspartic-type endopeptidase|uncharacterized protein', map_location='22A2-22A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1497243, end_position_on_the_genomic_accession=1498583, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33331 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33331, CurrentID=0, Status='live', Symbol='CG18131', Aliases='Dmel_ BcDNA:AT12853, Dmel\\CG18131', description='CG18131 gene product from transcript CG18131-RG', other_designations='CG18131-PA|CG18131-PB|CG18131-PC|CG18131-PD|CG18131-PG|CG18131-PH|uncharacterized protein', map_location='22A2-22A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1498455, end_position_on_the_genomic_accession=1500608, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33332 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33332, CurrentID=0, Status='live', Symbol='CG7420', Aliases='Dmel_ Dmel\\CG7420', description='CG7420 gene product from transcript CG7420-RB', other_designations='CG7420-PA|CG7420-PB', map_location='22A2-22A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1500784, end_position_on_the_genomic_accession=1502904, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33333 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33333, CurrentID=0, Status='live', Symbol='CG18132', Aliases='Dmel_ Dmel\\CG18132', description='CG18132 gene product from transcript CG18132-RA', other_designations='CG18132-PA|uncharacterized protein', map_location='22A2-22A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1516795, end_position_on_the_genomic_accession=1517478, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33334 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33334, CurrentID=0, Status='live', Symbol='halo', Aliases='Dmel_CG7428, CG7428, Dmel\\CG7428', description='CG7428 gene product from transcript CG7428-RB', other_designations='CG7428-PB|halo-PB', map_location='22A2-22A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1517533, end_position_on_the_genomic_accession=1518148, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33335 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33335, CurrentID=0, Status='live', Symbol='Or22a', Aliases='Dmel_CG12193, 22A.1, 22a, AN11, CG12193, DOR22A.1, DOR22a, DOR53, DmOr22a, Dmel Or22a, Dmel22a, Dmel\\CG12193, Dor53, OR22a, Or22A.1/b, Or53, dOr22a, dor53, Or22a', description='Odorant receptor 22a', other_designations='CG12193-PA|Or22a-PA|odorant receptor 22a|odorant receptor 53|olfactory receptor 22A.1', map_location='22A2-22A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1520491, end_position_on_the_genomic_accession=1522156, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33336 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33336, CurrentID=0, Status='live', Symbol='Or22b', Aliases='Dmel_CG4231, 22A.2, 22b, AN12, CG4231, DOR22A.2, DOR22b, DOR67, Dmel\\CG4231, Dor67, OR22b, Or22A.2, Or22a/b, Or67, dOr22b, dor67, or22b', description='Odorant receptor 22b', other_designations='CG4231-PA|Or22b-PA|dmel Or22b|odorant receptor 22b|odorant receptor 67|olfactory receptor 22A.2', map_location='22A2-22A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1522697, end_position_on_the_genomic_accession=1524257, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33337 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33337, CurrentID=0, Status='live', Symbol='CG10869', Aliases='Dmel_ Dmel\\CG10869', description='CG10869 gene product from transcript CG10869-RA', other_designations='CG10869-PA|uncharacterized protein', map_location='22A3-22A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1584866, end_position_on_the_genomic_accession=1587155, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33338 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33338, CurrentID=0, Status='live', Symbol='CG31935', Aliases='Dmel_ CG10870, CG7373, Dmel\\CG31935', description='CG31935 gene product from transcript CG31935-RA', other_designations='CG31935-PA|uncharacterized protein', map_location='22A3-22A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1594822, end_position_on_the_genomic_accession=1611157, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33339 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33339, CurrentID=0, Status='live', Symbol='haf', Aliases='Dmel_CG14351, CG14351, CT33985, Dmel\\CG14351, tartan/capricious-like', description='hattifattener', other_designations='CG14351-PB|CG14351-PC|CG14351-PD|CG14351-PE|CG14351-PF|haf-PB|haf-PC|haf-PD|haf-PE|haf-PF', map_location='22A3-22A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1555129, end_position_on_the_genomic_accession=1608404, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  33341 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33341, CurrentID=0, Status='live', Symbol='CG14352', Aliases='Dmel_ Dmel\\CG14352', description='CG14352 gene product from transcript CG14352-RA', other_designations='CG14352-PA|uncharacterized protein', map_location='22A3-22A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1611410, end_position_on_the_genomic_accession=1612576, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33343 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33343, CurrentID=0, Status='live', Symbol='chinmo', Aliases='Dmel_CG31666, CG10871, CG17156, CG17649, CG31666, Chinmo, Dmel\\CG31666, F, l(2)04111', description='Chronologically inappropriate morphogenesis', other_designations='CG31666-PA|CG31666-PD|CG31666-PE|CG31666-PF|CG31666-PG|CG31666-PH|chinmo-PA|chinmo-PD|chinmo-PE|chinmo-PF|chinmo-PG|chinmo-PH|chronologically -inappropriate morphogenesis|chronologically inappropriate morphogenesis|lethal (2) 04111', map_location='22A5-22B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1651258, end_position_on_the_genomic_accession=1704682, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  26067040 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=26067040, CurrentID=0, Status='live', Symbol='CG43844', Aliases='Dmel_ CR43844, Dmel\\CG43844', description='CG43844 gene product from transcript CG43844-RF', other_designations='CG43844-PD|CG43844-PE|CG43844-PF|uncharacterized protein', map_location='93F14-93F14', chromosome='3R', genomic_nucleotide_accession_version='NT_033777.3', start_position_on_the_genomic_accession=21889539, end_position_on_the_genomic_accession=21890171, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33346 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33346, CurrentID=0, Status='live', Symbol='cpb', Aliases='Dmel_CG17158, CAPB_DROME, CG17158, CP, CP-beta, CPB, CapZ, Cpb, Dmel\\CG17158, J, bnd', description='capping protein beta', other_designations='CG17158-PA|CG17158-PB|CP beta subunit|Capping-protein-beta|F-actin capping protein|actin capping protein beta|ancpbeta|burned|capping protein|capping proteinbeta|capping proteins beta|cpb-PA|cpb-PB', map_location='22B1-22B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1704902, end_position_on_the_genomic_accession=1706962, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33347 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33347, CurrentID=0, Status='live', Symbol='CG17660', Aliases='Dmel_ Dmel\\CG17660', description='CG17660 gene product from transcript CG17660-RA', other_designations='CG17660-PA|uncharacterized protein', map_location='22B1-22B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1707132, end_position_on_the_genomic_accession=1710421, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33348 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33348, CurrentID=0, Status='live', Symbol='mRpL48', Aliases='Dmel_CG17642, CG17642, Dmel\\CG17642, MRP-L48', description='mitochondrial ribosomal protein L48', other_designations='CG17642-PA|CG17642-PB|mRpL48-PA|mRpL48-PB', map_location='22B1-22B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1710462, end_position_on_the_genomic_accession=1711465, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33349 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33349, CurrentID=0, Status='live', Symbol='frtz', Aliases='Dmel_CG17657, CG17657, Dmel\\CG17657, anon-WO0118547.105', description='fritz', other_designations='CG17657-PA|CG17657-PB|CG17657-PD|frtz-PA|frtz-PB|frtz-PD', map_location='22B1-22B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1711302, end_position_on_the_genomic_accession=1715851, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33350 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33350, CurrentID=0, Status='live', Symbol='Rim2', Aliases='Dmel_CG18317, CG18317, Dmel\\CG18317, drim2', description='Rim2 ortholog (S. cerevisiae)', other_designations='CG18317-PA|CG18317-PC|CG18317-PD|Rim2 ortholog|Rim2-PA|Rim2-PC|Rim2-PD', map_location='22B1-22B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1716244, end_position_on_the_genomic_accession=1724388, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33351 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33351, CurrentID=0, Status='live', Symbol='Eno', Aliases='Dmel_CG17654, BEST:LD15491, CG17654, CT32526, Dmel\\CG17654, ENOA2, T18, anon-WO0153538.76, eno, Eno', description='Enolase', other_designations='CG17654-PA|CG17654-PB|CG17654-PC|CG17654-PD|CG17654-PE|CG17654-PF|Eno-PA|Eno-PB|Eno-PC|Eno-PD|Eno-PE|Eno-PF|enolase|phosphopyruvate hydratase', map_location='22B1-22B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1724768, end_position_on_the_genomic_accession=1729636, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33353 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33353, CurrentID=0, Status='live', Symbol='CG17652', Aliases='Dmel_ Dmel\\CG17652', description='CG17652 gene product from transcript CG17652-RB', other_designations='CG17652-PA|CG17652-PB|uncharacterized protein', map_location='22B1-22B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1731033, end_position_on_the_genomic_accession=1732356, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33354 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33354, CurrentID=0, Status='live', Symbol='CG17646', Aliases='Dmel_ ABCG1, BEST:GH05015, CG17647, Dmel\\CG17646, l(2)SH0142, l(2)SH2 0142', description='CG17646 gene product from transcript CG17646-RB', other_designations='ATP-binding cassette transporter G1|CG17646-PA|CG17646-PB|lethal (2) SH0142|uncharacterized protein', map_location='22A4-22B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1732524, end_position_on_the_genomic_accession=1750612, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  33356 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33356, CurrentID=0, Status='live', Symbol='CG17712', Aliases='Dmel_ BcDNA:GH03377, Dmel\\CG17712', description='CG17712 gene product from transcript CG17712-RA', other_designations='CG17712-PA|uncharacterized protein', map_location='22B2-22B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1750687, end_position_on_the_genomic_accession=1752122, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33357 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33357, CurrentID=0, Status='live', Symbol='CG17648', Aliases='Dmel_ BcDNA:GH02930, Dmel\\CG17648', description='CG17648 gene product from transcript CG17648-RA', other_designations='CG17648-PA|uncharacterized protein', map_location='22B2-22B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1752308, end_position_on_the_genomic_accession=1752848, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33358 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33358, CurrentID=0, Status='live', Symbol='CG17650', Aliases='Dmel_ Dmel\\CG17650', description='CG17650 gene product from transcript CG17650-RA', other_designations='CG17650-PA|uncharacterized protein', map_location='22B2-22B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1758286, end_position_on_the_genomic_accession=1759093, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33359 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33359, CurrentID=0, Status='live', Symbol='CG31664', Aliases='Dmel_ CG15622, Dmel\\CG31664', description='CG31664 gene product from transcript CG31664-RC', other_designations='CG31664-PB|CG31664-PC|uncharacterized protein', map_location='22B3-22B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1824172, end_position_on_the_genomic_accession=1826500, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33360 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33360, CurrentID=0, Status='live', Symbol='c-cup', Aliases='Dmel_CG15623, CG15623, Dmel\\CG15623', description='calcutta cup', other_designations='CG15623-PA|c-cup-PA|calcutta-cup', map_location='22B3-22B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1831627, end_position_on_the_genomic_accession=1832565, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33361 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33361, CurrentID=0, Status='live', Symbol='wry', Aliases='Dmel_CG31665, CG12704, CG15621, CG31665, CT35769, Dmel\\CG31665', description='weary', other_designations='CG31665-PB|CG31665-PC|CG31665-PD|fibropellin|wry-PB|wry-PC|wry-PD', map_location='22B3-22B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1836538, end_position_on_the_genomic_accession=1858550, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  33363 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33363, CurrentID=0, Status='live', Symbol='CG31663', Aliases='Dmel_ BcDNA:GH27779, CG15359, CG15360, Dmel\\CG31663', description='CG31663 gene product from transcript CG31663-RC', other_designations='CG31663-PA|CG31663-PB|CG31663-PC|uncharacterized protein', map_location='22B4-22B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1858609, end_position_on_the_genomic_accession=1881480, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  33365 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33365, CurrentID=0, Status='live', Symbol='CG7295', Aliases='Dmel_ Dmel\\CG7295', description='CG7295 gene product from transcript CG7295-RB', other_designations='CG7295-PA|CG7295-PB', map_location='22B4-22B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1869803, end_position_on_the_genomic_accession=1871032, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33366 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33366, CurrentID=0, Status='live', Symbol='CG15358', Aliases='Dmel_ Dmel\\CG15358, mdcds_4396', description='CG15358 gene product from transcript CG15358-RC', other_designations='CG15358-PB|CG15358-PC|uncharacterized protein', map_location='22B4-22B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1882008, end_position_on_the_genomic_accession=1883185, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33367 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33367, CurrentID=0, Status='live', Symbol='CG7337', Aliases='Dmel_ Dmel\\CG7337, Q0E8U7_DROME', description='CG7337 gene product from transcript CG7337-RA', other_designations='CG7337-PA|CG7337-PB|CG7337-PC|CG7337-PD|CG7337-PE|CG7337-PF|CG7337-PG|CG7337-PH', map_location='22B4-22B6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1884622, end_position_on_the_genomic_accession=1944289, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  33369 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33369, CurrentID=0, Status='live', Symbol='Der-1', Aliases='Dmel_CG10908, CG10908, Dmel\\CG10908, l(2)SH1964, l(2)SH2 1964', description='Derlin-1', other_designations='CG10908-PA|CG10908-PB|Der-1-PA|Der-1-PB|Dm Derlin-1|derlin-1|lethal (2) SH1964', map_location='22B8-22B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1973957, end_position_on_the_genomic_accession=1975413, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33370 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33370, CurrentID=0, Status='live', Symbol='CG15356', Aliases='Dmel_ Dmel\\CG15356, EMSY', description='CG15356 gene product from transcript CG15356-RA', other_designations='CG15356-PA|uncharacterized protein', map_location='22B8-22B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1975463, end_position_on_the_genomic_accession=1980755, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33371 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33371, CurrentID=0, Status='live', Symbol='CG15362', Aliases='Dmel_ Dmel\\CG15362', description='CG15362 gene product from transcript CG15362-RA', other_designations='CG15362-PA|uncharacterized protein', map_location='22B8-22B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1981176, end_position_on_the_genomic_accession=1982099, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33372 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33372, CurrentID=0, Status='live', Symbol='CG7289', Aliases='Dmel_ Dmel\\CG7289', description='CG7289 gene product from transcript CG7289-RA', other_designations='CG7289-PA', map_location='22B8-22B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1982217, end_position_on_the_genomic_accession=1984514, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33373 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33373, CurrentID=0, Status='live', Symbol='Got2', Aliases='Dmel_CG4233, 152801_at, CG4233, Dmel\\CG4233, Got, Got 2, Got-2, got2', description='Glutamate oxaloacetate transaminase 2', other_designations='CG4233-PA|CG4233-PB|GLUTAMATE OXALOACETATE TRANSAMINASE 2|Got2-PA|Got2-PB|glutamate oxaloacetate transaminase 2|mitochondrial aspartate aminotransferase', map_location='22B8-22B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1984512, end_position_on_the_genomic_accession=1987758, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33374 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33374, CurrentID=0, Status='live', Symbol='Npc2a', Aliases='Dmel_CG7291, BEST:GH08376, BcDNA:GH22047, BcDNA:RH53228, CG7291, CT22505, DmML3, Dmel\\CG7291, NPC2, dnpc2a, npc2a', description='Niemann-Pick type C-2a', other_designations='CG7291-PA|Niemann-Pick type C-2|Npc2a-PA|epididymal secretory protein', map_location='22B8-22B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=1988290, end_position_on_the_genomic_accession=1988940, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  26067045 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=26067045, CurrentID=0, Status='live', Symbol='Mst77Y-13', Aliases='Dmel_CG45767, CG45767, Dmel\\CG45767', description='Male-specific transcript 77Y 13', other_designations='CG45767-PA|Mst77Y-13-PA', map_location='', chromosome='Y', genomic_nucleotide_accession_version='NC_024512.1', start_position_on_the_genomic_accession=3354105, end_position_on_the_genomic_accession=3354870, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33377 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33377, CurrentID=0, Status='live', Symbol='CG4238', Aliases='Dmel_ Dmel\\CG4238', description='CG4238 gene product from transcript CG4238-RF', other_designations='CG4238-PD|CG4238-PE|CG4238-PF|CG4238-PG|CG4238-PH|CG4238-PI|CG4238-PJ', map_location='22B8-22C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2009859, end_position_on_the_genomic_accession=2030788, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  33379 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33379, CurrentID=0, Status='live', Symbol='Su(dx)', Aliases='Dmel_CG4244, AIP4, CG4244, Dmel\\CG4244, ITCH, Itch, Su(Dx), Su(deltex), anon-WO0073329.1, anon-WO0073329.2, anon-WO0073329.4, su(dx)', description='Suppressor of deltex', other_designations='CG4244-PA|CG4244-PB|CG4244-PC|CG4244-PE|CG4244-PF|Su(dx)-PA|Su(dx)-PB|Su(dx)-PC|Su(dx)-PE|Su(dx)-PF|suppressor of deltex', map_location='22C1-22C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2037714, end_position_on_the_genomic_accession=2044372, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  33381 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33381, CurrentID=0, Status='live', Symbol='Or22c', Aliases='Dmel_CG15377, 22C.1, 22c, CG15377, DOR16, DOR22C.1, Dmel\\CG15377, Or22C.1', description='Odorant receptor 22c', other_designations='CG15377-PA|Or22c-PA|odorant receptor 22c|olfactory receptor 22C.1', map_location='22C1-22C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2054589, end_position_on_the_genomic_accession=2057967, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33384 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33384, CurrentID=0, Status='live', Symbol='CG12674', Aliases='Dmel_ Dmel\\CG12674', description='CG12674 gene product from transcript CG12674-RA', other_designations='CG12674-PA|CG12674-PB|uncharacterized protein', map_location='22C2-22C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2079919, end_position_on_the_genomic_accession=2081286, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33385 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33385, CurrentID=0, Status='live', Symbol='CG4259', Aliases='Dmel_ Dmel\\CG4259, SPH173', description='CG4259 gene product from transcript CG4259-RB', other_designations='CG4259-PA|CG4259-PB', map_location='22C3-22C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2127309, end_position_on_the_genomic_accession=2129237, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33386 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33386, CurrentID=0, Status='live', Symbol='GlyP', Aliases='Dmel_CG7254, BcDNA:LD24485, CG7254, DGPH, Dmel\\CG7254, GP, Glp1, Glyp, anon-WO0257455.33, l(2)k07918', description='Glycogen phosphorylase', other_designations='CG7254-PA|CG7254-PB|GlyP-PA|GlyP-PB|glycogen phosphorylase|glycogen phosphorylase b', map_location='22C3-22D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2130813, end_position_on_the_genomic_accession=2137296, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  26067047 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=26067047, CurrentID=0, Status='live', Symbol='Mst77Y-9', Aliases='Dmel_CG45769, CG45769, Dmel\\CG45769', description='Male-specific transcript 77Y 9', other_designations='CG45769-PA|Mst77Y-9-PA', map_location='', chromosome='Y', genomic_nucleotide_accession_version='NC_024512.1', start_position_on_the_genomic_accession=3336400, end_position_on_the_genomic_accession=3337123, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33388 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33388, CurrentID=0, Status='live', Symbol='CG11723', Aliases='Dmel_ 11723, Dmel\\CG11723', description='CG11723 gene product from transcript CG11723-RB', other_designations='CG11723-PA|CG11723-PB|uncharacterized protein', map_location='22D1-22D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2145297, end_position_on_the_genomic_accession=2147275, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33389 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33389, CurrentID=0, Status='live', Symbol='TBCD', Aliases='Dmel_CG7261, BcDNA:LD22320, CG7261, Dmel\\CG7261', description='tubulin folding cofactor D', other_designations='CG7261-PA|TBCD-PA', map_location='22D1-22D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2147518, end_position_on_the_genomic_accession=2151664, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33390 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33390, CurrentID=0, Status='live', Symbol='AIF', Aliases='Dmel_CG7263, CG7263, DmAIF, Dmel\\CG7263, SD03428p, aif', description='Apoptosis inducing factor', other_designations='AIF-PA|AIF-PB|AIF-PC|CG7263-PA|CG7263-PB|CG7263-PC|apoptosis inducing factor', map_location='22D1-22D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2151754, end_position_on_the_genomic_accession=2155389, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33391 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33391, CurrentID=0, Status='live', Symbol='CG15382', Aliases='Dmel_ BcDNA:RE26473, Dmel\\CG15382', description='CG15382 gene product from transcript CG15382-RA', other_designations='CG15382-PA|uncharacterized protein', map_location='22D1-22D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2155753, end_position_on_the_genomic_accession=2156790, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33392 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33392, CurrentID=0, Status='live', Symbol='aop', Aliases='Dmel_CG3166, AOP, Aop, Aop/Yan, CG3166, DROYANET, DROYANETSB, Dmel\\CG3166, SK2-1, YAN, Yan/yan, fus6, pok, yan, yan/pok, aop', description='anterior open', other_designations='CG3166-PA|CG3166-PB|CG3166-PC|CG3166-PD|CG3166-PE|SGP cluster fusion defects 6|anterior-open|aop-PA|aop-PB|aop-PC|aop-PD|aop-PE|pokkuri', map_location='2-12 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2156484, end_position_on_the_genomic_accession=2178754, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33394 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33394, CurrentID=0, Status='live', Symbol='CG10874', Aliases='Dmel_ Dmel\\CG10874, FBgn 31395', description='CG10874 gene product from transcript CG10874-RB', other_designations='CG10874-PA|CG10874-PB|CG10874-PC|CG10874-PD|uncharacterized protein', map_location='22D1-22D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2189914, end_position_on_the_genomic_accession=2192386, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33395 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33395, CurrentID=0, Status='live', Symbol='CG31668', Aliases='Dmel_CG31668, CG10879-PB, Dmel\\CG31668, dSLC5A12', description='CG31668 gene product from transcript CG31668-RC', other_designations='CG31668-PC|uncharacterized protein', map_location='22D1-22D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2203721, end_position_on_the_genomic_accession=2206166, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  33396 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33396, CurrentID=0, Status='live', Symbol='CG15385', Aliases='Dmel_ Dmel\\CG15385', description='CG15385 gene product from transcript CG15385-RA', other_designations='CG15385-PA|CG15385-PB|uncharacterized protein', map_location='22D4-22D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2209574, end_position_on_the_genomic_accession=2212571, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33397 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33397, CurrentID=0, Status='live', Symbol='Uch', Aliases='Dmel_CG4265, CG4265, Dmel\\CG4265, P35122, UBL, UCH, UCH-D, UCH-D19-D, dUch, uch, uch-D, Uch', description='Ubiquitin carboxy-terminal hydrolase', other_designations='CG4265-PA|CG4265-PB|CG4265-PC|Uch-PA|Uch-PB|Uch-PC|ubiquitin C-terminal hydrolase|ubiquitin carboxy-terminal hydrolase|ubiquitin carboxyl terminal hydrolase|ubiquitin carboxyterminal hydrolase', map_location='22D4-22D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2212738, end_position_on_the_genomic_accession=2214211, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33398 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33398, CurrentID=0, Status='live', Symbol='CG10880', Aliases='Dmel_ Dmel\\CG10880', description='CG10880 gene product from transcript CG10880-RB', other_designations='CG10880-PA|CG10880-PB|uncharacterized protein', map_location='22D4-22D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2214972, end_position_on_the_genomic_accession=2216311, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33399 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33399, CurrentID=0, Status='live', Symbol='mio', Aliases='Dmel_CG7074, CG15384, CG7074, Dmel\\CG7074, FBtr0077835, Mio, SEA4', description='missing oocyte', other_designations='CG7074-PA|mio-PA', map_location='22D4-22D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2217290, end_position_on_the_genomic_accession=2220625, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33401 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33401, CurrentID=0, Status='live', Symbol='papi', Aliases='Dmel_CG7082, CG7082, Dmel\\CG7082, PAPI, cg7082', description='CG7082 gene product from transcript CG7082-RA', other_designations='CG7082-PA|CG7082-PB|CG7082-PC|CG7082-PD|papi-PA|papi-PB|papi-PC|papi-PD|partner of PIWIs', map_location='22D4-22D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2220748, end_position_on_the_genomic_accession=2225544, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33402 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33402, CurrentID=0, Status='live', Symbol='sau', Aliases='Dmel_CG7085, BEST:LD28579, BcDNA:LD10657, CG7085, Dmel\\CG7085, GOLPH3, l(2)s5379, rti', description='sauron', other_designations='CG7085-PA|CG7085-PD|CG7085-PE|lethal (2) s5379|rotini|sau-PA|sau-PD|sau-PE', map_location='22D4-22D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2226342, end_position_on_the_genomic_accession=2231099, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33403 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33403, CurrentID=0, Status='live', Symbol='CG15387', Aliases='Dmel_ Dmel\\CG15387', description='CG15387 gene product from transcript CG15387-RB', other_designations='CG15387-PB|uncharacterized protein', map_location='22D4-22D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2225545, end_position_on_the_genomic_accession=2226294, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33404 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33404, CurrentID=0, Status='live', Symbol='Tengl3', Aliases='Dmel_CG31679, CG17006, CG31679, Dmel\\CG31679', description='Testis EndoG-Like 3', other_designations='CG31679-PA|Tengl3-PA|testis EndoG-Like 3', map_location='22D5-22D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2237076, end_position_on_the_genomic_accession=2238251, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33405 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33405, CurrentID=0, Status='live', Symbol='CG4267', Aliases='Dmel_ CG31686, Dmel\\CG4267, Dmel_CG31686', description='CG4267 gene product from transcript CG4267-RB', other_designations='CG4267-PA|CG4267-PB', map_location='22D5-22D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2242378, end_position_on_the_genomic_accession=2245274, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33406 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33406, CurrentID=0, Status='live', Symbol='Ser12', Aliases='Dmel_CG17240, CG17240, Dmel\\CG17240, SP92', description='Serine protease 12', other_designations='CG17240-PA|Ser12-PA|serine protease 12', map_location='22D5-22D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2250431, end_position_on_the_genomic_accession=2251275, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33407 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33407, CurrentID=0, Status='live', Symbol='Send1', Aliases='Dmel_CG17012, CG17012, Dmel\\CG17012, SP163', description='Spermathecal endopeptidase 1', other_designations='CG17012-PA|Send1-PA|spermathecal endopeptidase 1', map_location='22D5-22D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2254176, end_position_on_the_genomic_accession=2255050, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33408 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33408, CurrentID=0, Status='live', Symbol='CG4270', Aliases='Dmel_ BcDNA:AT04879, Dmel\\CG4270', description='CG4270 gene product from transcript CG4270-RA', other_designations='CG4270-PA|CG4270-PB', map_location='22D6-22D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2263442, end_position_on_the_genomic_accession=2264241, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33409 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33409, CurrentID=0, Status='live', Symbol='Sec24CD', Aliases='Dmel_CG10882, BcDNA:LP05220, CG10882, Dmel\\CG10882, FBgn0031408, Sec24, Sten, gho, sec24, sfb3, sten', description='Sec24CD ortholog (H. sapiens)', other_designations='CG10882-PA|CG10882-PB|CG10882-PC|Sec24CD ortholog|Sec24CD-PA|Sec24CD-PB|Sec24CD-PC|ghost|stenosis', map_location='2-68 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2231106, end_position_on_the_genomic_accession=2236844, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33410 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33410, CurrentID=0, Status='live', Symbol='CG4271', Aliases='Dmel_ Dmel\\CG4271, SPH164', description='CG4271 gene product from transcript CG4271-RA', other_designations='CG4271-PA', map_location='22D6-22D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2285163, end_position_on_the_genomic_accession=2285926, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33411 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33411, CurrentID=0, Status='live', Symbol='CG17237', Aliases='Dmel_ BcDNA:AT15471, DmAAF51272, Dmel\\CG17237', description='CG17237 gene product from transcript CG17237-RA', other_designations='CG17237-PA|uncharacterized protein', map_location='22D6-22D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2288503, end_position_on_the_genomic_accession=2289416, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33412 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33412, CurrentID=0, Status='live', Symbol='robl22E', Aliases='Dmel_CG10838, CG10838, Dmel\\CG10838, Robl22E', description='CG10838 gene product from transcript CG10838-RB', other_designations='CG10838-PA|CG10838-PB|robl22E-PA|robl22E-PB', map_location='22D6-22D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2290224, end_position_on_the_genomic_accession=2290738, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33413 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33413, CurrentID=0, Status='live', Symbol='CG16995', Aliases='Dmel_ Dmel\\CG16995', description='CG16995 gene product from transcript CG16995-RA', other_designations='CG16995-PA|uncharacterized protein', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2307948, end_position_on_the_genomic_accession=2308872, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33414 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33414, CurrentID=0, Status='live', Symbol='CG9967', Aliases='Dmel_ Dmel\\CG9967', description='CG9967 gene product from transcript CG9967-RC', other_designations='CG9967-PA|CG9967-PB|CG9967-PC', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2308761, end_position_on_the_genomic_accession=2357356, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  26067052 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=26067052, CurrentID=0, Status='live', Symbol='Myo81F', Aliases='Dmel_CG45784, CG15831, CG40155, CG40204, CG41281, CG41518, CG41527, CG42621, CG42622, CG42623, CG42624, CG45784, Dmel\\CG45784, Dmel_CG15831, Dmel_CG40155, Dmel_CG40204, Dmel_CG41281, Dmel_CG41518, Dmel_CG41527, Dmel_CG42621, Dmel_CG42622, Dmel_CG42623, Dmel_CG42624', description='Myosin 81F', other_designations='CG45784-PB|Myo81F-PB|myosin 81F', map_location='', chromosome='3R', genomic_nucleotide_accession_version='NT_033777.3', start_position_on_the_genomic_accession=567076, end_position_on_the_genomic_accession=2532932, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  33418 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33418, CurrentID=0, Status='live', Symbol='Rab5', Aliases='Dmel_CG3664, AAF51265, BAA88244, CG3664, D Dm Rab5, DmRab5, Dmel\\CG3664, Drab5, RAB5, RAB5a, Rab, Rab-5, dRab5, drab5, l(2)k08232, rab5', description='CG3664 gene product from transcript CG3664-RC', other_designations='CG3664-PA|CG3664-PB|CG3664-PC|CG3664-PD|CG3664-PE|CG3664-PF|CG3664-PG|CG3664-PH|CG3664-PI|Rab-protein 5|Rab5-PA|Rab5-PB|Rab5-PC|Rab5-PD|Rab5-PE|Rab5-PF|Rab5-PG|Rab5-PH|Rab5-PI', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2359142, end_position_on_the_genomic_accession=2365273, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  33419 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33419, CurrentID=0, Status='live', Symbol='Axud1', Aliases='Dmel_CG4272, BcDNA:GH09817, C676, CG4272, D Dmel\\CG4272', description='CG4272 gene product from transcript CG4272-RC', other_designations='Axud1-PA|Axud1-PB|Axud1-PC|Axud1-PD|CG4272-PA|CG4272-PB|CG4272-PC|CG4272-PD', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2365345, end_position_on_the_genomic_accession=2370137, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33420 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33420, CurrentID=0, Status='live', Symbol='CG3597', Aliases='Dmel_ BVRA, Dmel\\CG3597', description='CG3597 gene product from transcript CG3597-RA', other_designations='CG3597-PA|CG3597-PB', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2370152, end_position_on_the_genomic_accession=2371524, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33421 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33421, CurrentID=0, Status='live', Symbol='CG3609', Aliases='Dmel_ CT12127, Dmel\\CG3609', description='CG3609 gene product from transcript CG3609-RA', other_designations='CG3609-PA|CG3609-PB|CG3609-PC', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2372455, end_position_on_the_genomic_accession=2374627, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33422 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33422, CurrentID=0, Status='live', Symbol='CG15390', Aliases='Dmel_ BcDNA:RE18748, Dmel\\CG15390', description='CG15390 gene product from transcript CG15390-RA', other_designations='CG15390-PA|uncharacterized protein', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2374713, end_position_on_the_genomic_accession=2375697, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33423 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33423, CurrentID=0, Status='live', Symbol='Atxn7', Aliases='Dmel_CG9866, CG9866, Dmel\\CG9866', description='Ataxin 7', other_designations='Ataxin-7|Atxn7-PA|Atxn7-PB|Atxn7-PC|Atxn7-PD|CG9866-PA|CG9866-PB|CG9866-PC|CG9866-PD|ataxin 7', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2375841, end_position_on_the_genomic_accession=2380506, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33424 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33424, CurrentID=0, Status='live', Symbol='Eogt', Aliases='Dmel_CG9867, CG9867, Dmel\\CG9867, eogt', description='EGF-domain O-GlcNAc transferase', other_designations='CG9867-PA|CG9867-PB|Eogt-PA|Eogt-PB', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2381097, end_position_on_the_genomic_accession=2383073, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33425 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33425, CurrentID=0, Status='live', Symbol='CG9870', Aliases='Dmel_ Dmel\\CG9870', description='CG9870 gene product from transcript CG9870-RA', other_designations='CG9870-PA', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2383202, end_position_on_the_genomic_accession=2384747, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33426 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33426, CurrentID=0, Status='live', Symbol='CG3557', Aliases='Dmel_ Dmel\\CG3557', description='CG3557 gene product from transcript CG3557-RC', other_designations='CG3557-PA|CG3557-PB|CG3557-PC', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2384761, end_position_on_the_genomic_accession=2385792, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33427 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33427, CurrentID=0, Status='live', Symbol='VGlut', Aliases='Dmel_CG9887, CG9887, DV-Glut, DVGLUT, DVGluT, DVGlut, Dmel\\CG9887, DvGluT, DvGlut, MFS11, VGLUT, VGluT, Vglut, dVGLUT, dVGlut, dvGluT, dvGlut, dvglut, vGLUT, vGluT, vGlut, vglut', description='Vesicular glutamate transporter', other_designations='CG9887-PA|CG9887-PB|CG9887-PC|VGlut-PA|VGlut-PB|VGlut-PC|drosophila vesicular glutamate transporter|vesicular glutamate transporter', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2391660, end_position_on_the_genomic_accession=2410662, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  33429 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33429, CurrentID=0, Status='live', Symbol='CG18641', Aliases='Dmel_ CG11535, Dmel\\CG18641', description='CG18641 gene product from transcript CG18641-RC', other_designations='CG18641-PC|uncharacterized protein', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2410624, end_position_on_the_genomic_accession=2415322, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33431 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33431, CurrentID=0, Status='live', Symbol='CG9886', Aliases='Dmel_ Dmel\\CG9886', description='CG9886 gene product from transcript CG9886-RB', other_designations='CG9886-PA|CG9886-PB', map_location='22E1-22E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2420830, end_position_on_the_genomic_accession=2424647, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33432 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33432, CurrentID=0, Status='live', Symbol='dpp', Aliases='Dmel_CG9885, BMP, CG9885, DPP, DPP-C, Dm-DPP, Dmel\\CG9885, Dpp, Hin-d, M(2)23AB, M(2)LS1, TGF-b, TGF-beta, TGFbeta, Tg, blk, ho, l(2)10638, l(2)22Fa, l(2)k17036, shv', description='decapentaplegic', other_designations='CG9885-PA|CG9885-PB|CG9885-PC|CG9885-PE|Decapentaplegic/Bone morphogenetic protein|Haplo-insufficient|blink|bone morphogenetic protein|bone morphogenic protein|dpp-PA|dpp-PB|dpp-PC|dpp-PE|heldout|shortvein|tegula', map_location='2-4.0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2428372, end_position_on_the_genomic_accession=2459823, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33434 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33434, CurrentID=0, Status='live', Symbol='Slh', Aliases='Dmel_CG3539, CG15393, CG3539, Dmel\\CG3539, Dmel_CG15393, SLY1, Sly, Sly1, Sly1p, d-sly, slh', description='SLY-1 homologous', other_designations='CG3539-PC|CG3539-PG|SLY1 homologous|Slh-PC|Slh-PG', map_location='22F3-22F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2488197, end_position_on_the_genomic_accession=2492671, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33435 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33435, CurrentID=0, Status='live', Symbol='oaf', Aliases='Dmel_CG9884, CG9884, Dmel\\CG9884, l(2)22Fb, l(2)ND1, tnd', description='out at first', other_designations='CG9884-PA|CG9884-PB|CG9884-PC|CG9884-PD|near dpp complementation group 1|oaf-PA|oaf-PB|oaf-PC|oaf-PD|transcript near decapentaplegic|transcript-near-decapentaplegic', map_location='22F4-22F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2492955, end_position_on_the_genomic_accession=2498846, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33436 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33436, CurrentID=0, Status='live', Symbol='CG3528', Aliases='Dmel_ Dmel\\CG3528', description='CG3528 gene product from transcript CG3528-RA', other_designations='CG3528-PA', map_location='22F4-22F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2517102, end_position_on_the_genomic_accession=2518037, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33437 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33437, CurrentID=0, Status='live', Symbol='CG3515', Aliases='Dmel_ Dmel\\CG3515', description='CG3515 gene product from transcript CG3515-RA', other_designations='CG3515-PA', map_location='22F4-22F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2551145, end_position_on_the_genomic_accession=2552825, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33438 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33438, CurrentID=0, Status='live', Symbol='Cyp309a1', Aliases='Dmel_CG9964, 309a1, CG9964, Dmel\\CG9964', description='CG9964 gene product from transcript CG9964-RC', other_designations='CG9964-PB|CG9964-PC|Cyp309a1-PB|Cyp309a1-PC|cytochrome P450', map_location='22F4-23A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2562483, end_position_on_the_genomic_accession=2564830, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33439 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33439, CurrentID=0, Status='live', Symbol='Cyp309a2', Aliases='Dmel_CG18559, 309a2, CG18559, Dmel\\CG18559', description='CG18559 gene product from transcript CG18559-RA', other_designations='CG18559-PA|Cyp309a2-PA|cytochrome P450 309a2', map_location='23A1-23A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2564886, end_position_on_the_genomic_accession=2573037, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33440 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33440, CurrentID=0, Status='live', Symbol='Rad1', Aliases='Dmel_CG3240, CG3240, DmRad1, Dmel\\CG3240, Dromel_CG3240_FBtr0077747_rad1_mORF[Dm], rad1, Rad1', description='Radiation insensitive 1', other_designations='CG3240-PA|Rad1-PA|radiation insensitive 1', map_location='23A1-23A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2573436, end_position_on_the_genomic_accession=2575052, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33441 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33441, CurrentID=0, Status='live', Symbol='insv', Aliases='Dmel_CG3227, BcDNA:RE55538, CG3227, Dmel\\CG3227, Insv', description='insensitive', other_designations='CG3227-PA|CG3227-PB|insv-PA|insv-PB', map_location='23A1-23A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2575280, end_position_on_the_genomic_accession=2576997, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33442 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33442, CurrentID=0, Status='live', Symbol='Elba2', Aliases='Dmel_CG9883, CG9883, Dmel\\CG9883, Elba', description='Early boundary activity 2', other_designations='CG9883-PA|Elba2-PA|early boundary activity 2|early boundary factor', map_location='23A1-23A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2577687, end_position_on_the_genomic_accession=2579179, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33443 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33443, CurrentID=0, Status='live', Symbol='ND-B17.2', Aliases='Dmel_CG3214, B17.2, BcDNA:GH12382, CG3214, Dmel\\CG3214, N7BM, anon-EST:Posey62', description='NADH dehydrogenase (ubiquinone) B17.2 subunit', other_designations='CG3214-PA|CG3214-PB|CG3214-PC|FBpp0077425|NADH ubiquinone oxidoreductase B17.2|NADH-ubiquinone oxidoreductase subunit B17.2|NADH:ubiquinone oxidoreductase B17.2 subunit|ND-B17.2-PA|ND-B17.2-PB|ND-B17.2-PC', map_location='23A1-23A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2579201, end_position_on_the_genomic_accession=2580172, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33444 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33444, CurrentID=0, Status='live', Symbol='Arpc5', Aliases='Dmel_CG9881, ARPC5, ArpC5, CG9881, Dmel\\CG9881, P16-ARC, p16, p16-ARC, p16-arc', description='Actin-related protein 2/3 complex, subunit 5', other_designations='Arpc5-PA|Arpc5-PB|CG9881-PA|CG9881-PB|p16-ARC', map_location='23A1-23A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2580292, end_position_on_the_genomic_accession=2581423, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33445 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33445, CurrentID=0, Status='live', Symbol='Drp1', Aliases='Dmel_CG3210, CG3210, DRP, DRP1, Dmel\\CG3210, Dnm1/Drp1, Drp, Drp-1, drp-1, drp1, frat, l(2)22Fc, l(2)22Fd, l(2)ND2, l(2)ND3', description='Dynamin related protein 1', other_designations='CG3210-PA|CG3210-PB|Drp1-PA|Drp1-PB|dynamin related protein 1|dynamin related protein-1|dynamin-2|dynamin-related protein|dynamin-related protein 1|dynaminrelated protein 1|fratboy|lethal(2)22Fc|lethal(2)22Fd|near dpp complementation group 2|near dpp complementation group 3|noodle', map_location='23A1-23A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2581281, end_position_on_the_genomic_accession=2585430, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33446 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33446, CurrentID=0, Status='live', Symbol='CG15394', Aliases='Dmel_ Dmel\\CG15394, anon-SAGE:Wang-060', description='CG15394 gene product from transcript CG15394-RD', other_designations='CG15394-PC|CG15394-PD|anon-SAGE:Wang-060|uncharacterized protein', map_location='23A1-23A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2591869, end_position_on_the_genomic_accession=2592773, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33447 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33447, CurrentID=0, Status='live', Symbol='CG15395', Aliases='Dmel_ Dmel\\CG15395', description='CG15395 gene product from transcript CG15395-RB', other_designations='CG15395-PB|uncharacterized protein', map_location='23A1-23A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2609994, end_position_on_the_genomic_accession=2611283, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33448 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33448, CurrentID=0, Status='live', Symbol='CG9962', Aliases='Dmel_ Dmel\\CG9962', description='CG9962 gene product from transcript CG9962-RA', other_designations='CG9962-PA|CKIa-like', map_location='23A2-23A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2646577, end_position_on_the_genomic_accession=2647720, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33449 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33449, CurrentID=0, Status='live', Symbol='Prosbeta4R1', Aliases='Dmel_CG17301, BcDNA:AT30033, CG17301, Dmel\\CG17301, beta4R1', description='Proteasome beta4 subunit-related 1', other_designations='CG17301-PA|Prosbeta4R1-PA|proteasome beta4 subunit-related 1|proteasome beta4R1 subunit', map_location='23A2-23A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2653046, end_position_on_the_genomic_accession=2653926, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33450 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33450, CurrentID=0, Status='live', Symbol='Or23a', Aliases='Dmel_CG9880, 23A.1, 23a, AN5, CG9880, DOR23A.1, DOR64, Dmel\\CG9880, Dor64, Or23A.1, Or64, dor64, or23a', description='Odorant receptor 23a', other_designations='CG9880-PA|Or23a-PA|odorant receptor 23a|odorant receptor 64|olfactory receptor 23A.1', map_location='23A2-23A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2654049, end_position_on_the_genomic_accession=2655462, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33451 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33451, CurrentID=0, Status='live', Symbol='Prosbeta4R2', Aliases='Dmel_CG17302, CG17302, Dmel\\CG17302, anon-WO0140519.122, beta4R2', description='Proteasome beta4 subunit-related 2', other_designations='CG17302-PA|CG17302-PB|Prosbeta4R2-PA|Prosbeta4R2-PB|proteasome beta4 subunit-related 2|proteasome beta4R2 subunit', map_location='23A2-23A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2655394, end_position_on_the_genomic_accession=2657102, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33452 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33452, CurrentID=0, Status='live', Symbol='CG9879', Aliases='Dmel_ Dmel\\CG9879', description='CG9879 gene product from transcript CG9879-RA', other_designations='CG9879-PA', map_location='23A2-23A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2665062, end_position_on_the_genomic_accession=2666265, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33453 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33453, CurrentID=0, Status='live', Symbol='Gr23a', Aliases='Dmel_CG15396, 23A.1a, 23A1.b, 23A1a, 23A1b, CG15396, Dmel\\CG15396, GR23A.1, GR23a, Gr23A1a, Gr23A1b.a, Gr23a.b, Gr23aA, Gr23aB, Gr23a', description='Gustatory receptor 23a', other_designations='CG15396-PB|CG15396-PC|Gr23a-PB|Gr23a-PC|gustatory receptor 23A.1|gustatory receptor 23a', map_location='23A2-23A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2669823, end_position_on_the_genomic_accession=2672186, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33454 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33454, CurrentID=0, Status='live', Symbol='CG15398', Aliases='Dmel_ Dmel\\CG15398', description='CG15398 gene product from transcript CG15398-RB', other_designations='CG15398-PB|uncharacterized protein', map_location='23A2-23A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2695330, end_position_on_the_genomic_accession=2696437, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33455 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33455, CurrentID=0, Status='live', Symbol='CG31690', Aliases='Dmel_ CG11542, CG15397, Dmel\\CG31690', description='CG31690 gene product from transcript CG31690-RE', other_designations='CG31690-PE|uncharacterized protein', map_location='23A2-23A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2677734, end_position_on_the_genomic_accession=2719431, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33458 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33458, CurrentID=0, Status='live', Symbol='Hrs', Aliases='Dmel_CG2903, CG2903, DmHRS, Dmel\\CG2903, HRS, HRS-2, Vps27, dHrs, hrs, l(2)23AB5, l(2)23Ad, l(2)23Ad(Hrs), vps27', description='Hepatocyte growth factor regulated tyrosine kinase substrate', other_designations='CG2903-PA|CG2903-PB|CG2903-PC|F[[1]]F[[0]] ATPase|HGF-regulated tyrosine kinase substrate|Hrs-PA|Hrs-PB|Hrs-PC|hepatocyte growth factor regulated tyrosine kinase|hepatocyte growth factor regulated tyrosine kinase substrate|hepatocyte growth factor-regulated tyrosine kinase substrate|hepatocyte growth factor-regulated tyrosine substrate|hepatocyte growth-factor-regulated substrate', map_location='23A3-23A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2739986, end_position_on_the_genomic_accession=2743377, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33459 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33459, CurrentID=0, Status='live', Symbol='CG9961', Aliases='Dmel_ Dmel\\CG9961', description='CG9961 gene product from transcript CG9961-RB', other_designations='CG9961-PA|CG9961-PB', map_location='23A3-23A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2743375, end_position_on_the_genomic_accession=2744934, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33460 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33460, CurrentID=0, Status='live', Symbol='Cwc25', Aliases='Dmel_CG2843, CG2843, CWC25, Dmel\\CG2843', description='CG2843 gene product from transcript CG2843-RA', other_designations='CG2843-PA|Cwc25-PA', map_location='23A3-23A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2745098, end_position_on_the_genomic_accession=2746944, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33461 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33461, CurrentID=0, Status='live', Symbol='Pgk', Aliases='Dmel_CG3127, 169C9S, CG3127, Dmel\\CG3127, ESTS:169C9S, PGK, anon-sts18, l(2)23AB3, l(2)23Ac, pgk', description='Phosphoglycerate kinase', other_designations='CG3127-PA|CG3127-PB|CG3127-PC|CG3127-PD|CG3127-PE|Pgk-PA|Pgk-PB|Pgk-PC|Pgk-PD|Pgk-PE|lethal (2) 23AB3|phosphoglycerate kinase|phosphoglycerokinase', map_location='23A3-23B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2746880, end_position_on_the_genomic_accession=2753068, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33462 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33462, CurrentID=0, Status='live', Symbol='Bacc', Aliases='Dmel_CG9894, CG9894, Dmel\\CG9894, anon-EST:Liang-2.54, clone 2.54', description='Bacchus', other_designations='Bacc-PA|Bacc-PB|Bacc-PC|Bacc-PD|CG9894-PA|CG9894-PB|CG9894-PC|CG9894-PD|bacchus|baccus', map_location='23A3-23A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2752445, end_position_on_the_genomic_accession=2757975, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33465 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33465, CurrentID=0, Status='live', Symbol='Trn-SR', Aliases='Dmel_CG2848, CG2848, Dmel\\CG2848, TNPO3, anon-EST:Posey294, dTRN-SR', description='Transportin-Serine/Arginine rich', other_designations='CG2848-PA|CG2848-PB|Transportin-serine/arginine rich|Trn-SR-PA|Trn-SR-PB|transportin', map_location='23A3-23A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2759924, end_position_on_the_genomic_accession=2763889, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33466 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33466, CurrentID=0, Status='live', Symbol='CG3077', Aliases='Dmel_ DmSNX21, Dmel\\CG3077', description='CG3077 gene product from transcript CG3077-RB', other_designations='CG3077-PA|CG3077-PB', map_location='23A5-23A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2763416, end_position_on_the_genomic_accession=2765665, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33467 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33467, CurrentID=0, Status='live', Symbol='aph-1', Aliases='Dmel_CG2855, Aph-1, Aph1, CG2855, Dm APH-1, Dmel\\CG2855, Pen-1, aph, aph1, dAph-1, l(2)23AB6, l(2)23Ag, pen-1', description='anterior pharynx defective 1', other_designations='CG2855-PA|CG2855-PB|aph-1-PA|aph-1-PB|presenilin enhancer-1|presenilin stabilization factor', map_location='23A5-23A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2766233, end_position_on_the_genomic_accession=2767281, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33468 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33468, CurrentID=0, Status='live', Symbol='Taf10b', Aliases='Dmel_CG3069, CG3069, Dmel\\CG3069, TAF, TAF10b, TAFII16, TAF[[II]], TAF[[II]]16, TFIID, Taf10, Taf16, TafII16, dTAF10b, dTAF[[II]]16, dmTAF10b, dtafII16', description='TBP-associated factor 10b', other_designations='CG3069-PA|TBP-associated factor|TBP-associated factor 16kD|Taf10b-PA', map_location='23A5-23A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2767286, end_position_on_the_genomic_accession=2767845, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33469 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33469, CurrentID=0, Status='live', Symbol='Taf10', Aliases='Dmel_CG2859, BcDNA:RE73934, CG2859, Dmel\\CG2859, TAF, TAF10, TAF[[II]], TAF[[II]]24, TFIID, Taf24, TafII24, dTAF10, dTAFII24, dTAF[[II]]24, dmTAF10, dmTaf10, dtafII24, taf24', description='TBP-associated factor 10', other_designations='CG2859-PA|TBP-associated factor|TBP-associated factor 24kD|Taf10-PA', map_location='23A5-23A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2767890, end_position_on_the_genomic_accession=2768612, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33470 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33470, CurrentID=0, Status='live', Symbol='colt', Aliases='Dmel_CG3057, CG3057, Dmel\\CG3057', description='congested-like trachea', other_designations='CG3057-PA|CG3057-PD|collapsed trachea|colt-PA|colt-PD', map_location='23A5-23A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2768590, end_position_on_the_genomic_accession=2770069, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33471 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33471, CurrentID=0, Status='live', Symbol='CG2862', Aliases='Dmel_ Dmel\\CG2862', description='CG2862 gene product from transcript CG2862-RA', other_designations='CG2862-PA|CG2862-PB|CG2862-PC', map_location='23A5-23A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2770135, end_position_on_the_genomic_accession=2770904, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33472 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33472, CurrentID=0, Status='live', Symbol='CG15399', Aliases='Dmel_ Dmel\\CG15399', description='CG15399 gene product from transcript CG15399-RA', other_designations='CG15399-PA|uncharacterized protein', map_location='23A5-23A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2770884, end_position_on_the_genomic_accession=2771776, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33473 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33473, CurrentID=0, Status='live', Symbol='Syt1', Aliases='Dmel_CG3139, CG3139, D. Syt I, DSYT, DSYT2, DSypt, DSyt, DSyt1, Dmel\\CG3139, Droso1, Dsyt2, STY1, SYT, SYT I, SYT1, Syt, Syt 1, Syt I, Syt-1, SytI, dSYT, dSyt1, dsyt1, dsytI, l(2)23AB1, l(2)23Ba, l(2)k05909, syt, syt 1, syt I, syt-1, syt1, sytI', description='Synaptotagmin 1', other_designations='CG3139-PA|CG3139-PB|CG3139-PC|CG3139-PE|CG3139-PF|CG3139-PG|CG3139-PH|CG3139-PI|Synaptotagmin-1|Synaptotagmin-I|Synaptotagmin1|SynaptotagminI|Syt1-PA|Syt1-PB|Syt1-PC|Syt1-PE|Syt1-PF|Syt1-PG|Syt1-PH|Syt1-PI|synaptoptagmin 1|synaptotagmin|synaptotagmin 1|synaptotagmin I', map_location='23A5-23B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2772327, end_position_on_the_genomic_accession=2799979, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  33474 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33474, CurrentID=0, Status='live', Symbol='daw', Aliases='Dmel_CG16987, ALP23B, Alp, Alp23B, Alp23b, CG16987, DAW, Daw, Dmel\\CG16987, cg16987', description='dawdle', other_designations='Activin-Like protein|CG16987-PA|CG16987-PB|CG16987-PC|activin like protein|activin like protein at 23B|dActivin2|daw-PA|daw-PB|daw-PC', map_location='23B1-23B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2805261, end_position_on_the_genomic_accession=2812376, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33475 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33475, CurrentID=0, Status='live', Symbol='CG2964', Aliases='Dmel_ Dmel\\CG2964', description='CG2964 gene product from transcript CG2964-RA', other_designations='CG2964-PA', map_location='23B2-23B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2812437, end_position_on_the_genomic_accession=2814429, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33476 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33476, CurrentID=0, Status='live', Symbol='G6P', Aliases='Dmel_CG15400, CG15400, Dmel\\CG15400, G6pase', description='Glucose-6-Phosphatase', other_designations='CG15400-PB|G6P-PB', map_location='23B2-23B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2814336, end_position_on_the_genomic_accession=2815760, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33477 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33477, CurrentID=0, Status='live', Symbol='Duox', Aliases='Dmel_CG3131, CG3131, DUOX, Dmel\\CG3131, dDuox, dduox, duox', description='Dual oxidase', other_designations='CG3131-PB|CG3131-PC|Duox-PB|Duox-PC|NADPH dual oxidase|dual oxidase', map_location='23B2-23B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2815970, end_position_on_the_genomic_accession=2830248, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33478 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33478, CurrentID=0, Status='live', Symbol='CG3123', Aliases='Dmel_ Dmel\\CG3123, gi21064005, gi7295901', description='CG3123 gene product from transcript CG3123-RA', other_designations='CG3123-PA', map_location='23B2-23B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2823546, end_position_on_the_genomic_accession=2825506, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33479 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33479, CurrentID=0, Status='live', Symbol='CG3119', Aliases='Dmel_ Dmel\\CG3119, dC1GalT7', description='CG3119 gene product from transcript CG3119-RA', other_designations='CG3119-PA|CG3119-PB', map_location='23B3-23B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2834887, end_position_on_the_genomic_accession=2837833, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33480 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33480, CurrentID=0, Status='live', Symbol='Cpr23B', Aliases='Dmel_CG2973, CG2973, DmelCpr23B, Dmel\\CG2973', description='Cuticular protein 23B', other_designations='CG2973-PA|Cpr23B-PA|cuticular protein 23B', map_location='23B3-23B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2838411, end_position_on_the_genomic_accession=2839547, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33481 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33481, CurrentID=0, Status='live', Symbol='CG2975', Aliases='Dmel_ Dmel\\CG2975, dC1GalT4', description='CG2975 gene product from transcript CG2975-RA', other_designations='CG2975-PA', map_location='23B4-23B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2840124, end_position_on_the_genomic_accession=2842638, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33482 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33482, CurrentID=0, Status='live', Symbol='CG18558', Aliases='Dmel_ Dmel\\CG18558, dC1GalT3', description='CG18558 gene product from transcript CG18558-RB', other_designations='CG18558-PB|uncharacterized protein', map_location='23B4-23B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2842589, end_position_on_the_genomic_accession=2844513, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33483 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33483, CurrentID=0, Status='live', Symbol='CG18557', Aliases='Dmel_ Dmel\\CG18557, c-SPH125', description='CG18557 gene product from transcript CG18557-RA', other_designations='CG18557-PA|uncharacterized protein', map_location='23B4-23B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2844601, end_position_on_the_genomic_accession=2845734, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33484 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33484, CurrentID=0, Status='live', Symbol='CG3117', Aliases='Dmel_ Dmel\\CG3117, SPH94, c-SPH94', description='CG3117 gene product from transcript CG3117-RB', other_designations='CG3117-PB', map_location='23B4-23B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2845926, end_position_on_the_genomic_accession=2847212, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33485 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33485, CurrentID=0, Status='live', Symbol='CG2983', Aliases='Dmel_ Dmel\\CG2983, dC1GalT8', description='CG2983 gene product from transcript CG2983-RB', other_designations='CG2983-PB', map_location='23B5-23B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2847632, end_position_on_the_genomic_accession=2848997, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33486 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33486, CurrentID=0, Status='live', Symbol='CG3104', Aliases='Dmel_ Dmel\\CG3104', description='CG3104 gene product from transcript CG3104-RA', other_designations='CG3104-PA|CG3104-PB|CG3104-PC', map_location='23B5-23B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2848989, end_position_on_the_genomic_accession=2855778, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33487 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33487, CurrentID=0, Status='live', Symbol='RpS21', Aliases='Dmel_CG2986, CG2986, Dmel\\CG2986, M(2)23B, l(2)03575, l(2)168/14, l(2)k16814, oho23, oho23B, rpS21', description='Ribosomal protein S21', other_designations='CG2986-PA|CG2986-PB|CG2986-PD|CG2986-PE|CG2986-PF|Rp S21|RpS21-PA|RpS21-PB|RpS21-PD|RpS21-PE|RpS21-PF|overgrown hematopoietic organs 23B|overgrown hematopoietic organs at 23B|overgrown hematopoietic organs-23|ribosomal protein S21', map_location='23B5-23B6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2856070, end_position_on_the_genomic_accession=2857029, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33488 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33488, CurrentID=0, Status='live', Symbol='CG2991', Aliases='Dmel_ CT10107, CT42388, Dmel\\CG2991', description='CG2991 gene product from transcript CG2991-RA', other_designations='CG2991-PA|CG2991-PB|CG2991-PC', map_location='23B6-23B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2857164, end_position_on_the_genomic_accession=2868548, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33489 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33489, CurrentID=0, Status='live', Symbol='CG31694', Aliases='Dmel_ CG15401, CG3098, Dmel\\CG31694', description='CG31694 gene product from transcript CG31694-RA', other_designations='CG31694-PA|uncharacterized protein', map_location='23B7-23B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2868627, end_position_on_the_genomic_accession=2874489, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33490 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33490, CurrentID=0, Status='live', Symbol='CG8813', Aliases='Dmel_ Dmel\\CG8813, anon-WO0140519.96', description='CG8813 gene product from transcript CG8813-RA', other_designations='CG8813-PA', map_location='23B7-23B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2869652, end_position_on_the_genomic_accession=2870649, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33492 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33492, CurrentID=0, Status='live', Symbol='CG8814', Aliases='Dmel_ Dmel\\CG8814', description='CG8814 gene product from transcript CG8814-RA', other_designations='CG8814-PA', map_location='23B8-23C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2874890, end_position_on_the_genomic_accession=2877168, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33493 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33493, CurrentID=0, Status='live', Symbol='Prx6005', Aliases='Dmel_CG3083, 153181_at, CG3083, DPx-6005, DPx6005, Dmel\\CG3083, GM04269p', description='Peroxiredoxin 6005', other_designations='CG3083-PA|Prx6005-PA|peroxiredoxin 6005', map_location='23C1-23C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2877091, end_position_on_the_genomic_accession=2878232, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33495 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33495, CurrentID=0, Status='live', Symbol='NTPase', Aliases='Dmel_CG3059, CG3059, Dmel\\CG3059, NTPDase6, dm', description='CG3059 gene product from transcript CG3059-RD', other_designations='CD39-like NTPase|CG3059-PA|CG3059-PC|CG3059-PD|CG3059-PE|CG3059-PF|NTPase-PA|NTPase-PC|NTPase-PD|NTPase-PE|NTPase-PF', map_location='23C1-23C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2880704, end_position_on_the_genomic_accession=2885850, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33496 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33496, CurrentID=0, Status='live', Symbol='lilli', Aliases='Dmel_CG8817, 154454_at, 189Y, AFF4, BEST:GH09955, BcDNA:GM02019, CG8817, Dmel\\CG8817, Lilli, S(ls)4, SS2-1, SY2-1, Su(Raf)2A, Su(Raf)2a, dAFF4, l(2)00632, l(2)23Cc, l(2)K00632, l(2)K07920, l(2)k07920, l(2)k16124', description='lilliputian', other_designations='CG8817-PA|CG8817-PB|CG8817-PC|CG8817-PD|CG8817-PE|CG8817-PF|CG8817-PG|CG8817-PH|liliputian|lilli-PA|lilli-PB|lilli-PC|lilli-PD|lilli-PE|lilli-PF|lilli-PG|lilli-PH|suppressor of GMR-sina 2-1', map_location='23C1-23C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2885929, end_position_on_the_genomic_accession=2954406, orientation='plus', exon_count=17, OMIM='', no_hdr0=''),
  33498 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33498, CurrentID=0, Status='live', Symbol='Rbp9', Aliases='Dmel_CG3151, CG15402, CG3151, Dmel\\CG3151, RBP9, RBP9-2, RRM10, RRM9, Rbp10, Rpb9, fes, fs(2)B, rbp, rbp9, rbp9a, rrm10, rrm9', description='RNA-binding protein 9', other_designations='CG3151-PB|CG3151-PC|CG3151-PE|CG3151-PF|CG3151-PG|CG3151-PH|CG3151-PI|CG3151-PJ|CG3151-PK|RNA binding protein 9|RNA-binding protein 10|Rbp9-PB|Rbp9-PC|Rbp9-PE|Rbp9-PF|Rbp9-PG|Rbp9-PH|Rbp9-PI|Rbp9-PJ|Rbp9-PK|arrest|female sterile|female sterile (2) bridges|female sterile(2)Bridges', map_location='2-5 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2954762, end_position_on_the_genomic_accession=2968434, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  33499 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33499, CurrentID=0, Status='live', Symbol='Ts', Aliases='Dmel_CG3181, CG3181, Dmel\\CG3181, FBgn0024920, TS, anon-23Ca, c1.5', description='Thymidylate synthase', other_designations='CG3181-PA|CG3181-PB|Ts-PA|Ts-PB|thymidilate synthetase|thymidylate synthase', map_location='23C3-23C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2968293, end_position_on_the_genomic_accession=2969638, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33500 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33500, CurrentID=0, Status='live', Symbol='Rrp1', Aliases='Dmel_CG3178, 3178, CG3178, Dmel\\CG3178, RRP1, RRP1_DROME, Rrp-1, rrp', description='Recombination repair protein 1', other_designations='CG3178-PA|CG3178-PB|Rrp1-PA|Rrp1-PB|recombination repair protein 1|strand transferase', map_location='23C3-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2969773, end_position_on_the_genomic_accession=2972508, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33501 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33501, CurrentID=0, Status='live', Symbol='gammaTub23C', Aliases='Dmel_CG3157, CG 3157, CG3157, D.m.GAMMA-23C, Dmel\\CG3157, GAMMA23C, GTU88*, GTUB, Tub23, g-Tubulin, gamma tubulin, gamma-Tub, gamma-Tub23C, gamma-tub, gamma-tub 23C, gamma-tub23, gamma-tub23C, gamma-tubulin, gammaTUB, gammaTUB23C, gammaTubD, gamma[zy], gammatub, gammatub23C, l(2)23Ce, gammaTub23C', description='gamma-Tubulin at 23C', other_designations='&ggr-tubulin|23C gamma-tubulin|23C-gamma-tubulin|CG3157-PA|gama-tubulin|gamma tubulin|gamma tubulin 23C|gamma-Tubulin|gamma-tubulin (23C)|gamma-tubulin 23C|gamma-tubulin(23C)|gamma-tubulin-1|gamma-tubulin23C|gammaTub23C-PA|gammatubulin|lethal (2) 23Ce|tubulin', map_location='23C1-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2972891, end_position_on_the_genomic_accession=2974858, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33502 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33502, CurrentID=0, Status='live', Symbol='CG9641', Aliases='Dmel_ Dmel\\CG9641', description='CG9641 gene product from transcript CG9641-RB', other_designations='CG9641-PA|CG9641-PB', map_location='23C4-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2974859, end_position_on_the_genomic_accession=2976862, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33503 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33503, CurrentID=0, Status='live', Symbol='CG3165', Aliases='Dmel_ Dmel\\CG3165', description='CG3165 gene product from transcript CG3165-RA', other_designations='CG3165-PA|CG3165-PB', map_location='23C4-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2977122, end_position_on_the_genomic_accession=2978500, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33504 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33504, CurrentID=0, Status='live', Symbol='CG9643', Aliases='Dmel_ Dmel\\CG9643', description='CG9643 gene product from transcript CG9643-RB', other_designations='CG9643-PA|CG9643-PB', map_location='23C4-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2978411, end_position_on_the_genomic_accession=2979288, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33505 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33505, CurrentID=0, Status='live', Symbol='Chd1', Aliases='Dmel_CG3733, 2, CG3733, CHD-1, CHD1, DmCHD1, Dmel\\CG3733, chd1, dCHD1, l(2)23Cd', description='Chromodomain-helicase-DNA-binding protein 1', other_designations='CG3733-PA|CG3733-PB|CG3733-PC|Chd1-PA|Chd1-PB|Chd1-PC|Chromodomain-helicase-DNA-binding protein|chromo-ATPase/helicase-DNA-binding domain|chromo-ATPase/helicase-DNA-binding protein 1|lethal (2) 23Cd', map_location='23C4-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2979562, end_position_on_the_genomic_accession=2987723, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  19835678 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=19835678, CurrentID=0, Status='live', Symbol='pre-mod(mdg4)-K', Aliases='Dmel_CG44879, CG44879, Dmel\\CG44879', description='CG44879 gene product from transcript CG44879-RB', other_designations='CG44879-PA|CG44879-PB|pre-mod(mdg4)-K-PA|pre-mod(mdg4)-K-PB', map_location='93D8-93D8', chromosome='3R', genomic_nucleotide_accession_version='NT_033777.3', start_position_on_the_genomic_accession=21355692, end_position_on_the_genomic_accession=21359768, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33507 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33507, CurrentID=0, Status='live', Symbol='okr', Aliases='Dmel_CG3736, CG3736, DhR54, DmRAD54, DmRad54, Dmel\\CG3736, Dmrad54, Okr, RAD54, RAD54L, Rad54, Ras54, rad54', description='okra', other_designations='CG3736-PA|okr-PA', map_location='2-1 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2989594, end_position_on_the_genomic_accession=2992759, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33509 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33509, CurrentID=0, Status='live', Symbol='CG17265', Aliases='Dmel_ Dmel\\CG17265', description='CG17265 gene product from transcript CG17265-RA', other_designations='CG17265-PA|uncharacterized protein', map_location='23C4-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=2999286, end_position_on_the_genomic_accession=3016069, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33510 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33510, CurrentID=0, Status='live', Symbol='CG17224', Aliases='Dmel_ Dmel\\CG17224', description='CG17224 gene product from transcript CG17224-RC', other_designations='CG17224-PA|CG17224-PB|CG17224-PC|CG17224-PD|uncharacterized protein', map_location='23C4-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3016441, end_position_on_the_genomic_accession=3018308, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33511 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33511, CurrentID=0, Status='live', Symbol='CG17264', Aliases='Dmel_ Dmel\\CG17264', description='CG17264 gene product from transcript CG17264-RA', other_designations='CG17264-PA|CG17264-PB|uncharacterized protein', map_location='23C4-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3018508, end_position_on_the_genomic_accession=3021506, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33512 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33512, CurrentID=0, Status='live', Symbol='alpha4GT1', Aliases='Dmel_CG17223, CG17223, Dmel\\CG17223, alpha-4GT1', description='CG17223 gene product from transcript CG17223-RA', other_designations='CG17223-PA|alpha1,4-N-acetylgalactosaminyltransferase-1|alpha4GT1-PA', map_location='23C4-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3021309, end_position_on_the_genomic_accession=3023141, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33513 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33513, CurrentID=0, Status='live', Symbol='CG3542', Aliases='Dmel_ Dmel\\CG3542, prp40', description='CG3542 gene product from transcript CG3542-RA', other_designations='CG3542-PA', map_location='23C4-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3023226, end_position_on_the_genomic_accession=3026439, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33514 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33514, CurrentID=0, Status='live', Symbol='CG3605', Aliases='Dmel_ Dmel\\CG3605', description='CG3605 gene product from transcript CG3605-RB', other_designations='CG3605-PA|CG3605-PB', map_location='23C4-23C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3026252, end_position_on_the_genomic_accession=3029168, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33515 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33515, CurrentID=0, Status='live', Symbol='CG17219', Aliases='Dmel_ Dmel\\CG17219', description='CG17219 gene product from transcript CG17219-RA', other_designations='CG17219-PA|uncharacterized protein', map_location='23C4-23C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3029253, end_position_on_the_genomic_accession=3030616, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33516 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33516, CurrentID=0, Status='live', Symbol='GABPI', Aliases='Dmel_CG17257, CG17257, Dmel\\CG17257', description='beta4GalNAcTB pilot', other_designations='CG17257-PA|CG17257-PB|CG17257-PC|CG17257-PD|GABPI-PA|GABPI-PB|GABPI-PC|GABPI-PD', map_location='23C5-23C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3030539, end_position_on_the_genomic_accession=3032300, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33517 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33517, CurrentID=0, Status='live', Symbol='CG17258', Aliases='Dmel_ Dmel\\CG17258', description='CG17258 gene product from transcript CG17258-RC', other_designations='CG17258-PB|CG17258-PC|CG17258-PD|uncharacterized protein', map_location='23C5-23C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3032210, end_position_on_the_genomic_accession=3035348, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33518 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33518, CurrentID=0, Status='live', Symbol='CG17259', Aliases='Dmel_ DmSRS1, Dmel\\CG17259, SerRS', description='CG17259 gene product from transcript CG17259-RA', other_designations='CG17259-PA|CG17259-PB|seryl-tRNA synthetase|uncharacterized protein', map_location='23C5-23C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3035493, end_position_on_the_genomic_accession=3037403, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33519 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33519, CurrentID=0, Status='live', Symbol='CG17260', Aliases='Dmel_ Dmel\\CG17260', description='CG17260 gene product from transcript CG17260-RC', other_designations='CG17260-PA|CG17260-PB|CG17260-PC|uncharacterized protein', map_location='23C5-23C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3037230, end_position_on_the_genomic_accession=3038793, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33520 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33520, CurrentID=0, Status='live', Symbol='cnir', Aliases='Dmel_CG17262, CG17262, Cnir, Dmel\\CG17262', description='cornichon related', other_designations='CG17262-PA|Cni-related|cnir-PA', map_location='23C5-23C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3038826, end_position_on_the_genomic_accession=3039812, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33521 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33521, CurrentID=0, Status='live', Symbol='CG17221', Aliases='Dmel_ DM_7295851, Dmel\\CG17221', description='CG17221 gene product from transcript CG17221-RB', other_designations='CG17221-PA|CG17221-PB|CG17221-PC|uncharacterized protein', map_location='23C5-23C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3039976, end_position_on_the_genomic_accession=3041890, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33522 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33522, CurrentID=0, Status='live', Symbol='CG17261', Aliases='Dmel_ Dmel\\CG17261', description='CG17261 gene product from transcript CG17261-RB', other_designations='CG17261-PA|CG17261-PB|uncharacterized protein', map_location='23C5-23C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3042551, end_position_on_the_genomic_accession=3043593, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33524 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33524, CurrentID=0, Status='live', Symbol='FASN1', Aliases='Dmel_CG3523, BcDNA:GH07626, BcDNA:gh07626, CG3523, DM_7295848, Dmel\\CG3523, FAS, FASN, FASN[CG3523], FAS[CG3523], Fas, Fatty acid synthase, anon-EST:Posey235, anon-EST:Posey43, anon-WO0138581.1, dFAS, fas', description='Fatty acid synthase 1', other_designations='CG3523-PA|CG3523-PC|FASN1-PA|FASN1-PC|fatty acid synthase|fatty acid synthase 1|fatty acid synthetase', map_location='23C5-23D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3056598, end_position_on_the_genomic_accession=3068177, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33526 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33526, CurrentID=0, Status='live', Symbol='toc', Aliases='Dmel_CG9660, BA34, BcDNA:LD27161, CG9660, Dmel\\CG9660, Toc, l(2)01361, l(2)05527, l(2)K08224, l(2)k08224', description='toucan', other_designations='CG9660-PA|CG9660-PB|CG9660-PC|CG9660-PD|CG9660-PE|CG9660-PF|CG9660-PG|CG9660-PH|CG9660-PI|CG9660-PJ|toc-PA|toc-PB|toc-PC|toc-PD|toc-PE|toc-PF|toc-PG|toc-PH|toc-PI|toc-PJ', map_location='23D1-23D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3068345, end_position_on_the_genomic_accession=3144786, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  33527 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33527, CurrentID=0, Status='live', Symbol='CG15403', Aliases='Dmel_ Dmel\\CG15403', description='CG15403 gene product from transcript CG15403-RA', other_designations='CG15403-PA|uncharacterized protein', map_location='23D2-23D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3128635, end_position_on_the_genomic_accession=3129489, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33528 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33528, CurrentID=0, Status='live', Symbol='ND-B14.5B', Aliases='Dmel_CG12400, BcDNA:RE29623, CG12400, Dmel\\CG12400, N4BM', description='NADH dehydrogenase (ubiquinone) B14.5 B subunit', other_designations='CG12400-PA|CG12400-PB|NADH ubiquinone oxidoreductase B14.5B|NADH-ubiquinone oxidoreductase subunit B14.5b|NADH:ubiquinone oxidoreductase B14.5B subunit|ND-B14.5B-PA|ND-B14.5B-PB', map_location='23D2-23D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3144953, end_position_on_the_genomic_accession=3145848, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33529 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33529, CurrentID=0, Status='live', Symbol='Mad', Aliases='Dmel_CG12399, 2/23, CG12399, Dmel\\CG12399, E(zen)2, En(vvl), MAD, Mat, P-Mad, P-mad, PMad, Smad, Smad1, apg, c28, dMAD, dMad, l(2)K00237, l(2)k00237, mad, p-Mad, pMAD, pMad, pSmad', description='Mothers against dpp', other_designations='CG12399-PA|CG12399-PB|Mad-PA|Mad-PB|apang|mother against Dpp|mother against decapentaplegic|mothers against decapentaplegi|mothers against decapentaplegic|mothers against dpp|phospho-Smad|phosphoSmad|phosphorylated smad', map_location='2-7.7 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3146056, end_position_on_the_genomic_accession=3159643, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33530 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33530, CurrentID=0, Status='live', Symbol='gkt', Aliases='Dmel_CG8825, CG8825, CG8826, Dmel\\CG8825, Gkt, TDP1, Tdp1, anon-23Db, c22', description='glaikit', other_designations='CG8825-PA|Tyrosyl-DNA phosophodiesterase 1|anon-23Db|gkt-PA', map_location='23D4-23D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3159950, end_position_on_the_genomic_accession=3162399, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33532 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33532, CurrentID=0, Status='live', Symbol='Hydr2', Aliases='Dmel_CG3488, C24, CG3488, CT11757, DMU29170, Dmel\\CG3488, HYDR2, anon-23D, anon-23Da, c24, cg3488', description='alpha/beta hydrolase2', other_designations='CG3488-PA|CG3488-PB|CG3488-PC|Hydr2-PA|Hydr2-PB|Hydr2-PC', map_location='23D4-23D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3163645, end_position_on_the_genomic_accession=3169462, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33534 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33534, CurrentID=0, Status='live', Symbol='CG34393', Aliases='Dmel_ CG15405, CG8829, Dm_2L:14421, Dmel\\CG34393, Dmel_CG15405, Dmel_CG8829', description='CG34393 gene product from transcript CG34393-RA', other_designations='CG34393-PA|CG34393-PB|uncharacterized protein', map_location='23D5-23D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3175112, end_position_on_the_genomic_accession=3200496, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  33535 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33535, CurrentID=0, Status='live', Symbol='CG44002', Aliases='Dmel_ CG18555, CG34406, CG34406-2, Dmel\\CG44002', description='CG44002 gene product from transcript CG44002-RA', other_designations='CG44002-PA|uncharacterized protein', map_location='23D4-23D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3169820, end_position_on_the_genomic_accession=3171092, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33537 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33537, CurrentID=0, Status='live', Symbol='CG15404', Aliases='Dmel_ Dmel\\CG15404', description='CG15404 gene product from transcript CG15404-RB', other_designations='CG15404-PA|CG15404-PB|uncharacterized protein', map_location='23D4-23D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3173972, end_position_on_the_genomic_accession=3174504, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33538 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33538, CurrentID=0, Status='live', Symbol='CG3347', Aliases='Dmel_ Dmel\\CG3347', description='CG3347 gene product from transcript CG3347-RB', other_designations='CG3347-PB|CG3347-PC', map_location='23E1-23E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3269437, end_position_on_the_genomic_accession=3271806, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33539 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33539, CurrentID=0, Status='live', Symbol='CG3332', Aliases='Dmel_ Dmel\\CG3332', description='CG3332 gene product from transcript CG3332-RB', other_designations='CG3332-PA|CG3332-PB|CG3332-PC|CG3332-PD', map_location='23E1-23E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3275800, end_position_on_the_genomic_accession=3280534, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33540 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33540, CurrentID=0, Status='live', Symbol='CG9664', Aliases='Dmel_ Dmel\\CG9664', description='CG9664 gene product from transcript CG9664-RA', other_designations='CG9664-PA|CG9664-PB|CG9664-PC|CG9664-PD', map_location='23E1-23E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3291245, end_position_on_the_genomic_accession=3294706, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33541 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33541, CurrentID=0, Status='live', Symbol='CG9663', Aliases='Dmel_ Dmel\\CG9663', description='CG9663 gene product from transcript CG9663-RA', other_designations='CG9663-PA', map_location='23E1-23E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3294926, end_position_on_the_genomic_accession=3303130, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33542 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33542, CurrentID=0, Status='live', Symbol='CG15406', Aliases='Dmel_ Dmel\\CG15406', description='CG15406 gene product from transcript CG15406-RA', other_designations='CG15406-PA|uncharacterized protein', map_location='23E3-23E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3309222, end_position_on_the_genomic_accession=3311682, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33543 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33543, CurrentID=0, Status='live', Symbol='CG3277', Aliases='Dmel_ Dmel\\CG3277', description='CG3277 gene product from transcript CG3277-RC', other_designations='CG3277-PC', map_location='23E3-23E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3304100, end_position_on_the_genomic_accession=3317418, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  33544 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33544, CurrentID=0, Status='live', Symbol='CG3326', Aliases='Dmel_ DmCG3326, Dmel\\CG3326', description='CG3326 gene product from transcript CG3326-RB', other_designations='CG3326-PA|CG3326-PB|Dm-fidgetin|fidgetin_DROME', map_location='23E3-23E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3316794, end_position_on_the_genomic_accession=3319872, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33545 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33545, CurrentID=0, Status='live', Symbol='CG8837', Aliases='Dmel_ Dmel\\CG8837', description='CG8837 gene product from transcript CG8837-RB', other_designations='CG8837-PA|CG8837-PB', map_location='23E3-23E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3320245, end_position_on_the_genomic_accession=3323141, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33547 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33547, CurrentID=0, Status='live', Symbol='CG3285', Aliases='Dmel_ Dmel\\CG3285', description='CG3285 gene product from transcript CG3285-RA', other_designations='CG3285-PA|CG3285-PB', map_location='23E4-23E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3330928, end_position_on_the_genomic_accession=3332876, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33548 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33548, CurrentID=0, Status='live', Symbol='CG15408', Aliases='Dmel_ Dmel\\CG15408', description='CG15408 gene product from transcript CG15408-RA', other_designations='CG15408-PA|uncharacterized protein', map_location='23E4-23E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3332814, end_position_on_the_genomic_accession=3334790, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33551 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33551, CurrentID=0, Status='live', Symbol='CG8838', Aliases='Dmel_ Dmel\\CG8838, anon-WO0140519.135', description='CG8838 gene product from transcript CG8838-RA', other_designations='CG8838-PA', map_location='23E5-23E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3357646, end_position_on_the_genomic_accession=3358618, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33552 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33552, CurrentID=0, Status='live', Symbol='CG34394', Aliases='Dmel_ BcDNA:RE58243, CG15411, CG3304, Dmel\\CG34394, Dmel_CG15411, Dmel_CG3304', description='CG34394 gene product from transcript CG34394-RH', other_designations='CG34394-PA|CG34394-PC|CG34394-PD|CG34394-PE|CG34394-PG|CG34394-PH|uncharacterized protein', map_location='23E5-23E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3358640, end_position_on_the_genomic_accession=3373372, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  33553 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33553, CurrentID=0, Status='live', Symbol='CG15412', Aliases='Dmel_ Dmel\\CG15412', description='CG15412 gene product from transcript CG15412-RB', other_designations='CG15412-PB|CG15412-PC|uncharacterized protein', map_location='23F1-23F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3373567, end_position_on_the_genomic_accession=3375711, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33554 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33554, CurrentID=0, Status='live', Symbol='CG9662', Aliases='Dmel_ BcDNA:AT03617, Dmel\\CG9662', description='CG9662 gene product from transcript CG9662-RB', other_designations='CG9662-PA|CG9662-PB', map_location='23F1-23F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3375832, end_position_on_the_genomic_accession=3376737, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33555 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33555, CurrentID=0, Status='live', Symbol='Ptpa', Aliases='Dmel_CG3289, CG3289, DPTPA, Dmel\\CG3289, PTPA', description='Phosphotyrosyl phosphatase activator', other_designations='CG3289-PA|Ptpa-PA|phosphotyrosyl phosphatase activator', map_location='23F1-23F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3377002, end_position_on_the_genomic_accession=3378590, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33556 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33556, CurrentID=0, Status='live', Symbol='pgant2', Aliases='Dmel_CG3254, CG3254, Dmel\\CG3254, PGANT2', description='polypeptide GalNAc transferase 2', other_designations='CG3254-PA|CG3254-PB|pgant2-PA|pgant2-PB', map_location='23F1-23F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3404460, end_position_on_the_genomic_accession=3426719, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  33557 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33557, CurrentID=0, Status='live', Symbol='CG8840', Aliases='Dmel_ Dmel\\CG8840', description='CG8840 gene product from transcript CG8840-RA', other_designations='CG8840-PA', map_location='23F1-23F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3410560, end_position_on_the_genomic_accession=3411199, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33559 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33559, CurrentID=0, Status='live', Symbol='CG2772', Aliases='Dmel_ BcDNA:RE45077, Dmel\\CG2772', description='CG2772 gene product from transcript CG2772-RA', other_designations='CG2772-PA', map_location='23F3-23F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3445992, end_position_on_the_genomic_accession=3447589, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33560 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33560, CurrentID=0, Status='live', Symbol='Snx1', Aliases='Dmel_CG2774, CG2774, Dmel\\CG2774, Dsnx1, Vps5', description='Sorting nexin 1', other_designations='CG2774-PA|CG2774-PB|Snx1-PA|Snx1-PB|sorting nexin 1', map_location='23F3-23F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3449683, end_position_on_the_genomic_accession=3452106, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33561 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33561, CurrentID=0, Status='live', Symbol='CG12795', Aliases='Dmel_ Dmel\\CG12795', description='CG12795 gene product from transcript CG12795-RB', other_designations='CG12795-PB|uncharacterized protein', map_location='23F3-23F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3452466, end_position_on_the_genomic_accession=3453755, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33562 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33562, CurrentID=0, Status='live', Symbol='Cog3', Aliases='Dmel_CG3248, CG 3248, CG3248, COG3, Dmel\\CG3248, SEC34, dCOG3', description='CG3248 gene product from transcript CG3248-RA', other_designations='CG3248-PA|Cog3-PA', map_location='23F3-23F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3453697, end_position_on_the_genomic_accession=3457064, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33563 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33563, CurrentID=0, Status='live', Symbol='Sec5', Aliases='Dmel_CG8843, CG8843, Dmel\\CG8843, SEC5, Sec-5p, dsec5, sec5, Sec5', description='Sec5 ortholog (S. cerevisiae)', other_designations='CG8843-PA|Sec5 ortholog|Sec5-PA|sec5', map_location='23F3-23F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3457302, end_position_on_the_genomic_accession=3460367, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33564 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33564, CurrentID=0, Status='live', Symbol='CG3246', Aliases='Dmel_ Dmel\\CG3246', description='CG3246 gene product from transcript CG3246-RA', other_designations='CG3246-PA', map_location='23F3-23F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3460322, end_position_on_the_genomic_accession=3461952, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33565 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33565, CurrentID=0, Status='live', Symbol='msl-2', Aliases='Dmel_CG3241, CG3241, Dmel\\CG3241, MSL, MSL-2, MSL2, Msl 1-3, Msl-2, Msl2, km(2)A, kmA, msl, msl2', description='male-specific lethal 2', other_designations='CG3241-PA|CG3241-PB|killer of males|killer-of-males-A|male specifc lethal|male specific lethal 2|male specific-lethal 2|male-specific-lethal 2|male-specific-lethal-2|msl-2-PA|msl-2-PB', map_location='2-9.0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3462218, end_position_on_the_genomic_accession=3466112, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33567 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33567, CurrentID=0, Status='live', Symbol='CG3238', Aliases='Dmel_ Dmel\\CG3238', description='CG3238 gene product from transcript CG3238-RB', other_designations='CG3238-PA|CG3238-PB', map_location='23F3-23F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3467342, end_position_on_the_genomic_accession=3470004, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33568 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33568, CurrentID=0, Status='live', Symbol='CG31776', Aliases='Dmel_ CG8845, CG8845a, Dmel\\CG31776, dppGalNAcT10', description='CG31776 gene product from transcript CG31776-RA', other_designations='CG31776-PA|uncharacterized protein', map_location='23F3-23F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3470182, end_position_on_the_genomic_accession=3472364, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33569 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33569, CurrentID=0, Status='live', Symbol='Thor', Aliases='Dmel_CG8846, 153432_at, 43-BP, 4E-BP, 4E-BP1, 4EBP, 4e-BP, 4e-bp, 4eBP, 4ebp, BcDNA.HL08053, BcDNA:HL08053, CG8846, CT8705, Dm 4E-BP, Dmel\\CG8846, Phas1/EIF4EBP, anon-WO0172774.158, d4E-BP, d4E-BP1, d4EBP, d4e-bp, d4eBP, dthor, eIF4E-BP, l(2)06270, l(2)k07736, l(2)k13517, pp20, thor', description='CG8846 gene product from transcript CG8846-RA', other_designations='4E binding protein|CG8846-PA|CG8846-PB|Eif4e-binding protein|Thor-PA|Thor-PB|eIF-4E-binding protein|eIF4E binding protein|eif4e-binding protein 4EBP|eukaryotic initiation factor 4E binding protein|eukaryotic initiation factor 4E-binding protein|eukaryotic translation initiation factor 4E binding protein|eukaryotic translation initiation factor 4E-binding protein|insulin-stimulated eIF-4E binding protein|lethal (2) 06270|thor|translation initiation factor 4E binding protein', map_location='23F3-23F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3478434, end_position_on_the_genomic_accession=3479612, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33570 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33570, CurrentID=0, Status='live', Symbol='CG15414', Aliases='Dmel_ Dmel\\CG15414', description='CG15414 gene product from transcript CG15414-RA', other_designations='CG15414-PA|uncharacterized protein', map_location='23F3-23F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3480755, end_position_on_the_genomic_accession=3491071, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33571 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33571, CurrentID=0, Status='live', Symbol='tim', Aliases='Dmel_CG3234, CG3234, Dmel\\CG3234, Ritsu, TIM, Tim, dTIM, dTim, dtim, mel_tim, rit1, tim', description='timeless', other_designations='CG3234-PB|CG3234-PL|CG3234-PM|CG3234-PN|CG3234-PO|CG3234-PP|CG3234-PR|CG3234-PS|TIMELESS|dtimeless|ritsu|tim-PB|tim-PL|tim-PM|tim-PN|tim-PO|tim-PP|tim-PR|tim-PS|timeless1', map_location='23F6-23F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3493986, end_position_on_the_genomic_accession=3508119, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  33572 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33572, CurrentID=0, Status='live', Symbol='CG31954', Aliases='Dmel_ CG3229, Dmel\\CG31954, SP107', description='CG31954 gene product from transcript CG31954-RA', other_designations='CG31954-PA|uncharacterized protein', map_location='23F6-23F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3509058, end_position_on_the_genomic_accession=3510102, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33573 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33573, CurrentID=0, Status='live', Symbol='CG17593', Aliases='Dmel_ Dmel\\CG17593', description='CG17593 gene product from transcript CG17593-RB', other_designations='CG17593-PA|CG17593-PB|uncharacterized protein', map_location='23F6-23F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3514872, end_position_on_the_genomic_accession=3517264, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33574 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33574, CurrentID=0, Status='live', Symbol='CG3213', Aliases='Dmel_ Dmel\\CG3213, bs30c03.y1', description='CG3213 gene product from transcript CG3213-RA', other_designations='CG3213-PA', map_location='23F6-23F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3517273, end_position_on_the_genomic_accession=3519651, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  5740462 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740462, CurrentID=0, Status='live', Symbol='CG34398', Aliases='Dmel_ CG15867, CG9487, Dmel\\CG34398, Dmel_CG15867, Dmel_CG9487', description='CG34398 gene product from transcript CG34398-RE', other_designations='CG34398-PA|CG34398-PC|CG34398-PE|CG34398-PF|CG34398-PG|CG34398-PH|CG34398-PI|CG34398-PJ|CG34398-PK|CG34398-PL|uncharacterized protein', map_location='29F3-29F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8898786, end_position_on_the_genomic_accession=8933594, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  33576 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33576, CurrentID=0, Status='live', Symbol='Sr-CIV', Aliases='Dmel_CG3212, CG3212, CT10789, Dmel\\CG3212, SR-CIV', description='Scavenger receptor class C, type IV', other_designations='CG3212-PA|Sr-CIV-PA|scavenger receptor class C, type IV', map_location='23F6-23F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3522521, end_position_on_the_genomic_accession=3524056, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33577 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33577, CurrentID=0, Status='live', Symbol='CG8852', Aliases='Dmel_ CT9284, Dmel\\CG8852', description='CG8852 gene product from transcript CG8852-RA', other_designations='CG8852-PA', map_location='23F6-24A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3525131, end_position_on_the_genomic_accession=3527588, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33578 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33578, CurrentID=0, Status='live', Symbol='Spindly', Aliases='Dmel_CG15415, CG15415, Dmel\\CG15415', description='CG15415 gene product from transcript CG15415-RB', other_designations='CG15415-PB|Spindly-PB|spindly', map_location='24A1-24A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3527387, end_position_on_the_genomic_accession=3530317, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33579 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33579, CurrentID=0, Status='live', Symbol='Che-13', Aliases='Dmel_CG8853, CG8853, CHE-13, Dmel\\CG8853, Hippi, IFT55, IFT57, che-13', description='Che-13 ortholog (C. elegans)', other_designations='CG8853-PA|Che-13 ortholog|Che-13-PA|hippi', map_location='24A1-24A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3530789, end_position_on_the_genomic_accession=3532678, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33581 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33581, CurrentID=0, Status='live', Symbol='sob', Aliases='Dmel_CG3242, CG3242, Dmel\\CG3242, Sob, org1', description='sister of odd and bowl', other_designations='CG3242-PA|odd skipped-related 1|sob-PA', map_location='24A1-24A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3578013, end_position_on_the_genomic_accession=3580769, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33583 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33583, CurrentID=0, Status='live', Symbol='odd', Aliases='Dmel_CG3851, CG3851, Dmel\\CG3851, ODD, Odd, l(2)01863, ods', description='odd skipped', other_designations='CG3851-PA|odd paired|odd-PA|odd-skipped|oddskipped', map_location='2-8 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3604224, end_position_on_the_genomic_accession=3606756, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33585 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33585, CurrentID=0, Status='live', Symbol='CG15418', Aliases='Dmel_ Dmel\\CG15418', description='CG15418 gene product from transcript CG15418-RA', other_designations='CG15418-PA|uncharacterized protein', map_location='24A2-24A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3621110, end_position_on_the_genomic_accession=3621681, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33589 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33589, CurrentID=0, Status='live', Symbol='CG16704', Aliases='Dmel_ BcDNA:RH31195, CT37177, Dmel\\CG16704', description='CG16704 gene product from transcript CG16704-RB', other_designations='CG16704-PA|CG16704-PB|uncharacterized protein', map_location='24B1-24B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3692123, end_position_on_the_genomic_accession=3692587, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33590 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33590, CurrentID=0, Status='live', Symbol='CG3513', Aliases='Dmel_ Dmel\\CG3513', description='CG3513 gene product from transcript CG3513-RA', other_designations='CG3513-PA', map_location='24B1-24B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3692699, end_position_on_the_genomic_accession=3693182, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33591 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33591, CurrentID=0, Status='live', Symbol='CG16713', Aliases='Dmel_ CT37195, Dmel\\CG16713', description='CG16713 gene product from transcript CG16713-RA', other_designations='CG16713-PA|uncharacterized protein', map_location='24B2-24B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3695032, end_position_on_the_genomic_accession=3695411, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33592 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33592, CurrentID=0, Status='live', Symbol='IM33', Aliases='Dmel_CG16712, BcDNA:RH05411, BcDNA:RH38008, CG16712, CT37183, DIM 33, Dmel\\CG16712', description='Immune induced molecule 33', other_designations='CG16712-PA|CG16712-PB|IM33-PA|IM33-PB|immune induced molecule 33', map_location='24B3-24B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3696218, end_position_on_the_genomic_accession=3696658, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33593 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33593, CurrentID=0, Status='live', Symbol='CG3604', Aliases='Dmel_ BcDNA:LP04037, Dmel\\CG3604', description='CG3604 gene product from transcript CG3604-RB', other_designations='CG3604-PA|CG3604-PB', map_location='24B3-24B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3697242, end_position_on_the_genomic_accession=3697872, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33594 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33594, CurrentID=0, Status='live', Symbol='CG10031', Aliases='Dmel_ Dmel\\CG10031', description='CG10031 gene product from transcript CG10031-RA', other_designations='CG10031-PA|uncharacterized protein', map_location='24B3-24C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3698451, end_position_on_the_genomic_accession=3699092, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33595 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33595, CurrentID=0, Status='live', Symbol='CG2816', Aliases='Dmel_ Dmel\\CG2816', description='CG2816 gene product from transcript CG2816-RB', other_designations='CG2816-PB', map_location='24C1-24C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3703659, end_position_on_the_genomic_accession=3704253, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33597 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33597, CurrentID=0, Status='live', Symbol='CG2818', Aliases='Dmel_ Dmel\\CG2818', description='CG2818 gene product from transcript CG2818-RA', other_designations='CG2818-PA|CG2818-PB', map_location='24C1-24C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3713360, end_position_on_the_genomic_accession=3716810, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33599 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33599, CurrentID=0, Status='live', Symbol='Shaw', Aliases='Dmel_CG2822, CG15419, CG2822, Dmel\\CG2822, Kv3, Kv3.12, dShaw, dShaw2, shaw, Shaw', description='Shaker cognate w', other_designations='CG2822-PA|CG2822-PB|CG2822-PC|CG2822-PD|CG2822-PE|Shaw-PA|Shaw-PB|Shaw-PC|Shaw-PD|Shaw-PE|shaker cognate w', map_location='24C1-24C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3718185, end_position_on_the_genomic_accession=3729145, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  33600 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33600, CurrentID=0, Status='live', Symbol='CG10019', Aliases='Dmel_ BEST:GH25970, Dmel\\CG10019, GH25970', description='CG10019 gene product from transcript CG10019-RC', other_designations='CG10019-PB|CG10019-PC|uncharacterized protein', map_location='24C2-24C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3730466, end_position_on_the_genomic_accession=3754617, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  33601 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33601, CurrentID=0, Status='live', Symbol='CG43707', Aliases='Dmel_ CG10020, CG31772, CG31959, Dmel\\CG43707, Dmel_CG31772, Dmel_CG31959', description='CG43707 gene product from transcript CG43707-RF', other_designations='CG43707-PC|CG43707-PD|CG43707-PE|CG43707-PF|CG43707-PG|CG43707-PH|CG43707-PI|uncharacterized protein', map_location='24C3-24C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3757256, end_position_on_the_genomic_accession=3769525, orientation='plus', exon_count=21, OMIM='', no_hdr0=''),
  33602 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33602, CurrentID=0, Status='live', Symbol='bowl', Aliases='Dmel_CG10021, 17-29-5, Bowl, CG10021, Dmel\\CG10021, Su(tor)2-1, l(2)c, org2', description='brother of odd with entrails limited', other_designations='CG10021-PA|CG10021-PB|CG10021-PC|CG10021-PD|CG10021-PF|CG10021-PG|CG10021-PH|bowel|bowl-PA|bowl-PB|bowl-PC|bowl-PD|bowl-PF|bowl-PG|bowl-PH|odd skipped-related 2', map_location='2-16 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3771700, end_position_on_the_genomic_accession=3784121, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33603 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33603, CurrentID=0, Status='live', Symbol='CG31958', Aliases='Dmel_ CG10022, Dmel\\CG31958', description='CG31958 gene product from transcript CG31958-RA', other_designations='CG31958-PA|uncharacterized protein', map_location='24C4-24C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3785738, end_position_on_the_genomic_accession=3786343, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33604 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33604, CurrentID=0, Status='live', Symbol='bark', Aliases='Dmel_CG3921, CG3921, Dmel\\CG3921, aka', description='bark beetle', other_designations='CG3921-PA|CG3921-PB|CG3921-PC|anakonda|bark-PA|bark-PB|bark-PC', map_location='24C5-24C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3787167, end_position_on_the_genomic_accession=3802726, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  33606 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33606, CurrentID=0, Status='live', Symbol='CG3407', Aliases='Dmel_ Dmel\\CG3407, cg3407', description='CG3407 gene product from transcript CG3407-RA', other_designations='CG3407-PA', map_location='24C5-24C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3810801, end_position_on_the_genomic_accession=3813410, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33607 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33607, CurrentID=0, Status='live', Symbol='slp1', Aliases='Dmel_CG16738, CG16738, Dmel\\CG16738, Dmslp1, FD6, FoxG, SLP, SLP1, Slp, Slp-1, Slp1, l(2)05965, sko1, slp, slp-1, slp-2', description='sloppy paired 1', other_designations='CG16738-PA|Sloppy-paired|Sloppy-paired1|sloppy|sloppy pair|sloppy paired|sloppy-paired 1|sloppy-paired-1|slp1-PA', map_location='2-8 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3825675, end_position_on_the_genomic_accession=3827099, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33608 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33608, CurrentID=0, Status='live', Symbol='slp2', Aliases='Dmel_CG2939, CG2939, Dmel\\CG2939, Dmslp2, FD7, FoxG, SLP, Slp, Slp2, slp', description='sloppy paired 2', other_designations='CG2939-PA|Sloppy-paired|sloppy pair|sloppy paired|sloppy-paired 2|slp2-PA', map_location='2-8 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3836840, end_position_on_the_genomic_accession=3839185, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33609 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33609, CurrentID=0, Status='live', Symbol='CG3964', Aliases='Dmel_ Dmel\\CG3964', description='CG3964 gene product from transcript CG3964-RB', other_designations='CG3964-PA|CG3964-PB|CG3964-PC', map_location='24C8-24C8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3862668, end_position_on_the_genomic_accession=3867507, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  33610 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33610, CurrentID=0, Status='live', Symbol='Cep97', Aliases='Dmel_CG3980, CG3980, CT13231, D Dmel\\CG3980', description='CG3980 gene product from transcript CG3980-RB', other_designations='CG3980-PB|CG3980-PD|Cep97-PB|Cep97-PD', map_location='24C8-24C8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3867697, end_position_on_the_genomic_accession=3871425, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33611 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33611, CurrentID=0, Status='live', Symbol='capu', Aliases='Dmel_CG3399, CG15420, CG3399, Capu, Dmel\\CG3399, capp', description='cappuccino', other_designations='CG3399-PA|CG3399-PB|CG3399-PD|CG3399-PE|CG3399-PF|CG3399-PG|CG3399-PH|CG3399-PI|CG3399-PJ|cappucino|capu-PA|capu-PB|capu-PD|capu-PE|capu-PF|capu-PG|capu-PH|capu-PI|capu-PJ', map_location='2-8 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3872646, end_position_on_the_genomic_accession=3902860, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  33613 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33613, CurrentID=0, Status='live', Symbol='fred', Aliases='Dmel_CG31774, CG12675, CG31774, CG3390, CG3393, CT11413, Dmel\\CG31774, Fred', description='friend of echinoid', other_designations='CG31774-PF|CG31774-PG|CG31774-PH|fred-PF|fred-PG|fred-PH', map_location='24C9-24D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3902928, end_position_on_the_genomic_accession=3991713, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33615 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33615, CurrentID=0, Status='live', Symbol='CG15422', Aliases='Dmel_ Dmel\\CG15422', description='CG15422 gene product from transcript CG15422-RA', other_designations='CG15422-PA|uncharacterized protein', map_location='24D3-24D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4004984, end_position_on_the_genomic_accession=4005670, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33616 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33616, CurrentID=0, Status='live', Symbol='CG15423', Aliases='Dmel_ Dmel\\CG15423', description='CG15423 gene product from transcript CG15423-RA', other_designations='CG15423-PA|uncharacterized protein', map_location='24D3-24D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4006041, end_position_on_the_genomic_accession=4006606, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33617 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33617, CurrentID=0, Status='live', Symbol='CG43773', Aliases='Dmel_ CG10039, Dmel\\CG43773', description='CG43773 gene product from transcript CG43773-RA', other_designations='CG43773-PA|uncharacterized protein', map_location='24D3-24D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4007690, end_position_on_the_genomic_accession=4007984, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33619 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33619, CurrentID=0, Status='live', Symbol='ed', Aliases='Dmel_CG12676, 1X5, CG12676, CG15424, CG16842, CT13476, CT35484, Dmel\\CG12676, E(Elp)24D, E(Elp)[24D], Ed, l(2)k01102', description='echinoid', other_designations='CG12676-PA|CG12676-PB|CG12676-PC|ed-PA|ed-PB|ed-PC', map_location='2-11.0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4031377, end_position_on_the_genomic_accession=4115749, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  33621 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33621, CurrentID=0, Status='live', Symbol='Sr-CI', Aliases='Dmel_CG4099, CG4099, CT9876, D-SR-CI, DSR-CI, Dmel\\CG4099, SR-C1, SR-CI, Sr-C1, Sr-Cl, dSR-C1, dSR-CI, dSRC-I, dScR-I', description='Scavenger receptor class C, type I', other_designations='CG4099-PA|CG4099-PB|Sr-CI-PA|Sr-CI-PB|scavenger receptor|scavenger receptor C, type I|scavenger receptor class C, type 1|scavenger receptor class C, type I', map_location='24D6-24D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4121702, end_position_on_the_genomic_accession=4124153, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33622 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33622, CurrentID=0, Status='live', Symbol='CG2955', Aliases='Dmel_ Dmel\\CG2955, anon-WO0140519.175', description='CG2955 gene product from transcript CG2955-RA', other_designations='CG2955-PA', map_location='24D6-24D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4149279, end_position_on_the_genomic_accession=4151203, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33623 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33623, CurrentID=0, Status='live', Symbol='Or24a', Aliases='Dmel_CG11767, 24D.1, 24a, CG11767, DOR24D.1, DOR48, Dmel\\CG11767, Or24D.1', description='Odorant receptor 24a', other_designations='CG11767-PB|Or24a-PB|odorant receptor 24a|olfactory receptor 24D.1', map_location='24D7-24D7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4164689, end_position_on_the_genomic_accession=4166134, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33626 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33626, CurrentID=0, Status='live', Symbol='CG3714', Aliases='Dmel_ AAF51037, Dmel\\CG3714', description='CG3714 gene product from transcript CG3714-RG', other_designations='CG3714-PA|CG3714-PB|CG3714-PC|CG3714-PD|CG3714-PE|CG3714-PF|CG3714-PG|CG3714-PH', map_location='24D8-24D8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4189340, end_position_on_the_genomic_accession=4198071, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  33627 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33627, CurrentID=0, Status='live', Symbol='ft', Aliases='Dmel_CG3352, 79/18, CG3352, CT11259, Dm Fat, Dmel\\CG3352, Fat, Ft, l(2)24Da, l(2)79/18, l(2)fat, l(2)fd, l(2)ft, l(2)gd-1, l(2)gd-l, l(2)gd2, l(2)k07918', description='fat', other_designations='CG3352-PA|floppy-discs|ft-PA|giant discs 2|giant-discs-1', map_location='2-12.0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4198404, end_position_on_the_genomic_accession=4221796, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  33628 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33628, CurrentID=0, Status='live', Symbol='CG3702', Aliases='Dmel_ Dmel\\CG3702, cg3702', description='CG3702 gene product from transcript CG3702-RA', other_designations='CG3702-PA|CG3702-PB', map_location='24D8-24E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4224650, end_position_on_the_genomic_accession=4227097, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33629 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33629, CurrentID=0, Status='live', Symbol='RpL40', Aliases='Dmel_CG2960, BcDNA:RE10554, CEP52, CG2960, DUb52, Dmel\\CG2960, Dub52, Rpl40, Ub52, Ubi-f, Ubi-f52, Ubiq', description='Ribosomal protein L40', other_designations='CG2960-PA|CG2960-PB|RpL40-PA|RpL40-PB|ribosomal protein L40|ubiquitin|ubiquitin 52-AA extension protein|ubiquitin fusion 52', map_location='24E1-24E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4227699, end_position_on_the_genomic_accession=4228561, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33630 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33630, CurrentID=0, Status='live', Symbol='CG15425', Aliases='Dmel_ Dmel\\CG15425, anon-SAGE:Wang-056', description='CG15425 gene product from transcript CG15425-RA', other_designations='CG15425-PA|anon-SAGE:Wang-056|uncharacterized protein', map_location='24E1-24E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4257572, end_position_on_the_genomic_accession=4258425, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33631 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33631, CurrentID=0, Status='live', Symbol='Art2', Aliases='Dmel_CG3675, CG3675, DART2, Dmel\\CG3675', description='Arginine methyltransferase 2', other_designations='Art2-PA|Art2-PB|CG3675-PA|CG3675-PB|arginine methyltransferase 2', map_location='24E1-24E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4277696, end_position_on_the_genomic_accession=4281324, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33635 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33635, CurrentID=0, Status='live', Symbol='bdl', Aliases='Dmel_CG16857, BcDNA:GH11322, CG16857, CT35491, Dmel\\CG16857, GH11322', description='borderless', other_designations='CG16857-PA|bdl-PA', map_location='24E1-24E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4324554, end_position_on_the_genomic_accession=4331830, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33636 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33636, CurrentID=0, Status='live', Symbol='Atet', Aliases='Dmel_CG2969, CG2969, Dmel\\CG2969', description='ABC transporter expressed in trachea', other_designations='Atet-PA|Atet-PB|Atet-PC|Atet-PD|CG2969-PA|CG2969-PB|CG2969-PC|CG2969-PD', map_location='24E1-24E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4333913, end_position_on_the_genomic_accession=4345776, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  33637 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33637, CurrentID=0, Status='live', Symbol='CG15429', Aliases='Dmel_ BcDNA:AT23465, Dmel\\CG15429', description='CG15429 gene product from transcript CG15429-RA', other_designations='CG15429-PA|CG15429-PB|uncharacterized protein', map_location='24E1-24E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4352975, end_position_on_the_genomic_accession=4354034, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33638 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33638, CurrentID=0, Status='live', Symbol='Traf4', Aliases='Dmel_CG3048, CG3048, DTRAF, DTRAF1, Dmel\\CG3048, TRAF, TRAF1, TRAF4, Traf1, dTRAF, dTRAF1, dTraf1, dTraf4, dtraf1, traf-4, traf1, traf4', description='TNF-receptor-associated factor 4', other_designations='CG3048-PA|CG3048-PE|TNF receptor associated factor 1|TNF-receptor-associated factor 1|Traf4-PA|Traf4-PE', map_location='24E1-24E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4361925, end_position_on_the_genomic_accession=4380716, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33639 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33639, CurrentID=0, Status='live', Symbol='CG17612', Aliases='Dmel_ Dmel\\CG17612', description='CG17612 gene product from transcript CG17612-RB', other_designations='CG17612-PA|CG17612-PB|uncharacterized protein', map_location='24E4-24E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4380722, end_position_on_the_genomic_accession=4382735, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33640 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33640, CurrentID=0, Status='live', Symbol='Vps53', Aliases='Dmel_CG3338, CG3338, Dmel\\CG3338', description='Vacuolar protein sorting 53', other_designations='CG3338-PA|Vps53-PA|vacuolar protein sorting 53', map_location='24E4-24E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4382925, end_position_on_the_genomic_accession=4386062, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33641 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33641, CurrentID=0, Status='live', Symbol='Psf2', Aliases='Dmel_CG18013, CG18013, Dmel\\CG18013, P{lacW}l(2)SH0805[SH0805], l(2)SH0805, l(2)SH2 0805', description='CG18013 gene product from transcript CG18013-RC', other_designations='CG18013-PB|CG18013-PC|Psf2-PB|Psf2-PC|lethal (2) SH0805', map_location='24F1-24F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4386182, end_position_on_the_genomic_accession=4387356, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33642 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33642, CurrentID=0, Status='live', Symbol='Tps1', Aliases='Dmel_CG4104, 19920676, BcDNA:GH08860, CG4104, CG4104 PA, Dmel\\CG4104, TPS, TreS, dtps1, jf5, l(2)24Ea, l(2)jf4, l(2)jf5, l(2)k08903, tps1', description='Trehalose-6-phosphate synthase 1', other_designations='CG4104-PA|Tps1-PA|Trehalos-6-phosphate synthase|lethal(2)24Ea|trehalose synthase|trehalose-6-phosphate synthase|trehalose-phosphate synthase', map_location='24E4-24E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4388327, end_position_on_the_genomic_accession=4392778, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33643 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33643, CurrentID=0, Status='live', Symbol='CG3652', Aliases='Dmel_ Dmel\\CG3652', description='CG3652 gene product from transcript CG3652-RA', other_designations='CG3652-PA', map_location='24E5-24E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4392770, end_position_on_the_genomic_accession=4393876, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33644 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33644, CurrentID=0, Status='live', Symbol='l(2)k05819', Aliases='Dmel_CG3054, CG3054, Dmel\\CG3054, anon-WO0140519.156', description='lethal (2) k05819', other_designations='CG3054-PA|CG3054-PC|CG3054-PD|l(2)k05819-PA|l(2)k05819-PC|l(2)k05819-PD', map_location='24E5-24F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4394196, end_position_on_the_genomic_accession=4400487, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  33645 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33645, CurrentID=0, Status='live', Symbol='Dim1', Aliases='Dmel_CG3058, BcDNA:RE13747, CG3058, Dmel\\CG3058, U5-15kD', description='CG3058 gene product from transcript CG3058-RA', other_designations='CG3058-PA|Dim1-PA', map_location='24F1-24F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4403251, end_position_on_the_genomic_accession=4403955, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33646 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33646, CurrentID=0, Status='live', Symbol='CG15431', Aliases='Dmel_ Dmel\\CG15431', description='CG15431 gene product from transcript CG15431-RA', other_designations='CG15431-PA|CG15431-PB|uncharacterized protein', map_location='24F1-24F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4403992, end_position_on_the_genomic_accession=4441282, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33647 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33647, CurrentID=0, Status='live', Symbol='CG15432', Aliases='Dmel_ Dmel\\CG15432, cg15432', description='CG15432 gene product from transcript CG15432-RC', other_designations='CG15432-PA|CG15432-PB|CG15432-PC|uncharacterized protein', map_location='24F2-24F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4442320, end_position_on_the_genomic_accession=4442985, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33648 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33648, CurrentID=0, Status='live', Symbol='morgue', Aliases='Dmel_CG15437, BcDNA:GH02435, CG15437, Dmel\\CG15437, FBXO18, Morgue', description='modifier of rpr and grim, ubiquitously expressed', other_designations='CG15437-PA|morgue-PA', map_location='24F2-24F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4442870, end_position_on_the_genomic_accession=4444680, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33649 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33649, CurrentID=0, Status='live', Symbol='Elp3', Aliases='Dmel_CG15433, CG15433, D-elp3, Dmel/ELP3, Dmel\\CG15433, Dmel\\ELP3, ELP3, HAT, dmHAG408, elp-3, elp3', description='Elongator complex protein 3', other_designations='CG15433-PA|Elp3-PA|elongator complex protein 3|elongator protein 3', map_location='24F2-24F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4444732, end_position_on_the_genomic_accession=4446765, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33650 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33650, CurrentID=0, Status='live', Symbol='MFS18', Aliases='Dmel_CG15438, BEST:CK02623, CG15438, CK02623, Dmel\\CG15438', description='Major Facilitator Superfamily Transporter 18', other_designations='CG15438-PA|MFS18-PA|major facilitator superfamily transporter 18', map_location='24F2-24F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4446670, end_position_on_the_genomic_accession=4448635, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33651 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33651, CurrentID=0, Status='live', Symbol='CG15439', Aliases='Dmel_ Dmel\\CG15439', description='CG15439 gene product from transcript CG15439-RA', other_designations='CG15439-PA|uncharacterized protein', map_location='24F3-24F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4449295, end_position_on_the_genomic_accession=4453038, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33652 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33652, CurrentID=0, Status='live', Symbol='CG15440', Aliases='Dmel_ Dmel\\CG15440, Secp43, cg15440', description='CG15440 gene product from transcript CG15440-RA', other_designations='CG15440-PA|uncharacterized protein', map_location='24F3-24F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4453169, end_position_on_the_genomic_accession=4454453, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33653 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33653, CurrentID=0, Status='live', Symbol='Gs1l', Aliases='Dmel_CG15441, 19864674, CG15441, Dmel\\CG15441, GS1l, gs1-like', description='GS1-like', other_designations='CG15441-PA|CG15441-PB|GS1-like protein|GS1like|Gs1l-PA|Gs1l-PB', map_location='24F3-24F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4455137, end_position_on_the_genomic_accession=4456807, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33654 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33654, CurrentID=0, Status='live', Symbol='RpL27A', Aliases='Dmel_CG15442, CG15442, Dmel\\CG15442, M, M(2)24F, M(2)24F-1, M(2)Z, M(2)z, M(2L)z, M[[z]], Mz, Rp L27Aa, RpL27Ab, RpL27a, RpL27a2, anon-EST:Posey257, l(2)24EFh, l(2)24Fb, rpL27a, RpL27A', description='Ribosomal protein L27A', other_designations='CG15442-PA|CG15442-PC|CG15442-PD|RpL27A-PA|RpL27A-PC|RpL27A-PD|minute|minute (2) 24F|ribosomal protein L27A|ribosomal protein L27a', map_location='2-12.9 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4457186, end_position_on_the_genomic_accession=4458364, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33655 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33655, CurrentID=0, Status='live', Symbol='CG15435', Aliases='Dmel_ Dmel\\CG15435', description='CG15435 gene product from transcript CG15435-RB', other_designations='CG15435-PA|CG15435-PB|uncharacterized protein', map_location='24F3-24F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4459729, end_position_on_the_genomic_accession=4461746, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33656 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33656, CurrentID=0, Status='live', Symbol='CG15443', Aliases='Dmel_ Dmel\\CG15443', description='CG15443 gene product from transcript CG15443-RB', other_designations='CG15443-PA|CG15443-PB|uncharacterized protein', map_location='24F3-24F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4461657, end_position_on_the_genomic_accession=4463447, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33657 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33657, CurrentID=0, Status='live', Symbol='CG15436', Aliases='Dmel_ Dmel\\CG15436', description='CG15436 gene product from transcript CG15436-RA', other_designations='CG15436-PA|uncharacterized protein', map_location='24F3-24F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4463611, end_position_on_the_genomic_accession=4465075, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33658 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33658, CurrentID=0, Status='live', Symbol='CG17840', Aliases='Dmel_ Dmel\\CG17840', description='CG17840 gene product from transcript CG17840-RA', other_designations='CG17840-PA|uncharacterized protein', map_location='24F4-24F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4465174, end_position_on_the_genomic_accession=4468022, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33659 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33659, CurrentID=0, Status='live', Symbol='ine', Aliases='Dmel_CG15444, CG15444, CG15444d, DMINE, Dmel\\CG15444/rosA, rosA, ine', description='inebriated', other_designations='CG15444-PA|CG15444-PB|CG15444-PC|CG15444-PE|CG15444-PF|ine-PA|ine-PB|ine-PC|ine-PE|ine-PF', map_location='2-12 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4468000, end_position_on_the_genomic_accession=4477022, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  33661 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33661, CurrentID=0, Status='live', Symbol='HP6', Aliases='Dmel_CG15636, CG15636, Dmel\\CG15636, UMB, UMBREA, Umbrea, umbrea', description='Heterochromatin protein 6', other_designations='CG15636-PA|HP6-PA|heterochromatin protein 6|umbrea', map_location='25A1-25A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4577719, end_position_on_the_genomic_accession=4578218, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33665 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33665, CurrentID=0, Status='live', Symbol='CG15635', Aliases='Dmel_ Dmel\\CG15635', description='CG15635 gene product from transcript CG15635-RB', other_designations='CG15635-PB|uncharacterized protein', map_location='25A2-25A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4642972, end_position_on_the_genomic_accession=4646562, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33667 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33667, CurrentID=0, Status='live', Symbol='CG3355', Aliases='Dmel_ Dmel\\CG3355, SP21', description='CG3355 gene product from transcript CG3355-RB', other_designations='CG3355-PA|CG3355-PB', map_location='25A2-25A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4651403, end_position_on_the_genomic_accession=4652892, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33668 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33668, CurrentID=0, Status='live', Symbol='CG11929', Aliases='Dmel_ Dmel\\CG11929', description='CG11929 gene product from transcript CG11929-RA', other_designations='CG11929-PA|CG11929-PB|uncharacterized protein', map_location='25A3-25A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4682677, end_position_on_the_genomic_accession=4687232, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33669 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33669, CurrentID=0, Status='live', Symbol='Bsg25A', Aliases='Dmel_CG12205, CG12205, Dmel\\CG12205, Elba, Elba1, anon-EST:Liang-1.70, bsg25A, clone 1.70', description='Blastoderm-specific gene 25A', other_designations='Bsg25A-PA|CG12205-PA|early boundary factor', map_location='25A3-25A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4683052, end_position_on_the_genomic_accession=4684461, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33670 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33670, CurrentID=0, Status='live', Symbol='Elba3', Aliases='Dmel_CG15634, CG15634, Dmel\\CG15634, Elba', description='Early boundary activity 3', other_designations='CG15634-PA|Elba3-PA|early boundary activity 3|early boundary factor', map_location='25A3-25A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4687511, end_position_on_the_genomic_accession=4688956, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33671 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33671, CurrentID=0, Status='live', Symbol='CG3251', Aliases='Dmel_ Dmel\\CG3251', description='CG3251 gene product from transcript CG3251-RA', other_designations='CG3251-PA', map_location='25A3-25A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4688965, end_position_on_the_genomic_accession=4690702, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33672 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33672, CurrentID=0, Status='live', Symbol='Taf12L', Aliases='Dmel_CG15632, CG15632, Dmel\\CG15632, Rye, TAF, TAF12L, TAF30alpha-2, TAF[[II]], TFIID, Taf30alpha-2, dTAF12, dTAF12L, dTAF[[II]]30a, dTAF[[II]]30alpha-2, dmTAF12L, dmTAF12b, rye', description='TBP-associated factor 30kD subunit alpha-2', other_designations='CG15632-PA|TBP-associated factor|TBP-associated factor subunit alpha-2|Taf12L-PA|ryan express', map_location='25A3-25A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4700835, end_position_on_the_genomic_accession=4701485, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33675 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33675, CurrentID=0, Status='live', Symbol='CG15631', Aliases='Dmel_ Dmel\\CG15631', description='CG15631 gene product from transcript CG15631-RB', other_designations='CG15631-PA|CG15631-PB|uncharacterized protein', map_location='25A4-25A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4732413, end_position_on_the_genomic_accession=4734458, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33676 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33676, CurrentID=0, Status='live', Symbol='CG15630', Aliases='Dmel_ 15630, CG31970, CT35785, Dmel\\CG15630', description='CG15630 gene product from transcript CG15630-RA', other_designations='CG15630-PA|uncharacterized protein', map_location='25A4-25A6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4734592, end_position_on_the_genomic_accession=4794044, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33677 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33677, CurrentID=0, Status='live', Symbol='CG3294', Aliases='Dmel_ Dmel\\CG3294, cg3294', description='CG3294 gene product from transcript CG3294-RB', other_designations='CG3294-PA|CG3294-PB', map_location='25A6-25A6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4794549, end_position_on_the_genomic_accession=4796581, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33678 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33678, CurrentID=0, Status='live', Symbol='Clect27', Aliases='Dmel_CG3244, CG3244, Dmel\\CG3244', description='C-type lectin 27kD', other_designations='CG3244-PA|CG3244-PB|Clect27-PA|Clect27-PB', map_location='25A6-25A6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4796600, end_position_on_the_genomic_accession=4801923, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33679 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33679, CurrentID=0, Status='live', Symbol='CG15629', Aliases='Dmel_ Dmel\\CG15629', description='CG15629 gene product from transcript CG15629-RA', other_designations='CG15629-PA|uncharacterized protein', map_location='25A6-25A6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4813009, end_position_on_the_genomic_accession=4815891, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33680 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33680, CurrentID=0, Status='live', Symbol='CG3225', Aliases='Dmel_ Dmel\\CG3225, cg3225', description='CG3225 gene product from transcript CG3225-RA', other_designations='CG3225-PA', map_location='25A6-25A7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4815613, end_position_on_the_genomic_accession=4818245, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33681 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33681, CurrentID=0, Status='live', Symbol='CG15628', Aliases='Dmel_ Dmel\\CG15628, anon-WO02059370.23', description='CG15628 gene product from transcript CG15628-RB', other_designations='CG15628-PA|CG15628-PB|uncharacterized protein', map_location='25A7-25A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4821774, end_position_on_the_genomic_accession=4828945, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33682 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33682, CurrentID=0, Status='live', Symbol='Fnta', Aliases='Dmel_CG2976, CG2976, Dmel\\CG2976, FNTA', description='Farnesyl transferase alpha', other_designations='CG2976-PA|CG2976-PB|Fnta-PA|Fnta-PB|farnesyl transferase alpha|farnesyl transferase alpha ortholog', map_location='25A8-25A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4829214, end_position_on_the_genomic_accession=4830693, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33683 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33683, CurrentID=0, Status='live', Symbol='Ir25a', Aliases='Dmel_CG15627, CG15627, CT35778, DmelIR25a, Dmel\\CG15627, IR25a', description='Ionotropic receptor 25a', other_designations='CG15627-PB|CG15627-PC|CG15627-PD|CG15627-PE|Ir25a-PB|Ir25a-PC|Ir25a-PD|Ir25a-PE|ionotropic receptor 25a', map_location='25A8-25A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4830846, end_position_on_the_genomic_accession=4835300, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33684 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33684, CurrentID=0, Status='live', Symbol='tank', Aliases='Dmel_CG15626, CG15626, Dmel\\CG15626', description='CG15626 gene product from transcript CG15626-RB', other_designations='CG15626-PA|CG15626-PB|tank-PA|tank-PB', map_location='25A8-25A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4835335, end_position_on_the_genomic_accession=4837999, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33685 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33685, CurrentID=0, Status='live', Symbol='CG12194', Aliases='Dmel_ Dmel\\CG12194, anon-EST:Posey105', description='CG12194 gene product from transcript CG12194-RA', other_designations='CG12194-PA|CG12194-PB|CG12194-PC|uncharacterized protein', map_location='25A8-25A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4838347, end_position_on_the_genomic_accession=4841465, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33686 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33686, CurrentID=0, Status='live', Symbol='mxt', Aliases='Dmel_CG2950, BcDNA:GH06479, CG2950, Dmel\\CG2950, cg2950', description='mextli', other_designations='CG2950-PA|CG2950-PB|CG2950-PC|CG2950-PD|CG2950-PE|CG2950-PF|CG2950-PG|mxt-PA|mxt-PB|mxt-PC|mxt-PD|mxt-PE|mxt-PF|mxt-PG', map_location='25A8-25B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4841482, end_position_on_the_genomic_accession=4847295, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  33687 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33687, CurrentID=0, Status='live', Symbol='CG11927', Aliases='Dmel_ Dmel\\CG11927', description='CG11927 gene product from transcript CG11927-RA', other_designations='CG11927-PA|uncharacterized protein', map_location='25B1-25B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4847766, end_position_on_the_genomic_accession=4849499, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33688 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33688, CurrentID=0, Status='live', Symbol='mRpS2', Aliases='Dmel_CG2937, CG2937, Dmel\\CG2937, MRP-S2', description='mitochondrial ribosomal protein S2', other_designations='CG2937-PA|mRpS2-PA', map_location='25B1-25B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4849439, end_position_on_the_genomic_accession=4850419, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33689 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33689, CurrentID=0, Status='live', Symbol='Mon1', Aliases='Dmel_CG11926, CG11926, Dmel\\CG11926, MON1, NP_608868', description='Mon1 ortholog', other_designations='CG11926-PA|Mon1-PA', map_location='25B1-25B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4850641, end_position_on_the_genomic_accession=4852640, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33690 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33690, CurrentID=0, Status='live', Symbol='pog', Aliases='Dmel_CG31660, CG11923, CG11925, CG31660, Dmel\\CG31660, anon-WO0170980.181, anon-WO0170980.182, pg', description='poor gastrulation', other_designations='CG31660-PB|CG31660-PC|CG31660-PD|CG31660-PE|CG31660-PF|pog-PB|pog-PC|pog-PD|pog-PE|pog-PF', map_location='25B1-25B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4852864, end_position_on_the_genomic_accession=4876792, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  33692 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33692, CurrentID=0, Status='live', Symbol='Cf2', Aliases='Dmel_CG11924, BcDNA:GM09668, CF2, CF2.5, CG11924, Dmel\\CG11924, cf2', description='Chorion factor 2', other_designations='CG11924-PA|CG11924-PB|CG11924-PC|CG11924-PE|CG11924-PF|Cf2-PA|Cf2-PB|Cf2-PC|Cf2-PE|Cf2-PF|chorion Factor-2|chorion factor 2', map_location='25B1-25B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4876891, end_position_on_the_genomic_accession=4883107, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33693 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33693, CurrentID=0, Status='live', Symbol='CG3008', Aliases='Dmel_ Dmel\\CG3008', description='CG3008 gene product from transcript CG3008-RA', other_designations='CG3008-PA', map_location='25B1-25B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4883298, end_position_on_the_genomic_accession=4885669, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33694 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33694, CurrentID=0, Status='live', Symbol='CG15625', Aliases='Dmel_ Dmel\\CG15625', description='CG15625 gene product from transcript CG15625-RA', other_designations='CG15625-PA|uncharacterized protein', map_location='25B1-25B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4889995, end_position_on_the_genomic_accession=4891277, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33695 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33695, CurrentID=0, Status='live', Symbol='CG3036', Aliases='Dmel_ 151989_at, CT10168, Dmel\\CG3036', description='CG3036 gene product from transcript CG3036-RA', other_designations='CG3036-PA|CG3036-PB', map_location='25B1-25B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4892112, end_position_on_the_genomic_accession=4903889, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33696 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33696, CurrentID=0, Status='live', Symbol='CG2837', Aliases='Dmel_ Dmel\\CG2837', description='CG2837 gene product from transcript CG2837-RC', other_designations='CG2837-PA|CG2837-PB|CG2837-PC|CG2837-PD', map_location='25B2-25B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4903865, end_position_on_the_genomic_accession=4906762, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33700 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33700, CurrentID=0, Status='live', Symbol='hoe2', Aliases='Dmel_CG15624, CG15624, Dmel\\CG15624', description='hoepel2', other_designations='CG15624-PA|hoe2-PA', map_location='25B4-25B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4933047, end_position_on_the_genomic_accession=4936450, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33701 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33701, CurrentID=0, Status='live', Symbol='Sgs1', Aliases='Dmel_CG3047, CG3047, Dmel\\CG3047, Muc25B, Sgs, Sgs-1, sgs-1, sgs1', description='Salivary gland secretion 1', other_designations='CG3047-PA|Sgs1-PA|mucin 25B|salivary gland protein 1|salivary gland secretion 1', map_location='2-13.9 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4937409, end_position_on_the_genomic_accession=4941423, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33702 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33702, CurrentID=0, Status='live', Symbol='CG14044', Aliases='Dmel_ Dmel\\CG14044', description='CG14044 gene product from transcript CG14044-RA', other_designations='CG14044-PA|uncharacterized protein', map_location='25B4-25B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4942742, end_position_on_the_genomic_accession=4944305, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33703 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33703, CurrentID=0, Status='live', Symbol='mRpL24', Aliases='Dmel_CG8849, CG8849, Dmel\\CG8849, L24, RpL24', description='mitochondrial ribosomal protein L24', other_designations='CG8849-PA|mRpL24-PA', map_location='25B4-25B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4944256, end_position_on_the_genomic_accession=4945361, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33704 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33704, CurrentID=0, Status='live', Symbol='betaggt-I', Aliases='Dmel_CG3469, CG3469, Dmel\\CG3469, GGT1, SR2-2, beta GGT-I, beta-GGT, betaGGT-I, betaGGTI, bro3, ggt-1, ggt1', description='beta subunit of type I geranylgeranyl transferase', other_designations='CG3469-PA|CG3469-PB|betaggt-I-PA|betaggt-I-PB|suppressor of Ras1 2-2|type I geranylgeranyl transferase', map_location='25B4-25B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4945579, end_position_on_the_genomic_accession=4948324, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33705 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33705, CurrentID=0, Status='live', Symbol='jet', Aliases='Dmel_CG8873, CG8873, Dmel\\CG8873, FBXL15, JET', description='jetlag', other_designations='CG8873-PA|CG8873-PB|jet-PA|jet-PB', map_location='25B4-25B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4948206, end_position_on_the_genomic_accession=4949784, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33706 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33706, CurrentID=0, Status='live', Symbol='Jon25Biii', Aliases='Dmel_CG8871, 25B, CG8871, Dmel\\CG8871, Jon25, Jon25B, SP177', description='Jonah 25Biii', other_designations='CG8871-PA|Jon25Biii-PA|jonah 25B|jonah 25Biii', map_location='25B4-25B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4949941, end_position_on_the_genomic_accession=4950767, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33707 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33707, CurrentID=0, Status='live', Symbol='Jon25Bii', Aliases='Dmel_CG8869, 25B, CG8869, Dmel\\CG8869, Jon25, Jon25B, SP112', description='Jonah 25Bii', other_designations='CG8869-PA|CG8869-PB|Jon25Bii-PA|Jon25Bii-PB|jonah 25B|jonah 25Bii', map_location='25B4-25B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4952243, end_position_on_the_genomic_accession=4953136, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33708 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33708, CurrentID=0, Status='live', Symbol='Jon25Bi', Aliases='Dmel_CG8867, 25B, CG8867, Dmel\\CG8867, Jon25, Jon25B, SP137, Ser4', description='Jonah 25Bi', other_designations='CG8867-PB|Jon25Bi-PB|jonah 25B|jonah 25Bi|serine protease 4', map_location='25B4-25B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4954279, end_position_on_the_genomic_accession=4955144, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33709 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33709, CurrentID=0, Status='live', Symbol='Marcal1', Aliases='Dmel_CG3753, CG3753, Dmel\\CG3753, HARP, Marca1, dmHARP', description='CG3753 gene product from transcript CG3753-RA', other_designations='CG3753-PA|Marcal1-PA|dsmarcal1|hepA-related protein', map_location='25B4-25B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4955509, end_position_on_the_genomic_accession=4958292, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33710 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33710, CurrentID=0, Status='live', Symbol='Trip1', Aliases='Dmel_CG8882, CG8882, DmTRIP, Dmel\\CG8882, eIF-3beta, eIF3-S2, eIF3i', description='CG8882 gene product from transcript CG8882-RA', other_designations='CG8882-PA|Trip1-PA', map_location='25B5-25B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4966367, end_position_on_the_genomic_accession=4967775, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33711 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33711, CurrentID=0, Status='live', Symbol='Scox', Aliases='Dmel_CG8885, CG8885, Dmel\\CG8885, SCO, SCO1, SCOX, dSco1, l(2)SH1783, l(2)SH2 1783, scox', description='Synthesis of cytochrome c oxidase', other_designations='CG8885-PA|SCO1 protein homolog|Scox-PA|lethal (2) SH1783|synthesis of cytochrome c oxidase', map_location='25B5-25B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4967832, end_position_on_the_genomic_accession=4968935, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33712 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33712, CurrentID=0, Status='live', Symbol='CG3756', Aliases='Dmel_ Dmel\\CG3756', description='CG3756 gene product from transcript CG3756-RA', other_designations='CG3756-PA', map_location='25B5-25B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4969004, end_position_on_the_genomic_accession=4970216, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33714 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33714, CurrentID=0, Status='live', Symbol='CG14043', Aliases='Dmel_ Dmel\\CG14043', description='CG14043 gene product from transcript CG14043-RA', other_designations='CG14043-PA|uncharacterized protein', map_location='25B5-25B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4971702, end_position_on_the_genomic_accession=4973687, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33715 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33715, CurrentID=0, Status='live', Symbol='mRpL28', Aliases='Dmel_CG3782, CG3782, Dmel\\CG3782, MRP-L28', description='mitochondrial ribosomal protein L28', other_designations='CG3782-PA|CG3782-PB|ecdysteroid regulated 16kd protein|mRpL28-PA|mRpL28-PB', map_location='25B5-25B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4973976, end_position_on_the_genomic_accession=4975316, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33716 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33716, CurrentID=0, Status='live', Symbol='Gmd', Aliases='Dmel_CG8890, Brazil nut, CG8890, Dm-gmd, DmGMD, Dmel\\CG8890, GMD, gmd, l(2)SH1606, l(2)SH2 1606', description='GDP-mannose 4,6-dehydratase', other_designations='CG8890-PA|GDP-D-mannose 4,6-dehydratase|GDP-mannose 4,6 dehydratase|GDP-mannose 4,6-dehydrase|GDP-mannose dehydratase|Gmd-PA', map_location='25B5-25B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4975300, end_position_on_the_genomic_accession=4977023, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33717 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33717, CurrentID=0, Status='live', Symbol='CG3792', Aliases='Dmel_ Dmel\\CG3792, anon-EST:Posey8', description='CG3792 gene product from transcript CG3792-RA', other_designations='CG3792-PA', map_location='25B5-25B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4977312, end_position_on_the_genomic_accession=4978567, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33718 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33718, CurrentID=0, Status='live', Symbol='CG8891', Aliases='Dmel_ Dmel\\CG8891', description='CG8891 gene product from transcript CG8891-RA', other_designations='CG8891-PA', map_location='25B5-25B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4978484, end_position_on_the_genomic_accession=4979379, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33719 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33719, CurrentID=0, Status='live', Symbol='CG8892', Aliases='Dmel_ Dmel\\CG8892', description='CG8892 gene product from transcript CG8892-RC', other_designations='CG8892-PB|CG8892-PC|CG8892-PD|CG8892-PE|UBX domain 7 like', map_location='25B5-25B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4979513, end_position_on_the_genomic_accession=4981592, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33721 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33721, CurrentID=0, Status='live', Symbol='Rtnl1', Aliases='Dmel_CG33113, 142893_at, CG18623, CG33113, CG8895, Dmel\\CG33113, G9, Retl1, Rtnl-1, rtnl1', description='Reticulon-like1', other_designations='CG33113-PA|CG33113-PB|CG33113-PC|CG33113-PD|CG33113-PE|CG33113-PF|CG33113-PG|CG33113-PH|CG33113-PI|CG33113-PJ|CG33113-PL|Reticulon-like 1|Rtnl1-PA|Rtnl1-PB|Rtnl1-PC|Rtnl1-PD|Rtnl1-PE|Rtnl1-PF|Rtnl1-PG|Rtnl1-PH|Rtnl1-PI|Rtnl1-PJ|Rtnl1-PL|reticulon|reticulon-like1', map_location='25B9-25C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=4992808, end_position_on_the_genomic_accession=5009720, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  33725 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33725, CurrentID=0, Status='live', Symbol='CG3887', Aliases='Dmel_ Dmel\\CG3887', description='CG3887 gene product from transcript CG3887-RC', other_designations='CG3887-PA|CG3887-PB|CG3887-PC', map_location='25C1-25C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5010922, end_position_on_the_genomic_accession=5012127, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33726 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33726, CurrentID=0, Status='live', Symbol='vkg', Aliases='Dmel_CG16858, 1209, 6072, CG16858, CT25584, Coll IValpha2, DmColA2, Dmel\\CG16858, Vkg, VkgC, alpha(IV)2/vkg, col4a2, coll-IV, coll. IV, collagen-IV, l(2)01209', description='viking', other_designations='CG16858-PA|CG16858-PB|CG16858-PC|collagen IV|collagen IV alpha2|collagenIV a2|type IV collagen|type IV collagen, alpha-chain|type IV collagenS|vkg-PA|vkg-PB|vkg-PC', map_location='25C1-25C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5012144, end_position_on_the_genomic_accession=5028191, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33727 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33727, CurrentID=0, Status='live', Symbol='Cg25C', Aliases='Dmel_CG4145, CG25C, CG4145, CT12803, Cgc25, Cgc25C, Col IV alpha(1), Coll, Coll IV, DCg1, Dcg, Dcg1, Dmel\\CG4145, alpha(IV)1/Cg25C, alpha1, cg25C, cg25c, col4a1, gp125', description='Collagen type IV', other_designations='CG4145-PA|CG4145-PB|CG4145-PC|Cg25C-PA|Cg25C-PB|Cg25C-PC|collagen|collagen IV|collagen type IV|collagenIV a1|laminin alpha3,5|preprocollagen alpha1(IV)|type IV collagen|type IV collagen, alpha-chain', map_location='25C1-25C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5029609, end_position_on_the_genomic_accession=5037279, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  246600 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=246600, CurrentID=0, Status='live', Symbol='CG30411', Aliases='Dmel_ BcDNA:RE06996, Dmel\\CG30411', description='CG30411 gene product from transcript CG30411-RA', other_designations='CG30411-PA|uncharacterized protein', map_location='59D11-59D11', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=23415939, end_position_on_the_genomic_accession=23417238, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33732 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33732, CurrentID=0, Status='live', Symbol='CG9121', Aliases='Dmel_ Dmel\\CG9121', description='CG9121 gene product from transcript CG9121-RD', other_designations='CG9121-PA|CG9121-PB|CG9121-PC|CG9121-PD', map_location='25C1-25C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5047818, end_position_on_the_genomic_accession=5051062, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33734 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33734, CurrentID=0, Status='live', Symbol='CG14040', Aliases='Dmel_ Dmel\\CG14040', description='CG14040 gene product from transcript CG14040-RA', other_designations='CG14040-PA|uncharacterized protein', map_location='25C3-25C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5052843, end_position_on_the_genomic_accession=5054575, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33735 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33735, CurrentID=0, Status='live', Symbol='CG14036', Aliases='Dmel_ Dmel\\CG14036', description='CG14036 gene product from transcript CG14036-RA', other_designations='CG14036-PA|uncharacterized protein', map_location='25C3-25C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5054579, end_position_on_the_genomic_accession=5055016, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33736 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33736, CurrentID=0, Status='live', Symbol='His3.3A', Aliases='Dmel_CG5825, CG5825, Dmel\\CG5825, H3.3, H3.3A, His-3.3A, His3.3, PH3, dH3.3A', description='Histone H3.3A', other_designations='CG5825-PA|CG5825-PC|CG5825-PD|H3L-like histone|His3.3A-PA|His3.3A-PC|His3.3A-PD|histone H3.3|histone H3.3 variant|histone H3.3A|histone variant 3.3|histone variant H3.3', map_location='25C3-25C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5055058, end_position_on_the_genomic_accession=5056149, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33738 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33738, CurrentID=0, Status='live', Symbol='Rpn11', Aliases='Dmel_CG18174, 37B, CG18174, DmS13, Dmel\\CG18174, Q9V3H2, RPN11, RPn11, S13, p37B, rpn11, yip5', description='Regulatory particle non-ATPase 11', other_designations='CG18174-PA|Rpn11-PA|regulatory particle non-ATPase 11|yippee interacting protein 5', map_location='25C3-25C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5058404, end_position_on_the_genomic_accession=5059790, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33739 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33739, CurrentID=0, Status='live', Symbol='qtc', Aliases='Dmel_CG14039, CG14039, Dmel\\CG14039', description='quick-to-court', other_designations='CG14039-PA|CG14039-PB|CG14039-PE|CG14039-PF|CG14039-PG|CG14039-PH|CG14039-PI|CG14039-PJ|CG14039-PK|CG14039-PL|CG14039-PM|CG14039-PN|qtc-PA|qtc-PB|qtc-PE|qtc-PF|qtc-PG|qtc-PH|qtc-PI|qtc-PJ|qtc-PK|qtc-PL|qtc-PM|qtc-PN', map_location='25C3-25C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5060815, end_position_on_the_genomic_accession=5070750, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  33742 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33742, CurrentID=0, Status='live', Symbol='CG5828', Aliases='Dmel_ Dmel\\CG5828', description='CG5828 gene product from transcript CG5828-RB', other_designations='CG5828-PA|CG5828-PB', map_location='25C6-25C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5093976, end_position_on_the_genomic_accession=5095910, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33743 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33743, CurrentID=0, Status='live', Symbol='CG4230', Aliases='Dmel_ Dmel\\CG4230', description='CG4230 gene product from transcript CG4230-RA', other_designations='CG4230-PA|CG4230-PB|CG4230-PC', map_location='25C6-25C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5096227, end_position_on_the_genomic_accession=5099294, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33744 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33744, CurrentID=0, Status='live', Symbol='ND-13A', Aliases='Dmel_CG8680, CG8680, Dmel\\CG8680, NUMM', description='NADH dehydrogenase (ubiquinone) 13 kDa A subunit', other_designations='CG8680-PA|CG8680-PB|CG8680-PC|NADH ubiquinone oxidoreductase 13 kDa A|NADH-ubiquinone oxidoreductase 13 kDa-A subunit|NADH:ubiquinone oxidoreductase 13 kDa A subunit|ND-13A-PA|ND-13A-PB|ND-13A-PC', map_location='25C6-25C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5099177, end_position_on_the_genomic_accession=5100288, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33748 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33748, CurrentID=0, Status='live', Symbol='Cyp28d2', Aliases='Dmel_CG6081, 28d2, CG6081, Dmel\\CG6081', description='CG6081 gene product from transcript CG6081-RA', other_designations='CG6081-PA|Cyp28d2-PA|cytochrome P450', map_location='25C10-25C10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5207267, end_position_on_the_genomic_accession=5209345, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33749 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33749, CurrentID=0, Status='live', Symbol='Cyp28d1', Aliases='Dmel_CG10833, 28d1, CG10833, Dmel\\CG10833', description='CG10833 gene product from transcript CG10833-RA', other_designations='CG10833-PA|Cyp28d1-PA|cytochrome P450', map_location='25C10-25C10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5210460, end_position_on_the_genomic_accession=5212445, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33750 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33750, CurrentID=0, Status='live', Symbol='CG7742', Aliases='Dmel_ Dmel\\CG7742', description='CG7742 gene product from transcript CG7742-RD', other_designations='CG7742-PA|CG7742-PB|CG7742-PC|CG7742-PD', map_location='25C10-25D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5212395, end_position_on_the_genomic_accession=5215081, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33751 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33751, CurrentID=0, Status='live', Symbol='CG14034', Aliases='Dmel_ Dmel\\CG14034, anon-SAGE:Wang-122', description='CG14034 gene product from transcript CG14034-RC', other_designations='CG14034-PB|CG14034-PC|anon-SAGE:Wang-122|uncharacterized protein', map_location='25D1-25D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5215189, end_position_on_the_genomic_accession=5216542, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33752 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33752, CurrentID=0, Status='live', Symbol='TpnC25D', Aliases='Dmel_CG6514, BcDNA:RE53289, CG6514, DmTpnC25D, DmTpnCII, Dmel\\CG6514, TNC25D, TnC, TpnC II, TpnCII, anon-EST:Posey103', description='Troponin C at 25D', other_designations='CG6514-PA|CG6514-PB|CG6514-PC|TpnC25D-PA|TpnC25D-PB|TpnC25D-PC|troponin C at 25D', map_location='25D1-25D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5216701, end_position_on_the_genomic_accession=5219053, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33753 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33753, CurrentID=0, Status='live', Symbol='tkv', Aliases='Dmel_CG14026, Atkv, Atr25D, Brk25D, Brk25D1, Brk25D2, CG14026, Dmel\\CG14026, Dtfr, STK-A, TKV, TKV1, Tkv, dtfr, kv, l(2)04415, l(2)25Da, str1, tkva, tkv', description='thickveins', other_designations='Activin-A-receptor-25D|BMP receptor kinase 25D|CG14026-PA|CG14026-PB|CG14026-PC|CG14026-PD|DPP receptor|Thick-vein|Thick-veins|slater|thick veins|thickvein|tkv-PA|tkv-PB|tkv-PC|tkv-PD', map_location='2-16 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5219000, end_position_on_the_genomic_accession=5271384, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33754 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33754, CurrentID=0, Status='live', Symbol='Cyp4ac1', Aliases='Dmel_CG14032, 4ac1, CG14032, Dmel\\CG14032, cyp4ac1', description='CG14032 gene product from transcript CG14032-RA', other_designations='CG14032-PA|Cyp4ac1-PA', map_location='25D2-25D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5264001, end_position_on_the_genomic_accession=5265899, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33755 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33755, CurrentID=0, Status='live', Symbol='Cyp4ac2', Aliases='Dmel_CG17970, 4ac2, CG17970, Dmel\\CG17970', description='CG17970 gene product from transcript CG17970-RB', other_designations='CG17970-PB|Cyp4ac2-PB|cytochrome P450', map_location='25D2-25D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5266392, end_position_on_the_genomic_accession=5268455, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33756 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33756, CurrentID=0, Status='live', Symbol='Cyp4ac3', Aliases='Dmel_CG14031, 4ac3, CG14031, Dmel\\CG14031', description='CG14031 gene product from transcript CG14031-RA', other_designations='CG14031-PA|Cyp4ac3-PA|cytochrome P450', map_location='25D2-25D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5268498, end_position_on_the_genomic_accession=5270329, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33757 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33757, CurrentID=0, Status='live', Symbol='Bsg25D', Aliases='Dmel_CG14025, CG14025, Dmel\\CG14025, brg25D, bsg25D, bsq25D', description='Blastoderm-specific gene 25D', other_designations='Bsg25D-PB|Bsg25D-PC|Bsg25D-PD|Bsg25D-PE|Bsg25D-PF|Bsg25D-PG|Bsg25D-PH|CG14025-PB|CG14025-PC|CG14025-PD|CG14025-PE|CG14025-PF|CG14025-PG|CG14025-PH', map_location='25D2-25D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5271728, end_position_on_the_genomic_accession=5278548, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  33758 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33758, CurrentID=0, Status='live', Symbol='Bub1', Aliases='Dmel_CG14030, BUB1, BUB1-like, BubR1, BubRI, CG14030, CG14030/Bub1, Dmel\\CG14030, bub1', description='Bub1 homologue', other_designations='Bub1-PA|Bub1-PB|Bub1-PC|CG14030-PA|CG14030-PB|CG14030-PC', map_location='25D3-25D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5278865, end_position_on_the_genomic_accession=5283283, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33759 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33759, CurrentID=0, Status='live', Symbol='vri', Aliases='Dmel_CG14029, CG14029, DM16, Dmel\\CG14029, VRI, Vri, argo, jf23, l(2)25Db, l(2)jf23, mat(2)ea-G, mat(2)earlyRS32, mel_vri', description='vrille', other_designations='CG14029-PA|CG14029-PC|CG14029-PD|CG14029-PE|CG14029-PF|VRILLE|lethal(2)25Db|maternal effect early arrest G|vri-PA|vri-PC|vri-PD|vri-PE|vri-PF', map_location='2-17 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5288944, end_position_on_the_genomic_accession=5311223, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33760 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33760, CurrentID=0, Status='live', Symbol='CG14024', Aliases='Dmel_ Dmel\\CG14024, d4ST1', description='CG14024 gene product from transcript CG14024-RB', other_designations='CG14024-PA|CG14024-PB|uncharacterized protein', map_location='25D5-25D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5311311, end_position_on_the_genomic_accession=5314895, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33761 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33761, CurrentID=0, Status='live', Symbol='Ncoa6', Aliases='Dmel_CG14023, CG14023, Dmel\\CG14023, NCOA6, dNCOA6', description='Nuclear receptor coactivator 6', other_designations='CG14023-PC|CG14023-PD|CG14023-PF|Ncoa6-PC|Ncoa6-PD|Ncoa6-PF|nuclear receptor coactivator 6', map_location='25D5-25D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5315290, end_position_on_the_genomic_accession=5326683, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33763 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33763, CurrentID=0, Status='live', Symbol='CG14022', Aliases='Dmel_ BcDNA:RH62365, Dmel\\CG14022', description='CG14022 gene product from transcript CG14022-RA', other_designations='CG14022-PA|CG14022-PB|uncharacterized protein', map_location='25D6-25D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5327975, end_position_on_the_genomic_accession=5328879, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33764 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33764, CurrentID=0, Status='live', Symbol='TotM', Aliases='Dmel_CG14027, CG14027, Dmel\\CG14027, TOTM, Tot M, tot, totM', description='Turandot M', other_designations='CG14027-PA|CG14027-PB|TotM-PA|TotM-PB|turandot|turandot M', map_location='25D6-25D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5329857, end_position_on_the_genomic_accession=5330464, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33765 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33765, CurrentID=0, Status='live', Symbol='fusl', Aliases='Dmel_CG14021, CG14021, Dmel\\CG14021', description='fuseless', other_designations='CG14021-PA|CG14021-PB|CG14021-PC|CG14021-PD|CG14021-PE|CG14021-PF|fusl-PA|fusl-PB|fusl-PC|fusl-PD|fusl-PE|fusl-PF', map_location='25D6-25D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5330470, end_position_on_the_genomic_accession=5338073, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33766 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33766, CurrentID=0, Status='live', Symbol='CG12512', Aliases='Dmel_ Dmel\\CG12512', description='CG12512 gene product from transcript CG12512-RA', other_designations='CG12512-PA|uncharacterized protein', map_location='25D6-25D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5339132, end_position_on_the_genomic_accession=5342234, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33768 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33768, CurrentID=0, Status='live', Symbol='nompC', Aliases='Dmel_CG11020, CG11020, CG17468, CT30855, DmNompC, Dmel\\CG11020, NOMPC, NompC, ORE-13, TRPN, TRPN1, jf24, l(2)25Dc, l(2)jf24, nomp', description='no mechanoreceptor potential C', other_designations='CG11020-PD|CG11020-PE|CG11020-PF|CG11020-PG|CG11020-PH|No Mechano-receptor potential C|No mechanoreceptor potential C|lethal(2)25Dc|nompC-PD|nompC-PE|nompC-PF|nompC-PG|nompC-PH', map_location='25D6-25D7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5346200, end_position_on_the_genomic_accession=5365760, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  33769 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33769, CurrentID=0, Status='live', Symbol='H15', Aliases='Dmel_CG6604, CG6604, Dm- Dmel\\CG6604, Nmr, Nmr-1, Tbx20, dm-H15, nmr, nmr1, nmr[H15]', description='CG6604 gene product from transcript CG6604-RA', other_designations='CG6604-PA|CG6604-PB|H15-PA|H15-PB|neuromancer|neuromancer 1|neuromancer 2|neuromancer-1|neuromancer1', map_location='25E1-25E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5404280, end_position_on_the_genomic_accession=5416593, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33770 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33770, CurrentID=0, Status='live', Symbol='mid', Aliases='Dmel_CG6634, CG6634, Dmel\\CG6634, H15r, H15r/nmr2, Mid(H15), TBX20, extra, los, nmr2', description='midline', other_designations='CG6634-PA|CG6634-PB|H15-related|extra|lost in space|mid-PA|mid-PB|neuromancer 1|neuromancer 2|neuromancer2', map_location='2-16 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5461639, end_position_on_the_genomic_accession=5467610, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33771 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33771, CurrentID=0, Status='live', Symbol='CG14020', Aliases='Dmel_ Dmel\\CG14020', description='CG14020 gene product from transcript CG14020-RA', other_designations='CG14020-PA|CG14020-PB|uncharacterized protein', map_location='25E5-25E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5517737, end_position_on_the_genomic_accession=5518949, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33772 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33772, CurrentID=0, Status='live', Symbol='CG7382', Aliases='Dmel_ Dmel\\CG7382', description='CG7382 gene product from transcript CG7382-RA', other_designations='CG7382-PA', map_location='25E5-25E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5518893, end_position_on_the_genomic_accession=5519896, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33774 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33774, CurrentID=0, Status='live', Symbol='Vps52', Aliases='Dmel_CG7371, CG7371, Dmel\\CG7371', description='Vacuolar protein sorting 52', other_designations='CG7371-PA|Vps52-PA|vacuolar protein sorting 52', map_location='25E5-25E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5521281, end_position_on_the_genomic_accession=5523898, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33775 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33775, CurrentID=0, Status='live', Symbol='CG6907', Aliases='Dmel_ Dmel\\CG6907', description='CG6907 gene product from transcript CG6907-RA', other_designations='CG6907-PA|CG6907-PB', map_location='25E5-25E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5524139, end_position_on_the_genomic_accession=5525809, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33776 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33776, CurrentID=0, Status='live', Symbol='CG31648', Aliases='Dmel_ CG6922, COXZ, Dmel\\CG31648', description='CG31648 gene product from transcript CG31648-RA', other_designations='CG31648-PA|complex IV assembly protein COX11|cytochrome c oxidase assembly protein COX11|uncharacterized protein', map_location='25E5-25E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5526957, end_position_on_the_genomic_accession=5527854, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33777 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33777, CurrentID=0, Status='live', Symbol='CG7277', Aliases='Dmel_ Dmel\\CG7277', description='CG7277 gene product from transcript CG7277-RA', other_designations='CG7277-PA', map_location='25E5-25E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5530620, end_position_on_the_genomic_accession=5532223, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33778 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33778, CurrentID=0, Status='live', Symbol='Cap-D3', Aliases='Dmel_CG31989, BcDNA:RE74832, CAP-D2, CAP-D3, CG14019, CG31989, CG6922, CapD3, Dmel\\CG31989, cap-D3, dCap-D3', description='Chromosome associated protein D3', other_designations='CG31989-PA|CG31989-PB|Cap-D3-PA|Cap-D3-PB|chromosome associated protein D3', map_location='25E5-25E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5525905, end_position_on_the_genomic_accession=5535958, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33779 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33779, CurrentID=0, Status='live', Symbol='tomb', Aliases='Dmel_CG14016, CG14016, Dmel\\CG14016, Tomb', description='tombola', other_designations='CG14016-PA|tomb-PA', map_location='25E5-25E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5535861, end_position_on_the_genomic_accession=5536758, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33780 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33780, CurrentID=0, Status='live', Symbol='CG14015', Aliases='Dmel_ Dmel\\CG14015', description='CG14015 gene product from transcript CG14015-RA', other_designations='CG14015-PA|uncharacterized protein', map_location='25E5-25E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5536850, end_position_on_the_genomic_accession=5539196, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33781 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33781, CurrentID=0, Status='live', Symbol='Hel25E', Aliases='Dmel_CG7269, CG7269, Dbp25F, DmRH4, Dmel\\CG7269, HEL, Hel, UAP56, WM6, Wm6, hel, jf26, l(2)25Eb, l(2)gdh-12, l(2)gdh12, l(2)jf26, l(2)k11511, sz, uap56', description='Helicase at 25E', other_designations='CG7269-PA|CG7269-PB|CG7269-PC|CG7269-PD|Hel25E-PA|Hel25E-PB|Hel25E-PC|Hel25E-PD|RNA helicase|helicase|helicase at 25E|lethal(2)25Eb', map_location='25E6-25E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5539326, end_position_on_the_genomic_accession=5542314, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33782 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33782, CurrentID=0, Status='live', Symbol='Lam', Aliases='Dmel_CG6944, 2459, 74/76, CG6944, D5, DM[[O]], D[[m0]], Dm, Dm(0), Dm0, Dm1, Dm2, DmLamin, DmO, Dm[[0]], Dm[[1]], Dm[[2]], Dm[[mit]], Dm[[o]], Dmel\\CG6944, Dmo, LAM Dm[[0]], Lam(Dm0), LamDm, LamDm0, LamDm[[0]], LamDm[[o]], Lam[[Dm0]], Lamin B, Lamin Dm[[0]], jf27, l(2)04643, l(2)25Ec, l(2)gdh-7, l(2)gdh7, l(2)jf27, lam, lamDm0, lamDm[[0]], lamin, lamin B, lamin Dm0, lamin Dm[[0]], misg, nlam, Lam', description='Lamin', other_designations='B-type lamin|CG6944-PA|CG6944-PB|CG6944-PC|CG6944-PD|Lam-PA|Lam-PB|Lam-PC|Lam-PD|Lamin-B|LaminDm|LaminDm0|alpha-Lamin|intermediate filament-like lamina|lamin|lamin A|lamin B|lamin D|lamin D[[0]]|lamin D[[m0]]|lamin D[[m]]0|lamin D[[o]]|lamin Dm|lamin Dm0|lamin Dm[[0]]|lamin Dmo|lethal(2)25Ec|misguided|misrouted|n-lamin|nuclear lamin', map_location='25E6-25E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5542480, end_position_on_the_genomic_accession=5546642, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33783 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33783, CurrentID=0, Status='live', Symbol='Oscillin', Aliases='Dmel_CG6957, CG6957, Dmel\\CG6957', description='CG6957 gene product from transcript CG6957-RC', other_designations='CG6957-PA|CG6957-PB|CG6957-PC|CG6957-PD|CG6957-PE|CG6957-PF|CG6957-PG|CG6957-PH|Oscillin-PA|Oscillin-PB|Oscillin-PC|Oscillin-PD|Oscillin-PE|Oscillin-PF|Oscillin-PG|Oscillin-PH|oscillin', map_location='25E6-25E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5547086, end_position_on_the_genomic_accession=5549614, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  33784 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33784, CurrentID=0, Status='live', Symbol='CG14014', Aliases='Dmel_ Dmel\\CG14014', description='CG14014 gene product from transcript CG14014-RB', other_designations='CG14014-PB|uncharacterized protein', map_location='25E6-25E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5549709, end_position_on_the_genomic_accession=5550835, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33785 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33785, CurrentID=0, Status='live', Symbol='CG18269', Aliases='Dmel_ Dmel\\CG18269', description='CG18269 gene product from transcript CG18269-RA', other_designations='CG18269-PA|uncharacterized protein', map_location='25E6-25E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5551838, end_position_on_the_genomic_accession=5552756, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33786 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33786, CurrentID=0, Status='live', Symbol='CG14013', Aliases='Dmel_ Dmel\\CG14013', description='CG14013 gene product from transcript CG14013-RA', other_designations='CG14013-PA|uncharacterized protein', map_location='25E6-25E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5552843, end_position_on_the_genomic_accession=5553850, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33787 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33787, CurrentID=0, Status='live', Symbol='CG14017', Aliases='Dmel_ Dmel\\CG14017', description='CG14017 gene product from transcript CG14017-RA', other_designations='CG14017-PA|uncharacterized protein', map_location='25E6-25E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5553897, end_position_on_the_genomic_accession=5555137, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33788 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33788, CurrentID=0, Status='live', Symbol='GluRIIA', Aliases='Dmel_CG6992, CG6992, D-GluRIIA, DGluR-II, DGluR-IIA, DGluR2a, DGluRIIA, DGluRIIa, DgluRII, DmelGluRIIA, Dmel\\CG6992, Glu-RII, Glu-RIIA, GluR, GluR-IIA, GluR2, GluR2a, GluRII, GluRII-A, GluRIIa, GluR[[IIa]], GlurIIA, dGluRII, dGluRIIA, dglur-IIA, dglurIIA, gluRIIA, glurIIA, gluriia', description='Glutamate receptor IIA', other_designations='CG6992-PI|GluRIIA-PI|glutamate IIA receptor|glutamate receptor|glutamate receptor IIA|glutamate receptor subunit IIA', map_location='25E6-25E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5555072, end_position_on_the_genomic_accession=5558994, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  33789 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33789, CurrentID=0, Status='live', Symbol='GluRIIB', Aliases='Dmel_CG7234, CG7234, DGluIIB, DGluR-IIB, DGluRIIB, DmelGluRIIB, Dmel\\CG7234, Glu-RIIB, GluRIIb, dGluRIIB, dglurIIB, glurIIB', description='Glutamate receptor IIB', other_designations='CG7234-PI|GluRIIB-PI|glutamate receptor|glutamate receptor IIB', map_location='25E6-25E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5559342, end_position_on_the_genomic_accession=5563502, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  33790 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33790, CurrentID=0, Status='live', Symbol='CG14011', Aliases='Dmel_ Dmel\\CG14011', description='CG14011 gene product from transcript CG14011-RC', other_designations='CG14011-PA|CG14011-PB|CG14011-PC|uncharacterized protein', map_location='25F1-25F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5579580, end_position_on_the_genomic_accession=5581116, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33791 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33791, CurrentID=0, Status='live', Symbol='CG7251', Aliases='Dmel_ Dmel\\CG7251, anon-WO0140519.103, bs11h10.y1', description='CG7251 gene product from transcript CG7251-RB', other_designations='CG7251-PA|CG7251-PB', map_location='25F1-25F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5587115, end_position_on_the_genomic_accession=5588414, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33792 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33792, CurrentID=0, Status='live', Symbol='CG18266', Aliases='Dmel_ Dmel\\CG18266, anon-WO0140519.54', description='CG18266 gene product from transcript CG18266-RA', other_designations='CG18266-PA|uncharacterized protein', map_location='25F1-25F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5596833, end_position_on_the_genomic_accession=5598636, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33793 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33793, CurrentID=0, Status='live', Symbol='DIP-eta', Aliases='Dmel_CG14010, 14010, CG14010, CT33567, Dmel\\CG14010', description='Dpr-interacting protein eta', other_designations='CG14010-PB|CG14010-PD|DIP-eta-PB|DIP-eta-PD', map_location='25F1-25F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5601723, end_position_on_the_genomic_accession=5617946, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  33795 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33795, CurrentID=0, Status='live', Symbol='DIP-theta', Aliases='Dmel_CG31646, 31646, CG14008, CG14009, CG31646, CT33566, Dmel\\CG31646', description='Dpr-interacting protein theta', other_designations='CG31646-PA|DIP-theta-PA', map_location='25F1-25F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5626291, end_position_on_the_genomic_accession=5658560, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  33796 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33796, CurrentID=0, Status='live', Symbol='Hsp60C', Aliases='Dmel_CG7235, A4V087_DROME, CG7235, Dmel\\CG7235, bs36d10.y1', description='CG7235 gene product from transcript CG7235-RA', other_designations='CG7235-PA|CG7235-PB|CG7235-PC|Hsp60C-PA|Hsp60C-PB|Hsp60C-PC', map_location='25F2-25F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5662849, end_position_on_the_genomic_accession=5670838, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33797 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33797, CurrentID=0, Status='live', Symbol='CG12511', Aliases='Dmel_ Dmel\\CG12511', description='CG12511 gene product from transcript CG12511-RD', other_designations='CG12511-PB|CG12511-PC|CG12511-PD|uncharacterized protein', map_location='25F2-25F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5678582, end_position_on_the_genomic_accession=5679499, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33798 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33798, CurrentID=0, Status='live', Symbol='CG7236', Aliases='Dmel_CG7236, AC018104/Cdk1l, Dmel\\CG7236, KKIALRE', description='CG7236 gene product from transcript CG7236-RE', other_designations='CG7236-PB|CG7236-PC|CG7236-PD|CG7236-PE', map_location='25F3-25F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5706374, end_position_on_the_genomic_accession=5713791, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33799 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33799, CurrentID=0, Status='live', Symbol='CG14007', Aliases='Dmel_ Dmel\\CG14007', description='CG14007 gene product from transcript CG14007-RC', other_designations='CG14007-PC|uncharacterized protein', map_location='25F3-25F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5715349, end_position_on_the_genomic_accession=5716680, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33800 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33800, CurrentID=0, Status='live', Symbol='CG11149', Aliases='Dmel_ Dmel\\CG11149, dibeta3GnT4', description='CG11149 gene product from transcript CG11149-RD', other_designations='CG11149-PA|CG11149-PB|CG11149-PC|CG11149-PD|CG11149-PE|uncharacterized protein', map_location='25F3-25F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5718121, end_position_on_the_genomic_accession=5720899, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33802 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33802, CurrentID=0, Status='live', Symbol='CG14006', Aliases='Dmel_ Dmel\\CG14006', description='CG14006 gene product from transcript CG14006-RB', other_designations='CG14006-PA|CG14006-PB|uncharacterized protein', map_location='25F4-25F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5726415, end_position_on_the_genomic_accession=5728811, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33803 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33803, CurrentID=0, Status='live', Symbol='CG11147', Aliases='Dmel_ Dmel\\CG11147', description='CG11147 gene product from transcript CG11147-RA', other_designations='CG11147-PA|CG11147-PB|uncharacterized protein', map_location='25F4-25F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5733675, end_position_on_the_genomic_accession=5741244, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  33804 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33804, CurrentID=0, Status='live', Symbol='CG11029', Aliases='Dmel_ Dmel\\CG11029', description='CG11029 gene product from transcript CG11029-RA', other_designations='CG11029-PA|uncharacterized protein', map_location='25F4-25F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5746157, end_position_on_the_genomic_accession=5747961, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33805 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33805, CurrentID=0, Status='live', Symbol='CG11030', Aliases='Dmel_ Dmel\\CG11030', description='CG11030 gene product from transcript CG11030-RB', other_designations='CG11030-PA|CG11030-PB|uncharacterized protein', map_location='25F3-25F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5724656, end_position_on_the_genomic_accession=5762420, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33806 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33806, CurrentID=0, Status='live', Symbol='obst-E', Aliases='Dmel_CG11142, CG11142, Dmel\\CG11142, Obst-E', description='obstructor-E', other_designations='CG11142-PA|CG11142-PB|obst-E-PA|obst-E-PB', map_location='25F4-25F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5762553, end_position_on_the_genomic_accession=5766142, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33807 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33807, CurrentID=0, Status='live', Symbol='CG9171', Aliases='Dmel_ Dmel\\CG9171, dibeta3GnT2', description='CG9171 gene product from transcript CG9171-RD', other_designations='CG9171-PC|CG9171-PD|CG9171-PE|CG9171-PF|CG9171-PG', map_location='25F4-25F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5767002, end_position_on_the_genomic_accession=5800253, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33808 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33808, CurrentID=0, Status='live', Symbol='CG14005', Aliases='Dmel_ Dmel\\CG14005', description='CG14005 gene product from transcript CG14005-RB', other_designations='CG14005-PA|CG14005-PB|uncharacterized protein', map_location='25F5-25F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5800517, end_position_on_the_genomic_accession=5801975, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33809 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33809, CurrentID=0, Status='live', Symbol='CG7239', Aliases='Dmel_ Dmel\\CG7239, anon-EST:Posey250', description='CG7239 gene product from transcript CG7239-RA', other_designations='CG7239-PA', map_location='25F5-25F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5802220, end_position_on_the_genomic_accession=5804030, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33810 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33810, CurrentID=0, Status='live', Symbol='CG11034', Aliases='Dmel_ Dmel\\CG11034', description='CG11034 gene product from transcript CG11034-RC', other_designations='CG11034-PB|CG11034-PC|CG11034-PD|uncharacterized protein', map_location='25F5-25F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5805395, end_position_on_the_genomic_accession=5809063, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33812 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33812, CurrentID=0, Status='live', Symbol='TrissinR', Aliases='Dmel_CG34381, CG14002, CG14003, CG14004, CG31645, CG34381, Dmel\\CG34381, Dmel_CG14004, Dmel_CG31645, anon-WO0170980.172, anon-WO0170980.173', description='Trissin receptor', other_designations='CG34381-PB|CG34381-PC|CG34381-PD|CG34381-PE|TrissinR-PB|TrissinR-PC|TrissinR-PD|TrissinR-PE|trissin receptor', map_location='25F5-26A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5824004, end_position_on_the_genomic_accession=5856767, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  246630 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=246630, CurrentID=0, Status='live', Symbol='Ir52c', Aliases='Dmel_CG30468, CG12961, CG30468, DmelIR52c, Dmel\\CG30468, IR52c', description='Ionotropic receptor 52c', other_designations='CG30468-PA|Ir52c-PA|ionotropic receptor 52c', map_location='52A6-52A6', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=15504201, end_position_on_the_genomic_accession=15506000, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33814 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33814, CurrentID=0, Status='live', Symbol='rau', Aliases='Dmel_CG8965, CG8965, Dmel\\CG8965', description='CG8965 gene product from transcript CG8965-RA', other_designations='CG8965-PA|CG8965-PB|rau-PA|rau-PB', map_location='26A1-26A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5859769, end_position_on_the_genomic_accession=5879498, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33815 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33815, CurrentID=0, Status='live', Symbol='CG9029', Aliases='Dmel_ Dmel\\CG9029', description='CG9029 gene product from transcript CG9029-RB', other_designations='CG9029-PA|CG9029-PB', map_location='26A1-26A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5886002, end_position_on_the_genomic_accession=5886609, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33816 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33816, CurrentID=0, Status='live', Symbol='Acp26Ab', Aliases='Dmel_CG9024, Acp, Acp26A, Acp26Aab, Acp26a, CG9024, Dmel\\CG9024, Mst26A, Mst26Ab, acp26Ab, msP355b, mst 355b, mst355b', description='Accessory gland protein 26Ab', other_designations='Acp26Ab-PA|Acp26Ab-PB|Acp26Ab-PC|CG9024-PA|CG9024-PB|CG9024-PC|accessory gland protein 26Ab|accessory gland-specific peptide 26Ab|accessory protein 26A', map_location='26A1-26A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5892298, end_position_on_the_genomic_accession=5892862, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33817 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33817, CurrentID=0, Status='live', Symbol='Acp26Aa', Aliases='Dmel_CG8982, Acp, Acp26Ab, Acp26a, CG8982, Dmel\\CG8982, Mst26A, Mst26Aa, Ovulin, msP355a, mst 355a, mst355a, ovulin, Acp26Aa', description='Accessory gland protein 26Aa', other_designations='Acp26Aa-PA|CG8982-PA|accessory gland peptide 26Aa|accessory gland protein 26Aa|accessory gland-specific peptide 26Aa|accessory protein 26A|ovulin', map_location='26A1-26A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5892883, end_position_on_the_genomic_accession=5893896, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33818 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33818, CurrentID=0, Status='live', Symbol='CG9021', Aliases='Dmel_ Dmel\\CG9021', description='CG9021 gene product from transcript CG9021-RB', other_designations='CG9021-PA|CG9021-PB', map_location='26A1-26A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5903178, end_position_on_the_genomic_accession=5904689, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33819 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33819, CurrentID=0, Status='live', Symbol='bchs', Aliases='Dmel_CG14001, Alfy, BcDNA:SD12984, Bchs, Beach1, CG14001, CG9011, DBEACH1, Dmel\\CG14001, EP2299, alfy, bchd', description='blue cheese', other_designations='Beach1|Beached1|CG14001-PA|bchs-PA|beached|beached 1|dbeach1', map_location='26A1-26A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5907169, end_position_on_the_genomic_accession=5922776, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  33820 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33820, CurrentID=0, Status='live', Symbol='CG14000', Aliases='Dmel_ Dmel\\CG14000', description='CG14000 gene product from transcript CG14000-RA', other_designations='CG14000-PA|uncharacterized protein', map_location='26A1-26A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5908927, end_position_on_the_genomic_accession=5910289, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33822 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33822, CurrentID=0, Status='live', Symbol='CG9016', Aliases='Dmel_ BcDNA:AT19175, Dmel\\CG9016, NEST:bs09a09, NEST:bs20d08, NEST:bs24f02, NEST:bs36a03, bs03c03.y1, bs05g03.y1, bs07e11.y1, bs09c06.y1, bs10d11.y1, bs10f09.y1, bs13h06.y1, bs14b11.y1, bs16c10.y1, bs16d01.y1, bs18b05.y1, bs19d06.y1, bs20d08.y1, bs21a02.y1, bs22a02.y1, bs24f02.y1, bs25d03.y1, bs27b06.y1, bs28b03.y1, bs29e04.y1, bs29f11.y1, bs36f07.y1', description='CG9016 gene product from transcript CG9016-RB', other_designations='CG9016-PA|CG9016-PB', map_location='26A1-26A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5922876, end_position_on_the_genomic_accession=5923653, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33823 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33823, CurrentID=0, Status='live', Symbol='dsf', Aliases='Dmel_CG9019, CG9019, DSF, Dmel\\CG9019, Dsf, NR2E4', description='dissatisfaction', other_designations='CG9019-PA|CG9019-PB|dsf-PA|dsf-PB', map_location='26A1-26A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5925937, end_position_on_the_genomic_accession=5939261, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33824 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33824, CurrentID=0, Status='live', Symbol='Gpdh', Aliases='Dmel_CG9042, CG9042, DROGPDHA, DmG3PDH, Dmel\\CG9042, G3PDH, G3pdh, GAPDH, GPD, GPDA, GPDH, GPDH-1, Gdh, Gpd, alpha-GPD, alpha-GPDH, alpha-GPDH-1, alpha-Gpdh, alphaGPDH, alphaGpd, alphaGpdh, alphaGpdh-1, gpdh, gpdh-1, sn-Gpdh', description='Glycerol 3 phosphate dehydrogenase', other_designations="5' gene|Alpha-Glycerophosphate dehydrogenase|CG9042-PA|CG9042-PB|CG9042-PC|CG9042-PE|CG9042-PF|CG9042-PG|Gpdh-PA|Gpdh-PB|Gpdh-PC|Gpdh-PE|Gpdh-PF|Gpdh-PG|alpha glycerophosphate dehydrogenase|alpha-glycerol phosphate dehydrogenase|alpha-glycerol-3-phosphate dehydrogenase|dehydrogenase|glycerol 3 phosphate dehydrogenase|glycerol-3-phosphate dehydrogenase|glycerophosphate dehydrogenase|sn-glycerol 3-phosphate dehydrogenase|sn-glycerol-3-phosphate|sn-glycerol-3-phosphate dehydrogenase", map_location='26A3-26A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5943643, end_position_on_the_genomic_accession=5948968, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33825 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33825, CurrentID=0, Status='live', Symbol='CG9044', Aliases='Dmel_ CT25972, Dmel\\CG9044, mdcds_8484', description='CG9044 gene product from transcript CG9044-RC', other_designations='CG9044-PB|CG9044-PC', map_location='26A3-26A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5949450, end_position_on_the_genomic_accession=5955235, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  33826 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33826, CurrentID=0, Status='live', Symbol='CG13999', Aliases='Dmel_ Dmel\\CG13999', description='CG13999 gene product from transcript CG13999-RA', other_designations='CG13999-PA|uncharacterized protein', map_location='26A3-26A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5955312, end_position_on_the_genomic_accession=5956466, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33827 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33827, CurrentID=0, Status='live', Symbol='Vm26Ab', Aliases='Dmel_CG9046, CG9046, DIM 29, Dm sV23, Dmel\\CG9046, Sv23, TU-4, VM26A.2, Vm26A, fs(2)QJ42, sV23, sV26, sv23', description='Vitelline membrane 26Ab', other_designations='CG9046-PA|CG9046-PB|Vm26Ab-PA|Vm26Ab-PB|vitelline membrane 26Ab', map_location='26A3-26A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5957004, end_position_on_the_genomic_accession=5957639, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33828 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33828, CurrentID=0, Status='live', Symbol='Vm26Ac', Aliases='Dmel_CG13997, CG13997, Dmel\\CG13997, Fcp26Ac, TU-3, VM26Ac, fc 20, fc20', description='Vitelline membrane 26Aac', other_designations='CG13997-PA|Vm26Ac-PA|follicle cell protein 26Ac|vitelline membrane 26Aac', map_location='26A3-26A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5958005, end_position_on_the_genomic_accession=5958631, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33829 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33829, CurrentID=0, Status='live', Symbol='Vm26Aa', Aliases='Dmel_CG9048, CG9048, Dmel\\CG9048, TU-2, VM26A.1, VM26Aa, Vm26A, Vm26A.1, Vm26A1, sV17', description='Vitelline membrane 26Aa', other_designations='CG9048-PA|CG9048-PB|Vm26Aa-PA|Vm26Aa-PB|vitelline membrane 26Aa', map_location='26A3-26A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5959596, end_position_on_the_genomic_accession=5960340, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33830 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33830, CurrentID=0, Status='live', Symbol='psd', Aliases='Dmel_CG9050, BcDNA:GM32356, CG9050, Dmel\\CG9050, Fcp26Aa, TU-1', description='palisade', other_designations='CG9050-PA|CG9050-PB|follicle cell protein 26Aa|psd-PA|psd-PB', map_location='26A4-26A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5963087, end_position_on_the_genomic_accession=5964951, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33831 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33831, CurrentID=0, Status='live', Symbol='CG13992', Aliases='Dmel_ Dmel\\CG13992', description='CG13992 gene product from transcript CG13992-RC', other_designations='CG13992-PA|CG13992-PB|CG13992-PC|uncharacterized protein', map_location='26A4-26A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5965391, end_position_on_the_genomic_accession=5967752, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33832 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33832, CurrentID=0, Status='live', Symbol='Ucp4C', Aliases='Dmel_CG9064, CG9064, DmUCP4C, Dmel\\CG9064, UCP4C, UCP4c, Ucp4c, anon-WO02079478.1, anon-WO02079478.2, anon-WO0242455.3, anon-WO0242455.4, anon-WO03037362.7, anon-WO03061681.1, anon-WO03061681.2, dmUCP4c', description='CG9064 gene product from transcript CG9064-RA', other_designations='CG9064-PA|Ucp4C-PA', map_location='26A4-26A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5968566, end_position_on_the_genomic_accession=5969761, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33833 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33833, CurrentID=0, Status='live', Symbol='Ucp4B', Aliases='Dmel_CG18340, CG18340, DmUCP4B, Dmel\\CG18340, UCP4B, Ucp 4b, Ucp4b, dmUCP4b', description='Uncoupling protein 4B', other_designations='CG18340-PA|CG18340-PB|CG18340-PC|Ucp4B-PA|Ucp4B-PB|Ucp4B-PC|uncoupling protein 4B|uncoupling protein 4b', map_location='26A5-26A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5969859, end_position_on_the_genomic_accession=5971025, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33834 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33834, CurrentID=0, Status='live', Symbol='chic', Aliases='Dmel_CG9553, CG9553, Chi, Chic, D88, Dmel\\CG9553, GH4, chi, l(2)27/7, profilin, sand', description='chickadee', other_designations='CG9553-PA|CG9553-PB|CG9553-PC|CG9553-PD|CG9553-PE|CG9553-PF|DProfilin|chic-PA|chic-PB|chic-PC|chic-PD|chic-PE|chic-PF|chicadee|chickaddee|profilin|stranded', map_location='26A5-26B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5972115, end_position_on_the_genomic_accession=5981018, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33835 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33835, CurrentID=0, Status='live', Symbol='eIF-4a', Aliases='Dmel_CG9075, 2439, 9075, CG9075, Dm-eIF4A, DmRH2, Dmel\\CG9075, EIF-4A, EIF-4a, EIF4A, EiF4A, Eif-4a, Eif4a, L(2L)162, Su(dpp)YE9, anon-26Aa, anon26A, deIF4A, eIF 4A, eIF-4A-I, eIF4A, eIF4A-I, eIF4AI, eIF4a, eiF4A, eif-4a, eif4A, eif4a, l(2)02439, l(2)162, l(2)26Ac, l(2)gdh-4, l(2)k01501, l(2L)162, pecan, eIF-4a', description='Eukaryotic initiation factor 4a', other_designations='CG9075-PA|CG9075-PB|CG9075-PC|CG9075-PD|CG9075-PE|CG9075-PF|eIF-4a-PA|eIF-4a-PB|eIF-4a-PC|eIF-4a-PD|eIF-4a-PE|eIF-4a-PF|eukaryotic initiation factor 4A|eukaryotic initiation factor 4a|eukaryotic translation initiation factor 4A|translation initiation factor 4A', map_location='26B2-26B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5981764, end_position_on_the_genomic_accession=5985909, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33836 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33836, CurrentID=0, Status='live', Symbol='ifc', Aliases='Dmel_CG9078, CG9078, DES-1, Des1, Dmel\\CG9078, Ifc, des, des-1, des1, l(2)26Ab, l(2)gdh-2, ms(2)04875', description='infertile crescent', other_designations='CG9078-PA|CG9078-PB|degenerating spermatocyte|degenerative spermatocyte|ifc-PA|ifc-PB|sphingolipid delta 4 desaturase', map_location='2-20.6 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5986348, end_position_on_the_genomic_accession=5988854, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33837 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33837, CurrentID=0, Status='live', Symbol='lid', Aliases='Dmel_CG9088, CG9088, Dmel\\CG9088, KDM5, LID, Lid, dJARID1, dKDM5/LID, l(2)10424', description='little imaginal discs', other_designations='CG9088-PA|CG9088-PB|CG9088-PC|CG9088-PD|CG9088-PE|CG9088-PF|lid-PA|lid-PB|lid-PC|lid-PD|lid-PE|lid-PF|little imaginal disks', map_location='26B2-26B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=5989400, end_position_on_the_genomic_accession=5999501, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33838 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33838, CurrentID=0, Status='live', Symbol='Tsp26A', Aliases='Dmel_CG9093, CG9093, Dm.Tsp26A, Dmel\\CG9093', description='Tetraspanin 26A', other_designations='CG9093-PB|CG9093-PC|CG9093-PD|Tsp26A-PB|Tsp26A-PC|Tsp26A-PD|tetraspanin 26A', map_location='26B2-26B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6000228, end_position_on_the_genomic_accession=6003738, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33839 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33839, CurrentID=0, Status='live', Symbol='Gal', Aliases='Dmel_CG9092, CG9092, Dmel\\CG9092, beta-GAL, beta-Gal-1, beta-gal, gal, lacZ-1', description='beta galactosidase', other_designations='CG9092-PA|CG9092-PB|Gal-PA|Gal-PB|beta-galactosidase-1', map_location='26B2-26B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6003574, end_position_on_the_genomic_accession=6006827, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33840 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33840, CurrentID=0, Status='live', Symbol='CG9098', Aliases='Dmel_ Dmel\\CG9098', description='CG9098 gene product from transcript CG9098-RC', other_designations='CG9098-PA|CG9098-PB|CG9098-PC', map_location='26B2-26B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6007364, end_position_on_the_genomic_accession=6012338, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33841 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33841, CurrentID=0, Status='live', Symbol='H2.0', Aliases='Dmel_CG11607, CG11607, Dmel\\CG11607', description='Homeodomain protein 2.0', other_designations='CG11607-PA|H2.0-PA|homeodomain protein 2.0', map_location='26B2-26B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6013059, end_position_on_the_genomic_accession=6019402, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33842 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33842, CurrentID=0, Status='live', Symbol='CG13996', Aliases='Dmel_ Dmel\\CG13996', description='CG13996 gene product from transcript CG13996-RA', other_designations='CG13996-PA|uncharacterized protein', map_location='26B3-26B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6020835, end_position_on_the_genomic_accession=6021718, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33843 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33843, CurrentID=0, Status='live', Symbol='CG9107', Aliases='Dmel_ Dmel\\CG9107, Rrp7', description='CG9107 gene product from transcript CG9107-RA', other_designations='CG9107-PA|CG9107-PB', map_location='26B3-26B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6022951, end_position_on_the_genomic_accession=6024539, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33844 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33844, CurrentID=0, Status='live', Symbol='CG9109', Aliases='Dmel_ Dmel\\CG9109, dC1GalT9', description='CG9109 gene product from transcript CG9109-RA', other_designations='CG9109-PA|CG9109-PC', map_location='26B3-26B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6025870, end_position_on_the_genomic_accession=6034423, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33845 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33845, CurrentID=0, Status='live', Symbol='mtm', Aliases='Dmel_CG9115, CG9115, Dmel\\CG9115, MTM1, dMTMH1', description='myotubularin', other_designations='CG9115-PA|CG9115-PB|mtm-PA|mtm-PB', map_location='26B3-26B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6034731, end_position_on_the_genomic_accession=6037015, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33846 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33846, CurrentID=0, Status='live', Symbol='CG9117', Aliases='Dmel_ Dmel\\CG9117', description='CG9117 gene product from transcript CG9117-RA', other_designations='CG9117-PA', map_location='26B3-26B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6036997, end_position_on_the_genomic_accession=6037902, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33847 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33847, CurrentID=0, Status='live', Symbol='ade2', Aliases='Dmel_CG9127, 153122_at, Ade2, CG9127, Dmel\\CG9127, Paics, pym', description='adenosine 2', other_designations='CG9127-PA|CG9127-PB|CG9127-PC|ade2-PA|ade2-PB|ade2-PC|adenosine2', map_location='2-17.7 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6041181, end_position_on_the_genomic_accession=6046050, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33849 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33849, CurrentID=0, Status='live', Symbol='CG12393', Aliases='Dmel_ Dmel\\CG12393', description='CG12393 gene product from transcript CG12393-RB', other_designations='CG12393-PA|CG12393-PB|CG12393-PD|uncharacterized protein', map_location='26B3-26B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6048002, end_position_on_the_genomic_accession=6050474, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33850 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33850, CurrentID=0, Status='live', Symbol='CG9135', Aliases='Dmel_ Dmel\\CG9135', description='CG9135 gene product from transcript CG9135-RD', other_designations='CG9135-PA|CG9135-PB|CG9135-PC|CG9135-PD', map_location='26B3-26B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6050800, end_position_on_the_genomic_accession=6053877, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33851 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33851, CurrentID=0, Status='live', Symbol='CG13995', Aliases='Dmel_ Dmel\\CG13995, anon-WO0170980.169, anon-WO0170980.170', description='CG13995 gene product from transcript CG13995-RA', other_designations='CG13995-PA|uncharacterized protein', map_location='26B3-26B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6054302, end_position_on_the_genomic_accession=6060169, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33852 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33852, CurrentID=0, Status='live', Symbol='ND-51', Aliases='Dmel_CG9140, CG9140, Dmel\\CG9140, ND51, NUBM', description='NADH dehydrogenase (ubiquinone) 51 kDa subunit', other_designations='CG9140-PA|CG9140-PB|FBpp0078847|NADH dehydrogenase|NADH ubiquinone oxidoreductase 51 kDa|NADH-UBIQUINONE OXIDOREDUCTASE 51 KDA SUBUNIT|NADH:ubiquinone oxidoreductase 51 kDa subunit|NADH:ubiquinone oxidoreductase, 51kDa subunit|ND-51-PA|ND-51-PB|ubiquinone', map_location='26B4-26B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6060842, end_position_on_the_genomic_accession=6062757, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33853 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33853, CurrentID=0, Status='live', Symbol='CG13994', Aliases='Dmel_ BcDNA:AT31406, Dmel\\CG13994', description='CG13994 gene product from transcript CG13994-RA', other_designations='CG13994-PA|CG13994-PB|uncharacterized protein', map_location='26B4-26B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6062989, end_position_on_the_genomic_accession=6063671, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33854 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33854, CurrentID=0, Status='live', Symbol='Fbw5', Aliases='Dmel_CG9144, CG9144, Dmel\\CG9144, FBXW2, FBgn 31773, dFbw5', description='F-box and WD repeat domain containing 5', other_designations='CG9144-PA|Fbw5-PA', map_location='26B4-26B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6063562, end_position_on_the_genomic_accession=6065953, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33855 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33855, CurrentID=0, Status='live', Symbol='CG9147', Aliases='Dmel_ Dmel\\CG9147', description='CG9147 gene product from transcript CG9147-RD', other_designations='CG9147-PA|CG9147-PB|CG9147-PC|CG9147-PD', map_location='26B4-26B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6065997, end_position_on_the_genomic_accession=6067635, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33856 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33856, CurrentID=0, Status='live', Symbol='CG9150', Aliases='Dmel_ Dmel\\CG9150', description='CG9150 gene product from transcript CG9150-RB', other_designations='CG9150-PB', map_location='26B4-26B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6067668, end_position_on_the_genomic_accession=6068594, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33857 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33857, CurrentID=0, Status='live', Symbol='CG13993', Aliases='Dmel_ Dmel\\CG13993, anon-EST:Posey288', description='CG13993 gene product from transcript CG13993-RA', other_designations='CG13993-PA|CG13993-PB|uncharacterized protein', map_location='26B4-26B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6069079, end_position_on_the_genomic_accession=6069838, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33858 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33858, CurrentID=0, Status='live', Symbol='CG9154', Aliases='Dmel_ Dmel\\CG9154', description='CG9154 gene product from transcript CG9154-RB', other_designations='CG9154-PA|CG9154-PB', map_location='26B4-26B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6069790, end_position_on_the_genomic_accession=6070686, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33859 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33859, CurrentID=0, Status='live', Symbol='Kr-h2', Aliases='Dmel_CG9159, CG9159, Dmel\\CG9159, Kr-H2, Kr-h, anon-26Ba', description='Kruppel homolog 2', other_designations='CG9159-PA|CG9159-PB|CG9159-PC|Kr-h2-PA|Kr-h2-PB|Kr-h2-PC|anon-26Ba|kruppel homolog|kruppel homolog 2', map_location='26B4-26B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6070990, end_position_on_the_genomic_accession=6073961, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33861 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33861, CurrentID=0, Status='live', Symbol='Kr-h1', Aliases='Dmel_CG45074, 44/11, CG18783, CG45074, CG9167, Dmel\\CG45074, Dmel_CG18783, Kr h, Kr-H1, Kr-h, P381, Pow, l(2)05208, l(2)10642', description='Kruppel homolog 1', other_designations='CG45074-PA|CG45074-PB|Kr-h1-PA|Kr-h1-PB|Krueppel-homolog alpha-isoform|Kruppel-homolog 1|Kruppel-homolog-1|kruppel homolog 1|krupple homolog 1|passion of white', map_location='26B5-26B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6082603, end_position_on_the_genomic_accession=6096498, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33862 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33862, CurrentID=0, Status='live', Symbol='CG9175', Aliases='Dmel_ Dmel\\CG9175, Sec12', description='CG9175 gene product from transcript CG9175-RB', other_designations='CG9175-PA|CG9175-PB', map_location='26B5-26B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6096698, end_position_on_the_genomic_accession=6098966, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33863 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33863, CurrentID=0, Status='live', Symbol='stai', Aliases='Dmel_CG31641, BEST:LD33989, CG31641, CG5981, D-stat, Dmel\\CG31641, LD33989, SCG10-like, rdt, rdtp', description='stathmin', other_designations='CG31641-PA|CG31641-PB|CG31641-PC|CG31641-PD|CG31641-PE|D-stathmin|redtape|stai-PA|stai-PB|stai-PC|stai-PD|stai-PE', map_location='26B5-26B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6100377, end_position_on_the_genomic_accession=6124653, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  33864 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33864, CurrentID=0, Status='live', Symbol='Arpc4', Aliases='Dmel_CG5972, ARPC4, Arc-p20, Arp-p20, BcDNA:RE43724, CG5972, Dmel\\CG5972, P-20 ARC, anon-EST:Posey49, arc-p20, p20, p20Arc', description='Actin-related protein 2/3 complex, subunit 4', other_designations='Arc-p20|Arp2/3 complex (p20 subunit)|Arp2/3 subunit p20|Arpc4-PA|CG5972-PA|p20 of Arp2/3 complex|p20 subunit of Arp2/3', map_location='26B7-26B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6125132, end_position_on_the_genomic_accession=6125911, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33865 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33865, CurrentID=0, Status='live', Symbol='WDR79', Aliases='Dmel_CG9226, CG9226, Dmel\\CG9226, dWDR79, p70', description='WD repeat domain 79 homolog', other_designations='CG9226-PB|CG9226-PC|WDR79-PB|WDR79-PC', map_location='26B7-26B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6125879, end_position_on_the_genomic_accession=6127775, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33866 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33866, CurrentID=0, Status='live', Symbol='tectonic', Aliases='Dmel_CG42731, CG42731, CG9227, Dmel\\CG42731, Dmel_CG9227, Tectonic', description='CG42731 gene product from transcript CG42731-RA', other_designations='CG42731-PA|tectonic-PA', map_location='26B7-26B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6127872, end_position_on_the_genomic_accession=6130651, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33867 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33867, CurrentID=0, Status='live', Symbol='CG9222', Aliases='Dmel_ Dmel\\CG9222', description='CG9222 gene product from transcript CG9222-RA', other_designations='CG9222-PA', map_location='26B8-26B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6131023, end_position_on_the_genomic_accession=6132484, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33868 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33868, CurrentID=0, Status='live', Symbol='CG13991', Aliases='Dmel_ Dmel\\CG13991', description='CG13991 gene product from transcript CG13991-RA', other_designations='CG13991-PA|uncharacterized protein', map_location='26B8-26B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6139382, end_position_on_the_genomic_accession=6145010, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33869 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33869, CurrentID=0, Status='live', Symbol='CG13989', Aliases='Dmel_ BcDNA:AT09383, Dmel\\CG13989', description='CG13989 gene product from transcript CG13989-RA', other_designations='CG13989-PA|uncharacterized protein', map_location='26B9-26B9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6160400, end_position_on_the_genomic_accession=6161309, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33874 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33874, CurrentID=0, Status='live', Symbol='AANATL2', Aliases='Dmel_CG9486, CG9486, Dmel\\CG9486', description='Arylalkylamine N-acyltransferase-like 2', other_designations='AANATL2-PA|AANATL2-PB|CG9486-PA|CG9486-PB|arylalkylamine N-acyltransferase-like 2', map_location='26C1-26C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6255859, end_position_on_the_genomic_accession=6256822, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33875 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33875, CurrentID=0, Status='live', Symbol='CG13983', Aliases='Dmel_ Dmel\\CG13983', description='CG13983 gene product from transcript CG13983-RA', other_designations='CG13983-PA|uncharacterized protein', map_location='26C1-26C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6263557, end_position_on_the_genomic_accession=6264490, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33879 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33879, CurrentID=0, Status='live', Symbol='CG13984', Aliases='Dmel_ Dmel\\CG13984', description='CG13984 gene product from transcript CG13984-RA', other_designations='CG13984-PA|uncharacterized protein', map_location='26C2-26C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6308819, end_position_on_the_genomic_accession=6309475, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33881 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33881, CurrentID=0, Status='live', Symbol='PDZ-GEF', Aliases='Dmel_CG9491, CG9491, D-PDZGEF, DGEF, Dmel\\CG9491, Dzy, EC2-8, GEF, Gef26, PDF-GEF Dizzy, dPDZ-GEF, dizzy, dzy, l(2)k13720', description='PDZ domain-containing guanine nucleotide exchange factor', other_designations='CG9491-PA|CG9491-PB|CG9491-PC|CG9491-PD|GEF|Gef26|PDZ-GEF-PA|PDZ-GEF-PB|PDZ-GEF-PC|PDZ-GEF-PD|PDZ-GEF/Dizzy|dizzy', map_location='26C2-26C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6323767, end_position_on_the_genomic_accession=6332789, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33882 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33882, CurrentID=0, Status='live', Symbol='Pez', Aliases='Dmel_CG9493, CG9493, Dmel\\CG9493, PTPD1, d', description='CG9493 gene product from transcript CG9493-RB', other_designations='CG9493-PA|CG9493-PB|Pez-PA|Pez-PB', map_location='26C3-26C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6332881, end_position_on_the_genomic_accession=6338671, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33883 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33883, CurrentID=0, Status='live', Symbol='Cpr', Aliases='Dmel_CG11567, CCR, CG11567, CPR, DMR, DmCPR, Dmel\\CG11567, NCPR, P450, cpr', description='Cytochrome P450 reductase', other_designations='CG11567-PA|CG11567-PB|CG11567-PC|CG11567-PD|Cpr-PA|Cpr-PB|Cpr-PC|Cpr-PD|NADPH--ferrihemoprotein reductase; NADPH-cytochrome P450 reductase|NADPH-cytochrome P450 oxidoreductase|NADPH-cytochrome P450 reductase|P450 reductase|cytochrome P450 reductase|cytochrome c reductase (NADPH)', map_location='26C3-26C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6338836, end_position_on_the_genomic_accession=6346280, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  33884 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33884, CurrentID=0, Status='live', Symbol='CG9497', Aliases='Dmel_ Dmel\\CG9497', description='CG9497 gene product from transcript CG9497-RB', other_designations='CG9497-PA|CG9497-PB', map_location='26C3-26C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6346430, end_position_on_the_genomic_accession=6348427, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33885 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33885, CurrentID=0, Status='live', Symbol='CG9498', Aliases='Dmel_ Dmel\\CG9498', description='CG9498 gene product from transcript CG9498-RA', other_designations='CG9498-PA', map_location='26C3-26C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6349393, end_position_on_the_genomic_accession=6351034, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33886 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33886, CurrentID=0, Status='live', Symbol='ppk7', Aliases='Dmel_CG9499, CG9499, Dmel\\CG9499, PPK7', description='pickpocket 7', other_designations='CG9499-PA|ppk7-PA', map_location='26C3-26C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6352324, end_position_on_the_genomic_accession=6354331, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33887 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33887, CurrentID=0, Status='live', Symbol='ppk14', Aliases='Dmel_CG9501, CG9501, Dmel\\CG9501, PPK14', description='pickpocket 14', other_designations='CG9501-PB|ppk14-PB', map_location='26C3-26C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6354956, end_position_on_the_genomic_accession=6356672, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33888 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33888, CurrentID=0, Status='live', Symbol='CG9500', Aliases='Dmel_ AAF52372, Dmel\\CG9500, FBpp0078910', description='CG9500 gene product from transcript CG9500-RA', other_designations='CG9500-PA|Fibrinogen-related protein', map_location='26C3-26C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6357005, end_position_on_the_genomic_accession=6358318, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33889 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33889, CurrentID=0, Status='live', Symbol='CG9505', Aliases='Dmel_ Dmel\\CG9505', description='CG9505 gene product from transcript CG9505-RA', other_designations='CG9505-PA', map_location='26C4-26C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6367882, end_position_on_the_genomic_accession=6370190, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33890 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33890, CurrentID=0, Status='live', Symbol='slam', Aliases='Dmel_CG9506, CG9506, Dmel\\CG9506, Slam, wdo', description='slow as molasses', other_designations='CG9506-PB|CG9506-PC|slam-PB|slam-PC|waldo', map_location='26C4-26C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6372388, end_position_on_the_genomic_accession=6377284, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33892 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33892, CurrentID=0, Status='live', Symbol='CG9507', Aliases='Dmel_ Dmel\\CG9507', description='CG9507 gene product from transcript CG9507-RA', other_designations='CG9507-PA', map_location='26C4-26C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6381266, end_position_on_the_genomic_accession=6383419, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33893 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33893, CurrentID=0, Status='live', Symbol='CG42370', Aliases='Dmel_ CG13981, CG33295, CG9508, CG9511, CT26920, Dmel\\CG42370, Dmel_CG9508, Dmel_CG9511', description='CG42370 gene product from transcript CG42370-RA', other_designations='CG42370-PA|Dmel_CG42370|uncharacterized protein', map_location='26C4-26D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6383435, end_position_on_the_genomic_accession=6385512, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33894 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33894, CurrentID=0, Status='live', Symbol='CG42369', Aliases='Dmel_ CG13981, CG33295, CG9508, CG9511, CT26922, Dmel\\CG42369, Dmel_CG9508, Dmel_CG9511', description='CG42369 gene product from transcript CG42369-RA', other_designations='CG42369-PA|uncharacterized protein', map_location='26D1-26D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6395853, end_position_on_the_genomic_accession=6397249, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33895 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33895, CurrentID=0, Status='live', Symbol='CG13982', Aliases='Dmel_ Dmel\\CG13982', description='CG13982 gene product from transcript CG13982-RA', other_designations='CG13982-PA|CG13982-PB|uncharacterized protein', map_location='26D1-26D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6412315, end_position_on_the_genomic_accession=6415335, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33896 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33896, CurrentID=0, Status='live', Symbol='Tig', Aliases='Dmel_CG11527, CG11527, CT36389, Dmel\\CG11527, TIG, tig', description='Tiggrin', other_designations='CG11527-PA|CG11527-PB|Tig-PA|Tig-PB|tiggrin', map_location='26D1-26D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6415179, end_position_on_the_genomic_accession=6423310, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33897 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33897, CurrentID=0, Status='live', Symbol='Fic', Aliases='Dmel_CG9523, CG9523, Dmel\\CG9523, l(2)k11101', description='Fic domain-containing protein', other_designations='CG9523-PA|Fic-PA|lethal (2) k11101', map_location='28D10-28D11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6424336, end_position_on_the_genomic_accession=6426371, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33898 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33898, CurrentID=0, Status='live', Symbol='CG9527', Aliases='Dmel_ Dmel\\CG9527, LCAD', description='CG9527 gene product from transcript CG9527-RD', other_designations='CG9527-PA|CG9527-PB|CG9527-PC|CG9527-PD|long chain acyl-CoA-dehydrogenase', map_location='26D1-26D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6426724, end_position_on_the_genomic_accession=6448403, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33899 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33899, CurrentID=0, Status='live', Symbol='retm', Aliases='Dmel_CG9528, CG9528, Dmel\\CG9528', description='real-time', other_designations='CG9528-PA|CG9528-PB|CG9528-PC|retm-PA|retm-PB|retm-PC', map_location='26D4-26D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6448464, end_position_on_the_genomic_accession=6455929, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33900 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33900, CurrentID=0, Status='live', Symbol='frj', Aliases='Dmel_CG9526, CG9526, CT26954, Dmel\\CG9526, Frj, MBOAT', description='farjavit', other_designations='CG9526-PA|CG9526-PB|frj-PA|frj-PB', map_location='26D5-26D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6456052, end_position_on_the_genomic_accession=6459008, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33901 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33901, CurrentID=0, Status='live', Symbol='CG16947', Aliases='Dmel_ Dmel\\CG16947, anon-EST:Posey20', description='CG16947 gene product from transcript CG16947-RA', other_designations='CG16947-PA|CG16947-PB|uncharacterized protein', map_location='26D5-26D7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6459015, end_position_on_the_genomic_accession=6465669, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33902 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33902, CurrentID=0, Status='live', Symbol='CG9531', Aliases='Dmel_ Dmel\\CG9531', description='CG9531 gene product from transcript CG9531-RA', other_designations='CG9531-PA|CG9531-PB', map_location='26D7-26D7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6466217, end_position_on_the_genomic_accession=6467698, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33903 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33903, CurrentID=0, Status='live', Symbol='mmy', Aliases='Dmel_CG9535, BcDNA:LD24639, CG9535, Dmel\\CG9535, LD44264, anon-WO0140519.242, cao, cys, cyst, cystic, l(2)k13717b, mum', description='mummy', other_designations='CG9535-PA|CG9535-PB|CG9535-PD|UDP-GlcNAc pyrophosphorylase|cabrio|cystic|mmy-PA|mmy-PB|mmy-PD', map_location='2-16 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6468538, end_position_on_the_genomic_accession=6473904, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33904 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33904, CurrentID=0, Status='live', Symbol='CG9536', Aliases='Dmel_ Dmel\\CG9536', description='CG9536 gene product from transcript CG9536-RB', other_designations='CG9536-PA|CG9536-PB', map_location='26D7-26D7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6474438, end_position_on_the_genomic_accession=6476975, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33905 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33905, CurrentID=0, Status='live', Symbol='Sec61alpha', Aliases='Dmel_CG9539, 0455, BEST:LD29847, BcDNA:LD29847, CG9539, DSec61alpha, Dmel\\CG9539, E(br)165, LD29847, SEC61-alpha, SEC61ALPHA, Sec61, Sec61-alpha, Sec61a, anon-WO0118547.195, anon-WO0118547.277, dSEC61A, dSec61alpha, endd2, l(2)k04917, sec61, sec61alpha', description='Sec61 alpha subunit', other_designations='CG9539-PA|CG9539-PB|E(br)165|Sec61alpha-PA|Sec61alpha-PB|effector for neural death and degeneration 2', map_location='26D7-26D8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6477182, end_position_on_the_genomic_accession=6480575, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33906 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33906, CurrentID=0, Status='live', Symbol='Daxx', Aliases='Dmel_CG9537, CG9537, DLP, Dmel\\CG9537', description='Daxx-like protein', other_designations='CG9537-PA|CG9537-PB|Daxx-PA|Daxx-PB', map_location='26D8-26D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6480929, end_position_on_the_genomic_accession=6487576, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33907 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33907, CurrentID=0, Status='live', Symbol='KFase', Aliases='Dmel_CG9542, CG9542, Dmel\\CG9542', description='Kynurenine formamidase', other_designations='CG9542-PA|CG9542-PB|KFase-PA|KFase-PB|kynurenine formamidase', map_location='26D9-26D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6487342, end_position_on_the_genomic_accession=6488756, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33908 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33908, CurrentID=0, Status='live', Symbol='epsilonCOP', Aliases='Dmel_CG9543, BcDNA:LD29885, CG9543, Dmel\\CG9543, bcDNA:LD29885, epsilon-COP, epsilon-Cop', description='Coat Protein (coatomer) epsilon', other_designations='CG9543-PA|COPI epsilon subunit|coat protein (coatomer) epsilon|epsilonCOP-PA', map_location='26D9-26D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6489090, end_position_on_the_genomic_accession=6490194, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33909 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33909, CurrentID=0, Status='live', Symbol='CG9548', Aliases='Dmel_ BcDNA:RH02789, Dmel\\CG9548', description='CG9548 gene product from transcript CG9548-RA', other_designations='CG9548-PA', map_location='26D9-26D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6490155, end_position_on_the_genomic_accession=6490843, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33910 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33910, CurrentID=0, Status='live', Symbol='CG31638', Aliases='Dmel_ CG13764, CG9545, Dmel\\CG31638', description='CG31638 gene product from transcript CG31638-RA', other_designations='CG31638-PA|CG31638-PB|uncharacterized protein', map_location='26D9-26D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6491061, end_position_on_the_genomic_accession=6496988, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  33911 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33911, CurrentID=0, Status='live', Symbol='CG9547', Aliases='Dmel_ 152078_at, Dmel\\CG9547', description='CG9547 gene product from transcript CG9547-RA', other_designations='CG9547-PA', map_location='26D9-26D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6492974, end_position_on_the_genomic_accession=6494532, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33913 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33913, CurrentID=0, Status='live', Symbol='CG9550', Aliases='Dmel_ Dmel\\CG9550, d6ST2', description='CG9550 gene product from transcript CG9550-RA', other_designations='CG9550-PA', map_location='26D9-26D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6497053, end_position_on_the_genomic_accession=6498466, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33914 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33914, CurrentID=0, Status='live', Symbol='CG31637', Aliases='Dmel_ CG13765, CG9551, Dmel\\CG31637, anon-WO0118547.107, d6ST1', description='CG31637 gene product from transcript CG31637-RA', other_designations='CG31637-PA|CG31637-PB|uncharacterized protein', map_location='26D9-26E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6498647, end_position_on_the_genomic_accession=6526996, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33916 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33916, CurrentID=0, Status='live', Symbol='eya', Aliases='Dmel_CG9554, 24582246, BcDNA:LD16029, CG9554, CLI, CLIFT, Dmel\\CG9554, EY2-1, EYA, Eya, cli, cli/eya, dEYA, del1, eay, ey-2', description='eyes absent', other_designations='CG9554-PA|CG9554-PB|CG9554-PC|Eye absent|Eyes-absent|clift|delayed gonad formation 1|eya-PA|eya-PB|eya-PC|eyeless 2', map_location='2-17 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6527447, end_position_on_the_genomic_accession=6546976, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33917 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33917, CurrentID=0, Status='live', Symbol='Osm6', Aliases='Dmel_CG9595, CG9595, Dmel\\CG9595, IFT52, NGD5, OSM-6, Osm-6, osm-6', description='Osm-6 ortholog (C. elegans)', other_designations='CG9595-PA|Osm-6 ortholog|Osm6-PA|osm-6', map_location='26E3-26E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6555717, end_position_on_the_genomic_accession=6557502, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33918 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33918, CurrentID=0, Status='live', Symbol='COX5B', Aliases='Dmel_CG11015, BcDNA:RH49324, CG11015, COXB, CcO Vb, CoVb, Dmel\\CG11015, Vb, anon-EST:Posey143, anon-WO0118547.187', description='Cytochrome c oxidase subunit 5B', other_designations='CG11015-PA|CG11015-PB|COX5B-PA|COX5B-PB|cytochrome c oxidase Vb|cytochrome c oxidase polypeptide Vb|cytochrome c oxidase subunit 5B|cytochrome c oxidase subunit Vb|subunit Vb', map_location='26E3-26E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6557800, end_position_on_the_genomic_accession=6559308, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33919 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33919, CurrentID=0, Status='live', Symbol='COX5BL', Aliases='Dmel_CG11043, CG11043, COXB, Dmel\\CG11043, Vb', description='Cytochrome c oxidase subunit 5B-like', other_designations='CG11043-PA|COX5BL-PA|cytochrome c oxidase polypeptide Vb|cytochrome c oxidase subunit 5B-like', map_location='26E3-26E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6559431, end_position_on_the_genomic_accession=6560133, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33920 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33920, CurrentID=0, Status='live', Symbol='CG9596', Aliases='Dmel_ Dmel\\CG9596', description='CG9596 gene product from transcript CG9596-RC', other_designations='CG9596-PB|CG9596-PC|CG9596-PD', map_location='26E3-26E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6559426, end_position_on_the_genomic_accession=6562289, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33921 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33921, CurrentID=0, Status='live', Symbol='Ent2', Aliases='Dmel_CG31911, BEST:LD04971, CG11045, CG31911, DmENT2, DmEnt2, Dmel\\CG31911, LD04971, P124, ent2', description='Equilibrative nucleoside transporter 2', other_designations='CG31911-PA|CG31911-PB|Ent2-PA|Ent2-PB|P124|equilibrative nucleoside transporter|equilibrative nucleoside transporter 2', map_location='26E3-26E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6562325, end_position_on_the_genomic_accession=6564709, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33922 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33922, CurrentID=0, Status='live', Symbol='CG13766', Aliases='Dmel_ Dmel\\CG13766, FBXO16', description='CG13766 gene product from transcript CG13766-RB', other_designations='CG13766-PA|CG13766-PB|uncharacterized protein', map_location='26E3-26E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6564112, end_position_on_the_genomic_accession=6566181, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33923 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33923, CurrentID=0, Status='live', Symbol='CG11319', Aliases='Dmel_ Dmel\\CG11319', description='CG11319 gene product from transcript CG11319-RA', other_designations='CG11319-PA|CG11319-PB|CG11319-PC|uncharacterized protein', map_location='26E3-26F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6568400, end_position_on_the_genomic_accession=6601068, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  33924 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33924, CurrentID=0, Status='live', Symbol='CG11050', Aliases='Dmel_ BcDNA:LD22339, Dmel\\CG11050', description='CG11050 gene product from transcript CG11050-RA', other_designations='CG11050-PA|CG11050-PB|CG11050-PC|uncharacterized protein', map_location='26F1-26F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6611011, end_position_on_the_genomic_accession=6617117, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33925 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33925, CurrentID=0, Status='live', Symbol='DIP-iota', Aliases='Dmel_CG11320, 11320, CG11320, CT31597, Dmel\\CG11320', description='Dpr-interacting protein iota', other_designations='CG11320-PB|DIP-iota-PB', map_location='26F1-26F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6617134, end_position_on_the_genomic_accession=6621700, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33927 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33927, CurrentID=0, Status='live', Symbol='Oatp26F', Aliases='Dmel_CG31634, CG11332, CG13767, CG18784, CG31634, Dmel\\CG31634, oatp 26F, oatp26F', description='Organic anion transporting polypeptide 26F', other_designations='CG31634-PA|Oatp26F-PA|organic anion transporter protein 26f|organic anion transporting polypeptide 26F', map_location='26F3-26F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6625138, end_position_on_the_genomic_accession=6632407, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33928 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33928, CurrentID=0, Status='live', Symbol='CG31635', Aliases='Dmel_ BcDNA:GM03875, CG13768, CG13769, CT33252, Dmel\\CG31635', description='CG31635 gene product from transcript CG31635-RG', other_designations='CG31635-PA|CG31635-PB|CG31635-PC|CG31635-PD|CG31635-PE|CG31635-PF|CG31635-PG|CG31635-PH|uncharacterized protein', map_location='26F3-26F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6632798, end_position_on_the_genomic_accession=6649114, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  33930 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33930, CurrentID=0, Status='live', Symbol='Tango1', Aliases='Dmel_CG11098, CG11098, Dmel\\CG11098, TANGO1', description='Transport and Golgi organization 1', other_designations='CG11098-PA|CG11098-PC|CG11098-PD|Tango1-PA|Tango1-PC|Tango1-PD|transport and golgi organisation 1|transport and golgi organization 1', map_location='26F3-26F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6649388, end_position_on_the_genomic_accession=6654574, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33931 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33931, CurrentID=0, Status='live', Symbol='CG31633', Aliases='Dmel_ CG13770, Dmel\\CG31633, FBXL17', description='CG31633 gene product from transcript CG31633-RA', other_designations='CG31633-PA|uncharacterized protein', map_location='26F5-26F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6654760, end_position_on_the_genomic_accession=6656321, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33932 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33932, CurrentID=0, Status='live', Symbol='CG11070', Aliases='Dmel_ BcDNA:LD34475, CG 11070, Dmel\\CG11070, E4 A, UBE4A, UFD2a', description='CG11070 gene product from transcript CG11070-RA', other_designations='AABU01002759.1|CG11070-PA|uncharacterized protein', map_location='26F5-26F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6658517, end_position_on_the_genomic_accession=6662033, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33933 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33933, CurrentID=0, Status='live', Symbol='CG13771', Aliases='Dmel_ Dmel\\CG13771', description='CG13771 gene product from transcript CG13771-RA', other_designations='CG13771-PA|CG13771-PB|uncharacterized protein', map_location='26F6-26F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6662061, end_position_on_the_genomic_accession=6663612, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33934 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33934, CurrentID=0, Status='live', Symbol='cup', Aliases='Dmel_CG11181, CG11181, CUP, Cup, DmCup, Dmel\\CG11181, fs(1) fs(2)cup, i239', description='CG11181 gene product from transcript CG11181-RC', other_designations='CG11181-PB|CG11181-PC|Cup|cup-PB|cup-PC', map_location='2-23 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6663664, end_position_on_the_genomic_accession=6674780, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  33935 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33935, CurrentID=0, Status='live', Symbol='Galt', Aliases='Dmel_CG9232, CG9232, Dmel\\CG9232, GALT, dGALT', description='Galactose-1-phosphate uridylyltransferase', other_designations='CG9232-PA|CG9232-PB|Galt-PA|Galt-PB|galactose-1-phosphate uridylyltransferase|galactose-1P uridylyltransferase', map_location='26F6-26F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6666264, end_position_on_the_genomic_accession=6668033, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33937 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33937, CurrentID=0, Status='live', Symbol='cort', Aliases='Dmel_CG11330, CG11330, Cort, Dmel\\CG11330, cor', description='cortex', other_designations='CG11330-PA|CG11330-PB|cdc20-like|cort-PA|cort-PB', map_location='2-49 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6674682, end_position_on_the_genomic_accession=6676635, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  33938 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33938, CurrentID=0, Status='live', Symbol='Nse1', Aliases='Dmel_CG11329, CG11329, Dmel\\CG11329, EST2, GM14348, NSE1, anon-WO0118547.82', description='Non-SMC element 1', other_designations='CG11329-PA|CG11329-PB|Nse1-PA|Nse1-PB', map_location='26F7-26F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6676649, end_position_on_the_genomic_accession=6677625, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33939 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33939, CurrentID=0, Status='live', Symbol='Nhe3', Aliases='Dmel_CG11328, CG11328, DmNHE3, Dmel\\CG11328, NHE3, nhe3', description='Na[+]/H[+] hydrogen exchanger 3', other_designations='CG11328-PD|CG11328-PE|CG11328-PG|CG11328-PH|CG11328-PI|CG11328-PJ|Nhe3-PD|Nhe3-PE|Nhe3-PG|Nhe3-PH|Nhe3-PI|Nhe3-PJ', map_location='26F7-26F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6677835, end_position_on_the_genomic_accession=6684364, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  33940 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33940, CurrentID=0, Status='live', Symbol='CG11327', Aliases='Dmel_ Dmel\\CG11327', description='CG11327 gene product from transcript CG11327-RA', other_designations='CG11327-PA|uncharacterized protein', map_location='26F7-26F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6684842, end_position_on_the_genomic_accession=6686712, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33941 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33941, CurrentID=0, Status='live', Symbol='Tsp', Aliases='Dmel_CG11326, CG11326, CT31613, D-TSP, DTSP, Dmel\\CG11326, SP295, tsp', description='Thrombospondin', other_designations='CG11326-PA|CG11326-PC|CG11326-PD|CG11326-PE|CG11326-PF|CG11326-PG|CG11326-PH|Tsp-PA|Tsp-PC|Tsp-PD|Tsp-PE|Tsp-PF|Tsp-PG|Tsp-PH|thrombospondin', map_location='26F7-27A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6686791, end_position_on_the_genomic_accession=6709086, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  33942 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33942, CurrentID=0, Status='live', Symbol='AkhR', Aliases='Dmel_CG11325, AKHR, Akhr, BEST:GH19447, CG11325, DAKHR, DAKHR-1, DGRHR, Dmel\\CG11325, GRHR, GRHR/CG11325, GnRHR, akhr', description='Adipokinetic hormone receptor', other_designations='AKH receptor|AkhR-PA|AkhR-PB|AkhR-PC|AkhR-PD|CG11325-PA|CG11325-PB|CG11325-PC|CG11325-PD|Drm-AKH receptor-1|adipokinetic hormone receptor|gonadotrophin-releasing hormone receptor|gonadotropin-releasing hormone receptor|hormone receptor', map_location='27A1-27A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6711286, end_position_on_the_genomic_accession=6716186, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33943 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33943, CurrentID=0, Status='live', Symbol='Aatf', Aliases='Dmel_CG11188, AATF, CG11188, Che-1, Dmel\\CG11188, anon-WO0118547.190, nutmeg', description='apoptosis antagonizing transcription factor ortholog', other_designations='Aatf-PA|CG11188-PA|nutmeg', map_location='27A1-27A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6717625, end_position_on_the_genomic_accession=6719389, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33944 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33944, CurrentID=0, Status='live', Symbol='homer', Aliases='Dmel_CG11324, BEST:LD03829, CG11324, Dhom, D Dm Homer, Dmel\\CG11324, Dvh, Hom, Homer, LD03829, dhom', description='CG11324 gene product from transcript CG11324-RD', other_designations='CG11324-PA|CG11324-PB|CG11324-PD|CG11324-PE|CG11324-PF|CG11324-PG|d-Homer|drosophila Ves-1 homolog|homer-PA|homer-PB|homer-PD|homer-PE|homer-PF|homer-PG', map_location='27A1-27A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6719394, end_position_on_the_genomic_accession=6723359, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  33946 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33946, CurrentID=0, Status='live', Symbol='TTLL3B', Aliases='Dmel_CG11201, CG11201, Dmel\\CG11201, dmTTLL3B', description='Tubulin tyrosine ligase-like 3B', other_designations='CG11201-PB|TTLL3B-PB|tubulin tyrosine ligase-like 3B', map_location='27A2-27A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6732866, end_position_on_the_genomic_accession=6736149, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33947 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33947, CurrentID=0, Status='live', Symbol='TTLL3A', Aliases='Dmel_CG11323, CG11323, Dmel\\CG11323, dmTTLL3A', description='Tubulin tyrosine ligase-like 3A', other_designations='CG11323-PA|TTLL3A-PA|tubulin tyrosine ligase-like 3A', map_location='27A2-27A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6736364, end_position_on_the_genomic_accession=6740188, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33948 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33948, CurrentID=0, Status='live', Symbol='CG11221', Aliases='Dmel_ Dmel\\CG11221, PKN', description='CG11221 gene product from transcript CG11221-RB', other_designations='CG11221-PA|CG11221-PB|uncharacterized protein', map_location='27A2-27B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6742502, end_position_on_the_genomic_accession=6756133, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33949 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33949, CurrentID=0, Status='live', Symbol='CG11322', Aliases='Dmel_ Dmel\\CG11322', description='CG11322 gene product from transcript CG11322-RB', other_designations='CG11322-PB|uncharacterized protein', map_location='27B1-27B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6757864, end_position_on_the_genomic_accession=6759628, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33950 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33950, CurrentID=0, Status='live', Symbol='CG11321', Aliases='Dmel_ AAF52435.2, Dmel\\CG11321', description='CG11321 gene product from transcript CG11321-RG', other_designations='CG11321-PC|CG11321-PD|CG11321-PE|CG11321-PF|CG11321-PG|CG11321-PH|CG11321-PI|CG11321-PJ|CG11321-PK|uncharacterized protein', map_location='27B1-27B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6759829, end_position_on_the_genomic_accession=6772755, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  33951 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33951, CurrentID=0, Status='live', Symbol='CG17378', Aliases='Dmel_ Dmel\\CG17378', description='CG17378 gene product from transcript CG17378-RA', other_designations='CG17378-PA|CG17378-PB|CG17378-PC|uncharacterized protein', map_location='27B1-27B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6774041, end_position_on_the_genomic_accession=6778444, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  33952 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33952, CurrentID=0, Status='live', Symbol='nrv1', Aliases='Dmel_CG9258, 42kDa, CG9258, Dmel\\CG9258, K-ATPase, NKA-alpha, Na, NaK ATPase, Na[+]/K[+] ATPase, Na[+]/K[+]-ATPase, Na[+]/K[+]ATPase, Nrv, Nrv1, nervana', description='nervana 1', other_designations='CG9258-PA|CG9258-PB|Nervana1|nervana|nervous system antigen 1|nirvana|nirvana 1|nrv1-PA|nrv1-PB', map_location='27B1-27B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6778555, end_position_on_the_genomic_accession=6786861, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33953 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33953, CurrentID=0, Status='live', Symbol='nrv2', Aliases='Dmel_CG9261, 42kDa, CG9261, Dmel\\CG9261, K-ATPase, NEST:bs13c10, Na, NaK ATPase, Na[+]/K[+] ATPase, Na[+]/K[+]-ATPase, Na[+]/K[+]ATPase, Nrv, Nrv2, Nrv2.2, ecta, l(2)SH0329, l(2)SH2 0329, l(2)k04223, l(2)k13315.2, nrv2', description='nervana 2', other_designations='CG9261-PA|CG9261-PC|CG9261-PD|CG9261-PE|CG9261-PF|CG9261-PG|Na+/K+ ATPase|Na[+]/K[+] ATPase|ectatic|nervana|nervana2|nirvana|nirvana2|nrv2-PA|nrv2-PC|nrv2-PD|nrv2-PE|nrv2-PF|nrv2-PG', map_location='27B1-27B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6789770, end_position_on_the_genomic_accession=6798862, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  33954 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33954, CurrentID=0, Status='live', Symbol='CG17377', Aliases='Dmel_ BEST:LP06279, Dmel\\CG17377, anon-WO0140519.32', description='CG17377 gene product from transcript CG17377-RF', other_designations='CG17377-PB|CG17377-PD|CG17377-PE|CG17377-PF|uncharacterized protein', map_location='27B3-27B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6801358, end_position_on_the_genomic_accession=6802840, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33955 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33955, CurrentID=0, Status='live', Symbol='CG11236', Aliases='Dmel_ Dmel\\CG11236', description='CG11236 gene product from transcript CG11236-RA', other_designations='CG11236-PA|CG11236-PB|uncharacterized protein', map_location='27B3-27B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6803011, end_position_on_the_genomic_accession=6804372, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33956 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33956, CurrentID=0, Status='live', Symbol='CG17375', Aliases='Dmel_ Dmel\\CG17375', description='CG17375 gene product from transcript CG17375-RD', other_designations='CG17375-PB|CG17375-PC|CG17375-PD|uncharacterized protein', map_location='27B3-27B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6804324, end_position_on_the_genomic_accession=6805792, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33957 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33957, CurrentID=0, Status='live', Symbol='sens-2', Aliases='Dmel_CG31632, CG11243, CG17373, CG31632, D.m Sens-2, Dmel\\CG31632, Sens-2, sens2', description='senseless-2', other_designations='CG31632-PA|CG31632-PB|sens-2-PA|sens-2-PB', map_location='27B4-27B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6821934, end_position_on_the_genomic_accession=6838995, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33959 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33959, CurrentID=0, Status='live', Symbol='Rca1', Aliases='Dmel_CG10800, 152549_at, CG10800, CLD4, Dmel\\CG10800, Emi1, FBXO5, P3300, RCA1, S(rux)2A, l(2)03300, rca1', description='Regulator of cyclin A1', other_designations='CG10800-PA|Rca1-PA|regulator of cyclin A|regulator of cyclin A 1|regulator of cyclin A1|suppressor of rux 2A', map_location='27C1-27C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6852315, end_position_on_the_genomic_accession=6853866, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33960 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33960, CurrentID=0, Status='live', Symbol='l(2)k09022', Aliases='Dmel_CG10805, CG10805, Dmel\\CG10805, anon-WO0118547.160', description='lethal (2) k09022', other_designations='CG10805-PA|l(2)k09022-PA', map_location='27C1-27C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6854142, end_position_on_the_genomic_accession=6860849, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33961 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33961, CurrentID=0, Status='live', Symbol='Nha1', Aliases='Dmel_CG10806, CG10806, DmNHA1, Dmel\\CG10806, nha1', description='Na[+]/H[+] hydrogen antiporter 1', other_designations='CG10806-PA|CG10806-PB|Nha1-PA|Nha1-PB|serine protease', map_location='27C1-27C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6860905, end_position_on_the_genomic_accession=6870389, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33962 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33962, CurrentID=0, Status='live', Symbol='Nlg2', Aliases='Dmel_CG13772, CG13772, DNlg2, Dmel\\CG13772, dnl2, dnlg2, neuroligin, nl2', description='Neuroligin 2', other_designations='CG13772-PA|CG13772-PB|CG13772-PC|Nlg2-PA|Nlg2-PB|Nlg2-PC|neuroligin|neuroligin 2', map_location='27C3-27C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6874900, end_position_on_the_genomic_accession=6906656, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  33963 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33963, CurrentID=0, Status='live', Symbol='CG13773', Aliases='Dmel_ BEST:GH23590, Dmel\\CG13773', description='CG13773 gene product from transcript CG13773-RA', other_designations='CG13773-PA|uncharacterized protein', map_location='27C4-27C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6906666, end_position_on_the_genomic_accession=6907844, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33964 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33964, CurrentID=0, Status='live', Symbol='Rat1', Aliases='Dmel_CG10354, CG10354, Dmel\\CG10354, RAT1, XRN2, Xrn2, dRAT1, dhp1', description='CG10354 gene product from transcript CG10354-RA', other_designations='CG10354-PA|CG10354-PB|Rat1-PA|Rat1-PB', map_location='27C4-27C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6908083, end_position_on_the_genomic_accession=6911423, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  33965 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33965, CurrentID=0, Status='live', Symbol='Wee1', Aliases='Dmel_CG4488, CG4488, Dmel\\CG4488, Dwee, Dwee1, WEE1, Wee, Wee 1, dWee1, dwee1, wee, wee1', description='Wee1 kinase', other_designations='CG4488-PA|CG4488-PB|Wee1 ortholog|Wee1-PA|Wee1-PB|wee', map_location='27C4-27C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6911090, end_position_on_the_genomic_accession=6914138, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33966 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33966, CurrentID=0, Status='live', Symbol='nop5', Aliases='Dmel_CG10206, 2/30, CG10206, DNOP5, Dmel\\CG10206, D FBgn0026196, NOP5, Nop5', description='CG10206 gene product from transcript CG10206-RA', other_designations='CG10206-PA|nop5-PA', map_location='27C4-27C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6916753, end_position_on_the_genomic_accession=6918743, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33967 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33967, CurrentID=0, Status='live', Symbol='x16', Aliases='Dmel_CG10203, 2/30, 9G8, CG10203, Dmel\\CG10203, D Dxl6, RBP1-like, TN166, X16/9G8, XL6, Xl6, anon-WO0118547.78, d9G8, dx16, dxl6, l(2)k00230, xl6', description='CG10203 gene product from transcript CG10203-RB', other_designations='CG10203-PA|CG10203-PB|x16-PA|x16-PB|xl6', map_location='27C4-27C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6914301, end_position_on_the_genomic_accession=6920210, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33968 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33968, CurrentID=0, Status='live', Symbol='Hrb27C', Aliases='Dmel_CG10377, 10280, CG10377, Dmel\\CG10377, HRB27C, HRP48, Hrb27-C, Hrb27c, Hrb48, Hrp48, Hrp48/Hrb27C, Ov5, RRM7, Rbp7, hnRNP27C, hnRNP48, hrb27, hrb27C, hrb27c, hrp48, l(2)02647, l(2)10280, l(2)2647, linha, p50, rrm7', description='Heterogeneous nuclear ribonucleoprotein at 27C', other_designations='CG10377-PA|CG10377-PB|CG10377-PC|CG10377-PD|CG10377-PE|CG10377-PF|CG10377-PG|CG10377-PH|Hrb27C-PA|Hrb27C-PB|Hrb27C-PC|Hrb27C-PD|Hrb27C-PE|Hrb27C-PF|Hrb27C-PG|Hrb27C-PH|RNA-binding protein 7|heterogeneous nuclear ribonucleoprotein|heterogeneous nuclear ribonucleoprotein at 27C|linha', map_location='27C4-27C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6920704, end_position_on_the_genomic_accession=6932057, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33969 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33969, CurrentID=0, Status='live', Symbol='CG18304', Aliases='Dmel_ CG13774, Dmel\\CG18304', description='CG18304 gene product from transcript CG18304-RC', other_designations='CG18304-PA|CG18304-PB|CG18304-PC|CG18304-PD|uncharacterized protein', map_location='27C4-27C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6932545, end_position_on_the_genomic_accession=6942814, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  33971 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33971, CurrentID=0, Status='live', Symbol='Fgop2', Aliases='Dmel_CG10158, CG10158, Dmel\\CG10158, FGFR1OP2, FGOP2', description='Fibroblast growth factor receptor 1 oncogene partner 2', other_designations='CG10158-PA|CG10158-PB|Fgop2-PA|Fgop2-PB|fibroblast growth factor receptor 1 oncogene partner 2|fibroblast growth factor receptor 1 oncogene partner 2 ortholog', map_location='27C6-27C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6943178, end_position_on_the_genomic_accession=6945289, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33972 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33972, CurrentID=0, Status='live', Symbol='ihog', Aliases='Dmel_CG9211, CG9211, CT26314, Dmel\\CG9211, Ihog, iHog', description='interference hedgehog', other_designations='CG9211-PA|ihog-PA', map_location='27C6-27C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6945464, end_position_on_the_genomic_accession=6948808, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33973 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33973, CurrentID=0, Status='live', Symbol='Gas41', Aliases='Dmel_CG9207, CG9207, Dmel\\CG9207, GAS41, d', description='CG9207 gene product from transcript CG9207-RA', other_designations='CG9207-PA|Gas41-PA', map_location='27C6-27C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6949310, end_position_on_the_genomic_accession=6950207, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33974 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33974, CurrentID=0, Status='live', Symbol='SA', Aliases='Dmel_CG3423, CG3423, DSA, DSA1, DmSA, Dmel\\CG3423, ESTS:92H2T, SCC3, Scc3', description='Stromalin', other_designations='CG3423-PA|SA-PA|cohesin|stromalin', map_location='27C7-27C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6950421, end_position_on_the_genomic_accession=6954586, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  33975 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33975, CurrentID=0, Status='live', Symbol='CG13775', Aliases='Dmel_ Dmel\\CG13775', description='CG13775 gene product from transcript CG13775-RB', other_designations='CG13775-PA|CG13775-PB|CG13775-PC|uncharacterized protein', map_location='27C7-27C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6954357, end_position_on_the_genomic_accession=6956950, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  33976 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33976, CurrentID=0, Status='live', Symbol='CG3430', Aliases='Dmel_ Dmel\\CG3430', description='CG3430 gene product from transcript CG3430-RA', other_designations='CG3430-PA', map_location='27C7-27C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6957008, end_position_on_the_genomic_accession=6959104, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  33977 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33977, CurrentID=0, Status='live', Symbol='Atac1', Aliases='Dmel_CG9200, CG9200, Dmel\\CG9200, dATAC1', description='Ada2a-containing complex component 1', other_designations='ATAC component 1|Atac1-PA|CG9200-PA', map_location='27C7-27C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6959099, end_position_on_the_genomic_accession=6960328, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  33978 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33978, CurrentID=0, Status='live', Symbol='CG10399', Aliases='Dmel_ 145934_at, Dmel\\CG10399', description='CG10399 gene product from transcript CG10399-RB', other_designations='CG10399-PA|CG10399-PB|uncharacterized protein', map_location='27C7-27C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6960377, end_position_on_the_genomic_accession=6961653, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33979 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33979, CurrentID=0, Status='live', Symbol='sip2', Aliases='Dmel_CG9188, CG9188, Dmel\\CG9188', description='septin interacting protein 2', other_designations='CG9188-PA|CG9188-PB|CG9188-PC|CG9188-PD|CG9188-PE|sip2-PA|sip2-PB|sip2-PC|sip2-PD|sip2-PE', map_location='27C7-27C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6961516, end_position_on_the_genomic_accession=6964074, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33981 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33981, CurrentID=0, Status='live', Symbol='smt3', Aliases='Dmel_CG4494, CG4494, Dm0342, DmSUMO-1, DmSmt3, Dmel\\CG4494, Dm SMT3, SUMO, Smt3, Sumo, anon-EST:Posey240, dSmt3, dsmt3, l(2)04493, l(2)SH0182, l(2)SH2 0182, sumo', description='CG4494 gene product from transcript CG4494-RA', other_designations='CG4494-PA|CG4494-PB|SUMO|SUMO protein|lethal (2) SH0182|small Ubiquitin-like modifier|smt3-PA|smt3-PB', map_location='27C7-27C8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6966780, end_position_on_the_genomic_accession=6967644, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33982 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33982, CurrentID=0, Status='live', Symbol='snRNP-U1-70K', Aliases='Dmel_CG8749, 70K, CG8749, Dm70K, Dmel\\CG8749, U1, U1 70K, U1 70K snRNP, U1 70k, U1 snRNP, U1-70K, U1-70k, U170K, U1snRNP-70K, dU1-70K, l(2)02107, snRNP, snRNP27D, snRNP70K', description='small ribonucleoprotein particle U1 subunit 70K', other_designations='CG8749-PA|CG8749-PC|U1 snRNP-specific 70K protein|small nuclear ribonucleoprotein 70K|snRNP-U1-70K-PA|snRNP-U1-70K-PC', map_location='27C7-27D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6968711, end_position_on_the_genomic_accession=6971737, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33983 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33983, CurrentID=0, Status='live', Symbol='uif', Aliases='Dmel_CG9138, CG9138, CT26172, Dmel\\CG9138, Poly-EGF, SP1070, Uif, poly-EGF, sp1070', description='uninflatable', other_designations='CG9138-PB|CG9138-PC|CG9138-PD|CG9138-PE|CG9138-PF|CG9138-PG|SP1070|uif-PB|uif-PC|uif-PD|uif-PE|uif-PF|uif-PG', map_location='27D1-27D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=6972828, end_position_on_the_genomic_accession=7010359, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  33984 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33984, CurrentID=0, Status='live', Symbol='CG43322', Aliases='Dmel_ CG13776, Dmel\\CG43322', description='CG43322 gene product from transcript CG43322-RA', other_designations='CG43322-PA|uncharacterized protein', map_location='27D4-27D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7013396, end_position_on_the_genomic_accession=7014737, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33985 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33985, CurrentID=0, Status='live', Symbol='Pcp', Aliases='Dmel_CG3440, CG3440, DMCPGART, DmelPcp, Dmel\\CG3440, Gartgart, Pcp', description='Pupal cuticle protein', other_designations='CG3440-PA|Pcp-PA|gart intron gene|gart intronic gene|pupal cuticle protein', map_location='27D4-27D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7021682, end_position_on_the_genomic_accession=7022470, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33986 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33986, CurrentID=0, Status='live', Symbol='ade3', Aliases='Dmel_CG31628, 143062_at, ADE8, Ade3, CG31628, CG8761, D, Dmel\\CG31628, GART, Gart, Gart/ade3, gart, l(2)27Da', description='adenosine 3', other_designations='CG31628-PA|CG31628-PB|CG31628-PC|ade3-PA|ade3-PB|ade3-PC|complementation group D', map_location='27D4-27D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7014623, end_position_on_the_genomic_accession=7023898, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33987 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33987, CurrentID=0, Status='live', Symbol='CG3476', Aliases='Dmel_ Dmel\\CG3476', description='CG3476 gene product from transcript CG3476-RA', other_designations='CG3476-PA', map_location='27D5-27D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7027526, end_position_on_the_genomic_accession=7028959, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  33988 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33988, CurrentID=0, Status='live', Symbol='Rab30', Aliases='Dmel_CG9100, AAF52477, CG9100, Dm Dmel\\CG9100, Q9VM50, Rab-30, rab30', description='CG9100 gene product from transcript CG9100-RB', other_designations='CG9100-PA|CG9100-PB|CG9100-PC|CG9100-PD|Rab30-PA|Rab30-PB|Rab30-PC|Rab30-PD', map_location='27D5-27D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7030493, end_position_on_the_genomic_accession=7032606, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  33989 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33989, CurrentID=0, Status='live', Symbol='Caper', Aliases='Dmel_CG11266, CAPER, CC1.3, CG11266, Dmel\\CG11266, HCC1, cg11266', description='CG11266 gene product from transcript CG11266-RK', other_designations='CG11266-PA|CG11266-PB|CG11266-PH|CG11266-PI|CG11266-PJ|CG11266-PK|CG11266-PL|Caper-PA|Caper-PB|Caper-PH|Caper-PI|Caper-PJ|Caper-PK|Caper-PL|caper', map_location='27D5-27D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7032721, end_position_on_the_genomic_accession=7037878, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  33991 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33991, CurrentID=0, Status='live', Symbol='Mnn1', Aliases='Dmel_CG13778, CG13778, CG33266, Dmel\\CG13778, MEN1, Menin, Menin1, menin, mnn1', description='Menin 1', other_designations='CG13778-PA|CG13778-PB|CG13778-PC|Menin1|Mnn1-PA|Mnn1-PB|Mnn1-PC|menin|menin 1', map_location='27D7-27D7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7056301, end_position_on_the_genomic_accession=7063586, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  33992 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33992, CurrentID=0, Status='live', Symbol='Nuf2', Aliases='Dmel_CG8902, CG8902, Dmel\\CG8902, anon-WO0118547.214, dm l(2)SH2 2276', description='CG8902 gene product from transcript CG8902-RA', other_designations='CG8902-PA|Nuf2-PA', map_location='27D7-27D7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7064431, end_position_on_the_genomic_accession=7065837, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  33993 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33993, CurrentID=0, Status='live', Symbol='CG11289', Aliases='Dmel_ Dmel\\CG11289', description='CG11289 gene product from transcript CG11289-RB', other_designations='CG11289-PB|uncharacterized protein', map_location='27D7-27E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7067983, end_position_on_the_genomic_accession=7069546, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  33994 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33994, CurrentID=0, Status='live', Symbol='Pvf2', Aliases='Dmel_CG13780, CG13780, DmVEGF-2, Dmel\\CG13780, PV2, PVF, PVF2, PVFs, Pvf, VEGF, VEGF-2, VEGF27Cb, Vegf27Cb, pvf2', description='PDGF- and VEGF-related factor 2', other_designations='CG13780-PA|PDGF- and VEGF-receptor related factor 2|Pvf2-PA|VEGF-related factor 2', map_location='27E1-27E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7069536, end_position_on_the_genomic_accession=7084635, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  33995 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33995, CurrentID=0, Status='live', Symbol='Pvf3', Aliases='Dmel_CG34378, CG13781, CG13782, CG13783, CG31629, CG34378, CG4492, DmVEGF-3, Dmel\\CG34378, Dmel_CG13783, Dmel_CG31629, PVF, PVF3, PVFs, Pvf, VEGF, VEGF27Ca, Vegf27Ca, pvf3', description='PDGF- and VEGF-related factor 3', other_designations='CG34378-PA|CG34378-PD|CG34378-PE|CG34378-PF|Pvf3-PA|Pvf3-PD|Pvf3-PE|Pvf3-PF', map_location='27E2-27E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7098188, end_position_on_the_genomic_accession=7157695, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  33999 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=33999, CurrentID=0, Status='live', Symbol='CG4495', Aliases='Dmel_ Dmel\\CG4495', description='CG4495 gene product from transcript CG4495-RB', other_designations='CG4495-PA|CG4495-PB', map_location='27E4-27E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7182234, end_position_on_the_genomic_accession=7185529, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  34000 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34000, CurrentID=0, Status='live', Symbol='CG4496', Aliases='Dmel_ Dmel\\CG4496', description='CG4496 gene product from transcript CG4496-RA', other_designations='CG4496-PA|CG4496-PB|CG4496-PC', map_location='27E4-27E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7185461, end_position_on_the_genomic_accession=7190010, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34001 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34001, CurrentID=0, Status='live', Symbol='CG4497', Aliases='Dmel_ Dmel\\CG4497', description='CG4497 gene product from transcript CG4497-RB', other_designations='CG4497-PA|CG4497-PB', map_location='27E4-27E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7190431, end_position_on_the_genomic_accession=7194588, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34002 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34002, CurrentID=0, Status='live', Symbol='CG4502', Aliases='Dmel_ Dmel\\CG4502, anon-WO0118547.403', description='CG4502 gene product from transcript CG4502-RA', other_designations='CG4502-PA|CG4502-PB', map_location='27E4-27E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7194908, end_position_on_the_genomic_accession=7204264, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34003 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34003, CurrentID=0, Status='live', Symbol='CG13784', Aliases='Dmel_ BcDNA:SD10385, Dmel\\CG13784', description='CG13784 gene product from transcript CG13784-RD', other_designations='CG13784-PB|CG13784-PC|CG13784-PD|CG13784-PE|CG13784-PF|uncharacterized protein', map_location='27E4-27E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7204538, end_position_on_the_genomic_accession=7220033, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34004 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34004, CurrentID=0, Status='live', Symbol='ico', Aliases='Dmel_CG4567, B, CG4567, Dmel\\CG4567, G, GFM1, dEF-G1, l(2)27Cb, l(2)27Ea', description='iconoclast', other_designations='CG4567-PA|complementation group B|complementation group G|ico-PA|lethal (2) 27Cb|lethal (2) 27Ea', map_location='27E5-27F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7220369, end_position_on_the_genomic_accession=7223081, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34005 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34005, CurrentID=0, Status='live', Symbol='Ndae1', Aliases='Dmel_CG42253, 153385_at, CG31906, CG42253, CG4675, Dmel\\CG42253, Dmel_CG31906, Dmel_CG4675, NDAE1, Ndae-1, anon-WO0257455.13, l(2)k10316, ndae1', description='Na[+]-driven anion exchanger 1', other_designations='CG42253-PA|CG42253-PB|CG42253-PC|CG42253-PD|CG42253-PE|CG42253-PF|CG42253-PG|CG42253-PH|CG42253-PI|CG42253-PJ|Ndae1-PA|Ndae1-PB|Ndae1-PC|Ndae1-PD|Ndae1-PE|Ndae1-PF|Ndae1-PG|Ndae1-PH|Ndae1-PI|Ndae1-PJ', map_location='27E6-27E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7223328, end_position_on_the_genomic_accession=7249343, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  34006 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34006, CurrentID=0, Status='live', Symbol='CG13786', Aliases='Dmel_ Dmel\\CG13786', description='CG13786 gene product from transcript CG13786-RB', other_designations='CG13786-PB|uncharacterized protein', map_location='27E7-27E7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7250607, end_position_on_the_genomic_accession=7252982, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34007 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34007, CurrentID=0, Status='live', Symbol='Wnt4', Aliases='Dmel_CG4698, CG4698, DWnt-4, DWnt4, Dm DWnt4, Dmel\\CG4698, Dwnt4, Wnt, Wnt-4, anon-EST:Liang-2.4, clone 2.4, wnt-4, wnt4', description='Wnt oncogene analog 4', other_designations='CG4698-PA|CG4698-PB|Wnt4-PA|Wnt4-PB', map_location='27E7-27E8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7255419, end_position_on_the_genomic_accession=7277171, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34009 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34009, CurrentID=0, Status='live', Symbol='wg', Aliases='Dmel_CG4889, Br, CG4889, DWint-1, DWnt-1, Dint-1, Dm Wg, Dm-1, Dmel\\CG4889, Gla, I, Sp, WG, WNT, Wg, Wnt, Wnt-1, Wnt/Wg, Wnt1, dWnt, fg, int-1, l(2)02657, l(2)rO727, l(2)wg, spdl, wnt, wnt1, wg', description='wingless', other_designations='CG4889-PA|Wnt-1|bristled|complementation group I|flag|glazed|spade|sternopleural|wg-PA', map_location='2-21.9 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7307159, end_position_on_the_genomic_accession=7316265, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34010 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34010, CurrentID=0, Status='live', Symbol='Wnt6', Aliases='Dmel_CG4969, CG4969, D-Wnt-6, DWnt-6, DWnt6, Dmel\\CG4969, wnt6', description='Wnt oncogene analog 6', other_designations='CG4969-PB|CG4969-PC|Wnt6-PB|Wnt6-PC', map_location='27F2-27F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7333714, end_position_on_the_genomic_accession=7352542, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34011 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34011, CurrentID=0, Status='live', Symbol='Wnt10', Aliases='Dmel_CG4971, CG4971, D-Wnt-10, DWnt-10, DWnt10, Dm DWnt10, Dmel\\CG4971, wnt10', description='Wnt oncogene analog 10', other_designations='CG4971-PB|Wnt10-PB', map_location='27F2-27F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7363379, end_position_on_the_genomic_accession=7377528, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34012 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34012, CurrentID=0, Status='live', Symbol='ninaC', Aliases='Dmel_CG5125, 2.2, CG 5125, CG5125, CG54125, CT16120, CT42491, DRONINAC, Dm NinaC, Dmel\\CG5125, NINA C, NINAC, Nina C, NinaC, ninac', description='neither inactivation nor afterpotential C', other_designations='CG5125-PA|CG5125-PB|CG5125-PC|CG5125-PD|NINAC myosin III|droninac|either inactivation nor afterpotential C|myosin III|myosin-III|neither inactivation Nor afterpotential C|neither inactivation nor after potential C|neither inactivation nor afterpotential-C|ninaC-PA|ninaC-PB|ninaC-PC|ninaC-PD', map_location='27F3-27F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7377702, end_position_on_the_genomic_accession=7384344, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  34013 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34013, CurrentID=0, Status='live', Symbol='CG5149', Aliases='Dmel_ Dmel\\CG5149', description='CG5149 gene product from transcript CG5149-RA', other_designations='CG5149-PA', map_location='27F3-27F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7384486, end_position_on_the_genomic_accession=7388253, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34014 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34014, CurrentID=0, Status='live', Symbol='gudu', Aliases='Dmel_CG5155, CG5155, Dmel\\CG5155, Gudu', description='CG5155 gene product from transcript CG5155-RA', other_designations='CG5155-PA|gudu-PA', map_location='27F3-27F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7388508, end_position_on_the_genomic_accession=7390902, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34015 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34015, CurrentID=0, Status='live', Symbol='CG5160', Aliases='Dmel_ Dmel\\CG5160', description='CG5160 gene product from transcript CG5160-RA', other_designations='CG5160-PA|CG5160-PB', map_location='27F3-27F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7390984, end_position_on_the_genomic_accession=7398750, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34016 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34016, CurrentID=0, Status='live', Symbol='CG5171', Aliases='Dmel_ Dmel\\CG5171', description='CG5171 gene product from transcript CG5171-RD', other_designations='CG5171-PA|CG5171-PB|CG5171-PD|CG5171-PE|CG5171-PF', map_location='27F3-27F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7401335, end_position_on_the_genomic_accession=7404727, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34017 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34017, CurrentID=0, Status='live', Symbol='CG5177', Aliases='Dmel_ 21430192, 28603684, Dmel\\CG5177', description='CG5177 gene product from transcript CG5177-RB', other_designations='CG5177-PA|CG5177-PB|trehalose-phosphatase', map_location='27F3-27F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7405227, end_position_on_the_genomic_accession=7408600, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34018 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34018, CurrentID=0, Status='live', Symbol='CG5181', Aliases='Dmel_ Dmel\\CG5181', description='CG5181 gene product from transcript CG5181-RA', other_designations='CG5181-PA', map_location='27F3-27F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7408533, end_position_on_the_genomic_accession=7409809, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34019 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34019, CurrentID=0, Status='live', Symbol='CG15818', Aliases='Dmel_ Dmel\\CG15818', description='CG15818 gene product from transcript CG15818-RA', other_designations='CG15818-PA|uncharacterized protein', map_location='27F3-27F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7410909, end_position_on_the_genomic_accession=7412229, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34021 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34021, CurrentID=0, Status='live', Symbol='CG5261', Aliases='Dmel_ DLAT, Dmel\\CG5261, EP(2)0816, EP816, anon-WO0118547.121', description='CG5261 gene product from transcript CG5261-RB', other_designations='CG5261-PA|CG5261-PB|CG5261-PC|CG5261-PD|CG5261-PE|CG5261-PF|Dihydrolipoyllysine-residue acetyltransferase', map_location='27F4-27F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7426866, end_position_on_the_genomic_accession=7430329, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  34022 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34022, CurrentID=0, Status='live', Symbol='CG5958', Aliases='Dmel_ Dmel\\CG5958', description='CG5958 gene product from transcript CG5958-RA', other_designations='CG5958-PA', map_location='27F4-27F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7430530, end_position_on_the_genomic_accession=7433516, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34023 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34023, CurrentID=0, Status='live', Symbol='CG5973', Aliases='Dmel_ Dmel\\CG5973', description='CG5973 gene product from transcript CG5973-RE', other_designations='CG5973-PA|CG5973-PB|CG5973-PC|CG5973-PD|CG5973-PE|CG5973-PF|CG5973-PG', map_location='27F4-28A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7437492, end_position_on_the_genomic_accession=7445882, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  34024 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34024, CurrentID=0, Status='live', Symbol='santa-maria', Aliases='Dmel_CG12789, BEST:CK01577, CG12789, CK01577, Dmel\\CG12789, Santa Maria, santa maria', description='scavenger receptor acting in neural tissue and majority of rhodopsin is absent', other_designations='CG12789-PA|CG12789-PC|SANTA-MARIA|santa maria|santa-maria-PA|santa-maria-PC', map_location='28A1-28A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7445355, end_position_on_the_genomic_accession=7451244, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34027 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34027, CurrentID=0, Status='live', Symbol='CG6055', Aliases='Dmel_ Dmel\\CG6055', description='CG6055 gene product from transcript CG6055-RA', other_designations='CG6055-PA|CG6055-PB', map_location='28A1-28A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7466543, end_position_on_the_genomic_accession=7472493, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34029 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34029, CurrentID=0, Status='live', Symbol='CG6441', Aliases='Dmel_ Dmel\\CG6441, anon-WO0140519.45', description='CG6441 gene product from transcript CG6441-RA', other_designations='CG6441-PA|CG6441-PC', map_location='28A1-28A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7474704, end_position_on_the_genomic_accession=7476952, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34030 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34030, CurrentID=0, Status='live', Symbol='Ziz', Aliases='Dmel_CG42533, BcDNA:RH71439, CG15819, CG42533, CG6630, Dm ziz, Dmel\\CG42533, Dmel_CG15819, Dmel_CG6630', description='Zizimin ortholog (H. sapiens)', other_designations='CG42533-PB|CG42533-PC|CG42533-PD|CG42533-PE|CG42533-PG|CG42533-PH|CG42533-PI|CG42533-PJ|CG42533-PK|Dm zizimin|Ziz-PB|Ziz-PC|Ziz-PD|Ziz-PE|Ziz-PG|Ziz-PH|Ziz-PI|Ziz-PJ|Ziz-PK|zizimin ortholog', map_location='28A1-28A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7472513, end_position_on_the_genomic_accession=7496307, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  34031 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34031, CurrentID=0, Status='live', Symbol='Obp28a', Aliases='Dmel_CG6641, 28a, CG6641, DmelObp28a, Dmel\\CG6641, PB-PRP5, PBP5, PBPRP-5, PBPRP5, Pbprp5, obp28a, pbprp-5, pbprp5', description='Odorant-binding protein 28a', other_designations='CG6641-PA|Obp28a-PA|Pbprp5|Pheromone-binding protein-related protein 5', map_location='28A4-28A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7496791, end_position_on_the_genomic_accession=7497365, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34032 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34032, CurrentID=0, Status='live', Symbol='RapGAP1', Aliases='Dmel_CG44086, CG13789, CG13790, CG13791, CG33529, CG34374, CG44086, CG6682, Dmel\\CG44086, Dmel_CG13790, Dmel_CG13791, Dmel_CG33529, Dmel_CG34374, Q9VM02_DROME, RapGap1, Rapgap1, rapgap1', description='Rap GTPase activating protein 1', other_designations='CG44086-PD|CG44086-PE|CG44086-PF|CG44086-PH|CG44086-PI|RapGAP1-PD|RapGAP1-PE|RapGAP1-PF|RapGAP1-PH|RapGAP1-PI|Rapgap1', map_location='28A4-28B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7497805, end_position_on_the_genomic_accession=7578980, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34035 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34035, CurrentID=0, Status='live', Symbol='Spn28B', Aliases='Dmel_CG6717, CG6717, Dmel\\CG6717, Spn7', description='Serpin 28B', other_designations='CG6717-PA|CG6717-PB|Spn28B-PA|Spn28B-PB|serine protease inhibitor 7|serpin 28B', map_location='28B3-28B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7581924, end_position_on_the_genomic_accession=7583333, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34036 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34036, CurrentID=0, Status='live', Symbol='Cyp4d21', Aliases='Dmel_CG6730, 4d21, CG6730, Dmel\\CG6730, cyp4d21, sxe1', description='CG6730 gene product from transcript CG6730-RA', other_designations='CG6730-PA|Cyp4d21-PA|cytochrome P450|sex-specific enzyme 1', map_location='28B4-28B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7605600, end_position_on_the_genomic_accession=7607701, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34037 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34037, CurrentID=0, Status='live', Symbol='CG6739', Aliases='Dmel_ Dmel\\CG6739', description='CG6739 gene product from transcript CG6739-RB', other_designations='CG6739-PA|CG6739-PB', map_location='28B4-28B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7608389, end_position_on_the_genomic_accession=7616533, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34038 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34038, CurrentID=0, Status='live', Symbol='Slob', Aliases='Dmel_CG43756, CG13792, CG43756, CG6772, Dmel\\CG43756, Dmel_CG13792, Dmel_CG6772, slob', description='Slowpoke binding protein', other_designations='CG43756-PA|CG43756-PB|CG43756-PC|CG43756-PD|CG43756-PE|CG43756-PF|CG43756-PG|CG43756-PH|CG43756-PI|CG43756-PJ|CG43756-PK|SLO-binding protein|SLOWPOKE-binding protein|Slob-PA|Slob-PB|Slob-PC|Slob-PD|Slob-PE|Slob-PF|Slob-PG|Slob-PH|Slob-PI|Slob-PJ|Slob-PK|giant slob|slowpoke binding protein|slowpoke channel binding protein', map_location='28B4-28C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7642005, end_position_on_the_genomic_accession=7675078, orientation='minus', exon_count=19, OMIM='', no_hdr0=''),
  34041 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34041, CurrentID=0, Status='live', Symbol='CG18585', Aliases='Dmel_ Dmel\\CG18585', description='CG18585 gene product from transcript CG18585-RB', other_designations='CG18585-PA|CG18585-PB|uncharacterized protein', map_location='28C1-28C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7689311, end_position_on_the_genomic_accession=7691061, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34042 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34042, CurrentID=0, Status='live', Symbol='CG7025', Aliases='Dmel_ Dmel\\CG7025', description='CG7025 gene product from transcript CG7025-RA', other_designations='CG7025-PA', map_location='28C1-28C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7691109, end_position_on_the_genomic_accession=7692683, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34044 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34044, CurrentID=0, Status='live', Symbol='Tep2', Aliases='Dmel_CG7052, 145970_at, 145971_at, CG18589, CG7052, Dmel\\CG7052, T13, TEP II, TEP2, TEP2mel, Tep 2, Tep II, TepII, dTEPII, tepII', description='Thioester-containing protein 2', other_designations='CG7052-PA|CG7052-PB|CG7052-PD|CG7052-PF|CG7052-PG|TEP|Tep2-PA|Tep2-PB|Tep2-PD|Tep2-PF|Tep2-PG|thioester containing protein II|thiolester containing protein II', map_location='28C1-28C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7693727, end_position_on_the_genomic_accession=7701601, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  34045 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34045, CurrentID=0, Status='live', Symbol='Tep3', Aliases='Dmel_CG7068, CG7068, Dmel\\CG7068, TEP3, TEP3mel, TEPIII, TepIII, dTEPIII', description='Thioester-containing protein 3', other_designations='CG7068-PA|TEP|Tep3-PA|thiolester containing protein III', map_location='28C1-28C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7702805, end_position_on_the_genomic_accession=7710690, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  34046 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34046, CurrentID=0, Status='live', Symbol='Ntl', Aliases='Dmel_CG7075, CG7075, Dmel\\CG7075, Mp, ntl', description='Neurotransmitter transporter-like', other_designations='CG7075-PA|CG7075-PB|Ntl-PA|Ntl-PB|membrane protein|neurotransmitter transporter-like', map_location='28C-28C', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7710880, end_position_on_the_genomic_accession=7713991, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  34047 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34047, CurrentID=0, Status='live', Symbol='CG13793', Aliases='Dmel_ Dmel\\CG13793', description='CG13793 gene product from transcript CG13793-RB', other_designations='CG13793-PB|uncharacterized protein', map_location='28C1-28C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7716974, end_position_on_the_genomic_accession=7719487, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34048 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34048, CurrentID=0, Status='live', Symbol='CG13794', Aliases='Dmel_ Dmel\\CG13794', description='CG13794 gene product from transcript CG13794-RA', other_designations='CG13794-PA|uncharacterized protein', map_location='28C2-28C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7719847, end_position_on_the_genomic_accession=7722823, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34049 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34049, CurrentID=0, Status='live', Symbol='CG13795', Aliases='Dmel_ CT33284, Dmel\\CG13795', description='CG13795 gene product from transcript CG13795-RC', other_designations='CG13795-PB|CG13795-PC|uncharacterized protein', map_location='28C2-28C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7723045, end_position_on_the_genomic_accession=7726298, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34051 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34051, CurrentID=0, Status='live', Symbol='CG13796', Aliases='Dmel_CG13796-PA, CG18590, CT42497, Dmel\\CG13796', description='CG13796 gene product from transcript CG13796-RD', other_designations='CG13796-PA|CG13796-PB|CG13796-PC|CG13796-PD|uncharacterized protein', map_location='28C2-28C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7727157, end_position_on_the_genomic_accession=7732670, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  34052 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34052, CurrentID=0, Status='live', Symbol='Acp1', Aliases='Dmel_CG7216, CG7216, CG7216-PA, Dacp-1, Dmel\\CG7216, acp1', description='Adult cuticle protein 1', other_designations='Acp1-PA|CG7216-PA|adult cuticle protein 1', map_location='28C2-28C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7740562, end_position_on_the_genomic_accession=7741537, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34053 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34053, CurrentID=0, Status='live', Symbol='CG7214', Aliases='Dmel_ Dmel\\CG7214', description='CG7214 gene product from transcript CG7214-RA', other_designations='CG7214-PA', map_location='28C2-28C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7743682, end_position_on_the_genomic_accession=7744839, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34054 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34054, CurrentID=0, Status='live', Symbol='ATPsynGL', Aliases='Dmel_CG7211, ATPN, CG7211, Dmel\\CG7211', description='ATP synthase, subunit G-like', other_designations='ATP synthase g chain|ATPsynGL-PA|CG7211-PA', map_location='28C2-28C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7747275, end_position_on_the_genomic_accession=7747874, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34055 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34055, CurrentID=0, Status='live', Symbol='CG7203', Aliases='Dmel_ Dmel\\CG7203', description='CG7203 gene product from transcript CG7203-RC', other_designations='CG7203-PB|CG7203-PC', map_location='28C2-28C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7752170, end_position_on_the_genomic_accession=7753186, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34058 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34058, CurrentID=0, Status='live', Symbol='CG7191', Aliases='Dmel_ Dmel\\CG7191', description='CG7191 gene product from transcript CG7191-RA', other_designations='CG7191-PA|CG7191-PB', map_location='28C3-28C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7767628, end_position_on_the_genomic_accession=7775033, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34059 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34059, CurrentID=0, Status='live', Symbol='CG7179', Aliases='Dmel_ CT22169, Dmel\\CG7179, Opa, anon-28Cg, tld-like', description='CG7179 gene product from transcript CG7179-RB', other_designations='CG7179-PB', map_location='28C3-28C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7775804, end_position_on_the_genomic_accession=7778029, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34060 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34060, CurrentID=0, Status='live', Symbol='Uro', Aliases='Dmel_CG7171, CG7171, Dm UO, Dmel\\CG7171, OU, UO, UOX, Uo, anon-WO0140519.210, uro', description='Urate oxidase', other_designations='CG7171-PA|Uro-PA|urate oxidase', map_location='28C3-28C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7780085, end_position_on_the_genomic_accession=7781415, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34061 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34061, CurrentID=0, Status='live', Symbol='CG7164', Aliases='Dmel_ Dmel\\CG7164', description='CG7164 gene product from transcript CG7164-RB', other_designations='CG7164-PA|CG7164-PB', map_location='28C3-28C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7781465, end_position_on_the_genomic_accession=7782760, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34062 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34062, CurrentID=0, Status='live', Symbol='CG7154', Aliases='Dmel_ Dmel\\CG7154', description='CG7154 gene product from transcript CG7154-RA', other_designations='CG7154-PA', map_location='28C3-28C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7782865, end_position_on_the_genomic_accession=7786061, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34063 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34063, CurrentID=0, Status='live', Symbol='CG7149', Aliases='Dmel_ Dmel\\CG7149, cpt, dCCS3', description='CG7149 gene product from transcript CG7149-RB', other_designations='CG7149-PA|CG7149-PB|CG7149-PC|diacylglycerol cholinephosphotransferase', map_location='28C3-28C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7786160, end_position_on_the_genomic_accession=7790557, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34064 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34064, CurrentID=0, Status='live', Symbol='LKRSDH', Aliases='Dmel_CG7144, BEST:CK02318, CG7144, CK02318, Dmel\\CG7144, LKR, SDH, anon-WO0149856.1, dLKR', description='Lysine ketoglutarate reductase/saccharopine dehydrogenase', other_designations='CG7144-PA|CG7144-PB|LKRSDH-PA|LKRSDH-PB|drosophila lysine ketoglutarate reductase|drosophila lysine ketoglutarate reductase (dLKR)/saccharopine dehydrogenase (SDH)|lysine ketoglutarate reductase|lysine ketoglutarate reductase/saccharopine dehydrogenase|saccharopine dehydogenase', map_location='28C4-28C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7791175, end_position_on_the_genomic_accession=7795959, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34065 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34065, CurrentID=0, Status='live', Symbol='Herp', Aliases='Dmel_CG14536, CG1453, CG14536, Dmel\\CG14536, dHerp, herp', description='Homocysteine-induced endoplasmic reticulum protein', other_designations='CG14536-PA|CG14536-PC|Herp-PA|Herp-PC|homocysteine-induced endoplasmic reticulum protein', map_location='28C4-28C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7796314, end_position_on_the_genomic_accession=7800058, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34066 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34066, CurrentID=0, Status='live', Symbol='r2d2', Aliases='Dmel_CG7138, CG7138, Dmel\\CG7138, R2D2, R2d2, cg7138', description='CG7138 gene product from transcript CG7138-RA', other_designations='CG7138-PA|CG7138-PB|CG7138-PC|R2D2|r2d2-PA|r2d2-PB|r2d2-PC', map_location='28C4-28C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7800147, end_position_on_the_genomic_accession=7802098, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34067 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34067, CurrentID=0, Status='live', Symbol='cdc14', Aliases='Dmel_CG7134, CDC-14, CDC14, CG7134, Cdc14, Dmel\\CG7134', description='cell division cycle 14', other_designations='CG7134-PA|CG7134-PB|CG7134-PC|CG7134-PD|CG7134-PE|cdc14-PA|cdc14-PB|cdc14-PC|cdc14-PD|cdc14-PE', map_location='28C4-28C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7801668, end_position_on_the_genomic_accession=7810703, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34068 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34068, CurrentID=0, Status='live', Symbol='LanB1', Aliases='Dmel_CG7123, BcDNA:LD21794, CG7123, CT22015, Dmel\\CG7123, EP-600, LM-B1/beta, Lam-B1, LamB1, Lambeta, Lan B1, LanB, beta1, lamB1, mspl', description='CG7123 gene product from transcript CG7123-RA', other_designations='CG7123-PA|CG7123-PB|LamininB1|LanB1-PA|LanB1-PB|laminin|laminin B1|laminin B1 subunit|laminin beta|laminin beta-chain|laminin beta1|lamininB|misplaced gonads', map_location='28C4-28D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7811438, end_position_on_the_genomic_accession=7820771, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34069 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34069, CurrentID=0, Status='live', Symbol='CG7115', Aliases='Dmel_ BcDNA:LD21794, Dmel\\CG7115, PP2C', description='CG7115 gene product from transcript CG7115-RD', other_designations='CG7115-PA|CG7115-PB|CG7115-PC|CG7115-PD|CG7115-PE', map_location='28D1-28D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7821151, end_position_on_the_genomic_accession=7825350, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34070 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34070, CurrentID=0, Status='live', Symbol='Rack1', Aliases='Dmel_CG7111, CG7111, Dmel\\CG7111, RACK1, dRack1, i173, rack1', description='Receptor of activated protein kinase C 1', other_designations='CG7111-PA|CG7111-PB|CG7111-PC|CG7111-PD|Rack1-PA|Rack1-PB|Rack1-PC|Rack1-PD|guanine nucleotide-binding protein beta-subunit like protein|receptor for activated C kinase 1|receptor for activated protein kinase C1|receptor of activated protein kinase C 1', map_location='28D1-28D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7825347, end_position_on_the_genomic_accession=7827315, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34072 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34072, CurrentID=0, Status='live', Symbol='CG14537', Aliases='Dmel_ BcDNA:AT11469, Dmel\\CG14537', description='CG14537 gene product from transcript CG14537-RA', other_designations='CG14537-PA|uncharacterized protein', map_location='28D2-28D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7840452, end_position_on_the_genomic_accession=7841262, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34073 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34073, CurrentID=0, Status='live', Symbol='CG14535', Aliases='Dmel_ DmKIF26, Dmel\\CG14535, KIF26, KIF26A/B', description='CG14535 gene product from transcript CG14535-RB', other_designations='CG14535-PA|CG14535-PB|kinesin superfamily protein 26|uncharacterized protein', map_location='28D2-28D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7844905, end_position_on_the_genomic_accession=7855475, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34075 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34075, CurrentID=0, Status='live', Symbol='TwdlE', Aliases='Dmel_CG14534, CG14534, Dmel\\CG14534', description='TweedleE', other_designations='CG14534-PA|TwdlE-PA', map_location='28D2-28D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7857957, end_position_on_the_genomic_accession=7860839, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34077 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34077, CurrentID=0, Status='live', Symbol='spz3', Aliases='Dmel_CG7104, CG14533, CG7104, CT21967, CT34263, Dmel\\CG7104, Spz3', description='spatzle 3', other_designations='CG7104-PA|Spz3|spz3-PA', map_location='28D2-28D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7873495, end_position_on_the_genomic_accession=7879552, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34079 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34079, CurrentID=0, Status='live', Symbol='CG7102', Aliases='Dmel_ CG17973, Dmel\\CG7102', description='CG7102 gene product from transcript CG7102-RB', other_designations='CG7102-PA|CG7102-PB', map_location='28D2-28D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7883282, end_position_on_the_genomic_accession=7887513, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34080 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34080, CurrentID=0, Status='live', Symbol='SmE', Aliases='Dmel_CG18591, BcDNA:GM19936, CG18591, Dmel\\CG18591, E, E-Sm, dE, snRNPE', description='Small ribonucleoprotein particle protein SmE', other_designations='CG18591-PA|SmE-PA|small ribonucleoprotein particle protein SmE|snRNPE', map_location='28D2-28D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7884930, end_position_on_the_genomic_accession=7885450, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34082 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34082, CurrentID=0, Status='live', Symbol='Spn28Da', Aliases='Dmel_CG31902, CG12318, CG31902, Dmel\\CG31902', description='Serpin 28Da', other_designations='CG31902-PB|Spn28Da-PB|serpin 28Da', map_location='28D2-28D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7887693, end_position_on_the_genomic_accession=7889129, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  5740878 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740878, CurrentID=0, Status='live', Symbol='CG34280', Aliases='Dmel_ Dmel\\CG34280', description='CG34280 gene product from transcript CG34280-RA', other_designations='CG34280-PA|uncharacterized protein', map_location='90A5-90A5', chromosome='3R', genomic_nucleotide_accession_version='NT_033777.3', start_position_on_the_genomic_accession=17403272, end_position_on_the_genomic_accession=17403718, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34086 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34086, CurrentID=0, Status='live', Symbol='CG7231', Aliases='Dmel_ Dmel\\CG7231', description='CG7231 gene product from transcript CG7231-RE', other_designations='CG7231-PC|CG7231-PD|CG7231-PE|CG7231-PF', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7983946, end_position_on_the_genomic_accession=7986785, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34087 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34087, CurrentID=0, Status='live', Symbol='pes', Aliases='Dmel_CG7228, CG7228, Dmel\\CG7228, Pes', description='peste', other_designations='CG7228-PC|CG7228-PD|CG7228-PE|CG7228-PF|CG7228-PG|CG7228-PH|pes-PC|pes-PD|pes-PE|pes-PF|pes-PG|pes-PH', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7986786, end_position_on_the_genomic_accession=7994184, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34088 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34088, CurrentID=0, Status='live', Symbol='CG7227', Aliases='Dmel_ Dmel\\CG7227', description='CG7227 gene product from transcript CG7227-RC', other_designations='CG7227-PA|CG7227-PB|CG7227-PC', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7994388, end_position_on_the_genomic_accession=7998151, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34089 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34089, CurrentID=0, Status='live', Symbol='Sirup', Aliases='Dmel_CG7224, BcDNA:GH18422, CG7224, Dmel\\CG7224, anon-EST:Posey12, dSdhaf4', description='Starvation-upregulated protein', other_designations='CG7224-PA|CG7224-PC|Sirup-PA|Sirup-PC|starvation-upregulated protein', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7998869, end_position_on_the_genomic_accession=7999676, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34090 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34090, CurrentID=0, Status='live', Symbol='Wwox', Aliases='Dmel_CG7221, CG7221, DmWWOX, Dmel\\CG7221, anon-EST:Posey177', description='WW domain containing oxidoreductase', other_designations='CG7221-PA|CG7221-PB|Wwox-PA|Wwox-PB', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=7999670, end_position_on_the_genomic_accession=8004286, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34091 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34091, CurrentID=0, Status='live', Symbol='Spn28Dc', Aliases='Dmel_CG7219, CG7219, Dm-Spn28D, Dmel\\CG7219, Spn28D, spn28D', description='Serpin 28Dc', other_designations='CG7219-PA|Dm-serpin-28D|Serpin-28D|Spn28Dc-PA|serpin 28D|serpin 28Dc', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8004548, end_position_on_the_genomic_accession=8007210, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34092 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34092, CurrentID=0, Status='live', Symbol='CG12560', Aliases='Dmel_ Dmel\\CG12560', description='CG12560 gene product from transcript CG12560-RC', other_designations='CG12560-PB|CG12560-PC|uncharacterized protein', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8008302, end_position_on_the_genomic_accession=8009477, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34093 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34093, CurrentID=0, Status='live', Symbol='Tg', Aliases='Dmel_CG7356, CG7356, Dmel\\CG7356, TG, dTG', description='Transglutaminase', other_designations='CG7356-PA|CG7356-PB|Tg-PA|Tg-PB|transglutaminase', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8011405, end_position_on_the_genomic_accession=8026898, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34094 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34094, CurrentID=0, Status='live', Symbol='CG7367', Aliases='Dmel_ Dmel\\CG7367, TL', description='CG7367 gene product from transcript CG7367-RD', other_designations='CG7367-PB|CG7367-PC|CG7367-PD', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8026914, end_position_on_the_genomic_accession=8039788, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34095 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34095, CurrentID=0, Status='live', Symbol='baf', Aliases='Dmel_CG7380, BAF, CG7380, Dmel\\CG7380, anon-WO0172774.178, dBAF', description='barrier to autointegration factor', other_designations='Barrier-to-autointegration factor|CG7380-PA|CG7380-PB|baf-PA|baf-PB', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8029462, end_position_on_the_genomic_accession=8030565, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34096 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34096, CurrentID=0, Status='live', Symbol='Cka', Aliases='Dmel_CG7392, 5836, CG7392, CKA, Dcka, Dmel\\CG7392, anon-WO0172774.174, anon-WO0172774.175, anon-WO0172774.177, anon-WO0172774.179, cka, l(2)05836, l(2)s1883', description='Connector of kinase to AP-1', other_designations='CG7392-PA|CG7392-PB|CG7392-PC|CG7392-PD|CG7392-PE|CG7392-PF|CG7392-PG|Cka-PA|Cka-PB|Cka-PC|Cka-PD|Cka-PE|Cka-PF|Cka-PG|WD-40-family-member|connector of kinase to AP-1', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8030721, end_position_on_the_genomic_accession=8040826, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34097 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34097, CurrentID=0, Status='live', Symbol='CCDC53', Aliases='Dmel_CG7429, CG7429, Dmel\\CG7429', description='CG7429 gene product from transcript CG7429-RA', other_designations='CCDC53-PA|CG7429-PA', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8041106, end_position_on_the_genomic_accession=8041879, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34098 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34098, CurrentID=0, Status='live', Symbol='RpL36A', Aliases='Dmel_CG7424, CG7424, Dmel\\CG7424, anon-EST:fe1B2', description='Ribosomal protein L36A', other_designations='CG7424-PA|CG7424-PB|RpL36A-PA|RpL36A-PB|anon-fast-evolving-1B2|ribosomal protein L36A', map_location='28D3-28D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8041873, end_position_on_the_genomic_accession=8042909, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34099 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34099, CurrentID=0, Status='live', Symbol='CG7466', Aliases='Dmel_ Dmel\\CG7466', description='CG7466 gene product from transcript CG7466-RB', other_designations='CG7466-PB|CG7466-PC', map_location='28D3-28D11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8043471, end_position_on_the_genomic_accession=8054326, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34102 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34102, CurrentID=0, Status='live', Symbol='Trf', Aliases='Dmel_CG7562, CG7562, Dmel\\CG7562, TRF, TRF11, X70838, dTRF-1, dTRF1, trf, Trf', description='TBP-related factor', other_designations='CG7562-PA|Trf-PA', map_location='28E1-28E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8072895, end_position_on_the_genomic_accession=8073948, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34105 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34105, CurrentID=0, Status='live', Symbol='CG8673', Aliases='Dmel_ Dmel\\CG8673, GalT5, dbeta3GnT', description='CG8673 gene product from transcript CG8673-RA', other_designations='CG8673-PA', map_location='28E7-28E7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8124329, end_position_on_the_genomic_accession=8125799, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34106 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34106, CurrentID=0, Status='live', Symbol='CG12375', Aliases='Dmel_ Dmel\\CG12375', description='CG12375 gene product from transcript CG12375-RA', other_designations='CG12375-PA|uncharacterized protein', map_location='28E7-28E7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8125668, end_position_on_the_genomic_accession=8126890, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34107 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34107, CurrentID=0, Status='live', Symbol='CG8668', Aliases='Dmel_ Dmel\\CG8668, GalT4, dbeta3GnT', description='CG8668 gene product from transcript CG8668-RB', other_designations='CG8668-PA|CG8668-PB|resille', map_location='28E7-28E7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8127001, end_position_on_the_genomic_accession=8133989, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34109 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34109, CurrentID=0, Status='live', Symbol='PAPLA1', Aliases='Dmel_CG8552, CG14278, CG8552, Dmel\\CG8552, Sec23-IP', description='Phosphatidic Acid Phospholipase A1', other_designations='CG8552-PA|CG8552-PB|CG8552-PD|CG8552-PE|PAPLA1-PA|PAPLA1-PB|PAPLA1-PD|PAPLA1-PE|Sec23-interacting protein|phosphatidic acid phospholipase A1', map_location='28E7-28E9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8134247, end_position_on_the_genomic_accession=8159638, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34110 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34110, CurrentID=0, Status='live', Symbol='Rbsn-5', Aliases='Dmel_CG8506, CG8506, Dmel\\CG8506, EEA1, MENE (2L)-C, MENE(2L)-C, Rbsn, Rbsn5, rbsn, rbsn-5', description='Rabenosyn-5', other_designations='CG8506-PA|Rabenosyn5|Rbsn-5-PA|dRabenosyn|early endosomal antigen 1|rabenosyn', map_location='28E9-28E9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8159832, end_position_on_the_genomic_accession=8161800, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34111 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34111, CurrentID=0, Status='live', Symbol='CG8498', Aliases='Dmel_ Dmel\\CG8498', description='CG8498 gene product from transcript CG8498-RB', other_designations='CG8498-PA|CG8498-PB', map_location='28E9-28E9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8161796, end_position_on_the_genomic_accession=8162452, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34112 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34112, CurrentID=0, Status='live', Symbol='Piezo', Aliases='Dmel_CG44122, CG18103, CG31608, CG44122, CG8486, Dm Dmel\\CG44122, Dmel_CG18103, Dmel_CG8486, Dmpiezo, OrfKD, anon-EST:Liang-1.32, clone 1.32, fos28F, fos500', description='CG44122 gene product from transcript CG44122-RK', other_designations='CG44122-PE|CG44122-PF|CG44122-PG|CG44122-PH|CG44122-PI|CG44122-PJ|CG44122-PK|CG44122-PL|CG44122-PM|CG44122-PO|CG44122-PP|Piezo-PE|Piezo-PF|Piezo-PG|Piezo-PH|Piezo-PI|Piezo-PJ|Piezo-PK|Piezo-PL|Piezo-PM|Piezo-PO|Piezo-PP|dmpiezo|fos-related gene at 28F|piezo', map_location='28F1-28F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8163073, end_position_on_the_genomic_accession=8190137, orientation='plus', exon_count=34, OMIM='', no_hdr0=''),
  246640 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=246640, CurrentID=0, Status='live', Symbol='CG30480', Aliases='Dmel_ CG18373, Dmel\\CG30480', description='CG30480 gene product from transcript CG30480-RB', other_designations='CG30480-PA|CG30480-PB|uncharacterized protein', map_location='51B10-51B10', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=14674606, end_position_on_the_genomic_accession=14678136, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34114 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34114, CurrentID=0, Status='live', Symbol='CG8475', Aliases='Dmel_ Dmel\\CG8475', description='CG8475 gene product from transcript CG8475-RC', other_designations='CG8475-PA|CG8475-PB|CG8475-PC', map_location='28F1-28F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8190808, end_position_on_the_genomic_accession=8196918, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  34115 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34115, CurrentID=0, Status='live', Symbol='CG8460', Aliases='Dmel_ Dmel\\CG8460', description='CG8460 gene product from transcript CG8460-RA', other_designations='CG8460-PA', map_location='28F1-28F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8197193, end_position_on_the_genomic_accession=8198813, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34116 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34116, CurrentID=0, Status='live', Symbol='PGAP5', Aliases='Dmel_CG8455, CG8455, Dmel\\CG8455', description='Post-GPI attachment to proteins 5 ortholog (H. sapiens)', other_designations='CG8455-PA|CG8455-PB|CG8455-PC|PGAP5-PA|PGAP5-PB|PGAP5-PC|Post-GPI attachment to proteins 5 ortholog', map_location='28F1-28F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8198882, end_position_on_the_genomic_accession=8200652, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34117 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34117, CurrentID=0, Status='live', Symbol='SLC5A11', Aliases='Dmel_CG8451, CG8451, CG8451-PA, Dmel\\CG8451', description='Sodium/solute co-transporter-like 5A11', other_designations='CG8451-PA|NA-dependent multivitamin transporter|SLC5A11-PA|cupcake', map_location='28F1-28F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8200465, end_position_on_the_genomic_accession=8205132, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34118 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34118, CurrentID=0, Status='live', Symbol='CG8419', Aliases='Dmel_ Dmel\\CG8419', description='CG8419 gene product from transcript CG8419-RA', other_designations='CG8419-PA', map_location='28F1-28F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8206171, end_position_on_the_genomic_accession=8209637, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34119 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34119, CurrentID=0, Status='live', Symbol='Su(var)205', Aliases='Dmel_CG8409, CBX5, CG8409, DmHP-1, DmHP1, Dmel\\CG8409, E(var)29, E(var)29A, FBgn0003607, HP-1, HP1, HP1-VS, HP1A, HP1a, HP1alpha, Hp1, Hp1a, SU(VAR)205, Su(Var)2-5, Su(var), Su(var)2-05, Su(var)2-5, Su(var)2-501, Su(var)29A, Su(var)[205], Su-var(2)5, Su[Var]205, Su[var]205, Suvar(2)5, Suvar2-5, dHP-1a, dHP1, hp1, hp1a, su(var)205', description='Suppressor of variegation 205', other_designations='C1A9-nuclear-antigen|CG8409-PA|CG8409-PB|Su(var)2-5|Su(var)205-PA|Su(var)205-PB|heterochromatic protein|heterochromatic protein 1a|heterochromatin protein 1|heterochromatin protein 1A|heterochromatin protein-1|heterochromatin-binding protein|heterochromatin-protein-1|histone protein 1|suppressor of variegated 205|suppressor of variegation 205', map_location='2-31.1 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8209626, end_position_on_the_genomic_accession=8211122, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34120 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34120, CurrentID=0, Status='live', Symbol='Ssb-c31a', Aliases='Dmel_CG8396, C31A, CG8396, Dmel\\CG8396, PC4-like, Ssb-C31a, p11', description='Single stranded-binding protein c31A', other_designations='CG8396-PA|Ssb-c31a-PA|single stranded-binding protein c31A', map_location='28F3-28F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8211347, end_position_on_the_genomic_accession=8211938, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34121 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34121, CurrentID=0, Status='live', Symbol='CG8372', Aliases='Dmel_ Dmel\\CG8372', description='CG8372 gene product from transcript CG8372-RA', other_designations='CG8372-PA|CG8372-PB', map_location='28F3-28F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8212039, end_position_on_the_genomic_accession=8212902, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34122 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34122, CurrentID=0, Status='live', Symbol='CG8360', Aliases='Dmel_ BcDNA:LP03131, Dmel\\CG8360', description='CG8360 gene product from transcript CG8360-RC', other_designations='CG8360-PA|CG8360-PC', map_location='28F3-28F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8212959, end_position_on_the_genomic_accession=8214135, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34123 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34123, CurrentID=0, Status='live', Symbol='CG8353', Aliases='Dmel_ Dmel\\CG8353', description='CG8353 gene product from transcript CG8353-RB', other_designations='CG8353-PA|CG8353-PB', map_location='28F3-28F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8214045, end_position_on_the_genomic_accession=8215239, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34124 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34124, CurrentID=0, Status='live', Symbol='CG8349', Aliases='Dmel_ Dmel\\CG8349', description='CG8349 gene product from transcript CG8349-RA', other_designations='CG8349-PA', map_location='28F3-28F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8215915, end_position_on_the_genomic_accession=8216901, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34125 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34125, CurrentID=0, Status='live', Symbol='CG8292', Aliases='Dmel_ Dmel\\CG8292', description='CG8292 gene product from transcript CG8292-RA', other_designations='CG8292-PA', map_location='28F3-28F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8216851, end_position_on_the_genomic_accession=8218017, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34126 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34126, CurrentID=0, Status='live', Symbol='Snx6', Aliases='Dmel_CG8282, CG8282, DmSNX6, Dmel\\CG8282, Dsnx6, SNX6', description='Sorting nexin 6', other_designations='CG8282-PA|CG8282-PB|Snx6-PA|Snx6-PB|sorting nexin 6', map_location='28F3-28F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8218071, end_position_on_the_genomic_accession=8220741, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34127 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34127, CurrentID=0, Status='live', Symbol='Pvr', Aliases='Dmel_CG8222, 8222, CG8222, CT24332, DmVEGFR, Dmel\\CG8222, PVR, VEGFR, VEGFR-A, VGR1, Vegf, Vegfr, Vegfr-b, Vegfr-c, Vgr1, pvr, stai, vgr1', description='PDGF- and VEGF-receptor related', other_designations='CG8222-PA|CG8222-PB|CG8222-PD|CG8222-PE|CG8222-PG|CG8222-PH|CG8222-PI|CG8222-PJ|CG8222-PK|CG8222-PL|CG8222-PM|CG8222-PN|CG8222-PO|PDGF- and VEGF receptor related|PDGF- and VEGF- receptor related|PDGF- and VEGF-Receptor related|PDGF- and VEGF-related receptor|PDGF/VEGF receptor|PVF receptor|Pvr-PA|Pvr-PB|Pvr-PD|Pvr-PE|Pvr-PG|Pvr-PH|Pvr-PI|Pvr-PJ|Pvr-PK|Pvr-PL|Pvr-PM|Pvr-PN|Pvr-PO|VEGF receptor|platelet-derived growth factor/vascular endothelial growth factor receptor|stasis|vascular endothelial growth factor receptor|vascular endothelial growth factor receptor-1 like', map_location='28F4-28F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8220980, end_position_on_the_genomic_accession=8239878, orientation='minus', exon_count=22, OMIM='', no_hdr0=''),
  34129 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34129, CurrentID=0, Status='live', Symbol='CG14277', Aliases='Dmel_ Dmel\\CG14277', description='CG14277 gene product from transcript CG14277-RB', other_designations='CG14277-PA|CG14277-PB|uncharacterized protein', map_location='28F5-28F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8242486, end_position_on_the_genomic_accession=8243426, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34131 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34131, CurrentID=0, Status='live', Symbol='CG8086', Aliases='Dmel_ CG8113, Dmel\\CG8086', description='CG8086 gene product from transcript CG8086-RK', other_designations='CG8086-PA|CG8086-PB|CG8086-PG|CG8086-PH|CG8086-PI|CG8086-PJ|CG8086-PK|CG8086-PL|CG8086-PM|CG8086-PN|CG8086-PO|CG8086-PP', map_location='28F5-29A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8244160, end_position_on_the_genomic_accession=8257502, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  34132 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34132, CurrentID=0, Status='live', Symbol='Btk29A', Aliases='Dmel_CG8049, Btk, Btk29a, C-src2, C-src4, CG18355, CG8049, CT2415, CT41718, DSrc28, DTec29, Dm SRC2, Dmel\\CG8049, Dsrc28C, Dsrc29A, EC2-9, S13, SRC 29A, Src2, Src29A, Tec, Tec29, Tec29A, btk, btk29, btk29A, btk29a, c-src/fps, dsrc29A, fic, src-4, src2, src28C, src4, tec29', description='Btk family kinase at 29A', other_designations='Btk29A type 2|Btk29A-PA|Btk29A-PB|Btk29A-PC|Btk29A-PD|Btk29A-PE|Btk29A-PF|Btk29A-PG|Btk29A-PH|CG8049-PA|CG8049-PB|CG8049-PC|CG8049-PD|CG8049-PE|CG8049-PF|CG8049-PG|CG8049-PH|Src oncogene 29A|fickle', map_location='29A1-29A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8258373, end_position_on_the_genomic_accession=8301079, orientation='minus', exon_count=18, OMIM='', no_hdr0=''),
  34134 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34134, CurrentID=0, Status='live', Symbol='wol', Aliases='Dmel_CG7870, ALG5, CG7870, Dmel\\CG7870, Wol, alg5, dAlg5', description='wollknaeuel', other_designations='CG7870-PA|wol-PA|wollknauel', map_location='29A3-29A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8301345, end_position_on_the_genomic_accession=8302985, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34135 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34135, CurrentID=0, Status='live', Symbol='Scgalpha', Aliases='Dmel_CG7851, CG7851, DmSCG-alphaepsilon, Dmel\\CG7851, Scga', description='Sarcoglycan alpha', other_designations='CG7851-PA|CG7851-PB|CG7851-PC|Scgalpha-PA|Scgalpha-PB|Scgalpha-PC|sarcoglycan alpha', map_location='29A3-29A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8303429, end_position_on_the_genomic_accession=8305376, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34136 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34136, CurrentID=0, Status='live', Symbol='CG7840', Aliases='Dmel_ Dmel\\CG7840, cg7840', description='CG7840 gene product from transcript CG7840-RA', other_designations='CG7840-PA', map_location='29A3-29A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8305586, end_position_on_the_genomic_accession=8306741, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34137 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34137, CurrentID=0, Status='live', Symbol='Ostgamma', Aliases='Dmel_CG7830, CG7830, Dmel\\CG7830, MagT1, OST, dMagT1', description='Oligosaccharide transferase gamma subunit', other_designations='CG7830-PA|Ostgamma-PA|magnesium transporter subtype 1|oligosaccharide transferase gamma subunit', map_location='29A3-29A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8306696, end_position_on_the_genomic_accession=8308192, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34138 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34138, CurrentID=0, Status='live', Symbol='CG7818', Aliases='Dmel_ Dmel\\CG7818', description='CG7818 gene product from transcript CG7818-RA', other_designations='CG7818-PA', map_location='29A3-29A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8308427, end_position_on_the_genomic_accession=8309961, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34139 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34139, CurrentID=0, Status='live', Symbol='CG7810', Aliases='Dmel_ Dmel\\CG7810', description='CG7810 gene product from transcript CG7810-RA', other_designations='CG7810-PA', map_location='29A3-29A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8309876, end_position_on_the_genomic_accession=8311195, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34140 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34140, CurrentID=0, Status='live', Symbol='CG7806', Aliases='Dmel_ Dme_CG7806, Dmel\\CG7806', description='CG7806 gene product from transcript CG7806-RA', other_designations='CG7806-PA', map_location='29A3-29A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8311399, end_position_on_the_genomic_accession=8317011, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34141 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34141, CurrentID=0, Status='live', Symbol='mtsh', Aliases='Dmel_CG7795, CG7795, Dmel\\CG7795', description='mitoshell', other_designations='CG7795-PC|CG7795-PD|mtsh-PC|mtsh-PD', map_location='29A4-29A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8316889, end_position_on_the_genomic_accession=8319908, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34142 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34142, CurrentID=0, Status='live', Symbol='CG7787', Aliases='Dmel_ BcDNA:RE45155, Dmel\\CG7787', description='CG7787 gene product from transcript CG7787-RA', other_designations='CG7787-PA', map_location='29A4-29A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8320328, end_position_on_the_genomic_accession=8321285, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34143 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34143, CurrentID=0, Status='live', Symbol='CG7781', Aliases='Dmel_ Dmel\\CG7781', description='CG7781 gene product from transcript CG7781-RB', other_designations='CG7781-PA|CG7781-PB', map_location='29A4-29A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8321280, end_position_on_the_genomic_accession=8325409, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34144 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34144, CurrentID=0, Status='live', Symbol='CG14275', Aliases='Dmel_ BcDNA:RE73208, CT33900, Dmel\\CG14275', description='CG14275 gene product from transcript CG14275-RA', other_designations='CG14275-PA|CG14275-PB|uncharacterized protein', map_location='29A5-29A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8327456, end_position_on_the_genomic_accession=8332911, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34145 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34145, CurrentID=0, Status='live', Symbol='CG14274', Aliases='Dmel_ Dmel\\CG14274', description='CG14274 gene product from transcript CG14274-RA', other_designations='CG14274-PA|uncharacterized protein', map_location='29A5-29B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8338287, end_position_on_the_genomic_accession=8342056, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34146 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34146, CurrentID=0, Status='live', Symbol='CG14273', Aliases='Dmel_ Dmel\\CG14273', description='CG14273 gene product from transcript CG14273-RA', other_designations='CG14273-PA|uncharacterized protein', map_location='29B1-29B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8342695, end_position_on_the_genomic_accession=8344378, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34147 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34147, CurrentID=0, Status='live', Symbol='CG7778', Aliases='Dmel_ Dmel\\CG7778', description='CG7778 gene product from transcript CG7778-RB', other_designations='CG7778-PA|CG7778-PB', map_location='29B1-29B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8346620, end_position_on_the_genomic_accession=8351112, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34148 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34148, CurrentID=0, Status='live', Symbol='CG7627', Aliases='Dmel_ Dme_CG7627, Dmel\\CG7627', description='CG7627 gene product from transcript CG7627-RB', other_designations='CG7627-PA|CG7627-PB', map_location='29B1-29B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8355678, end_position_on_the_genomic_accession=8362469, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34149 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34149, CurrentID=0, Status='live', Symbol='RpS13', Aliases='Dmel_CG13389, CG13389, Dmel\\CG13389, M(2)29B, M(2)32, M(2)32A, RPS13, Rp S13, Rp17, S13, l(2)k09614', description='Ribosomal protein S13', other_designations='CG13389-PA|CG13389-PB|CG13389-PC|Minute(2)32A|RpS13-PA|RpS13-PB|RpS13-PC|ribosomal protein S13|ribosomal protein S17', map_location='29B1-29B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8363477, end_position_on_the_genomic_accession=8364662, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34152 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34152, CurrentID=0, Status='live', Symbol='CG17292', Aliases='Dmel_ Dmel\\CG17292', description='CG17292 gene product from transcript CG17292-RD', other_designations='CG17292-PA|CG17292-PB|CG17292-PC|CG17292-PD|uncharacterized protein', map_location='29B2-29B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8370454, end_position_on_the_genomic_accession=8374250, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34153 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34153, CurrentID=0, Status='live', Symbol='Wdr82', Aliases='Dmel_CG17293, CG17293, Dmel\\CG17293, WDR82, dWdr82, wdr-82, wdr82', description='WD repeat domain 82', other_designations='CG17293-PA|Wdr82-PA', map_location='29B2-29B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8374461, end_position_on_the_genomic_accession=8375549, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34154 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34154, CurrentID=0, Status='live', Symbol='CG13390', Aliases='Dmel_ Dmel\\CG13390', description='CG13390 gene product from transcript CG13390-RA', other_designations='CG13390-PA|uncharacterized protein', map_location='29B3-29B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8375502, end_position_on_the_genomic_accession=8376797, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34155 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34155, CurrentID=0, Status='live', Symbol='CG17294', Aliases='Dmel_ 15010468, Dmel\\CG17294, Phos17294', description='CG17294 gene product from transcript CG17294-RA', other_designations='CG17294-PA|uncharacterized protein', map_location='29B3-29B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8377035, end_position_on_the_genomic_accession=8378206, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34156 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34156, CurrentID=0, Status='live', Symbol='Aats-ala', Aliases='Dmel_CG13391, ARS, AlaRS, CG13391, Dmel\\CG13391, alaS', description='Alanyl-tRNA synthetase', other_designations='Aats-ala-PA|Aats-ala-PB|CG13391-PA|CG13391-PB', map_location='29B3-29B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8378262, end_position_on_the_genomic_accession=8381764, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34157 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34157, CurrentID=0, Status='live', Symbol='CG13392', Aliases='Dmel_ Dmel\\CG13392', description='CG13392 gene product from transcript CG13392-RB', other_designations='CG13392-PA|CG13392-PB|uncharacterized protein', map_location='29B3-29B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8381821, end_position_on_the_genomic_accession=8382807, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34158 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34158, CurrentID=0, Status='live', Symbol='Rcd4', Aliases='Dmel_CG17295, BcDNA:SD16838, CG17295, Dmel\\CG17295', description='Reduction in Cnn dots 4', other_designations='CG17295-PA|CG17295-PB|Rcd4-PA|Rcd4-PB|reduction in Cnn dots 4', map_location='29B4-29B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8382861, end_position_on_the_genomic_accession=8383657, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34159 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34159, CurrentID=0, Status='live', Symbol='l(2)k12914', Aliases='Dmel_CG13393, BcDNA:RE23864, CG13393, Dmel\\CG13393, OST', description='lethal (2) k12914', other_designations='CG13393-PA|l(2)k12914-PA', map_location='29C1-29B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8383612, end_position_on_the_genomic_accession=8384137, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34160 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34160, CurrentID=0, Status='live', Symbol='CG13384', Aliases='Dmel_ Dmel\\CG13384', description='CG13384 gene product from transcript CG13384-RD', other_designations='CG13384-PB|CG13384-PC|CG13384-PD|CG13384-PE|CG13384-PF|CG13384-PG|CG13384-PH|CG13384-PI|CG13384-PJ|CG13384-PK|CG13384-PL|uncharacterized protein', map_location='29B4-29C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8384455, end_position_on_the_genomic_accession=8388804, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34161 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34161, CurrentID=0, Status='live', Symbol='CG42820', Aliases='Dmel_ CG13394, Dmel\\CG42820, Dmel_CG13394', description='CG42820 gene product from transcript CG42820-RA', other_designations='CG42820-PA|uncharacterized protein', map_location='29C1-29C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8389881, end_position_on_the_genomic_accession=8392398, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34162 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34162, CurrentID=0, Status='live', Symbol='Acp29AB', Aliases='Dmel_CG17797, AC 004423B, AC004423b, Acp29-II, Acp29B, CG17797, Dmel\\CG17797, Acp29AB', description='Accessory gland protein 29AB', other_designations='Acp29AB-PA|CG17797-PA|accessory gland protein|accessory gland protein 29AB|accessory gland-specific peptide 29AB', map_location='29C1-29C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8392456, end_position_on_the_genomic_accession=8393222, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  19835795 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=19835795, CurrentID=0, Status='live', Symbol='CG45093', Aliases='Dmel_ Dmel\\CG45093', description='CG45093 gene product from transcript CG45093-RD', other_designations='CG45093-PA|CG45093-PB|CG45093-PC|CG45093-PD|uncharacterized protein', map_location='43E13-43E16', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=7737019, end_position_on_the_genomic_accession=7782637, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34164 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34164, CurrentID=0, Status='live', Symbol='CG13385', Aliases='Dmel_ Dmel\\CG13385', description='CG13385 gene product from transcript CG13385-RA', other_designations='CG13385-PA|uncharacterized protein', map_location='29C1-29C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8396649, end_position_on_the_genomic_accession=8397886, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34165 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34165, CurrentID=0, Status='live', Symbol='CG13386', Aliases='Dmel_ Dmel\\CG13386', description='CG13386 gene product from transcript CG13386-RA', other_designations='CG13386-PA|uncharacterized protein', map_location='29C1-29C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8399021, end_position_on_the_genomic_accession=8400078, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34166 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34166, CurrentID=0, Status='live', Symbol='fy', Aliases='Dmel_CG13396, CG13396, Dmel\\CG13396', description='fuzzy', other_designations='CG13396-PA|CG13396-PB|fy-PA|fy-PB', map_location='2-24.1 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8401476, end_position_on_the_genomic_accession=8403280, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34167 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34167, CurrentID=0, Status='live', Symbol='emb', Aliases='Dmel_CG13387, CG13387, CRM1, Crm1, DCRM1, Dmel\\CG13387, Emb, XPO-1, XPO1, Xpo1, crm1, dCRM1, l(2)k16715', description='embargoed', other_designations='CG13387-PA|CG13387-PB|Exportin-1|chromosomal region maintenance 1|emb-PA|emb-PB|exportin', map_location='29C1-29C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8403573, end_position_on_the_genomic_accession=8408853, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34169 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34169, CurrentID=0, Status='live', Symbol='CG13398', Aliases='Dmel_ Dmel\\CG13398', description='CG13398 gene product from transcript CG13398-RB', other_designations='CG13398-PA|CG13398-PB|uncharacterized protein', map_location='29C3-29C3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8412144, end_position_on_the_genomic_accession=8415256, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34170 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34170, CurrentID=0, Status='live', Symbol='Akap200', Aliases='Dmel_CG13388, AKAP200, Akap 200, BcDNA:LP02734, CG13388, DAKAP200, Dmel\\CG13388, EP(2)2254, MESR2, akap200, anon-WO0118547.134, anon-WO0118547.213, dpo', description='A kinase anchor protein 200', other_designations='A kinase anchor protein|Akap200-PA|Akap200-PB|Akap200-PC|Akap200-PD|Akap200-PE|Akap200-PF|Akap200-PG|CG13388-PA|CG13388-PB|CG13388-PC|CG13388-PD|CG13388-PE|CG13388-PF|CG13388-PG', map_location='29C3-29C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8415690, end_position_on_the_genomic_accession=8431297, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34171 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34171, CurrentID=0, Status='live', Symbol='grk', Aliases='Dmel_CG17610, CG17610, CT32746, Dmel\\CG17610, GRK, Grk, s-Grk', description='gurken', other_designations='CG17610-PA|grk-PA', map_location='2-30 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8431086, end_position_on_the_genomic_accession=8433598, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34172 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34172, CurrentID=0, Status='live', Symbol='D12', Aliases='Dmel_CG13400, CG13400, Dmel\\CG13400, Yeats2', description='CG13400 gene product from transcript CG13400-RA', other_designations='CG13400-PA|D12-PA', map_location='29C4-29C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8434058, end_position_on_the_genomic_accession=8437365, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34175 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34175, CurrentID=0, Status='live', Symbol='U26', Aliases='Dmel_CG13401, CG13401, Dmel\\CG13401', description='CG13401 gene product from transcript CG13401-RA', other_designations='CG13401-PA|CG13401-PC|CG13401-PD|U26-PA|U26-PC|U26-PD', map_location='29C5-29C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8445861, end_position_on_the_genomic_accession=8449576, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34176 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34176, CurrentID=0, Status='live', Symbol='fu12', Aliases='Dmel_CG17608, AGPAT1, AGPAT2, CG17608, Dmel\\CG17608', description='CG17608 gene product from transcript CG17608-RA', other_designations='CG17608-PA|CG17608-PB|CG17608-PC|CG17608-PD|fu12-PA|fu12-PB|fu12-PC|fu12-PD', map_location='29C5-29D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8449691, end_position_on_the_genomic_accession=8463994, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34177 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34177, CurrentID=0, Status='live', Symbol='fu2', Aliases='Dmel_CG9233, CG9233, Dmel\\CG9233, FU12', description='CG9233 gene product from transcript CG9233-RB', other_designations='CG9233-PA|CG9233-PB|fu2-PA|fu2-PB', map_location='29D1-29D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8464488, end_position_on_the_genomic_accession=8466694, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34179 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34179, CurrentID=0, Status='live', Symbol='d', Aliases='Dmel_CG42840, 29C3-D1, 29CD, AAF52683, CG10595, CG13087, CG31610, CG42840, D, DmMyo20, Dmel\\CG42840, Dmel_CG10595, Dmel_CG13087, Ds, Myo29D, anon-EST:Liang-1.78, clone 1.78, l(2)c00146', description='dachs', other_designations='CG42840-PD|CG42840-PE|d-PD|d-PE|lethal (2) c00146|myosin 29D|unconventional myosin 29D', map_location='2-31.0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8466817, end_position_on_the_genomic_accession=8488671, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  34180 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34180, CurrentID=0, Status='live', Symbol='CG13088', Aliases='Dmel_ Dmel\\CG13088, FBXO15', description='CG13088 gene product from transcript CG13088-RA', other_designations='CG13088-PA|uncharacterized protein', map_location='29D1-29D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8488981, end_position_on_the_genomic_accession=8490546, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34181 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34181, CurrentID=0, Status='live', Symbol='Dh31', Aliases='Dmel_CG13094, CG13094, DH 31, DH-II, DH31, DH[[31], DH[[31]], Dh[[31]], Dmel\\CG13094, Drm-DH[[31]], Drome-DH[[31]], anon-EST:Posey114, anon-WO02059370.45, dh31, drome-DH31', description='Diuretic hormone 31', other_designations='CG13094-PA|CG13094-PC|Calcitonin-like diuretic hormone (31 residues)|Dh31-PA|Dh31-PC|calcitonin|diuretic hormone|diuretic hormone 31', map_location='29D1-29D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8491868, end_position_on_the_genomic_accession=8506845, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34182 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34182, CurrentID=0, Status='live', Symbol='Bace', Aliases='Dmel_CG13095, CG13095, Dmel\\CG13095, anon-WO0140519.142, dBACE, dBace', description='beta-site APP-cleaving enzyme', other_designations='Bace-PA|Bace-PB|CG13095-PA|CG13095-PB', map_location='29D2-29D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8494893, end_position_on_the_genomic_accession=8496307, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34183 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34183, CurrentID=0, Status='live', Symbol='CG13096', Aliases='Dmel_ Dmel\\CG13096', description='CG13096 gene product from transcript CG13096-RB', other_designations='CG13096-PA|CG13096-PB|uncharacterized protein', map_location='29D3-29D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8509069, end_position_on_the_genomic_accession=8511866, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34184 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34184, CurrentID=0, Status='live', Symbol='CG13097', Aliases='Dmel_ Dmel\\CG13097', description='CG13097 gene product from transcript CG13097-RA', other_designations='CG13097-PA|uncharacterized protein', map_location='29D3-29D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8512174, end_position_on_the_genomic_accession=8514868, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34185 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34185, CurrentID=0, Status='live', Symbol='PIG-U', Aliases='Dmel_CG13089, CG13089, Dmel\\CG13089', description='Phosphatidylinositol glycan anchor biosynthesis, class U ortholog (H. sapiens)', other_designations='CG13089-PA|PIG-U-PA|phosphatidylinositol glycan anchor biosynthesis, class U ortholog', map_location='29D4-29D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8515096, end_position_on_the_genomic_accession=8516755, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34186 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34186, CurrentID=0, Status='live', Symbol='mRpL51', Aliases='Dmel_CG13098, CG13098, Dmel\\CG13098, MRP-L51', description='mitochondrial ribosomal protein L51', other_designations='CG13098-PA|mRpL51-PA', map_location='29D4-29D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8516753, end_position_on_the_genomic_accession=8517380, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34187 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34187, CurrentID=0, Status='live', Symbol='CG13090', Aliases='Dmel_ Dmel\\CG13090, dMoaD', description='CG13090 gene product from transcript CG13090-RC', other_designations='CG13090-PA|CG13090-PB|CG13090-PC|Uba4 homologue|uncharacterized protein', map_location='29D4-29D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8517411, end_position_on_the_genomic_accession=8519176, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34188 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34188, CurrentID=0, Status='live', Symbol='CG13091', Aliases='Dmel_ CT32316, Dmel\\CG13091', description='CG13091 gene product from transcript CG13091-RB', other_designations='CG13091-PA|CG13091-PB|uncharacterized protein', map_location='29D4-29D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8519690, end_position_on_the_genomic_accession=8521809, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34189 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34189, CurrentID=0, Status='live', Symbol='Acer', Aliases='Dmel_CG10593, ACE, ACER, CG10593, Dmel\\CG10593, acer, l(2)k07704', description='Angiotensin-converting enzyme-related', other_designations='Acer-PA|Acer-PB|CG10593-PA|CG10593-PB|angiotensin-converting enzyme-related', map_location='29D4-29D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8521933, end_position_on_the_genomic_accession=8525740, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34191 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34191, CurrentID=0, Status='live', Symbol='CG17834', Aliases='Dmel_ BcDNA:LP07538, Dmel\\CG17834, anon-290a, anon-29Da', description='CG17834 gene product from transcript CG17834-RA', other_designations='CG17834-PA|CG17834-PB|CG17834-PC|CG17834-PD|CG17834-PE|CG17834-PF|uncharacterized protein', map_location='29D5-29E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8529141, end_position_on_the_genomic_accession=8541439, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34192 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34192, CurrentID=0, Status='live', Symbol='Sema-1a', Aliases='Dmel_CG18405, BcDNA:RE36155, CG18405, CT26404, D-Sema 1a, D-Sema I, D-Sema-I, D-SemaI, D-semaI, Dmel\\CG18405, Dsema 1a, Dsema-I, Fas-IV, FasIV, SEMA-1A, Sema 1a, Sema-I, Sema1A, Sema1a, SemaI, d-sema I, d-semaI, l(2)k13702, sema, sema 1a, sema-1a, sema-I, sema1a', description='CG18405 gene product from transcript CG18405-RE', other_designations='CG18405-PA|CG18405-PD|CG18405-PE|CG18405-PF|CG18405-PG|CG18405-PH|CG18405-PI|Fasciclin-IV|Sema-1a-PA|Sema-1a-PD|Sema-1a-PE|Sema-1a-PF|Sema-1a-PG|Sema-1a-PH|Sema-1a-PI|Semaphorin-1|Semaphorin-1A|semaphorin|semaphorin 1|semaphorin 1a|semaphorin I|semaphorin1a|semiphorin', map_location='29E1-29E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8542147, end_position_on_the_genomic_accession=8672041, orientation='plus', exon_count=24, OMIM='', no_hdr0=''),
  34193 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34193, CurrentID=0, Status='live', Symbol='Glt', Aliases='Dmel_CG9280, CG9280, CT26441, Dmel\\CG9280', description='Glutactin', other_designations='CG9280-PA|CG9280-PD|Glt-PA|Glt-PD|glutactin', map_location='29E3-29E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8672698, end_position_on_the_genomic_accession=8676804, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34194 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34194, CurrentID=0, Status='live', Symbol='CG9287', Aliases='Dmel_ Dmel\\CG9287', description='CG9287 gene product from transcript CG9287-RA', other_designations='CG9287-PA', map_location='29E3-29E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8676777, end_position_on_the_genomic_accession=8679812, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34195 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34195, CurrentID=0, Status='live', Symbol='CG9289', Aliases='Dmel_ CT26467, Dmel\\CG9289', description='CG9289 gene product from transcript CG9289-RA', other_designations='CG9289-PA|glutactin-like', map_location='29E3-29E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8681325, end_position_on_the_genomic_accession=8684376, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34196 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34196, CurrentID=0, Status='live', Symbol='PrBP', Aliases='Dmel_CG9296, CG9296, DmPrBP, DmPrBP/delta, Dmel\\CG9296', description='Prenyl-binding protein', other_designations='CG9296-PA|PrBP-PA', map_location='29E3-29E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8684823, end_position_on_the_genomic_accession=8685955, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34197 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34197, CurrentID=0, Status='live', Symbol='Trs23', Aliases='Dmel_CG9298, CG9298, Dmel\\CG9298, TRS23p, Trs23', description='TRAPP subunit 23 ortholog (S. cerevisiae)', other_designations='CG9298-PA|TRAPP subunit 23 ortholog|Trs23-PA', map_location='29E3-29E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8686231, end_position_on_the_genomic_accession=8687052, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34198 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34198, CurrentID=0, Status='live', Symbol='CG9314', Aliases='Dmel_ CT26521, CatB, Dmel\\CG9314, anon-WO0140519.249', description='CG9314 gene product from transcript CG9314-RC', other_designations='CG9314-PA|CG9314-PC|catalase B|kitty', map_location='29E4-29E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8705572, end_position_on_the_genomic_accession=8707527, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34202 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34202, CurrentID=0, Status='live', Symbol='CG12438', Aliases='Dmel_ Dmel\\CG12438', description='CG12438 gene product from transcript CG12438-RA', other_designations='CG12438-PA|uncharacterized protein', map_location='29E6-29E6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8752285, end_position_on_the_genomic_accession=8753209, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34203 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34203, CurrentID=0, Status='live', Symbol='LManIII', Aliases='Dmel_CG9463, CG9463, Dmel\\CG9463', description='Lysosomal alpha-mannosidase III', other_designations='CG9463-PA|CG9463-PB|LManIII-PA|LManIII-PB|lysosomal alpha-mannosidase III', map_location='29F1-29F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8765273, end_position_on_the_genomic_accession=8768710, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34204 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34204, CurrentID=0, Status='live', Symbol='LManIV', Aliases='Dmel_CG9465, CG9465, Dmel\\CG9465', description='Lysosomal alpha-mannosidase IV', other_designations='CG9465-PB|LManIV-PB|lysosomal alpha-mannosidase IV', map_location='29F1-29F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8769159, end_position_on_the_genomic_accession=8772344, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34205 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34205, CurrentID=0, Status='live', Symbol='LManV', Aliases='Dmel_CG9466, CG9466, Dmel\\CG9466', description='Lysosomal alpha-mannosidase V', other_designations='CG9466-PA|CG9466-PB|LManV-PA|LManV-PB|lysosomal alpha-mannosidase V', map_location='29F1-29F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8772946, end_position_on_the_genomic_accession=8776263, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34206 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34206, CurrentID=0, Status='live', Symbol='LManVI', Aliases='Dmel_CG9468, CG9468, Dmel\\CG9468', description='Lysosomal alpha-mannosidase VI', other_designations='CG9468-PA|LManVI-PA|lysosomal alpha-mannosidase VI', map_location='29F1-29F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8777661, end_position_on_the_genomic_accession=8781252, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  5740101 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740101, CurrentID=0, Status='live', Symbol='CG34459', Aliases='Dmel_ CG6301, Dmel\\CG34459, Dmel_CG6301', description='CG34459 gene product from transcript CG34459-RC', other_designations='CG34459-PA|CG34459-PB|CG34459-PC|uncharacterized protein', map_location='53D11-53D11', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=16824664, end_position_on_the_genomic_accession=16826648, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34208 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34208, CurrentID=0, Status='live', Symbol='CG32986', Aliases='Dmel_ CG15866, Dmel\\CG32986', description='CG32986 gene product from transcript CG32986-RA', other_designations='CG32986-PA|uncharacterized protein', map_location='29F3-29F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8862776, end_position_on_the_genomic_accession=8863743, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34209 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34209, CurrentID=0, Status='live', Symbol='CG9483', Aliases='Dmel_ Dmel\\CG9483, anon-WO0140519.161', description='CG9483 gene product from transcript CG9483-RA', other_designations='CG9483-PA', map_location='29F3-29F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8866767, end_position_on_the_genomic_accession=8867686, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34211 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34211, CurrentID=0, Status='live', Symbol='Tsp29Fa', Aliases='Dmel_CG9494, CG9494, Dm.Tsp29Fa, Dmel\\CG9494', description='Tetraspanin 29Fa', other_designations='CG9494-PA|CG9494-PB|CG9494-PC|Tsp29Fa-PA|Tsp29Fa-PB|Tsp29Fa-PC|tetraspanin 29Fa', map_location='29F4-29F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8933962, end_position_on_the_genomic_accession=8936096, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34212 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34212, CurrentID=0, Status='live', Symbol='Tsp29Fb', Aliases='Dmel_CG9496, CG9496, Dm.Tsp29Fb, Dmel\\CG9496, anon-EST:ParkEST130', description='Tetraspanin 29Fb', other_designations='CG9496-PA|CG9496-PB|CG9496-PC|Tsp29Fb-PA|Tsp29Fb-PB|Tsp29Fb-PC|tetraspanin 29Fb', map_location='29F5-29F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8937390, end_position_on_the_genomic_accession=8939743, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34215 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34215, CurrentID=0, Status='live', Symbol='C1GalTA', Aliases='Dmel_CG9520, C1GALT1, C1beta3GalT1, CG9520, Dmel\\CG9520, anon-WO0144478.18, dC1GalT1, dC1beta3GalT1', description='Core 1 Galactosyltransferase A', other_designations='C1GalTA-PA|C1GalTA-PB|C1GalTA-PC|CG9520-PA|CG9520-PB|CG9520-PC|core 1 beta1,3-galactosyltransferase|core 1 galactosyltransferase A', map_location='29F5-29F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8943455, end_position_on_the_genomic_accession=8951216, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34217 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34217, CurrentID=0, Status='live', Symbol='CG9525', Aliases='Dmel_ Dmel\\CG9525, gi7297470', description='CG9525 gene product from transcript CG9525-RB', other_designations='CG9525-PA|CG9525-PB', map_location='29F5-29F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8959255, end_position_on_the_genomic_accession=8962354, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34218 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34218, CurrentID=0, Status='live', Symbol='CG32984', Aliases='Dmel_ CG17789, Dmel\\CG32984, gi21430910, gi22945998', description='CG32984 gene product from transcript CG32984-RA', other_designations='CG32984-PA|uncharacterized protein', map_location='29F6-29F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8964982, end_position_on_the_genomic_accession=8967035, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34219 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34219, CurrentID=0, Status='live', Symbol='CG18088', Aliases='Dmel_ Dmel\\CG18088, gi21430616, gi7297472', description='CG18088 gene product from transcript CG18088-RC', other_designations='CG18088-PA|CG18088-PB|CG18088-PC|uncharacterized protein', map_location='29F6-29F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8967535, end_position_on_the_genomic_accession=8970627, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34220 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34220, CurrentID=0, Status='live', Symbol='CG9541', Aliases='Dmel_ Dmel\\CG9541', description='CG9541 gene product from transcript CG9541-RC', other_designations='CG9541-PC|CG9541-PD', map_location='29F6-29F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8970520, end_position_on_the_genomic_accession=8975428, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34221 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34221, CurrentID=0, Status='live', Symbol='CG13101', Aliases='Dmel_ Dmel\\CG13101', description='CG13101 gene product from transcript CG13101-RB', other_designations='CG13101-PA|CG13101-PB|uncharacterized protein', map_location='29F6-29F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8977834, end_position_on_the_genomic_accession=8984872, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34222 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34222, CurrentID=0, Status='live', Symbol='rost', Aliases='Dmel_CG9552, CG9552, Dmel\\CG9552', description='rolling stone', other_designations='CG9552-PA|CG9552-PB|CG9552-PC|rost-PA|rost-PB|rost-PC', map_location='29F6-29F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8985936, end_position_on_the_genomic_accession=8989539, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34223 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34223, CurrentID=0, Status='live', Symbol='CG9555', Aliases='Dmel_ Dmel\\CG9555', description='CG9555 gene product from transcript CG9555-RC', other_designations='CG9555-PA|CG9555-PC', map_location='29F7-29F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8991735, end_position_on_the_genomic_accession=8993632, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34224 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34224, CurrentID=0, Status='live', Symbol='CG17906', Aliases='Dmel_ Dmel\\CG17906', description='CG17906 gene product from transcript CG17906-RA', other_designations='CG17906-PA|uncharacterized protein', map_location='29F7-29F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8994391, end_position_on_the_genomic_accession=8995617, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34225 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34225, CurrentID=0, Status='live', Symbol='alien', Aliases='Dmel_CG9556, Alien, BcDNA:LD10463, CG9556, CH2, CSN2, Csn2, DCH2, Dch2, Dmel\\CG9556', description='CG9556 gene product from transcript CG9556-RD', other_designations='CG9556-PA|CG9556-PB|CG9556-PD|CG9556-PE|COP9 complex homolog subunit 2|alien-PA|alien-PB|alien-PD|alien-PE|d-Alien|drosophila COP9 signalosome homolog 2', map_location='29F7-29F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8993818, end_position_on_the_genomic_accession=8997379, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34226 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34226, CurrentID=0, Status='live', Symbol='Try29F', Aliases='Dmel_CG9564, CG9564, Dmel\\CG9564, SP106, try29F, try29F.2', description='Trypsin 29F', other_designations='CG9564-PC|CG9564-PD|Try29F-PC|Try29F-PD|trypsin 29F', map_location='29F7-29F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=8998537, end_position_on_the_genomic_accession=8999816, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34227 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34227, CurrentID=0, Status='live', Symbol='CG9568', Aliases='Dmel_ Dmel\\CG9568, FBgn 32087, anon-WO0140519.183', description='CG9568 gene product from transcript CG9568-RA', other_designations='CG9568-PA', map_location='29F7-29F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9010583, end_position_on_the_genomic_accession=9011358, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34228 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34228, CurrentID=0, Status='live', Symbol='CG13102', Aliases='Dmel_ BcDNA:RE57454, Dmel\\CG13102', description='CG13102 gene product from transcript CG13102-RB', other_designations='CG13102-PA|CG13102-PB|uncharacterized protein', map_location='29F7-29F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9012188, end_position_on_the_genomic_accession=9014149, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34229 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34229, CurrentID=0, Status='live', Symbol='Rcd-1r', Aliases='Dmel_CG9573, CG9573, Dmel\\CG9573, Drcd-1r, Zeus', description='Rcd-1 related', other_designations='CG9573-PA|Drcd-1 related|Rcd-1r-PA', map_location='29F7-29F7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9012885, end_position_on_the_genomic_accession=9014068, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34230 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34230, CurrentID=0, Status='live', Symbol='CG9582', Aliases='Dmel_ Dmel\\CG9582', description='CG9582 gene product from transcript CG9582-RB', other_designations='CG9582-PA|CG9582-PB', map_location='29F8-29F8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9024320, end_position_on_the_genomic_accession=9031836, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34231 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34231, CurrentID=0, Status='live', Symbol='DIP-zeta', Aliases='Dmel_CG31708, 31078, CG13103, CG13104, CG13105, CG31078, CG31708, CT32337, CT32338, Dmel\\CG31708', description='Dpr-interacting protein zeta', other_designations='CG31708-PA|CG31708-PB|CG31708-PC|DIP-zeta-PA|DIP-zeta-PB|DIP-zeta-PC', map_location='29F8-30A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9051631, end_position_on_the_genomic_accession=9071164, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34234 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34234, CurrentID=0, Status='live', Symbol='CG12439', Aliases='Dmel_ BcDNA:AT16114, Dmel\\CG12439', description='CG12439 gene product from transcript CG12439-RB', other_designations='CG12439-PA|CG12439-PB|uncharacterized protein', map_location='30A1-30A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9077121, end_position_on_the_genomic_accession=9077988, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34235 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34235, CurrentID=0, Status='live', Symbol='Toll-4', Aliases='Dmel_CG18241, CG18241, CT29238, Dmel\\CG18241, TL4, Tl-4, dTLR4, dToll4, toll', description='CG18241 gene product from transcript CG18241-RA', other_designations='CG18241-PA|Toll-4-PA|Toll-like|toll receptor', map_location='30A1-30A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9084107, end_position_on_the_genomic_accession=9089440, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34236 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34236, CurrentID=0, Status='live', Symbol='Or30a', Aliases='Dmel_CG13106, 30A.1, 30a, CG13106, DOR56, Dmel\\CG13106', description='Odorant receptor 30a', other_designations='CG13106-PA|Or30a-PA|odorant receptor 30a', map_location='30A1-30A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9111814, end_position_on_the_genomic_accession=9113285, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34237 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34237, CurrentID=0, Status='live', Symbol='CG32982', Aliases='Dmel_ CG18566, CG9584, CG9585, Dmel\\CG32982', description='CG32982 gene product from transcript CG32982-RF', other_designations='CG32982-PA|CG32982-PB|CG32982-PD|CG32982-PE|CG32982-PF|CG32982-PG|CG32982-PH|uncharacterized protein', map_location='30A2-30A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9125737, end_position_on_the_genomic_accession=9163721, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  34240 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34240, CurrentID=0, Status='live', Symbol='CG13108', Aliases='Dmel_ Dmel\\CG13108', description='CG13108 gene product from transcript CG13108-RA', other_designations='CG13108-PA|uncharacterized protein', map_location='30A2-30A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9164235, end_position_on_the_genomic_accession=9165426, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34241 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34241, CurrentID=0, Status='live', Symbol='CG9586', Aliases='Dmel_ Dmel\\CG9586', description='CG9586 gene product from transcript CG9586-RB', other_designations='CG9586-PB|CG9586-PC', map_location='30A2-30A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9165421, end_position_on_the_genomic_accession=9166514, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34242 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34242, CurrentID=0, Status='live', Symbol='tai', Aliases='Dmel_CG13109, 58/2, CG13109, CG18494, DAIB1, DmTaiman, Dmel\\CG13109, EP(2)2630, NEST:bs13g05, TAI, Tai, bs13g05.y1, l(2)01351, l(2)k05802, l(2)k05809', description='taiman', other_designations='CG13109-PC|CG13109-PD|CG13109-PE|CG13109-PF|CG13109-PG|CG13109-PH|drosophila amplified in breast cancer-1|tai-PC|tai-PD|tai-PE|tai-PF|tai-PG|tai-PH', map_location='30A2-30A6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9166778, end_position_on_the_genomic_accession=9250211, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  34244 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34244, CurrentID=0, Status='live', Symbol='aust', Aliases='Dmel_CG17009, CG17009, Dmel\\CG17009', description='australin', other_designations='CG17009-PA|CG17009-PB|aust-PA|aust-PB', map_location='30A6-30A6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9250048, end_position_on_the_genomic_accession=9251042, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34245 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34245, CurrentID=0, Status='live', Symbol='borr', Aliases='Dmel_CG4454, BORR, Bor, Borr, CG4454, Dmel\\CG4454, dBor', description='borealin-related', other_designations='Borealin-related|CG4454-PA|CG4454-PB|borealin|borr-PA|borr-PB', map_location='30A6-30A6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9251472, end_position_on_the_genomic_accession=9253118, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34249 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34249, CurrentID=0, Status='live', Symbol='CG17005', Aliases='Dmel_ Dmel\\CG17005', description='CG17005 gene product from transcript CG17005-RE', other_designations='CG17005-PB|CG17005-PC|CG17005-PD|CG17005-PE|uncharacterized protein', map_location='30A8-30A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9327744, end_position_on_the_genomic_accession=9330332, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34250 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34250, CurrentID=0, Status='live', Symbol='Cks30A', Aliases='Dmel_CG3738, CDI2, CG3738, Cdi2, Cks, DmCks1, Dmel\\CG3738, U40077, cdi2, cks, cks30A, fs(2)rem, rem', description='Cyclin-dependent kinase subunit 30A', other_designations='CG3738-PA|Cks30A-PA|Cyclin-dependent kinase interactor 2|remnants', map_location='2-32 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9330763, end_position_on_the_genomic_accession=9331981, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34251 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34251, CurrentID=0, Status='live', Symbol='Eaat1', Aliases='Dmel_CG3747, AF001784, CG3747, Dglt-1, Dglut-1, Dmel\\CG3747, EAAT, EAAT1, dEAAT, dEAAT1, dEaat1, eaat1', description='Excitatory amino acid transporter 1', other_designations='CG3747-PA|CG3747-PB|CG3747-PC|CG3747-PD|Eaat1-PA|Eaat1-PB|Eaat1-PC|Eaat1-PD|drosophila glutamate transporter-1|excitatory amino acid transporter 1|glutamate transporter|sodium-dependent excitatory amino acid transporter 1|sodium-dependent glutamate transporter|sodium-excitatory-glutamate-cotransporter', map_location='30A8-30A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9333567, end_position_on_the_genomic_accession=9341925, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  34252 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34252, CurrentID=0, Status='live', Symbol='CG3748', Aliases='Dmel_ BcDNA:AT30262, Dmel\\CG3748, anon-WO0140519.143', description='CG3748 gene product from transcript CG3748-RC', other_designations='CG3748-PB|CG3748-PC', map_location='30A8-30A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9342832, end_position_on_the_genomic_accession=9344777, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34253 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34253, CurrentID=0, Status='live', Symbol='CG13110', Aliases='Dmel_ BcDNA:AT19071, Dmel\\CG13110', description='CG13110 gene product from transcript CG13110-RA', other_designations='CG13110-PA|uncharacterized protein', map_location='30A9-30A9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9350470, end_position_on_the_genomic_accession=9350996, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34256 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34256, CurrentID=0, Status='live', Symbol='Aldh', Aliases='Dmel_CG3752, 146084_at, ACDH, ALDH, ALDHA1, CG 3752, CG3752, Dmel\\CG3752', description='Aldehyde dehydrogenase', other_designations='Aldh-PA|Aldh-PB|CG3752-PA|CG3752-PB|acetaldehyde dehydrogenase|aldehyde dehydrogenase', map_location='30B1-30B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9387389, end_position_on_the_genomic_accession=9391567, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34257 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34257, CurrentID=0, Status='live', Symbol='CG4438', Aliases='Dmel_ Dmel\\CG4438', description='CG4438 gene product from transcript CG4438-RB', other_designations='CG4438-PA|CG4438-PB', map_location='30B1-30B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9396999, end_position_on_the_genomic_accession=9397988, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34258 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34258, CurrentID=0, Status='live', Symbol='Mco1', Aliases='Dmel_CG3759, CG3759, Dmel\\CG3759, MCO1', description='Multicopper oxidase-1', other_designations='CG3759-PA|CG3759-PB|CG3759-PC|Mco1-PA|Mco1-PB|Mco1-PC|laccase-like|multicopper oxidase-1', map_location='30B2-30B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9416588, end_position_on_the_genomic_accession=9426342, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34259 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34259, CurrentID=0, Status='live', Symbol='Fbp2', Aliases='Dmel_CG3763, CG3763, Dmel\\CG3763, Fbp-2, P6, T19', description='Fat body protein 2', other_designations='CG3763-PA|CG3763-PB|CG3763-PC|Fbp2-PA|Fbp2-PB|Fbp2-PC|Protein-6|fat body protein P6', map_location='30B3-30B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9426784, end_position_on_the_genomic_accession=9427917, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34260 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34260, CurrentID=0, Status='live', Symbol='FucTB', Aliases='Dmel_CG4435, CG4435, CT14430, Dmel\\CG4435', description='CG4435 gene product from transcript CG4435-RD', other_designations='CG4435-PA|CG4435-PC|CG4435-PD|FucTB-PA|FucTB-PC|FucTB-PD|alpha1,3-fucosyltransferase', map_location='30B3-30B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9428669, end_position_on_the_genomic_accession=9431052, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34262 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34262, CurrentID=0, Status='live', Symbol='CG3769', Aliases='Dmel_ Dmel\\CG3769', description='CG3769 gene product from transcript CG3769-RA', other_designations='CG3769-PA', map_location='30B3-30B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9435399, end_position_on_the_genomic_accession=9436842, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34263 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34263, CurrentID=0, Status='live', Symbol='numb', Aliases='Dmel_CG3779, CG3779, Dmel\\CG3779, N7-1, Nb, Numb, d-numb, dNumb, l(2)03235, l(2)3235, l(2)s2201, nbs', description='CG3779 gene product from transcript CG3779-RB', other_designations='CG3779-PA|CG3779-PB|CG3779-PD|d-Numb|numb-PA|numb-PB|numb-PD', map_location='30B3-30B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9437469, end_position_on_the_genomic_accession=9464184, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34264 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34264, CurrentID=0, Status='live', Symbol='Gdi', Aliases='Dmel_CG4422, CG4422, Dmel\\CG4422, GDI, GdI, N7-3, dGDI, l(2)N7-3, lincRNA.S746, rab GDI', description='GDP dissociation inhibitor', other_designations='CG4422-PA|CG4422-PB|CG4422-PC|Gdi-PA|Gdi-PB|Gdi-PC|Gdi-related|rab GDP dissociation inhibitor', map_location='30B5-30B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9491176, end_position_on_the_genomic_accession=9494876, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34268 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34268, CurrentID=0, Status='live', Symbol='Oatp30B', Aliases='Dmel_CG3811, CG3811, Dmel\\CG3811, oatp 30B, oatp30B', description='Organic anion transporting polypeptide 30B', other_designations='CG3811-PA|CG3811-PB|CG3811-PC|CG3811-PD|Oatp30B-PA|Oatp30B-PB|Oatp30B-PC|Oatp30B-PD|organic anion transporting polypeptide 30B', map_location='30B10-30B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9521210, end_position_on_the_genomic_accession=9540060, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  34269 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34269, CurrentID=0, Status='live', Symbol='CG17855', Aliases='Dmel_ Dmel\\CG17855', description='CG17855 gene product from transcript CG17855-RA', other_designations='CG17855-PA|uncharacterized protein', map_location='30B10-30B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9540523, end_position_on_the_genomic_accession=9542480, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34270 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34270, CurrentID=0, Status='live', Symbol='Cpr30B', Aliases='Dmel_CG3818, CG3818, DmelCpr30B, Dmel\\CG3818', description='Cuticular protein 30B', other_designations='CG3818-PA|Cpr30B-PA|cuticular protein 30B', map_location='30B10-30B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9542878, end_position_on_the_genomic_accession=9543658, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34271 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34271, CurrentID=0, Status='live', Symbol='CG13113', Aliases='Dmel_ Dmel\\CG13113', description='CG13113 gene product from transcript CG13113-RA', other_designations='CG13113-PA|uncharacterized protein', map_location='30B10-30B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9544171, end_position_on_the_genomic_accession=9544875, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34272 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34272, CurrentID=0, Status='live', Symbol='CG13114', Aliases='Dmel_ Dmel\\CG13114', description='CG13114 gene product from transcript CG13114-RB', other_designations='CG13114-PB|uncharacterized protein', map_location='30B10-30B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9545811, end_position_on_the_genomic_accession=9547424, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34274 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34274, CurrentID=0, Status='live', Symbol='jp', Aliases='Dmel_CG4405, CG13115, CG4405, Dmel\\CG4405, JP', description='junctophilin', other_designations='CG4405-PA|CG4405-PB|CG4405-PC|CG4405-PD|CG4405-PE|jp-PA|jp-PB|jp-PC|jp-PD|jp-PE', map_location='30B10-30B12', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9547720, end_position_on_the_genomic_accession=9566750, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  34275 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34275, CurrentID=0, Status='live', Symbol='CG3838', Aliases='Dmel_ Dmel\\CG3838, NEST:bs09e08, anon-WO0118547.445, bs09e08.y1', description='CG3838 gene product from transcript CG3838-RA', other_designations='CG3838-PA|CG3838-PB', map_location='30B12-30B12', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9568890, end_position_on_the_genomic_accession=9573572, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34276 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34276, CurrentID=0, Status='live', Symbol='Mtpalpha', Aliases='Dmel_CG4389, BcDNA:GH12558, CG 4389, CG4389, Dmel\\CG4389', description='Mitochondrial trifunctional protein alpha subunit', other_designations='CG4389-PA|CG4389-PB|Mtpalpha-PA|Mtpalpha-PB|mitochondrial trifunctional protein alpha subunit', map_location='30B12-30B12', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9573563, end_position_on_the_genomic_accession=9576769, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34277 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34277, CurrentID=0, Status='live', Symbol='gcm', Aliases='Dmel_CG12245, CG12245, Dmel\\CG12245, GCM, GCM1, GCMa, Gcm, N7-4, glide, glide/gcm, l(2)N7-4, ucc', description='glial cells missing', other_designations='CG12245-PA|CG12245-PB|gcm-PA|gcm-PB|glia cells missing|glial cell deficient|glial cell missing|glial cells-missing|glide|glide glide2|upper class chordotonals', map_location='30B12-30B12', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9579498, end_position_on_the_genomic_accession=9581745, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34278 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34278, CurrentID=0, Status='live', Symbol='CG3841', Aliases='Dmel_ Dmel\\CG3841', description='CG3841 gene product from transcript CG3841-RB', other_designations='CG3841-PA|CG3841-PB', map_location='30B12-30C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9589476, end_position_on_the_genomic_accession=9591783, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34279 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34279, CurrentID=0, Status='live', Symbol='CG4382', Aliases='Dmel_ Dmel\\CG4382', description='CG4382 gene product from transcript CG4382-RB', other_designations='CG4382-PB', map_location='30C1-30C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9598880, end_position_on_the_genomic_accession=9600872, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34280 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34280, CurrentID=0, Status='live', Symbol='gcm2', Aliases='Dmel_CG3858, CG3858, Dmel\\CG3858, FBgn0019809, Gcm2, dGCM2', description='CG3858 gene product from transcript CG3858-RA', other_designations='CG3858-PA|gcm2-PA|glial cells missing 2|glide glide2|glide2', map_location='30C1-30C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9608562, end_position_on_the_genomic_accession=9612706, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34281 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34281, CurrentID=0, Status='live', Symbol='Trx-2', Aliases='Dmel_CG31884, 31884, CG31884, CG3864, DTrx-2, DmTrx-2, DmelTrx-2, Dmel\\CG31884, Trx, anon-WO0118547.188, dmtrx-2', description='thioredoxin-2', other_designations='CG31884-PA|CG31884-PB|Thioredoxin-2|Trx-2-PA|Trx-2-PB|thioredoxin', map_location='30C1-30C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9613166, end_position_on_the_genomic_accession=9616404, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34282 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34282, CurrentID=0, Status='live', Symbol='GlcAT-S', Aliases='Dmel_CG3881, CG3881, D DmGlcAT-BSI, Dmel\\CG3881, dGlcAT-BSI', description='CG3881 gene product from transcript CG3881-RA', other_designations='CG3881-PA|CG3881-PB|CG3881-PC|GlcAT-S-PA|GlcAT-S-PB|GlcAT-S-PC', map_location='30C1-30C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9616469, end_position_on_the_genomic_accession=9623109, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34283 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34283, CurrentID=0, Status='live', Symbol='Apoltp', Aliases='Dmel_CG15828, ApoLTPI, ApoLTPII, CG15828, CT39214, Dmel\\CG15828, LTP, apoLTP, apoltp', description='Apolipoprotein lipid transfer particle', other_designations='Apoltp-PC|CG15828-PC|apolipoprotein lipid transfer particle|lipid transfer particle', map_location='30C2-30C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9634179, end_position_on_the_genomic_accession=9656026, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  34284 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34284, CurrentID=0, Status='live', Symbol='Pka-C1', Aliases='Dmel_CG4379, 6353, C, CG4379, CdkA, Cos, Cos-1, Cos1, DC0, DCO, Dc0, Dco, Dcpk, Dmel\\CG4379, PKA, PKA CI, PKA Cl, PKA-C1, PKAC1, PKAc, PKAcA, Pka, Pka-C, PkaC1, cos1, dPKA, dcO, dco, l(2)01272, l(2)cos[[1]], l(2)s4402, pKA, pkA, pka, pka C1, pka-C1, pka-c1', description='Protein kinase, cAMP-dependent, catalytic subunit 1', other_designations='CG4379-PB|CG4379-PC|CG4379-PD|Costal-1|PKA catalytic subunit|Pka-C1-PB|Pka-C1-PC|Pka-C1-PD|cAMP-dependent protein kinase|cAMP-dependent protein kinase 1|catalytic subunit of PKA|catalytic subunit of cAMP-dependent protein kinase|costal|protein kinase A|protein kinase, cAMP-dependent, catalytic subunit 1', map_location='30C5-30C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9682315, end_position_on_the_genomic_accession=9699297, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34286 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34286, CurrentID=0, Status='live', Symbol='pelo', Aliases='Dmel_CG3959, CG3959, Dmel\\CG3959, ms(2)01559', description='pelota', other_designations='CG3959-PA|pelo-PA', map_location='30C5-30C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9700810, end_position_on_the_genomic_accession=9708883, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34287 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34287, CurrentID=0, Status='live', Symbol='CG4364', Aliases='Dmel_ Dmel\\CG4364', description='CG4364 gene product from transcript CG4364-RA', other_designations='CG4364-PA', map_location='30C5-30C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9708921, end_position_on_the_genomic_accession=9711271, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34288 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34288, CurrentID=0, Status='live', Symbol='CG13116', Aliases='Dmel_ Dmel\\CG13116', description='CG13116 gene product from transcript CG13116-RA', other_designations='CG13116-PA|CG13116-PB|uncharacterized protein', map_location='30C6-30C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9729940, end_position_on_the_genomic_accession=9730945, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34289 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34289, CurrentID=0, Status='live', Symbol='CG13117', Aliases='Dmel_ BcDNA:SD27505, Dmel\\CG13117', description='CG13117 gene product from transcript CG13117-RB', other_designations='CG13117-PA|CG13117-PB|uncharacterized protein', map_location='30C6-30C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9736645, end_position_on_the_genomic_accession=9737949, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34291 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34291, CurrentID=0, Status='live', Symbol='Cyp4e3', Aliases='Dmel_CG4105, 4e3, CG4105, Cyp4E3, Dmel\\CG4105, P-450, P450, cyp4e3', description='Cytochrome P450-4e3', other_designations='CG4105-PA|Cyp4e3-PA|cytochrome P450|cytochrome P450-4e3', map_location='30C7-30C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9747839, end_position_on_the_genomic_accession=9750071, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34292 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34292, CurrentID=0, Status='live', Symbol='zf30C', Aliases='Dmel_CG3998, C282, CG3998, Dmel\\CG3998, Zf30c, Zn30C, anon-EST:Liang-1.52, clone 1.52, l(2)k02506, zf30c', description='zinc finger protein 30C', other_designations='CG3998-PA|zf30C-PA', map_location='30C7-30C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9758342, end_position_on_the_genomic_accession=9762375, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34293 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34293, CurrentID=0, Status='live', Symbol='Taf11', Aliases='Dmel_CG4079, CG4079, Dmel\\CG4079, TAF, TAF1, TAF11, TAF30b, TAF30beta, TAF[II]30beta, TAF[[II]], TAF[[II]]30beta, TFIID, TFIID 28 beta, TFIID-p28beta, Taf30beta, Taf[[II]]30beta, d30beta, dTAFII30, dTAFII30 beta, dTAFII30beta, dTAF[[II]]30, dTAF[[II]]30beta', description='TBP-associated factor 11', other_designations='CG4079-PA|TBP-associated factor|TBP-associated factor 30kD subunit beta|Taf11-PA', map_location='30C7-30C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9762424, end_position_on_the_genomic_accession=9763262, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34294 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34294, CurrentID=0, Status='live', Symbol='und', Aliases='Dmel_CG4008, CG4008, DMAP2, Dmel\\CG4008, MAP2, p67', description='uninitiated', other_designations='CG4008-PA|CG4008-PB|CG4008-PC|p67|und-PA|und-PB|und-PC', map_location='30C7-30C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9763369, end_position_on_the_genomic_accession=9765338, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34295 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34295, CurrentID=0, Status='live', Symbol='ppk18', Aliases='Dmel_CG44152, CG13120, CG13121, CG44152, Dmel\\CG44152, Dmel_CG13120, Dmel_CG13121', description='pickpocket 18', other_designations='CG44152-PA|ppk18-PA', map_location='30C8-30C8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9765357, end_position_on_the_genomic_accession=9770996, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34296 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34296, CurrentID=0, Status='live', Symbol='CG4017', Aliases='Dmel_ Dmel\\CG4017', description='CG4017 gene product from transcript CG4017-RA', other_designations='CG4017-PA', map_location='30C8-30C8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9767058, end_position_on_the_genomic_accession=9768727, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34297 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34297, CurrentID=0, Status='live', Symbol='CG17633', Aliases='Dmel_ Dmel\\CG17633', description='CG17633 gene product from transcript CG17633-RA', other_designations='CG17633-PA|uncharacterized protein', map_location='30C8-30C8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9769060, end_position_on_the_genomic_accession=9770409, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34299 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34299, CurrentID=0, Status='live', Symbol='ppk11', Aliases='Dmel_CG34058, CG34058, CG4110, Dmel\\CG34058, PPK11', description='pickpocket 11', other_designations='CG34058-PA|pickpocket11|ppk11-PA', map_location='30C8-30C9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9773108, end_position_on_the_genomic_accession=9775030, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34300 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34300, CurrentID=0, Status='live', Symbol='IP3K1', Aliases='Dmel_CG4026, CG4026, D-IP3K1, Dmel\\CG4026, IP3KI, IP[[3]]K-1, UY530, anon-WO0118547.189, dmIP3Kalpha, dmIP[[3]]Kalpha', description='Inositol 1,4,5-triphosphate kinase 1', other_designations='CG4026-PA|CG4026-PB|IP3 kinase 1|IP3K1-PA|IP3K1-PB|inositol 1,4,5-triphosphate kinase 1|inositol 1,4,5-triphosphate kinase1', map_location='30C9-30D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9782384, end_position_on_the_genomic_accession=9788499, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34302 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34302, CurrentID=0, Status='live', Symbol='CG4036', Aliases='Dmel_ Dmel\\CG4036', description='CG4036 gene product from transcript CG4036-RB', other_designations='CG4036-PA|CG4036-PB', map_location='30D1-30D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9790882, end_position_on_the_genomic_accession=9791958, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34303 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34303, CurrentID=0, Status='live', Symbol='CG13123', Aliases='Dmel_ Dmel\\CG13123', description='CG13123 gene product from transcript CG13123-RB', other_designations='CG13123-PA|CG13123-PB|CG13123-PC|uncharacterized protein', map_location='30D1-30D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9791961, end_position_on_the_genomic_accession=9793107, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34304 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34304, CurrentID=0, Status='live', Symbol='nAChRalpha6', Aliases='Dmel_CG4128, BcDNA:GH01410, CG4128, CT13662, Dalpha6, Dmel\\CG4128, alpha6, das, nAChR, nAChR alpha 6, nAChRAlpha-30D, nAChRalpha, nAChRalpha-30D, nAcRalpha-30D, rsn', description='nicotinic Acetylcholine Receptor alpha6', other_designations='CG4128-PA|CG4128-PB|CG4128-PC|CG4128-PD|CG4128-PE|CG4128-PG|CG4128-PH|Dalpha6|alpha6 nicotinic acetylcholine receptor subunit|nAChRalpha6-PA|nAChRalpha6-PB|nAChRalpha6-PC|nAChRalpha6-PD|nAChRalpha6-PE|nAChRalpha6-PG|nAChRalpha6-PH|nicotinic acetylcholine receptor 30D|nicotinic acetylcholine receptor alpha 30D|nicotinic acetylcholine receptor alpha6|resistance to spinosyn|resistant to spinosyns', map_location='30D1-30E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9793317, end_position_on_the_genomic_accession=9886250, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  34306 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34306, CurrentID=0, Status='live', Symbol='CG4537', Aliases='Dmel_ Dmel\\CG4537', description='CG4537 gene product from transcript CG4537-RB', other_designations='CG4537-PB', map_location='30E1-30E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9890885, end_position_on_the_genomic_accession=9891336, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34307 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34307, CurrentID=0, Status='live', Symbol='mtDNA-helicase', Aliases='Dmel_CG5924, CG5924, Dmel\\CG5924', description='mitochondrial DNA helicase', other_designations='CG5924-PA|d-mtDNA helicase|mtDNA helicase|mtDNA-helicase-PA|twinkle', map_location='30E1-30E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9891255, end_position_on_the_genomic_accession=9893446, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34309 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34309, CurrentID=0, Status='live', Symbol='RpS2', Aliases='Dmel_CG5920, CG5920, Dm01335, Dmel\\CG5920, Rp S2, S2, anon-EST:Posey202, dS2, l(2)03848, l(2)k04603, sop', description='Ribosomal protein S2', other_designations='40S ribosomal protein S2|CG5920-PA|CG5920-PB|CG5920-PC|RpS2-PA|RpS2-PB|RpS2-PC|S2 ribosomal protein|ribosomal protein S2|ribosome RS2|string of pearls', map_location='30E1-30E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9896265, end_position_on_the_genomic_accession=9897552, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34310 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34310, CurrentID=0, Status='live', Symbol='CG13124', Aliases='Dmel_ Dmel\\CG13124', description='CG13124 gene product from transcript CG13124-RJ', other_designations='CG13124-PA|CG13124-PB|CG13124-PD|CG13124-PE|CG13124-PF|CG13124-PG|CG13124-PH|CG13124-PI|CG13124-PJ|uncharacterized protein', map_location='30E1-30E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9903279, end_position_on_the_genomic_accession=9908633, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34311 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34311, CurrentID=0, Status='live', Symbol='Etl1', Aliases='Dmel_CG5899, CG5899, Dmel\\CG5899', description='Etl1 homologue', other_designations='CG5899-PA|Etl1-PA', map_location='30E1-30E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9908830, end_position_on_the_genomic_accession=9912608, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34312 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34312, CurrentID=0, Status='live', Symbol='Srp54', Aliases='Dmel_CG4602, CG4602, Dmel\\CG4602, SRp54, anon-EST:Liang-2.16, clone 2.16, dSRp54, p75', description='CG4602 gene product from transcript CG4602-RA', other_designations='CG4602-PA|Srp54-PA', map_location='30E4-30E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9912911, end_position_on_the_genomic_accession=9915044, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34313 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34313, CurrentID=0, Status='live', Symbol='yip2', Aliases='Dmel_CG4600, ACAA, CG4600, Dmel\\CG4600, Yip2', description='yippee interacting protein 2', other_designations='CG4600-PA|acetyl-CoA acyltransferase|yip2-PA', map_location='30E4-30E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9915253, end_position_on_the_genomic_accession=9917220, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34314 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34314, CurrentID=0, Status='live', Symbol='CG5885', Aliases='Dmel_ AI945207, BEST:CK01296, CK01296, Dmel\\CG5885', description='CG5885 gene product from transcript CG5885-RB', other_designations='CG5885-PA|CG5885-PB', map_location='30E4-30E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9917221, end_position_on_the_genomic_accession=9918330, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34315 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34315, CurrentID=0, Status='live', Symbol='CG4598', Aliases='Dmel_ Dmel\\CG4598', description='CG4598 gene product from transcript CG4598-RB', other_designations='CG4598-PA|CG4598-PB', map_location='30E4-30E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9918618, end_position_on_the_genomic_accession=9920120, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34316 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34316, CurrentID=0, Status='live', Symbol='CG4594', Aliases='Dmel_ Dmel\\CG4594', description='CG4594 gene product from transcript CG4594-RB', other_designations='CG4594-PA|CG4594-PB', map_location='30E4-30F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9920160, end_position_on_the_genomic_accession=9921459, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34317 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34317, CurrentID=0, Status='live', Symbol='CG4592', Aliases='Dmel_ Dmel\\CG4592', description='CG4592 gene product from transcript CG4592-RB', other_designations='CG4592-PA|CG4592-PB', map_location='30F1-30F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9921633, end_position_on_the_genomic_accession=9922860, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34318 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34318, CurrentID=0, Status='live', Symbol='TbCMF46', Aliases='Dmel_CG13125, CG13125, CT32363, Dmel\\CG13125, mel CG13125', description='CG13125 gene product from transcript CG13125-RA', other_designations='CG13125-PA|TbCMF46-PA', map_location='30F1-30F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9922737, end_position_on_the_genomic_accession=9924865, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34319 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34319, CurrentID=0, Status='live', Symbol='CG42366', Aliases='Dmel_ CG31711, CG31878, CG4588, Dmel\\CG42366, Dmel_CG31711, Dmel_CG31878, IME2, MAK', description='CG42366 gene product from transcript CG42366-RA', other_designations='CG42366-PA|CG42366-PB|uncharacterized protein', map_location='30F1-30F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9925161, end_position_on_the_genomic_accession=9930378, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34320 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34320, CurrentID=0, Status='live', Symbol='CG31712', Aliases='Dmel_ CG5879, Dmel\\CG31712', description='CG31712 gene product from transcript CG31712-RA', other_designations='CG31712-PA|CG31712-PB|uncharacterized protein', map_location='30F1-30F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9934767, end_position_on_the_genomic_accession=9938134, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34321 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34321, CurrentID=0, Status='live', Symbol='CG4619', Aliases='Dmel_ CG31879, Dmel\\CG4619', description='CG4619 gene product from transcript CG4619-RA', other_designations='CG4619-PA|CG4619-PB', map_location='30F1-30F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9938863, end_position_on_the_genomic_accession=9943058, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34322 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34322, CurrentID=0, Status='live', Symbol='CG5853', Aliases='Dmel_ Dmel\\CG5853', description='CG5853 gene product from transcript CG5853-RC', other_designations='CG5853-PA|CG5853-PB|CG5853-PC', map_location='30F1-30F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9940773, end_position_on_the_genomic_accession=9947648, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34323 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34323, CurrentID=0, Status='live', Symbol='CG13126', Aliases='Dmel_ Dmel\\CG13126, anon-WO0118547.208', description='CG13126 gene product from transcript CG13126-RB', other_designations='CG13126-PA|CG13126-PB|uncharacterized protein', map_location='30F2-30F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9952072, end_position_on_the_genomic_accession=9954181, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34324 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34324, CurrentID=0, Status='live', Symbol='CG4709', Aliases='Dmel_ Dmel\\CG4709', description='CG4709 gene product from transcript CG4709-RB', other_designations='CG4709-PA|CG4709-PB', map_location='30F2-30F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9954325, end_position_on_the_genomic_accession=9956176, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34325 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34325, CurrentID=0, Status='live', Symbol='CG4658', Aliases='Dmel_ Dmel\\CG4658', description='CG4658 gene product from transcript CG4658-RD', other_designations='CG4658-PA|CG4658-PB|CG4658-PC|CG4658-PD|CG4658-PE', map_location='30F2-30F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9957132, end_position_on_the_genomic_accession=9960168, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34326 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34326, CurrentID=0, Status='live', Symbol='CG5846', Aliases='Dmel_ Dmel\\CG5846', description='CG5846 gene product from transcript CG5846-RA', other_designations='CG5846-PA|CG5846-PB', map_location='30F2-30F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9956175, end_position_on_the_genomic_accession=9957237, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34327 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34327, CurrentID=0, Status='live', Symbol='CG5850', Aliases='Dmel_ Dmel\\CG5850', description='CG5850 gene product from transcript CG5850-RD', other_designations='CG5850-PA|CG5850-PC|CG5850-PD|CG5850-PE|CG5850-PF|CG5850-PG', map_location='30F2-30F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9959248, end_position_on_the_genomic_accession=9963949, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34328 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34328, CurrentID=0, Status='live', Symbol='Dref', Aliases='Dmel_CG5838, CG5838, DREF, DmDREF, Dmel\\CG5838, Dmel_DREF, dDREF, dref, p80, p80/DREF', description='DNA replication-related element factor', other_designations='CG5838-PA|CG5838-PB|DNA|DNA replication-related element binding factor|DNA replication-related element-binding factor|DNA-replication-related element factor|DRE (DNA replication-related element) binding factor|DRE-binding factor|Dref-PA|Dref-PB|replication-related element-binding factor', map_location='30F2-30F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9964147, end_position_on_the_genomic_accession=9967229, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34329 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34329, CurrentID=0, Status='live', Symbol='RpL13', Aliases='Dmel_CG4651, Bbc1, CG4651, Dmbbc1, Dmel\\CG4651, L13, Rp L13, Rpl13, anon-EST:fe1D1, bbc1, rpL13', description='Ribosomal protein L13', other_designations='CG4651-PA|CG4651-PB|CG4651-PC|RpL13-PA|RpL13-PB|RpL13-PC|anon-fast-evolving-1D1|r-protein L13|ribosomal protein L13', map_location='30F3-30F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9967313, end_position_on_the_genomic_accession=9968645, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34330 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34330, CurrentID=0, Status='live', Symbol='bib', Aliases='Dmel_CG4722, BIB_DROME, Bib, CG4722, Dmel\\CG4722, EP(2)2278, l(2)neo66, l(2)neo91, m-bib', description='big brain', other_designations='Big brain|CG4722-PA|CG4722-PB|bib-PA|bib-PB', map_location='2-34.7 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9984645, end_position_on_the_genomic_accession=9995538, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34331 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34331, CurrentID=0, Status='live', Symbol='SoYb', Aliases='Dmel_CG31755, CG31755, CG5831, Dmel\\CG31755', description='Sister of Yb', other_designations='CG31755-PB|CG31755-PC|SoYb-PB|SoYb-PC|sister of Yb', map_location='30F5-30F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=9996706, end_position_on_the_genomic_accession=10002736, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34333 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34333, CurrentID=0, Status='live', Symbol='Trp1', Aliases='Dmel_CG4758, CG4758, Dmel\\CG4758, Dtrp1, Tp1, sec62', description='Translocation protein 1', other_designations='CG4758-PA|CG4758-PB|CG4758-PC|CG4758-PD|Trp1-PA|Trp1-PB|Trp1-PC|Trp1-PD|translocation protein 1', map_location='30F5-30F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10009381, end_position_on_the_genomic_accession=10013170, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34334 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34334, CurrentID=0, Status='live', Symbol='CG13131', Aliases='Dmel_ Dmel\\CG13131', description='CG13131 gene product from transcript CG13131-RA', other_designations='CG13131-PA|uncharacterized protein', map_location='30F5-30F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10013227, end_position_on_the_genomic_accession=10017463, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34335 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34335, CurrentID=0, Status='live', Symbol='CG13127', Aliases='Dmel_ Dmel\\CG13127', description='CG13127 gene product from transcript CG13127-RA', other_designations='CG13127-PA|uncharacterized protein', map_location='30F6-30F6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10026676, end_position_on_the_genomic_accession=10029298, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34336 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34336, CurrentID=0, Status='live', Symbol='obst-B', Aliases='Dmel_CG4778, BEST:CK00178, BcDNA:GH02976, CG4778, CK00178, Dmel\\CG4778', description='obstructor-B', other_designations='CG4778-PA|obst-B-PA', map_location='30F6-31A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10032690, end_position_on_the_genomic_accession=10038954, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34338 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34338, CurrentID=0, Status='live', Symbol='Pen', Aliases='Dmel_CG4799, 2.1, CG4799, DPend, Dalpha2, Dimp-alpha2, Dmel\\CG4799, IMPalpha2, Imp-alpha2, Kap alpha2, Kap-alpha2, Kpna2, OHO31, Oho31, Rch1, alpha2, alpha2A-Kap, alphaKap2, anon-WO0140519.258, bs29g06.y1, imp alpha2, imp-alpha2, impalpha2, importin alpha2/pendulin, l(2)144/1, l(2)k06324, l(2)k14401, oho-31, oho31, pen, pen-2', description='Pendulin', other_designations='CG4799-PA|Importin-a2|Importin-alpha|Importin-alpha2|Pen-PA|alpha-importin|i|importin alpha|importin alpha2|lethal (2) k06324|pendulin', map_location='31A1-31A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10056900, end_position_on_the_genomic_accession=10060095, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34339 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34339, CurrentID=0, Status='live', Symbol='Spn31A', Aliases='Dmel_CG4804, CG4804, Dmel\\CG4804', description='Serpin 31A', other_designations='CG4804-PA|Spn31A-PA|serpin 31A', map_location='31A2-31A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10060816, end_position_on_the_genomic_accession=10063925, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34341 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34341, CurrentID=0, Status='live', Symbol='CG44153', Aliases='Dmel_ BP1029, CG13132, CG13134, CG13136, CG31714, CG34048, CG42843, CG5833, Dmel\\CG44153, Dmel_CG13134, Dmel_CG13136, Dmel_CG31714, Dmel_CG34048, Dmel_CG42843', description='CG44153 gene product from transcript CG44153-RB', other_designations='CG44153-PA|CG44153-PB|uncharacterized protein', map_location='31A3-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10064121, end_position_on_the_genomic_accession=10180256, orientation='minus', exon_count=21, OMIM='', no_hdr0=''),
  34342 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34342, CurrentID=0, Status='live', Symbol='CG13133', Aliases='Dmel_ Dmel\\CG13133', description='CG13133 gene product from transcript CG13133-RA', other_designations='CG13133-PA|uncharacterized protein', map_location='31A2-31A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10091208, end_position_on_the_genomic_accession=10092389, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  19835613 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=19835613, CurrentID=0, Status='live', Symbol='CG44286', Aliases='Dmel_ Dmel\\CG44286', description='CG44286 gene product from transcript CG44286-RD', other_designations='CG44286-PA|CG44286-PB|CG44286-PC|CG44286-PD|uncharacterized protein', map_location='45A11-45A12', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=9138486, end_position_on_the_genomic_accession=9141981, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34345 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34345, CurrentID=0, Status='live', Symbol='CG13135', Aliases='Dmel_ Dmel\\CG13135', description='CG13135 gene product from transcript CG13135-RC', other_designations='CG13135-PA|CG13135-PC|uncharacterized protein', map_location='31A2-31A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10122129, end_position_on_the_genomic_accession=10122771, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34348 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34348, CurrentID=0, Status='live', Symbol='CG4839', Aliases='Dmel_ Dmel\\CG4839', description='CG4839 gene product from transcript CG4839-RA', other_designations='CG4839-PA|CG4839-PB|PKG-like', map_location='31A3-31A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10144776, end_position_on_the_genomic_accession=10156407, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  34349 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34349, CurrentID=0, Status='live', Symbol='CG13137', Aliases='Dmel_ Dmel\\CG13137', description='CG13137 gene product from transcript CG13137-RB', other_designations='CG13137-PB|uncharacterized protein', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10172702, end_position_on_the_genomic_accession=10174090, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34350 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34350, CurrentID=0, Status='live', Symbol='Sur', Aliases='Dmel_CG5772, BEST:CK00325, CG5772, CK00325, CYO, Dme_CG5772, Dmel\\CG5772, Dsur, SUR, cyo, dSUR, dSur, dsur, sur', description='Sulfonylurea receptor', other_designations='CG5772-PB|Sur-PB|sulfonyl urea receptor|sulfonylurea receptor|sulphonylurea receptor', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10182557, end_position_on_the_genomic_accession=10199117, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  34351 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34351, CurrentID=0, Status='live', Symbol='Ripalpha', Aliases='Dmel_CG18145, CG18145, Dmel\\CG18145, Tes83, dRIPalpha', description='RPA-interacting protein alpha', other_designations='CG18145-PA|Ripalpha-PA', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10199401, end_position_on_the_genomic_accession=10200974, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34352 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34352, CurrentID=0, Status='live', Symbol='RpL7', Aliases='Dmel_CG4897, BEST:GH04411, CG4897, Dmel\\CG4897, L7, RPL7, Rp L7, rpL7, rpl7', description='Ribosomal protein L7', other_designations='CG4897-PA|CG4897-PB|RpL7-PA|RpL7-PB|ribosomal protein L7', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10201004, end_position_on_the_genomic_accession=10202321, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34353 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34353, CurrentID=0, Status='live', Symbol='CG34159', Aliases='Dmel_ CG5739, Dmel\\CG34159', description='CG34159 gene product from transcript CG34159-RA', other_designations='CG34159-PA|uncharacterized protein', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10202520, end_position_on_the_genomic_accession=10204317, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34354 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34354, CurrentID=0, Status='live', Symbol='CG5734', Aliases='Dmel_ DmSNX17, Dmel\\CG5734', description='CG5734 gene product from transcript CG5734-RA', other_designations='CG5734-PA', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10204757, end_position_on_the_genomic_accession=10206961, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34355 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34355, CurrentID=0, Status='live', Symbol='CG5731', Aliases='Dmel_ Dmel\\CG5731', description='CG5731 gene product from transcript CG5731-RA', other_designations='CG5731-PA', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10207085, end_position_on_the_genomic_accession=10209744, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34356 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34356, CurrentID=0, Status='live', Symbol='CG5727', Aliases='Dmel_ BcDNA:LD02427, Dmel\\CG5727', description='CG5727 gene product from transcript CG5727-RA', other_designations='CG5727-PA', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10209853, end_position_on_the_genomic_accession=10210681, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34357 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34357, CurrentID=0, Status='live', Symbol='CG4901', Aliases='Dmel_ Dmel\\CG4901, cg4901', description='CG4901 gene product from transcript CG4901-RA', other_designations='CG4901-PA', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10211170, end_position_on_the_genomic_accession=10213721, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34358 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34358, CurrentID=0, Status='live', Symbol='Npc1a', Aliases='Dmel_CG5722, CG5722, DmNPC, Dmel\\CG5722, NPC1, NPC1a, Npc1, Npc1_Dm, dNPC1, dNPC1a, dmNPC1, dncp1a, dnpc1a, npc1, npc1a', description='Niemann-Pick type C-1a', other_designations='CG5722-PA|CG5722-PB|CG5722-PC|CG5722-PD|CG5722-PE|CG5722-PF|CG5722-PG|Niemann-Pick type C-1|Npc1a-PA|Npc1a-PB|Npc1a-PC|Npc1a-PD|Npc1a-PE|Npc1a-PF|Npc1a-PG', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10213812, end_position_on_the_genomic_accession=10221216, orientation='minus', exon_count=13, OMIM='', no_hdr0=''),
  34359 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34359, CurrentID=0, Status='live', Symbol='Prosalpha6', Aliases='Dmel_CG4904, 143314_at, Alpha-6, CG4904, Dmel\\CG4904, PROS-35, PROS-Dm35, PSMA1, Pros-35, Pros-Dm35, Pros35, alpha-6, alpha6, alpha_dm, anon-SAGE:Wang-116, pros 35, pros35', description='Proteasome alpha6 subunit', other_designations='20S alpha6 subunit|20s proteasome|CG4904-PA|CG4904-PB|Prosalpha6-PA|Prosalpha6-PB|alpha-subunit of 20S proteasome|alpha6|anon-SAGE:Wang-116|proteasome 35|proteasome 35 kD subunit|proteasome 35-kDa subunit|proteasome 35kD subunit|proteasome 35kDa subunit|proteasome alpha6 subunit', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10221351, end_position_on_the_genomic_accession=10222546, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34360 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34360, CurrentID=0, Status='live', Symbol='CG4908', Aliases='Dmel_ Dmel\\CG4908', description='CG4908 gene product from transcript CG4908-RB', other_designations='CG4908-PA|CG4908-PB', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10222657, end_position_on_the_genomic_accession=10224447, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34361 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34361, CurrentID=0, Status='live', Symbol='CG5708', Aliases='Dmel_ Dmel\\CG5708', description='CG5708 gene product from transcript CG5708-RC', other_designations='CG5708-PA|CG5708-PB|CG5708-PC', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10224457, end_position_on_the_genomic_accession=10226808, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34362 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34362, CurrentID=0, Status='live', Symbol='CG5694', Aliases='Dmel_ Dmel\\CG5694', description='CG5694 gene product from transcript CG5694-RA', other_designations='CG5694-PA|CG5694-PB', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10227760, end_position_on_the_genomic_accession=10231692, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34363 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34363, CurrentID=0, Status='live', Symbol='eEF1delta', Aliases='Dmel_CG4912, CG4912, Dmel\\CG4912, eEF1d, eEf1delta', description='CG4912 gene product from transcript CG4912-RB', other_designations='CG4912-PA|CG4912-PB|eEF1delta-PA|eEF1delta-PB|eukaryotic translation elongation factor 1delta', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10232507, end_position_on_the_genomic_accession=10234450, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34364 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34364, CurrentID=0, Status='live', Symbol='me31B', Aliases='Dmel_CG4916, CG4916, DDX6, Dhh1p/Me31b, DmRH3, Dmel\\CG4916, ME31B, Mat31B, Me31B, Me31b, l(2)k06607', description='maternal expression at 31B', other_designations='CG4916-PA|CG4916-PB|me31B-PA|me31B-PB', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10239341, end_position_on_the_genomic_accession=10242172, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34367 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34367, CurrentID=0, Status='live', Symbol='Ror', Aliases='Dmel_CG4926, CG4926, D DmHD-2, Dmel\\CG4926, Dror, HD-2, ROR, ROR1', description='CG4926 gene product from transcript CG4926-RA', other_designations='CG4926-PA|Ror-PA', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10251843, end_position_on_the_genomic_accession=10254686, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34368 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34368, CurrentID=0, Status='live', Symbol='CG5676', Aliases='Dmel_ BEST:LD31953, Dmel\\CG5676, LD31953', description='CG5676 gene product from transcript CG5676-RA', other_designations='CG5676-PA', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10254610, end_position_on_the_genomic_accession=10255891, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  5740128 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740128, CurrentID=0, Status='live', Symbol='CG34199', Aliases='Dmel_ Dmel\\CG34199', description='CG34199 gene product from transcript CG34199-RA', other_designations='CG34199-PA|uncharacterized protein', map_location='56F16-56F16', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=20287596, end_position_on_the_genomic_accession=20288346, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34370 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34370, CurrentID=0, Status='live', Symbol='Rsf1', Aliases='Dmel_CG5655, CG5655, Dmel\\CG5655, ROX21, RSF1, Rox21, rox21', description='Repressor splicing factor 1', other_designations='CG5655-PA|CG5655-PB|Rsf1-PA|Rsf1-PB|repressor splicing factor 1', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10261795, end_position_on_the_genomic_accession=10263554, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34371 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34371, CurrentID=0, Status='live', Symbol='REPTOR-BP', Aliases='Dmel_CG18619, BcDNA:RH73910, CG18619, DM20, Dmel\\CG18619', description='REPTOR-binding partner', other_designations='CG18619-PA|CG18619-PB|CG18619-PC|CG18619-PD|REPTOR-BP-PA|REPTOR-BP-PB|REPTOR-BP-PC|REPTOR-BP-PD', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10264125, end_position_on_the_genomic_accession=10265229, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34372 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34372, CurrentID=0, Status='live', Symbol='Mob3', Aliases='Dmel_CG4946, CG4946, D Dmel\\CG4946, Dmob3, dmob3', description='CG4946 gene product from transcript CG4946-RA', other_designations='CG4946-PA|Mob3-PA', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10265336, end_position_on_the_genomic_accession=10266570, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34373 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34373, CurrentID=0, Status='live', Symbol='CG4953', Aliases='Dmel_ Dmel\\CG4953', description='CG4953 gene product from transcript CG4953-RA', other_designations='CG4953-PA', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10266703, end_position_on_the_genomic_accession=10268748, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34374 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34374, CurrentID=0, Status='live', Symbol='CG4957', Aliases='Dmel_ Dmel\\CG4957', description='CG4957 gene product from transcript CG4957-RA', other_designations='CG4957-PA', map_location='31B1-31B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10268872, end_position_on_the_genomic_accession=10269904, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34376 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34376, CurrentID=0, Status='live', Symbol='trk', Aliases='Dmel_CG5619, CG5619, Dmel\\CG5619, fs(2)trunk', description='trunk', other_designations='CG5619-PA|trk-PA', map_location='2-36 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10271443, end_position_on_the_genomic_accession=10272324, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34377 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34377, CurrentID=0, Status='live', Symbol='Utx', Aliases='Dmel_CG5640, CG5640, Dmel\\CG5640, UTX, anon-31BCa, dUTX, dUtx, utx', description='Utx histone demethylase', other_designations='CG5640-PA|CG5640-PB|CG5640-PC|CG5640-PD|CG5640-PE|Utx-PA|Utx-PB|Utx-PC|Utx-PD|Utx-PE|anon-31BCa', map_location='31C7-31C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10272325, end_position_on_the_genomic_accession=10278811, orientation='minus', exon_count=17, OMIM='', no_hdr0=''),
  34378 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34378, CurrentID=0, Status='live', Symbol='CG5604', Aliases='Dmel_ Dmel\\CG5604', description='CG5604 gene product from transcript CG5604-RA', other_designations='CG5604-PA', map_location='31C4-31C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10281943, end_position_on_the_genomic_accession=10292365, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34379 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34379, CurrentID=0, Status='live', Symbol='Hand', Aliases='Dmel_CG18144, CG18144, Dhand, Dmel\\CG18144, HAND, bHLHa28, dHAND, d hand, hand-C', description='CG18144 gene product from transcript CG18144-RA', other_designations='CG18144-PA|Hand-PA|hand', map_location='31C6-31C7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10292679, end_position_on_the_genomic_accession=10295385, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34380 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34380, CurrentID=0, Status='live', Symbol='CYLD', Aliases='Dmel_CG5603, CG5603, Cyld, Dmel\\CG5603, Q8IPC5, cyld, dCYLD', description='cylindromatosis ortholog (H. sapiens)', other_designations='CG5603-PB|CG5603-PD|CG5603-PE|CYLD-PB|CYLD-PD|CYLD-PE|cylindromatosis|cylindromatosis ortholog', map_location='31C7-31D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10295859, end_position_on_the_genomic_accession=10299847, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  34381 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34381, CurrentID=0, Status='live', Symbol='CG13138', Aliases='Dmel_ Dmel\\CG13138', description='CG13138 gene product from transcript CG13138-RC', other_designations='CG13138-PB|CG13138-PC|uncharacterized protein', map_location='31D1-31D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10299977, end_position_on_the_genomic_accession=10302018, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34383 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34383, CurrentID=0, Status='live', Symbol='CG5390', Aliases='Dmel_ BEST:GH06341, Dmel\\CG5390, SPH, SPH35, c-SPH35, gh06341', description='CG5390 gene product from transcript CG5390-RA', other_designations='CG5390-PA|CG5390-PB|serine protease homologue protein', map_location='31D1-31D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10304069, end_position_on_the_genomic_accession=10306594, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34384 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34384, CurrentID=0, Status='live', Symbol='CG4968', Aliases='Dmel_ Dmel\\CG4968, Q9VL00', description='CG4968 gene product from transcript CG4968-RA', other_designations='CG4968-PA', map_location='31D1-31D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10306922, end_position_on_the_genomic_accession=10308045, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34385 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34385, CurrentID=0, Status='live', Symbol='Cdk5alpha', Aliases='Dmel_CG5387, CG5387, Cdk5a, D-p35, Dmel\\CG5387, Dp35, P35, dCdk5alpha, p25, p35, p35-21C, p35-31C', description='Cdk5 activator-like protein', other_designations='CG5387-PA|CG5387-PB|Cdk5alpha-PA|Cdk5alpha-PB', map_location='31D1-31D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10308131, end_position_on_the_genomic_accession=10310956, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34386 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34386, CurrentID=0, Status='live', Symbol='l(2)SH0834', Aliases='Dmel_CG5385, CG5385, Dmel\\CG5385, l(2)SH2 0834', description='lethal (2) SH0834', other_designations='CG5385-PA|l(2)SH0834-PA', map_location='31D5-31D8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10311050, end_position_on_the_genomic_accession=10312099, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34387 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34387, CurrentID=0, Status='live', Symbol='Usp14', Aliases='Dmel_CG5384, CG5384, DmUsp14, Dmel\\CG5384, Q9VKZ8, Ubp6p', description='Ubiquitin specific protease 14', other_designations='CG5384-PA|CG5384-PB|Usp14-PA|Usp14-PB|ubiquitin specific protease 14', map_location='31D4-31D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10312265, end_position_on_the_genomic_accession=10314396, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34388 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34388, CurrentID=0, Status='live', Symbol='CG4972', Aliases='Dmel_ Dmel\\CG4972, Q9VKZ7_DROME', description='CG4972 gene product from transcript CG4972-RA', other_designations='CG4972-PA', map_location='31D5-31D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10314792, end_position_on_the_genomic_accession=10317569, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34389 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34389, CurrentID=0, Status='live', Symbol='CG5381', Aliases='Dmel_ Dmel\\CG5381', description='CG5381 gene product from transcript CG5381-RC', other_designations='CG5381-PA|CG5381-PB|CG5381-PC|CG5381-PD', map_location='31D6-31D7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10317497, end_position_on_the_genomic_accession=10323102, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34390 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34390, CurrentID=0, Status='live', Symbol='CG4995', Aliases='Dmel_ CG18626, Dmel\\CG4995', description='CG4995 gene product from transcript CG4995-RB', other_designations='CG4995-PA|CG4995-PB|CG4995-PC|CG4995-PD', map_location='31D7-31D8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10322476, end_position_on_the_genomic_accession=10324990, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34392 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34392, CurrentID=0, Status='live', Symbol='RnrL', Aliases='Dmel_CG5371, CG5371, DmRNR1, Dmel\\CG5371, RNR1, RNRL, RnrM1, RntL, l(2)k06709', description='Ribonucleoside diphosphate reductase large subunit', other_designations='CG5371-PA|RnrL-PA|ribonucleoside diphosphate reductase M1 subunit|ribonucleoside diphosphate reductase large subunit|ribonucleoside-diphosphate reductase large subunit', map_location='31D8-31D8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10325026, end_position_on_the_genomic_accession=10327943, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34393 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34393, CurrentID=0, Status='live', Symbol='CG5375', Aliases='Dmel_ Dmel\\CG5375', description='CG5375 gene product from transcript CG5375-RB', other_designations='CG5375-PB', map_location='31D8-31D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10328200, end_position_on_the_genomic_accession=10331116, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34394 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34394, CurrentID=0, Status='live', Symbol='CG5037', Aliases='Dmel_ COXX, Dmel\\CG5037', description='CG5037 gene product from transcript CG5037-RA', other_designations='CG5037-PA|protoheme IX farnesyltransferase', map_location='31D9-31D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10331471, end_position_on_the_genomic_accession=10333129, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34395 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34395, CurrentID=0, Status='live', Symbol='GATAd', Aliases='Dmel_CG5034, CG5034, Dmel\\CG5034, dGATA-D, d', description='CG5034 gene product from transcript CG5034-RB', other_designations='CG5034-PA|CG5034-PB|CG5034-PC|GATAd-PA|GATAd-PB|GATAd-PC', map_location='31D9-31D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10333734, end_position_on_the_genomic_accession=10339185, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34396 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34396, CurrentID=0, Status='live', Symbol='SamDC', Aliases='Dmel_CG5029, CG5029, Dmel\\CG5029, l(2)31Dc, l(2)31Dd, l(2)31De', description='S-adenosylmethionine decarboxylase', other_designations='CG5029-PA|S-adenosyl decarboxylase|SamDC-PA', map_location='31D9-31D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10339457, end_position_on_the_genomic_accession=10341503, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34397 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34397, CurrentID=0, Status='live', Symbol='Sps2', Aliases='Dmel_CG5025, CG5025, Dmel\\CG5025, Dsps2, SPS2, dSPS2, dsps2, sps2', description='Selenophosphate synthetase 2', other_designations='CG5025-PA|CG5025-PC|Sps2-PA|Sps2-PC|selenophosphate synthetase 2', map_location='31D9-31D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10342594, end_position_on_the_genomic_accession=10344223, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34398 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34398, CurrentID=0, Status='live', Symbol='CG5022', Aliases='Dmel_ Dmel\\CG5022', description='CG5022 gene product from transcript CG5022-RA', other_designations='CG5022-PA', map_location='31D9-31D9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10344442, end_position_on_the_genomic_accession=10347706, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34401 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34401, CurrentID=0, Status='live', Symbol='CG5367', Aliases='Dmel_ Dmel\\CG5367', description='CG5367 gene product from transcript CG5367-RA', other_designations='CG5367-PA', map_location='31D10-31D10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10354743, end_position_on_the_genomic_accession=10356597, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34402 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34402, CurrentID=0, Status='live', Symbol='CG5045', Aliases='Dmel_ Dmel\\CG5045', description='CG5045 gene product from transcript CG5045-RB', other_designations='CG5045-PA|CG5045-PB', map_location='31D10-31D10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10356795, end_position_on_the_genomic_accession=10358078, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34403 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34403, CurrentID=0, Status='live', Symbol='Cand1', Aliases='Dmel_CG5366, BcDNA:GH07774, CAND1, CG5366, Dmel\\CG5366, dmCAND1', description='Cullin-associated and neddylation-dissociated 1', other_designations='CG5366-PA|CG5366-PB|Cand1-PA|Cand1-PB', map_location='31D10-31D10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10358134, end_position_on_the_genomic_accession=10362707, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34404 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34404, CurrentID=0, Status='live', Symbol='pim', Aliases='Dmel_CG5052, CG5052, Dmel\\CG5052, PIM, Pim, frag2, l(2)31Df', description='pimples', other_designations='CG5052-PA|CG5052-PB|PIMPLES|fragmented gonads 2|pim-PA|pim-PB|securin', map_location='2-30 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10362989, end_position_on_the_genomic_accession=10364092, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34405 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34405, CurrentID=0, Status='live', Symbol='lft', Aliases='Dmel_CG13139, CG13139, Dmel\\CG13139', description='lowfat', other_designations='CG13139-PA|CG13139-PB|lft-PA|lft-PB', map_location='31D10-31D10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10364471, end_position_on_the_genomic_accession=10366410, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34406 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34406, CurrentID=0, Status='live', Symbol='CG5056', Aliases='Dmel_ Dmel\\CG5056', description='CG5056 gene product from transcript CG5056-RA', other_designations='CG5056-PA', map_location='31D10-31D10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10366692, end_position_on_the_genomic_accession=10367946, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34408 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34408, CurrentID=0, Status='live', Symbol='dpr19', Aliases='Dmel_CG13140, BcDNA:LP09705, CG13140, Dmel\\CG13140, Dpr-19, Dpr19', description='defective proboscis extension response 19', other_designations='CG13140-PA|CG13140-PB|CG13140-PC|dpr19-PA|dpr19-PB|dpr19-PC', map_location='31D11-31D11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10376168, end_position_on_the_genomic_accession=10379905, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34409 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34409, CurrentID=0, Status='live', Symbol='gny', Aliases='Dmel_CG5091, CG5091, Dalg6, Dmel\\CG5091, Gny[, alg6, dAlg6', description='garnysstan', other_designations='CG5091-PA|CG5091-PB|gny-PA|gny-PB', map_location='31D11-31D11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10380103, end_position_on_the_genomic_accession=10382864, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34410 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34410, CurrentID=0, Status='live', Symbol='CG5096', Aliases='Dmel_ CT16355, Dmel\\CG5096', description='CG5096 gene product from transcript CG5096-RA', other_designations='CG5096-PA', map_location='31D11-31D11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10382263, end_position_on_the_genomic_accession=10384723, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34411 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34411, CurrentID=0, Status='live', Symbol='Cdk1', Aliases='Dmel_CG5363, 5363, CDC2, CDCDm, CDK1, CDK1/CDC2, CG5363, Cdc2, Cdk-1, Dcdc2, Dm cdc2, DmCdc2, DmCdk1, Dmcdc2, Dmel\\CG5363, cdc, cdc2, cdc2Dm, cdk1, dCdk1, group 4, l(2)31Eh', description='Cyclin-dependent kinase 1', other_designations='CG5363-PA|Cdk1-PA|cdc2|cdc2 kinase|cell division control|cyclin dependent kinase|cyclin-dependent kinase|protein 2', map_location='31D11-31D11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10384739, end_position_on_the_genomic_accession=10386262, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34412 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34412, CurrentID=0, Status='live', Symbol='mRpS7', Aliases='Dmel_CG5108, CG5108, Dmel\\CG5108, MRP-S7, RpS7, mRPS7', description='mitochondrial ribosomal protein S7', other_designations='CG5108-PA|CG5108-PB|mRpS7-PA|mRpS7-PB', map_location='31D11-31D11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10386662, end_position_on_the_genomic_accession=10387652, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34413 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34413, CurrentID=0, Status='live', Symbol='da', Aliases='Dmel_CG5102, 5102, CG5102, DA, Da, Dmel\\CG5102, bHLHb22, l(2)31Ea, l(2)k08611', description='daughterless', other_designations='CG5102-PA|CG5102-PB|CG5102-PC|da-PA|da-PB|da-PC|daughter-less|lethal (2) k08611', map_location='2-41.3 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10388105, end_position_on_the_genomic_accession=10393228, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34414 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34414, CurrentID=0, Status='live', Symbol='Mdh1', Aliases='Dmel_CG5362, CG5362, CT17038, Dmel\\CG5362, MDH, MDH-1, Mdh, Mdh-1, Mdh2, MdhD, cMdh, sMdh', description='Malate dehydrogenase 1', other_designations='CG5362-PA|CG5362-PB|Mdh1-PA|Mdh1-PB|cytoplasmic Mdh|cytosolic malate dehydrogenase|malate dehydrogenase|malate dehydrogenase 1|malic DH', map_location='2-37.2 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10393774, end_position_on_the_genomic_accession=10396332, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34416 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34416, CurrentID=0, Status='live', Symbol='Cnot4', Aliases='Dmel_CG31716, CG31716, CG5244, CG5251, Cont4, Dmel\\CG31716, NOT4, Not4, Q8IPB9_DROME, cg5251, not4', description='Cnot 4 homologue', other_designations='CG31716-PA|CG31716-PB|CG31716-PC|CG31716-PD|CG31716-PE|CG31716-PG|CG31716-PH|CG31716-PI|CG31716-PJ|CG31716-PK|CG31716-PL|Cnot4-PA|Cnot4-PB|Cnot4-PC|Cnot4-PD|Cnot4-PE|Cnot4-PG|Cnot4-PH|Cnot4-PI|Cnot4-PJ|Cnot4-PK|Cnot4-PL|cnot 4 homologue', map_location='31E1-31E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10396716, end_position_on_the_genomic_accession=10403206, orientation='plus', exon_count=18, OMIM='', no_hdr0=''),
  34419 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34419, CurrentID=0, Status='live', Symbol='Ip259', Aliases='Dmel_CG5277, CG5277, Dmel\\CG5277, IP259', description='Intronic Protein 259', other_designations='CG5277-PA|CG5277-PB|Ip259-PA|Ip259-PB|intronic protein 259', map_location='31E1-31E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10408352, end_position_on_the_genomic_accession=10409610, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34420 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34420, CurrentID=0, Status='live', Symbol='RpS27A', Aliases='Dmel_CG5271, CG5271, DUb80, Dmel\\CG5271, Dub80, UB3-D, Ubi-f80, Ubi-m, Ubiq, l(2)04820, l(2)31Ei, mfs(2)31, mfs(2)48, mfs48', description='Ribosomal protein S27A', other_designations='CG5271-PA|RpS27A-PA|Ubiquitin-monomeric|male female sterile 31|ribosomal protein S27A|ubiquitin|ubiquitin fusion 80', map_location='2-41.35 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10408352, end_position_on_the_genomic_accession=10410456, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34421 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34421, CurrentID=0, Status='live', Symbol='CG5355', Aliases='Dmel_ Dmel\\CG5355', description='CG5355 gene product from transcript CG5355-RA', other_designations='CG5355-PA', map_location='31E1-31E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10410537, end_position_on_the_genomic_accession=10413463, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34422 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34422, CurrentID=0, Status='live', Symbol='Klp31E', Aliases='Dmel_CG5300, CG5300, DmCG5300, DmKlp31D, DmKlp31E, Dmel\\CG5300, KIF 21A, KIF21A/B, KLP31E', description='Kinesin-like protein at 31E', other_designations='CG5300-PA|CG5300-PB|CG5300-PC|CG5300-PE|Klp31E-PA|Klp31E-PB|Klp31E-PC|Klp31E-PE', map_location='31E1-31E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10414017, end_position_on_the_genomic_accession=10418991, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  34423 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34423, CurrentID=0, Status='live', Symbol='RfC3', Aliases='Dmel_CG5313, CG5313, DRFC, DmRFC3, Dmel\\CG5313, Rfc3', description='Replication factor C subunit 3', other_designations='CG5313-PA|RfC3-PA|drosophila replication factor C|replication factor C subunit 3', map_location='31E1-31E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10419190, end_position_on_the_genomic_accession=10420612, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34425 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34425, CurrentID=0, Status='live', Symbol='CG5168', Aliases='Dmel_ Dmel\\CG5168', description='CG5168 gene product from transcript CG5168-RB', other_designations='CG5168-PA|CG5168-PB', map_location='31E1-31E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10423291, end_position_on_the_genomic_accession=10425482, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34426 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34426, CurrentID=0, Status='live', Symbol='SmB', Aliases='Dmel_CG5352, B, CG5352, Dmel\\CG5352, SYM10, Sm B1, dSmB, l(2)SH0509, l(2)SH2 0509, snRNP B, SmB', description='Small ribonucleoprotein particle protein SmB', other_designations='CG5352-PB|SmB-PB|lethal (2) SH0509|polypeptide B|small ribonucleoprotein particle protein B|small ribonucleoprotein particle protein SmB', map_location='31E1-31E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10425483, end_position_on_the_genomic_accession=10426627, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34427 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34427, CurrentID=0, Status='live', Symbol='KdelR', Aliases='Dmel_CG5183, BEST:CK00230, CG5183, CK00230, Dmel\\CG5183, ERD2, Erd2, dmErd2, l(2)31Em, l(2)k00311', description='KDEL receptor', other_designations='CG5183-PA|CG5183-PB|CG5183-PC|ER lumen protein retaining receptor 2|KDEL-receptor|KdelR-PA|KdelR-PB|KdelR-PC|lethal (2) 31Em', map_location='31E-31E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10426887, end_position_on_the_genomic_accession=10428632, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34428 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34428, CurrentID=0, Status='live', Symbol='CG5188', Aliases='Dmel_ Dmel\\CG5188, MAP1B', description='CG5188 gene product from transcript CG5188-RA', other_designations='CG5188-PA', map_location='31E1-31E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10428829, end_position_on_the_genomic_accession=10429988, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34429 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34429, CurrentID=0, Status='live', Symbol='Bug22', Aliases='Dmel_CG5343, CG5343, Dmel\\CG5343', description='Basal body up regulated gene 22 ortholog', other_designations='Bug22-PA|CG5343-PA|basal body up regulated gene 22 ortholog', map_location='31E1-31E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10429920, end_position_on_the_genomic_accession=10430918, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34430 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34430, CurrentID=0, Status='live', Symbol='TfIIB', Aliases='Dmel_CG5193, CG5193, Dmel\\CG5193, TFIIB, Tfiib, TfllB, dTFIIB, dTfIIB, dmTFIIB', description='Transcription factor IIB', other_designations='CG5193-PA|CG5193-PB|TfIIB-PA|TfIIB-PB|transcription factor IIB', map_location='31E2-31E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10431338, end_position_on_the_genomic_accession=10433116, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34431 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34431, CurrentID=0, Status='live', Symbol='CG5337', Aliases='Dmel_ Dmel\\CG5337', description='CG5337 gene product from transcript CG5337-RA', other_designations='CG5337-PA', map_location='31E2-31E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10432687, end_position_on_the_genomic_accession=10435656, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34432 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34432, CurrentID=0, Status='live', Symbol='holn1', Aliases='Dmel_CG5198, CG5198, Dmel\\CG5198', description='hole-in-one', other_designations='CG5198-PA|holn1-PA', map_location='31E2-31E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10435995, end_position_on_the_genomic_accession=10437316, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34433 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34433, CurrentID=0, Status='live', Symbol='CHIP', Aliases='Dmel_CG5203, CG5203, Chip, Dmel\\CG5203, dCHIP', description='CHIP ortholog', other_designations='CG5203-PA|CHIP-PA|NM 058093.3', map_location='31E2-31E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10437548, end_position_on_the_genomic_accession=10439240, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34434 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34434, CurrentID=0, Status='live', Symbol='Nse4', Aliases='Dmel_CG13142, CG13142, Dmel\\CG13142', description='Non-SMC element 4', other_designations='CG13142-PB|CG13142-PC|Nse4-PB|Nse4-PC', map_location='31E2-31E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10439440, end_position_on_the_genomic_accession=10441047, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34435 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34435, CurrentID=0, Status='live', Symbol='loh', Aliases='Dmel_CG6232, CG6232, CT19510, Dmel\\CG6232, Loh', description='lonely heart', other_designations='CG6232-PA|CG6232-PC|CG6232-PD|loh-PA|loh-PC|loh-PD', map_location='31E3-31E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10442534, end_position_on_the_genomic_accession=10450080, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  34436 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34436, CurrentID=0, Status='live', Symbol='LManI', Aliases='Dmel_CG5322, CG5322, Dmel\\CG5322', description='Lysosomal alpha-mannosidase I', other_designations='CG5322-PA|CG5322-PB|LManI-PA|LManI-PB|lysosomal alpha-mannosidase I', map_location='31E4-31E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10452677, end_position_on_the_genomic_accession=10457241, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34437 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34437, CurrentID=0, Status='live', Symbol='LManII', Aliases='Dmel_CG6206, BcDNA:GH02419, CG6206, Dmel\\CG6206, LM, LM408, dLM, dLM408', description='Lysosomal alpha-mannosidase II', other_designations='CG6206-PA|CG6206-PB|LManII-PA|LManII-PB|class II lysosomal alpha-mannosidase|lysosomal alpha-mannosidase|lysosomal alpha-mannosidase II|lysosomal mannosidase', map_location='31E5-31E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10457658, end_position_on_the_genomic_accession=10462472, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  34438 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34438, CurrentID=0, Status='live', Symbol='RluA-1', Aliases='Dmel_CG31719, CG13143, CG31719, CG7475, Dmel\\CG31719', description='CG31719 gene product from transcript CG31719-RD', other_designations='CG31719-PA|CG31719-PB|CG31719-PC|CG31719-PD|RluA-1-PA|RluA-1-PB|RluA-1-PC|RluA-1-PD|multiple', map_location='31E6-31F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10463340, end_position_on_the_genomic_accession=10474349, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  34440 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34440, CurrentID=0, Status='live', Symbol='RluA-2', Aliases='Dmel_CG6187, CG6187, Dmel\\CG6187, yumo', description='CG6187 gene product from transcript CG6187-RA', other_designations='CG6187-PA|CG6187-PC|CG6187-PD|CG6187-PE|RluA-2-PA|RluA-2-PC|RluA-2-PD|RluA-2-PE', map_location='31F1-31F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10477073, end_position_on_the_genomic_accession=10482975, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  34441 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34441, CurrentID=0, Status='live', Symbol='Grip75', Aliases='Dmel_CG6176, 75p, CG6176, D Dgrip75, Dgrip75/d75p, Dgrip75s, Dmel\\CG6176, d75p', description='CG6176 gene product from transcript CG6176-RA', other_designations='CG6176-PA|DGrip75|Grip75-PA', map_location='31F1-31F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10483295, end_position_on_the_genomic_accession=10485857, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34442 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34442, CurrentID=0, Status='live', Symbol='CG7456', Aliases='Dmel_ Dmel\\CG7456', description='CG7456 gene product from transcript CG7456-RA', other_designations='CG7456-PA', map_location='31F1-31F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10485538, end_position_on_the_genomic_accession=10488622, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34443 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34443, CurrentID=0, Status='live', Symbol='CG6144', Aliases='Dmel_ Dmel\\CG6144', description='CG6144 gene product from transcript CG6144-RB', other_designations='CG6144-PB|CG6144-PC', map_location='31F1-31F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10488694, end_position_on_the_genomic_accession=10490461, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34444 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34444, CurrentID=0, Status='live', Symbol='CG13144', Aliases='Dmel_ Dmel\\CG13144', description='CG13144 gene product from transcript CG13144-RA', other_designations='CG13144-PA|uncharacterized protein', map_location='31F1-31F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10489900, end_position_on_the_genomic_accession=10491454, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34445 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34445, CurrentID=0, Status='live', Symbol='Myo31DF', Aliases='Dmel_CG7438, CG7438, Dm IA, DmIA, Dmel\\CG7438, DroMIA, IA, MYOIA, Myo-IA, Myo1A, MyoIA, MyoID, myo31DF, myoID, souther', description='Myosin 31DF', other_designations='CG7438-PA|CG7438-PB|CG7438-PC|Myo31DF-PA|Myo31DF-PB|Myo31DF-PC|Myosin31DF|myosin 1D|myosin 1a|myosin 31DF|myosin I|myosin IA|myosin ID|myosin-IA|myosin1A|souther|unconventional myosin 31DF', map_location='31F1-31F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10491814, end_position_on_the_genomic_accession=10506779, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34446 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34446, CurrentID=0, Status='live', Symbol='CG6094', Aliases='Dmel_ Dmel\\CG6094, FBgn 32261', description='CG6094 gene product from transcript CG6094-RB', other_designations='CG6094-PA|CG6094-PB', map_location='31F4-31F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10507081, end_position_on_the_genomic_accession=10508032, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34447 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34447, CurrentID=0, Status='live', Symbol='CG7384', Aliases='Dmel_ Dmel\\CG7384', description='CG7384 gene product from transcript CG7384-RA', other_designations='CG7384-PA', map_location='31F4-31F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10507859, end_position_on_the_genomic_accession=10510453, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34449 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34449, CurrentID=0, Status='live', Symbol='Lrr47', Aliases='Dmel_CG6098, CG6098, CT19173, Dmel\\CG6098, LRR47, Lrr-47', description='Leucine-rich repeat 47', other_designations='CG6098-PA|CG6098-PB|Lrr47-PA|Lrr47-PB', map_location='31F5-31F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10517335, end_position_on_the_genomic_accession=10519269, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34450 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34450, CurrentID=0, Status='live', Symbol='Lip4', Aliases='Dmel_CG6113, CG6113, Dmel\\CG6113, dLip4, dlip4', description='Lipase 4', other_designations='CG6113-PA|CG6113-PB|CG6113-PC|Lip4-PA|Lip4-PB|Lip4-PC|lipase 4|lipase4', map_location='31F5-31F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10527572, end_position_on_the_genomic_accession=10531778, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34451 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34451, CurrentID=0, Status='live', Symbol='CG18301', Aliases='Dmel_ Dmel\\CG18301', description='CG18301 gene product from transcript CG18301-RA', other_designations='CG18301-PA|uncharacterized protein', map_location='31F5-31F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10531821, end_position_on_the_genomic_accession=10533647, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34452 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34452, CurrentID=0, Status='live', Symbol='CG18302', Aliases='Dmel_ Dmel\\CG18302', description='CG18302 gene product from transcript CG18302-RA', other_designations='CG18302-PA|uncharacterized protein', map_location='31F5-31F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10534322, end_position_on_the_genomic_accession=10536587, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34453 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34453, CurrentID=0, Status='live', Symbol='Trim9', Aliases='Dmel_CG31721, Asap, CG13145, CG31721, CG6256, Dmel\\CG31721, asap, dTrim9', description='Tripartite motif containing 9', other_designations='CG31721-PA|CG31721-PB|Trim9-PA|Trim9-PB|anomalies in sensory axon patterning|tripartite motif containing 9', map_location='31F5-32A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10544883, end_position_on_the_genomic_accession=10628054, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  34454 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34454, CurrentID=0, Status='live', Symbol='CG6138', Aliases='Dmel_ BcDNA:AT25107, Dmel\\CG6138', description='CG6138 gene product from transcript CG6138-RA', other_designations='CG6138-PA', map_location='32A1-32A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10567255, end_position_on_the_genomic_accession=10568012, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34455 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34455, CurrentID=0, Status='live', Symbol='w-cup', Aliases='Dmel_CG7363, BcDNA:AT31112, CG7363, Dmel\\CG7363', description='world cup', other_designations='CG7363-PA|CG7363-PB|w-cup-PA|w-cup-PB|world-cup', map_location='32A1-32A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10575860, end_position_on_the_genomic_accession=10577792, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34457 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34457, CurrentID=0, Status='live', Symbol='CG7329', Aliases='Dmel_ Dmel\\CG7329, ORE-4', description='CG7329 gene product from transcript CG7329-RB', other_designations='CG7329-PA|CG7329-PB', map_location='32A2-32A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10629352, end_position_on_the_genomic_accession=10638471, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34458 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34458, CurrentID=0, Status='live', Symbol='CG31872', Aliases='Dmel_ CG17093, CG17101, Dmel\\CG31872', description='CG31872 gene product from transcript CG31872-RB', other_designations='CG31872-PA|CG31872-PB|uncharacterized protein', map_location='32A2-32A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10639931, end_position_on_the_genomic_accession=10643539, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  5740143 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740143, CurrentID=0, Status='live', Symbol='CG34207', Aliases='Dmel_ Dmel\\CG34207', description='CG34207 gene product from transcript CG34207-RA', other_designations='CG34207-PA|uncharacterized protein', map_location='58D3-58D3', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=22329195, end_position_on_the_genomic_accession=22329720, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34460 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34460, CurrentID=0, Status='live', Symbol='CG18284', Aliases='Dmel_ Acp, BEST:GH10507, Dmel\\CG18284', description='CG18284 gene product from transcript CG18284-RC', other_designations='CG18284-PB|CG18284-PC|uncharacterized protein', map_location='32A2-32A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10643971, end_position_on_the_genomic_accession=10645891, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34461 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34461, CurrentID=0, Status='live', Symbol='CG17097', Aliases='Dmel_ Dmel\\CG17097, anon-SAGE:Wang-018', description='CG17097 gene product from transcript CG17097-RB', other_designations='CG17097-PB|anon-SAGE:Wang-018|uncharacterized protein', map_location='32A2-32A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10646415, end_position_on_the_genomic_accession=10650152, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34462 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34462, CurrentID=0, Status='live', Symbol='CG17098', Aliases='Dmel_ Dmel\\CG17098', description='CG17098 gene product from transcript CG17098-RA', other_designations='CG17098-PA|uncharacterized protein', map_location='32A2-32A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10651613, end_position_on_the_genomic_accession=10654499, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34463 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34463, CurrentID=0, Status='live', Symbol='CG31871', Aliases='Dmel_ CG17087, CG17099, Dmel\\CG31871', description='CG31871 gene product from transcript CG31871-RA', other_designations='CG31871-PA|uncharacterized protein', map_location='32A2-32A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10662081, end_position_on_the_genomic_accession=10671487, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34465 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34465, CurrentID=0, Status='live', Symbol='CG17104', Aliases='Dmel_ BEST:LD16579, Dmel\\CG17104', description='CG17104 gene product from transcript CG17104-RB', other_designations='CG17104-PA|CG17104-PB|CG17104-PC|uncharacterized protein', map_location='32A3-32A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10677198, end_position_on_the_genomic_accession=10679707, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34466 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34466, CurrentID=0, Status='live', Symbol='CG17105', Aliases='Dmel_ Dmel\\CG17105', description='CG17105 gene product from transcript CG17105-RB', other_designations='CG17105-PA|CG17105-PB|uncharacterized protein', map_location='32A4-32A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10681030, end_position_on_the_genomic_accession=10681775, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34467 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34467, CurrentID=0, Status='live', Symbol='CG17107', Aliases='Dmel_ Dmel\\CG17107', description='CG17107 gene product from transcript CG17107-RB', other_designations='CG17107-PA|CG17107-PB|CG17107-PC|uncharacterized protein', map_location='32A4-32A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10681902, end_position_on_the_genomic_accession=10682528, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34468 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34468, CurrentID=0, Status='live', Symbol='CG7299', Aliases='Dmel_ BcDNA:RE24635, CT22515, Dmel\\CG7299', description='CG7299 gene product from transcript CG7299-RC', other_designations='CG7299-PA|CG7299-PC', map_location='32A4-32A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10683427, end_position_on_the_genomic_accession=10684409, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34469 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34469, CurrentID=0, Status='live', Symbol='CG7296', Aliases='Dmel_ BcDNA:RH68528, Dmel\\CG7296', description='CG7296 gene product from transcript CG7296-RB', other_designations='CG7296-PA|CG7296-PB', map_location='32A4-32A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10686124, end_position_on_the_genomic_accession=10687066, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34470 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34470, CurrentID=0, Status='live', Symbol='CG7294', Aliases='Dmel_ BcDNA:RE28280, Dmel\\CG7294', description='CG7294 gene product from transcript CG7294-RA', other_designations='CG7294-PA', map_location='32A4-32A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10688734, end_position_on_the_genomic_accession=10689271, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34471 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34471, CurrentID=0, Status='live', Symbol='CG17108', Aliases='Dmel_ BEST:GH23489, CT33647, Dmel\\CG17108, gh23489', description='CG17108 gene product from transcript CG17108-RA', other_designations='CG17108-PA|uncharacterized protein', map_location='32A4-32A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10692940, end_position_on_the_genomic_accession=10694103, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34472 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34472, CurrentID=0, Status='live', Symbol='CG7300', Aliases='Dmel_ Dmel\\CG7300', description='CG7300 gene product from transcript CG7300-RD', other_designations='CG7300-PB|CG7300-PD', map_location='32A4-32A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10695000, end_position_on_the_genomic_accession=10698043, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34474 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34474, CurrentID=0, Status='live', Symbol='CG6415', Aliases='Dmel_ 151967_at, Dmel\\CG6415, anon-32Aa', description='CG6415 gene product from transcript CG6415-RA', other_designations='CG6415-PA', map_location='32A4-32A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10703621, end_position_on_the_genomic_accession=10704930, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34476 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34476, CurrentID=0, Status='live', Symbol='CG6431', Aliases='Dmel_ Dmel\\CG6431, chr2L_10724193_10724543.0', description='CG6431 gene product from transcript CG6431-RC', other_designations='CG6431-PB|CG6431-PC', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10724203, end_position_on_the_genomic_accession=10728740, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34477 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34477, CurrentID=0, Status='live', Symbol='CG6443', Aliases='Dmel_ Dmel\\CG6443', description='CG6443 gene product from transcript CG6443-RA', other_designations='CG6443-PA', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10728978, end_position_on_the_genomic_accession=10730302, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34478 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34478, CurrentID=0, Status='live', Symbol='CG17118', Aliases='Dmel_ Dmel\\CG17118', description='CG17118 gene product from transcript CG17118-RA', other_designations='CG17118-PA|uncharacterized protein', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10730255, end_position_on_the_genomic_accession=10731356, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34479 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34479, CurrentID=0, Status='live', Symbol='EMC3', Aliases='Dmel_CG6750, CG6750, Dmel\\CG6750, dPob', description='ER Membrane protein Complex 3', other_designations='CG6750-PA|EMC3-PA|ER membrane protein complex 3', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10731400, end_position_on_the_genomic_accession=10732423, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34480 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34480, CurrentID=0, Status='live', Symbol='Dpy-30L1', Aliases='Dmel_CG6444, CG6444, DPY30, Dmel\\CG6444, Dpy30, dDPY30-L1, dpy-30L1, dpy30', description='Dpy-30-like 1', other_designations='CG6444-PA|Dpy-30L1-PA', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10732653, end_position_on_the_genomic_accession=10733307, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34481 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34481, CurrentID=0, Status='live', Symbol='Nup107', Aliases='Dmel_CG6743, BcDNA:LD18761, CG6743, Dmel\\CG6743, Nup 107, Nup170, dmNup107, nup107', description='Nucleoporin 107kD', other_designations='CG6743-PA|Nup107-PA|Nup170|nucleoporin 107|nucleoporin 107kD', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10733293, end_position_on_the_genomic_accession=10736071, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34482 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34482, CurrentID=0, Status='live', Symbol='Vha16-5', Aliases='Dmel_CG6737, CG6737, Dmel\\CG6737, vha16-5', description='Vacuolar H[+] ATPase 16kD subunit 5', other_designations='CG6737-PA|Vha16-5-PA|vacuolar H[+] ATPase 16kD subunit 5|vacuolar H[+] ATPase subunit 16-5', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10736319, end_position_on_the_genomic_accession=10737043, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34483 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34483, CurrentID=0, Status='live', Symbol='CG12299', Aliases='Dmel_ Dmel\\CG12299', description='CG12299 gene product from transcript CG12299-RA', other_designations='CG12299-PA|uncharacterized protein', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10737345, end_position_on_the_genomic_accession=10740762, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34484 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34484, CurrentID=0, Status='live', Symbol='CG6729', Aliases='Dmel_ Dmel\\CG6729', description='CG6729 gene product from transcript CG6729-RA', other_designations='CG6729-PA', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10740782, end_position_on_the_genomic_accession=10743935, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34485 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34485, CurrentID=0, Status='live', Symbol='CG17124', Aliases='Dmel_ Dmel\\CG17124, anon-WO0118547.153', description='CG17124 gene product from transcript CG17124-RB', other_designations='CG17124-PA|CG17124-PB|CG17124-PC|uncharacterized protein', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10744075, end_position_on_the_genomic_accession=10756325, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34486 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34486, CurrentID=0, Status='live', Symbol='CG6495', Aliases='Dmel_ BcDNA:GH10711, Dmel\\CG6495, GH10711', description='CG6495 gene product from transcript CG6495-RA', other_designations='CG6495-PA', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10761116, end_position_on_the_genomic_accession=10764971, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34487 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34487, CurrentID=0, Status='live', Symbol='Ubc2', Aliases='Dmel_CG6720, CG6720, Dmel\\CG6720, UbcD2, l(2)k13206, ubcD2', description='Ubiquitin conjugating enzyme 2', other_designations='CG6720-PA|CG6720-PB|CG6720-PC|CG6720-PD|Ubc2-PA|Ubc2-PB|Ubc2-PC|Ubc2-PD|ubiquitin conjugating enzyme 2', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10765010, end_position_on_the_genomic_accession=10768006, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34488 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34488, CurrentID=0, Status='live', Symbol='CG6724', Aliases='Dmel_ Dmel\\CG6724', description='CG6724 gene product from transcript CG6724-RB', other_designations='CG6724-PA|CG6724-PB', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10768234, end_position_on_the_genomic_accession=10769952, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34489 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34489, CurrentID=0, Status='live', Symbol='CG17127', Aliases='Dmel_ Dmel\\CG17127', description='CG17127 gene product from transcript CG17127-RB', other_designations='CG17127-PA|CG17127-PB|uncharacterized protein', map_location='32A5-32A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10770868, end_position_on_the_genomic_accession=10771370, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34490 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34490, CurrentID=0, Status='live', Symbol='CG31869', Aliases='Dmel_ CG17130, CG18499, Dmel\\CG31869', description='CG31869 gene product from transcript CG31869-RC', other_designations='CG31869-PA|CG31869-PB|CG31869-PC|uncharacterized protein', map_location='32A5-32B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10772038, end_position_on_the_genomic_accession=10801109, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34493 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34493, CurrentID=0, Status='live', Symbol='CG6508', Aliases='Dmel_ Dmel\\CG6508', description='CG6508 gene product from transcript CG6508-RA', other_designations='CG6508-PA', map_location='32B1-32B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10819107, end_position_on_the_genomic_accession=10820485, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34494 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34494, CurrentID=0, Status='live', Symbol='CG17134', Aliases='Dmel_ Dmel\\CG17134', description='CG17134 gene product from transcript CG17134-RA', other_designations='CG17134-PA|uncharacterized protein', map_location='32B1-32B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10820705, end_position_on_the_genomic_accession=10821967, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34495 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34495, CurrentID=0, Status='live', Symbol='Nos', Aliases='Dmel_CG6713, CG6713, DNOS, DNOS1, Dmel\\CG6713, NOS, dNOS, dNos, drNOSoxy, nNOS, nos', description='Nitric oxide synthase', other_designations='CG6713-PA|CG6713-PF|CG6713-PK|NO synthase|Nos-PA|Nos-PF|Nos-PK|nitric oixide synthase|nitric oxide synthase', map_location='32B1-32B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10804274, end_position_on_the_genomic_accession=10837511, orientation='minus', exon_count=20, OMIM='', no_hdr0=''),
  34496 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34496, CurrentID=0, Status='live', Symbol='CG6700', Aliases='Dmel_ Dmel\\CG6700', description='CG6700 gene product from transcript CG6700-RA', other_designations='CG6700-PA|CG6700-PB', map_location='32B1-32B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10837732, end_position_on_the_genomic_accession=10842597, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34497 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34497, CurrentID=0, Status='live', Symbol='CG17139', Aliases='Dmel_ CG31722, CG31722-A, Dmel\\CG17139', description='CG17139 gene product from transcript CG17139-RA', other_designations='CG17139-PA|uncharacterized protein', map_location='32B1-32B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10843014, end_position_on_the_genomic_accession=10845664, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34499 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34499, CurrentID=0, Status='live', Symbol='Porin2', Aliases='Dmel_CG17137, BEST:LP07660, CG17137, Dm Dmel\\CG17137, LP07660.3prime, Porin 2, porin 2', description='CG17137 gene product from transcript CG17137-RB', other_designations='CG17137-PA|CG17137-PB|Porin2-PA|Porin2-PB|porin 2|porin2', map_location='32B1-32B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10845788, end_position_on_the_genomic_accession=10847044, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34500 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34500, CurrentID=0, Status='live', Symbol='porin', Aliases='Dmel_CG6647, CG6647, DVDAC, DmPorin1, DmVDAC, Dmel\\CG6647, POR-1, PORIN, Porin, VDAC, Vdac, anon-WO02059370.56, cg6647, l(2)k05123', description='CG6647 gene product from transcript CG6647-RB', other_designations='CG6647-PA|CG6647-PB|CG6647-PC|CG6647-PD|CG6647-PE|Voltage-dependent anion-selective channel|mitochondrial porin|porin 1|porin-PA|porin-PB|porin-PC|porin-PD|porin-PE|voltage-dependent anion channel', map_location='32B1-32B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10847227, end_position_on_the_genomic_accession=10850848, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34502 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34502, CurrentID=0, Status='live', Symbol='CG43129', Aliases='Dmel_ CG17085, CG17086, Dmel\\CG43129, Dmel_CG17085, Dmel_CG17086', description='CG43129 gene product from transcript CG43129-RE', other_designations='CG43129-PC|CG43129-PD|CG43129-PE|uncharacterized protein', map_location='32B1-32B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10850141, end_position_on_the_genomic_accession=10854604, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34503 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34503, CurrentID=0, Status='live', Symbol='Dnz1', Aliases='Dmel_CG6627, CG6627, DNZ1, Dmel\\CG6627', description='DNZDHHC/NEW1 zinc finger protein 11', other_designations='CG6627-PA|DNZDHHC/NEW1 zinc-finger protein 11|Dnz1-PA', map_location='32B1-32B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10854435, end_position_on_the_genomic_accession=10856644, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34504 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34504, CurrentID=0, Status='live', Symbol='aurB', Aliases='Dmel_CG6620, ABK, Aur B, AurB, Aurora B, Aurora-B, CG6620, DmAIRK2, DmAurB, DmAuroraB, Dmel\\CG6620, IAL, IAL1, Ial, ial, ial/AurB', description='aurora B', other_designations='AURORA-like|CG6620-PA|DmAuroraB|IplI-aurora-like kinase|aurB-PA|aurora|aurora B kinase|aurora-B|auroraB|dAurora B', map_location='32B2-32B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10856797, end_position_on_the_genomic_accession=10858094, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34505 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34505, CurrentID=0, Status='live', Symbol='Stam', Aliases='Dmel_CG6521, CG6521, Dmel\\CG6521, Dstam, STAM1, dstam, stam, Stam', description='Signal transducing adaptor molecule', other_designations='CG6521-PA|Stam-PA|signal transducer adaptor molecule|signal transducing adaptor molecule|signal-transducing adaptor molecule', map_location='32B2-32B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10858536, end_position_on_the_genomic_accession=10862006, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34506 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34506, CurrentID=0, Status='live', Symbol='CG12517', Aliases='Dmel_ Dmel\\CG12517', description='CG12517 gene product from transcript CG12517-RA', other_designations='CG12517-PA|uncharacterized protein', map_location='32B3-32B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10870167, end_position_on_the_genomic_accession=10870722, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34507 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34507, CurrentID=0, Status='live', Symbol='CG14071', Aliases='Dmel_ Dmel\\CG14071', description='CG14071 gene product from transcript CG14071-RB', other_designations='CG14071-PA|CG14071-PB|CG14071-PC|uncharacterized protein', map_location='32B3-32B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10887645, end_position_on_the_genomic_accession=10888927, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34508 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34508, CurrentID=0, Status='live', Symbol='CG14070', Aliases='Dmel_ Dmel\\CG14070', description='CG14070 gene product from transcript CG14070-RB', other_designations='CG14070-PA|CG14070-PB|uncharacterized protein', map_location='32B4-32B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10900501, end_position_on_the_genomic_accession=10901785, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34509 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34509, CurrentID=0, Status='live', Symbol='CG7309', Aliases='Dmel_ Dmel\\CG7309', description='CG7309 gene product from transcript CG7309-RC', other_designations='CG7309-PC', map_location='32B4-32B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10906270, end_position_on_the_genomic_accession=10908893, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34510 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34510, CurrentID=0, Status='live', Symbol='CG14069', Aliases='Dmel_ Dmel\\CG14069', description='CG14069 gene product from transcript CG14069-RB', other_designations='CG14069-PA|CG14069-PB|uncharacterized protein', map_location='32B4-32B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10910051, end_position_on_the_genomic_accession=10910648, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  5740152 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740152, CurrentID=0, Status='live', Symbol='CG34342', Aliases='Dmel_ CG10629, CG32422, Dmel\\CG34342, Dmel_CG10629, Dmel_CG32422', description='CG34342 gene product from transcript CG34342-RE', other_designations='CG34342-PD|CG34342-PE|uncharacterized protein', map_location='64D2-64D2', chromosome='3L', genomic_nucleotide_accession_version='NT_037436.4', start_position_on_the_genomic_accession=5503528, end_position_on_the_genomic_accession=5510860, orientation='minus', exon_count=11, OMIM='', no_hdr0=''),
  34514 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34514, CurrentID=0, Status='live', Symbol='CG33129', Aliases='Dmel_ CG6087, CG6089, Dmel\\CG33129', description='CG33129 gene product from transcript CG33129-RF', other_designations='CG33129-PA|CG33129-PB|CG33129-PC|CG33129-PE|CG33129-PF|CG33129-PG|CG33129-PH|uncharacterized protein', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10964905, end_position_on_the_genomic_accession=10970275, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34516 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34516, CurrentID=0, Status='live', Symbol='YL-1', Aliases='Dmel_CG4621, CG4621, Dmel\\CG4621, d', description='CG4621 gene product from transcript CG4621-RB', other_designations='CG4621-PA|CG4621-PB|YL-1-PA|YL-1-PB', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10970443, end_position_on_the_genomic_accession=10972093, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34517 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34517, CurrentID=0, Status='live', Symbol='CG16743', Aliases='Dmel_ BcDNA:RH23514, Dmel\\CG16743', description='CG16743 gene product from transcript CG16743-RB', other_designations='CG16743-PA|CG16743-PB|uncharacterized protein', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10972280, end_position_on_the_genomic_accession=10973408, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34519 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34519, CurrentID=0, Status='live', Symbol='SCAR', Aliases='Dmel_CG4636, BEST:SD02991, CG4636, D-SCAR, DWave, DmSCAR, Dmel\\CG4636, Dscar/WAVE, Scar, WAVE, WAVE/SCAR, Wave, dWAVE, l(2)k03107, l(2)k13811, scar, wave', description='CG4636 gene product from transcript CG4636-RD', other_designations='CG4636-PA|CG4636-PB|CG4636-PC|CG4636-PD|CG4636-PE|CG4636-PF|SCAR-PA|SCAR-PB|SCAR-PC|SCAR-PD|SCAR-PE|SCAR-PF|WASP family verprolin-homologous protein|scar|suppressor of cAMP receptors|suppressor of cAR|suppressor of cyclic AMP receptor', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10976772, end_position_on_the_genomic_accession=10982395, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34521 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34521, CurrentID=0, Status='live', Symbol='piwi', Aliases='Dmel_CG6122, CG6122, Dmel\\CG6122, PIWI, Piwi', description='CG6122 gene product from transcript CG6122-RA', other_designations='CG6122-PA|CG6122-PB|P-element induced wimpy testis|piwi-PA|piwi-PB', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10982205, end_position_on_the_genomic_accession=10987420, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34524 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34524, CurrentID=0, Status='live', Symbol='aub', Aliases='Dmel_CG6137, AUB, Aub, CG6137, Dmel\\CG6137, ms(2)32D, sti, sting', description='aubergine', other_designations='CG6137-PA|CG6137-PC|aub-PA|aub-PC|stellate-interacting gene', map_location='2-39 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=10997819, end_position_on_the_genomic_accession=11001476, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  5740154 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740154, CurrentID=0, Status='live', Symbol='CG34222', Aliases='Dmel_ Dmel\\CG34222, NEST:bs08e11, NEST:bs11e07, NEST:bs12c06', description='CG34222 gene product from transcript CG34222-RA', other_designations='CG34222-PA|NEST:bs08e11|NEST:bs11e07|NEST:bs12c06|uncharacterized protein', map_location='47A1-47A1', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=10319844, end_position_on_the_genomic_accession=10320500, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34526 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34526, CurrentID=0, Status='live', Symbol='RpL9', Aliases='Dmel_CG6141, CG6141, Dmel\\CG6141, L9, M(2)32D, Rp L9, Rpl9, anon-EST:fe3A6, anon-WO0153538.25, anon-WO0153538.26, anon-WO0153538.27, rpL9', description='Ribosomal protein L9', other_designations='CG6141-PA|CG6141-PB|CG6141-PC|RpL9-PA|RpL9-PB|RpL9-PC|anon-fast-evolving-3A6|ribosomal protein L9', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11002758, end_position_on_the_genomic_accession=11004189, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34527 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34527, CurrentID=0, Status='live', Symbol='Nup154', Aliases='Dmel_CG4579, BcDNA:LD21772, CG4579, Dmel\\CG4579, Nup, Nup155, Nup32D, l(2)01501, l(2)10432, ms(2)zk, nup154, nup32D, tip, tlp, zk', description='Nucleoporin 154kD', other_designations='CG4579-PA|CG4579-PC|CG4579-PD|Nup154-PA|Nup154-PC|Nup154-PD|nucleoporin 154|nucleoporin 154kD|tulipano|zonder kloten', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11004820, end_position_on_the_genomic_accession=11010921, orientation='plus', exon_count=12, OMIM='', no_hdr0=''),
  34528 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34528, CurrentID=0, Status='live', Symbol='Art8', Aliases='Dmel_CG16840, CG16840, DART7, DART8, Dmel\\CG16840, dART8', description='Arginine methyltransferase 8', other_designations='Art8-PA|CG16840-PA|arginine methyltransferase 8', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11009821, end_position_on_the_genomic_accession=11011086, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34529 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34529, CurrentID=0, Status='live', Symbol='dUTPase', Aliases='Dmel_CG4584, BcDNA:LD08534, CG4584, Dmel\\CG4584, LD08534, UTPase, anon-SAGE:Wang-077', description='Deoxyuridine triphosphatase', other_designations='CG4584-PA|CG4584-PB|CG4584-PC|CG4584-PD|anon-SAGE:Wang-077|dUTPase-PA|dUTPase-PB|dUTPase-PC|dUTPase-PD|deoxyuridine triphosphatase', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11011312, end_position_on_the_genomic_accession=11012135, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34530 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34530, CurrentID=0, Status='live', Symbol='Samuel', Aliases='Dmel_CG31868, 78BP, CG12291, CG14917, CG14918, CG31868, Dmel\\CG31868, Moses, mdcds_1002, moses', description='SAM-motif ubiquitously expressed punctatedly localized protein', other_designations='CG31868-PA|CG31868-PB|CG31868-PD|CG31868-PE|Samuel-PA|Samuel-PB|Samuel-PD|Samuel-PE|middleman of seventy-eight signaling', map_location='32C1-32D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11013206, end_position_on_the_genomic_accession=11066998, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34531 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34531, CurrentID=0, Status='live', Symbol='Acp32CD', Aliases='Dmel_CG4605, CG4605, Dmel\\CG4605', description='Accessory gland protein 32CD', other_designations='Acp32CD-PA|Acp32CD-PB|CG4605-PA|CG4605-PB|accessory gland protein 32CD|accessory gland-specific peptide 32CD', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11015620, end_position_on_the_genomic_accession=11016571, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34532 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34532, CurrentID=0, Status='live', Symbol='CG14913', Aliases='Dmel_ Dmel\\CG14913', description='CG14913 gene product from transcript CG14913-RB', other_designations='CG14913-PB|uncharacterized protein', map_location='32C1-32C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11016995, end_position_on_the_genomic_accession=11018778, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34536 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34536, CurrentID=0, Status='live', Symbol='CG14915', Aliases='Dmel_ Dmel\\CG14915', description='CG14915 gene product from transcript CG14915-RA', other_designations='CG14915-PA|uncharacterized protein', map_location='32D2-32D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11071027, end_position_on_the_genomic_accession=11071532, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34537 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34537, CurrentID=0, Status='live', Symbol='AstC', Aliases='Dmel_CG14919, ASC, AST-C, ASTC, Ast-C, Ast2, BEST:GH06087, BcDNA:RH36507, CG14919, CG149199, DAP-C, Dmel\\CG14919, Drm-AST-C, FLT, Flt, M-ASH, ast2, flt, gh06087', description='Allatostatin C', other_designations='AstC-PA|AstC-PB|CG14919-PA|CG14919-PB|Drm-AST C|Drostatin-C|allatostatin 2|allatostatin C|allatostatin Manduca-type|allatostatin-C|flatline', map_location='32D2-32D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11076165, end_position_on_the_genomic_accession=11081399, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34538 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34538, CurrentID=0, Status='live', Symbol='AstCC', Aliases='Dmel_CG14920, ASCC, ASTCC, Ast-CC, CG14920, Dmel\\CG14920', description='Allatostatin double C', other_designations='AstCC-PB|AstCC-PC|CG14920-PB|CG14920-PC|allatostatin CC|allatostatin double C', map_location='32D2-32D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11083459, end_position_on_the_genomic_accession=11085229, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34539 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34539, CurrentID=0, Status='live', Symbol='CG16854', Aliases='Dmel_ Dmel\\CG16854, gi7297815', description='CG16854 gene product from transcript CG16854-RD', other_designations='CG16854-PB|CG16854-PC|CG16854-PD|uncharacterized protein', map_location='32D2-32D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11086721, end_position_on_the_genomic_accession=11090973, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34540 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34540, CurrentID=0, Status='live', Symbol='CG4705', Aliases='Dmel_ Dmel\\CG4705, FBtr0080196, SEA3', description='CG4705 gene product from transcript CG4705-RD', other_designations='CG4705-PB|CG4705-PD', map_location='32D2-32D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11091444, end_position_on_the_genomic_accession=11095096, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34541 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34541, CurrentID=0, Status='live', Symbol='Ge-1', Aliases='Dmel_CG6181, CG6181, Dmel\\CG6181, EDC4, GE-1, dGe-1', description='Ge-1 ortholog (H. sapiens)', other_designations='CG6181-PA|CG6181-PB|Ge-1 ortholog|Ge-1-PA|Ge-1-PB', map_location='32D3-32D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11095150, end_position_on_the_genomic_accession=11100888, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34542 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34542, CurrentID=0, Status='live', Symbol='Reps', Aliases='Dmel_CG6192, CG6192, Dmel\\CG6192, REPS', description='CG6192 gene product from transcript CG6192-RB', other_designations='CG6192-PA|CG6192-PB|Reps-PA|Reps-PB|reps', map_location='32D3-32D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11100963, end_position_on_the_genomic_accession=11106645, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34543 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34543, CurrentID=0, Status='live', Symbol='l(2)gd1', Aliases='Dmel_CG4713, CG4713, Dmel\\CG4713, SH495, gd, l(2)SH0495, l(2)SH2 0495, l(2)gd, l(2)giant disc, l[[2]]gd, lgd', description='lethal (2) giant discs 1', other_designations='CG4713-PA|CG4713-PB|l(2)gd1-PA|l(2)gd1-PB|leathal giant disc|lethal (2) SH0495|lethal (2) giant discs|lethal giant discs', map_location='32D3-32D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11106943, end_position_on_the_genomic_accession=11110851, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34544 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34544, CurrentID=0, Status='live', Symbol='CG6201', Aliases='Dmel_ Dmel\\CG6201', description='CG6201 gene product from transcript CG6201-RA', other_designations='CG6201-PA', map_location='32D4-32D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11110557, end_position_on_the_genomic_accession=11113061, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34545 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34545, CurrentID=0, Status='live', Symbol='Gr32a', Aliases='Dmel_CG14916, 32D.1, 32D1, CG14916, Dmel\\CG14916, GR32D.1, GR32D1, GR32a, Gr32A, Gr32D1, Gr32d', description='Gustatory receptor 32a', other_designations='CG14916-PA|Gr32a-PA|gustatory receptor 32D.1|gustatory receptor 32a', map_location='32D4-32D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11114014, end_position_on_the_genomic_accession=11115823, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34546 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34546, CurrentID=0, Status='live', Symbol='CG6230', Aliases='Dmel_ BcDNA:GH06032, Dmel\\CG6230, dCOD1', description='CG6230 gene product from transcript CG6230-RA', other_designations='CG6230-PA', map_location='32D4-32D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11115635, end_position_on_the_genomic_accession=11120319, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34547 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34547, CurrentID=0, Status='live', Symbol='CG14921', Aliases='Dmel_ Dmel\\CG14921', description='CG14921 gene product from transcript CG14921-RA', other_designations='CG14921-PA|uncharacterized protein', map_location='32D4-32D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11120642, end_position_on_the_genomic_accession=11121714, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34548 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34548, CurrentID=0, Status='live', Symbol='Csl4', Aliases='Dmel_CG6249, CG6249, CSL4, Dmel\\CG6249, d', description='CG6249 gene product from transcript CG6249-RA', other_designations='CG6249-PA|Csl4-PA', map_location='32D4-32D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11122574, end_position_on_the_genomic_accession=11123567, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34549 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34549, CurrentID=0, Status='live', Symbol='Nup160', Aliases='Dmel_CG4738, CG4738, Dmel\\CG4738, Nup[mel], l(2)SH2 2055, l(2)SH2055, nup160, Nup160', description='Nucleoporin 160kD', other_designations='CG4738-PA|CG4738-PB|Nup160-PA|Nup160-PB|lethal (2) SH2055|nuclear pore protein 160|nucleoporin 160|nucleoporin 160kD', map_location='32D4-32D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11123777, end_position_on_the_genomic_accession=11129335, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  34550 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34550, CurrentID=0, Status='live', Symbol='RfC38', Aliases='Dmel_CG6258, BcDNA:LD06837, CG6258, DmRFC5, Dmel\\CG6258, Rfc38, l(2)k13807, l(2)rfc38, n(2)k13807', description='Replication factor C 38kD subunit', other_designations='CG6258-PA|CG6258-PB|DNA replication factor, 38k subunit|RfC38-PA|RfC38-PB|replication factor C 38kD subunit', map_location='32D4-32D4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11128932, end_position_on_the_genomic_accession=11130645, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34551 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34551, CurrentID=0, Status='live', Symbol='CG4751', Aliases='Dmel_ Dmel\\CG4751, Q9VKJ1', description='CG4751 gene product from transcript CG4751-RA', other_designations='CG4751-PA', map_location='32D4-32D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11130737, end_position_on_the_genomic_accession=11136003, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34552 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34552, CurrentID=0, Status='live', Symbol='hgo', Aliases='Dmel_CG4779, CG4779, Dmel\\CG4779', description='homogentisate 1,2-dioxygenase', other_designations='CG4779-PA|hgo-PA', map_location='32D5-32D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11136393, end_position_on_the_genomic_accession=11138565, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34553 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34553, CurrentID=0, Status='live', Symbol='Gyc32E', Aliases='Dmel_CG33114, CG33114, CG6275, Cyg1, DMRGC, Dmel\\CG33114, GC, GYC 32E, Gyc-r', description='Guanyl cyclase at 32E', other_designations='CG33114-PB|CG33114-PD|CG33114-PG|Gyc32E-PB|Gyc32E-PD|Gyc32E-PG|guanyl cyclase at 32E|guanylate cyclase receptor-type', map_location='32D5-32D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11138759, end_position_on_the_genomic_accession=11149101, orientation='minus', exon_count=24, OMIM='', no_hdr0=''),
  34554 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34554, CurrentID=0, Status='live', Symbol='CG6287', Aliases='Dmel_ Dmel\\CG6287, GH26', description='CG6287 gene product from transcript CG6287-RA', other_designations='CG6287-PA', map_location='32D5-32D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11151506, end_position_on_the_genomic_accession=11155721, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34557 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34557, CurrentID=0, Status='live', Symbol='Ca-beta', Aliases='Dmel_CG42403, CG14922, CG14923, CG33305, CG42403, CG6320, CaBeta, DmCa1beta, Dmel\\CG42403, Dmel_CG33305, Dmel_CG6320, ca-beta, dmcab1', description='Ca2+-channel-protein-beta-subunit', other_designations='CG42403-PE|CG42403-PG|CG42403-PJ|CG42403-PL|CG42403-PM|CG42403-PN|CG42403-PO|CG42403-PP|CG42403-PQ|Ca-beta-PE|Ca-beta-PG|Ca-beta-PJ|Ca-beta-PL|Ca-beta-PM|Ca-beta-PN|Ca-beta-PO|Ca-beta-PP|Ca-beta-PQ|Ca2+-channel-protein beta subunit|Ca[2+]-channel-protein-beta-subunit|calcium channel beta|calcium channel beta subunit', map_location='32D5-32E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11156118, end_position_on_the_genomic_accession=11203544, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  34558 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34558, CurrentID=0, Status='live', Symbol='Vm32E', Aliases='Dmel_CG16874, CG16874, Dmel\\CG16874, VM321, VM32E, VMP32E, Vm3a, Vm32Ec, Vm32E', description='Vitelline membrane 32E', other_designations='CG16874-PA|CG16874-PB|Vm32E-PA|Vm32E-PB|vitelline membrane 32E', map_location='32E1-32E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11171167, end_position_on_the_genomic_accession=11171665, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34559 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34559, CurrentID=0, Status='live', Symbol='CG4788', Aliases='Dmel_ Dmel\\CG4788', description='CG4788 gene product from transcript CG4788-RA', other_designations='CG4788-PA|CG4788-PB', map_location='32E1-32E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11179032, end_position_on_the_genomic_accession=11180430, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34560 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34560, CurrentID=0, Status='live', Symbol='ab', Aliases='Dmel_CG43860, Ab, B2149, CG32830, CG43860, CG4807, Dmel\\CG43860, Dmel_CG32830, Dmel_CG4807, clu, l(2)k02807, ptd', description='abrupt', other_designations='CG43860-PA|CG43860-PB|CG43860-PD|CG43860-PE|CG43860-PF|ab-PA|ab-PB|ab-PD|ab-PE|ab-PF|clueless|parted', map_location='2-44.0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11210678, end_position_on_the_genomic_accession=11261080, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  34564 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34564, CurrentID=0, Status='live', Symbol='Ppt2', Aliases='Dmel_CG4851, CG4851, Dmel\\CG4851, PPT-2', description='Palmitoyl-protein Thioesterase 2', other_designations='CG4851-PA|Palmitoyl-protein thioesterase 2|Ppt2-PA', map_location='32E2-32E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11280298, end_position_on_the_genomic_accession=11281920, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34565 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34565, CurrentID=0, Status='live', Symbol='mre11', Aliases='Dmel_CG16928, 16928, CG16928, Dmel\\CG16928, MRE11, Mre11', description='meiotic recombination 11', other_designations='CG16928-PA|mre11-PA', map_location='32E2-32E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11282090, end_position_on_the_genomic_accession=11284335, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34566 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34566, CurrentID=0, Status='live', Symbol='Osi21', Aliases='Dmel_CG14925, CG14925, Dmel\\CG14925', description='Osiris 21', other_designations='CG14925-PA|Osi21-PA|osiris|osiris 21', map_location='32E2-32E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11284327, end_position_on_the_genomic_accession=11285706, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34567 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34567, CurrentID=0, Status='live', Symbol='CG14926', Aliases='Dmel_ Dmel\\CG14926, bs34f02.y1', description='CG14926 gene product from transcript CG14926-RB', other_designations='CG14926-PA|CG14926-PB|CG14926-PC|uncharacterized protein', map_location='32E4-32E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11342301, end_position_on_the_genomic_accession=11343318, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34568 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34568, CurrentID=0, Status='live', Symbol='salr', Aliases='Dmel_CG4881, 32F, CG4881, Cf3, Dmel\\CG4881, Sal-r, Salr, Spalt, sal, sal-r, salR, spalt', description='spalt-related', other_designations='CG4881-PA|CG4881-PB|CG4881-PC|Spalt-related|chorion factor 3|sal related|sal-related|salr-PA|salr-PB|salr-PC|spalt|spalt related', map_location='32E4-32F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11358873, end_position_on_the_genomic_accession=11373636, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34569 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34569, CurrentID=0, Status='live', Symbol='salm', Aliases='Dmel_CG6464, 3602, B1164, CG6464, Dmel\\CG6464, SAL, SALM, SPALT, Sal, SalM, Salm, Spalt, l(2)03602, sal, salII, salM, slam, spalt', description='spalt major', other_designations='CG6464-PA|CG6464-PB|Spalt-M|sal major|salm-PA|salm-PB|spalt|spalt M|spalt majr|spalt-major', map_location='2-44 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11434311, end_position_on_the_genomic_accession=11445614, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34570 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34570, CurrentID=0, Status='live', Symbol='sala', Aliases='Dmel_CG4922, BcDNA:RE40068, CG4922, Dmel\\CG4922, chr2L:11486634..11486740, nsal, sal', description='spalt-adjacent', other_designations='CG4922-PA|CG4922-PC|not-spalt|sal adjacent|sala-PA|sala-PC|spalt|spalt accessory', map_location='2-44 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11484707, end_position_on_the_genomic_accession=11486949, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34571 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34571, CurrentID=0, Status='live', Symbol='CG6488', Aliases='Dmel_ Dmel\\CG6488', description='CG6488 gene product from transcript CG6488-RA', other_designations='CG6488-PA', map_location='32F2-32F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11496804, end_position_on_the_genomic_accession=11498948, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34572 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34572, CurrentID=0, Status='live', Symbol='spz4', Aliases='Dmel_CG14928, CG14928, CT34755, Dmel\\CG14928, Spz4', description='spatzle 4', other_designations='CG14928-PB|spz4-PB', map_location='32F2-32F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11501715, end_position_on_the_genomic_accession=11508649, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34573 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34573, CurrentID=0, Status='live', Symbol='CG6509', Aliases='Dmel_ DLG5, Dlg5, Dmel\\CG6509, LD32687', description='CG6509 gene product from transcript CG6509-RA', other_designations='CG6509-PA|CG6509-PB|CG6509-PC|CG6509-PD', map_location='32F2-32F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11508399, end_position_on_the_genomic_accession=11517081, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  34576 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34576, CurrentID=0, Status='live', Symbol='CG14930', Aliases='Dmel_ Dmel\\CG14930', description='CG14930 gene product from transcript CG14930-RA', other_designations='CG14930-PA|uncharacterized protein', map_location='32F2-32F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11520358, end_position_on_the_genomic_accession=11521285, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34577 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34577, CurrentID=0, Status='live', Symbol='CG31705', Aliases='Dmel_ BcDNA:GH07269, CG6528, Dmel\\CG31705', description='CG31705 gene product from transcript CG31705-RE', other_designations='CG31705-PA|CG31705-PD|CG31705-PE|uncharacterized protein', map_location='32F2-32F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11523021, end_position_on_the_genomic_accession=11528205, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34578 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34578, CurrentID=0, Status='live', Symbol='Mst33A', Aliases='Dmel_CG6541, CG6541, Dmel\\CG6541', description='CG6541 gene product from transcript CG6541-RB', other_designations='CG6541-PA|CG6541-PB|CG6541-PC|Mst33A-PA|Mst33A-PB|Mst33A-PC', map_location='32F3-32F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11585433, end_position_on_the_genomic_accession=11586833, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34581 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34581, CurrentID=0, Status='live', Symbol='spag4', Aliases='Dmel_CG6589, CG6589, Dmel\\CG6589, Dspag4, dspag, giac', description='sperm-associated antigen 4', other_designations='CG6589-PB|giacomo|spag4-PB', map_location='32F4-32F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11610510, end_position_on_the_genomic_accession=11611772, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34582 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34582, CurrentID=0, Status='live', Symbol='kek2', Aliases='Dmel_CG4977, CG4977, CT15962, Dmel\\CG4977, Kek2, NB7', description='kekkon-2', other_designations='CG4977-PA|kek2-PA|kekkon', map_location='32F4-32F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11581937, end_position_on_the_genomic_accession=11626883, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34583 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34583, CurrentID=0, Status='live', Symbol='CG6614', Aliases='Dmel_ Dmel\\CG6614', description='CG6614 gene product from transcript CG6614-RC', other_designations='CG6614-PA|CG6614-PB|CG6614-PC', map_location='32F4-32F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11644619, end_position_on_the_genomic_accession=11648839, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34584 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34584, CurrentID=0, Status='live', Symbol='CG12307', Aliases='Dmel_ Dmel\\CG12307', description='CG12307 gene product from transcript CG12307-RA', other_designations='CG12307-PA|uncharacterized protein', map_location='32F4-32F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11651331, end_position_on_the_genomic_accession=11652010, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34585 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34585, CurrentID=0, Status='live', Symbol='CG4983', Aliases='Dmel_ Dmel\\CG4983, anon-WO0140519.134', description='CG4983 gene product from transcript CG4983-RB', other_designations='CG4983-PA|CG4983-PB', map_location='32F4-32F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11652448, end_position_on_the_genomic_accession=11654164, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34586 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34586, CurrentID=0, Status='live', Symbol='CG4988', Aliases='Dmel_ Dmel\\CG4988', description='CG4988 gene product from transcript CG4988-RA', other_designations='CG4988-PA', map_location='33A1-33A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11694804, end_position_on_the_genomic_accession=11696107, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34587 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34587, CurrentID=0, Status='live', Symbol='Vha100-5', Aliases='Dmel_CG12602, CG12602, Dmel\\CG12602, vha100-5', description='Vacuolar H[+] ATPase 100kD subunit 5', other_designations='CG12602-PA|CG12602-PB|Vha100-5-PA|Vha100-5-PB|vacuolar H[+] ATPase 100kD subunit 5|vacuolar H[+] ATPase subunit 100-5', map_location='33A1-33A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11738948, end_position_on_the_genomic_accession=11744524, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34588 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34588, CurrentID=0, Status='live', Symbol='CG14931', Aliases='Dmel_ Dmel\\CG14931', description='CG14931 gene product from transcript CG14931-RC', other_designations='CG14931-PB|CG14931-PC|uncharacterized protein', map_location='33A1-33A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11788334, end_position_on_the_genomic_accession=11789475, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34589 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34589, CurrentID=0, Status='live', Symbol='CG14932', Aliases='Dmel_ Dmel\\CG14932', description='CG14932 gene product from transcript CG14932-RB', other_designations='CG14932-PB|CG14932-PC|uncharacterized protein', map_location='33A1-33A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11789919, end_position_on_the_genomic_accession=11791011, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34590 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34590, CurrentID=0, Status='live', Symbol='Tsp33B', Aliases='Dmel_CG14936, CG14936, Dm.Tsp33B, Dmel\\CG14936', description='Tetraspanin 33B', other_designations='CG14936-PA|Tsp33B-PA|tetraspanin 33B', map_location='33A1-33A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11791025, end_position_on_the_genomic_accession=11792365, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34591 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34591, CurrentID=0, Status='live', Symbol='CG14937', Aliases='Dmel_ Dmel\\CG14937, FBXO17', description='CG14937 gene product from transcript CG14937-RA', other_designations='CG14937-PA|uncharacterized protein', map_location='33A1-33A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11792412, end_position_on_the_genomic_accession=11794086, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34592 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34592, CurrentID=0, Status='live', Symbol='crol', Aliases='Dmel_CG14938, CG14938, Crol, Dmel\\CG14938, ORE-15, anon-EST:Liang-1.74, anon-EST:Liang-2.48, clone 1.74, clone 2.48 alpha, crol beta, crol gamma, l(2)04418, l(2)s2346, crol', description='crooked legs', other_designations='CG14938-PA|CG14938-PB|CG14938-PC|CG14938-PD|CG14938-PE|CG14938-PF|CG14938-PG|CG14938-PH|CG14938-PI|crol-PA|crol-PB|crol-PC|crol-PD|crol-PE|crol-PF|crol-PG|crol-PH|crol-PI|crooked-legs', map_location='33A1-33A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11794327, end_position_on_the_genomic_accession=11809438, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34593 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34593, CurrentID=0, Status='live', Symbol='CycY', Aliases='Dmel_CG14939, CG14939, Dcyclin Y, Dmel\\CG14939, anon-WO0118547.165, i182', description='Cyclin Y', other_designations='CG14939-PA|CG14939-PB|CycY-PA|CycY-PB|cyclin Y|drosophila cyclin Y', map_location='33A2-33A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11810092, end_position_on_the_genomic_accession=11813780, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34594 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34594, CurrentID=0, Status='live', Symbol='Pde1c', Aliases='Dmel_CG44007, CG14940, CG14942, CG14943, CG14944, CG31757, CG31758, CG42325, CG44007, Dmel\\CG44007, Dmel_CG14940, Dmel_CG14943, Dmel_CG14944, Dmel_CG31757, Dmel_CG31758, Dmel_CG42325, PDE1C, PDE1c, mdcds_1440', description='CG44007 gene product from transcript CG44007-RG', other_designations='CG44007-PB|CG44007-PC|CG44007-PD|CG44007-PE|CG44007-PG|CG44007-PH|CG44007-PJ|CG44007-PK|CG44007-PL|Pde1c-PB|Pde1c-PC|Pde1c-PD|Pde1c-PE|Pde1c-PG|Pde1c-PH|Pde1c-PJ|Pde1c-PK|Pde1c-PL|phosphodiesterase 1c', map_location='33A8-33B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11814156, end_position_on_the_genomic_accession=11928572, orientation='minus', exon_count=16, OMIM='', no_hdr0=''),
  34595 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34595, CurrentID=0, Status='live', Symbol='esc', Aliases='Dmel_CG14941, CG14941, Dmel\\CG14941, ESC, Esc, L41867, dESC, sc', description='extra sexcombs', other_designations='CG14941-PA|esc-PA|extra Sex combs|extra sex comb', map_location='33A2-33A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11827204, end_position_on_the_genomic_accession=11829405, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34597 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34597, CurrentID=0, Status='live', Symbol='Mal-B1', Aliases='Dmel_CG14934, CG14934, Dmel\\CG14934, Drome_B1, mal_B1', description='Maltase B1', other_designations='CG14934-PA|Mal-B1-PA|maltase B1', map_location='33A3-33A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11847226, end_position_on_the_genomic_accession=11849169, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34598 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34598, CurrentID=0, Status='live', Symbol='Mal-B2', Aliases='Dmel_CG14935, CG14935, Dmel\\CG14935, Drome_B2, FBgn0032382, mal_B2', description='Maltase B2', other_designations='CG14935-PA|CG14935-PC|CG14935-PD|Mal-B2-PA|Mal-B2-PC|Mal-B2-PD|maltase B2', map_location='33A4-33A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11849958, end_position_on_the_genomic_accession=11852881, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34601 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34601, CurrentID=0, Status='live', Symbol='Or33a', Aliases='Dmel_CG16960, 33B.1, 33a, AN3, CG16960, DOR33B.1, DOR73, Dmel\\CG16960, Or33B.1, Or73, dor73', description='Odorant receptor 33a', other_designations='CG16960-PA|Or33a-PA|odorant receptor 33a|olfactory receptor 33B.1', map_location='33B2-33B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11934505, end_position_on_the_genomic_accession=11935716, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34602 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34602, CurrentID=0, Status='live', Symbol='Or33b', Aliases='Dmel_CG16961, 33B.2, 33b, AN1, CG16961, DOR33B.2, DOR72, Dmel\\CG16961, Or33B.2, Or72, dor72', description='Odorant receptor 33b', other_designations='CG16961-PA|Or33b-PA|odorant receptor 33b|olfactory receptor 33B.2', map_location='33B2-33B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11936181, end_position_on_the_genomic_accession=11937501, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34603 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34603, CurrentID=0, Status='live', Symbol='Or33c', Aliases='Dmel_CG5006, 33B.3, 33c, AN2, CG5006, DOR33B.3, DOR71, Dmel\\CG5006, Or33B.3, Or71, dor71', description='Odorant receptor 33c', other_designations='CG5006-PA|Or33c-PA|odorant receptor 33c|olfactory receptor 33B.3', map_location='33B2-33B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11937969, end_position_on_the_genomic_accession=11939202, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34604 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34604, CurrentID=0, Status='live', Symbol='Crys', Aliases='Dmel_CG16963, CG16963, Cry, DmelCry, Dmel\\CG16963, c, dcy', description='Crystallin', other_designations='CG16963-PA|CG16963-PB|Crys-PA|Crys-PB|crystallin|cyrstallin|ddosocrystallin|droscrystallin|drosocrystallin', map_location='33B2-33B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11944129, end_position_on_the_genomic_accession=11947131, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34605 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34605, CurrentID=0, Status='live', Symbol='CG16964', Aliases='Dmel_ BcDNA:GH05159, Dmel\\CG16964', description='CG16964 gene product from transcript CG16964-RB', other_designations='CG16964-PA|CG16964-PB|uncharacterized protein', map_location='33B2-33B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11947941, end_position_on_the_genomic_accession=11948803, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34607 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34607, CurrentID=0, Status='live', Symbol='CG16965', Aliases='Dmel_ Dmel\\CG16965', description='CG16965 gene product from transcript CG16965-RC', other_designations='CG16965-PC|uncharacterized protein', map_location='33B5-33B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11981591, end_position_on_the_genomic_accession=11984380, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34608 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34608, CurrentID=0, Status='live', Symbol='CG6686', Aliases='Dmel_ Dmel\\CG6686, SART1', description='CG6686 gene product from transcript CG6686-RB', other_designations='CG6686-PA|CG6686-PB|CG6686-PC', map_location='33B5-33B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11984327, end_position_on_the_genomic_accession=11988039, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34609 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34609, CurrentID=0, Status='live', Symbol='zuc', Aliases='Dmel_CG12314, CG12314, Dmel\\CG12314, ZUC, Zuc', description='zucchini', other_designations='CG12314-PA|zuc-PA', map_location='33B5-33F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11988735, end_position_on_the_genomic_accession=11989882, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34610 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34610, CurrentID=0, Status='live', Symbol='dgt2', Aliases='Dmel_CG16969, CG16969, Dgt2, Dmel\\CG16969', description='dim gamma-tubulin 2', other_designations='CG16969-PA|CG16969-PB|dgt2-PA|dgt2-PB', map_location='33B5-33B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11989936, end_position_on_the_genomic_accession=11990979, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34611 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34611, CurrentID=0, Status='live', Symbol='escl', Aliases='Dmel_CG5202, CG5202, CG5202-PA, Dmel\\CG5202, ESC, ESC-LIKE, ESC1, ESCL', description='CG5202 gene product from transcript CG5202-RA', other_designations='CG5202-PA|CG5202-PC|esc-like|escl-PA|escl-PC', map_location='33B5-33B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11990927, end_position_on_the_genomic_accession=11992848, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34613 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34613, CurrentID=0, Status='live', Symbol='CG12264', Aliases='Dmel_CG12264-PA, Dmel\\CG12264', description='CG12264 gene product from transcript CG12264-RA', other_designations='CG12264-PA|IscS homologue|uncharacterized protein', map_location='33B5-33B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=11999654, end_position_on_the_genomic_accession=12001244, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34614 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34614, CurrentID=0, Status='live', Symbol='CG6746', Aliases='Dmel_ Dmel\\CG6746', description='CG6746 gene product from transcript CG6746-RA', other_designations='CG6746-PA', map_location='33B5-33B6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12001234, end_position_on_the_genomic_accession=12002266, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34615 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34615, CurrentID=0, Status='live', Symbol='Rh5', Aliases='Dmel_CG5279, CG5279, DMELRH5, Dm Rh5, Dmel\\CG5279, RH5, Rh, rh5', description='Rhodopsin 5', other_designations='CG5279-PA|CG5279-PB|Rh5-PA|Rh5-PB|Rhodopsin5|rhodopsin|rhodopsin 5|rhodopsin-5', map_location='33B8-33B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12008153, end_position_on_the_genomic_accession=12009832, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34616 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34616, CurrentID=0, Status='live', Symbol='CG6734', Aliases='Dmel_ Dmel\\CG6734, cg6734', description='CG6734 gene product from transcript CG6734-RA', other_designations='CG6734-PA', map_location='33B8-33B9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12014304, end_position_on_the_genomic_accession=12020960, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34618 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34618, CurrentID=0, Status='live', Symbol='Tom70', Aliases='Dmel_CG6756, CG6756, Dmel\\CG6756, RE66761p, dtom70', description='Translocase of outer membrane 70', other_designations='CG6756-PA|CG6756-PB|CG6756-PC|Tom70-PA|Tom70-PB|Tom70-PC|translocase of outer membrane 70', map_location='33B9-33B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12035984, end_position_on_the_genomic_accession=12038511, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34619 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34619, CurrentID=0, Status='live', Symbol='CG6766', Aliases='Dmel_ Dmel\\CG6766, cg6766', description='CG6766 gene product from transcript CG6766-RA', other_designations='CG6766-PA', map_location='33B10-33B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12038631, end_position_on_the_genomic_accession=12040689, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34620 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34620, CurrentID=0, Status='live', Symbol='CG6785', Aliases='Dmel_ Dmel\\CG6785, cg6785', description='CG6785 gene product from transcript CG6785-RA', other_designations='CG6785-PA|CG6785-PB|CG6785-PC', map_location='33B10-33B11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12041054, end_position_on_the_genomic_accession=12045200, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34621 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34621, CurrentID=0, Status='live', Symbol='CG6770', Aliases='Dmel_ CT21019, Dmel\\CG6770, anon-WO02059370.25, p8', description='CG6770 gene product from transcript CG6770-RA', other_designations='CG6770-PA', map_location='33B11-33B11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12045343, end_position_on_the_genomic_accession=12046118, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34622 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34622, CurrentID=0, Status='live', Symbol='Plzf', Aliases='Dmel_CG6792, CG6792, Dmel\\CG6792, PLZF, cg6792, dPLZF', description='Promyelocytic leukemia zinc finger ortholog', other_designations='CG6792-PA|CG6792-PB|Plzf-PA|Plzf-PB|promyelocytic leukemia zinc finger ortholog', map_location='33B11-33B11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12046711, end_position_on_the_genomic_accession=12048918, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34623 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34623, CurrentID=0, Status='live', Symbol='CG14945', Aliases='Dmel_ Dmel\\CG14945, cg14945', description='CG14945 gene product from transcript CG14945-RB', other_designations='CG14945-PA|CG14945-PB|uncharacterized protein', map_location='33B11-33B11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12049418, end_position_on_the_genomic_accession=12052049, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34624 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34624, CurrentID=0, Status='live', Symbol='JhI-21', Aliases='Dmel_CG12317, CG12317, Dmel\\CG12317, JHI-21, Jhl-21', description='CG12317 gene product from transcript CG12317-RE', other_designations='CG12317-PA|CG12317-PB|CG12317-PC|CG12317-PD|CG12317-PE|JhI-21-PA|JhI-21-PB|JhI-21-PC|JhI-21-PD|JhI-21-PE', map_location='33B11-33C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12051755, end_position_on_the_genomic_accession=12056042, orientation='minus', exon_count=10, OMIM='', no_hdr0=''),
  34625 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34625, CurrentID=0, Status='live', Symbol='RpL7-like', Aliases='Dmel_CG5317, CG5317, Dmel\\CG5317', description='Ribosomal protein L7-like', other_designations='CG5317-PA|CG5317-PB|CG5317-PC|RpL7-like-PA|RpL7-like-PB|RpL7-like-PC|ribosomal protein L7-like', map_location='33C1-33C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12056326, end_position_on_the_genomic_accession=12058251, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34626 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34626, CurrentID=0, Status='live', Symbol='Rab3-GAP', Aliases='Dmel_CG7061, BcDNA:LD23336, CG7061, Dmel\\CG7061, rab3-GAP', description='Rab3 GTPase activating protein', other_designations='CG7061-PA|CG7061-PB|Rab3-GAP-PA|Rab3-GAP-PB|rab3-GAP', map_location='33C1-33C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12058304, end_position_on_the_genomic_accession=12063184, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34627 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34627, CurrentID=0, Status='live', Symbol='CG14946', Aliases='Dmel_ Dmel\\CG14946', description='CG14946 gene product from transcript CG14946-RD', other_designations='CG14946-PC|CG14946-PD|CG14946-PE|uncharacterized protein', map_location='33C2-33C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12063457, end_position_on_the_genomic_accession=12066775, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34628 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34628, CurrentID=0, Status='live', Symbol='CG14947', Aliases='Dmel_ Dmel\\CG14947', description='CG14947 gene product from transcript CG14947-RA', other_designations='CG14947-PA|uncharacterized protein', map_location='33C2-33C2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12076100, end_position_on_the_genomic_accession=12077739, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34629 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34629, CurrentID=0, Status='live', Symbol='prd', Aliases='Dmel_CG6716, CG6716, Dmel\\CG6716, PRD, Prd, pr', description='paired', other_designations='CG6716-PA|CG6716-PB|prd-PA|prd-PB', map_location='2-45 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12082995, end_position_on_the_genomic_accession=12085827, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34630 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34630, CurrentID=0, Status='live', Symbol='Pex19', Aliases='Dmel_CG5325, BEST:GH03076, CG5325, DmelPex19, Dmel\\CG5325, PEX19, Pex-19', description='Peroxin 19', other_designations='CG5325-PA|CG5325-PC|Pex19-PA|Pex19-PC|peroxin 19|peroxisomal farnesylated protein', map_location='33C4-33C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12091822, end_position_on_the_genomic_accession=12095250, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34631 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34631, CurrentID=0, Status='live', Symbol='CG6712', Aliases='Dmel_ Dmel\\CG6712, ORF2', description='CG6712 gene product from transcript CG6712-RA', other_designations='CG6712-PA', map_location='33C4-33C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12095176, end_position_on_the_genomic_accession=12096511, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34632 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34632, CurrentID=0, Status='live', Symbol='Mt2', Aliases='Dmel_CG10692, CG10692, DNMT, DNMT2, DmMT2, Dmel\\CG10692, Dnmt, Dnmt2, dDNMT, dDNMT2, dDnmt2, dnmt2, nmt2', description='Methyltransferase 2', other_designations='CG10692-PC|CG10692-PD|DNA methyltransferase 2|DNA(5-cytosine) methyltransferase|Mt2-PC|Mt2-PD|cytosine-5 methyltransferase|methyltransferase 2', map_location='33C4-33C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12096525, end_position_on_the_genomic_accession=12097687, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34633 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34633, CurrentID=0, Status='live', Symbol='Ced-12', Aliases='Dmel_CG5336, CG5336, Ced12, Dced-12, Dmel\\CG5336, ELMO, Elmo, ced-12, d dced-12, elmo', description='CG5336 gene product from transcript CG5336-RA', other_designations='CG5336-PA|Ced-12-PA|engulfment and cell motility', map_location='33C4-33C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12097838, end_position_on_the_genomic_accession=12100839, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34634 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34634, CurrentID=0, Status='live', Symbol='Patsas', Aliases='Dmel_CG6618, CG6618, Dmel\\CG6618', description='CG6618 gene product from transcript CG6618-RA', other_designations='CG6618-PA|Patsas-PA|patsas', map_location='33C4-33C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12100765, end_position_on_the_genomic_accession=12103285, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34636 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34636, CurrentID=0, Status='live', Symbol='Rab6', Aliases='Dmel_CG6601, 136/6, AAF53168, CG6601, D Dm Rab6, DmRab6, Dmel\\CG6601, Drab6, O18334, dRab6, drab6, l(2)08323, rab6, wrt', description='CG6601 gene product from transcript CG6601-RB', other_designations='CG6601-PA|CG6601-PB|Rab protein 6|Rab-protein 6|Rab6-PA|Rab6-PB|warthog', map_location='33C4-33C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12107221, end_position_on_the_genomic_accession=12109116, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34637 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34637, CurrentID=0, Status='live', Symbol='Phae1', Aliases='Dmel_CG16996, CG16996, Dmel\\CG16996, SP134', description='Phaedra 1', other_designations='CG16996-PA|CG16996-PB|Phae1-PA|Phae1-PB|phaedra 1', map_location='33C4-33C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12109417, end_position_on_the_genomic_accession=12110664, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34638 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34638, CurrentID=0, Status='live', Symbol='Phae2', Aliases='Dmel_CG16997, CG16997, Dmel\\CG16997, SP147', description='Phaedra 2', other_designations='CG16997-PB|CG16997-PC|Phae2-PB|Phae2-PC|phaedra 2', map_location='33C4-33C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12111110, end_position_on_the_genomic_accession=12112256, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34639 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34639, CurrentID=0, Status='live', Symbol='CG17211', Aliases='Dmel_ Dmel\\CG17211', description='CG17211 gene product from transcript CG17211-RA', other_designations='CG17211-PA|uncharacterized protein', map_location='33D2-33D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12114360, end_position_on_the_genomic_accession=12129896, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34640 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34640, CurrentID=0, Status='live', Symbol='rho-6', Aliases='Dmel_CG17212, CG17212, Dmel\\CG17212, Rho-related [33C1], rho 6, rho6', description='rhomboid-6', other_designations='CG17212-PB|CG17212-PC|Rhomboid-6|rho-6-PB|rho-6-PC', map_location='33D2-33D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12130516, end_position_on_the_genomic_accession=12133411, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34641 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34641, CurrentID=0, Status='live', Symbol='Gr33a', Aliases='Dmel_CG17213, CG17213, Dmel\\CG17213, GR33a, Gr33C1', description='Gustatory receptor 33a', other_designations='CG17213-PA|Gr33a-PA|gustatory receptor 33C1|gustatory receptor 33a', map_location='33D2-33D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12138008, end_position_on_the_genomic_accession=12140392, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34642 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34642, CurrentID=0, Status='live', Symbol='CG31760', Aliases='Dmel_ BcDNA:RE52162, CG17214, CG17215, Dmel\\CG31760', description='CG31760 gene product from transcript CG31760-RC', other_designations='CG31760-PB|CG31760-PC|CG31760-PD|uncharacterized protein', map_location='33D2-33D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12142780, end_position_on_the_genomic_accession=12170508, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  34644 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34644, CurrentID=0, Status='live', Symbol='CG17217', Aliases='Dmel_ Dmel\\CG17217', description='CG17217 gene product from transcript CG17217-RA', other_designations='CG17217-PA|uncharacterized protein', map_location='33D2-33D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12170550, end_position_on_the_genomic_accession=12171232, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34645 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34645, CurrentID=0, Status='live', Symbol='CG6583', Aliases='Dmel_ Dmel\\CG6583', description='CG6583 gene product from transcript CG6583-RA', other_designations='CG6583-PA', map_location='33D2-33D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12171204, end_position_on_the_genomic_accession=12172586, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34646 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34646, CurrentID=0, Status='live', Symbol='crok', Aliases='Dmel_CG17218, BcDNA:RE65321, CG17218, Dmel\\CG17218', description='crooked', other_designations='CG17218-PA|crok-PA', map_location='33D2-33D2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12172981, end_position_on_the_genomic_accession=12174091, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34647 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34647, CurrentID=0, Status='live', Symbol='atilla', Aliases='Dmel_CG6579, CG6579, Dmel\\CG6579', description='CG6579 gene product from transcript CG6579-RB', other_designations='CG6579-PB|CG6579-PC|atilla-PB|atilla-PC', map_location='33D2-33D3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12175451, end_position_on_the_genomic_accession=12177886, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34648 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34648, CurrentID=0, Status='live', Symbol='aret', Aliases='Dmel_CG31762, ARET, Aret, BcDNA:GM15173, Bru, Bruno, CG31762, CG6319, Dm Bru, Dmel\\CG31762, NEST:bs01g04, NEST:bs34h11/bruno1, arrest/Bruno, bru, bruno, ms(2)01284, aret', description='arrest', other_designations='CG31762-PA|CG31762-PB|CG31762-PD|CG31762-PE|CG31762-PF|CG31762-PG|CG31762-PH|CG31762-PI|CG31762-PJ|CG31762-PK|aret-PA|aret-PB|aret-PD|aret-PE|aret-PF|aret-PG|aret-PH|aret-PI|aret-PJ|aret-PK|bruno', map_location='33D3-33D5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12175004, end_position_on_the_genomic_accession=12313438, orientation='plus', exon_count=20, OMIM='', no_hdr0=''),
  34650 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34650, CurrentID=0, Status='live', Symbol='CG17010', Aliases='Dmel_ Dmel\\CG17010', description='CG17010 gene product from transcript CG17010-RA', other_designations='CG17010-PA|uncharacterized protein', map_location='33E1-33E1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12356441, end_position_on_the_genomic_accession=12357906, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34651 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34651, CurrentID=0, Status='live', Symbol='Pkd2', Aliases='Dmel_CG6504, AMO, Amo, CG6504, Dmel\\CG6504, Dmpkd2, PKD2, TRPP, amo, pkd2', description='Polycystic kidney disease 2 ortholog (H. sapiens)', other_designations='CG6504-PA|Pkd2-PA|almost there|polycystic kidney disease 2 ortholog|polycystic kidney disease gene-2|polycystin-2', map_location='33E3-33E3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12398274, end_position_on_the_genomic_accession=12402023, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  34652 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34652, CurrentID=0, Status='live', Symbol='vir-1', Aliases='Dmel_CG31764, BEST:GH02216, CG15493, CG31764, CG5453, Dmel\\CG31764, Vir-1, Vir1, vir1', description='virus-induced RNA 1', other_designations='CG31764-PA|CG31764-PB|CG31764-PC|CG31764-PD|CG31764-PE|CG31764-PG|CG31764-PH|vir-1-PA|vir-1-PB|vir-1-PC|vir-1-PD|vir-1-PE|vir-1-PG|vir-1-PH|virus induced RNA-1|virus-induced 1|virus-induced RNA1', map_location='33E3-33E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12403270, end_position_on_the_genomic_accession=12423439, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34654 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34654, CurrentID=0, Status='live', Symbol='CG6405', Aliases='Dmel_ Dmel\\CG6405', description='CG6405 gene product from transcript CG6405-RA', other_designations='CG6405-PA', map_location='33E4-33E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12424904, end_position_on_the_genomic_accession=12426440, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34655 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34655, CurrentID=0, Status='live', Symbol='CG5446', Aliases='Dmel_ BcDNA:RE36920, Dmel\\CG5446', description='CG5446 gene product from transcript CG5446-RC', other_designations='CG5446-PA|CG5446-PB|CG5446-PC', map_location='33E4-33E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12426631, end_position_on_the_genomic_accession=12427709, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34656 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34656, CurrentID=0, Status='live', Symbol='CG6388', Aliases='Dmel_ Dmel\\CG6388', description='CG6388 gene product from transcript CG6388-RA', other_designations='CG6388-PA', map_location='33E4-33E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12428028, end_position_on_the_genomic_accession=12430021, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  5740176 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740176, CurrentID=0, Status='live', Symbol='CG34340', Aliases='Dmel_ CG10017, CG2808, Dmel\\CG34340, Dmel_CG10017, Dmel_CG2808', description='CG34340 gene product from transcript CG34340-RF', other_designations='CG34340-PE|CG34340-PF|uncharacterized protein', map_location='24A5-24B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=3662745, end_position_on_the_genomic_accession=3692114, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34658 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34658, CurrentID=0, Status='live', Symbol='Elf', Aliases='Dmel_CG6382, CG6382, DSUP35, Dmel\\CG6382, Dsup35, delf, dsup35, eRF3, elf', description='Ef1alpha-like factor', other_designations='CG6382-PA|CG6382-PB|CG6382-PC|CG6382-PD|Elf-PA|Elf-PB|Elf-PC|Elf-PD|eukaryotic release factor 3', map_location='33E4-33E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12434452, end_position_on_the_genomic_accession=12441279, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34660 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34660, CurrentID=0, Status='live', Symbol='Oatp33Ea', Aliases='Dmel_CG5427, CG5427, Dmel\\CG5427, oatp 33Ea', description='Organic anion transporting polypeptide 33Ea', other_designations='CG5427-PA|CG5427-PB|Oatp33Ea-PA|Oatp33Ea-PB|organic anion transporting polypeptide 33Ea', map_location='33E5-33E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12441401, end_position_on_the_genomic_accession=12445924, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34661 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34661, CurrentID=0, Status='live', Symbol='CG5421', Aliases='Dmel_ Dmel\\CG5421', description='CG5421 gene product from transcript CG5421-RB', other_designations='CG5421-PA|CG5421-PB', map_location='33E5-33E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12446080, end_position_on_the_genomic_accession=12448132, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34662 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34662, CurrentID=0, Status='live', Symbol='Oatp33Eb', Aliases='Dmel_CG6417, CG6417, Dmel\\CG6417, oatp 33Eb', description='Organic anion transporting polypeptide 33Eb', other_designations='CG6417-PA|Oatp33Eb-PA|organic anion transporting polypeptide 33Eb', map_location='33E5-33E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12448484, end_position_on_the_genomic_accession=12452047, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34663 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34663, CurrentID=0, Status='live', Symbol='CG5418', Aliases='Dmel_ Dmel\\CG5418', description='CG5418 gene product from transcript CG5418-RA', other_designations='CG5418-PA', map_location='33E5-33E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12451945, end_position_on_the_genomic_accession=12453242, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34665 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34665, CurrentID=0, Status='live', Symbol='bun', Aliases='Dmel_CG42281, 1550, Bun, BunA, CG31857, CG42281, CG5461, Dm_2L:60722, Dmel\\CG42281, Dmel_CG31857, Dmel_CG5461, EP(2)0488, TSC-22, Tsc22, bnc, l(2)00255, l(2)02687, l(2)05479, l(2)06475, l(2)k02903, l(2)rI043, shs', description='bunched', other_designations='CG42281-PA|CG42281-PB|CG42281-PC|CG42281-PD|CG42281-PE|CG42281-PF|CG42281-PG|CG42281-PH|CG42281-PO|CG42281-PP|bun-PA|bun-PB|bun-PC|bun-PD|bun-PE|bun-PF|bun-PG|bun-PH|bun-PO|bun-PP|short sighted|short-sighted|shortsighted', map_location='33E5-33E9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12455540, end_position_on_the_genomic_accession=12546611, orientation='minus', exon_count=14, OMIM='', no_hdr0=''),
  34667 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34667, CurrentID=0, Status='live', Symbol='Ref2', Aliases='Dmel_CG17031, CG17031, Dmel\\CG17031, REF2, cg17031, ref2', description='RNA and export factor binding protein 2', other_designations='CG17031-PA|CG17031-PB|CG17031-PC|Ref2-PA|Ref2-PB|Ref2-PC|ref2', map_location='33F1-33F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12610517, end_position_on_the_genomic_accession=12646356, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34669 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34669, CurrentID=0, Status='live', Symbol='nub', Aliases='Dmel_CG34395, CG15488, CG15489, CG34395, CG6246, Dmel\\CG34395, Dmel_CG15488, Dmel_CG15489, Dmel_CG6246, NUB, Nb, Nub, Oct-1, Oct1, PDM-1, PDM1, POU33F1, Pdm, Pdm-1, Pdm1, dOct1, dPOU-19, dPOU-19/pdm-1, dPOU19, nb, pdm, pdm-1, pdm1, twn', description='nubbin', other_designations='CG34395-PB|CG34395-PD|CG34395-PE|NUBBIN|POU domain protein 1|nub-PB|nub-PD|nub-PE|twain', map_location='2-47.0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12587625, end_position_on_the_genomic_accession=12628135, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34671 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34671, CurrentID=0, Status='live', Symbol='CG15485', Aliases='Dmel_ Dmel\\CG15485', description='CG15485 gene product from transcript CG15485-RA', other_designations='CG15485-PA|CG15485-PB|uncharacterized protein', map_location='33F2-33F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12667248, end_position_on_the_genomic_accession=12669714, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34673 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34673, CurrentID=0, Status='live', Symbol='pdm2', Aliases='Dmel_CG12287, CG12287, CG15486, CG15487, Dmel\\CG12287, Oct-2, Oct2, Pdm, Pdm-2, Pdm2, dOct2, dPOU-28, dPOU28, dPOU28/pdm-2, dim, dpou28, miti, pdm, pdm-2', description='POU domain protein 2', other_designations='CG12287-PA|CG12287-PB|CG12287-PC|CG12287-PD|Miti-mere|POU domain prot 2|didymous|pdm2-PA|pdm2-PB|pdm2-PC|pdm2-PD', map_location='33F2-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12657165, end_position_on_the_genomic_accession=12686306, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34674 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34674, CurrentID=0, Status='live', Symbol='CG5525', Aliases='Dmel_ CCT4, Cct4, Dmel\\CG5525, Q9VK69_DROME, TCP-1, Tcp-1delta, Tcp1-delta', description='CG5525 gene product from transcript CG5525-RA', other_designations='CG5525-PA', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12690336, end_position_on_the_genomic_accession=12692934, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34675 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34675, CurrentID=0, Status='live', Symbol='CG6153', Aliases='Dmel_ 6153, Dmel\\CG6153', description='CG6153 gene product from transcript CG6153-RC', other_designations='CG6153-PA|CG6153-PC', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12692993, end_position_on_the_genomic_accession=12693939, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34676 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34676, CurrentID=0, Status='live', Symbol='CG5780', Aliases='Dmel_ Dmel\\CG5780, IFT43', description='CG5780 gene product from transcript CG5780-RB', other_designations='CG5780-PB', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12693872, end_position_on_the_genomic_accession=12694988, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34677 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34677, CurrentID=0, Status='live', Symbol='PICK1', Aliases='Dmel_CG6167, CG6167, Dmel\\CG6167', description='Protein interacting with C kinase 1', other_designations='CG6167-PA|CG6167-PB|CG6167-PD|CG6167-PE|CG6167-PF|PICK1 ortholog|PICK1-PA|PICK1-PB|PICK1-PD|PICK1-PE|PICK1-PF|protein interacting with C kinase 1', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12695033, end_position_on_the_genomic_accession=12698917, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34678 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34678, CurrentID=0, Status='live', Symbol='CG5781', Aliases='Dmel_ Dmel\\CG5781', description='CG5781 gene product from transcript CG5781-RA', other_designations='CG5781-PA', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12696426, end_position_on_the_genomic_accession=12697323, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34679 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34679, CurrentID=0, Status='live', Symbol='CG17036', Aliases='Dmel_ Dmel\\CG17036', description='CG17036 gene product from transcript CG17036-RA', other_designations='CG17036-PA|CG17036-PB|uncharacterized protein', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12698918, end_position_on_the_genomic_accession=12700746, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34680 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34680, CurrentID=0, Status='live', Symbol='CG5776', Aliases='Dmel_ Dmel\\CG5776', description='CG5776 gene product from transcript CG5776-RB', other_designations='CG5776-PA|CG5776-PB', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12700949, end_position_on_the_genomic_accession=12704451, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34681 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34681, CurrentID=0, Status='live', Symbol='spict', Aliases='Dmel_CG12292, CG12292, Dmel\\CG12292, Spict, spg6', description='spichthyin', other_designations='CG12292-PA|CG12292-PB|spict-PA|spict-PB', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12704725, end_position_on_the_genomic_accession=12706683, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34682 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34682, CurrentID=0, Status='live', Symbol='CG15484', Aliases='Dmel_ Dmel\\CG15484', description='CG15484 gene product from transcript CG15484-RA', other_designations='CG15484-PA|uncharacterized protein', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12706799, end_position_on_the_genomic_accession=12707711, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34683 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34683, CurrentID=0, Status='live', Symbol='CG6180', Aliases='Dmel_ Dmel\\CG6180', description='CG6180 gene product from transcript CG6180-RA', other_designations='CG6180-PA', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12707661, end_position_on_the_genomic_accession=12708680, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34684 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34684, CurrentID=0, Status='live', Symbol='CG5787', Aliases='Dmel_ Dmel\\CG5787', description='CG5787 gene product from transcript CG5787-RB', other_designations='CG5787-PA|CG5787-PB', map_location='33F3-33F3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12708792, end_position_on_the_genomic_accession=12712952, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34685 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34685, CurrentID=0, Status='live', Symbol='Pih1D1', Aliases='Dmel_CG5792, CG5792, Dmel\\CG5792', description='CG5792 gene product from transcript CG5792-RA', other_designations='CG5792-PA|CG5792-PD|Pih1D1-PA|Pih1D1-PD', map_location='33F3-33F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12713276, end_position_on_the_genomic_accession=12721843, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34686 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34686, CurrentID=0, Status='live', Symbol='MRP', Aliases='Dmel_CG6214, CG6214, Dmel\\CG62141, Mrp, dMRP, dMRP/CG6214, dMRP1, lincRNA.123, MRP', description='Multidrug-Resistance like Protein 1', other_designations='CG6214-PA|CG6214-PB|CG6214-PC|CG6214-PD|CG6214-PE|CG6214-PF|CG6214-PG|CG6214-PH|CG6214-PI|CG6214-PJ|CG6214-PK|CG6214-PL|CG6214-PM|CG6214-PN|CG6214-PO|CG6214-PP|CG6214-PQ|CG6214-PR|MRP-PA|MRP-PB|MRP-PC|MRP-PD|MRP-PE|MRP-PF|MRP-PG|MRP-PH|MRP-PI|MRP-PJ|MRP-PK|MRP-PL|MRP-PM|MRP-PN|MRP-PO|MRP-PP|MRP-PQ|MRP-PR|Multidrug-Resistance like protein 1|Multidrug-resistance protein|multidrug resistance like protein|multidrug resistance-associated protein|multidrug resistance-like protein 1', map_location='33F3-33F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12719045, end_position_on_the_genomic_accession=12766546, orientation='plus', exon_count=22, OMIM='', no_hdr0=''),
  34687 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34687, CurrentID=0, Status='live', Symbol='CG15483', Aliases='Dmel_ Dmel\\CG15483, dibeta3GnT3', description='CG15483 gene product from transcript CG15483-RA', other_designations='CG15483-PA|uncharacterized protein', map_location='33F5-33F5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12760346, end_position_on_the_genomic_accession=12761840, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34688 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34688, CurrentID=0, Status='live', Symbol='kek1', Aliases='Dmel_CG12283, BEST:GM02380, CG12283, CT18186, Dmel\\CG12283, Dmkek1, GM02380, KEK1, Kek, Kek-1, Kek1, NB1, SD01674, kek, kek-1, kekon, l(2)01433, n(2)k07332, uns', description='kekkon-1', other_designations='CG12283-PB|CG12283-PC|Kekkon-1|Kekkon1|Kekon-1|kek1-PB|kek1-PC|kekkon|kekkon 1|kekkonI|unstrung', map_location='34A1-34A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12817000, end_position_on_the_genomic_accession=12822787, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34689 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34689, CurrentID=0, Status='live', Symbol='ACXC', Aliases='Dmel_CG5983, AC, Acxc, CG5983, D Dmel\\CG5983', description='CG5983 gene product from transcript CG5983-RB', other_designations='ACXC-PA|ACXC-PB|CG5983-PA|CG5983-PB', map_location='34A2-34A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12912530, end_position_on_the_genomic_accession=12916774, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  34693 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34693, CurrentID=0, Status='live', Symbol='CG16800', Aliases='Dmel_ Dmel\\CG16800', description='CG16800 gene product from transcript CG16800-RB', other_designations='CG16800-PB|uncharacterized protein', map_location='34A3-34A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12966590, end_position_on_the_genomic_accession=12967810, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34695 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34695, CurrentID=0, Status='live', Symbol='Vha68-3', Aliases='Dmel_CG5075, CG5075, Dmel\\CG5075, Vha68, vha67-3, vha68-3', description='Vacuolar H[+] ATPase 68kD subunit 3', other_designations='CG5075-PA|Vha68-3-PA|vacuolar H[+] ATPase 68kD subunit 3|vacuolar H[+] ATPase subunit 68-3', map_location='34A3-34A3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12978786, end_position_on_the_genomic_accession=12981293, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34696 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34696, CurrentID=0, Status='live', Symbol='CG12404', Aliases='Dmel_ Dmel\\CG12404', description='CG12404 gene product from transcript CG12404-RA', other_designations='CG12404-PA|uncharacterized protein', map_location='34A4-34A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=12993757, end_position_on_the_genomic_accession=13000635, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34699 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34699, CurrentID=0, Status='live', Symbol='CG9934', Aliases='Dmel_ CG 9934, Dmel\\CG9934, E4 B, UBE4B, UFD2b, dUfd2, ufd2', description='CG9934 gene product from transcript CG9934-RA', other_designations='CG9934-PA|CG9934-PB|NM 135753.2', map_location='34A4-34A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13013276, end_position_on_the_genomic_accession=13019434, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34700 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34700, CurrentID=0, Status='live', Symbol='A16', Aliases='Dmel_CG9933, CG9933, Dmel\\CG9933', description='CG9933 gene product from transcript CG9933-RA', other_designations='A16-PA|CG9933-PA', map_location='34A4-34A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13019575, end_position_on_the_genomic_accession=13021312, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34701 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34701, CurrentID=0, Status='live', Symbol='CG9932', Aliases='Dmel_ Dmel\\CG9932, EP2317, Ef4A, elF-4A', description='CG9932 gene product from transcript CG9932-RE', other_designations='CG9932-PA|CG9932-PC|CG9932-PD|CG9932-PE|elongation factor 4a', map_location='34A5-34A6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13021868, end_position_on_the_genomic_accession=13060140, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34702 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34702, CurrentID=0, Status='live', Symbol='CG5142', Aliases='Dmel_ Dmel\\CG5142, TTC30', description='CG5142 gene product from transcript CG5142-RD', other_designations='CG5142-PC|CG5142-PD', map_location='34A5-34A5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13106807, end_position_on_the_genomic_accession=13109468, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34703 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34703, CurrentID=0, Status='live', Symbol='CG5122', Aliases='Dmel_ Dmel\\CG5122', description='CG5122 gene product from transcript CG5122-RA', other_designations='CG5122-PA', map_location='34A5-34A6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13130591, end_position_on_the_genomic_accession=13134804, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34704 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34704, CurrentID=0, Status='live', Symbol='CG9928', Aliases='Dmel_ BcDNA:RH70154, CT27834, Dmel\\CG9928', description='CG9928 gene product from transcript CG9928-RB', other_designations='CG9928-PA|CG9928-PB', map_location='34A6-34A6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13142445, end_position_on_the_genomic_accession=13142903, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34705 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34705, CurrentID=0, Status='live', Symbol='Pk34A', Aliases='Dmel_CG5182, CG5182, Dmel\\CG5182, GSK3a', description='CG5182 gene product from transcript CG5182-RA', other_designations='CG5182-PA|Pk34A-PA', map_location='34A7-34A7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13158810, end_position_on_the_genomic_accession=13160173, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34706 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34706, CurrentID=0, Status='live', Symbol='CG5204', Aliases='Dmel_ Dmel\\CG5204, anon-WO0118547.212', description='CG5204 gene product from transcript CG5204-RA', other_designations='CG5204-PA', map_location='34A7-34A7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13160527, end_position_on_the_genomic_accession=13163153, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34707 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34707, CurrentID=0, Status='live', Symbol='DnaJ-H', Aliases='Dmel_CG9828, CG9828, DNA J-H, DNAJ-H, Dmel\\CG9828, NEST:bs08d07, dDnaJ-H, dHdj2, dnaJ-H', description='DnaJ homolog', other_designations='CG9828-PA|CG9828-PB|CG9828-PC|DnaJ-H-PA|DnaJ-H-PB|DnaJ-H-PC', map_location='34A7-34A7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13163209, end_position_on_the_genomic_accession=13166072, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34708 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34708, CurrentID=0, Status='live', Symbol='Sirt1', Aliases='Dmel_CG5216, BEST:LD38188, CG5216, D.mel1, DSir2, Dmel\\CG5216, SIR2, Sir2, Sir2L, dSIR2, dSir2, dmSRT406, dsir2, l(2)05326, sir2', description='Sirtuin 1', other_designations='CG5216-PA|Sir2|Sirt1-PA|silent information regulator 2|sirtuin 1', map_location='34A7-34A7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13165564, end_position_on_the_genomic_accession=13169551, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34709 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34709, CurrentID=0, Status='live', Symbol='Sfmbt', Aliases='Dmel_CG16975, CG16975, Dmel\\CG16975, SFMBT, dSFMBT, dSfmbt', description='Scm-related gene containing four mbt domains', other_designations='CG16975-PA|CG16975-PB|CG16975-PC|CG16975-PD|Sfmbt-PA|Sfmbt-PB|Sfmbt-PC|Sfmbt-PD', map_location='34A7-34A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13169649, end_position_on_the_genomic_accession=13176785, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34710 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34710, CurrentID=0, Status='live', Symbol='CG5439', Aliases='Dmel_ Dmel\\CG5439', description='CG5439 gene product from transcript CG5439-RA', other_designations='CG5439-PA', map_location='34A8-34A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13177150, end_position_on_the_genomic_accession=13178978, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34711 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34711, CurrentID=0, Status='live', Symbol='CG5287', Aliases='Dmel_ Dmel\\CG5287, dAlg7', description='CG5287 gene product from transcript CG5287-RA', other_designations='CG5287-PA', map_location='34A8-34A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13179247, end_position_on_the_genomic_accession=13183495, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34712 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34712, CurrentID=0, Status='live', Symbol='CG5458', Aliases='Dmel_ Dmel\\CG5458', description='CG5458 gene product from transcript CG5458-RA', other_designations='CG5458-PA', map_location='34A8-34A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13183450, end_position_on_the_genomic_accession=13184875, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34713 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34713, CurrentID=0, Status='live', Symbol='CG16974', Aliases='Dmel_ CT35580, Dmel\\CG16974, Dromel_CG16974_FBtr0080489_mORF', description='CG16974 gene product from transcript CG16974-RB', other_designations='CG16974-PA|CG16974-PB|kekkon-like|uncharacterized protein', map_location='34A8-34A8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13183849, end_position_on_the_genomic_accession=13191979, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34714 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34714, CurrentID=0, Status='live', Symbol='Edem2', Aliases='Dmel_CG5682, CG5682, Dmel\\CG5682, EDEM2, edem2', description='ER degradation enhancer, mannosidase alpha-like 2', other_designations='CG5682-PA|CG5682-PB|Edem2-PA|Edem2-PB', map_location='34A8-34A9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13192201, end_position_on_the_genomic_accession=13197281, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34715 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34715, CurrentID=0, Status='live', Symbol='CG16972', Aliases='Dmel_ Dmel\\CG16972, anon-WO0140519.52', description='CG16972 gene product from transcript CG16972-RA', other_designations='CG16972-PA|uncharacterized protein', map_location='34A9-34A9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13197102, end_position_on_the_genomic_accession=13203295, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34716 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34716, CurrentID=0, Status='live', Symbol='Pect', Aliases='Dmel_CG5547, CG5547, Dmel\\CG5547, PECT, pect', description='Phosphoethanolamine cytidylyltransferase', other_designations='CG5547-PB|CG5547-PC|CG5547-PD|CG5547-PE|Pect-PB|Pect-PC|Pect-PD|Pect-PE|phosphoethanolamine cytidylyltransferase', map_location='34A9-34A9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13203762, end_position_on_the_genomic_accession=13210828, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  5740629 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=5740629, CurrentID=0, Status='live', Symbol='CG43795', Aliases='Dmel_ CG13552, CG13553, CG13556, CG18678, CG18679, CG34372, CG5357, Dmel\\CG43795, Dmel_CG13552, Dmel_CG13556, Dmel_CG18678, Dmel_CG18679, Dmel_CG34372, Dmel_CG5357', description='CG43795 gene product from transcript CG43795-RA', other_designations='CG43795-PA|uncharacterized protein', map_location='59E2-59E2', chromosome='2R', genomic_nucleotide_accession_version='NT_033778.4', start_position_on_the_genomic_accession=23444137, end_position_on_the_genomic_accession=23491997, orientation='plus', exon_count=14, OMIM='', no_hdr0=''),
  34718 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34718, CurrentID=0, Status='live', Symbol='kek4', Aliases='Dmel_CG9431, CG9431, CT26742, Dmel\\CG9431', description='kekkon4', other_designations='CG9431-PA|CG9431-PB|CG9431-PC|kek4-PA|kek4-PB|kek4-PC|kekkon-like', map_location='34A9-34A10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13212335, end_position_on_the_genomic_accession=13215350, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34719 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34719, CurrentID=0, Status='live', Symbol='CG9426', Aliases='Dmel_ Dmel\\CG9426, Ipp', description='CG9426 gene product from transcript CG9426-RA', other_designations='CG9426-PA', map_location='34A10-34A10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13216290, end_position_on_the_genomic_accession=13219923, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34720 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34720, CurrentID=0, Status='live', Symbol='CG5705', Aliases='Dmel_ Dmel\\CG5705', description='CG5705 gene product from transcript CG5705-RA', other_designations='CG5705-PA', map_location='34A10-34A10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13219979, end_position_on_the_genomic_accession=13221398, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34721 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34721, CurrentID=0, Status='live', Symbol='Ski6', Aliases='Dmel_CG15481, CG15481, Dmel\\CG15481, Rrp41, dRrp41, d', description='CG15481 gene product from transcript CG15481-RB', other_designations='CG15481-PA|CG15481-PB|Ski6-PA|Ski6-PB', map_location='34A10-34A10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13221397, end_position_on_the_genomic_accession=13222429, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34722 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34722, CurrentID=0, Status='live', Symbol='CG16812', Aliases='Dmel_ Dmel\\CG16812', description='CG16812 gene product from transcript CG16812-RA', other_designations='CG16812-PA|uncharacterized protein', map_location='34A10-34A10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13222587, end_position_on_the_genomic_accession=13224545, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34723 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34723, CurrentID=0, Status='live', Symbol='CG15480', Aliases='Dmel_ Dmel\\CG15480', description='CG15480 gene product from transcript CG15480-RA', other_designations='CG15480-PA|uncharacterized protein', map_location='34A10-34A10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13224620, end_position_on_the_genomic_accession=13225275, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34724 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34724, CurrentID=0, Status='live', Symbol='CG16813', Aliases='Dmel_ DM26, Dmel\\CG16813', description='CG16813 gene product from transcript CG16813-RB', other_designations='CG16813-PA|CG16813-PB|uncharacterized protein', map_location='34A10-34A10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13227529, end_position_on_the_genomic_accession=13228521, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34725 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34725, CurrentID=0, Status='live', Symbol='CG16815', Aliases='Dmel_ DM27, Dmel\\CG16815', description='CG16815 gene product from transcript CG16815-RB', other_designations='CG16815-PB|uncharacterized protein', map_location='34A11-34A11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13229832, end_position_on_the_genomic_accession=13230549, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34726 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34726, CurrentID=0, Status='live', Symbol='Prosalpha6T', Aliases='Dmel_CG5648, 5648, Alpha6T, CG5648, Dmel\\CG5648, alpha6T, prosalpha6T', description='Proteasome alpha6 subunit, Testis-specific', other_designations='CG5648-PA|Prosalpha6T-PA|proteasome alpha6 subunit, Testis-specific|proteasome alpha6T subunit', map_location='34A11-34A11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13232039, end_position_on_the_genomic_accession=13233058, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34727 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34727, CurrentID=0, Status='live', Symbol='Mabi', Aliases='Dmel_CG15479, CG15479, DM2, Dmel\\CG15479', description='Mabiki', other_designations='CG15479-PA|Mabi-PA|mabiki', map_location='34A11-34A11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13233798, end_position_on_the_genomic_accession=13234660, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34728 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34728, CurrentID=0, Status='live', Symbol='CG5867', Aliases='Dmel_ BcDNA:GH05536, CT18390, Dmel\\CG5867', description='CG5867 gene product from transcript CG5867-RA', other_designations='CG5867-PA', map_location='34A11-34A11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13236494, end_position_on_the_genomic_accession=13239297, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34729 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34729, CurrentID=0, Status='live', Symbol='CG5945', Aliases='Dmel_ CT18564, Dmel\\CG5945, cg5945', description='CG5945 gene product from transcript CG5945-RB', other_designations='CG5945-PA|CG5945-PB', map_location='34A11-34B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13239989, end_position_on_the_genomic_accession=13241773, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34730 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34730, CurrentID=0, Status='live', Symbol='CG16820', Aliases='Dmel_ Dmel\\CG16820, cg16820', description='CG16820 gene product from transcript CG16820-RA', other_designations='CG16820-PA|uncharacterized protein', map_location='34B1-34B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13246232, end_position_on_the_genomic_accession=13250189, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34731 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34731, CurrentID=0, Status='live', Symbol='CG31728', Aliases='Dmel_ CG16821, Dmel\\CG31728, SP36, c-SP36', description='CG31728 gene product from transcript CG31728-RC', other_designations='CG31728-PC|uncharacterized protein', map_location='34B2-34B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13251509, end_position_on_the_genomic_accession=13257426, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34732 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34732, CurrentID=0, Status='live', Symbol='CG44085', Aliases='Dmel_ CG6043, CG6108, Dmel\\CG44085, Dmel_CG6043, Dmel_CG6108', description='CG44085 gene product from transcript CG44085-RF', other_designations='CG44085-PC|CG44085-PD|CG44085-PF|CG44085-PG|CG44085-PH|CG44085-PI|CG44085-PJ|CG44085-PK|CG44085-PL|CG44085-PM|CG44085-PN|CG44085-PO|CG44085-PP|uncharacterized protein', map_location='34B3-34B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13261008, end_position_on_the_genomic_accession=13284043, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  34734 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34734, CurrentID=0, Status='live', Symbol='Drep4', Aliases='Dmel_CG9414, CAD, CG9414, DREP-4, Dmel\\CG9414, Drep-4, Rep4, dCAD, drep4', description='DNA fragmentation factor-related protein 4', other_designations='CG9414-PA|Caspase-activated DNase|Drep4-PA|Rep4', map_location='34B4-34B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13283912, end_position_on_the_genomic_accession=13286462, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34735 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34735, CurrentID=0, Status='live', Symbol='Uvrag', Aliases='Dmel_CG6116, CG6116, Dmel\\CG6116, UVRAG, Vps38, uvrag', description='UV-resistance associated gene', other_designations='CG6116-PA|CG6116-PB|UV radiation resistance associated|UV radiation resistance associated gene|Uvrag-PA|Uvrag-PB', map_location='34B4-34B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13286777, end_position_on_the_genomic_accession=13289556, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34736 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34736, CurrentID=0, Status='live', Symbol='CG31729', Aliases='Dmel_ CG16823, CG6263, DmCG31729, Dmel\\CG31729', description='CG31729 gene product from transcript CG31729-RB', other_designations='CG31729-PA|CG31729-PB|CG31729-PC|CG31729-PD|uncharacterized protein', map_location='34B4-34B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13289997, end_position_on_the_genomic_accession=13301668, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34738 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34738, CurrentID=0, Status='live', Symbol='CG43778', Aliases='Dmel_ CG15639, CG16970, Dmel\\CG43778, Dmel_CG16970, FBgn 32504', description='CG43778 gene product from transcript CG43778-RD', other_designations='CG43778-PA|CG43778-PC|CG43778-PD|uncharacterized protein', map_location='34B5-34B6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13301814, end_position_on_the_genomic_accession=13331121, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34739 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34739, CurrentID=0, Status='live', Symbol='CG16825', Aliases='Dmel_ BcDNA:AT09390, Dmel\\CG16825', description='CG16825 gene product from transcript CG16825-RB', other_designations='CG16825-PA|CG16825-PB|uncharacterized protein', map_location='34B5-34B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13304788, end_position_on_the_genomic_accession=13307807, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34741 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34741, CurrentID=0, Status='live', Symbol='CG16826', Aliases='Dmel_ Dmel\\CG16826', description='CG16826 gene product from transcript CG16826-RB', other_designations='CG16826-PA|CG16826-PB|uncharacterized protein', map_location='34B6-34B6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13347773, end_position_on_the_genomic_accession=13349020, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34742 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34742, CurrentID=0, Status='live', Symbol='CG9395', Aliases='Dmel_ Dmel\\CG9395', description='CG9395 gene product from transcript CG9395-RD', other_designations='CG9395-PC|CG9395-PD', map_location='34B6-34B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13349823, end_position_on_the_genomic_accession=13355073, orientation='minus', exon_count=9, OMIM='', no_hdr0=''),
  34743 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34743, CurrentID=0, Status='live', Symbol='CG9377', Aliases='Dmel_ Dmel\\CG9377, SPH166, c-SPH166', description='CG9377 gene product from transcript CG9377-RA', other_designations='CG9377-PA', map_location='34B7-34B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13359901, end_position_on_the_genomic_accession=13361565, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34745 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34745, CurrentID=0, Status='live', Symbol='CG6523', Aliases='Dmel_ Dmel\\CG6523, Grx3, Grx4', description='CG6523 gene product from transcript CG6523-RA', other_designations='CG6523-PA', map_location='34B7-34B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13366447, end_position_on_the_genomic_accession=13367410, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34747 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34747, CurrentID=0, Status='live', Symbol='ND-B22', Aliases='Dmel_CG9306, CG9306, Dmel\\CG9306, NI2M', description='NADH dehydrogenase (ubiquinone) B22 subunit', other_designations='CG9306-PA|CG9306-PB|NADH ubiquinone oxidoreductase B22|NADH-ubiquinone oxidoreductase B22 subunit|NADH:ubiquinone oxidoreductase B22 subunit|ND-B22-PA|ND-B22-PB', map_location='34B8-34B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13370103, end_position_on_the_genomic_accession=13371110, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34748 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34748, CurrentID=0, Status='live', Symbol='CG9305', Aliases='Dmel_ Bdp1, Dmel\\CG9305', description='CG9305 gene product from transcript CG9305-RB', other_designations='CG9305-PA|CG9305-PB', map_location='34B8-34B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13371427, end_position_on_the_genomic_accession=13373890, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34749 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34749, CurrentID=0, Status='live', Symbol='CG6565', Aliases='Dmel_ Dmel\\CG6565', description='CG6565 gene product from transcript CG6565-RB', other_designations='CG6565-PA|CG6565-PB|CG6565-PC', map_location='34B8-34B8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13374019, end_position_on_the_genomic_accession=13376404, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34750 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34750, CurrentID=0, Status='live', Symbol='CG9302', Aliases='Dmel_ Dmel\\CG9302, anon-WO0118547.80', description='CG9302 gene product from transcript CG9302-RA', other_designations='CG9302-PA', map_location='34B8-34B9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13376455, end_position_on_the_genomic_accession=13378538, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34751 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34751, CurrentID=0, Status='live', Symbol='loqs', Aliases='Dmel_CG6866, CG6866, Dmel\\CG6866, LOQS, Loqs, R3D1, R3D1-L, R3D1-S, TRBP, cg6866, dRax, loq, r3d1', description='loquacious', other_designations='CG6866-PA|CG6866-PB|CG6866-PC|CG6866-PD|CG6866-PE|CG6866-PF|loqs-PA|loqs-PB|loqs-PC|loqs-PD|loqs-PE|loqs-PF', map_location='34B9-34B9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13382652, end_position_on_the_genomic_accession=13385671, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34752 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34752, CurrentID=0, Status='live', Symbol='CG9293', Aliases='Dmel_ Dmel\\CG9293', description='CG9293 gene product from transcript CG9293-RB', other_designations='CG9293-PA|CG9293-PB', map_location='34B9-34B9', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13385848, end_position_on_the_genomic_accession=13387312, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34753 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34753, CurrentID=0, Status='live', Symbol='CG7099', Aliases='Dmel_ Dmel\\CG7099, FBgn 32517, dTFIIIC220', description='CG7099 gene product from transcript CG7099-RA', other_designations='CG7099-PA', map_location='34B9-34B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13387571, end_position_on_the_genomic_accession=13393959, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34754 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34754, CurrentID=0, Status='live', Symbol='RpL24', Aliases='Dmel_CG9282, CG9282, Dmel\\CG9282, L24, RL24_DROME, Rp L24, Rpl24, anon-EST:Posey242, anon-EST:Posey37', description='Ribosomal protein L24', other_designations='CG9282-PA|CG9282-PB|CG9282-PC|RpL24-PA|RpL24-PB|RpL24-PC|ribosomal protein L24', map_location='34B10-34B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13393687, end_position_on_the_genomic_accession=13395131, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34755 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34755, CurrentID=0, Status='live', Symbol='CG16957', Aliases='Dmel_ Dmel\\CG16957', description='CG16957 gene product from transcript CG16957-RA', other_designations='CG16957-PA|CG16957-PB|uncharacterized protein', map_location='34B10-34B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13395360, end_position_on_the_genomic_accession=13396184, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34756 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34756, CurrentID=0, Status='live', Symbol='CG10859', Aliases='Dmel_ Dmel\\CG10859', description='CG10859 gene product from transcript CG10859-RA', other_designations='CG10859-PA|CG10859-PB|uncharacterized protein', map_location='34B10-34B10', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13396392, end_position_on_the_genomic_accession=13398664, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34757 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34757, CurrentID=0, Status='live', Symbol='CG7110', Aliases='Dmel_ Dmel\\CG7110', description='CG7110 gene product from transcript CG7110-RB', other_designations='CG7110-PB|CG7110-PC', map_location='34B10-34B11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13398991, end_position_on_the_genomic_accession=13411047, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34758 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34758, CurrentID=0, Status='live', Symbol='Vm34Ca', Aliases='Dmel_CG9271, CG9271, Dmel\\CG9271, VM26A.1, VM34C, VM34C.1, Vm34C, Vm34Cc', description='Vitelline membrane 34Ca', other_designations='CG9271-PA|Vm34Ca-PA|vitelline membrane 34Ca', map_location='34B11-34B11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13411141, end_position_on_the_genomic_accession=13411631, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34759 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34759, CurrentID=0, Status='live', Symbol='CG16848', Aliases='Dmel_ Dmel\\CG16848, FBgn0032522', description='CG16848 gene product from transcript CG16848-RA', other_designations='CG16848-PA|uncharacterized protein', map_location='34B11-34B11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13412519, end_position_on_the_genomic_accession=13413716, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34760 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34760, CurrentID=0, Status='live', Symbol='CG16956', Aliases='Dmel_ Dmel\\CG16956', description='CG16956 gene product from transcript CG16956-RA', other_designations='CG16956-PA|uncharacterized protein', map_location='34B11-34B11', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13413783, end_position_on_the_genomic_accession=13414575, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34761 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34761, CurrentID=0, Status='live', Symbol='Tehao', Aliases='Dmel_CG7121, CG7121, CT22017, Dmel\\CG7121, Tho, Tl-5, Toll 5, Toll-5, dTLR5, dToll5, tehao, toll', description='CG7121 gene product from transcript CG7121-RB', other_designations='CG7121-PA|CG7121-PB|Tehao-PA|Tehao-PB|Toll-5|tehao|toll receptor', map_location='34C1-34C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13435622, end_position_on_the_genomic_accession=13439930, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34762 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34762, CurrentID=0, Status='live', Symbol='CG9267', Aliases='Dmel_ Dmel\\CG9267, Q9VJX8', description='CG9267 gene product from transcript CG9267-RA', other_designations='CG9267-PA', map_location='34C1-34C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13444103, end_position_on_the_genomic_accession=13445651, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34763 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34763, CurrentID=0, Status='live', Symbol='Hsp60D', Aliases='Dmel_CG16954, CG16954, Dmel\\CG16954', description='CG16954 gene product from transcript CG16954-RA', other_designations='CG16954-PA|CG16954-PB|Hsp60D-PA|Hsp60D-PB', map_location='34C1-34C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13447538, end_position_on_the_genomic_accession=13449497, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34764 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34764, CurrentID=0, Status='live', Symbol='CG42810', Aliases='Dmel_ CG16849, Dmel\\CG42810, Dmel_CG16849', description='CG42810 gene product from transcript CG42810-RA', other_designations='CG42810-PA|uncharacterized protein', map_location='34C1-34C1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13459681, end_position_on_the_genomic_accession=13460183, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34767 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34767, CurrentID=0, Status='live', Symbol='B4', Aliases='Dmel_CG9239/Susi, BG:DS07660.4, CG9239, CG9260, Dmel\\CG9239, Susi, n(2)05337', description='CG9239 gene product from transcript CG9239-RC', other_designations='B4-PA|B4-PB|B4-PC|CG9239-PA|CG9239-PB|CG9239-PC|suppressor of signaling by insulin', map_location='34C3-34C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13500624, end_position_on_the_genomic_accession=13549328, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34768 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34768, CurrentID=0, Status='live', Symbol='CG15638', Aliases='Dmel_ BG:BACR48E02.1, Dmel\\CG15638', description='CG15638 gene product from transcript CG15638-RA', other_designations='CG15638-PA|uncharacterized protein', map_location='34C4-34C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13535291, end_position_on_the_genomic_accession=13535778, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34769 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34769, CurrentID=0, Status='live', Symbol='CG16852', Aliases='Dmel_ BG:BACR48E02.2, BcDNA:AT28681, Dmel\\CG16852', description='CG16852 gene product from transcript CG16852-RA', other_designations='CG16852-PA|uncharacterized protein', map_location='34C4-34C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13540751, end_position_on_the_genomic_accession=13541646, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34770 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34770, CurrentID=0, Status='live', Symbol='CG9263', Aliases='Dmel_ Dmel\\CG9263', description='CG9263 gene product from transcript CG9263-RA', other_designations='CG9263-PA', map_location='34C4-34C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13541638, end_position_on_the_genomic_accession=13542576, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34771 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34771, CurrentID=0, Status='live', Symbol='CG16853', Aliases='Dmel_ BG:BACR48E02.3, Dmel\\CG16853', description='CG16853 gene product from transcript CG16853-RA', other_designations='CG16853-PA|CG16853-PB|uncharacterized protein', map_location='34C4-34C4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13542268, end_position_on_the_genomic_accession=13543633, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34772 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34772, CurrentID=0, Status='live', Symbol='kuz', Aliases='Dmel_CG7147, 11410, 34Da, ADAM10, BG:DS07660.3, CG7147, CT22079, Dmel\\CG7147, GS11410, Kuz, br38, l(2)03782, l(2)34Da, l(2)br38, l(2)c00136, l(2)k01403, l34Da, soy nut', description='kuzbanian', other_designations='CG7147-PA|CG7147-PB|CG7147-PC|CG7147-PF|CG7147-PG|kuz-PA|kuz-PB|kuz-PC|kuz-PF|kuz-PG|kuzbaninan|lethal (2) c00136', map_location='34C4-34C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13550139, end_position_on_the_genomic_accession=13639411, orientation='plus', exon_count=13, OMIM='', no_hdr0=''),
  34773 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34773, CurrentID=0, Status='live', Symbol='CG9254', Aliases='Dmel_ BG:DS07660.1, DS07660.1, Dmel\\CG9254', description='CG9254 gene product from transcript CG9254-RA', other_designations='CG9254-PA', map_location='34C5-34C5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13595503, end_position_on_the_genomic_accession=13597186, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34774 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34774, CurrentID=0, Status='live', Symbol='ics', Aliases='Dmel_CG9031, BG:BACR48E02.4, CG9031, CT25926, Dmel\\CG9031, RSU-1, RSU1, Rsu-1', description='icarus', other_designations='CG9031-PA|CG9031-PB|CG9031-PC|Ras suppressor-1|ics-PA|ics-PB|ics-PC', map_location='34C6-34C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13639447, end_position_on_the_genomic_accession=13642602, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34775 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34775, CurrentID=0, Status='live', Symbol='CG18507', Aliases='Dmel_ BG:DS01368.1, DS01368.1, Dmel\\CG18507, bg:ds01368', description='CG18507 gene product from transcript CG18507-RC', other_designations='CG18507-PA|CG18507-PB|CG18507-PC|CG18507-PD|CG18507-PE|uncharacterized protein', map_location='34C6-34C6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13665525, end_position_on_the_genomic_accession=13672967, orientation='plus', exon_count=11, OMIM='', no_hdr0=''),
  34776 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34776, CurrentID=0, Status='live', Symbol='CG7311', Aliases='Dmel_ BG:DS08249.2, Dmel\\CG7311, GPO, GPO-2, Gpo, alpha-GPO', description='CG7311 gene product from transcript CG7311-RD', other_designations='CG7311-PD|CG7311-PE', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13708215, end_position_on_the_genomic_accession=13710583, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34777 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34777, CurrentID=0, Status='live', Symbol='CG9014', Aliases='Dmel_ BG:DS08249.3, DS08249.3, Dmel\\CG9014', description='CG9014 gene product from transcript CG9014-RA', other_designations='CG9014-PA|CG9014-PB', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13722161, end_position_on_the_genomic_accession=13723642, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34778 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34778, CurrentID=0, Status='live', Symbol='TM9SF4', Aliases='Dmel_CG7364, BG:DS00797.1, CG16861, CG7364, Dmel\\CG7364, n(2)k07245', description='Transmembrane 9 superfamily protein member 4', other_designations='CG7364-PA|CG7364-PB|TM9SF4-PA|TM9SF4-PB|transmembrane 9 superfamily protein member 4', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13746952, end_position_on_the_genomic_accession=13773905, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34779 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34779, CurrentID=0, Status='live', Symbol='CG9008', Aliases='Dmel_ BG:DS00797.2, Dmel\\CG9008', description='CG9008 gene product from transcript CG9008-RA', other_designations='CG9008-PA|CG9008-PD|CG9008-PE', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13774340, end_position_on_the_genomic_accession=13780165, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34780 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34780, CurrentID=0, Status='live', Symbol='p38b', Aliases='Dmel_CG7393, 186F5S, BG:DS00797.3, CG7393, D-p38, D-p38 MAPK, D-p38b, Dm p38b, Dmel\\CG7393, Dmp38b, Dp38, Dp38b, ESTS:186F5S, MAPK, Mpk34C, anon-sts23, dp38b, p38, p38 MAPK, p38 beta, p38B, p38Kbeta, p38b', description='p38b MAP kinase', other_designations='CG7393-PA|p38 MAP kinase|p38 mitogen-activated protein kinase|p38b-PA|stress-activated p38b MAP kinase', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13780689, end_position_on_the_genomic_accession=13782611, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34781 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34781, CurrentID=0, Status='live', Symbol='CG16890', Aliases='Dmel_ BG:DS00797.4, Dmel\\CG16890', description='CG16890 gene product from transcript CG16890-RD', other_designations='CG16890-PA|CG16890-PC|CG16890-PD|uncharacterized protein', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13782231, end_position_on_the_genomic_accession=13784338, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34783 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34783, CurrentID=0, Status='live', Symbol='CG31731', Aliases='Dmel_ BG:DS00797.5, CG7491, CG7559, D00797.5, DS00797.5, Dmel\\CG31731', description='CG31731 gene product from transcript CG31731-RB', other_designations='CG31731-PB|CG31731-PC|uncharacterized protein', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13784084, end_position_on_the_genomic_accession=13790562, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  34784 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34784, CurrentID=0, Status='live', Symbol='CG16863', Aliases='Dmel_ BG:DS00797.6, DS00797.6, Dmel\\CG16863', description='CG16863 gene product from transcript CG16863-RA', other_designations='CG16863-PA|CG16863-PB|uncharacterized protein', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13790959, end_position_on_the_genomic_accession=13793264, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34785 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34785, CurrentID=0, Status='live', Symbol='Sec71', Aliases='Dmel_CG7578, BG:DS00797.7, BIG1, CG7578, Dmel\\CG7578, sec71', description='Sec71 ortholog (S. cerevisiae)', other_designations='CG7578-PA|Sec71 ortholog|Sec71-PA|sec71', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13793521, end_position_on_the_genomic_accession=13799674, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34786 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34786, CurrentID=0, Status='live', Symbol='CAH1', Aliases='Dmel_CG7820, BG:DS00941.1, CAH, CG7820, Dmel\\CG7820, Gh7', description='Carbonic anhydrase 1', other_designations='CAH1-PA|CG7820-PA|carbonic anhydrase 1', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13803626, end_position_on_the_genomic_accession=13809994, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34787 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34787, CurrentID=0, Status='live', Symbol='Adat1', Aliases='Dmel_CG16889, Adat, BG:DS00941.2, CG16889, Dmel\\CG16889, adat, dADAT1', description='Adenosine deaminase, tRNA-specific 1', other_designations='Adat1-PA|Adat1-PB|CG16889-PA|CG16889-PB|adat|adenosine deaminase, tRNA-specific 1', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13808360, end_position_on_the_genomic_accession=13811474, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34788 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34788, CurrentID=0, Status='live', Symbol='CG16865', Aliases='Dmel_ BG:DS00941.3, Dmel\\CG16865', description='CG16865 gene product from transcript CG16865-RB', other_designations='CG16865-PA|CG16865-PB|uncharacterized protein', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13811522, end_position_on_the_genomic_accession=13813316, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34789 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34789, CurrentID=0, Status='live', Symbol='CG16888', Aliases='Dmel_ Dmel\\CG16888', description='CG16888 gene product from transcript CG16888-RA', other_designations='CG16888-PA|uncharacterized protein', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13812700, end_position_on_the_genomic_accession=13813256, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34790 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34790, CurrentID=0, Status='live', Symbol='Sos', Aliases='Dmel_CG7793, 2.3, 34Ea, BG:DS00941.4, CG7793, Dmel\\CG7793, E(sev)2A, E(var)189, EC2-5, EK2-8, EY2-3, SOS1, Su(tor)2-2, br24, br25, dSos, dme-SOS, l(2)34Ea, l(2)Sos, l(2)br24, l(2)br25, l(2)k05224, l(2)k06321, sos, Sos', description='Son of sevenless', other_designations='CG7793-PA|Son-of-sevenless|Sos-PA|lethal 24 in the black-reduced region|lethal 25 in the black-reduced region', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13813816, end_position_on_the_genomic_accession=13819824, orientation='plus', exon_count=7, OMIM='', no_hdr0=''),
  34791 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34791, CurrentID=0, Status='live', Symbol='b', Aliases='Dmel_CG7811, ADC, B, BG:DS00941.5, CG7811, DGad2, DmGad2, Dmel\\CG7811, GAD[[2]], Gad2, anon-34Db, cDNA 1', description='black', other_designations='Aspartate-alpha-decarboxylase|CG7811-PA|CG7811-PB|CG7811-PC|Oregon-R glutamate decarboxylase|aspartate 1-decarboxylase|b-PA|b-PB|b-PC|glutamic acid decarboxylase 2', map_location='2-48.5 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13821248, end_position_on_the_genomic_accession=13823979, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34792 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34792, CurrentID=0, Status='live', Symbol='tam', Aliases='Dmel_CG8987, 34Dc, AAC47658, BG:DS00941.6, CG8987, D-pol gamma-alpha, DNApol-gamma, DNApol-gamma125, Dmel\\CG8987, MtPolA, POLGalpha, Polgamma, Tam, anon-34Dc, br5, cDNA 2, l(2)34Dc, l(2)br14, l(2)br5, l(2)brS, mtDNA pol, mtPolA, pol gamma, pol gamma-alpha, polgamma, polgamma-alpha', description='tamas', other_designations='CG8987-PA|DNA polymerase gamma|DNA polymerase gamma 125kD|alpha subunit|catalytic subunit of the mitochondrial DNA polymerase|catalytic(alpha)subunit|lethal 14 in the black-reduced region|lethal 5 in the black-reduced region|lethal(2)34Dc|mitochondrial gamma polymerase|mtDNA polymerase alpha|tam-PA', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13823980, end_position_on_the_genomic_accession=13827772, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34793 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34793, CurrentID=0, Status='live', Symbol='Arpc1', Aliases='Dmel_CG8978, 34Dd, ARC-P41, ARPC1, ARPC1/p41, Arc41, ArcP41, ArpC1, BG:DS00941.7, CG8978, D-sop2, DSop2, Dmel\\CG8978, Dsop2, Sop2, Spo2, arc41, arpc1, br32, l(2)34Dd, l(2)Sop2, l(2)br32, p41, p42, sop, sop2, sop2/arc41', description='Actin-related protein 2/3 complex, subunit 1', other_designations='Arpc1-PA|Arpc1-PB|CG8978-PA|CG8978-PB|lethal(2)34Dd|profilin 2|suppressor of|suppressor of profilin 2', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13827941, end_position_on_the_genomic_accession=13829741, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34794 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34794, CurrentID=0, Status='live', Symbol='Orc5', Aliases='Dmel_CG7833, BG:DS00941.8, CG7833, D-orc5, DmORC5, DmOrc5, Dmel\\CG7833, ORC, ORC5, br39, dORC5, l(2)34Df, l(2)br39, orc5', description='Origin recognition complex subunit 5', other_designations='CG7833-PA|Orc5-PA|lethal(2)34Df|origin recognition complex subunit 5', map_location='34D1-34D1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13829837, end_position_on_the_genomic_accession=13831576, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34796 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34796, CurrentID=0, Status='live', Symbol='RpII33', Aliases='Dmel_CG7885, 152117_at, BG:DS00941.10, CG7885, D-rpII33, Dmel\\CG7885, Pol II, Pol II RPII33, PolII, PolIIo, RNA Pol II, RNA pol II, RNA polII, RNAP, RPB3, Rbp3, Rpb3, Rpll33, br17, l(2)34Dg, l(2)br17, l(2)k05605, l34Dg, pol II, polII, rpII33, rpb3', description='RNA polymerase II 33kD subunit', other_designations='CG7885-PA|RNA polymerase II|RpII33-PA|lethal 17 in the black-reduced region|lethal(2)34Dg', map_location='34D1-34D6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13833337, end_position_on_the_genomic_accession=13834306, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34799 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34799, CurrentID=0, Status='live', Symbol='CG8997', Aliases='Dmel_ BG:DS00941.12, CT25774, DS00941.12, Dmel\\CG8997', description='CG8997 gene product from transcript CG8997-RB', other_designations='CG8997-PA|CG8997-PB', map_location='34D7-34D7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13843915, end_position_on_the_genomic_accession=13845325, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34800 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34800, CurrentID=0, Status='live', Symbol='CG7916', Aliases='Dmel_ BG:DS00941.13, CT23894, Dmel\\CG7916, LP05416', description='CG7916 gene product from transcript CG7916-RA', other_designations='CG7916-PA', map_location='34D7-34D7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13846752, end_position_on_the_genomic_accession=13847799, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34801 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34801, CurrentID=0, Status='live', Symbol='CG7953', Aliases='Dmel_ BG:DS00941.14, DS00941.14, Dmel\\CG7953, anon-WO0140519.73', description='CG7953 gene product from transcript CG7953-RB', other_designations='CG7953-PA|CG7953-PB', map_location='34D7-34D8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13847925, end_position_on_the_genomic_accession=13849223, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34802 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34802, CurrentID=0, Status='live', Symbol='CG7968', Aliases='Dmel_ BG:DS00941.15, DS00941.15, Dmel\\CG7968', description='CG7968 gene product from transcript CG7968-RA', other_designations='CG7968-PA', map_location='34D8-34D8', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13849400, end_position_on_the_genomic_accession=13850329, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34803 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34803, CurrentID=0, Status='live', Symbol='CenG1A', Aliases='Dmel_CG31811, BG:DS08220.1, CG16866, CG16867, CG31811, CG7982, Dmel\\CG31811, cenG, cenG1A, cenG1a, ceng1A', description='Centaurin gamma 1A', other_designations='CG31811-PA|CG31811-PB|CG31811-PC|CenG1A-PA|CenG1A-PB|CenG1A-PC|centaurin gamma|centaurin gamma 1A|centaurin gamma-1A', map_location='34D6-34E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13835564, end_position_on_the_genomic_accession=13898712, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  34804 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34804, CurrentID=0, Status='live', Symbol='Smg5', Aliases='Dmel_CG8954, BG:DS08220.2, CG8954, Dmel\\CG8954, SMG5, anon-34Ea, dSMG5, smg5', description='CG8954 gene product from transcript CG8954-RB', other_designations='CG8954-PA|CG8954-PB|CG8954-PC|Smg5-PA|Smg5-PB|Smg5-PC', map_location='34E2-34E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13898828, end_position_on_the_genomic_accession=13904661, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34805 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34805, CurrentID=0, Status='live', Symbol='Ance', Aliases='Dmel_CG8827, ACE, ANCE, AnCE, BG:DS08220.3, CG8827, Dmel\\CG8827, RACE, Race, ance, anon-EST:fe3D10, br31, l(2)34Eb, l(2)br31, l34Eb, race', description='Angiotensin converting enzyme', other_designations='Ance-PA|Ance-PB|Ance-PC|CG8827-PA|CG8827-PB|CG8827-PC|angiotensin I-converting enzyme|angiotensin converting enzyme|angiotensin-converting enzyme|anon-fast-evolving-3D10|related to angiotensin converting enzyme', map_location='34E2-34E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13905645, end_position_on_the_genomic_accession=13909212, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34806 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34806, CurrentID=0, Status='live', Symbol='Ance-2', Aliases='Dmel_CG16869, CG16869, CG31844, Dmel\\CG16869, ance-2', description='CG16869 gene product from transcript CG16869-RA', other_designations='Ance-2-PA|CG16869-PA', map_location='34E2-34E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13909333, end_position_on_the_genomic_accession=13911719, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34807 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34807, CurrentID=0, Status='live', Symbol='Acyp', Aliases='Dmel_CG16870, ACPDro, AcPDro, BG:DS00180.1, CG16870, Dmel\\CG16870', description='Acylphosphatase', other_designations='Acyp-PA|Acyp-PB|CG16870-PA|CG16870-PB|acylphosphatase', map_location='34E2-34E2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13912083, end_position_on_the_genomic_accession=13912652, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34808 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34808, CurrentID=0, Status='live', Symbol='Ance-3', Aliases='Dmel_CG17988, BG:DS00180.5, CG17988, CG31766, CG31843, CT40163, DS00180.5, Dmel\\CG17988, ance-3', description='CG17988 gene product from transcript CG17988-RC', other_designations='Ance-3-PB|Ance-3-PC|CG17988-PB|CG17988-PC', map_location='34E3-34E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13914725, end_position_on_the_genomic_accession=13956188, orientation='plus', exon_count=9, OMIM='', no_hdr0=''),
  34809 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34809, CurrentID=0, Status='live', Symbol='CG16886', Aliases='Dmel_ BG:DS00180.2, Dmel\\CG16886, vajk-1', description='CG16886 gene product from transcript CG16886-RB', other_designations='CG16886-PA|CG16886-PB|uncharacterized protein', map_location='34E4-34E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13920707, end_position_on_the_genomic_accession=13923553, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34811 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34811, CurrentID=0, Status='live', Symbol='CG16885', Aliases='Dmel_ CG18634, Dmel\\CG16885, vajk-2', description='CG16885 gene product from transcript CG16885-RA', other_designations='CG16885-PA|uncharacterized protein', map_location='34E4-34E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13932559, end_position_on_the_genomic_accession=13934692, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34812 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34812, CurrentID=0, Status='live', Symbol='CG16884', Aliases='Dmel_ BG:DS00180.3, Dmel\\CG16884, vajk-3', description='CG16884 gene product from transcript CG16884-RA', other_designations='CG16884-PA|uncharacterized protein', map_location='34E4-34E4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13944756, end_position_on_the_genomic_accession=13947476, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34813 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34813, CurrentID=0, Status='live', Symbol='NimB1', Aliases='Dmel_CG33119, BG:DS00180.12, BcDNA:GH07762, CG33119, CG8855, CT25428, DS00180.12, Dmel\\CG33119, nim B1, nimB1', description='Nimrod B1', other_designations='CG33119-PA|CG33119-PB|NimB1-PA|NimB1-PB|nimrod B1', map_location='34E5-34E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13963507, end_position_on_the_genomic_accession=13965088, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34814 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34814, CurrentID=0, Status='live', Symbol='NimB4', Aliases='Dmel_CG33115, BG:DS00180.8, CG16882, CG33115, CT37470, DS00180.8, Dmel\\CG33115, nimB4', description='Nimrod B4', other_designations='CG33115-PA|NimB4-PA|nimrod B4|nimrodB4', map_location='34E5-34E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13968280, end_position_on_the_genomic_accession=13969976, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34815 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34815, CurrentID=0, Status='live', Symbol='NimB5', Aliases='Dmel_CG16873, BG:DS00180.9, CG16873, Dmel\\CG16873, nimB5', description='Nimrod B5', other_designations='CG16873-PA|CG16873-PB|CG16873-PC|NimB5-PA|NimB5-PB|NimB5-PC|nimrod B5', map_location='34E5-34E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13970177, end_position_on_the_genomic_accession=13972173, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34816 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34816, CurrentID=0, Status='live', Symbol='NimC1', Aliases='Dmel_CG8942, BG:DS00180.10, CG8942, CT25688, Dmel\\CG8942, Nim, NimC, P1, nimC1, nimrod', description='Nimrod C1', other_designations='CG8942-PA|CG8942-PB|CG8942-PC|NimC1-PA|NimC1-PB|NimC1-PC|NimrodC1|nimrod|nimrod C1', map_location='34E5-34E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13973158, end_position_on_the_genomic_accession=13976769, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34817 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34817, CurrentID=0, Status='live', Symbol='Cyp28a5', Aliases='Dmel_CG8864, 28a5, BEST:GH10483, BG:DS00180.11, CG8864, Cyp28A5, DS00180.11, Dmel\\CG8864, cyp28a5, gh10483', description='CG8864 gene product from transcript CG8864-RA', other_designations='CG8864-PA|Cyp28a5-PA|cytochrome P450', map_location='34E5-34E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13977302, end_position_on_the_genomic_accession=13979569, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34818 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34818, CurrentID=0, Status='live', Symbol='NimC2', Aliases='Dmel_CG18146, BG:DS00180.14, CG18146, CG18146-PB, CT40902, DS00180.14, Dmel\\CG18146, nimC2', description='Nimrod C2', other_designations='CG18146-PA|CG18146-PB|CG18146-PC|NimC2-PA|NimC2-PB|NimC2-PC|nimrod C2', map_location='34E5-34E5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13980126, end_position_on_the_genomic_accession=13983269, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34819 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34819, CurrentID=0, Status='live', Symbol='rk', Aliases='Dmel_CG8930, BG:DS00180.13, CG8930, CT25644, DLGR-2, DLGR2, Dmel\\CG8930, LGR2/CG8930, rk', description='rickets', other_designations='CG8930-PA|glycoprotein hormone receptor II|glycoprotein-hormone-receptor-II|leucine-rich repeat-containing G protein-coupled receptor 2|rk-PA', map_location='2-48.8 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=13982743, end_position_on_the_genomic_accession=14001248, orientation='minus', exon_count=15, OMIM='', no_hdr0=''),
  34822 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34822, CurrentID=0, Status='live', Symbol='CG4500', Aliases='Dmel_ 2a9, BG:DS05899.1, Dmel\\CG4500, I, anon-EST:CL2a9', description='CG4500 gene product from transcript CG4500-RA', other_designations='CG4500-PA', map_location='34F1-34F1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14027001, end_position_on_the_genomic_accession=14029368, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34823 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34823, CurrentID=0, Status='live', Symbol='CG18095', Aliases='Dmel_ BG:DS05899.7, DS05899.7, Dmel\\CG18095', description='CG18095 gene product from transcript CG18095-RB', other_designations='CG18095-PA|CG18095-PB|CG18095-PC|gp150-like|uncharacterized protein', map_location='34F1-34F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14029262, end_position_on_the_genomic_accession=14031539, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34824 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34824, CurrentID=0, Status='live', Symbol='NimC4', Aliases='Dmel_CG16876, BG:DS05899.3, CG16876, CT35247, Dmel\\CG16876, nimC4, simu', description='Nimrod C4', other_designations='CG16876-PA|NimC4-PA|nimrod C4|six microns under|six-microns-under', map_location='34F2-34F2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14047582, end_position_on_the_genomic_accession=14048863, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  38572 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=38572, CurrentID=0, Status='live', Symbol='CG18418', Aliases='Dmel_ Dmel\\CG18418, anon-WO0140519.190', description='CG18418 gene product from transcript CG18418-RA', other_designations='CG18418-PA|uncharacterized protein', map_location='64B13-64B13', chromosome='3L', genomic_nucleotide_accession_version='NT_037436.4', start_position_on_the_genomic_accession=4688929, end_position_on_the_genomic_accession=4690070, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34826 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34826, CurrentID=0, Status='live', Symbol='nAChRalpha5', Aliases='Dmel_CG32975, BG:DS05899.4, BG:DS05899.5, CG16878, CG32975, CG4498, CT14633, Dalpha5, Dmel\\CG32975, Nic 34E, anon-WO02059370.44, daf, lincRNA.128, lincRNA.S1055, nAChR, nAChRalpha-34E, nAcRalpha-34E, nAcRalpha-34e', description='nicotinic Acetylcholine Receptor alpha5', other_designations='CG32975-PB|CG32975-PD|CG32975-PH|Dalpha5|nAChRalpha5-PB|nAChRalpha5-PD|nAChRalpha5-PH|nicotinic acetylcholine Receptor_34E|nicotinic acetylcholine receptor alpha 34E|nicotinic acetylcholine receptor alpha5', map_location='34F2-34F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14040170, end_position_on_the_genomic_accession=14094401, orientation='plus', exon_count=15, OMIM='', no_hdr0=''),
  34827 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34827, CurrentID=0, Status='live', Symbol='CG16879', Aliases='Dmel_ BG:DS01759.1, DS01759.1, Dmel\\CG16879', description='CG16879 gene product from transcript CG16879-RB', other_designations='CG16879-PA|CG16879-PB|uncharacterized protein', map_location='34F4-34F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14104483, end_position_on_the_genomic_accession=14107461, orientation='plus', exon_count=4, OMIM='', no_hdr0=''),
  34828 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34828, CurrentID=0, Status='live', Symbol='CG15293', Aliases='Dmel_ BG:DS01759.2, CT35241, Dmel\\CG15293, HL03474', description='CG15293 gene product from transcript CG15293-RC', other_designations='CG15293-PA|CG15293-PC|uncharacterized protein', map_location='34F4-34F4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14108057, end_position_on_the_genomic_accession=14109447, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34829 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34829, CurrentID=0, Status='live', Symbol='CG17341', Aliases='Dmel_ BG:DS01523.1, Dmel\\CG17341', description='CG17341 gene product from transcript CG17341-RB', other_designations='CG17341-PB|uncharacterized protein', map_location='35A1-35A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14134491, end_position_on_the_genomic_accession=14160587, orientation='plus', exon_count=5, OMIM='', no_hdr0=''),
  34830 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34830, CurrentID=0, Status='live', Symbol='CG43333', Aliases='Dmel_ BG:DS01523.2, CG15291, CG32972, Dmel\\CG43333, Dmel_CG32972', description='CG43333 gene product from transcript CG43333-RA', other_designations='CG43333-PA|uncharacterized protein', map_location='35A1-35A1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14163508, end_position_on_the_genomic_accession=14180686, orientation='minus', exon_count=6, OMIM='', no_hdr0=''),
  34831 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34831, CurrentID=0, Status='live', Symbol='Dyrk2', Aliases='Dmel_CG4551, BG:DS01523.3, CG4551, DYRK, DYRK2, Dm2, DmDyrk2, Dmel\\CG4551, dDYRK2, smi35A', description='Dual-specificity tyrosine phosphorylation-regulated kinase 2', other_designations='CG4551-PA|CG4551-PB|CG4551-PC|CG4551-PD|CG4551-PE|CG4551-PF|CG4551-PG|Dyrk2-PA|Dyrk2-PB|Dyrk2-PC|Dyrk2-PD|Dyrk2-PE|Dyrk2-PF|Dyrk2-PG|dual specificity tyrosine phosphorylation-regulated kinase|smell impaired 35A', map_location='35A1-35A2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14184478, end_position_on_the_genomic_accession=14234126, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  34833 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34833, CurrentID=0, Status='live', Symbol='ms(2)34Fe', Aliases='Dmel_CG15287, BG:DS01068.1, CG15287, Dmel\\CG15287, br40, l(2)34Fe, ms(2)34Fh, ms(2)br40, ms34Fe', description='male sterile (2) 34Fe', other_designations='CG15287-PA|ms(2)34Fe-PA', map_location='35A4-35A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14328429, end_position_on_the_genomic_accession=14333860, orientation='plus', exon_count=10, OMIM='', no_hdr0=''),
  34834 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34834, CurrentID=0, Status='live', Symbol='CG15286', Aliases='Dmel_ BG:DS01068.11, Dmel\\CG15286', description='CG15286 gene product from transcript CG15286-RA', other_designations='CG15286-PA|CG15286-PB|uncharacterized protein', map_location='35A4-35A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14338240, end_position_on_the_genomic_accession=14340080, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34835 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34835, CurrentID=0, Status='live', Symbol='CG33090', Aliases='Dmel_ BG:DS01068.2, CG15287, CG31837, CG7469, Dmel\\CG33090', description='CG33090 gene product from transcript CG33090-RE', other_designations='CG33090-PB|CG33090-PC|CG33090-PD|CG33090-PE|glucosylceramidase|uncharacterized protein', map_location='35A4-35A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14334158, end_position_on_the_genomic_accession=14345795, orientation='plus', exon_count=8, OMIM='', no_hdr0=''),
  34836 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34836, CurrentID=0, Status='live', Symbol='Send2', Aliases='Dmel_CG18125, BG:DS01068.10, CG18125, DS01068.10, Dmel\\CG18125, SPH190', description='Spermathecal endopeptidase 2', other_designations='CG18125-PA|Send2-PA|spermathecal endopeptidase 2', map_location='35A4-35A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14345915, end_position_on_the_genomic_accession=14346688, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34837 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34837, CurrentID=0, Status='live', Symbol='mTTF', Aliases='Dmel_CG18124, BG:DS01068.4, CG18124, DS01068.4, DmTTF, Dmel\\CG18124', description='mitochondrial transcription termination factor', other_designations='CG18124-PA|mTTF-PA', map_location='35A4-35A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14347239, end_position_on_the_genomic_accession=14348790, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34838 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34838, CurrentID=0, Status='live', Symbol='l(2)34Fc', Aliases='Dmel_CG7532, A2, BG:DS01068.5, BcDNA:RE60882, CG7532, DS01068.5, Dmel\\CG7532, anon-EST:ParkEST060, br8, l(2)br8, l34Fc', description='lethal (2) 34Fc', other_designations='CG7532-PA|CG7532-PB|l(2)34Fc-PA|l(2)34Fc-PB|lethal 8 in the black-reduced region|lethal group A2', map_location='35A4-35A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14349020, end_position_on_the_genomic_accession=14351513, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34839 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34839, CurrentID=0, Status='live', Symbol='l(2)34Fd', Aliases='Dmel_CG7516, A4, BG:DS01068.6, CG7516, Dmel\\CG7516, br15, l(2)br15', description='lethal (2) 34Fd', other_designations='CG7516-PA|l(2)34Fd-PA|lethal 15 in the black-reduced region|lethal group A4', map_location='35A4-35A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14352594, end_position_on_the_genomic_accession=14355085, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34840 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34840, CurrentID=0, Status='live', Symbol='Rab14', Aliases='Dmel_CG4212, 57H4T, AAF53390, BG:DS01068.7, CG4212, DRAB14, D DmRab14, Dmel\\CG4212, ESTS:57H4T, O18336, Rab-r14, anon-sts33, rab14', description='CG4212 gene product from transcript CG4212-RA', other_designations='CG4212-PA|CG4212-PB|CG4212-PD|Rab-protein 14|Rab14-PA|Rab14-PB|Rab14-PD', map_location='35A4-35A4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14355145, end_position_on_the_genomic_accession=14358764, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34842 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34842, CurrentID=0, Status='live', Symbol='spel1', Aliases='Dmel_CG4215, BG:DS01068.9, CG4215, Dmel\\CG4215, Msh2, SPEL1, spel, spel-1', description='spellchecker1', other_designations='CG4215-PA|CG4215-PD|CG4215-PE|CG4215-PF|spel1-PA|spel1-PD|spel1-PE|spel1-PF|spellchecker|spellchecker 1', map_location='35A4-35B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14362069, end_position_on_the_genomic_accession=14366840, orientation='plus', exon_count=6, OMIM='', no_hdr0=''),
  34843 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34843, CurrentID=0, Status='live', Symbol='ppk', Aliases='Dmel_CG3478, BG:DS06238.1, CG3478, Dmel\\CG3478, PPK, PPK1, dmdNaC1, dmdNaCl, mdNaC1, pkt1, ppk', description='pickpocket', other_designations='CG3478-PA|Pickpocket1|drifter|multidendritic neurons sodium channel 1|pickpocket 1|ppk-PA', map_location='35B1-35B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14378218, end_position_on_the_genomic_accession=14381172, orientation='minus', exon_count=7, OMIM='', no_hdr0=''),
  34844 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34844, CurrentID=0, Status='live', Symbol='elB', Aliases='Dmel_CG4220, BG:DS06238.3, CG4220, Dmel\\CG4220, Elb, P10, el, el[B], elb, elbow', description='elbow B', other_designations='CG4220-PC|CG4220-PD|ElbowB|elB-PC|elB-PD|elbow', map_location='2-50.0 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14390628, end_position_on_the_genomic_accession=14409549, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34845 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34845, CurrentID=0, Status='live', Symbol='Pburs', Aliases='Dmel_CG15284, A, Bur beta, Burs beta, Bursbeta, CG15284, Dmel\\CG15284, PBURS, bur &gr;, burs beta, burs-beta, bursbeta, pads-b, pburs, pu, pup', description='Partner of Bursicon', other_designations='CG15284-PA|Pburs-PA|bursicon|bursicon beta|bursicon beta subunit|bursicon beta-subunit|lethal group A|partner of burs|partner of bursicon|pupal', map_location='35B1-35B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14416729, end_position_on_the_genomic_accession=14417331, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34846 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34846, CurrentID=0, Status='live', Symbol='Cpr35B', Aliases='Dmel_CG3474, BG:DS06238.4, CG3474, DS06283.4, DmelCpr35B, Dmel\\CG3474', description='Cuticular protein 35B', other_designations='CG3474-PA|Cpr35B-PA|cuticular protein 35B', map_location='35B1-35B1', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14424315, end_position_on_the_genomic_accession=14425189, orientation='minus', exon_count=2, OMIM='', no_hdr0=''),
  34847 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34847, CurrentID=0, Status='live', Symbol='noc', Aliases='Dmel_CG4491, BG:DS04641.1, CG4491, Dmel\\CG4491, Noc, br22, el, l(2)35Ba, l(2)35Ba/nocA, l(2)br22, l35BaA, noc[A], noc', description='no ocelli', other_designations='CG4491-PA|CG4491-PB|no-ocelli|noc-PA|noc-PB', map_location='35B2-35B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14490859, end_position_on_the_genomic_accession=14494019, orientation='plus', exon_count=2, OMIM='', no_hdr0=''),
  34848 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34848, CurrentID=0, Status='live', Symbol='CG4218', Aliases='Dmel_ BG:DS04641.8, Dmel\\CG4218, anon-SAGE:Wang-118, anon-SAGE:Wang-133', description='CG4218 gene product from transcript CG4218-RC', other_designations='CG4218-PA|CG4218-PB|CG4218-PC|CG4218-PD|anon-SAGE:Wang-118|anon-SAGE:Wang-133', map_location='35B2-35B2', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14547498, end_position_on_the_genomic_accession=14549109, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34849 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34849, CurrentID=0, Status='live', Symbol='CG3473', Aliases='Dmel_ BG:DS01486.1, BcDNA:AT16033, Dmel\\CG3473, cg3473', description='CG3473 gene product from transcript CG3473-RB', other_designations='CG3473-PA|CG3473-PB', map_location='35B3-35B3', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14563015, end_position_on_the_genomic_accession=14563726, orientation='minus', exon_count=1, OMIM='', no_hdr0=''),
  34850 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34850, CurrentID=0, Status='live', Symbol='osp', Aliases='Dmel_CG3479, BG:DS01486.5, BG:DS01486.7, BG:DS07721.2, CG3479, Dmel\\CG3479, alw, anon-WO02059370.75, l(2)rJ571, v(2)rJ571', description='outspread', other_designations='CG3479-PC|CG3479-PD|CG3479-PE|CG3479-PF|arc-like wing|arclike wing|osp-PC|osp-PD|osp-PE|osp-PF', map_location='2-50.1 cM', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14599196, end_position_on_the_genomic_accession=14689340, orientation='minus', exon_count=12, OMIM='', no_hdr0=''),
  34853 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34853, CurrentID=0, Status='live', Symbol='CG15282', Aliases='Dmel_ BG:DS07721.3, BcDNA:RE15191, DS07721.3, Dmel\\CG15282', description='CG15282 gene product from transcript CG15282-RC', other_designations='CG15282-PA|CG15282-PB|CG15282-PC|uncharacterized protein', map_location='35B4-35B4', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14712471, end_position_on_the_genomic_accession=14713298, orientation='plus', exon_count=3, OMIM='', no_hdr0=''),
  34854 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34854, CurrentID=0, Status='live', Symbol='CG42685', Aliases='Dmel_ BG:DS07721.6, CG12636, CG33482, DS07721.6, Dmel\\CG42685, Dmel_CG12636, Dmel_CG33482', description='CG42685 gene product from transcript CG42685-RA', other_designations='CG42685-PA|DS07721.6-like protein|uncharacterized protein', map_location='35B5-35B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14724617, end_position_on_the_genomic_accession=14730177, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34856 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34856, CurrentID=0, Status='live', Symbol='CG4691', Aliases='Dmel_ BG:DS06874.1, Dmel\\CG4691, anon-WO0140519.47', description='CG4691 gene product from transcript CG4691-RA', other_designations='CG4691-PA', map_location='35B5-35B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14760767, end_position_on_the_genomic_accession=14761924, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34857 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34857, CurrentID=0, Status='live', Symbol='CSN1a', Aliases='Dmel_CG4697, BG:DS06874.2, CG4697, CH1-1, COP9, CSN1, Csn1A, Csn1a, Dch1, Dch1-1, Dmel\\CG4697, csn1', description='COP9 signalosome subunit 1a', other_designations='CG4697-PA|COP9 complex homolog subunit 1 a|CSN1a-PA|drosophila COP9 signalosome homolog 1', map_location='35B5-35B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14762765, end_position_on_the_genomic_accession=14764065, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34858 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34858, CurrentID=0, Status='live', Symbol='CG4701', Aliases='Dmel_ BG:DS06874.3, DmDM19DC4Z, Dmel\\CG4701', description='CG4701 gene product from transcript CG4701-RA', other_designations='CG4701-PA', map_location='35B5-35B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14765908, end_position_on_the_genomic_accession=14767225, orientation='plus', exon_count=1, OMIM='', no_hdr0=''),
  34859 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34859, CurrentID=0, Status='live', Symbol='CG4650', Aliases='Dmel_ Dmel\\CG4650, SPH197', description='CG4650 gene product from transcript CG4650-RC', other_designations='CG4650-PB|CG4650-PC', map_location='35B5-35B5', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14773814, end_position_on_the_genomic_accession=14774981, orientation='minus', exon_count=4, OMIM='', no_hdr0=''),
  34863 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34863, CurrentID=0, Status='live', Symbol='CG15279', Aliases='Dmel_ BG:DS03431.1, DS03431.1, DmNAT6, Dmel\\CG15279, anon-WO0149848.9', description='CG15279 gene product from transcript CG15279-RB', other_designations='CG15279-PA|CG15279-PB|CG15279-PD|uncharacterized protein', map_location='35B6-35B6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14844993, end_position_on_the_genomic_accession=14851749, orientation='minus', exon_count=8, OMIM='', no_hdr0=''),
  34864 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34864, CurrentID=0, Status='live', Symbol='CG4480', Aliases='Dmel_ Dmel\\CG4480', description='CG4480 gene product from transcript CG4480-RB', other_designations='CG4480-PB|CG4480-PC', map_location='35B6-35B6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14870371, end_position_on_the_genomic_accession=14872022, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34865 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34865, CurrentID=0, Status='live', Symbol='CG15278', Aliases='Dmel_ Dmel\\CG15278, NEST:bs32h08, bs32h08.y1', description='CG15278 gene product from transcript CG15278-RC', other_designations='CG15278-PA|CG15278-PB|CG15278-PC|uncharacterized protein', map_location='35B6-35B6', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14874376, end_position_on_the_genomic_accession=14876333, orientation='minus', exon_count=5, OMIM='', no_hdr0=''),
  34866 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34866, CurrentID=0, Status='live', Symbol='ProtA', Aliases='Dmel_CG4479, BG:DS03431.2, BcDNA:AT31403, CG4479, Dmel\\CG4479, Mst35Ba, dProtA, mst35B, mst35Ba, mst35b, protA', description='Protamine A', other_designations='CG4479-PA|CG4479-PB|Male-specific-transcript-35Ba|ProtA-PA|ProtA-PB|ProtamineA|dProtamineA|protamine|protamine (mst35Ba)|protamine A', map_location='35B6-35B7', chromosome='2L', genomic_nucleotide_accession_version='NT_033779.5', start_position_on_the_genomic_accession=14879050, end_position_on_the_genomic_accession=14881652, orientation='minus', exon_count=3, OMIM='', no_hdr0=''),
  34867 : NtData(tax_id=7227, Org_name='Drosophila melanogaster', GeneID=34867, CurrentID=0, Status='live', Symbol='ProtB', Aliases='Dmel_CG4478, BG:DS03431.3, BcDNA:GH11850, CG4478, Dmel\\CG4