"""ECO ID to Evidence code group dictionary from evidenceontology"""

# pylint: disable=too-many-lines
# 1295 ECO IDs
ECO2GRP = {
    'ECO:0000030': 'ISA',
    'ECO:0000031': 'ISA',
    'ECO:0000032': 'ISA',
    'ECO:0000053': 'IEA',
    'ECO:0000209': 'IEA',
    'ECO:0000210': 'IEA',
    'ECO:0000211': 'IEA',
    'ECO:0000213': 'IEA',
    'ECO:0000245': 'RCA',
    'ECO:0000247': 'ISA',
    'ECO:0000248': 'IEA',
    'ECO:0000249': 'IEA',
    'ECO:0000250': 'ISS',
    'ECO:0000251': 'IEA',
    'ECO:0000254': 'IEA',
    'ECO:0000255': 'ISM',
    'ECO:0000256': 'IEA',
    'ECO:0000257': 'ISM',
    'ECO:0000258': 'IEA',
    'ECO:0000259': 'IEA',
    'ECO:0000260': 'ISM',
    'ECO:0000261': 'IEA',
    'ECO:0000262': 'ISM',
    'ECO:0000263': 'IEA',
    'ECO:0000264': 'ISM',
    'ECO:0000265': 'IEA',
    'ECO:0000266': 'ISO',
    'ECO:0000269': 'EXP',
    'ECO:0000270': 'IEP',
    'ECO:0000272': 'IEP',
    'ECO:0000273': 'IEP',
    'ECO:0000274': 'IDA',
    'ECO:0000275': 'IEP',
    'ECO:0000276': 'IEP',
    'ECO:0000277': 'IEP',
    'ECO:0000278': 'EXP',
    'ECO:0000279': 'IEP',
    'ECO:0000281': 'IEP',
    'ECO:0000282': 'IEP',
    'ECO:0000283': 'IEP',
    'ECO:0000284': 'IEP',
    'ECO:0000285': 'IEP',
    'ECO:0000287': 'IEP',
    'ECO:0000288': 'EXP',
    'ECO:0000289': 'IEP',
    'ECO:0000290': 'IEP',
    'ECO:0000291': 'IEP',
    'ECO:0000303': 'NAS',
    'ECO:0000304': 'TAS',
    'ECO:0000305': 'IC',
    'ECO:0000306': 'IC',
    'ECO:0000307': 'ND',
    'ECO:0000313': 'IEA',
    'ECO:0000314': 'IDA',
    'ECO:0000315': 'IMP',
    'ECO:0000316': 'IGI',
    'ECO:0000317': 'IGC',
    'ECO:0000318': 'IBA',
    'ECO:0000319': 'IBD',
    'ECO:0000320': 'IKR',
    'ECO:0000321': 'IRD',
    'ECO:0000322': 'IEA',
    'ECO:0000323': 'IEA',
    'ECO:0000329': 'ISA',
    'ECO:0000330': 'ISA',
    'ECO:0000331': 'IEA',
    'ECO:0000332': 'IEA',
    'ECO:0000346': 'IEP',
    'ECO:0000347': 'IEA',
    'ECO:0000348': 'IEA',
    'ECO:0000349': 'IEP',
    'ECO:0000350': 'IEA',
    'ECO:0000351': 'IEP',
    'ECO:0000353': 'IPI',
    'ECO:0000354': 'IGC',
    'ECO:0000363': 'IEA',
    'ECO:0000364': 'IEA',
    'ECO:0000366': 'IEA',
    'ECO:0000501': 'IEA',
    'ECO:0001043': 'EXP',
    'ECO:0001138': 'IDA',
    'ECO:0001139': 'IDA',
    'ECO:0001140': 'IDA',
    'ECO:0001141': 'IDA',
    'ECO:0001142': 'IDA',
    'ECO:0001143': 'IDA',
    'ECO:0001144': 'IDA',
    'ECO:0001145': 'IDA',
    'ECO:0001146': 'EXP',
    'ECO:0001147': 'EXP',
    'ECO:0001148': 'IDA',
    'ECO:0001149': 'EXP',
    'ECO:0001150': 'IPI',
    'ECO:0001151': 'IPI',
    'ECO:0001152': 'IPI',
    'ECO:0001153': 'IDA',
    'ECO:0001154': 'IDA',
    'ECO:0001155': 'IDA',
    'ECO:0001156': 'IDA',
    'ECO:0001157': 'IDA',
    'ECO:0001158': 'IDA',
    'ECO:0001159': 'IDA',
    'ECO:0001160': 'EXP',
    'ECO:0001161': 'IMP',
    'ECO:0001162': 'IDA',
    'ECO:0001163': 'IDA',
    'ECO:0001164': 'IPI',
    'ECO:0001165': 'IDA',
    'ECO:0001166': 'IDA',
    'ECO:0001167': 'IMP',
    'ECO:0001168': 'IMP',
    'ECO:0001169': 'EXP',
    'ECO:0001170': 'IPI',
    'ECO:0001171': 'EXP',
    'ECO:0001172': 'IDA',
    'ECO:0001173': 'IDA',
    'ECO:0001174': 'IDA',
    'ECO:0001175': 'IMP',
    'ECO:0001176': 'IDA',
    'ECO:0001177': 'EXP',
    'ECO:0001179': 'IMP',
    'ECO:0001180': 'IPI',
    'ECO:0001181': 'IPI',
    'ECO:0001182': 'IEP',
    'ECO:0001183': 'IPI',
    'ECO:0001184': 'EXP',
    'ECO:0001185': 'IDA',
    'ECO:0001186': 'EXP',
    'ECO:0001187': 'IDA',
    'ECO:0001188': 'IPI',
    'ECO:0001189': 'EXP',
    'ECO:0001190': 'IDA',
    'ECO:0001191': 'IDA',
    'ECO:0001192': 'IDA',
    'ECO:0001193': 'IDA',
    'ECO:0001194': 'IDA',
    'ECO:0001195': 'IDA',
    'ECO:0001196': 'IDA',
    'ECO:0001197': 'IDA',
    'ECO:0001198': 'IDA',
    'ECO:0001199': 'IDA',
    'ECO:0001200': 'IDA',
    'ECO:0001201': 'IDA',
    'ECO:0001202': 'IDA',
    'ECO:0001203': 'IDA',
    'ECO:0001204': 'IDA',
    'ECO:0001205': 'IDA',
    'ECO:0001206': 'IDA',
    'ECO:0001207': 'IDA',
    'ECO:0001208': 'IDA',
    'ECO:0001209': 'IDA',
    'ECO:0001210': 'IDA',
    'ECO:0001211': 'IDA',
    'ECO:0001212': 'IDA',
    'ECO:0001213': 'IDA',
    'ECO:0001214': 'IDA',
    'ECO:0001215': 'IDA',
    'ECO:0001216': 'IDA',
    'ECO:0001217': 'IDA',
    'ECO:0001218': 'IDA',
    'ECO:0001219': 'IDA',
    'ECO:0001220': 'IDA',
    'ECO:0001221': 'IDA',
    'ECO:0001222': 'IDA',
    'ECO:0001224': 'IMP',
    'ECO:0001225': 'IMP',
    'ECO:0001226': 'IPI',
    'ECO:0001227': 'IPI',
    'ECO:0001228': 'EXP',
    'ECO:0001229': 'IPI',
    'ECO:0001230': 'EXP',
    'ECO:0001231': 'IDA',
    'ECO:0001232': 'IDA',
    'ECO:0001233': 'IDA',
    'ECO:0001234': 'IDA',
    'ECO:0001235': 'IDA',
    'ECO:0001236': 'EXP',
    'ECO:0001237': 'EXP',
    'ECO:0001238': 'EXP',
    'ECO:0001239': 'IDA',
    'ECO:0001240': 'EXP',
    'ECO:0001241': 'IDA',
    'ECO:0001242': 'IPI',
    'ECO:0001243': 'IDA',
    'ECO:0001244': 'IPI',
    'ECO:0001245': 'IPI',
    'ECO:0001246': 'IDA',
    'ECO:0001247': 'IMP',
    'ECO:0001248': 'IDA',
    'ECO:0001249': 'IDA',
    'ECO:0001250': 'EXP',
    'ECO:0001251': 'EXP',
    'ECO:0001252': 'EXP',
    'ECO:0001253': 'EXP',
    'ECO:0001254': 'IDA',
    'ECO:0001255': 'EXP',
    'ECO:0001256': 'IDA',
    'ECO:0001257': 'EXP',
    'ECO:0001258': 'EXP',
    'ECO:0001259': 'EXP',
    'ECO:0001260': 'EXP',
    'ECO:0001261': 'IDA',
    'ECO:0001263': 'IDA',
    'ECO:0001264': 'IDA',
    'ECO:0001265': 'EXP',
    'ECO:0001266': 'IMP',
    'ECO:0001267': 'IDA',
    'ECO:0001268': 'IDA',
    'ECO:0001269': 'IPI',
    'ECO:0001270': 'EXP',
    'ECO:0001271': 'IDA',
    'ECO:0001272': 'EXP',
    'ECO:0001273': 'EXP',
    'ECO:000156': 'IEA',
    'ECO:0001567': 'EXP',
    'ECO:0001568': 'IEA',
    'ECO:000157': 'EXP',
    'ECO:0001570': 'IEP',
    'ECO:0001572': 'IEA',
    'ECO:0001575': 'IEA',
    'ECO:0001576': 'IDA',
    'ECO:0001578': 'IEA',
    'ECO:0001579': 'IDA',
    'ECO:0001581': 'IEA',
    'ECO:0001582': 'EXP',
    'ECO:0001584': 'IEA',
    'ECO:0001585': 'IMP',
    'ECO:0001587': 'IEA',
    'ECO:0001588': 'EXP',
    'ECO:0001590': 'IEA',
    'ECO:0001591': 'IDA',
    'ECO:0001593': 'IEA',
    'ECO:0001594': 'EXP',
    'ECO:0001599': 'IEA',
    'ECO:0001600': 'EXP',
    'ECO:0001807': 'IPI',
    'ECO:0001808': 'EXP',
    'ECO:0001831': 'IEA',
    'ECO:0001832': 'EXP',
    'ECO:0001834': 'IEA',
    'ECO:0001835': 'EXP',
    'ECO:0001837': 'IEA',
    'ECO:0001838': 'IEP',
    'ECO:0001840': 'IEA',
    'ECO:0001841': 'IEP',
    'ECO:0001843': 'IEA',
    'ECO:0001844': 'IMP',
    'ECO:0001846': 'IEA',
    'ECO:0001847': 'IDA',
    'ECO:0005501': 'IDA',
    'ECO:0005523': 'EXP',
    'ECO:0005527': 'EXP',
    'ECO:0005530': 'IMP',
    'ECO:0005542': 'EXP',
    'ECO:0005543': 'EXP',
    'ECO:0005544': 'ISO',
    'ECO:0005546': 'ISS',
    'ECO:0005547': 'NAS',
    'ECO:0005556': 'ISA',
    'ECO:0005557': 'IEA',
    'ECO:0005558': 'ISA',
    'ECO:0005559': 'IEA',
    'ECO:0005560': 'ISA',
    'ECO:0005561': 'IEA',
    'ECO:0005579': 'IDA',
    'ECO:0005580': 'IDA',
    'ECO:0005581': 'EXP',
    'ECO:0005586': 'EXP',
    'ECO:0005589': 'IDA',
    'ECO:0005590': 'IDA',
    'ECO:0005592': 'IDA',
    'ECO:0005595': 'IDA',
    'ECO:0005597': 'IDA',
    'ECO:0005601': 'IDA',
    'ECO:0005610': 'ISS',
    'ECO:0005613': 'EXP',
    'ECO:0005614': 'IDA',
    'ECO:0005615': 'IEP',
    'ECO:0005616': 'IEP',
    'ECO:0005617': 'IEP',
    'ECO:0005618': 'IEA',
    'ECO:0005619': 'IEA',
    'ECO:0005620': 'IPI',
    'ECO:0005621': 'IEA',
    'ECO:0005622': 'ISM',
    'ECO:0005623': 'IEA',
    'ECO:0005624': 'ISM',
    'ECO:0005625': 'IEA',
    'ECO:0005626': 'IPI',
    'ECO:0005627': 'IPI',
    'ECO:0005628': 'IEA',
    'ECO:0005629': 'EXP',
    'ECO:0005630': 'IEA',
    'ECO:0005631': 'IPI',
    'ECO:0005632': 'IDA',
    'ECO:0005633': 'IEP',
    'ECO:0005634': 'IPI',
    'ECO:0005635': 'IEA',
    'ECO:0005636': 'IEP',
    'ECO:0005637': 'IEA',
    'ECO:0005638': 'IDA',
    'ECO:0005639': 'IEA',
    'ECO:0005640': 'IPI',
    'ECO:0005641': 'IEP',
    'ECO:0005642': 'EXP',
    'ECO:0005643': 'IPI',
    'ECO:0005644': 'IPI',
    'ECO:0005645': 'EXP',
    'ECO:0005646': 'IEA',
    'ECO:0005647': 'IPI',
    'ECO:0005648': 'IEP',
    'ECO:0005649': 'ISM',
    'ECO:0005650': 'IEA',
    'ECO:0005651': 'IEA',
    'ECO:0005652': 'IPI',
    'ECO:0005653': 'IEP',
    'ECO:0005654': 'ISA',
    'ECO:0005655': 'IEA',
    'ECO:0005656': 'IPI',
    'ECO:0005657': 'IEP',
    'ECO:0005658': 'ISM',
    'ECO:0005659': 'IEA',
    'ECO:0005660': 'EXP',
    'ECO:0005661': 'EXP',
    'ECO:0005662': 'ISM',
    'ECO:0005663': 'IEA',
    'ECO:0005666': 'EXP',
    'ECO:0005667': 'IMP',
    'ECO:0005668': 'IMP',
    'ECO:0005669': 'IPI',
    'ECO:0005670': 'EXP',
    'ECO:0005671': 'IEA',
    'ECO:0005672': 'IEP',
    'ECO:0005674': 'EXP',
    'ECO:0005676': 'EXP',
    'ECO:0005801': 'IDA',
    'ECO:0005802': 'EXP',
    'ECO:0005804': 'EXP',
    'ECO:0005805': 'IPI',
    'ECO:0006002': 'IEP',
    'ECO:0006003': 'IDA',
    'ECO:0006004': 'IDA',
    'ECO:0006005': 'IDA',
    'ECO:0006006': 'IDA',
    'ECO:0006007': 'IPI',
    'ECO:0006008': 'IPI',
    'ECO:0006009': 'IPI',
    'ECO:0006011': 'IPI',
    'ECO:0006013': 'IDA',
    'ECO:0006015': 'IDA',
    'ECO:0006017': 'TAS',
    'ECO:0006019': 'IC',
    'ECO:0006021': 'IDA',
    'ECO:0006023': 'IDA',
    'ECO:0006025': 'IDA',
    'ECO:0006027': 'IDA',
    'ECO:0006029': 'IDA',
    'ECO:0006030': 'IPI',
    'ECO:0006031': 'IDA',
    'ECO:0006033': 'EXP',
    'ECO:0006035': 'IDA',
    'ECO:0006037': 'IDA',
    'ECO:0006039': 'IDA',
    'ECO:0006041': 'IDA',
    'ECO:0006042': 'IDA',
    'ECO:0006044': 'IDA',
    'ECO:0006046': 'IDA',
    'ECO:0006048': 'IDA',
    'ECO:0006049': 'IMP',
    'ECO:0006050': 'IMP',
    'ECO:0006051': 'IMP',
    'ECO:0006052': 'IMP',
    'ECO:0006054': 'EXP',
    'ECO:0006056': 'HTP',
    'ECO:0006057': 'IEA',
    'ECO:0006059': 'HTP',
    'ECO:0006060': 'IEA',
    'ECO:0006061': 'IDA',
    'ECO:0006062': 'IDA',
    'ECO:0006063': 'IMP',
    'ECO:0006064': 'IDA',
    'ECO:0006067': 'IDA',
    'ECO:0006068': 'IEP',
    'ECO:0006069': 'IEA',
    'ECO:0006071': 'IDA',
    'ECO:0006073': 'IDA',
    'ECO:0006074': 'IPI',
    'ECO:0006075': 'IPI',
    'ECO:0006076': 'IPI',
    'ECO:0006077': 'IPI',
    'ECO:0006078': 'IPI',
    'ECO:0006079': 'IPI',
    'ECO:0006080': 'IPI',
    'ECO:0006081': 'IPI',
    'ECO:0006082': 'IPI',
    'ECO:0006083': 'IPI',
    'ECO:0006084': 'IPI',
    'ECO:0006085': 'IPI',
    'ECO:0006086': 'IPI',
    'ECO:0006087': 'IPI',
    'ECO:0006088': 'IPI',
    'ECO:0006089': 'IPI',
    'ECO:0006090': 'IPI',
    'ECO:0006091': 'IGI',
    'ECO:0006092': 'IGI',
    'ECO:0006093': 'IGI',
    'ECO:0006094': 'IGI',
    'ECO:0006095': 'IGI',
    'ECO:0006096': 'IGI',
    'ECO:0006097': 'IGI',
    'ECO:0006099': 'IMP',
    'ECO:0006101': 'IMP',
    'ECO:0006156': 'IEA',
    'ECO:0006158': 'IEA',
    'ECO:0006160': 'IEA',
    'ECO:0006162': 'IEA',
    'ECO:0006164': 'IEA',
    'ECO:0006165': 'EXP',
    'ECO:0006167': 'IEA',
    'ECO:0006168': 'EXP',
    'ECO:0006170': 'IEP',
    'ECO:0006171': 'IEA',
    'ECO:0006173': 'IEA',
    'ECO:0006174': 'IEP',
    'ECO:0006196': 'EXP',
    'ECO:0006197': 'IEA',
    'ECO:0006198': 'EXP',
    'ECO:0006199': 'IEA',
    'ECO:0006200': 'EXP',
    'ECO:0006201': 'IEA',
    'ECO:0006202': 'EXP',
    'ECO:0006203': 'IEA',
    'ECO:0006204': 'EXP',
    'ECO:0006205': 'IEA',
    'ECO:0006206': 'EXP',
    'ECO:0006207': 'IEA',
    'ECO:0006208': 'IDA',
    'ECO:0006209': 'IEA',
    'ECO:0006210': 'EXP',
    'ECO:0006211': 'IEA',
    'ECO:0006212': 'EXP',
    'ECO:0006213': 'IEA',
    'ECO:0006214': 'EXP',
    'ECO:0006215': 'IEA',
    'ECO:0006217': 'IEA',
    'ECO:0006219': 'IEA',
    'ECO:0006220': 'EXP',
    'ECO:0006221': 'IEA',
    'ECO:0006222': 'EXP',
    'ECO:0006223': 'IEA',
    'ECO:0006224': 'IDA',
    'ECO:0006225': 'IEA',
    'ECO:0006226': 'IDA',
    'ECO:0006227': 'IEA',
    'ECO:0006228': 'EXP',
    'ECO:0006229': 'IEA',
    'ECO:0006230': 'IDA',
    'ECO:0006231': 'IEA',
    'ECO:0006232': 'IDA',
    'ECO:0006233': 'IEA',
    'ECO:0006234': 'IDA',
    'ECO:0006235': 'IEA',
    'ECO:0006236': 'EXP',
    'ECO:0006237': 'IEA',
    'ECO:0006241': 'IEP',
    'ECO:0006242': 'IEA',
    'ECO:0006243': 'IEP',
    'ECO:0006244': 'IEA',
    'ECO:0006245': 'EXP',
    'ECO:0006246': 'IEA',
    'ECO:0006275': 'EXP',
    'ECO:0006276': 'IEA',
    'ECO:0006277': 'IPI',
    'ECO:0006278': 'IEA',
    'ECO:0006279': 'IPI',
    'ECO:0006280': 'IEA',
    'ECO:0006281': 'IDA',
    'ECO:0006282': 'IEA',
    'ECO:0006283': 'EXP',
    'ECO:0006284': 'IEA',
    'ECO:0006285': 'EXP',
    'ECO:0006286': 'IEA',
    'ECO:0006287': 'EXP',
    'ECO:0006288': 'IEA',
    'ECO:0006289': 'EXP',
    'ECO:0006290': 'IEA',
    'ECO:0006291': 'IDA',
    'ECO:0006292': 'IEA',
    'ECO:0006293': 'IPI',
    'ECO:0006294': 'IEA',
    'ECO:0006295': 'IPI',
    'ECO:0006296': 'IEA',
    'ECO:0006297': 'IPI',
    'ECO:0006298': 'IEA',
    'ECO:0006299': 'EXP',
    'ECO:0006300': 'IEA',
    'ECO:0006301': 'IDA',
    'ECO:0006302': 'IEA',
    'ECO:0006303': 'IPI',
    'ECO:0006304': 'IEA',
    'ECO:0006305': 'IDA',
    'ECO:0006306': 'IEA',
    'ECO:0006307': 'IDA',
    'ECO:0006308': 'IEA',
    'ECO:0006309': 'IPI',
    'ECO:0006310': 'IEA',
    'ECO:0006311': 'EXP',
    'ECO:0006312': 'IEA',
    'ECO:0006313': 'EXP',
    'ECO:0006314': 'IEA',
    'ECO:0006315': 'EXP',
    'ECO:0006316': 'IEA',
    'ECO:0006317': 'EXP',
    'ECO:0006318': 'IEA',
    'ECO:0006319': 'IDA',
    'ECO:0006320': 'IEA',
    'ECO:0006321': 'IPI',
    'ECO:0006322': 'IEA',
    'ECO:0006323': 'IDA',
    'ECO:0006324': 'IEA',
    'ECO:0006325': 'IDA',
    'ECO:0006326': 'IEA',
    'ECO:0006327': 'IPI',
    'ECO:0006328': 'IEA',
    'ECO:0006329': 'IPI',
    'ECO:0006330': 'IEA',
    'ECO:0006352': 'IDA',
    'ECO:0006353': 'IEA',
    'ECO:0006354': 'IDA',
    'ECO:0006355': 'IEA',
    'ECO:0006356': 'IDA',
    'ECO:0006357': 'IEA',
    'ECO:0006358': 'IDA',
    'ECO:0006359': 'IEA',
    'ECO:0006360': 'IDA',
    'ECO:0006361': 'IEA',
    'ECO:0006362': 'IDA',
    'ECO:0006363': 'IEA',
    'ECO:0006364': 'IDA',
    'ECO:0006365': 'IEA',
    'ECO:0006366': 'IDA',
    'ECO:0006367': 'IEA',
    'ECO:0006368': 'EXP',
    'ECO:0006369': 'IEA',
    'ECO:0006370': 'EXP',
    'ECO:0006371': 'IEA',
    'ECO:0006373': 'IEA',
    'ECO:0006374': 'EXP',
    'ECO:0006375': 'IEA',
    'ECO:0006376': 'EXP',
    'ECO:0006377': 'IEA',
    'ECO:0006378': 'IDA',
    'ECO:0006379': 'IEA',
    'ECO:0006380': 'IDA',
    'ECO:0006381': 'IEA',
    'ECO:0006382': 'IDA',
    'ECO:0006383': 'IEA',
    'ECO:0006384': 'EXP',
    'ECO:0006385': 'IEA',
    'ECO:0006386': 'EXP',
    'ECO:0006387': 'IEA',
    'ECO:0006388': 'IPI',
    'ECO:0006389': 'IEA',
    'ECO:0006390': 'EXP',
    'ECO:0006391': 'IEA',
    'ECO:0006392': 'IPI',
    'ECO:0006393': 'IEA',
    'ECO:0006397': 'IEA',
    'ECO:0007001': 'HMP',
    'ECO:0007003': 'HGI',
    'ECO:0007005': 'HDA',
    'ECO:0007007': 'HEP',
    'ECO:0007009': 'IPI',
    'ECO:0007016': 'IDA',
    'ECO:0007018': 'IDA',
    'ECO:0007020': 'IPI',
    'ECO:0007022': 'IPI',
    'ECO:0007024': 'IPI',
    'ECO:0007026': 'IPI',
    'ECO:0007028': 'IPI',
    'ECO:0007030': 'IPI',
    'ECO:0007032': 'IPI',
    'ECO:0007034': 'IPI',
    'ECO:0007036': 'IDA',
    'ECO:0007038': 'IDA',
    'ECO:0007040': 'IDA',
    'ECO:0007042': 'IDA',
    'ECO:0007044': 'IDA',
    'ECO:0007046': 'IDA',
    'ECO:0007048': 'IDA',
    'ECO:0007050': 'IDA',
    'ECO:0007052': 'IDA',
    'ECO:0007054': 'IDA',
    'ECO:0007056': 'IDA',
    'ECO:0007058': 'IDA',
    'ECO:0007060': 'IDA',
    'ECO:0007062': 'EXP',
    'ECO:0007064': 'EXP',
    'ECO:0007066': 'EXP',
    'ECO:0007068': 'EXP',
    'ECO:0007070': 'IDA',
    'ECO:0007072': 'IDA',
    'ECO:0007074': 'IPI',
    'ECO:0007076': 'EXP',
    'ECO:0007078': 'EXP',
    'ECO:0007080': 'EXP',
    'ECO:0007082': 'EXP',
    'ECO:0007084': 'IDA',
    'ECO:0007086': 'IDA',
    'ECO:0007088': 'IEP',
    'ECO:0007089': 'IMP',
    'ECO:0007092': 'IMP',
    'ECO:0007093': 'EXP',
    'ECO:0007095': 'EXP',
    'ECO:0007100': 'IDA',
    'ECO:0007101': 'EXP',
    'ECO:0007102': 'IDA',
    'ECO:0007103': 'IDA',
    'ECO:0007104': 'IDA',
    'ECO:0007106': 'IDA',
    'ECO:0007107': 'IDA',
    'ECO:0007108': 'IDA',
    'ECO:0007109': 'IDA',
    'ECO:0007110': 'EXP',
    'ECO:0007111': 'IDA',
    'ECO:0007112': 'IDA',
    'ECO:0007113': 'IDA',
    'ECO:0007114': 'IDA',
    'ECO:0007115': 'IDA',
    'ECO:0007116': 'EXP',
    'ECO:0007117': 'IMP',
    'ECO:0007118': 'IMP',
    'ECO:0007119': 'IDA',
    'ECO:0007120': 'EXP',
    'ECO:0007121': 'EXP',
    'ECO:0007122': 'IDA',
    'ECO:0007123': 'IDA',
    'ECO:0007125': 'EXP',
    'ECO:0007126': 'EXP',
    'ECO:0007127': 'EXP',
    'ECO:0007128': 'EXP',
    'ECO:0007129': 'IPI',
    'ECO:0007130': 'EXP',
    'ECO:0007131': 'EXP',
    'ECO:0007133': 'EXP',
    'ECO:0007134': 'EXP',
    'ECO:0007135': 'EXP',
    'ECO:0007136': 'EXP',
    'ECO:0007137': 'EXP',
    'ECO:0007138': 'EXP',
    'ECO:0007141': 'EXP',
    'ECO:0007142': 'IDA',
    'ECO:0007143': 'IDA',
    'ECO:0007144': 'IEP',
    'ECO:0007145': 'IEP',
    'ECO:0007146': 'IDA',
    'ECO:0007147': 'IDA',
    'ECO:0007148': 'IDA',
    'ECO:0007149': 'IDA',
    'ECO:0007150': 'EXP',
    'ECO:0007151': 'IDA',
    'ECO:0007152': 'ISA',
    'ECO:0007154': 'IEP',
    'ECO:0007155': 'IEP',
    'ECO:0007156': 'EXP',
    'ECO:0007157': 'IDA',
    'ECO:0007159': 'IDA',
    'ECO:0007160': 'IMP',
    'ECO:0007161': 'IMP',
    'ECO:0007162': 'IMP',
    'ECO:0007163': 'IMP',
    'ECO:0007164': 'EXP',
    'ECO:0007165': 'IMP',
    'ECO:0007166': 'IMP',
    'ECO:0007167': 'IMP',
    'ECO:0007168': 'IMP',
    'ECO:0007169': 'IDA',
    'ECO:0007170': 'IDA',
    'ECO:0007171': 'IDA',
    'ECO:0007172': 'IDA',
    'ECO:0007173': 'IDA',
    'ECO:0007174': 'IDA',
    'ECO:0007175': 'IDA',
    'ECO:0007176': 'IDA',
    'ECO:0007177': 'IDA',
    'ECO:0007178': 'IDA',
    'ECO:0007179': 'IDA',
    'ECO:0007180': 'IDA',
    'ECO:0007181': 'IDA',
    'ECO:0007182': 'IDA',
    'ECO:0007184': 'EXP',
    'ECO:0007185': 'IDA',
    'ECO:0007186': 'IDA',
    'ECO:0007187': 'IDA',
    'ECO:0007188': 'IDA',
    'ECO:0007191': 'EXP',
    'ECO:0007192': 'IDA',
    'ECO:0007193': 'IEA',
    'ECO:0007194': 'IEA',
    'ECO:0007196': 'IEA',
    'ECO:0007197': 'IEA',
    'ECO:0007198': 'IEA',
    'ECO:0007199': 'IEA',
    'ECO:0007200': 'IEA',
    'ECO:0007201': 'IEA',
    'ECO:0007202': 'IEA',
    'ECO:0007203': 'IEA',
    'ECO:0007204': 'IEA',
    'ECO:0007205': 'IEA',
    'ECO:0007206': 'IEA',
    'ECO:0007207': 'IEA',
    'ECO:0007208': 'IEA',
    'ECO:0007210': 'IEA',
    'ECO:0007211': 'IEA',
    'ECO:0007212': 'IEA',
    'ECO:0007213': 'IEA',
    'ECO:0007214': 'IEA',
    'ECO:0007215': 'IEA',
    'ECO:0007216': 'IEA',
    'ECO:0007217': 'IEA',
    'ECO:0007218': 'IEA',
    'ECO:0007219': 'IEA',
    'ECO:0007220': 'IEA',
    'ECO:0007221': 'IEA',
    'ECO:0007222': 'IEA',
    'ECO:0007223': 'IEA',
    'ECO:0007224': 'IEA',
    'ECO:0007225': 'IEA',
    'ECO:0007226': 'IEA',
    'ECO:0007227': 'IEA',
    'ECO:0007229': 'IEA',
    'ECO:0007230': 'IEA',
    'ECO:0007231': 'IEA',
    'ECO:0007232': 'IEA',
    'ECO:0007233': 'IEA',
    'ECO:0007234': 'IEA',
    'ECO:0007235': 'IEA',
    'ECO:0007237': 'IEA',
    'ECO:0007238': 'IEA',
    'ECO:0007239': 'IEA',
    'ECO:0007240': 'IEA',
    'ECO:0007241': 'IEA',
    'ECO:0007242': 'IEA',
    'ECO:0007245': 'IEA',
    'ECO:0007246': 'IEA',
    'ECO:0007247': 'IEA',
    'ECO:0007248': 'IEA',
    'ECO:0007249': 'IEA',
    'ECO:0007250': 'IEA',
    'ECO:0007251': 'IEA',
    'ECO:0007252': 'IEA',
    'ECO:0007253': 'IEA',
    'ECO:0007254': 'IEA',
    'ECO:0007255': 'IEA',
    'ECO:0007256': 'IEA',
    'ECO:0007257': 'IEA',
    'ECO:0007258': 'IEA',
    'ECO:0007259': 'IEA',
    'ECO:0007260': 'IEA',
    'ECO:0007261': 'IEA',
    'ECO:0007263': 'IEA',
    'ECO:0007264': 'IEA',
    'ECO:0007265': 'IEA',
    'ECO:0007266': 'IEA',
    'ECO:0007267': 'IEA',
    'ECO:0007268': 'IEA',
    'ECO:0007269': 'IEA',
    'ECO:0007270': 'IEA',
    'ECO:0007271': 'IEA',
    'ECO:0007272': 'IEA',
    'ECO:0007273': 'IEA',
    'ECO:0007274': 'IEA',
    'ECO:0007275': 'IEA',
    'ECO:0007276': 'IEA',
    'ECO:0007277': 'IEA',
    'ECO:0007278': 'IEA',
    'ECO:0007279': 'IEA',
    'ECO:0007280': 'IEA',
    'ECO:0007281': 'IEA',
    'ECO:0007282': 'IEA',
    'ECO:0007283': 'IEA',
    'ECO:0007284': 'IEA',
    'ECO:0007285': 'IEA',
    'ECO:0007286': 'IEA',
    'ECO:0007288': 'IEA',
    'ECO:0007289': 'IEA',
    'ECO:0007290': 'IEA',
    'ECO:0007291': 'IEA',
    'ECO:0007292': 'IEA',
    'ECO:0007295': 'IEA',
    'ECO:0007296': 'IEA',
    'ECO:0007297': 'IEA',
    'ECO:0007298': 'IEA',
    'ECO:0007299': 'IEA',
    'ECO:0007300': 'IEA',
    'ECO:0007301': 'IEA',
    'ECO:0007302': 'IEA',
    'ECO:0007303': 'IEA',
    'ECO:0007304': 'IEA',
    'ECO:0007305': 'IEA',
    'ECO:0007306': 'IEA',
    'ECO:0007307': 'IEA',
    'ECO:0007309': 'IEA',
    'ECO:0007310': 'IEA',
    'ECO:0007311': 'IEA',
    'ECO:0007312': 'IEA',
    'ECO:0007313': 'IEA',
    'ECO:0007314': 'IEA',
    'ECO:0007315': 'IEA',
    'ECO:0007316': 'IEA',
    'ECO:0007317': 'IEA',
    'ECO:0007318': 'IEA',
    'ECO:0007319': 'IEA',
    'ECO:0007320': 'IEA',
    'ECO:0007321': 'IEA',
    'ECO:0007322': 'IEA',
    'ECO:0007323': 'IEA',
    'ECO:0007324': 'IEA',
    'ECO:0007325': 'IEA',
    'ECO:0007326': 'IEA',
    'ECO:0007327': 'IEA',
    'ECO:0007328': 'IEA',
    'ECO:0007329': 'IEA',
    'ECO:0007330': 'IEA',
    'ECO:0007331': 'IEA',
    'ECO:0007332': 'IEA',
    'ECO:0007333': 'IEA',
    'ECO:0007334': 'IEA',
    'ECO:0007335': 'IEA',
    'ECO:0007336': 'IEA',
    'ECO:0007337': 'IEA',
    'ECO:0007338': 'IEA',
    'ECO:0007339': 'IEA',
    'ECO:0007340': 'IEA',
    'ECO:0007341': 'IEA',
    'ECO:0007342': 'IEA',
    'ECO:0007343': 'IEA',
    'ECO:0007344': 'IEA',
    'ECO:0007345': 'IEA',
    'ECO:0007346': 'IEA',
    'ECO:0007347': 'IEA',
    'ECO:0007348': 'IEA',
    'ECO:0007349': 'IEA',
    'ECO:0007350': 'IEA',
    'ECO:0007351': 'IEA',
    'ECO:0007352': 'IEA',
    'ECO:0007353': 'IEA',
    'ECO:0007354': 'IEA',
    'ECO:0007355': 'IEA',
    'ECO:0007356': 'IEA',
    'ECO:0007357': 'IEA',
    'ECO:0007358': 'IEA',
    'ECO:0007359': 'IEA',
    'ECO:0007360': 'IEA',
    'ECO:0007361': 'IEA',
    'ECO:0007362': 'IEA',
    'ECO:0007363': 'IEA',
    'ECO:0007364': 'IEA',
    'ECO:0007365': 'IEA',
    'ECO:0007366': 'IEA',
    'ECO:0007367': 'IEA',
    'ECO:0007368': 'IEA',
    'ECO:0007369': 'IEA',
    'ECO:0007370': 'IEA',
    'ECO:0007371': 'IEA',
    'ECO:0007372': 'IEA',
    'ECO:0007373': 'IEA',
    'ECO:0007374': 'IEA',
    'ECO:0007375': 'IEA',
    'ECO:0007376': 'IEA',
    'ECO:0007377': 'IEA',
    'ECO:0007378': 'IEA',
    'ECO:0007379': 'IEA',
    'ECO:0007380': 'IEA',
    'ECO:0007381': 'IEA',
    'ECO:0007382': 'IEA',
    'ECO:0007383': 'IEA',
    'ECO:0007384': 'IEA',
    'ECO:0007385': 'IEA',
    'ECO:0007386': 'IEA',
    'ECO:0007387': 'IEA',
    'ECO:0007388': 'IEA',
    'ECO:0007389': 'IEA',
    'ECO:0007390': 'IEA',
    'ECO:0007391': 'IEA',
    'ECO:0007392': 'IEA',
    'ECO:0007393': 'IEA',
    'ECO:0007394': 'IEA',
    'ECO:0007395': 'IEA',
    'ECO:0007396': 'IEA',
    'ECO:0007397': 'IEA',
    'ECO:0007398': 'IEA',
    'ECO:0007399': 'IEA',
    'ECO:0007400': 'IEA',
    'ECO:0007401': 'IEA',
    'ECO:0007402': 'IEA',
    'ECO:0007403': 'IEA',
    'ECO:0007404': 'IEA',
    'ECO:0007405': 'IEA',
    'ECO:0007406': 'IEA',
    'ECO:0007407': 'IEA',
    'ECO:0007408': 'IEA',
    'ECO:0007409': 'IEA',
    'ECO:0007410': 'IEA',
    'ECO:0007411': 'IEA',
    'ECO:0007412': 'IEA',
    'ECO:0007413': 'IEA',
    'ECO:0007414': 'IEA',
    'ECO:0007415': 'IEA',
    'ECO:0007416': 'IEA',
    'ECO:0007417': 'IEA',
    'ECO:0007418': 'IEA',
    'ECO:0007419': 'IEA',
    'ECO:0007420': 'IEA',
    'ECO:0007421': 'IEA',
    'ECO:0007422': 'IEA',
    'ECO:0007423': 'IEA',
    'ECO:0007424': 'IEA',
    'ECO:0007425': 'IEA',
    'ECO:0007427': 'IEA',
    'ECO:0007428': 'IEA',
    'ECO:0007429': 'IEA',
    'ECO:0007430': 'IEA',
    'ECO:0007431': 'IEA',
    'ECO:0007432': 'IEA',
    'ECO:0007433': 'IEA',
    'ECO:0007434': 'IEA',
    'ECO:0007435': 'IEA',
    'ECO:0007436': 'IEA',
    'ECO:0007437': 'IEA',
    'ECO:0007438': 'IEA',
    'ECO:0007439': 'IEA',
    'ECO:0007440': 'IEA',
    'ECO:0007441': 'IEA',
    'ECO:0007442': 'IEA',
    'ECO:0007443': 'IEA',
    'ECO:0007444': 'IEA',
    'ECO:0007445': 'IEA',
    'ECO:0007446': 'IEA',
    'ECO:0007447': 'IEA',
    'ECO:0007448': 'IEA',
    'ECO:0007449': 'IEA',
    'ECO:0007450': 'IEA',
    'ECO:0007451': 'IEA',
    'ECO:0007452': 'IEA',
    'ECO:0007453': 'IEA',
    'ECO:0007454': 'IEA',
    'ECO:0007455': 'IEA',
    'ECO:0007456': 'IEA',
    'ECO:0007457': 'IEA',
    'ECO:0007458': 'IEA',
    'ECO:0007459': 'IEA',
    'ECO:0007460': 'IEA',
    'ECO:0007461': 'IEA',
    'ECO:0007462': 'IEA',
    'ECO:0007463': 'IEA',
    'ECO:0007464': 'IEA',
    'ECO:0007465': 'IEA',
    'ECO:0007466': 'IEA',
    'ECO:0007467': 'IEA',
    'ECO:0007468': 'IEA',
    'ECO:0007469': 'IEA',
    'ECO:0007470': 'IEA',
    'ECO:0007471': 'IEA',
    'ECO:0007472': 'IEA',
    'ECO:0007473': 'IEA',
    'ECO:0007474': 'IEA',
    'ECO:0007475': 'IEA',
    'ECO:0007476': 'IEA',
    'ECO:0007477': 'IEA',
    'ECO:0007478': 'IEA',
    'ECO:0007479': 'IEA',
    'ECO:0007480': 'IEA',
    'ECO:0007481': 'IEA',
    'ECO:0007482': 'IEA',
    'ECO:0007483': 'IEA',
    'ECO:0007484': 'IEA',
    'ECO:0007485': 'IEA',
    'ECO:0007486': 'IEA',
    'ECO:0007487': 'IEA',
    'ECO:0007488': 'IEA',
    'ECO:0007489': 'IEA',
    'ECO:0007490': 'IEA',
    'ECO:0007491': 'IEA',
    'ECO:0007492': 'IEA',
    'ECO:0007493': 'IEA',
    'ECO:0007494': 'IEA',
    'ECO:0007495': 'IEA',
    'ECO:0007496': 'IEA',
    'ECO:0007497': 'IEA',
    'ECO:0007498': 'IEA',
    'ECO:0007499': 'IEA',
    'ECO:0007500': 'IEA',
    'ECO:0007501': 'IEA',
    'ECO:0007502': 'IEA',
    'ECO:0007503': 'IEA',
    'ECO:0007504': 'IEA',
    'ECO:0007505': 'IEA',
    'ECO:0007506': 'IEA',
    'ECO:0007507': 'IEA',
    'ECO:0007508': 'IEA',
    'ECO:0007509': 'IEA',
    'ECO:0007510': 'IEA',
    'ECO:0007511': 'IEA',
    'ECO:0007512': 'IEA',
    'ECO:0007513': 'IEA',
    'ECO:0007514': 'IEA',
    'ECO:0007515': 'IEA',
    'ECO:0007516': 'IEA',
    'ECO:0007517': 'IEA',
    'ECO:0007518': 'IEA',
    'ECO:0007519': 'IEA',
    'ECO:0007520': 'IEA',
    'ECO:0007521': 'IEA',
    'ECO:0007522': 'IEA',
    'ECO:0007523': 'IEA',
    'ECO:0007524': 'IEA',
    'ECO:0007525': 'IEA',
    'ECO:0007526': 'IEA',
    'ECO:0007527': 'IEA',
    'ECO:0007528': 'IEA',
    'ECO:0007529': 'IEA',
    'ECO:0007530': 'IEA',
    'ECO:0007531': 'IEA',
    'ECO:0007532': 'IEA',
    'ECO:0007533': 'IEA',
    'ECO:0007534': 'IEA',
    'ECO:0007535': 'IEA',
    'ECO:0007536': 'IEA',
    'ECO:0007537': 'IEA',
    'ECO:0007538': 'IEA',
    'ECO:0007539': 'IEA',
    'ECO:0007540': 'IEA',
    'ECO:0007541': 'IEA',
    'ECO:0007542': 'IEA',
    'ECO:0007543': 'IEA',
    'ECO:0007544': 'IEA',
    'ECO:0007545': 'IEA',
    'ECO:0007546': 'IEA',
    'ECO:0007547': 'IEA',
    'ECO:0007548': 'IEA',
    'ECO:0007549': 'IEA',
    'ECO:0007550': 'IEA',
    'ECO:0007551': 'IEA',
    'ECO:0007552': 'IEA',
    'ECO:0007553': 'IEA',
    'ECO:0007554': 'IEA',
    'ECO:0007555': 'IEA',
    'ECO:0007556': 'IEA',
    'ECO:0007557': 'IEA',
    'ECO:0007558': 'IEA',
    'ECO:0007559': 'IEA',
    'ECO:0007560': 'IEA',
    'ECO:0007561': 'IEA',
    'ECO:0007562': 'IEA',
    'ECO:0007563': 'IEA',
    'ECO:0007564': 'IEA',
    'ECO:0007565': 'IEA',
    'ECO:0007566': 'IEA',
    'ECO:0007567': 'IEA',
    'ECO:0007568': 'IEA',
    'ECO:0007569': 'IEA',
    'ECO:0007570': 'IEA',
    'ECO:0007571': 'IEA',
    'ECO:0007572': 'IEA',
    'ECO:0007573': 'IEA',
    'ECO:0007574': 'IEA',
    'ECO:0007575': 'IEA',
    'ECO:0007576': 'IEA',
    'ECO:0007577': 'IEA',
    'ECO:0007578': 'IEA',
    'ECO:0007579': 'IEA',
    'ECO:0007580': 'IEA',
    'ECO:0007581': 'IEA',
    'ECO:0007582': 'IEA',
    'ECO:0007583': 'IEA',
    'ECO:0007584': 'IEA',
    'ECO:0007585': 'IEA',
    'ECO:0007586': 'IEA',
    'ECO:0007587': 'IEA',
    'ECO:0007588': 'IEA',
    'ECO:0007589': 'IEA',
    'ECO:0007590': 'IEA',
    'ECO:0007591': 'IEA',
    'ECO:0007592': 'IEA',
    'ECO:0007593': 'IEA',
    'ECO:0007594': 'IEA',
    'ECO:0007595': 'IEA',
    'ECO:0007596': 'IEA',
    'ECO:0007597': 'IEA',
    'ECO:0007598': 'IEA',
    'ECO:0007599': 'IEA',
    'ECO:0007600': 'IEA',
    'ECO:0007601': 'IEA',
    'ECO:0007602': 'IEA',
    'ECO:0007603': 'IEA',
    'ECO:0007604': 'IEA',
    'ECO:0007605': 'IEA',
    'ECO:0007606': 'IEA',
    'ECO:0007607': 'IEA',
    'ECO:0007608': 'IEA',
    'ECO:0007609': 'IEA',
    'ECO:0007610': 'IEA',
    'ECO:0007611': 'IEA',
    'ECO:0007612': 'IEA',
    'ECO:0007613': 'IEA',
    'ECO:0007614': 'IEA',
    'ECO:0007615': 'IEA',
    'ECO:0007616': 'IEA',
    'ECO:0007617': 'IEA',
    'ECO:0007618': 'IEA',
    'ECO:0007619': 'IEA',
    'ECO:0007620': 'IEA',
    'ECO:0007621': 'IEA',
    'ECO:0007622': 'IEA',
    'ECO:0007623': 'IEA',
    'ECO:0007624': 'IEA',
    'ECO:0007625': 'IEA',
    'ECO:0007626': 'IEA',
    'ECO:0007627': 'IEA',
    'ECO:0007628': 'IEA',
    'ECO:0007629': 'IEA',
    'ECO:0007630': 'IEA',
    'ECO:0007632': 'IDA',
    'ECO:0007633': 'IEA',
    'ECO:0007634': 'EXP',
    'ECO:0007635': 'IEA',
    'ECO:0007650': 'IEA',
    'ECO:0007652': 'RCA',
    'ECO:0007653': 'IEA',
    'ECO:0007657': 'IEA',
    'ECO:0007659': 'RCA',
    'ECO:0007660': 'IEA',
    'ECO:0007664': 'IEA',
    'ECO:0007666': 'RCA',
    'ECO:0007667': 'IEA',
    'ECO:0007669': 'IEA',
    'ECO:0007676': 'IEA',
    'ECO:0007679': 'IEA',
    'ECO:0007680': 'EXP',
    'ECO:0007681': 'IEA',
    'ECO:0007682': 'IEP',
    'ECO:0007684': 'IDA',
    'ECO:0007685': 'IDA',
    'ECO:0007686': 'IDA',
    'ECO:0007687': 'IDA',
    'ECO:0007688': 'IDA',
    'ECO:0007689': 'IDA',
    'ECO:0007690': 'IDA',
    'ECO:0007691': 'IDA',
    'ECO:0007692': 'IDA',
    'ECO:0007693': 'IDA',
    'ECO:0007694': 'IDA',
    'ECO:0007695': 'IDA',
    'ECO:0007696': 'IDA',
    'ECO:0007697': 'IDA',
    'ECO:0007698': 'IDA',
    'ECO:0007699': 'IDA',
    'ECO:0007700': 'IDA',
    'ECO:0007701': 'IDA',
    'ECO:0007702': 'IDA',
    'ECO:0007703': 'IDA',
    'ECO:0007704': 'IDA',
    'ECO:0007706': 'IPI',
    'ECO:0007707': 'IDA',
    'ECO:0007708': 'IDA',
    'ECO:0007709': 'IDA',
    'ECO:0007710': 'IDA',
    'ECO:0007711': 'IDA',
    'ECO:0007712': 'IDA',
    'ECO:0007713': 'IDA',
    'ECO:0007714': 'IDA',
    'ECO:0007715': 'IDA',
    'ECO:0007716': 'IDA',
    'ECO:0007717': 'IDA',
    'ECO:0007718': 'IDA',
    'ECO:0007719': 'IDA',
    'ECO:0007720': 'IDA',
    'ECO:0007721': 'IDA',
    'ECO:0007722': 'IDA',
    'ECO:0007723': 'IDA',
    'ECO:0007724': 'IDA',
    'ECO:0007725': 'IDA',
    'ECO:0007726': 'IDA',
    'ECO:0007727': 'IDA',
    'ECO:0007728': 'EXP',
    'ECO:0007730': 'EXP',
    'ECO:0007731': 'EXP',
    'ECO:0007732': 'EXP',
    'ECO:0007733': 'EXP',
    'ECO:0007734': 'EXP',
    'ECO:0007735': 'EXP',
    'ECO:0007736': 'EXP',
    'ECO:0007737': 'EXP',
    'ECO:0007738': 'EXP',
    'ECO:0007739': 'EXP',
    'ECO:0007740': 'EXP',
    'ECO:0007741': 'EXP',
    'ECO:0007742': 'EXP',
    'ECO:0007746': 'NAS',
    'ECO:0007747': 'EXP',
    'ECO:0007749': 'ISA',
    'ECO:0007752': 'IC',
    'ECO:0007753': 'IC',
    'ECO:0007754': 'IC',
    'ECO:0007755': 'IC',
    'ECO:0007756': 'IC',
    'ECO:0007757': 'IC',
    'ECO:0007758': 'IC',
    'ECO:0007759': 'IC',
    'ECO:0007760': 'IC',
    'ECO:0007761': 'IC',
    'ECO:0007762': 'IC',
    'ECO:0007763': 'IC',
    'ECO:0007765': 'IEA',
    'ECO:0007766': 'IEA',
    'ECO:0007767': 'IEA',
    'ECO:0007768': 'IEA',
    'ECO:0007769': 'IEA',
    'ECO:0007770': 'IEA',
    'ECO:0007771': 'IEA',
    'ECO:0007772': 'IEA',
    'ECO:0007773': 'IEA',
    'ECO:0007774': 'IEA',
    'ECO:0007775': 'IEA',
    'ECO:0007776': 'IEA',
    'ECO:0007777': 'IEA',
    'ECO:0007778': 'IEA',
    'ECO:0007779': 'IEA',
    'ECO:0007780': 'IEA',
    'ECO:0007781': 'IEA',
    'ECO:0007782': 'IEA',
    'ECO:0007783': 'IEA',
    'ECO:0007785': 'IEA',
    'ECO:0007786': 'IEA',
    'ECO:0007787': 'IEA',
    'ECO:0007788': 'IEA',
    'ECO:0007789': 'IEA',
    'ECO:0007790': 'IEA',
    'ECO:0007791': 'IEA',
    'ECO:0007792': 'IEA',
    'ECO:0007793': 'IEA',
    'ECO:0007794': 'IEA',
    'ECO:0007795': 'IEA',
    'ECO:0007796': 'IEA',
    'ECO:0007797': 'IEA',
    'ECO:0007798': 'IEA',
    'ECO:0007799': 'IEA',
    'ECO:0007800': 'IEA',
    'ECO:0007801': 'IEA',
    'ECO:0007802': 'IEA',
    'ECO:0007803': 'IEA',
    'ECO:0007804': 'IEA',
    'ECO:0007805': 'IEA',
    'ECO:0007806': 'IEA',
    'ECO:0007807': 'IEA',
    'ECO:0007808': 'IEA',
    'ECO:0007809': 'IEA',
    'ECO:0007810': 'IEA',
    'ECO:0007811': 'IEA',
    'ECO:0007812': 'IEA',
    'ECO:0007813': 'IEA',
    'ECO:0007814': 'IEA',
    'ECO:0007815': 'IEA',
    'ECO:0007816': 'IEA',
    'ECO:0007817': 'IEA',
    'ECO:0007818': 'IEA',
    'ECO:0007819': 'IEA',
    'ECO:0007820': 'IEA',
    'ECO:0007821': 'IEA',
    'ECO:0007822': 'IEA',
    'ECO:0007823': 'IEA',
    'ECO:0007824': 'IEA',
    'ECO:0007825': 'IEA',
    'ECO:0007826': 'IEA',
    'ECO:0007827': 'IEA',
    'ECO:0007828': 'IEA',
    'ECO:0007829': 'IEA',
    'ECO:0007830': 'IEA',
    'ECO:0007832': 'IEA',
    'ECO:0007833': 'IEA',
    'ECO:0007834': 'IEA',
    'ECO:0007835': 'IEA',
    'ECO:0007836': 'IEA',
    'ECO:0007837': 'IEA',
    'ECO:0007838': 'IEA',
    'ECO:0007839': 'IEA',
    'ECO:0007840': 'IEA',
    'ECO:0007841': 'IEA',
    'ECO:0007842': 'IEA',
    'ECO:0007843': 'IEA',
    'ECO:0007845': 'IEA',
    'ECO:0007846': 'IDA',
    'ECO:0007848': 'IEA',
    'ECO:0007849': 'IDA',
}
