from datetime import datetime
from pkg_resources import get_distribution, DistributionNotFound

__author__ = ("Haibao Tang", "DV Klopfenstein")
__copyright__ = "Copyright (C) 2009-{}, Haibao Tang, DV Klopfenstein".format(
    datetime.now().year
)
__email__ = "tanghaibao@gmail.com"
__license__ = "BSD"
__status__ = "Development"

try:
    VERSION = get_distribution(__name__).version
except DistributionNotFound:  # pragma: no cover
    try:
        from .version import version as VERSION  # noqa
    except ImportError:  # pragma: no cover
        raise ImportError(
            "Failed to find (autogenerated) version.py. "
            "This might be because you are installing from GitHub's tarballs, "
            "use the PyPI ones."
        )
__version__ = VERSION
