# -*- coding: utf-8 -*-

"""
direct Python Toolbox
All-in-one toolbox to encapsulate Python runtime variants
----------------------------------------------------------------------------
(C) direct Netware Group - All rights reserved
https://www.direct-netware.de/redirect?dpt;runtime

This Source Code Form is subject to the terms of the Mozilla Public License,
v. 2.0. If a copy of the MPL was not distributed with this file, You can
obtain one at http://mozilla.org/MPL/2.0/.
----------------------------------------------------------------------------
https://www.direct-netware.de/redirect?licenses;mpl2
----------------------------------------------------------------------------
v2.1.1
dpt_runtime/exceptions/operation_not_supported_exception.py
"""

# pylint: disable=bad-option-value, slots-on-old-class

from .traced_exception import TracedException

class OperationNotSupportedException(TracedException):
    """
This exception should be used if specific API calls or parameter values are
not supported in a given implementation.

:author:     direct Netware Group et al.
:copyright:  direct Netware Group - All rights reserved
:package:    dpt
:subpackage: runtime
:since:      v2.0.0
:license:    https://www.direct-netware.de/redirect?licenses;mpl2
             Mozilla Public License, v. 2.0
    """

    __slots__ = [ ]
    """
python.org: __slots__ reserves space for the declared variables and prevents
the automatic creation of __dict__ and __weakref__ for each instance.
    """

    def __init__(self, value = "Operation not supported", _exception = None):
        """
Constructor __init__(OperationNotSupportedException)

:param value: Exception message value
:param _exception: Inner exception

:since: v2.0.0
        """

        TracedException.__init__(self, value, _exception)
    #
#
