import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectApprovalRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The number of approvals required for this rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_approval_rule#approvals_required ProjectApprovalRule#approvals_required}
    */
    readonly approvalsRequired: number;
    /**
    * A list of group IDs whose members can approve of the merge request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_approval_rule#group_ids ProjectApprovalRule#group_ids}
    */
    readonly groupIds?: number[];
    /**
    * The name of the approval rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_approval_rule#name ProjectApprovalRule#name}
    */
    readonly name: string;
    /**
    * The name or id of the project to add the approval rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_approval_rule#project ProjectApprovalRule#project}
    */
    readonly project: string;
    /**
    * A list of protected branch IDs (not branch names) for which the rule applies.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_approval_rule#protected_branch_ids ProjectApprovalRule#protected_branch_ids}
    */
    readonly protectedBranchIds?: number[];
    /**
    * String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_approval_rule#rule_type ProjectApprovalRule#rule_type}
    */
    readonly ruleType?: string;
    /**
    * A list of specific User IDs to add to the list of approvers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_approval_rule#user_ids ProjectApprovalRule#user_ids}
    */
    readonly userIds?: number[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_approval_rule gitlab_project_approval_rule}
*/
export declare class ProjectApprovalRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_approval_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_approval_rule gitlab_project_approval_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectApprovalRuleConfig
    */
    constructor(scope: Construct, id: string, config: ProjectApprovalRuleConfig);
    private _approvalsRequired?;
    get approvalsRequired(): number;
    set approvalsRequired(value: number);
    get approvalsRequiredInput(): number | undefined;
    private _groupIds?;
    get groupIds(): number[];
    set groupIds(value: number[]);
    resetGroupIds(): void;
    get groupIdsInput(): number[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _protectedBranchIds?;
    get protectedBranchIds(): number[];
    set protectedBranchIds(value: number[]);
    resetProtectedBranchIds(): void;
    get protectedBranchIdsInput(): number[] | undefined;
    private _ruleType?;
    get ruleType(): string;
    set ruleType(value: string);
    resetRuleType(): void;
    get ruleTypeInput(): string | undefined;
    private _userIds?;
    get userIds(): number[];
    set userIds(value: number[]);
    resetUserIds(): void;
    get userIdsInput(): number[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=project-approval-rule.d.ts.map