from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

msp430 = SchLib(tool=SKIDL).add_parts(*[
        Part(name='MSP430AFE221IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='24pin TSSOP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430AFE231IPW', 'MSP430AFE251IPW'],pins=[
            Pin(num='1',name='A0.0+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A0.0-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='(AVSS)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='(AVSS)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Vref',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='(AVSS)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='(AVSS)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='20',name='URXD0/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='21',name='TMS/SVSOUT/SIMO0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TA2/SMCLK/TACLK/SVSIN/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TCK/TA2/SOMI0/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='TDI/TDO/TA1/UCLK0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XT2IN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TCLK/TDI/TA0/STE0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XT2OUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='SDCLK/TA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SD0DO/TA0/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='UTXD0/P1.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430AFE222IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='24pin TSSOP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430AFE232IPW', 'MSP430AFE252IPW'],pins=[
            Pin(num='1',name='A0.0+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A0.0-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='A1.0+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='A1.0-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Vref',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='(AVSS)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='(AVSS)',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='20',name='URXD0/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='21',name='TMS/SVSOUT/SIMO0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TA2/SMCLK/TACLK/SVSIN/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TCK/TA2/SOMI0/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='TDI/TDO/TA1/UCLK0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XT2IN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TCLK/TDI/TA0/STE0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XT2OUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='SDCLK/TA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SD0DO/TA0/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SD1DO/UTXD0/P1.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430AFE223IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='24pin TSSOP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430AFE233IPW', 'MSP430AFE253IPW'],pins=[
            Pin(num='1',name='A0.0+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='A0.0-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='A1.0+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='A1.0-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Vref',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='A2.0+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='A2.0-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='20',name='SD2DO/URXD0/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='21',name='TMS/SVSOUT/SIMO0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TA2/SMCLK/TACLK/SVSIN/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TCK/TA2/SOMI0/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='TDI/TDO/TA1/UCLK0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XT2IN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TCLK/TDI/TA0/STE0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='XT2OUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='SDCLK/TA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='SD0DO/TA0/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SD1DO/UTXD0/P1.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F1101AIDGV',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin TVSOP, 4KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F1111AIDGV', 'MSP430F1121AIDGV'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='P2.5/Rosc',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='XIN',do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='P2.0/ACLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/INCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/CAOUT/TA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P2.3/CA0/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/CA1/TA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F1101AIDW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin SOWB, 4KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F1111AIDW', 'MSP430F1121AIDW'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='P2.5/Rosc',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='XIN',do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='P2.0/ACLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/INCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/CAOUT/TA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P2.3/CA0/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/CA1/TA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F1101AIPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin TSSOP, 4KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F1111AIPW', 'MSP430F1121AIPW'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='P2.5/Rosc',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='XIN',do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='P2.0/ACLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/INCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/CAOUT/TA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P2.3/CA0/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/CA1/TA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F1101AIRGE',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='24pin QFN, 4KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F1111AIRGE', 'MSP430F1121AIRGE'],pins=[
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='XIN',do_erc=True),
            Pin(num='5',name='~RST~/NMI',do_erc=True),
            Pin(num='6',name='P2.0/ACLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P2.1/INCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.2/CAOUT/TA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.3/CA0/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P2.4/CA1/TA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TEST',do_erc=True),
            Pin(num='13',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P2.5/Rosc',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F1122IDW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin SOWB, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F1132IDW'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='P2.5/Rosc',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='XIN',do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='P2.0/A0/ACLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/A1/INCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/A2/TA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P2.3/A3/VREF-/VeREF-/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/A4/VREF+/VeREF+/TA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F1122IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin TSSOP, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F1132IPW'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='P2.5/Rosc',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='XIN',do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='P2.0/A0/ACLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/A1/INCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/A2/TA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P2.3/A3/VREF-/VeREF-/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/A4/VREF+/VeREF+/TA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F1122IRHB',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='32pin QFN, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F1132IRHB'],pins=[
            Pin(num='1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='XIN',do_erc=True),
            Pin(num='5',name='~RST~/NMI',do_erc=True),
            Pin(num='6',name='P2.0/A0/ACLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P2.1/A1/INCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.2/A2/TA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='P2.5/Rosc',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P2.3/A3/VREF-/VeREF-/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.4/A4/VREF+/VeREF+/TA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TEST',do_erc=True)]),
        Part(name='MSP430F1222IDW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='28pin SOWB, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F1232IDW'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='XIN',do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='INCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA2/VeREF+/VREF+/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.0/A5/STE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.1/SIMO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/SOMI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/UCLK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P3.4/UTXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P3.5/URXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P3.6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P3.7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA1/VeREF-/VREF-/A3/P2.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F1222IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='28pin TSSOP, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F1232IPW'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='XIN',do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='INCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA2/VeREF+/VREF+/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.0/A5/STE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.1/SIMO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/SOMI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/UCLK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P3.4/UTXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P3.5/URXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P3.6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P3.7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA1/VeREF-/VREF-/A3/P2.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F1222IRHB',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='32pin QFN, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F1232IRHB'],pins=[
            Pin(num='1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='XIN',do_erc=True),
            Pin(num='5',name='~RST~/NMI',do_erc=True),
            Pin(num='6',name='ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='INCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/A5/STE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P3.1/SIMO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P3.2/SOMI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.3/UCLK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.4/UTXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.5/URXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P3.6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P3.7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA1/VeREF-/VREF-/A3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA2/VeREF+/VREF+/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TEST',do_erc=True)]),
        Part(name='MSP430F122IDW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='28pin SOWB, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F123IDW'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='XIN',do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='ACLK/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='INCLK/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA0/CAOUT/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA2/CA1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.0/STE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.1/SIMO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/SOMI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/UCLK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P3.4/UTXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P3.5/URXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA1/CA0/P2.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F122IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='28pin TSSOP, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F123IPW'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='XIN',do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='ACLK/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='INCLK/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA0/CAOUT/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA2/CA1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.0/STE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.1/SIMO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/SOMI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/UCLK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P3.4/UTXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P3.5/URXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA1/CA0/P2.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F122IRHB',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='32pin QFN, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F123IRHB'],pins=[
            Pin(num='1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='XIN',do_erc=True),
            Pin(num='5',name='~RST~/NMI',do_erc=True),
            Pin(num='6',name='ACLK/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='INCLK/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA0/CAOUT/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/STE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P3.1/SIMO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P3.2/SOMI0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.3/UCLK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.4/UTXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.5/URXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA1/CA0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA2/CA1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TEST',do_erc=True)]),
        Part(name='MSP430F2001IN',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='14pin PDIP, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2011IN'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CA0/TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CA1/TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='CA2/TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CA3/CAOUT/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CA4/SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CA5/TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='CA6/TA1/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='CA7/CAOUT/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2001IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='14pin TSSOP, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2011IPW'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CA0/TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CA1/TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='CA2/TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CA3/CAOUT/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CA4/SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CA5/TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='CA6/TA1/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='CA7/CAOUT/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2001IRSA',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='16pin QFN, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2011IRSA'],pins=[
            Pin(num='1',name='CA0/TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='CA1/TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CA2/TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='CA3/CAOUT/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CA4/TCK/SMCLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CA5/TMS/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CA6/TDI/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='CA7/TDO/TDI/CAOUT/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='TEST/SBWTCK',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2002IN',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='14pin PDIP, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2012IN'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='A0/TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A1/TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='A2/TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/A3/VREF-/VeREF-/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SMCLK/A4/VREF+/VeREF+/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA0/A5/SCLK/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA1/A6/SDO/SCL/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='A7/SDI/SDA/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2002IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='14pin TSSOP, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2012IPW'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='A0/TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A1/TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='A2/TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/A3/VREF-/VeREF-/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SMCLK/A4/VREF+/VeREF+/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA0/A5/SCLK/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA1/A6/SDO/SCL/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='A7/SDI/SDA/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2002IRSA',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='16pin QFN, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2012IRSA'],pins=[
            Pin(num='1',name='A0/TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='A1/TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A2/TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='ADC10CLK/A3/VREF-/VeREF-/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SMCLK/A4/VREF+/VeREF+/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TA0/A5/SCLK/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA1/A6/SDO/SCL/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='A7/SDI/SDA/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2003IN',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='14pin PDIP, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2013IN'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TACLK/ACLK/A0+/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0/A0-/A4+/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA1/A1+/A4-/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VREF/A1-/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SMCLK/A2+/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA0/A2-/SCLK/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA1/A3+/SDO/SCL/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='A3-/SDI/SDA/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2003IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='14pin TSSOP, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2013IPW'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TACLK/ACLK/A0+/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0/A0-/A4+/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA1/A1+/A4-/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VREF/A1-/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SMCLK/A2+/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA0/A2-/SCLK/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA1/A3+/SDO/SCL/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='A3-/SDI/SDA/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2003IRSA',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='16pin QFN, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2013IRSA'],pins=[
            Pin(num='1',name='TACLK/ACLK/A0+/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0/A0-/A4+/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA1/A1+/A4-/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VREF/A1-/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SMCLK/A2+/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TA0/A2-/SCLK/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA1/A3+/SDO/SCL/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='A3-/SDI/SDA/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2101IDGV',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin TVSOP, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2111IDGV', 'MSP430F2121IDGV', 'MSP430F2131IDGV'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='P2.5/CA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='P2.7/XOUT/CA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P2.6/XIN/CA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='P2.0/ACLK/CA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/INCLK/CA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/CAOUT/TA0/CA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA2/TDI/TDO/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P2.3/TA1/CA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA2/CA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA1/TCLK/TDI/P1.6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F2101IDW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin SOWB, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2111IDW', 'MSP430F2121IDW', 'MSP430F2131IDW'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='P2.5/CA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='P2.7/XOUT/CA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P2.6/XIN/CA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='P2.0/ACLK/CA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/INCLK/CA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/CAOUT/TA0/CA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA2/TDI/TDO/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P2.3/TA1/CA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA2/CA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA1/TCLK/TDI/P1.6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F2101IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin TSSOP, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2111IPW', 'MSP430F2121IPW', 'MSP430F2131IPW'],pins=[
            Pin(num='1',name='TEST',do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='P2.5/CA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='P2.7/XOUT/CA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P2.6/XIN/CA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~RST~/NMI',do_erc=True),
            Pin(num='8',name='P2.0/ACLK/CA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/INCLK/CA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/CAOUT/TA0/CA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA2/TDI/TDO/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P2.3/TA1/CA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA2/CA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA1/TCLK/TDI/P1.6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F2101IRGE',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='24pin QFN, 8KB + 256B Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2111IRGE', 'MSP430F2121IRGE', 'MSP430F2131IRGE'],pins=[
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='P2.7/XOUT/CA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P2.6/XIN/CA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='~RST~/NMI',do_erc=True),
            Pin(num='6',name='P2.0/ACLK/CA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P2.1/INCLK/CA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.2/CAOUT/TA0/CA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.3/TA1/CA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA1/TCLK/TDI/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P2.4/TA2/CA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TA2/TDI/TDO/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TEST',do_erc=True),
            Pin(num='13',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P2.5/CA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F2112IPW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='28pin TSSOP, 8KB + 256B Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2122IPW', 'MSP430F2132IPW'],pins=[
            Pin(num='1',name='SBWTCK/TEST',do_erc=True),
            Pin(num='2',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CA5/Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='CA7/XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CA6/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~RST~/NMI/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='CA2/ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='CA3/TAINCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='CAOUT/CA4/TA0.0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='CA1/TA0.2/A4/VREF+/VeREF+/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.0/UCB0STE/UCA0CLK/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='CAOUT/TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA1.0/TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TA0.0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P3.6/A6/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA0.1/TDI/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P3.7/A7/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TA0.2/TDI/TDO/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='CA0/TA0.1/A3/VREF-/VeREF-/P2.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F2112IRHB',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='32pin QFN, 8KB + 256B Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2122IRHB', 'MSP430F2132IRHB'],pins=[
            Pin(num='1',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CA7/XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CA6/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='~RST~/NMI/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CA2/ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CA3/TAINCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='CAOUT/CA4/TA0.0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/UCB0STE/UCA0CLK/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='CAOUT/TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA1.0/TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='CA5/Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P3.6/A6/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P3.7/A7/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TA0.0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA0.1/TDI/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='CA0/TA0.1/A3/VREF-/VeREF-/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TA0.2/TDI/TDO/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='CA1/TA0.2/A4/VREF+/VeREF+/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='SBWTCK/TEST',do_erc=True)]),
        Part(name='MSP430F2112IRTV',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='32pin QFN, 8KB + 256B Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2122IRTV', 'MSP430F2132IRTV'],pins=[
            Pin(num='1',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CA7/XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CA6/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='~RST~/NMI/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CA2/ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CA3/TAINCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='CAOUT/CA4/TA0.0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/UCB0STE/UCA0CLK/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='CAOUT/TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA1.0/TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='CA5/Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P3.6/A6/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P3.7/A7/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TA0.0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA0.1/TDI/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='CA0/TA0.1/A3/VREF-/VeREF-/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TA0.2/TDI/TDO/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='CA1/TA0.2/A4/VREF+/VeREF+/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='SBWTCK/TEST',do_erc=True)]),
        Part(name='MSP430F2232IDA',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='38pin TSSOP, 32KB + 256B Flash Memory, 1KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2252IDA', 'MSP430F2272IDA'],pins=[
            Pin(num='1',name='SBWTCK/TEST',do_erc=True),
            Pin(num='2',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~RST~/NMI/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TAINCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P4.3/TB0/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA2/A4/VREF+/VeREF+/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.0/UCB0STE/UCA0CLK/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P4.4/TB1/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P4.5/TB2/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P4.6/TBOUTH/A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P3.6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TA1/TDI/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P3.7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='TA2/TDI/TDO/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TA1/A3/VREF-/VeREF-/P2.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F2232IRHA',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='40pin QFN, 32KB + 256B Flash Memory, 1KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2252IRHA', 'MSP430F2272IRHA'],pins=[
            Pin(num='1',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='6',name='ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TAINCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/UCB0STE/UCA0CLK/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P4.5/TB2/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ROSC/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P4.6/TBOUTH/A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P3.6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TA1/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='P3.7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='TA2/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA1/VREF-/VeREF-/A3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TEST/SBWTCK',do_erc=True),
            Pin(num='18',name='P4.3/TB0/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TA2/VREF+/VeREF+/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P4.4/TB1/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='P1.0/TACLK/ADC10CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2232IYFF',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='49ball BGA, 32KB + 256B Flash Memory, 1KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2252IYFF', 'MSP430F2272IYFF'],pins=[
            Pin(num='A1',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='D1',name='SBWTCK/TEST',do_erc=True),
            Pin(num='E1',name='TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='ROSC/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='TA2/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B3',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='C3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='E3',name='TA1/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='TA1/VREF-/VeREF-/A3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='TA2/VREF+/VeREF+/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='TAINCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F4',name='P3.6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='P3.7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='TA0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='P3.0/UCB0STE/UCA0CLK/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='P4.5/TB2/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C7',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='D7',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='P4.3/TB0/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='P4.4/TB1/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='P4.6/TBOUTH/A15',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F2234IDA',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='38pin TSSOP, 32KB + 256B Flash Memory, 1KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2254IDA', 'MSP430F2274IDA'],pins=[
            Pin(num='1',name='SBWTCK/TEST',do_erc=True),
            Pin(num='2',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~RST~/NMI/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='ACLK/A0/OA0I0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TAINCLK/SMCLK/A1/OA0O/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA0/A2/OA0I1/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P4.3/TB0/A12/OA0O',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA2/A4/VREF+/VeREF+/OA1I0/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.0/UCB0STE/UCA0CLK/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P4.4/TB1/A13/OA1O',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P4.5/TB2/A14/OA0I3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P4.6/TBOUTH/A15/OA1I3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P3.6/A6/OA0I2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TA1/TDI/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P3.7/A7/OA1I2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='TA2/TDI/TDO/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TA1/A3/VREF-/VeREF-/OA1I1/OA1O/P2.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F2234IRHA',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='40pin QFN, 32KB + 256B Flash Memory, 1KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2254IRHA', 'MSP430F2274IRHA'],pins=[
            Pin(num='1',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~RST~/NMI/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ACLK/A0/OA0I0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TAINCLK/SMCLK/A1/OA0O/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA0/A2/OA0I1/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/UCB0STE/UCA0CLK/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P4.5/TB2/A14/OA0I3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P4.6/TBOUTH/A15/OA1I3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P3.6/A6/OA0I2',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TA1/TDI/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='P3.7/A7/OA1I2',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='TA2/TDI/TDO/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA1/A3/VREF-/VeREF-/OA1I1/OA1O/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P4.3/TB0/A12/OA0O',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TA2/A4/VREF+/VeREF+/OA1I0/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P4.4/TB1/A13/OA1O',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2234IYFF',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='49ball BGA, 32KB + 256B Flash Memory, 1KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2254IYFF', 'MSP430F2274IYFF'],pins=[
            Pin(num='A1',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='D1',name='SBWTCK/TEST',do_erc=True),
            Pin(num='E1',name='TA0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='ROSC/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='TA2/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B3',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='C3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='E3',name='TA1/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='TA1/VREF-/VeREF-/OA1I1/OA1O/A3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='TA2/VREF+/VeREF+/OA1I0/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='ACLK/A0/OA0I0/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='TAINCLK/SMCLK/OA0O/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F4',name='P3.6/A6/OA0I2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='P3.7/A7/OA1I2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='TA0/OA0I1/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='P3.0/UCB0STE/UCA0CLK/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='P4.5/TB2/A14/OA0I3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C7',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='D7',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='P4.3/TB0/A12/OA0O',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='P4.4/TB1/A13/OA1O',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='P4.6/TBOUTH/A15/OA1I3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F2330IRHA',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='40pin QFN, 32KB + 256B Flash Memory, 2KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2350IRHA', 'MSP430F2370IRHA'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='XIN/CA6/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='XOUT/CA7/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SMCLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P4.4/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='P4.5/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ACLK/CA2/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='P4.6/TBOUTH/ACLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TAINCLK/CA3/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0/CAOUT/CA4/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TDO/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA1/CA0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/TCLK',do_erc=True),
            Pin(num='16',name='TA2/CA1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='TMS',do_erc=True),
            Pin(num='17',name='ROSC/CA5/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TCK',do_erc=True),
            Pin(num='18',name='P3.0/UCB0STE/UCA0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='~RST~/NMI',do_erc=True),
            Pin(num='19',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='P4.3/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430F2330IYFF',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='49ball BGA, 32KB + 256B Flash Memory, 2KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F2350IYFF', 'MSP430F2370IYFF'],pins=[
            Pin(num='A1',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='TCK',do_erc=True),
            Pin(num='D1',name='TDI/TCLK',do_erc=True),
            Pin(num='E1',name='TDO/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='P4.5/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='P4.4/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='XIN/CA6/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='~RST~/NMI',do_erc=True),
            Pin(num='D2',name='TMS',do_erc=True),
            Pin(num='E2',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='P4.6/TBOUTH/ACLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='XOUT/CA7/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F3',name='P4.3/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='ACLK/CA2/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='SMCLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TA0/CAOUT/CA4/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='TA2/CA1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='P3.0/UCB0STE/UCA0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='TAINCLK/CA3/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='TA1/CA0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='ROSC/CA5/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5217IRGC',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='64pin QFN, 128KB Flash Memory, 8KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5219IRGC'],pins=[
            Pin(num='1',name='P6.0/CB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P6.4/CB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P6.5/CB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P6.6/CB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P6.7/CB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA2.1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='DVIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='P7.1/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA2.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='P7.2/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RTCCLK/DMAE0/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='P7.3/TB0.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P7.4/TB0.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='P7.5/TB0.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='~RSTDVCC~/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='BSLEN',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='~RST~/NMI',do_erc=True),
            Pin(num='17',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='TA1.2/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TA2CLK/SMCLK/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TA2.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='P7.0/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='SBWTCK/TEST',do_erc=True)]),
        Part(name='MSP430F5217IYFF',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='64ball BGA, 128KB Flash Memory, 8KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5219IYFF'],pins=[
            Pin(num='A1',name='P6.1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='P7.5/TB0.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='P7.3/TB0.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='P7.0/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='P6.2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='P6.0/CB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='BSLEN',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='P7.4/TB0.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='P7.1/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='P6.7/CB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='P6.5/CB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='P6.3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='~RST~/NMI',do_erc=True),
            Pin(num='F3',name='P7.2/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='P6.4/CB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='P6.6/CB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='~RSTDVCC~/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='SBWTCK/TEST',do_erc=True),
            Pin(num='F4',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='C5',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='TA1.2/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='DVIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='A6',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='A7',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='B7',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='TA2CLK/SMCLK/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='TA2.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='TA2.1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='C8',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='TA2.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='RTCCLK/DMAE0/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5227IRGC',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='64pin QFN, 128KB Flash Memory, 8KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5229IRGC'],pins=[
            Pin(num='1',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P6.6/CB6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P6.7/CB7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA2.1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='DVIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='P7.1/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA2.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='P7.2/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RTCCLK/DMAE0/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='P7.3/TB0.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P7.4/TB0.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='P7.5/TB0.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='~RSTDVCC~/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='BSLEN',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='~RST~/NMI',do_erc=True),
            Pin(num='17',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='TA1.2/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TA2CLK/SMCLK/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TA2.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='P7.0/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='SBWTCK/TEST',do_erc=True)]),
        Part(name='MSP430F5227IYFF',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='64ball BGA, 128KB Flash Memory, 8KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5229IYFF'],pins=[
            Pin(num='A1',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='P7.5/TB0.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='P7.3/TB0.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='P7.0/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='BSLEN',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='P7.4/TB0.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='P7.1/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='P6.7/CB7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='~RST~/NMI',do_erc=True),
            Pin(num='F3',name='P7.2/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='P6.6/CB6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='~RSTDVCC~/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='SBWTCK/TEST',do_erc=True),
            Pin(num='F4',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='C5',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='TA1.2/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='DVIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='A6',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='A7',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='B7',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='TA2CLK/SMCLK/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='TA2.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='TA2.1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='C8',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='TA2.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='RTCCLK/DMAE0/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5232IRGZ',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430F2534, 48pin QFN, 128KB Flash Memory, 8KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5234IRGZ'],pins=[
            Pin(num='1',name='P6.3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.4/CB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.5/CB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VCORE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='~RSTDVCC~/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P6.0/CB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='~RST~/NMI',do_erc=True),
            Pin(num='47',name='P6.1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P6.2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5237IRGC',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='64pin QFN, 128KB Flash Memory, 8KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5239IRGC'],pins=[
            Pin(num='1',name='P6.0/CB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P6.4/CB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P6.5/CB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P6.6/CB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P6.7/CB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA2.1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='P7.1/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA2.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='P7.2/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RTCCLK/DMAE0/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='P7.3/TB0.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P7.4/TB0.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='P7.5/TB0.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='~RSTDVCC~/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='~RST~/NMI',do_erc=True),
            Pin(num='17',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='TA1.2/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='SMCLK/TA2CLK/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TA2.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='P7.0/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='SBWTCK/TEST',do_erc=True)]),
        Part(name='MSP430F5242IRGZ',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430F2544, 48pin QFN, 128KB Flash Memory, 8KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5244IRGZ'],pins=[
            Pin(num='1',name='P6.3/A3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.4/A4/CB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.5/A5/CB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VCORE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='~RSTDVCC~/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P6.0/A0/CB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='~RST~/NMI',do_erc=True),
            Pin(num='47',name='P6.1/A1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P6.2/A2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA1CLK/CBOUT/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5247IRGC',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='64pin QFN, 128KB Flash Memory, 8KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5249IRGC'],pins=[
            Pin(num='1',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P6.6/CB6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P6.7/CB7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA2.1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='P7.1/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA2.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='P7.2/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RTCCLK/DMAE0/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='P7.3/TB0.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P7.4/TB0.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='P7.5/TB0.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='~RSTDVCC~/SBWTDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='~RST~/NMI',do_erc=True),
            Pin(num='17',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='TA1.2/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='SMCLK/TA2CLK/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TA2.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='P7.0/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='SBWTCK/TEST',do_erc=True)]),
        Part(name='MSP430F5304IPT',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='48pin LQFN, 8KB Flash Memory, 6KB RAM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='P6.0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='LDOI',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='LDOO',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PM_NONE/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PM_NONE/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='19',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5304IRGZ',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='48pin QFN, 8KB Flash Memory, 6KB RAM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='P6.0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='LDOI',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='LDOO',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PM_NONE/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PM_NONE/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='19',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5308IPT',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='48pin LQFN, 32KB Flash Memory, 6KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5309IPT', 'MSP430F5310IPT'],pins=[
            Pin(num='1',name='P6.0/A0/CB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/A1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/A2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/A3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='LDOI',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='LDOO',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PM_NONE/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PM_NONE/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='19',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5308IRGC',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='64pin QFN, 32KB Flash Memory, 6KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5309IRGC', 'MSP430F5310IRGC'],pins=[
            Pin(num='1',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P6.6/CB6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P6.7/CB7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA2.1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA2.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RTCCLK/DMAE0/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='LDOI',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='LDOO',func=Pin.PWROUT,do_erc=True),
            Pin(num='64',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='15',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA1.2/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PM_NONE/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='SMCLK/TA2CLK/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PM_NONE/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TA2.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='59',name='SBWTCK/TEST',do_erc=True)]),
        Part(name='MSP430F5308IRGZ',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='48pin QFN, 32KB Flash Memory, 6KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5309IRGZ', 'MSP430F5310IRGZ'],pins=[
            Pin(num='1',name='P6.0/A0/CB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/A1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/A2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/A3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='LDOI',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='LDOO',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PM_NONE/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PM_NONE/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='19',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5308IZQE',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='80ball BGA, 32KB Flash Memory, 6KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5309IZQE', 'MSP430F5310IZQE'],pins=[
            Pin(num='A1',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P6.6/CB6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='J1',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='B2',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='P6.7/CB7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H3',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='SBWTCK/TEST',do_erc=True),
            Pin(num='B4',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='CBOUT/TA1CLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='J5',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='LDOO',func=Pin.PWROUT,do_erc=True),
            Pin(num='C6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='TA1.2/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='TA2.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='SMCLK/TA2CLK/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='LDOI',func=Pin.PWRIN,do_erc=True),
            Pin(num='C7',name='PM_NONE/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G7',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='TA2.1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C8',name='PM_NONE/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='TA2.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C9',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='F9',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='G9',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J9',name='RTCCLK/DMAE0/P2.6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5333IPZ',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='100pin VQFP, 256KB Flash Memory, 18KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5335IPZ'],pins=[
            Pin(num='1',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.6/CB6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.7/CB7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P7.4/CB8/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P7.5/CB9/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P7.6/CB10/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P7.7/CB11/A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VREF+/VeREF+/P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VREF-/VeREF-/P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P2MAP3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='TB0.0/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P8.2/UCA1TXD/UCA1SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P9.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='LDOI',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='DVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='P2MAP4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='P5.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='TA0.2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='TB0.1/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P8.3/UCA1RXD/UCA1SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='P9.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='LDOO',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='TEST/SBWTCK',do_erc=True),
            Pin(num='12',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='P2MAP5/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='P5.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TA1CLK/CBOUT/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='TB0.2/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='P8.4/UCB1CLK/UCA1STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='P9.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P2MAP6/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='P5.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TA1.0/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='TB0.3/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='73',name='P9.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='AVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P2MAP7/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TA1.1/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='TB0.4/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='P9.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='P7.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TA1.2/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='TB0.5/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='P8.5/UCB1SIMO/UCB1SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P9.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='P7.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC12CLK/DMAE0/P5.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='TA2CLK/SMCLK/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='TB0.6/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P8.6/UCB1SOMI/UCB1SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='86',name='VBAK',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='P2MAP0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='TA2.0/P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='TB0OUTH/SVMOUT/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='P8.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='VBAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P2MAP1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P5.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='TA2.1/P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P8.0/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P9.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='RTCCLK/P5.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2MAP2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='TA2.2/P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P8.1/UCB1STE/UCA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='P9.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='DVCC3',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5333IZQW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='113ball BGA, 256KB Flash Memory, 18KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5335IZQW'],pins=[
            Pin(num='A1',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='P6.6/CB6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='P7.4/CB8/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P7.7/CB11/A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC12CLK/DMAE0/P5.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='P2MAP2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='P2MAP5/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='P6.7/CB7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='P7.6/CB10/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='P2MAP1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='P2MAP4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='P2MAP6/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='P2MAP7/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='B3',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='P7.5/CB9/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='P5.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='A4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='VREF+/VeREF+/P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='VREF-/VeREF-/P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='P2MAP0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='P2MAP3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='P5.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='P5.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='DVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J5',name='P5.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='DVCC3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B6',name='TEST/SBWTCK',do_erc=True),
            Pin(num='D6',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='VBAK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='P7.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RTCCLK/P5.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='TA1.0/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='TA1CLK/CBOUT/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='TA0.2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='AVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='P7.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='VBAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='TA2CLK/SMCLK/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='TA1.2/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='TA1.1/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='LDOO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='P9.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='P9.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='P9.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='P8.6/UCB1SOMI/UCB1SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='TB0.0/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='TA2.1/P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='TA2.0/P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='LDOI',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='TB0.2/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='TA2.2/P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C11',name='P9.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='P9.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='P9.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='P8.5/UCB1SIMO/UCB1SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='P8.4/UCB1CLK/UCA1STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='P8.2/UCA1TXD/UCA1SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='P8.0/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='TB0.6/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='TB0.5/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='TB0.1/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='P9.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='P9.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='P8.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F12',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H12',name='P8.3/UCA1RXD/UCA1SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='P8.1/UCB1STE/UCA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='TB0OUTH/SVMOUT/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='TB0.4/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='TB0.3/P4.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5336IPZ',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='100pin VQFP, 256KB Flash Memory, 18KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5338IPZ'],pins=[
            Pin(num='1',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.6/CB6/A6/DAC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.7/CB7/A7/DAC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P7.4/CB8/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P7.5/CB9/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P7.6/CB10/A14/DAC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P7.7/CB11/A15/DAC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VREF+/VeREF+/P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VREF-/VeREF-/P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P2MAP3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='TB0.0/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P8.2/UCA1TXD/UCA1SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P9.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='LDOI',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='DVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='P2MAP4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='P5.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='TA0.2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='TB0.1/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P8.3/UCA1RXD/UCA1SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='P9.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='LDOO',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='TEST/SBWTCK',do_erc=True),
            Pin(num='12',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='P2MAP5/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='P5.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TA1CLK/CBOUT/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='TB0.2/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='P8.4/UCB1CLK/UCA1STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='P9.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P2MAP6/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='P5.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='TA1.0/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='TB0.3/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='73',name='P9.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='AVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='93',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P2MAP7/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TA1.1/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='TB0.4/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='P9.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='P7.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TA1.2/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='TB0.5/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='P8.5/UCB1SIMO/UCB1SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P9.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='P7.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADC12CLK/DMAE0/P5.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='TA2CLK/SMCLK/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='TB0.6/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P8.6/UCB1SOMI/UCB1SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='86',name='VBAK',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='P2MAP0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='TA2.0/P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='TB0OUTH/SVMOUT/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='P8.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='VBAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P2MAP1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P5.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='TA2.1/P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P8.0/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P9.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='RTCCLK/P5.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2MAP2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='TA2.2/P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P8.1/UCB1STE/UCA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='P9.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='DVCC3',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5336IZQW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='113ball BGA, 128KB Flash Memory, 18KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5338IZQW'],pins=[
            Pin(num='A1',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='P6.6/CB6/A6/DAC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='P7.4/CB8/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P7.7/CB11/A15/DAC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC12CLK/DMAE0/P5.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='P2MAP2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='P2MAP5/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='P6.7/CB7/A7/DAC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='P7.6/CB10/A14/DAC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='P2MAP1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='P2MAP4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='P2MAP6/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='P2MAP7/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='B3',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='P7.5/CB9/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='P5.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='A4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='VREF+/VeREF+/P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='VREF-/VeREF-/P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='P2MAP0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='P2MAP3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='P5.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='P5.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='DVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J5',name='P5.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='DVCC3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B6',name='TEST/SBWTCK',do_erc=True),
            Pin(num='D6',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='VBAK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='P7.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RTCCLK/P5.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='TA1.0/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='TA1CLK/CBOUT/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='TA0.2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='AVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='P7.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='VBAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='TA2CLK/SMCLK/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='TA1.2/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='TA1.1/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='LDOO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='P9.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='P9.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='P9.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='P8.6/UCB1SOMI/UCB1SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='TB0.0/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='TA2.1/P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='TA2.0/P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='LDOI',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='TB0.2/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='TA2.2/P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C11',name='P9.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='P9.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='P9.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='P8.5/UCB1SIMO/UCB1SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='P8.4/UCB1CLK/UCA1STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='P8.2/UCA1TXD/UCA1SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='P8.0/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='TB0.6/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='TB0.5/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='TB0.1/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='P9.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='P9.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='P8.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F12',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H12',name='P8.3/UCA1RXD/UCA1SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='P8.1/UCB1STE/UCA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='TB0OUTH/SVMOUT/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='TB0.4/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='TB0.3/P4.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5340IRGZ',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430F5340, 48pin QFN, 128KB Flash Memory, 10KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5341IRGZ', 'MSP430F5342IRGZ'],pins=[
            Pin(num='1',name='P6.3/A3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.4/A4/CB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.5/A5/CB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P5.0/A8/VREF+/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5.1/A9/VREF-/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='VCORE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PM_NONE/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PM_NONE/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P5.7/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P6.1/A1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='DVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='P6.2/A2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='TA1CLK/CBOUT/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5358IZQW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='113ball BGA, 512KB Flash Memory, 66KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5359IZQW'],pins=[
            Pin(num='A1',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='P6.6/CB6/A6/DAC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='P7.4/CB8/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P7.7/CB11/A15/DAC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='P5.6/ADC12CLK/DMAE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='P2.2/P2MAP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='P2.5/P2MAP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='P6.7/CB7/A7/DAC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='P7.6/CB10/A14/DAC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='P2.1/P2MAP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='P2.4/P2MAP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='P2.6/P2MAP6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='P2.7/P2MAP7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='B3',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='P7.5/CB9/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='P5.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='A4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='P5.0/VREF+/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='P5.1/VREF-/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='P2.0/P2MAP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='P2.3/P2MAP3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='P5.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='P5.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='DVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J5',name='P5.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='P1.0/TA0CLK/ACLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='P1.1/TA0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='DVCC3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B6',name='TEST/SBWTCK',do_erc=True),
            Pin(num='D6',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='P1.3/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='P1.2/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='P1.5/TA0.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='P1.4/TA0.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='VBAK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='P7.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='P5.7/RTCCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='P3.1/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='P1.6/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='P3.0/TA1CLK/CBOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='P1.7/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='AVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='P7.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='VBAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='P3.4/TA2CLK/SMCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='P3.3/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='P3.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='LDOO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='P9.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='P9.4/UCB2CLK/UCA2STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='P9.1/UCB2STE/UCA2CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='P8.6/UCB1SOMI/UCB1SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='P4.0/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='P3.6/TA2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='P3.5/TA2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='LDOI',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='P4.2/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='P3.7/TA2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='PU.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C11',name='P9.6/UCB2SOMI/UCB2SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='P9.3/UCA2RXD/UCA2SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='P9.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='P8.5/UCB1SIMO/UCB1SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='P8.4/UCB1CLK/UCA1STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='P8.2/UCA1TXD/UCA1SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='P8.0/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='P4.6/TB0.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='P4.5/TB0.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='P4.1/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='PU.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='P9.5/UCB2SIMO/UCB2SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='P9.2/UCA2TXD/UCA2SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='P8.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F12',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H12',name='P8.3/UCA1RXD/UCA1SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='P8.1/UCB1STE/UCA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='P4.7/TB0OUTH/SVMOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='P4.4/TB0.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='P4.3/TB0.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5500IRGZ',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='48pin QFN, 32KB Flash Memory, 4 + 2KB SRAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5501IRGZ', 'MSP430F5502IRGZ', 'MSP430F5503IRGZ'],pins=[
            Pin(num='1',name='P6.0/CB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5.0/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P5.1/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='TA1CLK/CBOUT/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PU.1/DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VBUS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VUSB',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='VCORE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='V18',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='PU.0/DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='19',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PUR',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5504IRGZ',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='48pin QFN, 32KB Flash Memory, 4 + 2KB SRAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5505IRGZ', 'MSP430F5506IRGZ', 'MSP430F5507IRGZ'],pins=[
            Pin(num='1',name='P6.0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='TA1CLK/CBOUT/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PU.1/DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VBUS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VUSB',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='VCORE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='V18',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='PU.0/DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='19',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PUR',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5508IRGZ',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='48pin QFN, 32KB Flash Memory, 4 + 2KB SRAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5509IRGZ', 'MSP430F5510IRGZ'],pins=[
            Pin(num='1',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5.0/A8/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P5.1/A9/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='TA1CLK/CBOUT/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PU.1/DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VBUS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VUSB',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='VCORE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='V18',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='PU.0/DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='19',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PUR',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5524IYFF',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='64ball BGA, 128KB Flash Memory, 8 + 2KB SRAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5526IYFF', 'MSP430F5528IYFF'],pins=[
            Pin(num='A1',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P5.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='P5.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='VUSB',func=Pin.PWROUT,do_erc=True),
            Pin(num='G1',name='PU.1/DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='PU.0/DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='P6.6/CB6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='E2',name='V18',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='F2',name='VBUS',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='PUR',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='A3',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='B3',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='SBWTCK/TEST',do_erc=True),
            Pin(num='F3',name='P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='PM_UCA1RXD/PM_UCA1SOMI/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='PM_UCA1TXD/PM_UCA1SIMO/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='B4',name='P5.0/A8/VREF+/VeREF+',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='PM_UCB1CLK/PM_UCA1STE/P4.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='PM_UCB1SOMI/PM_UCB1SCL/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='PM_UCB1SIMO/PM_UCB1SDA/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='P5.4/XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='P5.1/A9/VREF-/VeREF-',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='P6.7/CB7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='E5',name='TA1.1/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='PM_UCB1STE/PM_UCA1CLK/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='UCA0RXD/UCA0SOMI/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='A6',name='P5.5/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='TA2.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='RTCCLK/DMAE0/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='UCA0TXD/UCA0SIMO/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='A7',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='B7',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='TA1CLK/CBOUT/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='TA2CLK/SMCLK/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='TA2.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='UCB0CLK/UCA0STE/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='UCB0SOMI/UCB0SCL/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='TA1.0/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='TA1.2/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='TA2.1/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='UCB0SIMO/UCB0SDA/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H8',name='UCB0STE/UCA0CLK/P2.7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5630IZQW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='113ball BGA, 256KB Flash Memory, 16 + 2KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5631IZQW', 'MSP430F5632IZQW'],pins=[
            Pin(num='A1',name='P6.4/CB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='P6.6/CB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='P7.4/CB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P7.7/CB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='DMAE0/P5.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='P2MAP2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='P2MAP5/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='P6.2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='P6.5/CB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='P6.7/CB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='P7.6/CB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='P2MAP1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='P2MAP4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='P2MAP6/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='P2MAP7/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='B3',name='P6.1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='P7.5/CB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='P5.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='A4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='P6.0/CB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='VREF+/VeREF+/P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='VREF-/VeREF-/P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='P2MAP0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='P2MAP3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='P5.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='P5.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='DVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='P6.3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J5',name='P5.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='DVCC3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B6',name='SBWTCK/TEST',do_erc=True),
            Pin(num='D6',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='VBAK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='P7.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RTCCLK/P5.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='TA1.0/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='TA1CLK/CBOUT/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='TA0.2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='AVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='P7.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='VBAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='TA2CLK/SMCLK/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='TA1.2/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='TA1.1/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='V18',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='D9',name='P9.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='P9.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='P9.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='P8.6/UCB1SOMI/UCB1SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='TB0.0/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='TA2.1/P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='TA2.0/P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='VBUS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='PUR',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='TB0.2/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='TA2.2/P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='PU.1/DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C11',name='P9.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='P9.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='P9.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='P8.5/UCB1SIMO/UCB1SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='P8.4/UCB1CLK/UCA1STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='P8.2/UCA1TXD/UCA1SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='P8.0/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='TB0.6/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='TB0.5/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='TB0.1/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='PU.0/DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='P9.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='P9.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='P8.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F12',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H12',name='P8.3/UCA1RXD/UCA1SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='P8.1/UCB1STE/UCA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='TB0OUTH/SVMOUT/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='TB0.4/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='TB0.3/P4.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5633IZQW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='113ball BGA, 256KB Flash Memory, 16 + 2KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5634IZQW', 'MSP430F5635IZQW'],pins=[
            Pin(num='A1',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='P6.6/CB6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='P7.4/CB8/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P7.7/CB11/A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC12CLK/DMAE0/P5.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='P2MAP2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='P2MAP5/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='P6.7/CB7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='P7.6/CB10/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='P2MAP1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='P2MAP4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='P2MAP6/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='P2MAP7/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='B3',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='P7.5/CB9/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='P5.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='A4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='VREF+/VeREF+/P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='VREF-/VeREF-/P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='P2MAP0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='P2MAP3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='P5.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='P5.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='DVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J5',name='P5.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='DVCC3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B6',name='SBWTCK/TEST',do_erc=True),
            Pin(num='D6',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='VBAK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='P7.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RTCCLK/P5.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='TA1.0/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='TA1CLK/CBOUT/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='TA0.2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='AVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='P7.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='VBAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='TA2CLK/SMCLK/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='TA1.2/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='TA1.1/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='V18',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='D9',name='P9.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='P9.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='P9.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='P8.6/UCB1SOMI/UCB1SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='TB0.0/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='TA2.1/P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='TA2.0/P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='VBUS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='PUR',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='TB0.2/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='TA2.2/P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='PU.1/DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C11',name='P9.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='P9.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='P9.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='P8.5/UCB1SIMO/UCB1SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='P8.4/UCB1CLK/UCA1STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='P8.2/UCA1TXD/UCA1SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='P8.0/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='TB0.6/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='TB0.5/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='TB0.1/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='PU.0/DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='P9.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='P9.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='P8.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F12',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H12',name='P8.3/UCA1RXD/UCA1SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='P8.1/UCB1STE/UCA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='TB0OUTH/SVMOUT/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='TB0.4/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='TB0.3/P4.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5636IZQW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='113ball BGA, 256KB Flash Memory, 16 + 2KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5637IZQW', 'MSP430F5638IZQW'],pins=[
            Pin(num='A1',name='P6.4/CB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='P6.6/CB6/A6/DAC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='P7.4/CB8/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P7.7/CB11/A15/DAC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='XIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='ADC12CLK/DMAE0/P5.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='P2MAP2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='P2MAP5/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='P6.2/CB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='P6.5/CB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='P6.7/CB7/A7/DAC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='P7.6/CB10/A14/DAC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='P2MAP1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='P2MAP4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='P2MAP6/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='P2MAP7/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='VCORE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='B3',name='P6.1/CB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='P7.5/CB9/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='P5.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='A4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='P6.0/CB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='VREF+/VeREF+/P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='VREF-/VeREF-/P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='P2MAP0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='P2MAP3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='P5.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='P5.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='DVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='P6.3/CB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J5',name='P5.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='DVCC3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B6',name='SBWTCK/TEST',do_erc=True),
            Pin(num='D6',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='VBAK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='P7.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RTCCLK/P5.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='TA1.0/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='TA1CLK/CBOUT/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='TA0.2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='AVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='P7.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='VBAT',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='TA2CLK/SMCLK/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='TA1.2/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='TA1.1/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='VUSB',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='V18',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='D9',name='P9.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='P9.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='P9.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='P8.6/UCB1SOMI/UCB1SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='TB0.0/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='TA2.1/P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='TA2.0/P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='VBUS',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='PUR',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='TB0.2/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='TA2.2/P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='PU.1/DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C11',name='P9.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='P9.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='P9.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='P8.5/UCB1SIMO/UCB1SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='P8.4/UCB1CLK/UCA1STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='P8.2/UCA1TXD/UCA1SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='P8.0/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='TB0.6/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='TB0.5/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='TB0.1/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='PU.0/DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='P9.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='P9.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='P8.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F12',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H12',name='P8.3/UCA1RXD/UCA1SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='P8.1/UCB1STE/UCA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='TB0OUTH/SVMOUT/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='TB0.4/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='TB0.3/P4.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430F5658IZQW',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='113ball BGA, 512KB Flash Memory, 66KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430F5659IZQW'],pins=[
            Pin(num='A1',name='P6.4/A4/CB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='P6.6/A6/DAC0/CB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='P7.4/A12/CB8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='P7.7/A15/DAC1/CB11',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F1',name='XIN',do_erc=True),
            Pin(num='G1',name='XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H1',name='DMAE0/ADC12CLK/P5.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='P2MAP2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='P2MAP5/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='DVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='M1',name='DVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='P6.2/A2/CB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='P6.5/A5/CB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='P6.7/A7/DAC1/CB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='P7.6/A14/DAC0/CB10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='AVCC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F2',name='AVSS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='AVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='P2MAP1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='P2MAP4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='P2MAP6/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='P2MAP7/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='A3',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='B3',name='P6.1/A1/CB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='P7.5/A13/CB9',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='P5.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='A4',name='PJ.1/TDI/TCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='P6.0/A0/CB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='VREF+/VeREF+/P5.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='VREF-/VeREF-/P5.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='P2MAP0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='P2MAP3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='P5.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='P5.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='DVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='PJ.0/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='P6.3/A3/CB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J5',name='P5.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L5',name='ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='DVCC3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B6',name='TEST/SBWTCK',do_erc=True),
            Pin(num='D6',name='PJ.3/TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='TA0.4/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='TA0.3/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='VBAK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B7',name='P7.3/XT2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='RTCCLK/P5.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='PJ.2/TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='TA1.0/P3.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='CBOUT/TA1CLK/P3.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='TA0.2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='AVSS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='P7.2/XT2IN',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='VBAT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='E8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='SMCLK/TA2CLK/P3.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L8',name='TA1.2/P3.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='TA1.1/P3.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='VUSB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='D9',name='P9.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='P9.4/UCB2CLK/UCA2STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='F9',name='P9.1/UCB2STE/UCA2CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='P8.6/UCB1SOMI/UCB1SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='TB0.0/P4.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='TA2.1/P3.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M9',name='TA2.0/P3.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='VBUS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='B10',name='PUR',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='TB0.2/P4.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='TA2.2/P3.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='PU.1/DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C11',name='P9.6/UCB2SOMI/UCB2SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='P9.3/UCA2RXD/UCA2SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='P9.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='P8.5/UCB1SIMO/UCB1SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='P8.4/UCB1CLK/UCA1STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='P8.2/UCA1TXD/UCA1SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='J11',name='P8.0/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='TB0.6/P4.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='TB0.5/P4.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='TB0.1/P4.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='PU.0/DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='VSSU',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='P9.5/UCB2SIMO/UCB2SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='P9.2/UCA2TXD/UCA2SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='P8.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='F12',name='DVCC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='DVSS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='H12',name='P8.3/UCA1RXD/UCA1SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='J12',name='P8.1/UCB1STE/UCA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='SVMOUT/TB0OUTH/P4.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='L12',name='TB0.4/P4.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M12',name='TB0.3/P4.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430FR5720IRGE',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='24pin QFN, 16KB FRAM Memory, 1KB SRAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430FR5724IRGE', 'MSP430FR5728IRGE', 'MSP430FR5730IRGE', 'MSP430FR5734IRGE', 'MSP430FR5738IRGE'],pins=[
            Pin(num='1',name='TA0.1/DMAE0/RTCCLK/CD0/VeREF-/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.2/TA1CLK/CDOUT/CD1/VeREF+/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA1.1/TA0CLK/CDOUT/CD2/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA1.2/UCB0STE/CD3/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TB0.1/UCA0STE/CD4/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TB0.2/UCA0CLK/CD5/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PJ.0/TDO/TB0OUTH/SMCLK/CD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PJ.1/TDI/TCLK/MCLK/CD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PJ.2/TMS/ACLK/CD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PJ.3/TCK/CD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVCC',do_erc=True),
            Pin(num='11',name='TEST/SBWTCK',do_erc=True),
            Pin(num='21',name='PJ.4/XIN',do_erc=True),
            Pin(num='12',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='22',name='PJ.5/XOUT',do_erc=True),
            Pin(num='13',name='TB0CLK/UCA0TXD/UCA0SIMO/ACLK/P2.0',do_erc=True),
            Pin(num='23',name='AVSS',do_erc=True),
            Pin(num='14',name='TB0.0/UCA0RXD/UCA0SOMI/P2.1',do_erc=True),
            Pin(num='24',name='AVCC',do_erc=True),
            Pin(num='15',name='UCB0CLK/P2.2',do_erc=True),
            Pin(num='16',name='TA0.0/UCB0SIMO/UCB0SDA/P1.6',do_erc=True),
            Pin(num='17',name='TA1.0/UCB0SOMI/UCB0SCL/P1.7',do_erc=True),
            Pin(num='18',name='VCORE',do_erc=True),
            Pin(num='19',name='DVSS',do_erc=True)]),
        Part(name='MSP430FR5722IRGE',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='24pin QFN, 16KB FRAM Memory, 1KB SRAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430FR5726IRGE', 'MSP430FR5732IRGE', 'MSP430FR5736IRGE'],pins=[
            Pin(num='1',name='TA0.1/DMAE0/RTCCLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.2/TA1CLK/CDOUT/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA1.1/TA0CLK/CDOUT/CD2/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA1.2/UCB0STE/CD3/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TB0.1/UCA0STE/CD4/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TB0.2/UCA0CLK/CD5/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PJ.0/TDO/TB0OUTH/SMCLK/CD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PJ.1/TDI/TCLK/MCLK/CD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PJ.2/TMS/ACLK/CD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PJ.3/TCK/CD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVCC',do_erc=True),
            Pin(num='11',name='TEST/SBWTCK',do_erc=True),
            Pin(num='21',name='PJ.4/XIN',do_erc=True),
            Pin(num='12',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='22',name='PJ.5/XOUT',do_erc=True),
            Pin(num='13',name='TB0CLK/UCA0TXD/UCA0SIMO/ACLK/P2.0',do_erc=True),
            Pin(num='23',name='AVSS',do_erc=True),
            Pin(num='14',name='TB0.0/UCA0RXD/UCA0SOMI/P2.1',do_erc=True),
            Pin(num='24',name='AVCC',do_erc=True),
            Pin(num='15',name='UCB0CLK/P2.2',do_erc=True),
            Pin(num='16',name='TA0.0/UCB0SIMO/UCB0SDA/P1.6',do_erc=True),
            Pin(num='17',name='TA1.0/UCB0SOMI/UCB0SCL/P1.7',do_erc=True),
            Pin(num='18',name='VCORE',do_erc=True),
            Pin(num='19',name='DVSS',do_erc=True)]),
        Part(name='MSP430G2001IN14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='14pin PDIP, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2101IN14', 'MSP430G2201IN14'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA0.0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA0.1/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2001IPW14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2201, 14pin TSSOP, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2101IPW14', 'MSP430G2201IPW14'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA0.0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA0.1/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2001IRSA16',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2201, 16pin QFN, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2101IRSA16', 'MSP430G2201IRSA16'],pins=[
            Pin(num='1',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TA0.0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA0.1/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2102IN20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin PDIP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2202IN20', 'MSP430G2302IN20', 'MSP430G2402IN20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SMCLK/TCK/TA0.2/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SDO/SCL/TDI/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='SDI/SDA/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2102IPW14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2402, 14pin TSSOP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2202IPW14', 'MSP430G2302IPW14', 'MSP430G2402IPW14'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SMCLK/TCK/TA0.2/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SDO/SCL/TDI/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='SDI/SDA/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2102IPW20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2402, 20pin TSSOP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2202IPW20', 'MSP430G2302IPW20', 'MSP430G2402IPW20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SMCLK/TCK/TA0.2/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SDO/SCL/TDI/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='SDI/SDA/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2102IRSA16',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2402, 16pin QFN, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2202IRSA16', 'MSP430G2302IRSA16', 'MSP430G2402IRSA16'],pins=[
            Pin(num='1',name='TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TMS/SCLK/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SDO/SCL/TDI/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SDI/SDA/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2111IN14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='14pin PDIP, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2211IN14'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CA0/TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CA1/TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='CA2/TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CAOUT/CA3/ADC10CLK/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CA4/SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CA5/TA0.0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='CA6/TA0.1/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='CA7/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2111IPW14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2211, 14pin TSSOP, 1KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2211IPW14'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CA0/TA0CLK/ACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CA1/TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='CA2/TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CAOUT/CA3/ADC10CLK/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CA4/SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CA5/TA0.0/TMS/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='CA6/TA0.1/TDI/TCLK/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='CA7/TDO/TDI/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2111IRSA16',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2211, 16pin QFN, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2211IRSA16'],pins=[
            Pin(num='1',name='ACLK/TA0CLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.0/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.1/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='CAOUT/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TCK/SMCLK/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TMS/TA0.0/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TDI/TCLK/TA0.1/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDO/TDI/CAOUT/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2112IN20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin PDIP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2212IN20', 'MSP430G2312IN20', 'MSP430G2412IN20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CAOUT/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/TA0.2/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/TA0.1/SDO/SCL/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/SDI/SDA/CAOUT/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2112IPW14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2412, 14pin TSSOP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2212IPW14', 'MSP430G2312IPW14', 'MSP430G2412IPW14'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CAOUT/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/TA0.2/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDI/TCLK/TA0.1/SDO/SCL/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TDO/TDI/SDI/SDA/CAOUT/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2112IPW20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2412, 20pin TSSOP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2212IPW20', 'MSP430G2312IPW20', 'MSP430G2412IPW20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CAOUT/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/TA0.2/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/TA0.1/SDO/SCL/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/SDI/SDA/CAOUT/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2112IRSA16',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2412, 16pin QFN, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2212IRSA16', 'MSP430G2312IRSA16', 'MSP430G2412IRSA16'],pins=[
            Pin(num='1',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.0/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.1/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='CAOUT/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TCK/SMCLK/TA0.2/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TMS/SCLK/TA0.0/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TDI/TCLK/TA0.1/SDO/SCL/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDO/TDI/SDI/SDA/CAOUT/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2113IPW20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2513, 20pin TSSOP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2213IPW20', 'MSP430G2313IPW20', 'MSP430G2413IPW20', 'MSP430G2513IPW20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='UCA0RXD/UCA0SOMI/TA0.0/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='UCA0TXD/UCA0SIMO/TA0.1/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CAOUT/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/UCB0CLK/UCA0STE/TA0.0/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/UCB0SOMI/UCB0SCL/TA0.1/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/UCB0SIMO/UCB0SDA/CAOUT/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='TEST/SBWTCK',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2121IN14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='14pin PDIP, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2221IN14'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='ACLK/TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDI/SDO/SCL/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TDI/TDO/SDI/SDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2121IPW14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2221, 14pin TSSOP, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2221IPW14'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='ACLK/TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDI/SDO/SCL/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TDI/TDO/SDI/SDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2121IRSA16',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2221, 16pin QFN, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2221IRSA16'],pins=[
            Pin(num='1',name='ACLK/TACLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TCK/SMCLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TMS/SCLK/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TDI/SDO/SCL/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDI/TDO/SDI/SDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2131IN14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='14pin PDIP, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2231IN14'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='ACLK/TACLK/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/VREF+/VeREF+/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDI/SDO/SCL/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TDI/TDO/SDI/SDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2131IPW14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2231, 14pin PDIP, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2231IPW14'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='ACLK/TACLK/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/VREF+/VeREF+/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDI/SDO/SCL/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TDI/TDO/SDI/SDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2131IRSA16',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2231, 16pin QFN, 2KB Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2231IRSA16'],pins=[
            Pin(num='1',name='ACLK/TACLK/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.0/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.1/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TCK/SMCLK/VREF+/VeREF+/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TMS/SCLK/TA0.0/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TDI/SDO/SCL/TCLK/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDI/TDO/SDI/SDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2132IN20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin PDIP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2232IN20', 'MSP430G2332IN20', 'MSP430G2432IN20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='A0/ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A1/TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='A2/TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/VREF+/VeREF+/A4/SMCLK/TA0.2/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/A5/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SDO/SCL/TDI/TCLK/A6/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='SDI/SDA/TDO/TDI/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2132IPW14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2432, 14pin TSSOP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2232IPW14', 'MSP430G2332IPW14', 'MSP430G2432IPW14'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='ACLK/A0/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A1/TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='A2/TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SMCLK/TCK/A4/VREF+/VeREF+/TA0.2/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/A5/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SDO/SCL/TDI/TCLK/A6/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='SDI/SDA/TDO/TDI/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2132IPW20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2432, 20pin TSSOP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2232IPW20', 'MSP430G2332IPW20', 'MSP430G2432IPW20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='A0/ACLK/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A1/TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='A2/TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/VREF+/VeREF+/A4/SMCLK/TA0.2/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/A5/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='SDO/SCL/TDI/TCLK/A6/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='SDI/SDA/TDO/TDI/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2132IRSA16',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2432, 16pin QFN, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2232IRSA16', 'MSP430G2332IRSA16', 'MSP430G2432IRSA16'],pins=[
            Pin(num='1',name='ACLK/A0/TA0CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='A1/TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A2/TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SMCLK/TCK/VREF+/VeREF+/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TMS/SCLK/A5/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SDO/SCL/TDI/TCLK/A6/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='SDI/SDA/TDO/TDI/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2152IN20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin PDIP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2252IN20', 'MSP430G2352IN20', 'MSP430G2452IN20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/CA1/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/CA2/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/CAOUT/CA3/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/TA0.2/VREF+/VeREF+/CA4/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/CA5/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/TA0.1/SDO/SCL/CA6/A6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/SDI/SDA/CAOUT/CA7/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2152IPW14',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2452, 14pin TSSOP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2252IPW14', 'MSP430G2352IPW14', 'MSP430G2452IPW14'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/CA1/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/CA2/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/CAOUT/CA3/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/TA0.2/VREF+/VeREF+/CA4/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/CA5/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDI/TCLK/TA0.1/SDO/SCL/CA6/A6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TDO/TDI/SDI/SDA/CAOUT/CA7/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='11',name='SBWTCK/TEST',do_erc=True),
            Pin(num='12',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2152IPW20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2452, 20pin TSSOP, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2252IPW20', 'MSP430G2352IPW20', 'MSP430G2452IPW20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/CA1/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/CA2/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/CAOUT/CA3/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/TA0.2/VREF+/VeREF+/CA4/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/SCLK/TA0.0/CA5/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/TA0.1/SDO/SCL/CA6/A6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/SDI/SDA/CAOUT/CA7/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2152IRSA16',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2452, 16pin QFN, 8KB Flash Memory, 256B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2252IRSA16', 'MSP430G2352IRSA16', 'MSP430G2452IRSA16'],pins=[
            Pin(num='1',name='TA0CLK/ACLK/A0/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.0/A1/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.1/A2/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='ADC10CLK/CAOUT/VREF-/VeREF-/A3/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TCK/SMCLK/TA0.2/VREF+/VeREF+/A4/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TMS/TA0.0/SCLK/A5/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TDI/TCLK/TA0.1/SDO/SCL/A6/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TDO/TDI/CAOUT/SDI/SDA/A7/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='10',name='SBWTCK/TEST',do_erc=True),
            Pin(num='11',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2153IN20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin PDIP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2253IN20', 'MSP430G2353IN20', 'MSP430G2453IN20', 'MSP430G2553IN20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='UCA0RXD/UCA0SOMI/TA0.0/CA1/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='UCA0TXD/UCA0SIMO/TA0.1/CA2/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CAOUT/VREF-/VeREF-/CA3/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/VREF+/VeREF+/CA4/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/UCB0CLK/UCA0STE/TA0.0/CA5/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/UCB0SOMI/UCB0SCL/TA0.1/CA6/A6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/UCB0SIMO/UCB0SDA/CAOUT/CA7/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='TEST/SBWTCK',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2153IPW20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2553, 20pin TSSOP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2253IPW20', 'MSP430G2353IPW20', 'MSP430G2453IPW20', 'MSP430G2553IPW20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='UCA0RXD/UCA0SOMI/TA0.0/CA1/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='UCA0TXD/UCA0SIMO/TA0.1/CA2/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CAOUT/VREF-/VeREF-/CA3/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/VREF+/VeREF+/CA4/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/UCB0CLK/UCA0STE/TA0.0/CA5/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/UCB0SOMI/UCB0SCL/TA0.1/CA6/A6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/UCB0SIMO/UCB0SDA/CAOUT/CA7/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='TEST/SBWTCK',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2153IPW28',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2553, 28pin TQFP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2253IPW28', 'MSP430G2353IPW28', 'MSP430G2453IPW28', 'MSP430G2553IPW28'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/A0/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/UCA0RXD/UCA0SOMI/A1/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/UCA0TXD/UCA0SIMO/A2/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/CAOUT/VREF-/VeREF-/A3/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/VREF+/VeREF+/A4/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/TA0.0/UCB0CLK/UCA0STE/A5/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P3.1/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA1.0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P3.6/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='TA1.1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P3.7/TA1CLK/CAOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TA1.1/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/A6/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TDO/TDI/CAOUT/UCB0SIMO/UCB0SDA/A7/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='15',name='P3.4/TA0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SBWTCK/TEST',do_erc=True),
            Pin(num='16',name='TA1.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA1.2/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA0.1/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA1.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P3.5/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2153IRHB32',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2553, 32pin QFN, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2253IRHB32', 'MSP430G2353IRHB32', 'MSP430G2453IRHB32', 'MSP430G2553IRHB32'],pins=[
            Pin(num='1',name='TA0.0/UCA0RXD/UCA0SOMI/A1/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.1/UCA0TXD/UCA0SIMO/A2/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='ADC10CLK/CAOUT/VREF-/VeREF-/A3/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TCK/SMCLK/UCB0STE/UCA0CLK/VREF+/VeREF+/A4/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TMS/TA0.0/UCB0CLK/UCA0STE/A5/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P3.1/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P3.0/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TA1.0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA1.1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P3.7/TA1CLK/CAOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TA1.1/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/A6/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA0CLK/ACLK/A0/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TDO/TDI/CAOUT/UCB0SIMO/UCB0SDA/A7/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.3/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='14',name='P3.4/TA0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SBWTCK/TEST',do_erc=True),
            Pin(num='15',name='TA1.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA1.2/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TA0.1/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA1.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='P3.5/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P3.6/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2203IN20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin PDIP, 8KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2303IN20', 'MSP430G2403IN20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/UCA0RXD/UCA0SOMI/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/UCA0TXD/UCA0SIMO/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/TA0.0/UCB0CLK/UCA0STE/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/UCB0SIMO/UCB0SDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='TEST/SBWTCK',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2203IPW20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2403, 20pin TSSOP, 8KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2303IPW20', 'MSP430G2403IPW20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/UCA0RXD/UCA0SOMI/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/UCA0TXD/UCA0SIMO/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/TA0.0/UCB0CLK/UCA0STE/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/UCB0SIMO/UCB0SDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='TEST/SBWTCK',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2203IPW28',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2403, 28pin TSSOP, 8KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2303IPW28', 'MSP430G2403IPW28'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/UCA0RXD/UCA0SOMI/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/UCA0TXD/UCA0SIMO/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/TA0.0/UCB0CLK/UCA0STE/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P3.1/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA1.0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P3.6/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='TA1.1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P3.7/TA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TA1.1/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TDO/TDI/UCB0SIMO/UCB0SDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='15',name='P3.4/TA0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='TEST/SBWTCK',do_erc=True),
            Pin(num='16',name='TA1.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA1.2/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA0.1/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA1.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P3.5/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2203IRHB32',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2403, 32pin QFN, 8KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2303IRHB32', 'MSP430G2403IRHB32'],pins=[
            Pin(num='1',name='TA0.0/UCA0RXD/UCA0SOMI/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.1/UCA0TXD/UCA0SIMO/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TCK/SMCLK/UCB0STE/UCA0CLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TMS/TA0.0/UCB0CLK/UCA0STE/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P3.1/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P3.0/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TA1.0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA1.1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P3.7/TA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TA1.1/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TDO/TDI/UCB0SIMO/UCB0SDA/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.3/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='14',name='P3.4/TA0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TEST/SBWTCK',do_erc=True),
            Pin(num='15',name='TA1.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA1.2/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TA0.1/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA1.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='P3.5/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P3.6/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2210ID',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='8pin PDIP, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='TA0.1/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA0.0/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='TA0.1/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='CAOUT/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='TEST/SBWTCK',do_erc=True)]),
        Part(name='MSP430G2213IN20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin PDIP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2313IN20', 'MSP430G2413IN20', 'MSP430G2513IN20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='UCA0RXD/UCA0SOMI/TA0.0/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='UCA0TXD/UCA0SIMO/TA0.1/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CAOUT/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/UCB0CLK/UCA0STE/TA0.0/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/UCB0SOMI/UCB0SCL/TA0.1/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/UCB0SIMO/UCB0SDA/CAOUT/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='TEST/SBWTCK',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2213IPW28',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2513, 28pin TSSOP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2313IPW28', 'MSP430G2413IPW28', 'MSP430G2513IPW28'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/UCA0RXD/UCA0SOMI/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/UCA0TXD/UCA0SIMO/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CAOUT/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/TA0.0/UCB0CLK/UCA0STE/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P3.1/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA1.0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P3.6/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='TA1.1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P3.7/TA1CLK/CAOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TA1.1/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TDO/TDI/CAOUT/UCB0SIMO/UCB0SDA/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='15',name='P3.4/TA0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='SBWTCK/TEST',do_erc=True),
            Pin(num='16',name='TA1.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA1.2/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA0.1/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA1.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P3.5/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2213IRHB32',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2513, 32pin QFN, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2313IRHB32', 'MSP430G2413IRHB32', 'MSP430G2513IRHB32'],pins=[
            Pin(num='1',name='TA0.0/UCA0RXD/UCA0SOMI/CA1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.1/UCA0TXD/UCA0SIMO/CA2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CAOUT/CA3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TCK/SMCLK/UCB0STE/UCA0CLK/CA4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TMS/TA0.0/UCB0CLK/UCA0STE/CA5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P3.1/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P3.0/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TA1.0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA1.1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P3.7/TA1CLK/CAOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TA1.1/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/CA6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA0CLK/ACLK/CA0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TDO/TDI/CAOUT/UCB0SIMO/UCB0SDA/CA7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.3/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='14',name='P3.4/TA0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='SBWTCK/TEST',do_erc=True),
            Pin(num='15',name='TA1.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA1.2/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TA0.1/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA1.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='P3.5/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P3.6/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2230ID',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='8pin SOIC, 2KB + 256B Flash Memory, 128B RAM',ref_prefix='U',num_units=1,fplist=['SOIC-8*'],do_erc=True,pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0.1/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/SCLK/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='TA0.1/SDO/SCL/A6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='SDI/SDA/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='7',name='TEST/SBWTCK',do_erc=True)]),
        Part(name='MSP430G2233IN20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='20pin PDIP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2333IN20', 'MSP430G2433IN20', 'MSP430G2533IN20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/UCA0RXD/UCA0SOMI/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/UCA0TXD/UCA0SIMO/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/VREF+/VeREF+/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/TA0.0/UCB0CLK/UCA0STE/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/A6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/UCB0SIMO/UCB0SDA/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='TEST/SBWTCK',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2233IPW20',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2533, 20pin TSSOP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2333IPW20', 'MSP430G2433IPW20', 'MSP430G2533IPW20'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/UCA0RXD/UCA0SOMI/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/UCA0TXD/UCA0SIMO/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/VREF+/VeREF+/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/TA0.0/UCB0CLK/UCA0STE/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P2.0/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P2.1/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P2.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P2.3/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P2.4/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P2.5/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/A6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDO/TDI/UCB0SIMO/UCB0SDA/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='17',name='TEST/SBWTCK',do_erc=True),
            Pin(num='18',name='P2.7/XOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P2.6/XIN/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2233IPW28',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2533, 28pin TSSOP, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2333IPW28', 'MSP430G2433IPW28', 'MSP430G2533IPW28'],pins=[
            Pin(num='1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TA0CLK/ACLK/CA0/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TA0.0/UCA0RXD/UCA0SOMI/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TA0.1/UCA0TXD/UCA0SIMO/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='TCK/SMCLK/UCB0STE/UCA0CLK/VREF+/VeREF+/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS/TA0.0/UCB0CLK/UCA0STE/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P3.1/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA1.0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P3.6/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='TA1.1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P3.7/TA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='TA1.1/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/A6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TDO/TDI/UCB0SIMO/UCB0SDA/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='15',name='P3.4/TA0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='TEST/SBWTCK',do_erc=True),
            Pin(num='16',name='TA1.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA1.2/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA0.1/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='TA1.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P3.5/TA0.1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2233IRHB32',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2533, 32pin QFN, 16KB Flash Memory, 512B RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2333IRHB32', 'MSP430G2433IRHB32', 'MSP430G2533IRHB32'],pins=[
            Pin(num='1',name='TA0.0/UCA0RXD/UCA0SOMI/A1/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='TA0.1/UCA0TXD/UCA0SIMO/A2/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='ADC10CLK/VREF-/VeREF-/A3/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TCK/SMCLK/UCB0STE/UCA0CLK/VREF+/VeREF+/A4/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TMS/TA0.0/UCB0CLK/UCA0STE/A5/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P3.1/TA1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P3.0/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TA1.0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA1.1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P3.7/TA1CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TA1.1/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='TDI/TCLK/TA0.1/UCB0SOMI/UCB0SCL/A6/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA0CLK/ACLK/CA0/A0/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.2/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TDO/TDI/UCB0SIMO/UCB0SDA/A7/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.3/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='14',name='P3.4/TA0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='TEST/SBWTCK',do_erc=True),
            Pin(num='15',name='TA1.0/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TA1.2/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TA0.1/XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TA1.2/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='P3.5/TA0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P3.6/TA0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2444IDA38',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2744, 38pin TSSOP, 32KB + 256B Flash Memory, 1KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2544IDA38', 'MSP430G2744IDA38'],pins=[
            Pin(num='1',name='SBWTCK/TEST',do_erc=True),
            Pin(num='2',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Rosc/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='8',name='ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TAINCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P4.3/A12/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA2/VREF+/VeREF+/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.0/A5/UCB0STE/UCA0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P4.4/A13/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P4.5/A14/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P4.6/A15/TBOUTH',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TCK/SMCLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P3.6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P3.7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TA1/VREF-/VeREF-/A3/P2.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2444IRHA40',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430G2744, 40pin QFN, 32KB + 256B Flash Memory, 1KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2544IRHA40', 'MSP430G2744IRHA40'],pins=[
            Pin(num='1',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='6',name='ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TAINCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/UCB0STE/UCA0CLK/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P4.5/TB2/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ROSC/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P4.6/TBOUTH/A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='SMCLK/TCK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P3.6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='P3.7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA1/VREF-/VeREF-/A3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P4.3/TB0/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TA2/VREF+/VeREF+/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P4.4/TB1/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='DVCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MSP430G2444IYFF',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='49ball BGA, 32KB + 256B Flash Memory, 1KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2544IYFF', 'MSP430G2744IYFF'],pins=[
            Pin(num='A1',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C1',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='D1',name='SBWTCK/TEST',do_erc=True),
            Pin(num='E1',name='TMS/TA0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='TCK/SMCLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='TA2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C2',name='ROSC/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='TDO/TDI/TA2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='TA1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='TACLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='TA0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='B3',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='C3',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='E3',name='TDI/TCLK/TA1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='TA1/VREF-/VeREF-/A3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='TA2/VREF+/VeREF+/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='TAINCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='E4',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F4',name='P3.6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='P3.7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='TA0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='P3.0/A5/UCB0STE/UCA0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='P4.7/TBCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='P4.0/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='P4.2/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='P4.5/A14/TB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='C7',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='D7',name='P4.1/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='P4.3/A12/TB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='P4.4/A13/TB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G7',name='P4.6/A15/TBOUTH',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2755IDA38',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430F2955, 38pin TSSOP, 56KB Flash Memory, 4KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2855IDA38', 'MSP430G2955IDA38'],pins=[
            Pin(num='1',name='SBWTCK/TEST',do_erc=True),
            Pin(num='2',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='TA1.0/ROSC/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='8',name='TA1CLK/ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='TA0INCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TA0.0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P4.3/A12/CA3/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA0.2/VREF+/VeREF+/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.0/A5/UCB0STE/UCA0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P4.4/A13/CA4/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA0CLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P4.5/A14/CA5/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P4.6/A15/CA6/TB0OUTH',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P4.7/CA7/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TCK/SMCLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='TMS/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P4.0/CA0/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P3.6/A6/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='TDI/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P4.1/CA1/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P3.7/A7/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='TDO/TDI/TA0.2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P4.2/CA2/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TA0.1/VREF−/VeREF−/A3/P2.3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MSP430G2755IRHA40',dest=TEMPLATE,tool=SKIDL,keywords='MSP430 MIXED SIGNAL MICROCONTROLLER',description='MSP430F2955, 40pin QFN, 56KB Flash Memory, 4KB RAM',ref_prefix='U',num_units=1,do_erc=True,aliases=['MSP430G2855IRHA40', 'MSP430G2955IRHA40'],pins=[
            Pin(num='1',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='XOUT/P2.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='XIN/P2.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='DVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~RST~/NMI/SBWTDIO',do_erc=True),
            Pin(num='6',name='TA1CLK/ACLK/A0/P2.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TA0INCLK/SMCLK/A1/P2.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='TA0.0/A2/P2.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P3.0/A5/UCB0STE/UCA0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P3.1/UCB0SIMO/UCB0SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P4.5/A14/CA5/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TA0.0/P1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='TA1.0/ROSC/P2.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P3.2/UCB0SOMI/UCB0SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P4.6/A15/CA6/TB0OUTH',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TA0.1/P1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P3.3/UCB0CLK/UCA0STE',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P4.7/CA7/TB0CLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TA0.2/P1.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='P3.4/UCA0TXD/UCA0SIMO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='TCK/SMCLK/P1.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='P3.5/UCA0RXD/UCA0SOMI',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='TMS/TA0.0/P1.5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P4.0/CA0/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P3.6/A6/TA1.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='TDI/TA0.1/P1.6',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P4.1/CA1/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='P3.7/A6/TA1.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='TDO/TDI/TA0.2/P1.7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P4.2/CA2/TB0.2',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TA0.1/VREF−/VeREF−/A3/P2.3',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='SBWTCK/TEST',do_erc=True),
            Pin(num='18',name='P4.3/A12/CA3/TB0.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TA0.2/VREF+/VeREF+/A4/P2.4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='DVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P4.4/A13/CA4/TB0.1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TA0CLK/ADC10CLK/P1.0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='DVCC',func=Pin.PWRIN,do_erc=True)])])
