from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

ftdi = SchLib(tool=SKIDL).add_parts(*[
        Part(name='FT200XD',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB I2C Interface Converter',description='Full Speed USB to I2C Bridge, DFN-10',ref_prefix='U',num_units=1,fplist=['DFN*'],do_erc=True,pins=[
            Pin(num='1',name='USBDM',do_erc=True),
            Pin(num='2',name='~RESET',do_erc=True),
            Pin(num='3',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='CBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',do_erc=True),
            Pin(num='7',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='USBDP',do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='FT201XQ',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB I2C interface Converter',description='Full Speed USB to I2C Bridge, QFN-10',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,pins=[
            Pin(num='1',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='CBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='CBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='CBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='CBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='CBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='CBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SCL',do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='FT201XS',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB I2C Interface Converter',description='Full Speed USB to I2C Bridge, SSOP-16',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='CBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='SCL',do_erc=True),
            Pin(num='3',name='VCCIO',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='~RESET',do_erc=True),
            Pin(num='12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='CBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='CBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='CBUS3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FT220XQ',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB SPI FT1248 Interface Converter',description='Full Speed USB to 4-Bit SPI / FT1248 Bridge, QFN-16',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,pins=[
            Pin(num='1',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='MIOSI1',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='MIOSI3',do_erc=True),
            Pin(num='5',name='MISO',do_erc=True),
            Pin(num='6',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~CS',do_erc=True),
            Pin(num='12',name='CLK',do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='CBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='MIOSI0',do_erc=True),
            Pin(num='16',name='MIOSI2',do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='FT220XS',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB SPI FT1248 Interface Converter',description='Full Speed USB to 4-Bit SPI / FT1248 Bridge, SSOP-16',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='MIOSI0',do_erc=True),
            Pin(num='2',name='MIOSI2',do_erc=True),
            Pin(num='3',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='MIOSI1',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='MIOSI3',do_erc=True),
            Pin(num='7',name='MISO',do_erc=True),
            Pin(num='8',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='~RESET',do_erc=True),
            Pin(num='12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='~CS',do_erc=True),
            Pin(num='15',name='CLK',do_erc=True),
            Pin(num='16',name='CBUS3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FT221XQ',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB SPI FT1248 interface converter',description='Full Speed USB to 8-Bit SPI / FT1248 Bridge, QFN-20',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,pins=[
            Pin(num='1',name='MIOSI1',do_erc=True),
            Pin(num='2',name='MIOSI7',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='MIOSI5',do_erc=True),
            Pin(num='5',name='MIOSI6',do_erc=True),
            Pin(num='6',name='MIOSI3',do_erc=True),
            Pin(num='7',name='MISO',do_erc=True),
            Pin(num='8',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='20',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~RESET',do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='~CS',do_erc=True),
            Pin(num='15',name='CLK',do_erc=True),
            Pin(num='16',name='CBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='MIOSI0',do_erc=True),
            Pin(num='18',name='MIOSI4',do_erc=True),
            Pin(num='19',name='MIOSI2',do_erc=True)]),
        Part(name='FT221XS',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB SPI FT1248 interface converter',description='Full Speed USB to 8-Bit SPI / FT1248 Bridge, SSOP-20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='MIOSI4',do_erc=True),
            Pin(num='2',name='MIOSI2',do_erc=True),
            Pin(num='3',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='MIOSI1',do_erc=True),
            Pin(num='5',name='MIOSI7',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='MIOSI5',do_erc=True),
            Pin(num='8',name='MIOSI6',do_erc=True),
            Pin(num='9',name='MIOSI3',do_erc=True),
            Pin(num='10',name='MISO',do_erc=True),
            Pin(num='20',name='MIOSI0',do_erc=True),
            Pin(num='11',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='14',name='~RESET',do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~CS',do_erc=True),
            Pin(num='18',name='CLK',do_erc=True),
            Pin(num='19',name='CBUS3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FT2232D',dest=TEMPLATE,tool=SKIDL,keywords='USB Double UART FIFO',description='Full Speed Double Channel USB UART/FIFO, LQFP-48',ref_prefix='U',num_units=1,fplist=['LQFP*7x7mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='EECLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='EEDATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='~RSTOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SI/WUA',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='ADBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='BCBUS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='BDBUS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='ACBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='ADBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCCIOB',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='~PWREN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='ACBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='ADBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='BDBUS7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='42',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='ACBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='ADBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='BDBUS6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='XTIN',do_erc=True),
            Pin(num='14',name='VCCIOA',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='ADBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='XTOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='ACBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='BDBUS5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='ADBUS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='SI/WUB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='BDBUS4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='AVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='ADBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='BCBUS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='BDBUS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='TEST',do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='BCBUS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='BDBUS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='EECS',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='ADBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='BCBUS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='BDBUS1',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='FT2232H',dest=TEMPLATE,tool=SKIDL,keywords='USB Double UART FIFO',description='FT2232Hx, Hi Speed Double Channel USB UART/FIFO, LQFP/QFN-64',ref_prefix='U',num_units=1,fplist=['QFN*', 'LQFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OSCI',do_erc=True),
            Pin(num='3',name='OSCO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VPHY',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='REF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VPLL',do_erc=True),
            Pin(num='10',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='ACBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='BDBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='VREGIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='~PWREN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='ADBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='BDBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='EEDATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='ADBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='ACBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='BCBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='EECLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='TEST',do_erc=True),
            Pin(num='23',name='ADBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='ACBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='BDBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='BCBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='EECS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~RESET',do_erc=True),
            Pin(num='24',name='ADBUS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='ACBUS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='BDBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='BCBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='BDBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='BCBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ACBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='~SUSPEND',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='BDBUS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='ADBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ACBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='BCBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ACBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='BDBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='BCBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='BCBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='ADBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ACBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='BDBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='VREGOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='59',name='BCBUS7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FT230XQ',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB UART interface converter',description='Full Speed USB to Basic UART, QFN-16',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,pins=[
            Pin(num='1',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RXD',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~CTS',do_erc=True),
            Pin(num='5',name='CBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='9',name='~RESET',do_erc=True),
            Pin(num='10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='CBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='CBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='CBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='~RTS',do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='FT230XS',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB UART interface converter',description='Full Speed USB to Basic UART, SSOP-16',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~RTS',do_erc=True),
            Pin(num='3',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='~CTS',do_erc=True),
            Pin(num='7',name='CBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='~RESET',do_erc=True),
            Pin(num='12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='CBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='CBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='CBUS3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FT231XQ',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB UART interface converter',description='Full Speed USB to Full Handshake UART, QFN-20',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,pins=[
            Pin(num='1',name='RXD',do_erc=True),
            Pin(num='2',name='~RI',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~DSR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~DCD',do_erc=True),
            Pin(num='6',name='~CTS',do_erc=True),
            Pin(num='7',name='CBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='20',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~RESET',do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='CBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='CBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='CBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='~DTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='~RTS',do_erc=True)]),
        Part(name='FT231XS',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB UART interface converter',description='Full Speed USB to Full Handshake UART, SSOP-20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='~DTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~RTS',do_erc=True),
            Pin(num='3',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='RXD',do_erc=True),
            Pin(num='5',name='~RI',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='~DSR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~DCD',do_erc=True),
            Pin(num='9',name='~CTS',do_erc=True),
            Pin(num='10',name='CBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='14',name='~RESET',do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='CBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='CBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='CBUS3',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FT232BM',dest=TEMPLATE,tool=SKIDL,keywords='USB Single UART FIFO',description='Hi Speed Single Channel USB UART/FIFO, LQFP-32',ref_prefix='U',num_units=1,fplist=['LQFP*'],do_erc=True,pins=[
            Pin(num='1',name='EESK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='EEDATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='~RSTOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='~SLEEP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='D5/~DSR',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',do_erc=True),
            Pin(num='11',name='~RXLED',do_erc=True),
            Pin(num='21',name='D4/~DTR',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TEST',do_erc=True),
            Pin(num='12',name='~TXLED',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='D3/~CTS',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='EECS',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='D2/~RST',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PWRCTL',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='D1/RXD',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='~PWREN',do_erc=True),
            Pin(num='25',name='D0/TXD',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TXDEN',do_erc=True),
            Pin(num='26',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='XTIN',do_erc=True),
            Pin(num='18',name='D7/~RI',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='XTOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='D6/~DCD',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='AGND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='FT232H',dest=TEMPLATE,tool=SKIDL,keywords='USB Single UART FIFO',description='FT232Hx, Hi Speed Single Channel USB UART/FIFO, LQFP/QFN-48',ref_prefix='U',num_units=1,fplist=['LQFP*', 'QFN*'],do_erc=True,pins=[
            Pin(num='1',name='XCSI',do_erc=True),
            Pin(num='2',name='XCSO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VPHY',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='REF',do_erc=True),
            Pin(num='6',name='DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='ADBUS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='ACBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VREGIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='ACBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='ACBUS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='ACBUS8',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='TEST',do_erc=True),
            Pin(num='13',name='ADBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='ACBUS9',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='EEDATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ADBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='~RESET',do_erc=True),
            Pin(num='44',name='EECLK',do_erc=True),
            Pin(num='15',name='ADBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='ACBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='EECS',do_erc=True),
            Pin(num='16',name='ADBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='ACBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='ADBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ACBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCCA',func=Pin.PWROUT,do_erc=True),
            Pin(num='47',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='ADBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ACBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='VCCCORE',func=Pin.PWROUT,do_erc=True),
            Pin(num='48',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='ADBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='ACBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='VCCD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='FT232RL',dest=TEMPLATE,tool=SKIDL,keywords='USB Serial',description='USB to Serial Interface, SSOP-28',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='TXD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='DTR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='RTS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VCCIO',do_erc=True),
            Pin(num='5',name='RXD',do_erc=True),
            Pin(num='6',name='RI',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='DCR',do_erc=True),
            Pin(num='10',name='DCD',do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='CTS',do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='CBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='CBUS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='CBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='CBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='CBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='USBD+',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='USBD-',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='TEST',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='3V3OUT',do_erc=True),
            Pin(num='27',name='OSCI',do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='OSCO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='~RESET~',do_erc=True)]),
        Part(name='FT240XQ',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB FIFO interface converter',description='Full Speed USB to 8-Bit FIFO, QFN-24',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,pins=[
            Pin(num='1',name='DATA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='DATA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='DATA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='DATA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='DATA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~SI/WU',do_erc=True),
            Pin(num='8',name='~RD',do_erc=True),
            Pin(num='9',name='~WR',do_erc=True),
            Pin(num='10',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='CBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='DATA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='22',name='DATA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='~RESET',do_erc=True),
            Pin(num='23',name='DATA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='~TXE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='~RXF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='CBUS6',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FT240XS',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB FIFO interface converter',description='Full Speed USB to 8-Bit FIFO, SSOP-24',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='DATA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='DATA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='DATA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='DATA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='DATA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DATA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='DATA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~SI/WU',do_erc=True),
            Pin(num='20',name='~TXE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~RD',do_erc=True),
            Pin(num='21',name='~RXF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~WR',do_erc=True),
            Pin(num='22',name='CBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='CBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='DATA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='16',name='~RESET',do_erc=True),
            Pin(num='17',name='VCCIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GND',func=Pin.BIDIR,do_erc=True)]),
        Part(name='FT245BM',dest=TEMPLATE,tool=SKIDL,keywords='FTDI USB FIFO Interface Converter',description='Full Speed USB to 8-Bit FIFO, LQFP-32',ref_prefix='U',num_units=1,fplist=['LQFP*'],do_erc=True,pins=[
            Pin(num='1',name='EESK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='EEDATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~RESET',do_erc=True),
            Pin(num='5',name='~RSTOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='3V3OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='USBDP',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='USBDM',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='~PWREN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='AVCC',do_erc=True),
            Pin(num='11',name='SI/WU',do_erc=True),
            Pin(num='21',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='TEST',do_erc=True),
            Pin(num='12',name='~RXF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='EECS',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~TXE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='WR',do_erc=True),
            Pin(num='25',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='~RD',do_erc=True),
            Pin(num='26',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='XTIN',do_erc=True),
            Pin(num='18',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='XTOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='FT4232H',dest=TEMPLATE,tool=SKIDL,keywords='USB Quad UART FIFO',description='Hi Speed Quad Channel USB UART/FIFO, LQFP/QFN-64',ref_prefix='U',num_units=1,fplist=['LQFP*', 'QFN*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OSCI',do_erc=True),
            Pin(num='3',name='OSCO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VPHY',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='REF',do_erc=True),
            Pin(num='7',name='DM',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='DP',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='VPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='BDBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='CDBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='VREGIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='~PWREN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='ADBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='CDBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='EEDATA',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='ADBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='BDBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='DDBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='EECLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='TEST',do_erc=True),
            Pin(num='23',name='ADBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='BDBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='CDBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='DDBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='EECS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~RESET',do_erc=True),
            Pin(num='24',name='ADBUS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='BDBUS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='CDBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='DDBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='CDBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='DDBUS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='ADBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='BDBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='~SUSPEND',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='CDBUS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='ADBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='BDBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCORE',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='DDBUS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='ADBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='BDBUS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='CDBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='DDBUS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='DDBUS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='ADBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='BDBUS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='CDBUS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='VREGOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='59',name='DDBUS7',func=Pin.BIDIR,do_erc=True)])])
