from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

brooktre = SchLib(tool=SKIDL).add_parts(*[
        Part(name='BT106',dest=TEMPLATE,tool=SKIDL,keywords='video CDA',description='Convertisseur Video D->A 8 bits',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='17',name='AGND',do_erc=True),
            Pin(num='18',name='AGND',do_erc=True),
            Pin(num='15',name='VAA',do_erc=True),
            Pin(num='19',name='VAA',do_erc=True),
            Pin(num='14',name='COMP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='IOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='1',name='CLK',do_erc=True),
            Pin(num='10',name='REF',do_erc=True),
            Pin(num='11',name='BLANK',do_erc=True),
            Pin(num='20',name='SYNC',do_erc=True),
            Pin(num='13',name='FSADJ',do_erc=True),
            Pin(num='12',name='VREF',do_erc=True),
            Pin(num='2',name='D7',do_erc=True),
            Pin(num='3',name='D6',do_erc=True),
            Pin(num='4',name='D5',do_erc=True),
            Pin(num='5',name='D4',do_erc=True),
            Pin(num='6',name='D3',do_erc=True),
            Pin(num='7',name='D2',do_erc=True),
            Pin(num='8',name='D1',do_erc=True),
            Pin(num='9',name='D0',do_erc=True)]),
        Part(name='BT208',dest=TEMPLATE,tool=SKIDL,keywords='video CAD',description='CAD 8 bits video',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='18',name='OE',do_erc=True),
            Pin(num='16',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='CLK',do_erc=True),
            Pin(num='19',name='GND',do_erc=True),
            Pin(num='8',name='GND',do_erc=True),
            Pin(num='7',name='GND',do_erc=True),
            Pin(num='20',name='VAA',do_erc=True),
            Pin(num='6',name='VAA',do_erc=True),
            Pin(num='5',name='VAA',do_erc=True),
            Pin(num='10',name='REFIN-',do_erc=True),
            Pin(num='3',name='REFIN+',do_erc=True),
            Pin(num='4',name='VREFOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='LEVEL',do_erc=True),
            Pin(num='12',name='CLAMP',do_erc=True),
            Pin(num='2',name='VIN',do_erc=True),
            Pin(num='1',name='VIN',do_erc=True)]),
        Part(name='BT251',dest=TEMPLATE,tool=SKIDL,keywords='Video CAD',description='CAD 8 bits video + multiplexer 4 inputs',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='35',name='GND',do_erc=True),
            Pin(num='34',name='GND',do_erc=True),
            Pin(num='37',name='VCC',do_erc=True),
            Pin(num='36',name='VCC',do_erc=True),
            Pin(num='24',name='A1',do_erc=True),
            Pin(num='25',name='A0',do_erc=True),
            Pin(num='22',name='WR',do_erc=True),
            Pin(num='23',name='RD',do_erc=True),
            Pin(num='26',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='33',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='OE',do_erc=True),
            Pin(num='21',name='P7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='P6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='P5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='P4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='P3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='P2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='P1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='P0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='CLOCK',do_erc=True),
            Pin(num='12',name='ZERO',do_erc=True),
            Pin(num='5',name='LEVEL',do_erc=True),
            Pin(num='3',name='CLAMP',do_erc=True),
            Pin(num='40',name='VIDIN',do_erc=True),
            Pin(num='42',name='VIDOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='CSYNC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VID3',do_erc=True),
            Pin(num='4',name='VID2',do_erc=True),
            Pin(num='2',name='VID1',do_erc=True),
            Pin(num='44',name='VID0',do_erc=True),
            Pin(num='7',name='REF-',do_erc=True),
            Pin(num='38',name='REF+',do_erc=True),
            Pin(num='1',name='IOUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='IOUT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='CEXT1',do_erc=True),
            Pin(num='9',name='CEXT2',do_erc=True),
            Pin(num='41',name='RSET',do_erc=True)]),
        Part(name='BT253',dest=TEMPLATE,tool=SKIDL,keywords='CAD Video RVB RGB',description='Triple CAD 8 bits video RVB + multiplexer 2 inputs RVB+Sync',ref_prefix='U',num_units=1,do_erc=True,aliases=['BT254'],pins=[
            Pin(num='42',name='GND',do_erc=True),
            Pin(num='41',name='GND',do_erc=True),
            Pin(num='3',name='GND',do_erc=True),
            Pin(num='2',name='GND',do_erc=True),
            Pin(num='44',name='VAA',do_erc=True),
            Pin(num='43',name='VAA',do_erc=True),
            Pin(num='1',name='VAA',do_erc=True),
            Pin(num='84',name='VAA',do_erc=True),
            Pin(num='19',name='A2',do_erc=True),
            Pin(num='18',name='A1',do_erc=True),
            Pin(num='17',name='A0',do_erc=True),
            Pin(num='24',name='WR',do_erc=True),
            Pin(num='20',name='RD',do_erc=True),
            Pin(num='9',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='57',name='OE',do_erc=True),
            Pin(num='25',name='B7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='B6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='B5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='B4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='B3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='B2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='B1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='B0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='33',name='G7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='34',name='G6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='35',name='G5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='36',name='G4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='45',name='G3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='46',name='G2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='47',name='G1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='48',name='G0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='49',name='R7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='50',name='R6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='51',name='R5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='52',name='R4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='53',name='R3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='54',name='R2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='55',name='R1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='56',name='R0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='38',name='BCLOCK',do_erc=True),
            Pin(num='39',name='GCLOCK',do_erc=True),
            Pin(num='40',name='RCLOCK',do_erc=True),
            Pin(num='61',name='BLEVEL',do_erc=True),
            Pin(num='63',name='GLEVEL',do_erc=True),
            Pin(num='67',name='RLEVEL',do_erc=True),
            Pin(num='37',name='ZERO',do_erc=True),
            Pin(num='59',name='CLAMP',do_erc=True),
            Pin(num='71',name='IOUT5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='73',name='IOUT4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='76',name='IOUT3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='78',name='IOUT2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='80',name='IOUT1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='82',name='IOUT0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='69',name='RSET',do_erc=True),
            Pin(num='58',name='BIN',do_erc=True),
            Pin(num='68',name='BOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='60',name='GIN',do_erc=True),
            Pin(num='70',name='GOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='62',name='RIN',do_erc=True),
            Pin(num='72',name='ROUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='CEXT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='CEXT2',do_erc=True),
            Pin(num='23',name='BREF-',do_erc=True),
            Pin(num='22',name='GREF-',do_erc=True),
            Pin(num='21',name='RREF-',do_erc=True),
            Pin(num='64',name='BREF+',do_erc=True),
            Pin(num='65',name='GREF+',do_erc=True),
            Pin(num='66',name='RREF+',do_erc=True),
            Pin(num='5',name='SYNC1',do_erc=True),
            Pin(num='74',name='BVID1',do_erc=True),
            Pin(num='77',name='GVID1',do_erc=True),
            Pin(num='81',name='RVID1',do_erc=True),
            Pin(num='4',name='SYNC0',do_erc=True),
            Pin(num='75',name='BVID0',do_erc=True),
            Pin(num='79',name='GVID0',do_erc=True),
            Pin(num='83',name='RVID0',do_erc=True),
            Pin(num='8',name='CSYNC',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='BT281',dest=TEMPLATE,tool=SKIDL,keywords='Video RGB RVB',description='Matrix converter RGB',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='80',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='69',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='68',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='RESET',do_erc=True),
            Pin(num='40',name='WR',do_erc=True),
            Pin(num='39',name='RD',do_erc=True),
            Pin(num='38',name='CS',do_erc=True),
            Pin(num='36',name='A1',do_erc=True),
            Pin(num='37',name='A0',do_erc=True),
            Pin(num='32',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='70',name='CFLAG',do_erc=True),
            Pin(num='73',name='OE',do_erc=True),
            Pin(num='75',name='OUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='74',name='OUT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='76',name='QC0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='1',name='QC7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='84',name='QC6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='83',name='QC5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='82',name='QC4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='79',name='QC3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='78',name='QC2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='77',name='QC1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='QB7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='QB6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='QB5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='QB4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='QB3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='QB2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='QB1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='QB0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='QA7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='QA6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='QA5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='QA4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='QA3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='QA2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='QA1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='12',name='QA0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='72',name='IN1',do_erc=True),
            Pin(num='71',name='IN0',do_erc=True),
            Pin(num='43',name='CLK',do_erc=True),
            Pin(num='67',name='DC7',do_erc=True),
            Pin(num='66',name='DC6',do_erc=True),
            Pin(num='65',name='DC5',do_erc=True),
            Pin(num='64',name='DC4',do_erc=True),
            Pin(num='63',name='DC3',do_erc=True),
            Pin(num='62',name='DC2',do_erc=True),
            Pin(num='61',name='DC1',do_erc=True),
            Pin(num='60',name='DC0',do_erc=True),
            Pin(num='59',name='DB7',do_erc=True),
            Pin(num='58',name='BD6',do_erc=True),
            Pin(num='57',name='DB5',do_erc=True),
            Pin(num='56',name='DB4',do_erc=True),
            Pin(num='55',name='DB3',do_erc=True),
            Pin(num='54',name='DB2',do_erc=True),
            Pin(num='53',name='DB1',do_erc=True),
            Pin(num='52',name='DB0',do_erc=True),
            Pin(num='51',name='DA7',do_erc=True),
            Pin(num='50',name='DA6',do_erc=True),
            Pin(num='49',name='DA5',do_erc=True),
            Pin(num='48',name='DA4',do_erc=True),
            Pin(num='47',name='DA3',do_erc=True),
            Pin(num='46',name='DA2',do_erc=True),
            Pin(num='45',name='DA1',do_erc=True),
            Pin(num='44',name='DA0',do_erc=True)]),
        Part(name='BT471',dest=TEMPLATE,tool=SKIDL,keywords='Video CDA',description='CDA 6/8 Bits + palette RGB',ref_prefix='U',num_units=1,do_erc=True,aliases=['BT478'],pins=[
            Pin(num='24',name='GND',do_erc=True),
            Pin(num='3',name='GND',do_erc=True),
            Pin(num='22',name='VAA',do_erc=True),
            Pin(num='21',name='VAA',do_erc=True),
            Pin(num='20',name='VAA',do_erc=True),
            Pin(num='4',name='VAA',do_erc=True),
            Pin(num='40',name='PCLK',do_erc=True),
            Pin(num='7',name='BLANK',do_erc=True),
            Pin(num='5',name='SYNC',do_erc=True),
            Pin(num='2',name='8/6',do_erc=True),
            Pin(num='23',name='SET',do_erc=True),
            Pin(num='30',name='OPA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='29',name='COMP',do_erc=True),
            Pin(num='31',name='VREF',do_erc=True),
            Pin(num='28',name='IREF',do_erc=True),
            Pin(num='27',name='BLU',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='GRE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='RED',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='OL3',do_erc=True),
            Pin(num='43',name='OL2',do_erc=True),
            Pin(num='42',name='OL1',do_erc=True),
            Pin(num='41',name='OL0',do_erc=True),
            Pin(num='6',name='RD',do_erc=True),
            Pin(num='16',name='WR',do_erc=True),
            Pin(num='19',name='RS2',do_erc=True),
            Pin(num='18',name='RS1',do_erc=True),
            Pin(num='17',name='RS0',do_erc=True),
            Pin(num='15',name='D7',do_erc=True),
            Pin(num='14',name='D6',do_erc=True),
            Pin(num='13',name='D5',do_erc=True),
            Pin(num='12',name='D4',do_erc=True),
            Pin(num='11',name='D3',do_erc=True),
            Pin(num='10',name='D2',do_erc=True),
            Pin(num='9',name='D1',do_erc=True),
            Pin(num='8',name='D0',do_erc=True),
            Pin(num='39',name='P7',do_erc=True),
            Pin(num='38',name='P6',do_erc=True),
            Pin(num='37',name='P5',do_erc=True),
            Pin(num='36',name='P4',do_erc=True),
            Pin(num='35',name='P3',do_erc=True),
            Pin(num='34',name='P2',do_erc=True),
            Pin(num='33',name='P1',do_erc=True),
            Pin(num='32',name='P0',do_erc=True)]),
        Part(name='BT473',dest=TEMPLATE,tool=SKIDL,keywords='video CDA RVB RGB',description='Triple CDA video 8 bits RGB',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='6',name='S1',do_erc=True),
            Pin(num='5',name='S0',do_erc=True),
            Pin(num='32',name='GND',do_erc=True),
            Pin(num='31',name='GND',do_erc=True),
            Pin(num='4',name='GND',do_erc=True),
            Pin(num='3',name='GND',do_erc=True),
            Pin(num='36',name='VAA',do_erc=True),
            Pin(num='35',name='VAA',do_erc=True),
            Pin(num='34',name='VAA',do_erc=True),
            Pin(num='33',name='VAA',do_erc=True),
            Pin(num='2',name='VAA',do_erc=True),
            Pin(num='1',name='VAA',do_erc=True),
            Pin(num='30',name='CR3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='29',name='CR2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='CR1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='CR0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='CLOCK',do_erc=True),
            Pin(num='7',name='BLANK',do_erc=True),
            Pin(num='8',name='SYNC',do_erc=True),
            Pin(num='44',name='VREFOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='42',name='OPA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='41',name='COMP',do_erc=True),
            Pin(num='43',name='VREF',do_erc=True),
            Pin(num='40',name='IREF',do_erc=True),
            Pin(num='39',name='BLU',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='GRE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='RED',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='OL3',do_erc=True),
            Pin(num='12',name='OL2',do_erc=True),
            Pin(num='11',name='OL1',do_erc=True),
            Pin(num='10',name='OL0',do_erc=True),
            Pin(num='23',name='RD',do_erc=True),
            Pin(num='22',name='WR',do_erc=True),
            Pin(num='26',name='RS2',do_erc=True),
            Pin(num='25',name='RS1',do_erc=True),
            Pin(num='24',name='RS0',do_erc=True),
            Pin(num='21',name='D7',do_erc=True),
            Pin(num='20',name='D6',do_erc=True),
            Pin(num='19',name='D5',do_erc=True),
            Pin(num='18',name='D4',do_erc=True),
            Pin(num='17',name='D3',do_erc=True),
            Pin(num='16',name='D2',do_erc=True),
            Pin(num='15',name='D1',do_erc=True),
            Pin(num='14',name='D0',do_erc=True),
            Pin(num='68',name='B7',do_erc=True),
            Pin(num='67',name='B6',do_erc=True),
            Pin(num='66',name='B5',do_erc=True),
            Pin(num='65',name='B4',do_erc=True),
            Pin(num='64',name='B3',do_erc=True),
            Pin(num='63',name='B2',do_erc=True),
            Pin(num='62',name='B1',do_erc=True),
            Pin(num='61',name='B0',do_erc=True),
            Pin(num='60',name='G7',do_erc=True),
            Pin(num='59',name='G6',do_erc=True),
            Pin(num='58',name='G5',do_erc=True),
            Pin(num='57',name='G4',do_erc=True),
            Pin(num='56',name='G3',do_erc=True),
            Pin(num='55',name='G2',do_erc=True),
            Pin(num='54',name='G1',do_erc=True),
            Pin(num='53',name='G0',do_erc=True),
            Pin(num='52',name='R7',do_erc=True),
            Pin(num='51',name='R6',do_erc=True),
            Pin(num='50',name='R5',do_erc=True),
            Pin(num='49',name='R4',do_erc=True),
            Pin(num='48',name='R3',do_erc=True),
            Pin(num='47',name='R2',do_erc=True),
            Pin(num='46',name='R1',do_erc=True),
            Pin(num='45',name='R0',do_erc=True)]),
        Part(name='BT812',dest=TEMPLATE,tool=SKIDL,keywords='CAD PAL NTSC video',description='CAD Video PAL/NTSC Y/C 4 inputs',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='110',name='N/C',do_erc=True),
            Pin(num='123',name='VAA',func=Pin.PASSIVE,do_erc=True),
            Pin(num='91',name='VCC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='160',name='VAA',do_erc=True),
            Pin(num='159',name='VAA',do_erc=True),
            Pin(num='158',name='VAA',do_erc=True),
            Pin(num='149',name='VAA',do_erc=True),
            Pin(num='142',name='VAA',do_erc=True),
            Pin(num='141',name='VAA',do_erc=True),
            Pin(num='132',name='VAA',do_erc=True),
            Pin(num='122',name='VAA',do_erc=True),
            Pin(num='121',name='VAA',do_erc=True),
            Pin(num='120',name='VAA',do_erc=True),
            Pin(num='157',name='GNDA',do_erc=True),
            Pin(num='155',name='GNDA',do_erc=True),
            Pin(num='153',name='GNDA',do_erc=True),
            Pin(num='151',name='GNDA',do_erc=True),
            Pin(num='147',name='GNDA',do_erc=True),
            Pin(num='145',name='GNDA',do_erc=True),
            Pin(num='143',name='GNDA',do_erc=True),
            Pin(num='139',name='GNDA',do_erc=True),
            Pin(num='138',name='GNDA',do_erc=True),
            Pin(num='136',name='GNDA',do_erc=True),
            Pin(num='32',name='ACTIVE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='135',name='R/2',do_erc=True),
            Pin(num='114',name='CLEVEL',do_erc=True),
            Pin(num='118',name='CREF-',do_erc=True),
            Pin(num='137',name='CREF+',do_erc=True),
            Pin(num='7',name='YLEVEL',do_erc=True),
            Pin(num='3',name='YREF-',do_erc=True),
            Pin(num='144',name='YREF+',do_erc=True),
            Pin(num='140',name='SYNC_DET',do_erc=True),
            Pin(num='131',name='VID3_C',do_erc=True),
            Pin(num='150',name='VID3_Y',do_erc=True),
            Pin(num='129',name='VID2_C',do_erc=True),
            Pin(num='152',name='VID2_Y',do_erc=True),
            Pin(num='127',name='VID1_C',do_erc=True),
            Pin(num='154',name='VID1_Y',do_erc=True),
            Pin(num='125',name='VID0_C',do_erc=True),
            Pin(num='156',name='VID0_Y',do_erc=True),
            Pin(num='88',name='TDI',do_erc=True),
            Pin(num='89',name='TMS',do_erc=True),
            Pin(num='90',name='TCLK',do_erc=True),
            Pin(num='47',name='PIXEL_EN',do_erc=True),
            Pin(num='46',name='VTU_EN',do_erc=True),
            Pin(num='107',name='XTAL2_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='106',name='XTAL2_IN',do_erc=True),
            Pin(num='109',name='XTAL1_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='108',name='XTAL1_IN',do_erc=True),
            Pin(num='113',name='REFOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='101',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='105',name='CLKX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='117',name='VIN_C',do_erc=True),
            Pin(num='4',name='VIN_Y/COMP.',do_erc=True),
            Pin(num='37',name='SERROR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='CBFLAG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='29',name='VALID',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='CAPTURE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='HACTIVE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='FIELD_2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='75',name='GND',do_erc=True),
            Pin(num='134',name='GNDA',do_erc=True),
            Pin(num='130',name='GNDA',do_erc=True),
            Pin(num='128',name='GNDA',do_erc=True),
            Pin(num='126',name='GNDA',do_erc=True),
            Pin(num='124',name='GNDA',do_erc=True),
            Pin(num='116',name='GNDA',do_erc=True),
            Pin(num='5',name='GNDA',do_erc=True),
            Pin(num='111',name='GND',do_erc=True),
            Pin(num='103',name='GND',do_erc=True),
            Pin(num='98',name='GND',do_erc=True),
            Pin(num='66',name='GND',do_erc=True),
            Pin(num='119',name='VAA',do_erc=True),
            Pin(num='82',name='VAA',do_erc=True),
            Pin(num='81',name='VAA',do_erc=True),
            Pin(num='80',name='VAA',do_erc=True),
            Pin(num='79',name='VAA',do_erc=True),
            Pin(num='78',name='VAA',do_erc=True),
            Pin(num='43',name='VAA',do_erc=True),
            Pin(num='42',name='VAA',do_erc=True),
            Pin(num='41',name='VAA',do_erc=True),
            Pin(num='40',name='VAA',do_erc=True),
            Pin(num='39',name='VAA',do_erc=True),
            Pin(num='2',name='VAA',do_erc=True),
            Pin(num='1',name='VAA',do_erc=True),
            Pin(num='25',name='FIELD_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='FIELD_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VACTIVE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='VRESET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='OUT_Y',func=Pin.OUTPUT,do_erc=True),
            Pin(num='115',name='OUT_C',func=Pin.OUTPUT,do_erc=True),
            Pin(num='104',name='CLKX1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='87',name='RESET',do_erc=True),
            Pin(num='100',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='99',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='97',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='96',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='95',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='94',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='93',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='92',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='56',name='GND',do_erc=True),
            Pin(num='44',name='GND',do_erc=True),
            Pin(num='30',name='GND',do_erc=True),
            Pin(num='16',name='GND',do_erc=True),
            Pin(num='112',name='VCC',do_erc=True),
            Pin(num='102',name='VCC',do_erc=True),
            Pin(num='76',name='VCC',do_erc=True),
            Pin(num='57',name='VCC',do_erc=True),
            Pin(num='45',name='VCC',do_erc=True),
            Pin(num='31',name='VCC',do_erc=True),
            Pin(num='83',name='WR',do_erc=True),
            Pin(num='86',name='RD',do_erc=True),
            Pin(num='85',name='RS1',do_erc=True),
            Pin(num='84',name='RS0',do_erc=True),
            Pin(num='36',name='HRESET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='B7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='49',name='B6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='50',name='B5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='51',name='B4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='52',name='B3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='53',name='B2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='54',name='B1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='55',name='B0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='67',name='G7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='68',name='G6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='69',name='G5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='70',name='G4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='71',name='G3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='72',name='G2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='73',name='G1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='74',name='G0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='58',name='R7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='59',name='R6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='60',name='R5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='61',name='R4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='62',name='R3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='63',name='R2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='64',name='R1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='65',name='R0',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='BT855',dest=TEMPLATE,tool=SKIDL,keywords='video CDA PAL NTSC',description='Triple CDA PAL/NTSC Y/C',ref_prefix='U',num_units=1,do_erc=True,aliases=['BT858'],pins=[
            Pin(num='66',name='GND',do_erc=True),
            Pin(num='155',name='GND',do_erc=True),
            Pin(num='154',name='GND',do_erc=True),
            Pin(num='150',name='GND',do_erc=True),
            Pin(num='146',name='GND',do_erc=True),
            Pin(num='139',name='GND',do_erc=True),
            Pin(num='126',name='GND',do_erc=True),
            Pin(num='125',name='GND',do_erc=True),
            Pin(num='113',name='GND',do_erc=True),
            Pin(num='101',name='GND',do_erc=True),
            Pin(num='100',name='GND',do_erc=True),
            Pin(num='61',name='GND',do_erc=True),
            Pin(num='152',name='VAA',do_erc=True),
            Pin(num='148',name='VAA',do_erc=True),
            Pin(num='144',name='VAA',do_erc=True),
            Pin(num='142',name='VAA',do_erc=True),
            Pin(num='141',name='VAA',do_erc=True),
            Pin(num='124',name='VAA',do_erc=True),
            Pin(num='123',name='VAA',do_erc=True),
            Pin(num='122',name='VAA',do_erc=True),
            Pin(num='121',name='VAA',do_erc=True),
            Pin(num='103',name='VAA',do_erc=True),
            Pin(num='102',name='VAA',do_erc=True),
            Pin(num='65',name='VAA',do_erc=True),
            Pin(num='64',name='VAA',do_erc=True),
            Pin(num='63',name='VAA',do_erc=True),
            Pin(num='1',name='FIELD_1',do_erc=True),
            Pin(num='160',name='FIELD_0',do_erc=True),
            Pin(num='112',name='F/BLANK',do_erc=True),
            Pin(num='158',name='V/VSYNC',do_erc=True),
            Pin(num='153',name='Y_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='151',name='YCOMP',do_erc=True),
            Pin(num='149',name='C_OUT',do_erc=True),
            Pin(num='147',name='CCOMP',do_erc=True),
            Pin(num='145',name='NTSC/PAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='143',name='NCOMP',do_erc=True),
            Pin(num='138',name='COMP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='137',name='FS_AJUST',do_erc=True),
            Pin(num='140',name='VREF_IN',do_erc=True),
            Pin(num='156',name='CLK_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='111',name='RESET',do_erc=True),
            Pin(num='47',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='48',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='49',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='50',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='51',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='52',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='53',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='54',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='60',name='GND',do_erc=True),
            Pin(num='45',name='GND',do_erc=True),
            Pin(num='26',name='GND',do_erc=True),
            Pin(num='25',name='GND',do_erc=True),
            Pin(num='62',name='VAA',do_erc=True),
            Pin(num='46',name='VAA',do_erc=True),
            Pin(num='28',name='VAA',do_erc=True),
            Pin(num='27',name='VAA',do_erc=True),
            Pin(num='24',name='VAA',do_erc=True),
            Pin(num='23',name='VAA',do_erc=True),
            Pin(num='67',name='CLK_IN',do_erc=True),
            Pin(num='56',name='WR',do_erc=True),
            Pin(num='55',name='RD',do_erc=True),
            Pin(num='59',name='RS2',do_erc=True),
            Pin(num='58',name='RS1',do_erc=True),
            Pin(num='57',name='RS0',do_erc=True),
            Pin(num='157',name='H/HSYNC',do_erc=True),
            Pin(num='159',name='CSYNC',do_erc=True),
            Pin(num='41',name='OL3',do_erc=True),
            Pin(num='42',name='OL2',do_erc=True),
            Pin(num='43',name='OL1',do_erc=True),
            Pin(num='44',name='OL0',do_erc=True),
            Pin(num='20',name='B7',do_erc=True),
            Pin(num='19',name='B6',do_erc=True),
            Pin(num='18',name='B5',do_erc=True),
            Pin(num='17',name='B4',do_erc=True),
            Pin(num='16',name='B3',do_erc=True),
            Pin(num='15',name='B2',do_erc=True),
            Pin(num='14',name='B1',do_erc=True),
            Pin(num='13',name='B0',do_erc=True),
            Pin(num='36',name='G7',do_erc=True),
            Pin(num='35',name='G6',do_erc=True),
            Pin(num='34',name='G5',do_erc=True),
            Pin(num='33',name='G4',do_erc=True),
            Pin(num='32',name='G3',do_erc=True),
            Pin(num='31',name='G2',do_erc=True),
            Pin(num='30',name='G1',do_erc=True),
            Pin(num='29',name='G0',do_erc=True),
            Pin(num='12',name='R7',do_erc=True),
            Pin(num='11',name='R6',do_erc=True),
            Pin(num='10',name='R5',do_erc=True),
            Pin(num='9',name='R4',do_erc=True),
            Pin(num='8',name='R3',do_erc=True),
            Pin(num='7',name='R2',do_erc=True),
            Pin(num='6',name='R1',do_erc=True),
            Pin(num='5',name='R0',do_erc=True)])])
