from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

actel = SchLib(tool=SKIDL).add_parts(*[
        Part(name='A3P030-VQG100',dest=TEMPLATE,tool=SKIDL,keywords='ProASIC3 ACTEL FLASH',description='Actel ProASIC3 Flash Family FPGAs, 256 MCLB, 100pin QFP100',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO82RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO81RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO80RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO79RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO78RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO77RSB1',do_erc=True),
            Pin(num='8',name='IO76RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='IO75RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO67RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO57RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO49RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='IO38RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO30RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='IO20RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='IO12RSB0',do_erc=True),
            Pin(num='11',name='IO74RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO66RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO56RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO47RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='IO37RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='IO29RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='IO19RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='IO10RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='IO73RSB1/GEC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='IO65RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO55RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO46RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VPUMP',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='IO36RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IO28RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='IO18RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='IO08RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO72RSB1/GEA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO64RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO54RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO45RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='GDB0/IO34RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IO27RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO17RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO07RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IO71RSB1/GEB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='IO63RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO53RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO44RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='GDA0/IO33RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='IO26RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO16RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO06RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO70RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='IO62RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='IO52RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO43RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='GDC0/IO32RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='IO25RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO15RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='IO05RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='IO69RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='IO61RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='IO51RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IO42RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VJTAG',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='76',name='IO24RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO14RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO04RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='IO60RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IO41RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='77',name='IO23RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='97',name='IO03RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='IO59RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='IO40RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='78',name='IO22RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='IO02RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO68RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='IO58RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO39RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO31RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='IO21RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='IO01RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='IO00RSB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='A3P060-VQG100',dest=TEMPLATE,tool=SKIDL,keywords='ProASIC3 ACTEL FLASH',description='Actel ProASIC3 Flash Family FPGAs, 512 MCLB, 100pin QFP100',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO51RSB1/GAA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO52RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO53RSB1/GAB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO95RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO94RSB1/GAC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO93RSB1',do_erc=True),
            Pin(num='8',name='IO92RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='IO87RSB1/GFB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO75RSB1/GEB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO67RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO60RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='VMV1',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='GCC2/IO43RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='GBC2/IO29RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='GBC1/IO20RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='IO10RSB0',do_erc=True),
            Pin(num='11',name='IO86RSB1/GFB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO74RSB1/GEB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO66RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO59RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='GCB2/IO42RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='GBB2/IO27RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='GBC0/IO19RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='IO09RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VCOMPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='IO73RSB1/GEA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO65RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO58RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VPUMP',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='GCA0/IO40RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IO26RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='IO18RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='IO08RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO85RSB1/GFA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO72RSB1/GEA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO64RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO57RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='GCA1/IO39RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='GBA2/IO25RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO17RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='GAC1/IO07RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VCCPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VMV1',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='IO63RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO56RSB1/GDC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='GCC0/IO36RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='IO15RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='GAC1/IO06RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO84RSB1/GFA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='IO62RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO55RSB1/GDB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='GCC1/IO35RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='85',name='IO13RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='GAB1/IO05RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='IO83RSB1/GFA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='IO71RSB1/GEA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='IO61RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IO54RSB1/GDA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VJTAG',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='76',name='GBA1/IO24RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO11RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='GAB0/IO04RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='IO70RSB1/GEB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='GDA1/IO49RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='77',name='GBA0/IO23RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='97',name='GAA1/IO03RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='IO69RSB1/GEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='GDC0/IO46RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='78',name='GBB1/IO22RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='GAA0/IO02RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO77RSB1/GEC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='IO68RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='GDC1/IO45RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO31RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='GBB0/IO21RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='IO01RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='IO00RSB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='A3P1000-PQG208',dest=TEMPLATE,tool=SKIDL,keywords='ProASIC3 ACTEL FLASH',description='Actel ProASIC3 Flash Family FPGAs, 1000k Gates, 208pin QFP',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO225PDB3/GAA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO225NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO224PDB3/GAB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO224NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO223PDB3/GAC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO223NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='IO222PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='IO222NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='IO220PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO212NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO206PDB3/GFA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCCIB3',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VMV3',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='IO181RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO166RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='IO148RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='IO128RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IO220NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO209PDB3/GFC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO206NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='IO180RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='IO126RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='IO218PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='IO209NDB3/GFC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO205PDB3/GFB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO191PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='IO143RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='IO124RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO218NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO208PDB3/GFB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO205NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO191NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VMV2',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='IO178RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IO162RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO141RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO122RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IO216PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='IO208NDB3/GFB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO204PDB3/GFC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO190PDB3/GEC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='IO187RSB2/GEA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='IO176RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='IO160RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO139RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO120RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO216NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VCOMPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='IO204NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO190NDB3/GEC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='IO186RSB2/GEB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='IO158RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO137RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='IO118RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='IO207NPB3/GFA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='IO189PDB3/GEB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='IO185RSB2/GEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='IO174RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='IO156RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO135RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO116RSB2/GDC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VCCPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='IO199PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO189NDB3/GEB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IO184RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='IO172RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='IO154RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='IO133RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VCCIB3',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='IO207PPB3/GFA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO199NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO188PDB3/GEA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='IO183RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='IO170RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='IO152RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='IO115RSB2/GDB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO212PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='IO197PSB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='IO188NDB3/GEA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO182RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO168RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='IO150RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='IO114RSB2/GDA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='200',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='110',name='VJTAG',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='IO106PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='140',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='150',name='IO79NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='160',name='GBB1/IO75RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='170',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='180',name='IO35RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='190',name='IO18RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='201',name='GAC1/IO05RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='GDA0/IO113NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='IO104PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='GCA2/IO94PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='151',name='GBB2/IO79PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='161',name='GBB0/IO74RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='171',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='181',name='IO33RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='191',name='IO16RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='202',name='GAC0/IO04RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='GDA1/IO113PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='132',name='GCA1/IO93PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='152',name='IO78NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='162',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='172',name='IO54RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='182',name='IO31RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='192',name='IO15RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='203',name='GAB1/IO03RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='GDB0/IO112NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='133',name='GCA0/IO93NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='IO86PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='153',name='GBA2/IO78PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='163',name='GBC1/IO73RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='173',name='IO51RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='183',name='IO29RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='193',name='IO14RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='VMV2',func=Pin.PWRIN,do_erc=True),
            Pin(num='204',name='GAB0/IO02RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='GDB1/IO112PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='IO99NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='GCB0/IO92NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='IO84NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='154',name='VMV1',func=Pin.PWRIN,do_erc=True),
            Pin(num='164',name='GBC0/IO72RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='174',name='IO48RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='184',name='IO27RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='194',name='IO13RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='205',name='GAA1/IO01RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='GDC0/IO111NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='IO99PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='GCB1/IO92PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='145',name='IO84PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='155',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='165',name='IO70RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='175',name='IO45RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='185',name='IO25RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='195',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='106',name='VPUMP',func=Pin.PWRIN,do_erc=True),
            Pin(num='206',name='GAA0/IO00RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='GDC1/IO111PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='GCC0/IO91NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='146',name='IO82NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='156',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='166',name='IO67RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='176',name='IO42RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='186',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='196',name='IO12RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='107',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='207',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='117',name='IO109NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='IO96NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='GCC1/IO91PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='147',name='IO82PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='157',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='167',name='IO63RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='177',name='IO40RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='187',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='197',name='IO11RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='208',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='118',name='IO109PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='GCC2/IO96PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='138',name='IO88NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='148',name='IO80NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='158',name='GBA1/IO77RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='168',name='IO60RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='178',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='188',name='IO22RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='198',name='IO10RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='IO106NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='GCB2/IO95PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='IO88PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='149',name='GBC2/IO80PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='159',name='GBA0/IO76RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='169',name='IO57RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='179',name='IO38RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='189',name='IO20RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='199',name='IO09RSB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='A3P125-PQG208',dest=TEMPLATE,tool=SKIDL,keywords='ProASIC3 ACTEL FLASH',description='Actel ProASIC3 Flash Family FPGAs, 1024MCB, 208pin QFP',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO67RSB1/GAA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO68RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO69RSB1/GAB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO132RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO131RSB1/GAC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='IO130RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='IO129RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO120RSB1/GFA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VMV1',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='IO101RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO93RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='IO85RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='IO78RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO126RSB1/GFC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='IO100RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='IO77RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='IO128RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='IO125RSB1/GFC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO119RSB1/GFB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO114RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='IO84RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='IO76RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO124RSB1/GFB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO113RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='IO99RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IO92RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO83RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO75RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='IO123RSB1/GFB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO118RSB1/GFC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO112RSB1/GEC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='IO98RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='IO91RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO82RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO74RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VCOMPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='IO117RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO111RSB1/GEC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='IO106RSB1/GEA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='IO90RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO81RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='IO73RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='IO122RSB1/GFA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IO110RSB1/GEB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='IO105RSB1/GEB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='IO97RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='IO89RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO80RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO72RSB1/GDC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VCCPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='IO116PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO109PDB1/GEB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IO104RSB1/GEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='IO96RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='IO88RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='IO79RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='IO121RSB1/GFA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO115RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO108RSB1/GEA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='IO103RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='IO95RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='IO87RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='IO71RSB1/GDB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO127RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='IO107RSB1/GEA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO102RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO94RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='IO86RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='IO70RSB1/GDA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='200',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='110',name='VJTAG',func=Pin.PWRIN,do_erc=True),
            Pin(num='130',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='140',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='150',name='IO44RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='160',name='GBB1/IO38RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='170',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='180',name='IO22RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='190',name='IO14RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='201',name='GAC1/IO05RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='GDA0/IO66RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='GCA2/IO57RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='151',name='GBB2/IO43RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='161',name='GBB0/IO37RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='171',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='181',name='IO21RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='191',name='IO13RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='202',name='GAC0/IO04RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='GDA1/IO65RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='132',name='GCA0/IO56RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='152',name='IO42RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='162',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='172',name='IO29RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='182',name='IO20RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='192',name='IO12RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='203',name='GAB1/IO03RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='GDB0/IO64RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='133',name='GCA1/IO55RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='IO48RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='153',name='GBA2/IO41RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='163',name='GBC1/IO36RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='173',name='IO28RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='183',name='IO19RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='193',name='IO11RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='VMV1',func=Pin.PWRIN,do_erc=True),
            Pin(num='204',name='GAB0/IO02RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='GDB1/IO63RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='GCB0/IO54RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='IO47RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='154',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='164',name='GBC0/IO35RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='174',name='IO27RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='184',name='IO18RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='194',name='IO10RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='205',name='GAA1/IO01RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='GDC0/IO62RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='GCB1/IO53RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='145',name='IO46RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='155',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='165',name='IO34RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='175',name='IO26RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='185',name='IO17RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='195',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='106',name='VPUMP',func=Pin.PWRIN,do_erc=True),
            Pin(num='206',name='GAA0/IO00RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='GDC1/IO61RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='136',name='GCC0/IO52RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='156',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='166',name='IO33RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='176',name='IO25RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='186',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='196',name='IO09RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='207',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='127',name='IO60RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='GCC1/IO51RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='167',name='IO32RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='177',name='IO24RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='187',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='197',name='IO08RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='208',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='128',name='GCC2/IO59RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='138',name='IO50RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='158',name='GBA1/IO40RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='168',name='IO31RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='178',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='188',name='IO16RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='198',name='IO07RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='GCB2/IO58RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='IO49RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='149',name='GBC2/IO45RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='159',name='GBA0/IO39RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='169',name='IO30RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='179',name='IO23RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='189',name='IO15RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='199',name='IO06RSB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='A3P125-VQG100',dest=TEMPLATE,tool=SKIDL,keywords='ProASIC3 ACTEL FLASH',description='Actel ProASIC3 Flash Family FPGAs, 1024 MCLB, 100pin QFP100',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO67RSB1/GAA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO68RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO69RSB1/GAB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO132RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO131RSB1/GAC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO130RSB1',do_erc=True),
            Pin(num='8',name='IO129RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='IO124RSB1/GFB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO110RSB1/GEB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO100RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO87RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='VMV1',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='GCC2/IO59RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='GBC2/IO45RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='GBC1/IO36RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='IO15RSB0',do_erc=True),
            Pin(num='11',name='IO123RSB1/GFB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO109RSB1/GEB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO99RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO84RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='GCB2/IO58RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='GBB2/IO43RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='GBC0/IO35RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='IO13RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VCOMPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='IO108RSB1/GEA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO97RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO81RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VPUMP',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='GCA0/IO56RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IO42RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='IO32RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='IO11RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO122RSB1/GFA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO107RSB1/GEA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO96RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO75RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='GCA1/IO55RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='GBA2/IO41RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO28RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO09RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VCCPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VMV1',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='IO95RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO72RSB1/GDC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='GCC0/IO52RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='IO25RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO07RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO121RSB1/GFA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='IO94RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO71RSB1/GDB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='GCC1/IO51RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='85',name='IO22RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='GAC1/IO05RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='IO120RSB1/GFA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='IO106RSB1/GEA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='IO93RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IO70RSB1/GDA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='VJTAG',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='76',name='GBA1/IO40RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO19RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='GAC0/IO04RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='IO105RSB1/GEB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='GDA1/IO65RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='77',name='GBA0/IO39RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='97',name='GAB1/IO03RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='IO104RSB1/GEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='GDC0/IO62RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='78',name='GBB1/IO38RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='GAB0/IO02RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO111RSB1/GEC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='IO102RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='GDC1/IO61RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO47RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='GBB0/IO37RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='GAA1/IO01RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='GAA0/IO00RSB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='A3P250-PQG208',dest=TEMPLATE,tool=SKIDL,keywords='ProASIC3 ACTEL FLASH',description='Actel ProASIC3 Flash Family FPGAs, 2048MCB, 208pin QFP',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO118UDB3/GAA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO118VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO117UDB3/GAB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO117VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO116UDB3/GAC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO116VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='IO115UDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='IO115VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='IO114UDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO111NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO107PDB3/GFA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCCIB3',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VMV3',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='IO92RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO84RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='IO76RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='IO69RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IO114VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO110PDB3/GFC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO107NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='IO91RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='IO68RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='IO113PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='IO110NDB3/GFC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO106PDB3/GFB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO101PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='IO75RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='IO67RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO113NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO109PDB3/GFB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO106NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO101NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='IO90RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IO83RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO74RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO66RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IO112PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='IO109NDB3/GFB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO105PDB3/GFC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO100PDB3/GEC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='IO89RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='IO82RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO73RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO65RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO112NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VCOMPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='IO105NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO100NDB3/GEC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='IO97RSB2/GEA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='IO81RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO72RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='IO64RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='IO108NPB3/GFA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IO99PDB3/GEB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='IO96RSB2/GEB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='IO88RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='IO80RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO71RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO63RSB2/GDC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VCCPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='IO104PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO99NDB3/GEB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IO95RSB2/GEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='IO87RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='IO79RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='IO70RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VCCIB3',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='IO108PPB3/GFA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO104NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO98PDB3/GEA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='IO94RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='IO86RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='IO78RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='IO62RSB2/GDB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO111PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='IO103PSB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='IO98NDB3/GEA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO93RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO85RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='IO77RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='IO61RSB2/GDA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='200',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='110',name='VJTAG',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='IO56PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='140',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='150',name='IO42NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='160',name='GBB1/IO38RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='170',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='180',name='IO22RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='190',name='IO14RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='201',name='GAC1/IO05RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='GDA0/IO60VDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='IO55RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='GCA2/IO51PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='151',name='GBB2/IO42PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='161',name='GBB0/IO37RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='171',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='181',name='IO21RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='191',name='IO13RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='202',name='GAC0/IO04RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='GDA1/IO60UDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='132',name='GCA1/IO50PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='152',name='IO41NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='162',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='172',name='IO29RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='182',name='IO20RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='192',name='IO12RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='203',name='GAB1/IO03RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='GDB0/IO59VDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='133',name='GCA0/IO50NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='IO46RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='153',name='GBA2/IO41PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='163',name='GBC1/IO36RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='173',name='IO28RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='183',name='IO19RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='193',name='IO11RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='VMV2',func=Pin.PWRIN,do_erc=True),
            Pin(num='204',name='GAB0/IO02RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='GDB1/IO59UDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='GCB0/IO49NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='IO45NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='154',name='VMV1',func=Pin.PWRIN,do_erc=True),
            Pin(num='164',name='GBC0/IO35RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='174',name='IO27RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='184',name='IO18RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='194',name='IO10RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='205',name='GAA1/IO01RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='GDC0/IO58VDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='GCB1/IO49PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='145',name='IO45PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='155',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='165',name='IO34RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='175',name='IO26RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='185',name='IO17RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='195',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='106',name='VPUMP',func=Pin.PWRIN,do_erc=True),
            Pin(num='206',name='GAA0/IO00RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='GDC1/IO58UDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='136',name='GCC0/IO48NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='146',name='IO44NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='156',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='166',name='IO33RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='176',name='IO25RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='186',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='196',name='IO09RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='207',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='117',name='IO57VDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='IO53NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='GCC1/IO48PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='147',name='IO44PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='167',name='IO32RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='177',name='IO24RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='187',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='197',name='IO08RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='208',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='118',name='IO57UDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='GCC2/IO53PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='138',name='IO47NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='148',name='IO43NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='158',name='GBA1/IO40RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='168',name='IO31RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='178',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='188',name='IO16RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='198',name='IO07RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='IO56NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='GCB2/IO52PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='IO47PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='149',name='GBC2/IO43PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='159',name='GBA0/IO39RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='169',name='IO30RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='179',name='IO23RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='189',name='IO15RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='199',name='IO06RSB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='A3P250-VQG100',dest=TEMPLATE,tool=SKIDL,keywords='ProASIC3 ACTEL FLASH',description='Actel ProASIC3 Flash Family FPGAs, 2048 MCLB, 100pin QFP100',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='IO118UDB3/GAA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO118VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO117UDB3/GAB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO117VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO116UDB3/GAC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO116VDB3',do_erc=True),
            Pin(num='8',name='IO112PSB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='10',name='IO109PDB3/GFB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO100PDB3/GEC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO92RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO77RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='VMV2',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='IO52NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='GBC2/IO43PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='GBC1/IO36RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='IO15RSB0',do_erc=True),
            Pin(num='11',name='IO109NDB3/GFB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO100NDB3/GEC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO91RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO74RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='61',name='GCB2/IO52PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='GBB2/IO42PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='GBC0/IO35RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='IO13RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VCOMPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='IO98PDB3/GEA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO90RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO71RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VPUMP',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='GCA1/IO50PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IO41NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='IO29RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='IO11RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO108NPB3/GFA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO98NDB3/GEA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO88RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO63RSB2/GDC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='GCA0/IO50NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='GBA2/IO41PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO27RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='GAC1/IO05RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VCCPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VMV3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO86RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO62RSB2/GDB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='GCC0/IO48NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='VMV1',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO25RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='GAC0/IO04RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO108PPB3/GFA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GNDQ',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='IO85RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO61RSB2/GDA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='GCC1/IO48PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='GNDQ',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO23RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='GAB1/IO03RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='IO107PSB3/GFA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='IO97RSB2/GEA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='IO84RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='GNDQ',func=Pin.PWROUT,do_erc=True),
            Pin(num='56',name='VJTAG',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='VCCIB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='GBA1/IO40RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO21RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='GAB0/IO02RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='IO96RSB2/GEB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='GDA1/IO60USB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='77',name='GBA0/IO39RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='97',name='GAA1/IO01RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCCIB3',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='IO95RSB2/GEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='48',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='GDC0/IO58VDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='78',name='GBB1/IO38RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='98',name='GAA0/IO00RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO105PSB3/GFC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='IO93RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='GDC1/IO58UDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO43NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='GBB0/IO37RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='GNDQ',func=Pin.PWROUT,do_erc=True),
            Pin(num='100',name='VMV0',func=Pin.PWRIN,do_erc=True)]),
        Part(name='A3P400-PQG208',dest=TEMPLATE,tool=SKIDL,keywords='ProASIC3 ACTEL FLASH',description='Actel ProASIC3 Flash Family FPGAs, 400k Gates, 208pin QFP',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO155UDB3/GAA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO155VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO154UDB3/GAB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO154VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO153UDB3/GAC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO153VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='IO152UDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='IO152VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='IO151UDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO148NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO144PDB3/GFA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCCIB3',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VMV3',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='IO129RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO113RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='IO104RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='IO94RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IO151VDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO147PDB3/GFC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO144NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='IO128RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='IO92RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='IO150PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='IO147NDB3/GFC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO143PDB3/GFB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO138PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='IO102RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='IO90RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO150NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO146PDB3/GFB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO143NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO138NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VMV2',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='IO125RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IO112RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO101RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO88RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IO149PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='IO146NDB3/GFB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO142PDB3/GFC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO137PDB3/GEC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='IO123RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='IO111RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO100RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO86RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO149NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VCOMPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='IO142NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO137NDB3/GEC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='IO134RSB2/GEA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='IO110RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO99RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='IO84RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='IO145NPB3/GFA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IO136PDB3/GEB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='IO133RSB2/GEB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='IO121RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='IO109RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO98RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO82RSB2/GDC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VCCPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='IO141PSB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO136NDB3/GEB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IO132RSB2/GEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='IO119RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='IO108RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='IO97RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VCCIB3',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='IO145PPB3/GFA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO140PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO135PDB3/GEA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='IO131RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='IO117RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='IO107RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='IO81RSB2/GDB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO148PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='IO140NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='IO135NDB3/GEA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO130RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO115RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='IO106RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='IO80RSB2/GDA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='200',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='110',name='VJTAG',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='IO75PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='140',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='150',name='IO61NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='160',name='GBB1/IO57RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='170',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='180',name='IO28RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='190',name='IO19RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='201',name='GAC1/IO05RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='GDA0/IO79VDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='IO74RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='GCA2/IO70PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='151',name='GBB2/IO61PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='161',name='GBB0/IO56RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='171',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='181',name='IO27RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='191',name='IO18RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='202',name='GAC0/IO04RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='GDA1/IO79UDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='132',name='GCA1/IO69PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='152',name='IO60NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='162',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='172',name='IO36RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='182',name='IO26RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='192',name='IO17RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='203',name='GAB1/IO03RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='GDB0/IO78VDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='133',name='GCA0/IO69NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='IO65RSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='153',name='GBA2/IO60PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='163',name='GBC1/IO55RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='173',name='IO35RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='183',name='IO25RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='193',name='IO16RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='VMV2',func=Pin.PWRIN,do_erc=True),
            Pin(num='204',name='GAB0/IO02RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='GDB1/IO78UDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='GCB0/IO68NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='IO64NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='154',name='VMV1',func=Pin.PWRIN,do_erc=True),
            Pin(num='164',name='GBC0/IO54RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='174',name='IO34RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='184',name='IO24RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='194',name='IO15RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='205',name='GAA1/IO01RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='GDC0/IO77VDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='GCB1/IO68PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='145',name='IO64PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='155',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='165',name='IO52RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='175',name='IO33RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='185',name='IO23RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='195',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='106',name='VPUMP',func=Pin.PWRIN,do_erc=True),
            Pin(num='206',name='GAA0/IO00RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='GDC1/IO77UDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='136',name='GCC0/IO67NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='146',name='IO63NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='156',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='166',name='IO49RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='176',name='IO32RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='186',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='196',name='IO13RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='207',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='117',name='IO76VDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='IO72NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='GCC1/IO67PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='147',name='IO63PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='157',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='167',name='IO46RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='177',name='IO31RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='187',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='197',name='IO11RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='208',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='118',name='IO76UDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='GCC2/IO72PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='138',name='IO66NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='148',name='IO62NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='158',name='GBA1/IO59RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='168',name='IO43RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='178',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='188',name='IO21RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='198',name='IO09RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='IO75NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='GCB2/IO71PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='IO66PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='149',name='GBC2/IO62PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='159',name='GBA0/IO58RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='169',name='IO40RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='179',name='IO29RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='189',name='IO20RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='199',name='IO07RSB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='A3P600-PQG208',dest=TEMPLATE,tool=SKIDL,keywords='ProASIC3 ACTEL FLASH',description='Actel ProASIC3 Flash Family FPGAs, 600k Gates, 208pin QFP',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO174PDB3/GAA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO174NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO173PDB3/GAB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO173NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO172PDB3/GAC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO172NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='IO171PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='IO171NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='IO170PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO166NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO161PDB3/GFA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCCIB3',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='VMV3',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='IO137RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO123RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='IO112RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='IO104RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IO170NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO164PDB3/GFC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO161NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='IO136RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='IO102RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='IO169PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='IO164NDB3/GFC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO160PDB3/GFB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO147PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='IO111RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='IO100RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO169NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO163PDB3/GFB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO160NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO147NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VMV2',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='IO135RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IO120RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO110RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO98RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IO168PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='IO163NDB3/GFB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO159PDB3/GFC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO146PDB3/GEC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='IO143RSB2/GEA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='IO133RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='IO119RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO109RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO96RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO168NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VCOMPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='IO159NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO146NDB3/GEC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='IO142RSB2/GEB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='IO118RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO108RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='IO92RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='IO162NPB3/GFA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='IO145PDB3/GEB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='IO141RSB2/GEC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='IO131RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='IO117RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO107RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO91RSB2/GDC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='VCCPLF',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='IO152PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO145NDB3/GEB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IO140RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='IO129RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='IO116RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='IO106RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VCCIB3',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='IO162PPB3/GFA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO152NDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO144PDB3/GEA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='IO139RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='IO127RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='IO115RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='IO90RSB2/GDB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO166PDB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='IO150PSB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='IO144NDB3/GEA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO138RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO125RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='IO114RSB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='VCCIB2',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='IO89RSB2/GDA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='200',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='110',name='VJTAG',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='IO82PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='140',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='150',name='IO61NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='160',name='GBB1/IO57RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='170',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='180',name='IO28RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='190',name='IO18RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='201',name='GAC1/IO05RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='GDA0/IO88NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='IO81PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='GCA2/IO72PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='151',name='GBB2/IO61PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='161',name='GBB0/IO56RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='171',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='181',name='IO27RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='191',name='IO17RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='202',name='GAC0/IO04RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='GDA1/IO88PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='132',name='GCA1/IO71PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='152',name='IO60NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='162',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='172',name='IO36RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='182',name='IO26RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='192',name='IO16RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='203',name='GAB1/IO03RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='GDB0/IO87NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='VCCIB1',func=Pin.PWRIN,do_erc=True),
            Pin(num='133',name='GCA0/IO71NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='IO65PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='153',name='GBA2/IO60PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='163',name='GBC1/IO55RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='173',name='IO35RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='183',name='IO25RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='193',name='IO14RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='VMV2',func=Pin.PWRIN,do_erc=True),
            Pin(num='204',name='GAB0/IO02RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='GDB1/IO87PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='IO77NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='GCB0/IO70NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='IO64NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='154',name='VMV1',func=Pin.PWRIN,do_erc=True),
            Pin(num='164',name='GBC0/IO54RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='174',name='IO34RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='184',name='IO24RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='194',name='IO12RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='205',name='GAA1/IO01RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='GDC0/IO86NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='IO77PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='GCB1/IO70PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='145',name='IO64PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='155',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='165',name='IO52RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='175',name='IO33RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='185',name='IO23RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='195',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='106',name='VPUMP',func=Pin.PWRIN,do_erc=True),
            Pin(num='206',name='GAA0/IO00RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='GDC1/IO86PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='GCC0/IO69NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='146',name='IO63NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='156',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='166',name='IO50RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='176',name='IO32RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='186',name='VCCIB0',func=Pin.PWRIN,do_erc=True),
            Pin(num='196',name='IO10RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='107',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='207',name='GNDQ',func=Pin.PWRIN,do_erc=True),
            Pin(num='117',name='IO84NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='IO74NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='GCC1/IO69PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='147',name='IO63PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='157',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='167',name='IO48RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='177',name='IO31RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='187',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='197',name='IO09RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='208',name='VMV0',func=Pin.PWRIN,do_erc=True),
            Pin(num='118',name='IO84PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='GCC2/IO74PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='138',name='IO67NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='148',name='IO62NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='158',name='GBA1/IO59RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='168',name='IO46RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='178',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='188',name='IO20RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='198',name='IO08RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='IO82NDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='GCB2/IO73PSB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='IO67PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='149',name='GBC2/IO62PDB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='159',name='GBA0/IO58RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='169',name='IO44RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='179',name='IO29RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='189',name='IO19RSB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='199',name='IO07RSB0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='ACT1020PL44',dest=TEMPLATE,tool=SKIDL,keywords='Actel FPGA',description='ACT1020-PL44, Actel ACT1 FPGA, PLCC-44',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='IO1',do_erc=True),
            Pin(num='2',name='IO2',do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IO4',do_erc=True),
            Pin(num='5',name='IO5',do_erc=True),
            Pin(num='6',name='IO6',do_erc=True),
            Pin(num='7',name='IO7',do_erc=True),
            Pin(num='8',name='IO8',do_erc=True),
            Pin(num='9',name='IO9',do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='IO20',do_erc=True),
            Pin(num='30',name='IO30',do_erc=True),
            Pin(num='40',name='IO40',do_erc=True),
            Pin(num='11',name='IO11',do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='IO31',do_erc=True),
            Pin(num='41',name='IO41',do_erc=True),
            Pin(num='12',name='IO12',do_erc=True),
            Pin(num='22',name='IO22',do_erc=True),
            Pin(num='32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='IO42',do_erc=True),
            Pin(num='13',name='IO13',do_erc=True),
            Pin(num='23',name='IO23',do_erc=True),
            Pin(num='33',name='IO-CLK',do_erc=True),
            Pin(num='43',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='IO24',do_erc=True),
            Pin(num='34',name='MODE',do_erc=True),
            Pin(num='44',name='IO44',do_erc=True),
            Pin(num='15',name='IO15',do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='IO26',do_erc=True),
            Pin(num='36',name='SDI-IO36',do_erc=True),
            Pin(num='17',name='IO17',do_erc=True),
            Pin(num='27',name='IO27',do_erc=True),
            Pin(num='37',name='DCLK-IO37',do_erc=True),
            Pin(num='18',name='IO18',do_erc=True),
            Pin(num='28',name='IO28',do_erc=True),
            Pin(num='38',name='PRA-IO38',do_erc=True),
            Pin(num='19',name='IO19',do_erc=True),
            Pin(num='29',name='IO29',do_erc=True),
            Pin(num='39',name='PRB-IO39',do_erc=True)]),
        Part(name='ACT1020PL68',dest=TEMPLATE,tool=SKIDL,keywords='Actel FPGA',description='ACT1020-PL68, Actel ACT1 FPGA, PLCC-68',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='IO1',do_erc=True),
            Pin(num='2',name='IO2',do_erc=True),
            Pin(num='3',name='IO3',do_erc=True),
            Pin(num='4',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='IO5',do_erc=True),
            Pin(num='6',name='IO6',do_erc=True),
            Pin(num='7',name='IO7',do_erc=True),
            Pin(num='8',name='IO8',do_erc=True),
            Pin(num='9',name='IO9',do_erc=True),
            Pin(num='10',name='IO10',do_erc=True),
            Pin(num='20',name='IO20',do_erc=True),
            Pin(num='30',name='IO30',do_erc=True),
            Pin(num='40',name='IO40',do_erc=True),
            Pin(num='50',name='IO50',do_erc=True),
            Pin(num='60',name='IO60',do_erc=True),
            Pin(num='11',name='IO11',do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='IO31',do_erc=True),
            Pin(num='41',name='IO41',do_erc=True),
            Pin(num='51',name='IO51',do_erc=True),
            Pin(num='61',name='IO61',do_erc=True),
            Pin(num='12',name='IO12',do_erc=True),
            Pin(num='22',name='IO22',do_erc=True),
            Pin(num='32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='IO42',do_erc=True),
            Pin(num='52',name='CLK',do_erc=True),
            Pin(num='62',name='IO62',do_erc=True),
            Pin(num='13',name='IO13',do_erc=True),
            Pin(num='23',name='IO23',do_erc=True),
            Pin(num='33',name='IO33',do_erc=True),
            Pin(num='43',name='IO43',do_erc=True),
            Pin(num='53',name='IO53',do_erc=True),
            Pin(num='63',name='IO63',do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='IO24',do_erc=True),
            Pin(num='34',name='IO34',do_erc=True),
            Pin(num='44',name='IO44',do_erc=True),
            Pin(num='54',name='MODE',do_erc=True),
            Pin(num='64',name='IO64',do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='IO35',do_erc=True),
            Pin(num='45',name='IO45',do_erc=True),
            Pin(num='55',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='IO65',do_erc=True),
            Pin(num='16',name='IO16',do_erc=True),
            Pin(num='26',name='IO26',do_erc=True),
            Pin(num='36',name='IO36',do_erc=True),
            Pin(num='46',name='IO46',do_erc=True),
            Pin(num='56',name='SDI',do_erc=True),
            Pin(num='66',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='IO17',do_erc=True),
            Pin(num='27',name='IO27',do_erc=True),
            Pin(num='37',name='IO37',do_erc=True),
            Pin(num='47',name='IO47',do_erc=True),
            Pin(num='57',name='DCLK',do_erc=True),
            Pin(num='67',name='IO67',do_erc=True),
            Pin(num='18',name='IO18',do_erc=True),
            Pin(num='28',name='IO28',do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='IO48',do_erc=True),
            Pin(num='58',name='PRA',do_erc=True),
            Pin(num='68',name='IO68',do_erc=True),
            Pin(num='19',name='IO19',do_erc=True),
            Pin(num='29',name='IO29',do_erc=True),
            Pin(num='39',name='IO39',do_erc=True),
            Pin(num='49',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='59',name='PRB',do_erc=True)]),
        Part(name='ACT1225PL84',dest=TEMPLATE,tool=SKIDL,keywords='Actel FPGA',description='ACT1225-PL84, Actel ACT1 FPGA, PLCC-84',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='IO1',do_erc=True),
            Pin(num='2',name='CLKB',do_erc=True),
            Pin(num='3',name='IO3',do_erc=True),
            Pin(num='4',name='PRBB',do_erc=True),
            Pin(num='5',name='IO5',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='IO7',do_erc=True),
            Pin(num='8',name='IO8',do_erc=True),
            Pin(num='9',name='IO9',do_erc=True),
            Pin(num='10',name='DCLK',do_erc=True),
            Pin(num='20',name='IO20',do_erc=True),
            Pin(num='30',name='IO30',do_erc=True),
            Pin(num='40',name='IO40',do_erc=True),
            Pin(num='50',name='IO50',do_erc=True),
            Pin(num='60',name='IO60',do_erc=True),
            Pin(num='70',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='80',name='IO80',do_erc=True),
            Pin(num='11',name='IO11',do_erc=True),
            Pin(num='21',name='IO21',do_erc=True),
            Pin(num='31',name='IO31',do_erc=True),
            Pin(num='41',name='IO41',do_erc=True),
            Pin(num='51',name='IO51',do_erc=True),
            Pin(num='61',name='IO61',do_erc=True),
            Pin(num='71',name='IO71',do_erc=True),
            Pin(num='81',name='PRBA',do_erc=True),
            Pin(num='12',name='MODE',do_erc=True),
            Pin(num='22',name='VSV',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='IO32',do_erc=True),
            Pin(num='42',name='IO42',do_erc=True),
            Pin(num='52',name='SDO',do_erc=True),
            Pin(num='62',name='IO62',do_erc=True),
            Pin(num='72',name='IO72',do_erc=True),
            Pin(num='82',name='IO82',do_erc=True),
            Pin(num='13',name='IO13',do_erc=True),
            Pin(num='23',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='IO33',do_erc=True),
            Pin(num='43',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='53',name='IO53',do_erc=True),
            Pin(num='63',name='VKS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='73',name='IO73',do_erc=True),
            Pin(num='83',name='CLKA',do_erc=True),
            Pin(num='14',name='IO14',do_erc=True),
            Pin(num='24',name='IO24',do_erc=True),
            Pin(num='34',name='BIN/IN',do_erc=True),
            Pin(num='44',name='IO44',do_erc=True),
            Pin(num='54',name='IO54',do_erc=True),
            Pin(num='64',name='VPP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='74',name='IO74',do_erc=True),
            Pin(num='84',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='IO15',do_erc=True),
            Pin(num='25',name='IO25',do_erc=True),
            Pin(num='35',name='BIN/OUT',do_erc=True),
            Pin(num='45',name='IO45',do_erc=True),
            Pin(num='55',name='IO55',do_erc=True),
            Pin(num='65',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='IO75',do_erc=True),
            Pin(num='16',name='IO16',do_erc=True),
            Pin(num='26',name='IO26',do_erc=True),
            Pin(num='36',name='IO36',do_erc=True),
            Pin(num='46',name='IO46',do_erc=True),
            Pin(num='56',name='IO56',do_erc=True),
            Pin(num='66',name='IO66',do_erc=True),
            Pin(num='76',name='SDI',do_erc=True),
            Pin(num='17',name='IO17',do_erc=True),
            Pin(num='27',name='IO27',do_erc=True),
            Pin(num='37',name='IO37',do_erc=True),
            Pin(num='47',name='IO47',do_erc=True),
            Pin(num='57',name='IO57',do_erc=True),
            Pin(num='67',name='IO67',do_erc=True),
            Pin(num='77',name='IO77',do_erc=True),
            Pin(num='18',name='IO18',do_erc=True),
            Pin(num='28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='IO38',do_erc=True),
            Pin(num='48',name='IO48',do_erc=True),
            Pin(num='58',name='IO58',do_erc=True),
            Pin(num='68',name='IO68',do_erc=True),
            Pin(num='78',name='IO78',do_erc=True),
            Pin(num='19',name='IO19',do_erc=True),
            Pin(num='29',name='IO29',do_erc=True),
            Pin(num='39',name='IO39',do_erc=True),
            Pin(num='49',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='59',name='IO59',do_erc=True),
            Pin(num='69',name='IO69',do_erc=True),
            Pin(num='79',name='IO79',do_erc=True)]),
        Part(name='ACTEL-JTAG-10',dest=TEMPLATE,tool=SKIDL,keywords='JTAG IDC10 Male Connector',description='ACTEL FLASH PRO 3/4, JTAG, IDC10 Male Connector',ref_prefix='CON',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='~',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='~',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='EX128-TQ100',dest=TEMPLATE,tool=SKIDL,keywords='Actel FPGA eX eX128',description='Actel eX FPGA Family, 100pin QFP',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS',do_erc=True),
            Pin(num='8',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='92',name='PRA/IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO/PRB',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='IO/TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='77',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='CLKA',do_erc=True),
            Pin(num='97',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='68',name='GND/LP',func=Pin.PWRIN,do_erc=True),
            Pin(num='78',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='CLKB',do_erc=True),
            Pin(num='98',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='HCLK',do_erc=True),
            Pin(num='49',name='IO/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='79',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='TCK/IO',func=Pin.BIDIR,do_erc=True)]),
        Part(name='EX128-TQ64',dest=TEMPLATE,tool=SKIDL,keywords='Actel FPGA eX eX128',description='Actel eX Family FPGA, 64pin QFP',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='IO/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TMS',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IO/TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO/PRB',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='TDO/IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='43',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='24',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TCK/IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='HCLK',do_erc=True),
            Pin(num='35',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='GND/LP',func=Pin.PWROUT,do_erc=True),
            Pin(num='55',name='CLKA',do_erc=True),
            Pin(num='16',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='56',name='CLKB',do_erc=True),
            Pin(num='17',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='19',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PRA/IO',func=Pin.BIDIR,do_erc=True)]),
        Part(name='EX256-TQ100',dest=TEMPLATE,tool=SKIDL,keywords='Actel FPGA eX eX256',description='Actel eX FPGA Family, 100pin QFP',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IO/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS',do_erc=True),
            Pin(num='8',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='92',name='PRA/IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO/PRB',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='IO/TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='VSV',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='77',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='CLKA',do_erc=True),
            Pin(num='97',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='68',name='GND/LP',func=Pin.PWRIN,do_erc=True),
            Pin(num='78',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='CLKB',do_erc=True),
            Pin(num='98',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='HCLK',do_erc=True),
            Pin(num='49',name='IO/TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='79',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='TCK/IO',func=Pin.BIDIR,do_erc=True)]),
        Part(name='EX64-TQ100',dest=TEMPLATE,tool=SKIDL,keywords='Actel FPGA eX eX64',description='Actel eX Family FPGA, 100pin QFP',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='IO/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='TMS',do_erc=True),
            Pin(num='8',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='20',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='71',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='92',name='PRA/IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO/PRB',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='IO/TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='46',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='77',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='CLKA',do_erc=True),
            Pin(num='97',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='68',name='GND/LP',func=Pin.PWROUT,do_erc=True),
            Pin(num='78',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='CLKB',do_erc=True),
            Pin(num='98',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='HCLK',do_erc=True),
            Pin(num='49',name='TDO/IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='79',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='TCK/IO',func=Pin.BIDIR,do_erc=True)]),
        Part(name='EX64-TQ64',dest=TEMPLATE,tool=SKIDL,keywords='Actel FPGA eX eX64',description='Actel eX Family FPGA, 64pin QFP',ref_prefix='U',num_units=1,fplist=['*QFP*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='IO/TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='TMS',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IO/TRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO/PRB',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='TDO/IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='43',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='24',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TCK/IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='HCLK',do_erc=True),
            Pin(num='35',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='GND/LP',func=Pin.PWROUT,do_erc=True),
            Pin(num='55',name='CLKA',do_erc=True),
            Pin(num='16',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VSV',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='56',name='CLKB',do_erc=True),
            Pin(num='17',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='VCCA',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='19',name='VCCI',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PRA/IO',func=Pin.BIDIR,do_erc=True)])])
