from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

Lattice = SchLib(tool=SKIDL).add_parts(*[
        Part(name='GAL16V8',dest=TEMPLATE,tool=SKIDL,keywords='GAL PLD 16V8',description='Programmable Logic Array, DIP-20/SOIC-20/PLCC-20',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*', 'SOIC*', 'SO*', 'PLCC*'],do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='I1/CLK',do_erc=True),
            Pin(num='2',name='I2',do_erc=True),
            Pin(num='3',name='I3',do_erc=True),
            Pin(num='4',name='I4',do_erc=True),
            Pin(num='5',name='I5',do_erc=True),
            Pin(num='6',name='I6',do_erc=True),
            Pin(num='7',name='I7',do_erc=True),
            Pin(num='8',name='I8',do_erc=True),
            Pin(num='9',name='I9',do_erc=True),
            Pin(num='11',name='I10/~OE~',do_erc=True),
            Pin(num='12',name='IO8',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='IO7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='IO6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='IO5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='IO4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='I03',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='IO2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='IO1',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='PAL16L8',dest=TEMPLATE,tool=SKIDL,keywords='PAL PLD 16L8',description='Programmable Logic Array, DIP-20',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='I1',do_erc=True),
            Pin(num='2',name='I2',do_erc=True),
            Pin(num='3',name='I3',do_erc=True),
            Pin(num='4',name='I4',do_erc=True),
            Pin(num='5',name='I5',do_erc=True),
            Pin(num='6',name='I6',do_erc=True),
            Pin(num='7',name='I7',do_erc=True),
            Pin(num='8',name='I8',do_erc=True),
            Pin(num='9',name='I9',do_erc=True),
            Pin(num='11',name='I10',do_erc=True),
            Pin(num='12',name='IO8',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='IO7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='IO6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='IO5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='IO4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='I03',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='IO2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='IO1',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='PAL20L8',dest=TEMPLATE,tool=SKIDL,keywords='PAL PLD 20L8',description='Programmable Logic Array, DIP-24',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='I1',do_erc=True),
            Pin(num='2',name='I2',do_erc=True),
            Pin(num='3',name='I3',do_erc=True),
            Pin(num='4',name='I4',do_erc=True),
            Pin(num='5',name='I5',do_erc=True),
            Pin(num='6',name='I6',do_erc=True),
            Pin(num='7',name='I7',do_erc=True),
            Pin(num='8',name='I8',do_erc=True),
            Pin(num='9',name='I9',do_erc=True),
            Pin(num='10',name='I10',do_erc=True),
            Pin(num='20',name='I020',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='I11',do_erc=True),
            Pin(num='21',name='IO21',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='IO22',func=Pin.TRISTATE,do_erc=True),
            Pin(num='13',name='I13',do_erc=True),
            Pin(num='23',name='I23',do_erc=True),
            Pin(num='14',name='I14',do_erc=True),
            Pin(num='15',name='IO15',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='IO16',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='IO17',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='IO18',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='IO19',func=Pin.TRISTATE,do_erc=True)]),
        Part(name='PAL20RS10',dest=TEMPLATE,tool=SKIDL,keywords='PAL PLD 20RS10',description='Programmable Logic Array, DIP-24 (Narrow)',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='CLK',do_erc=True),
            Pin(num='2',name='I0',do_erc=True),
            Pin(num='3',name='I1',do_erc=True),
            Pin(num='4',name='I2',do_erc=True),
            Pin(num='5',name='I3',do_erc=True),
            Pin(num='6',name='I4',do_erc=True),
            Pin(num='7',name='I5',do_erc=True),
            Pin(num='8',name='I6',do_erc=True),
            Pin(num='9',name='I7',do_erc=True),
            Pin(num='10',name='I8',do_erc=True),
            Pin(num='20',name='O3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='I9',do_erc=True),
            Pin(num='21',name='O2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='O1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~OE~',do_erc=True),
            Pin(num='23',name='O0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='O9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='O8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='O7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='O6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='O5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='O4',func=Pin.OUTPUT,do_erc=True)])])
