# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BucketAccessRules',
    'BucketTag',
    'CertificateTag',
    'Container',
    'ContainerEnvironmentVariable',
    'ContainerHealthCheckConfig',
    'ContainerPortInfo',
    'ContainerPublicDomainName',
    'ContainerPublicEndpoint',
    'ContainerServiceDeployment',
    'ContainerTag',
    'DatabaseRelationalDatabaseParameter',
    'DatabaseTag',
    'DiskAddOn',
    'DiskAutoSnapshotAddOn',
    'DiskLocation',
    'DiskTag',
    'DistributionCacheBehavior',
    'DistributionCacheBehaviorPerPath',
    'DistributionCacheSettings',
    'DistributionCookieObject',
    'DistributionHeaderObject',
    'DistributionInputOrigin',
    'DistributionQueryStringObject',
    'DistributionTag',
    'InstanceAddOn',
    'InstanceAutoSnapshotAddOn',
    'InstanceDisk',
    'InstanceHardware',
    'InstanceLocation',
    'InstanceMonthlyTransfer',
    'InstanceNetworking',
    'InstancePort',
    'InstanceState',
    'InstanceTag',
    'LoadBalancerTag',
]

@pulumi.output_type
class BucketAccessRules(dict):
    """
    An object that sets the public accessibility of objects in the specified bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPublicOverrides":
            suggest = "allow_public_overrides"
        elif key == "getObject":
            suggest = "get_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAccessRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAccessRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAccessRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_public_overrides: Optional[bool] = None,
                 get_object: Optional[str] = None):
        """
        An object that sets the public accessibility of objects in the specified bucket.
        :param bool allow_public_overrides: A Boolean value that indicates whether the access control list (ACL) permissions that are applied to individual objects override the getObject option that is currently specified.
        :param str get_object: Specifies the anonymous access to all objects in a bucket.
        """
        if allow_public_overrides is not None:
            pulumi.set(__self__, "allow_public_overrides", allow_public_overrides)
        if get_object is not None:
            pulumi.set(__self__, "get_object", get_object)

    @property
    @pulumi.getter(name="allowPublicOverrides")
    def allow_public_overrides(self) -> Optional[bool]:
        """
        A Boolean value that indicates whether the access control list (ACL) permissions that are applied to individual objects override the getObject option that is currently specified.
        """
        return pulumi.get(self, "allow_public_overrides")

    @property
    @pulumi.getter(name="getObject")
    def get_object(self) -> Optional[str]:
        """
        Specifies the anonymous access to all objects in a bucket.
        """
        return pulumi.get(self, "get_object")


@pulumi.output_type
class BucketTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: Optional[str] = None):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CertificateTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: Optional[str] = None):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class Container(dict):
    """
    Describes the settings of a container that will be launched, or that is launched, to an Amazon Lightsail container service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Container. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Container.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Container.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Optional[Sequence[str]] = None,
                 container_name: Optional[str] = None,
                 environment: Optional[Sequence['outputs.ContainerEnvironmentVariable']] = None,
                 image: Optional[str] = None,
                 ports: Optional[Sequence['outputs.ContainerPortInfo']] = None):
        """
        Describes the settings of a container that will be launched, or that is launched, to an Amazon Lightsail container service.
        :param Sequence[str] command: The launch command for the container.
        :param str container_name: The name of the container.
        :param Sequence['ContainerEnvironmentVariable'] environment: The environment variables of the container.
        :param str image: The name of the image used for the container.
        :param Sequence['ContainerPortInfo'] ports: The open firewall ports of the container.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[str]]:
        """
        The launch command for the container.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        The name of the container.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Sequence['outputs.ContainerEnvironmentVariable']]:
        """
        The environment variables of the container.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        The name of the image used for the container.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.ContainerPortInfo']]:
        """
        The open firewall ports of the container.
        """
        return pulumi.get(self, "ports")


@pulumi.output_type
class ContainerEnvironmentVariable(dict):
    def __init__(__self__, *,
                 value: Optional[str] = None,
                 variable: Optional[str] = None):
        if value is not None:
            pulumi.set(__self__, "value", value)
        if variable is not None:
            pulumi.set(__self__, "variable", variable)

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def variable(self) -> Optional[str]:
        return pulumi.get(self, "variable")


@pulumi.output_type
class ContainerHealthCheckConfig(dict):
    """
    Describes the health check configuration of an Amazon Lightsail container service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "intervalSeconds":
            suggest = "interval_seconds"
        elif key == "successCodes":
            suggest = "success_codes"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerHealthCheckConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerHealthCheckConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerHealthCheckConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 healthy_threshold: Optional[int] = None,
                 interval_seconds: Optional[int] = None,
                 path: Optional[str] = None,
                 success_codes: Optional[str] = None,
                 timeout_seconds: Optional[int] = None,
                 unhealthy_threshold: Optional[int] = None):
        """
        Describes the health check configuration of an Amazon Lightsail container service.
        :param int healthy_threshold: The number of consecutive health checks successes required before moving the container to the Healthy state. The default value is 2.
        :param int interval_seconds: The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. The default value is 5.
        :param str path: The path on the container on which to perform the health check. The default value is /.
        :param str success_codes: The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. You can specify multiple values (for example, 200,202) or a range of values (for example, 200-299).
        :param int timeout_seconds: The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. The default value is 2.
        :param int unhealthy_threshold: The number of consecutive health check failures required before moving the container to the Unhealthy state. The default value is 2.
        """
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if interval_seconds is not None:
            pulumi.set(__self__, "interval_seconds", interval_seconds)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if success_codes is not None:
            pulumi.set(__self__, "success_codes", success_codes)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[int]:
        """
        The number of consecutive health checks successes required before moving the container to the Healthy state. The default value is 2.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter(name="intervalSeconds")
    def interval_seconds(self) -> Optional[int]:
        """
        The approximate interval, in seconds, between health checks of an individual container. You can specify between 5 and 300 seconds. The default value is 5.
        """
        return pulumi.get(self, "interval_seconds")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path on the container on which to perform the health check. The default value is /.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="successCodes")
    def success_codes(self) -> Optional[str]:
        """
        The HTTP codes to use when checking for a successful response from a container. You can specify values between 200 and 499. You can specify multiple values (for example, 200,202) or a range of values (for example, 200-299).
        """
        return pulumi.get(self, "success_codes")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        The amount of time, in seconds, during which no response means a failed health check. You can specify between 2 and 60 seconds. The default value is 2.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[int]:
        """
        The number of consecutive health check failures required before moving the container to the Unhealthy state. The default value is 2.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class ContainerPortInfo(dict):
    def __init__(__self__, *,
                 port: Optional[str] = None,
                 protocol: Optional[str] = None):
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerPublicDomainName(dict):
    """
    The public domain name to use with the container service, such as example.com and www.example.com.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateName":
            suggest = "certificate_name"
        elif key == "domainNames":
            suggest = "domain_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPublicDomainName. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPublicDomainName.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPublicDomainName.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_name: Optional[str] = None,
                 domain_names: Optional[Sequence[str]] = None):
        """
        The public domain name to use with the container service, such as example.com and www.example.com.
        :param Sequence[str] domain_names: An object that describes the configuration for the containers of the deployment.
        """
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[str]:
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[Sequence[str]]:
        """
        An object that describes the configuration for the containers of the deployment.
        """
        return pulumi.get(self, "domain_names")


@pulumi.output_type
class ContainerPublicEndpoint(dict):
    """
    Describes the settings of a public endpoint for an Amazon Lightsail container service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "healthCheckConfig":
            suggest = "health_check_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPublicEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPublicEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPublicEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[str] = None,
                 container_port: Optional[int] = None,
                 health_check_config: Optional['outputs.ContainerHealthCheckConfig'] = None):
        """
        Describes the settings of a public endpoint for an Amazon Lightsail container service.
        :param str container_name: The name of the container for the endpoint.
        :param int container_port: The port of the container to which traffic is forwarded to.
        :param 'ContainerHealthCheckConfig' health_check_config: An object that describes the health check configuration of the container.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if health_check_config is not None:
            pulumi.set(__self__, "health_check_config", health_check_config)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[str]:
        """
        The name of the container for the endpoint.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[int]:
        """
        The port of the container to which traffic is forwarded to.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="healthCheckConfig")
    def health_check_config(self) -> Optional['outputs.ContainerHealthCheckConfig']:
        """
        An object that describes the health check configuration of the container.
        """
        return pulumi.get(self, "health_check_config")


@pulumi.output_type
class ContainerServiceDeployment(dict):
    """
    Describes a container deployment configuration of an Amazon Lightsail container service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicEndpoint":
            suggest = "public_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerServiceDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerServiceDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerServiceDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.Container']] = None,
                 public_endpoint: Optional['outputs.ContainerPublicEndpoint'] = None):
        """
        Describes a container deployment configuration of an Amazon Lightsail container service.
        :param Sequence['Container'] containers: An object that describes the configuration for the containers of the deployment.
        :param 'ContainerPublicEndpoint' public_endpoint: An object that describes the endpoint of the deployment.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if public_endpoint is not None:
            pulumi.set(__self__, "public_endpoint", public_endpoint)

    @property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.Container']]:
        """
        An object that describes the configuration for the containers of the deployment.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional['outputs.ContainerPublicEndpoint']:
        """
        An object that describes the endpoint of the deployment.
        """
        return pulumi.get(self, "public_endpoint")


@pulumi.output_type
class ContainerTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: Optional[str] = None):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DatabaseRelationalDatabaseParameter(dict):
    """
    Describes the parameters of the database.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedValues":
            suggest = "allowed_values"
        elif key == "applyMethod":
            suggest = "apply_method"
        elif key == "applyType":
            suggest = "apply_type"
        elif key == "dataType":
            suggest = "data_type"
        elif key == "isModifiable":
            suggest = "is_modifiable"
        elif key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseRelationalDatabaseParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseRelationalDatabaseParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseRelationalDatabaseParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_values: Optional[str] = None,
                 apply_method: Optional[str] = None,
                 apply_type: Optional[str] = None,
                 data_type: Optional[str] = None,
                 description: Optional[str] = None,
                 is_modifiable: Optional[bool] = None,
                 parameter_name: Optional[str] = None,
                 parameter_value: Optional[str] = None):
        """
        Describes the parameters of the database.
        :param str allowed_values: Specifies the valid range of values for the parameter.
        :param str apply_method: Indicates when parameter updates are applied. Can be immediate or pending-reboot.
        :param str apply_type: Specifies the engine-specific parameter type.
        :param str data_type: Specifies the valid data type for the parameter.
        :param str description: Provides a description of the parameter.
        :param bool is_modifiable: A Boolean value indicating whether the parameter can be modified.
        :param str parameter_name: Specifies the name of the parameter.
        :param str parameter_value: Specifies the value of the parameter.
        """
        if allowed_values is not None:
            pulumi.set(__self__, "allowed_values", allowed_values)
        if apply_method is not None:
            pulumi.set(__self__, "apply_method", apply_method)
        if apply_type is not None:
            pulumi.set(__self__, "apply_type", apply_type)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_modifiable is not None:
            pulumi.set(__self__, "is_modifiable", is_modifiable)
        if parameter_name is not None:
            pulumi.set(__self__, "parameter_name", parameter_name)
        if parameter_value is not None:
            pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Optional[str]:
        """
        Specifies the valid range of values for the parameter.
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="applyMethod")
    def apply_method(self) -> Optional[str]:
        """
        Indicates when parameter updates are applied. Can be immediate or pending-reboot.
        """
        return pulumi.get(self, "apply_method")

    @property
    @pulumi.getter(name="applyType")
    def apply_type(self) -> Optional[str]:
        """
        Specifies the engine-specific parameter type.
        """
        return pulumi.get(self, "apply_type")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[str]:
        """
        Specifies the valid data type for the parameter.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Provides a description of the parameter.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isModifiable")
    def is_modifiable(self) -> Optional[bool]:
        """
        A Boolean value indicating whether the parameter can be modified.
        """
        return pulumi.get(self, "is_modifiable")

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> Optional[str]:
        """
        Specifies the name of the parameter.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> Optional[str]:
        """
        Specifies the value of the parameter.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class DatabaseTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: Optional[str] = None):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DiskAddOn(dict):
    """
    A addon associate with a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addOnType":
            suggest = "add_on_type"
        elif key == "autoSnapshotAddOnRequest":
            suggest = "auto_snapshot_add_on_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_on_type: str,
                 auto_snapshot_add_on_request: Optional['outputs.DiskAutoSnapshotAddOn'] = None,
                 status: Optional['DiskAddOnStatus'] = None):
        """
        A addon associate with a resource.
        :param str add_on_type: The add-on type
        :param 'DiskAddOnStatus' status: Status of the Addon
        """
        pulumi.set(__self__, "add_on_type", add_on_type)
        if auto_snapshot_add_on_request is not None:
            pulumi.set(__self__, "auto_snapshot_add_on_request", auto_snapshot_add_on_request)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="addOnType")
    def add_on_type(self) -> str:
        """
        The add-on type
        """
        return pulumi.get(self, "add_on_type")

    @property
    @pulumi.getter(name="autoSnapshotAddOnRequest")
    def auto_snapshot_add_on_request(self) -> Optional['outputs.DiskAutoSnapshotAddOn']:
        return pulumi.get(self, "auto_snapshot_add_on_request")

    @property
    @pulumi.getter
    def status(self) -> Optional['DiskAddOnStatus']:
        """
        Status of the Addon
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DiskAutoSnapshotAddOn(dict):
    """
    An object that represents additional parameters when enabling or modifying the automatic snapshot add-on
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotTimeOfDay":
            suggest = "snapshot_time_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskAutoSnapshotAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskAutoSnapshotAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskAutoSnapshotAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_time_of_day: Optional[str] = None):
        """
        An object that represents additional parameters when enabling or modifying the automatic snapshot add-on
        :param str snapshot_time_of_day: The daily time when an automatic snapshot will be created.
        """
        if snapshot_time_of_day is not None:
            pulumi.set(__self__, "snapshot_time_of_day", snapshot_time_of_day)

    @property
    @pulumi.getter(name="snapshotTimeOfDay")
    def snapshot_time_of_day(self) -> Optional[str]:
        """
        The daily time when an automatic snapshot will be created.
        """
        return pulumi.get(self, "snapshot_time_of_day")


@pulumi.output_type
class DiskLocation(dict):
    """
    Location of a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "regionName":
            suggest = "region_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[str] = None,
                 region_name: Optional[str] = None):
        """
        Location of a resource.
        :param str availability_zone: The Availability Zone in which to create your disk. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        :param str region_name: The Region Name in which to create your disk.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        The Availability Zone in which to create your disk. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[str]:
        """
        The Region Name in which to create your disk.
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class DiskTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: Optional[str] = None):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DistributionCacheBehavior(dict):
    """
    Describes the default cache behavior of an Amazon Lightsail content delivery network (CDN) distribution.
    """
    def __init__(__self__, *,
                 behavior: Optional[str] = None):
        """
        Describes the default cache behavior of an Amazon Lightsail content delivery network (CDN) distribution.
        :param str behavior: The cache behavior of the distribution.
        """
        if behavior is not None:
            pulumi.set(__self__, "behavior", behavior)

    @property
    @pulumi.getter
    def behavior(self) -> Optional[str]:
        """
        The cache behavior of the distribution.
        """
        return pulumi.get(self, "behavior")


@pulumi.output_type
class DistributionCacheBehaviorPerPath(dict):
    """
    Describes the per-path cache behavior of an Amazon Lightsail content delivery network (CDN) distribution.
    """
    def __init__(__self__, *,
                 behavior: Optional[str] = None,
                 path: Optional[str] = None):
        """
        Describes the per-path cache behavior of an Amazon Lightsail content delivery network (CDN) distribution.
        :param str behavior: The cache behavior for the specified path.
        :param str path: The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify wildcard directories (path/to/assets/*), and file types (*.html, *jpg, *js). Directories and file paths are case-sensitive.
        """
        if behavior is not None:
            pulumi.set(__self__, "behavior", behavior)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def behavior(self) -> Optional[str]:
        """
        The cache behavior for the specified path.
        """
        return pulumi.get(self, "behavior")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to a directory or file to cached, or not cache. Use an asterisk symbol to specify wildcard directories (path/to/assets/*), and file types (*.html, *jpg, *js). Directories and file paths are case-sensitive.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class DistributionCacheSettings(dict):
    """
    Describes the cache settings of an Amazon Lightsail content delivery network (CDN) distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHTTPMethods":
            suggest = "allowed_http_methods"
        elif key == "cachedHTTPMethods":
            suggest = "cached_http_methods"
        elif key == "defaultTTL":
            suggest = "default_ttl"
        elif key == "forwardedCookies":
            suggest = "forwarded_cookies"
        elif key == "forwardedHeaders":
            suggest = "forwarded_headers"
        elif key == "forwardedQueryStrings":
            suggest = "forwarded_query_strings"
        elif key == "maximumTTL":
            suggest = "maximum_ttl"
        elif key == "minimumTTL":
            suggest = "minimum_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCacheSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCacheSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCacheSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_http_methods: Optional[str] = None,
                 cached_http_methods: Optional[str] = None,
                 default_ttl: Optional[int] = None,
                 forwarded_cookies: Optional['outputs.DistributionCookieObject'] = None,
                 forwarded_headers: Optional['outputs.DistributionHeaderObject'] = None,
                 forwarded_query_strings: Optional['outputs.DistributionQueryStringObject'] = None,
                 maximum_ttl: Optional[int] = None,
                 minimum_ttl: Optional[int] = None):
        """
        Describes the cache settings of an Amazon Lightsail content delivery network (CDN) distribution.
        :param str allowed_http_methods: The HTTP methods that are processed and forwarded to the distribution's origin.
        :param str cached_http_methods: The HTTP method responses that are cached by your distribution.
        :param int default_ttl: The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
        :param 'DistributionCookieObject' forwarded_cookies: An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded.
        :param 'DistributionHeaderObject' forwarded_headers: An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded.
        :param 'DistributionQueryStringObject' forwarded_query_strings: An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded.
        :param int maximum_ttl: The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        :param int minimum_ttl: The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        """
        if allowed_http_methods is not None:
            pulumi.set(__self__, "allowed_http_methods", allowed_http_methods)
        if cached_http_methods is not None:
            pulumi.set(__self__, "cached_http_methods", cached_http_methods)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if forwarded_cookies is not None:
            pulumi.set(__self__, "forwarded_cookies", forwarded_cookies)
        if forwarded_headers is not None:
            pulumi.set(__self__, "forwarded_headers", forwarded_headers)
        if forwarded_query_strings is not None:
            pulumi.set(__self__, "forwarded_query_strings", forwarded_query_strings)
        if maximum_ttl is not None:
            pulumi.set(__self__, "maximum_ttl", maximum_ttl)
        if minimum_ttl is not None:
            pulumi.set(__self__, "minimum_ttl", minimum_ttl)

    @property
    @pulumi.getter(name="allowedHTTPMethods")
    def allowed_http_methods(self) -> Optional[str]:
        """
        The HTTP methods that are processed and forwarded to the distribution's origin.
        """
        return pulumi.get(self, "allowed_http_methods")

    @property
    @pulumi.getter(name="cachedHTTPMethods")
    def cached_http_methods(self) -> Optional[str]:
        """
        The HTTP method responses that are cached by your distribution.
        """
        return pulumi.get(self, "cached_http_methods")

    @property
    @pulumi.getter(name="defaultTTL")
    def default_ttl(self) -> Optional[int]:
        """
        The default amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the content has been updated.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="forwardedCookies")
    def forwarded_cookies(self) -> Optional['outputs.DistributionCookieObject']:
        """
        An object that describes the cookies that are forwarded to the origin. Your content is cached based on the cookies that are forwarded.
        """
        return pulumi.get(self, "forwarded_cookies")

    @property
    @pulumi.getter(name="forwardedHeaders")
    def forwarded_headers(self) -> Optional['outputs.DistributionHeaderObject']:
        """
        An object that describes the headers that are forwarded to the origin. Your content is cached based on the headers that are forwarded.
        """
        return pulumi.get(self, "forwarded_headers")

    @property
    @pulumi.getter(name="forwardedQueryStrings")
    def forwarded_query_strings(self) -> Optional['outputs.DistributionQueryStringObject']:
        """
        An object that describes the query strings that are forwarded to the origin. Your content is cached based on the query strings that are forwarded.
        """
        return pulumi.get(self, "forwarded_query_strings")

    @property
    @pulumi.getter(name="maximumTTL")
    def maximum_ttl(self) -> Optional[int]:
        """
        The maximum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        """
        return pulumi.get(self, "maximum_ttl")

    @property
    @pulumi.getter(name="minimumTTL")
    def minimum_ttl(self) -> Optional[int]:
        """
        The minimum amount of time that objects stay in the distribution's cache before the distribution forwards another request to the origin to determine whether the object has been updated.
        """
        return pulumi.get(self, "minimum_ttl")


@pulumi.output_type
class DistributionCookieObject(dict):
    """
    Describes whether an Amazon Lightsail content delivery network (CDN) distribution forwards cookies to the origin and, if so, which ones.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookiesAllowList":
            suggest = "cookies_allow_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionCookieObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionCookieObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionCookieObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookies_allow_list: Optional[Sequence[str]] = None,
                 option: Optional[str] = None):
        """
        Describes whether an Amazon Lightsail content delivery network (CDN) distribution forwards cookies to the origin and, if so, which ones.
        :param Sequence[str] cookies_allow_list: The specific cookies to forward to your distribution's origin.
        :param str option: Specifies which cookies to forward to the distribution's origin for a cache behavior: all, none, or allow-list to forward only the cookies specified in the cookiesAllowList parameter.
        """
        if cookies_allow_list is not None:
            pulumi.set(__self__, "cookies_allow_list", cookies_allow_list)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter(name="cookiesAllowList")
    def cookies_allow_list(self) -> Optional[Sequence[str]]:
        """
        The specific cookies to forward to your distribution's origin.
        """
        return pulumi.get(self, "cookies_allow_list")

    @property
    @pulumi.getter
    def option(self) -> Optional[str]:
        """
        Specifies which cookies to forward to the distribution's origin for a cache behavior: all, none, or allow-list to forward only the cookies specified in the cookiesAllowList parameter.
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class DistributionHeaderObject(dict):
    """
    Describes the request headers that a Lightsail distribution bases caching on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headersAllowList":
            suggest = "headers_allow_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionHeaderObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionHeaderObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionHeaderObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 headers_allow_list: Optional[Sequence[str]] = None,
                 option: Optional[str] = None):
        """
        Describes the request headers that a Lightsail distribution bases caching on.
        :param Sequence[str] headers_allow_list: The specific headers to forward to your distribution's origin.
        :param str option: The headers that you want your distribution to forward to your origin and base caching on.
        """
        if headers_allow_list is not None:
            pulumi.set(__self__, "headers_allow_list", headers_allow_list)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter(name="headersAllowList")
    def headers_allow_list(self) -> Optional[Sequence[str]]:
        """
        The specific headers to forward to your distribution's origin.
        """
        return pulumi.get(self, "headers_allow_list")

    @property
    @pulumi.getter
    def option(self) -> Optional[str]:
        """
        The headers that you want your distribution to forward to your origin and base caching on.
        """
        return pulumi.get(self, "option")


@pulumi.output_type
class DistributionInputOrigin(dict):
    """
    Describes the origin resource of an Amazon Lightsail content delivery network (CDN) distribution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolPolicy":
            suggest = "protocol_policy"
        elif key == "regionName":
            suggest = "region_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionInputOrigin. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionInputOrigin.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionInputOrigin.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 protocol_policy: Optional[str] = None,
                 region_name: Optional[str] = None):
        """
        Describes the origin resource of an Amazon Lightsail content delivery network (CDN) distribution.
        :param str name: The name of the origin resource.
        :param str protocol_policy: The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
        :param str region_name: The AWS Region name of the origin resource.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol_policy is not None:
            pulumi.set(__self__, "protocol_policy", protocol_policy)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the origin resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protocolPolicy")
    def protocol_policy(self) -> Optional[str]:
        """
        The protocol that your Amazon Lightsail distribution uses when establishing a connection with your origin to pull content.
        """
        return pulumi.get(self, "protocol_policy")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[str]:
        """
        The AWS Region name of the origin resource.
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class DistributionQueryStringObject(dict):
    """
    Describes the query string parameters that an Amazon Lightsail content delivery network (CDN) distribution to bases caching on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStringsAllowList":
            suggest = "query_strings_allow_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionQueryStringObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionQueryStringObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionQueryStringObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 option: Optional[bool] = None,
                 query_strings_allow_list: Optional[Sequence[str]] = None):
        """
        Describes the query string parameters that an Amazon Lightsail content delivery network (CDN) distribution to bases caching on.
        :param bool option: Indicates whether the distribution forwards and caches based on query strings.
        :param Sequence[str] query_strings_allow_list: The specific query strings that the distribution forwards to the origin.
        """
        if option is not None:
            pulumi.set(__self__, "option", option)
        if query_strings_allow_list is not None:
            pulumi.set(__self__, "query_strings_allow_list", query_strings_allow_list)

    @property
    @pulumi.getter
    def option(self) -> Optional[bool]:
        """
        Indicates whether the distribution forwards and caches based on query strings.
        """
        return pulumi.get(self, "option")

    @property
    @pulumi.getter(name="queryStringsAllowList")
    def query_strings_allow_list(self) -> Optional[Sequence[str]]:
        """
        The specific query strings that the distribution forwards to the origin.
        """
        return pulumi.get(self, "query_strings_allow_list")


@pulumi.output_type
class DistributionTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: Optional[str] = None):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class InstanceAddOn(dict):
    """
    A addon associate with a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addOnType":
            suggest = "add_on_type"
        elif key == "autoSnapshotAddOnRequest":
            suggest = "auto_snapshot_add_on_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_on_type: str,
                 auto_snapshot_add_on_request: Optional['outputs.InstanceAutoSnapshotAddOn'] = None,
                 status: Optional['InstanceAddOnStatus'] = None):
        """
        A addon associate with a resource.
        :param str add_on_type: The add-on type
        :param 'InstanceAddOnStatus' status: Status of the Addon
        """
        pulumi.set(__self__, "add_on_type", add_on_type)
        if auto_snapshot_add_on_request is not None:
            pulumi.set(__self__, "auto_snapshot_add_on_request", auto_snapshot_add_on_request)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="addOnType")
    def add_on_type(self) -> str:
        """
        The add-on type
        """
        return pulumi.get(self, "add_on_type")

    @property
    @pulumi.getter(name="autoSnapshotAddOnRequest")
    def auto_snapshot_add_on_request(self) -> Optional['outputs.InstanceAutoSnapshotAddOn']:
        return pulumi.get(self, "auto_snapshot_add_on_request")

    @property
    @pulumi.getter
    def status(self) -> Optional['InstanceAddOnStatus']:
        """
        Status of the Addon
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InstanceAutoSnapshotAddOn(dict):
    """
    An object that represents additional parameters when enabling or modifying the automatic snapshot add-on
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snapshotTimeOfDay":
            suggest = "snapshot_time_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAutoSnapshotAddOn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAutoSnapshotAddOn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAutoSnapshotAddOn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 snapshot_time_of_day: Optional[str] = None):
        """
        An object that represents additional parameters when enabling or modifying the automatic snapshot add-on
        :param str snapshot_time_of_day: The daily time when an automatic snapshot will be created.
        """
        if snapshot_time_of_day is not None:
            pulumi.set(__self__, "snapshot_time_of_day", snapshot_time_of_day)

    @property
    @pulumi.getter(name="snapshotTimeOfDay")
    def snapshot_time_of_day(self) -> Optional[str]:
        """
        The daily time when an automatic snapshot will be created.
        """
        return pulumi.get(self, "snapshot_time_of_day")


@pulumi.output_type
class InstanceDisk(dict):
    """
    Disk associated with the Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskName":
            suggest = "disk_name"
        elif key == "attachedTo":
            suggest = "attached_to"
        elif key == "attachmentState":
            suggest = "attachment_state"
        elif key == "iOPS":
            suggest = "i_ops"
        elif key == "isSystemDisk":
            suggest = "is_system_disk"
        elif key == "sizeInGb":
            suggest = "size_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_name: str,
                 path: str,
                 attached_to: Optional[str] = None,
                 attachment_state: Optional[str] = None,
                 i_ops: Optional[int] = None,
                 is_system_disk: Optional[bool] = None,
                 size_in_gb: Optional[str] = None):
        """
        Disk associated with the Instance.
        :param str disk_name: The names to use for your new Lightsail disk.
        :param str path: Path of the disk attached to the instance.
        :param str attached_to: Instance attached to the disk.
        :param str attachment_state: Attachment state of the disk.
        :param int i_ops: IOPS of disk.
        :param bool is_system_disk: Is the Attached disk is the system disk of the Instance.
        :param str size_in_gb: Size of the disk attached to the Instance.
        """
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "path", path)
        if attached_to is not None:
            pulumi.set(__self__, "attached_to", attached_to)
        if attachment_state is not None:
            pulumi.set(__self__, "attachment_state", attachment_state)
        if i_ops is not None:
            pulumi.set(__self__, "i_ops", i_ops)
        if is_system_disk is not None:
            pulumi.set(__self__, "is_system_disk", is_system_disk)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> str:
        """
        The names to use for your new Lightsail disk.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path of the disk attached to the instance.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="attachedTo")
    def attached_to(self) -> Optional[str]:
        """
        Instance attached to the disk.
        """
        return pulumi.get(self, "attached_to")

    @property
    @pulumi.getter(name="attachmentState")
    def attachment_state(self) -> Optional[str]:
        """
        Attachment state of the disk.
        """
        return pulumi.get(self, "attachment_state")

    @property
    @pulumi.getter(name="iOPS")
    def i_ops(self) -> Optional[int]:
        """
        IOPS of disk.
        """
        return pulumi.get(self, "i_ops")

    @property
    @pulumi.getter(name="isSystemDisk")
    def is_system_disk(self) -> Optional[bool]:
        """
        Is the Attached disk is the system disk of the Instance.
        """
        return pulumi.get(self, "is_system_disk")

    @property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[str]:
        """
        Size of the disk attached to the Instance.
        """
        return pulumi.get(self, "size_in_gb")


@pulumi.output_type
class InstanceHardware(dict):
    """
    Hardware of the Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCount":
            suggest = "cpu_count"
        elif key == "ramSizeInGb":
            suggest = "ram_size_in_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceHardware. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceHardware.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceHardware.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_count: Optional[int] = None,
                 disks: Optional[Sequence['outputs.InstanceDisk']] = None,
                 ram_size_in_gb: Optional[int] = None):
        """
        Hardware of the Instance.
        :param int cpu_count: CPU count of the Instance.
        :param Sequence['InstanceDisk'] disks: Disks attached to the Instance.
        :param int ram_size_in_gb: RAM Size of the Instance.
        """
        if cpu_count is not None:
            pulumi.set(__self__, "cpu_count", cpu_count)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if ram_size_in_gb is not None:
            pulumi.set(__self__, "ram_size_in_gb", ram_size_in_gb)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> Optional[int]:
        """
        CPU count of the Instance.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter
    def disks(self) -> Optional[Sequence['outputs.InstanceDisk']]:
        """
        Disks attached to the Instance.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="ramSizeInGb")
    def ram_size_in_gb(self) -> Optional[int]:
        """
        RAM Size of the Instance.
        """
        return pulumi.get(self, "ram_size_in_gb")


@pulumi.output_type
class InstanceLocation(dict):
    """
    Location of a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "regionName":
            suggest = "region_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[str] = None,
                 region_name: Optional[str] = None):
        """
        Location of a resource.
        :param str availability_zone: The Availability Zone in which to create your instance. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        :param str region_name: The Region Name in which to create your instance.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if region_name is not None:
            pulumi.set(__self__, "region_name", region_name)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        The Availability Zone in which to create your instance. Use the following format: us-east-2a (case sensitive). Be sure to add the include Availability Zones parameter to your request.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> Optional[str]:
        """
        The Region Name in which to create your instance.
        """
        return pulumi.get(self, "region_name")


@pulumi.output_type
class InstanceMonthlyTransfer(dict):
    """
    Monthly Transfer of the Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gbPerMonthAllocated":
            suggest = "gb_per_month_allocated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMonthlyTransfer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMonthlyTransfer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMonthlyTransfer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gb_per_month_allocated: Optional[str] = None):
        """
        Monthly Transfer of the Instance.
        :param str gb_per_month_allocated: GbPerMonthAllocated of the Instance.
        """
        if gb_per_month_allocated is not None:
            pulumi.set(__self__, "gb_per_month_allocated", gb_per_month_allocated)

    @property
    @pulumi.getter(name="gbPerMonthAllocated")
    def gb_per_month_allocated(self) -> Optional[str]:
        """
        GbPerMonthAllocated of the Instance.
        """
        return pulumi.get(self, "gb_per_month_allocated")


@pulumi.output_type
class InstanceNetworking(dict):
    """
    Networking of the Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthlyTransfer":
            suggest = "monthly_transfer"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworking. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworking.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworking.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ports: Sequence['outputs.InstancePort'],
                 monthly_transfer: Optional['outputs.InstanceMonthlyTransfer'] = None):
        """
        Networking of the Instance.
        :param Sequence['InstancePort'] ports: Ports to the Instance.
        """
        pulumi.set(__self__, "ports", ports)
        if monthly_transfer is not None:
            pulumi.set(__self__, "monthly_transfer", monthly_transfer)

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.InstancePort']:
        """
        Ports to the Instance.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="monthlyTransfer")
    def monthly_transfer(self) -> Optional['outputs.InstanceMonthlyTransfer']:
        return pulumi.get(self, "monthly_transfer")


@pulumi.output_type
class InstancePort(dict):
    """
    Port of the Instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessDirection":
            suggest = "access_direction"
        elif key == "accessFrom":
            suggest = "access_from"
        elif key == "accessType":
            suggest = "access_type"
        elif key == "cidrListAliases":
            suggest = "cidr_list_aliases"
        elif key == "commonName":
            suggest = "common_name"
        elif key == "fromPort":
            suggest = "from_port"
        elif key == "ipv6Cidrs":
            suggest = "ipv6_cidrs"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstancePort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstancePort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstancePort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_direction: Optional[str] = None,
                 access_from: Optional[str] = None,
                 access_type: Optional[str] = None,
                 cidr_list_aliases: Optional[Sequence[str]] = None,
                 cidrs: Optional[Sequence[str]] = None,
                 common_name: Optional[str] = None,
                 from_port: Optional[int] = None,
                 ipv6_cidrs: Optional[Sequence[str]] = None,
                 protocol: Optional[str] = None,
                 to_port: Optional[int] = None):
        """
        Port of the Instance.
        :param str access_direction: Access Direction for Protocol of the Instance(inbound/outbound).
        :param str access_from: Access From Protocol of the Instance.
        :param str access_type: Access Type Protocol of the Instance.
        :param str common_name: CommonName for Protocol of the Instance.
        :param int from_port: From Port of the Instance.
        :param str protocol: Port Protocol of the Instance.
        :param int to_port: To Port of the Instance.
        """
        if access_direction is not None:
            pulumi.set(__self__, "access_direction", access_direction)
        if access_from is not None:
            pulumi.set(__self__, "access_from", access_from)
        if access_type is not None:
            pulumi.set(__self__, "access_type", access_type)
        if cidr_list_aliases is not None:
            pulumi.set(__self__, "cidr_list_aliases", cidr_list_aliases)
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if from_port is not None:
            pulumi.set(__self__, "from_port", from_port)
        if ipv6_cidrs is not None:
            pulumi.set(__self__, "ipv6_cidrs", ipv6_cidrs)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if to_port is not None:
            pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="accessDirection")
    def access_direction(self) -> Optional[str]:
        """
        Access Direction for Protocol of the Instance(inbound/outbound).
        """
        return pulumi.get(self, "access_direction")

    @property
    @pulumi.getter(name="accessFrom")
    def access_from(self) -> Optional[str]:
        """
        Access From Protocol of the Instance.
        """
        return pulumi.get(self, "access_from")

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> Optional[str]:
        """
        Access Type Protocol of the Instance.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="cidrListAliases")
    def cidr_list_aliases(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cidr_list_aliases")

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cidrs")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        """
        CommonName for Protocol of the Instance.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> Optional[int]:
        """
        From Port of the Instance.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="ipv6Cidrs")
    def ipv6_cidrs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ipv6_cidrs")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Port Protocol of the Instance.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> Optional[int]:
        """
        To Port of the Instance.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class InstanceState(dict):
    """
    Current State of the Instance.
    """
    def __init__(__self__, *,
                 code: Optional[int] = None,
                 name: Optional[str] = None):
        """
        Current State of the Instance.
        :param int code: Status code of the Instance.
        :param str name: Status code of the Instance.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def code(self) -> Optional[int]:
        """
        Status code of the Instance.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Status code of the Instance.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class InstanceTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: Optional[str] = None):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadBalancerTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: Optional[str] = None):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param str value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")


