# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'CampaignDialerConfig',
    'CampaignOutboundCallConfig',
    'CampaignTag',
]

@pulumi.output_type
class CampaignDialerConfig(dict):
    """
    The possible types of dialer config parameters
    """
    def __init__(__self__):
        """
        The possible types of dialer config parameters
        """
        pass


@pulumi.output_type
class CampaignOutboundCallConfig(dict):
    """
    The configuration used for outbound calls.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectContactFlowArn":
            suggest = "connect_contact_flow_arn"
        elif key == "connectQueueArn":
            suggest = "connect_queue_arn"
        elif key == "connectSourcePhoneNumber":
            suggest = "connect_source_phone_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CampaignOutboundCallConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CampaignOutboundCallConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CampaignOutboundCallConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_contact_flow_arn: str,
                 connect_queue_arn: str,
                 connect_source_phone_number: Optional[str] = None):
        """
        The configuration used for outbound calls.
        :param str connect_contact_flow_arn: The identifier of the contact flow for the outbound call.
        :param str connect_queue_arn: The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you do not specify a queue, you must specify a source phone number.
        :param str connect_source_phone_number: The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.
        """
        pulumi.set(__self__, "connect_contact_flow_arn", connect_contact_flow_arn)
        pulumi.set(__self__, "connect_queue_arn", connect_queue_arn)
        if connect_source_phone_number is not None:
            pulumi.set(__self__, "connect_source_phone_number", connect_source_phone_number)

    @property
    @pulumi.getter(name="connectContactFlowArn")
    def connect_contact_flow_arn(self) -> str:
        """
        The identifier of the contact flow for the outbound call.
        """
        return pulumi.get(self, "connect_contact_flow_arn")

    @property
    @pulumi.getter(name="connectQueueArn")
    def connect_queue_arn(self) -> str:
        """
        The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the contact flow is used. If you do not specify a queue, you must specify a source phone number.
        """
        return pulumi.get(self, "connect_queue_arn")

    @property
    @pulumi.getter(name="connectSourcePhoneNumber")
    def connect_source_phone_number(self) -> Optional[str]:
        """
        The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.
        """
        return pulumi.get(self, "connect_source_phone_number")


@pulumi.output_type
class CampaignTag(dict):
    """
    A key-value pair to associate with a resource.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair to associate with a resource.
        :param str key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        :param str value: The value for the tag. You can specify a value that's 1 to 256 characters in length.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -. 
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value for the tag. You can specify a value that's 1 to 256 characters in length.
        """
        return pulumi.get(self, "value")


