# DO NOT EDIT! This file is automatically generated
import datetime
import enum
import typing

from commercetools.types._abstract import _BaseType
from commercetools.types._common import (
    BaseResource,
    Reference,
    ReferenceTypeId,
    ResourceIdentifier,
)

if typing.TYPE_CHECKING:
    from ._common import Address, CreatedBy, LastModifiedBy
    from ._customer_group import CustomerGroupReference, CustomerGroupResourceIdentifier
    from ._store import StoreKeyReference, StoreResourceIdentifier
    from ._type import (
        CustomFields,
        CustomFieldsDraft,
        FieldContainer,
        TypeResourceIdentifier,
    )
__all__ = [
    "AnonymousCartSignInMode",
    "Customer",
    "CustomerAddAddressAction",
    "CustomerAddBillingAddressIdAction",
    "CustomerAddShippingAddressIdAction",
    "CustomerAddStoreAction",
    "CustomerChangeAddressAction",
    "CustomerChangeEmailAction",
    "CustomerChangePassword",
    "CustomerCreateEmailToken",
    "CustomerCreatePasswordResetToken",
    "CustomerDraft",
    "CustomerEmailVerify",
    "CustomerPagedQueryResponse",
    "CustomerReference",
    "CustomerRemoveAddressAction",
    "CustomerRemoveBillingAddressIdAction",
    "CustomerRemoveShippingAddressIdAction",
    "CustomerRemoveStoreAction",
    "CustomerResetPassword",
    "CustomerResourceIdentifier",
    "CustomerSetCompanyNameAction",
    "CustomerSetCustomFieldAction",
    "CustomerSetCustomTypeAction",
    "CustomerSetCustomerGroupAction",
    "CustomerSetCustomerNumberAction",
    "CustomerSetDateOfBirthAction",
    "CustomerSetDefaultBillingAddressAction",
    "CustomerSetDefaultShippingAddressAction",
    "CustomerSetExternalIdAction",
    "CustomerSetFirstNameAction",
    "CustomerSetKeyAction",
    "CustomerSetLastNameAction",
    "CustomerSetLocaleAction",
    "CustomerSetMiddleNameAction",
    "CustomerSetSalutationAction",
    "CustomerSetStoresAction",
    "CustomerSetTitleAction",
    "CustomerSetVatIdAction",
    "CustomerSignInResult",
    "CustomerSignin",
    "CustomerToken",
    "CustomerUpdate",
    "CustomerUpdateAction",
]


class AnonymousCartSignInMode(enum.Enum):
    MERGE_WITH_EXISTING_CUSTOMER_CART = "MergeWithExistingCustomerCart"
    USE_AS_NEW_ACTIVE_CUSTOMER_CART = "UseAsNewActiveCustomerCart"


class Customer(BaseResource):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: datetime.datetime
    #: Optional :class:`commercetools.types.LastModifiedBy` `(Named` ``lastModifiedBy`` `in Commercetools)`
    last_modified_by: typing.Optional["LastModifiedBy"]
    #: Optional :class:`commercetools.types.CreatedBy` `(Named` ``createdBy`` `in Commercetools)`
    created_by: typing.Optional["CreatedBy"]
    #: Optional :class:`str` `(Named` ``customerNumber`` `in Commercetools)`
    customer_number: typing.Optional[str]
    #: :class:`str`
    email: str
    #: :class:`str`
    password: str
    #: Optional :class:`str` `(Named` ``firstName`` `in Commercetools)`
    first_name: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``lastName`` `in Commercetools)`
    last_name: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``middleName`` `in Commercetools)`
    middle_name: typing.Optional[str]
    #: Optional :class:`str`
    title: typing.Optional[str]
    #: Optional :class:`datetime.date` `(Named` ``dateOfBirth`` `in Commercetools)`
    date_of_birth: typing.Optional[datetime.date]
    #: Optional :class:`str` `(Named` ``companyName`` `in Commercetools)`
    company_name: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``vatId`` `in Commercetools)`
    vat_id: typing.Optional[str]
    #: List of :class:`commercetools.types.Address`
    addresses: typing.List["Address"]
    #: Optional :class:`str` `(Named` ``defaultShippingAddressId`` `in Commercetools)`
    default_shipping_address_id: typing.Optional[str]
    #: Optional list of :class:`str` `(Named` ``shippingAddressIds`` `in Commercetools)`
    shipping_address_ids: typing.Optional[typing.List[str]]
    #: Optional :class:`str` `(Named` ``defaultBillingAddressId`` `in Commercetools)`
    default_billing_address_id: typing.Optional[str]
    #: Optional list of :class:`str` `(Named` ``billingAddressIds`` `in Commercetools)`
    billing_address_ids: typing.Optional[typing.List[str]]
    #: :class:`bool` `(Named` ``isEmailVerified`` `in Commercetools)`
    is_email_verified: bool
    #: Optional :class:`str` `(Named` ``externalId`` `in Commercetools)`
    external_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.CustomerGroupReference` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupReference"]
    #: Optional :class:`commercetools.types.CustomFields`
    custom: typing.Optional["CustomFields"]
    #: Optional :class:`str`
    locale: typing.Optional[str]
    #: Optional :class:`str`
    salutation: typing.Optional[str]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.StoreKeyReference`
    stores: typing.Optional[typing.List["StoreKeyReference"]]

    def __init__(
        self,
        *,
        id: str,
        version: int,
        created_at: datetime.datetime,
        last_modified_at: datetime.datetime,
        email: str,
        password: str,
        addresses: typing.List["Address"],
        is_email_verified: bool,
        last_modified_by: typing.Optional["LastModifiedBy"] = None,
        created_by: typing.Optional["CreatedBy"] = None,
        customer_number: typing.Optional[str] = None,
        first_name: typing.Optional[str] = None,
        last_name: typing.Optional[str] = None,
        middle_name: typing.Optional[str] = None,
        title: typing.Optional[str] = None,
        date_of_birth: typing.Optional[datetime.date] = None,
        company_name: typing.Optional[str] = None,
        vat_id: typing.Optional[str] = None,
        default_shipping_address_id: typing.Optional[str] = None,
        shipping_address_ids: typing.Optional[typing.List[str]] = None,
        default_billing_address_id: typing.Optional[str] = None,
        billing_address_ids: typing.Optional[typing.List[str]] = None,
        external_id: typing.Optional[str] = None,
        customer_group: typing.Optional["CustomerGroupReference"] = None,
        custom: typing.Optional["CustomFields"] = None,
        locale: typing.Optional[str] = None,
        salutation: typing.Optional[str] = None,
        key: typing.Optional[str] = None,
        stores: typing.Optional[typing.List["StoreKeyReference"]] = None
    ) -> None:
        self.id = id
        self.version = version
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.created_by = created_by
        self.customer_number = customer_number
        self.email = email
        self.password = password
        self.first_name = first_name
        self.last_name = last_name
        self.middle_name = middle_name
        self.title = title
        self.date_of_birth = date_of_birth
        self.company_name = company_name
        self.vat_id = vat_id
        self.addresses = addresses
        self.default_shipping_address_id = default_shipping_address_id
        self.shipping_address_ids = shipping_address_ids
        self.default_billing_address_id = default_billing_address_id
        self.billing_address_ids = billing_address_ids
        self.is_email_verified = is_email_verified
        self.external_id = external_id
        self.customer_group = customer_group
        self.custom = custom
        self.locale = locale
        self.salutation = salutation
        self.key = key
        self.stores = stores
        super().__init__(
            id=id,
            version=version,
            created_at=created_at,
            last_modified_at=last_modified_at,
        )

    def __repr__(self) -> str:
        return (
            "Customer(id=%r, version=%r, created_at=%r, last_modified_at=%r, last_modified_by=%r, created_by=%r, customer_number=%r, email=%r, password=%r, first_name=%r, last_name=%r, middle_name=%r, title=%r, date_of_birth=%r, company_name=%r, vat_id=%r, addresses=%r, default_shipping_address_id=%r, shipping_address_ids=%r, default_billing_address_id=%r, billing_address_ids=%r, is_email_verified=%r, external_id=%r, customer_group=%r, custom=%r, locale=%r, salutation=%r, key=%r, stores=%r)"
            % (
                self.id,
                self.version,
                self.created_at,
                self.last_modified_at,
                self.last_modified_by,
                self.created_by,
                self.customer_number,
                self.email,
                self.password,
                self.first_name,
                self.last_name,
                self.middle_name,
                self.title,
                self.date_of_birth,
                self.company_name,
                self.vat_id,
                self.addresses,
                self.default_shipping_address_id,
                self.shipping_address_ids,
                self.default_billing_address_id,
                self.billing_address_ids,
                self.is_email_verified,
                self.external_id,
                self.customer_group,
                self.custom,
                self.locale,
                self.salutation,
                self.key,
                self.stores,
            )
        )


class CustomerChangePassword(_BaseType):
    #: :class:`str`
    id: str
    #: :class:`int`
    version: int
    #: :class:`str` `(Named` ``currentPassword`` `in Commercetools)`
    current_password: str
    #: :class:`str` `(Named` ``newPassword`` `in Commercetools)`
    new_password: str

    def __init__(
        self, *, id: str, version: int, current_password: str, new_password: str
    ) -> None:
        self.id = id
        self.version = version
        self.current_password = current_password
        self.new_password = new_password
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CustomerChangePassword(id=%r, version=%r, current_password=%r, new_password=%r)"
            % (self.id, self.version, self.current_password, self.new_password)
        )


class CustomerCreateEmailToken(_BaseType):
    #: :class:`str`
    id: str
    #: Optional :class:`int`
    version: typing.Optional[int]
    #: :class:`int` `(Named` ``ttlMinutes`` `in Commercetools)`
    ttl_minutes: int

    def __init__(
        self, *, id: str, ttl_minutes: int, version: typing.Optional[int] = None
    ) -> None:
        self.id = id
        self.version = version
        self.ttl_minutes = ttl_minutes
        super().__init__()

    def __repr__(self) -> str:
        return "CustomerCreateEmailToken(id=%r, version=%r, ttl_minutes=%r)" % (
            self.id,
            self.version,
            self.ttl_minutes,
        )


class CustomerCreatePasswordResetToken(_BaseType):
    #: :class:`str`
    email: str
    #: Optional :class:`int` `(Named` ``ttlMinutes`` `in Commercetools)`
    ttl_minutes: typing.Optional[int]

    def __init__(self, *, email: str, ttl_minutes: typing.Optional[int] = None) -> None:
        self.email = email
        self.ttl_minutes = ttl_minutes
        super().__init__()

    def __repr__(self) -> str:
        return "CustomerCreatePasswordResetToken(email=%r, ttl_minutes=%r)" % (
            self.email,
            self.ttl_minutes,
        )


class CustomerDraft(_BaseType):
    #: Optional :class:`str` `(Named` ``customerNumber`` `in Commercetools)`
    customer_number: typing.Optional[str]
    #: :class:`str`
    email: str
    #: :class:`str`
    password: str
    #: Optional :class:`str` `(Named` ``firstName`` `in Commercetools)`
    first_name: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``lastName`` `in Commercetools)`
    last_name: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``middleName`` `in Commercetools)`
    middle_name: typing.Optional[str]
    #: Optional :class:`str`
    title: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``anonymousCartId`` `in Commercetools)`
    anonymous_cart_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``anonymousId`` `in Commercetools)`
    anonymous_id: typing.Optional[str]
    #: Optional :class:`datetime.date` `(Named` ``dateOfBirth`` `in Commercetools)`
    date_of_birth: typing.Optional[datetime.date]
    #: Optional :class:`str` `(Named` ``companyName`` `in Commercetools)`
    company_name: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``vatId`` `in Commercetools)`
    vat_id: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.Address`
    addresses: typing.Optional[typing.List["Address"]]
    #: Optional :class:`int` `(Named` ``defaultShippingAddress`` `in Commercetools)`
    default_shipping_address: typing.Optional[int]
    #: Optional list of :class:`int` `(Named` ``shippingAddresses`` `in Commercetools)`
    shipping_addresses: typing.Optional[typing.List[int]]
    #: Optional :class:`int` `(Named` ``defaultBillingAddress`` `in Commercetools)`
    default_billing_address: typing.Optional[int]
    #: Optional list of :class:`int` `(Named` ``billingAddresses`` `in Commercetools)`
    billing_addresses: typing.Optional[typing.List[int]]
    #: Optional :class:`bool` `(Named` ``isEmailVerified`` `in Commercetools)`
    is_email_verified: typing.Optional[bool]
    #: Optional :class:`str` `(Named` ``externalId`` `in Commercetools)`
    external_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.CustomerGroupResourceIdentifier` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupResourceIdentifier"]
    #: Optional :class:`commercetools.types.CustomFieldsDraft`
    custom: typing.Optional["CustomFieldsDraft"]
    #: Optional :class:`str`
    locale: typing.Optional[str]
    #: Optional :class:`str`
    salutation: typing.Optional[str]
    #: Optional :class:`str`
    key: typing.Optional[str]
    #: Optional list of :class:`commercetools.types.StoreResourceIdentifier`
    stores: typing.Optional[typing.List["StoreResourceIdentifier"]]

    def __init__(
        self,
        *,
        email: str,
        password: str,
        customer_number: typing.Optional[str] = None,
        first_name: typing.Optional[str] = None,
        last_name: typing.Optional[str] = None,
        middle_name: typing.Optional[str] = None,
        title: typing.Optional[str] = None,
        anonymous_cart_id: typing.Optional[str] = None,
        anonymous_id: typing.Optional[str] = None,
        date_of_birth: typing.Optional[datetime.date] = None,
        company_name: typing.Optional[str] = None,
        vat_id: typing.Optional[str] = None,
        addresses: typing.Optional[typing.List["Address"]] = None,
        default_shipping_address: typing.Optional[int] = None,
        shipping_addresses: typing.Optional[typing.List[int]] = None,
        default_billing_address: typing.Optional[int] = None,
        billing_addresses: typing.Optional[typing.List[int]] = None,
        is_email_verified: typing.Optional[bool] = None,
        external_id: typing.Optional[str] = None,
        customer_group: typing.Optional["CustomerGroupResourceIdentifier"] = None,
        custom: typing.Optional["CustomFieldsDraft"] = None,
        locale: typing.Optional[str] = None,
        salutation: typing.Optional[str] = None,
        key: typing.Optional[str] = None,
        stores: typing.Optional[typing.List["StoreResourceIdentifier"]] = None
    ) -> None:
        self.customer_number = customer_number
        self.email = email
        self.password = password
        self.first_name = first_name
        self.last_name = last_name
        self.middle_name = middle_name
        self.title = title
        self.anonymous_cart_id = anonymous_cart_id
        self.anonymous_id = anonymous_id
        self.date_of_birth = date_of_birth
        self.company_name = company_name
        self.vat_id = vat_id
        self.addresses = addresses
        self.default_shipping_address = default_shipping_address
        self.shipping_addresses = shipping_addresses
        self.default_billing_address = default_billing_address
        self.billing_addresses = billing_addresses
        self.is_email_verified = is_email_verified
        self.external_id = external_id
        self.customer_group = customer_group
        self.custom = custom
        self.locale = locale
        self.salutation = salutation
        self.key = key
        self.stores = stores
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CustomerDraft(customer_number=%r, email=%r, password=%r, first_name=%r, last_name=%r, middle_name=%r, title=%r, anonymous_cart_id=%r, anonymous_id=%r, date_of_birth=%r, company_name=%r, vat_id=%r, addresses=%r, default_shipping_address=%r, shipping_addresses=%r, default_billing_address=%r, billing_addresses=%r, is_email_verified=%r, external_id=%r, customer_group=%r, custom=%r, locale=%r, salutation=%r, key=%r, stores=%r)"
            % (
                self.customer_number,
                self.email,
                self.password,
                self.first_name,
                self.last_name,
                self.middle_name,
                self.title,
                self.anonymous_cart_id,
                self.anonymous_id,
                self.date_of_birth,
                self.company_name,
                self.vat_id,
                self.addresses,
                self.default_shipping_address,
                self.shipping_addresses,
                self.default_billing_address,
                self.billing_addresses,
                self.is_email_verified,
                self.external_id,
                self.customer_group,
                self.custom,
                self.locale,
                self.salutation,
                self.key,
                self.stores,
            )
        )


class CustomerEmailVerify(_BaseType):
    #: Optional :class:`int`
    version: typing.Optional[int]
    #: :class:`str` `(Named` ``tokenValue`` `in Commercetools)`
    token_value: str

    def __init__(
        self, *, token_value: str, version: typing.Optional[int] = None
    ) -> None:
        self.version = version
        self.token_value = token_value
        super().__init__()

    def __repr__(self) -> str:
        return "CustomerEmailVerify(version=%r, token_value=%r)" % (
            self.version,
            self.token_value,
        )


class CustomerPagedQueryResponse(_BaseType):
    #: :class:`int`
    limit: int
    #: :class:`int`
    count: int
    #: Optional :class:`int`
    total: typing.Optional[int]
    #: :class:`int`
    offset: int
    #: List of :class:`commercetools.types.Customer`
    results: typing.Sequence["Customer"]

    def __init__(
        self,
        *,
        limit: int,
        count: int,
        offset: int,
        results: typing.Sequence["Customer"],
        total: typing.Optional[int] = None
    ) -> None:
        self.limit = limit
        self.count = count
        self.total = total
        self.offset = offset
        self.results = results
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CustomerPagedQueryResponse(limit=%r, count=%r, total=%r, offset=%r, results=%r)"
            % (self.limit, self.count, self.total, self.offset, self.results)
        )


class CustomerReference(Reference):
    #: Optional :class:`commercetools.types.Customer`
    obj: typing.Optional["Customer"]

    def __init__(self, *, id: str, obj: typing.Optional["Customer"] = None) -> None:
        self.obj = obj
        super().__init__(type_id=ReferenceTypeId.CUSTOMER, id=id)

    def __repr__(self) -> str:
        return "CustomerReference(type_id=%r, id=%r, obj=%r)" % (
            self.type_id,
            self.id,
            self.obj,
        )


class CustomerResetPassword(_BaseType):
    #: :class:`str` `(Named` ``tokenValue`` `in Commercetools)`
    token_value: str
    #: :class:`str` `(Named` ``newPassword`` `in Commercetools)`
    new_password: str
    #: Optional :class:`int`
    version: typing.Optional[int]

    def __init__(
        self,
        *,
        token_value: str,
        new_password: str,
        version: typing.Optional[int] = None
    ) -> None:
        self.token_value = token_value
        self.new_password = new_password
        self.version = version
        super().__init__()

    def __repr__(self) -> str:
        return "CustomerResetPassword(token_value=%r, new_password=%r, version=%r)" % (
            self.token_value,
            self.new_password,
            self.version,
        )


class CustomerResourceIdentifier(ResourceIdentifier):
    def __init__(
        self, *, id: typing.Optional[str] = None, key: typing.Optional[str] = None
    ) -> None:
        super().__init__(type_id=ReferenceTypeId.CUSTOMER, id=id, key=key)

    def __repr__(self) -> str:
        return "CustomerResourceIdentifier(type_id=%r, id=%r, key=%r)" % (
            self.type_id,
            self.id,
            self.key,
        )


class CustomerSignInResult(_BaseType):
    #: :class:`commercetools.types.Customer`
    customer: "Customer"
    #: Optional :class:`object`
    cart: typing.Optional[object]

    def __init__(
        self, *, customer: "Customer", cart: typing.Optional[object] = None
    ) -> None:
        self.customer = customer
        self.cart = cart
        super().__init__()

    def __repr__(self) -> str:
        return "CustomerSignInResult(customer=%r, cart=%r)" % (self.customer, self.cart)


class CustomerSignin(_BaseType):
    #: :class:`str`
    email: str
    #: :class:`str`
    password: str
    #: Optional :class:`str` `(Named` ``anonymousCartId`` `in Commercetools)`
    anonymous_cart_id: typing.Optional[str]
    #: Optional :class:`commercetools.types.AnonymousCartSignInMode` `(Named` ``anonymousCartSignInMode`` `in Commercetools)`
    anonymous_cart_sign_in_mode: typing.Optional["AnonymousCartSignInMode"]
    #: Optional :class:`str` `(Named` ``anonymousId`` `in Commercetools)`
    anonymous_id: typing.Optional[str]
    #: Optional :class:`bool` `(Named` ``updateProductData`` `in Commercetools)`
    update_product_data: typing.Optional[bool]

    def __init__(
        self,
        *,
        email: str,
        password: str,
        anonymous_cart_id: typing.Optional[str] = None,
        anonymous_cart_sign_in_mode: typing.Optional["AnonymousCartSignInMode"] = None,
        anonymous_id: typing.Optional[str] = None,
        update_product_data: typing.Optional[bool] = None
    ) -> None:
        self.email = email
        self.password = password
        self.anonymous_cart_id = anonymous_cart_id
        self.anonymous_cart_sign_in_mode = anonymous_cart_sign_in_mode
        self.anonymous_id = anonymous_id
        self.update_product_data = update_product_data
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CustomerSignin(email=%r, password=%r, anonymous_cart_id=%r, anonymous_cart_sign_in_mode=%r, anonymous_id=%r, update_product_data=%r)"
            % (
                self.email,
                self.password,
                self.anonymous_cart_id,
                self.anonymous_cart_sign_in_mode,
                self.anonymous_id,
                self.update_product_data,
            )
        )


class CustomerToken(_BaseType):
    #: :class:`str`
    id: str
    #: :class:`datetime.datetime` `(Named` ``createdAt`` `in Commercetools)`
    created_at: datetime.datetime
    #: Optional :class:`datetime.datetime` `(Named` ``lastModifiedAt`` `in Commercetools)`
    last_modified_at: typing.Optional[datetime.datetime]
    #: :class:`str` `(Named` ``customerId`` `in Commercetools)`
    customer_id: str
    #: :class:`datetime.datetime` `(Named` ``expiresAt`` `in Commercetools)`
    expires_at: datetime.datetime
    #: :class:`str`
    value: str

    def __init__(
        self,
        *,
        id: str,
        created_at: datetime.datetime,
        customer_id: str,
        expires_at: datetime.datetime,
        value: str,
        last_modified_at: typing.Optional[datetime.datetime] = None
    ) -> None:
        self.id = id
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        self.customer_id = customer_id
        self.expires_at = expires_at
        self.value = value
        super().__init__()

    def __repr__(self) -> str:
        return (
            "CustomerToken(id=%r, created_at=%r, last_modified_at=%r, customer_id=%r, expires_at=%r, value=%r)"
            % (
                self.id,
                self.created_at,
                self.last_modified_at,
                self.customer_id,
                self.expires_at,
                self.value,
            )
        )


class CustomerUpdate(_BaseType):
    #: :class:`int`
    version: int
    #: :class:`list`
    actions: list

    def __init__(self, *, version: int, actions: list) -> None:
        self.version = version
        self.actions = actions
        super().__init__()

    def __repr__(self) -> str:
        return "CustomerUpdate(version=%r, actions=%r)" % (self.version, self.actions)


class CustomerUpdateAction(_BaseType):
    #: :class:`str`
    action: str

    def __init__(self, *, action: str) -> None:
        self.action = action
        super().__init__()

    def __repr__(self) -> str:
        return "CustomerUpdateAction(action=%r)" % (self.action,)


class CustomerAddAddressAction(CustomerUpdateAction):
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(self, *, address: "Address") -> None:
        self.address = address
        super().__init__(action="addAddress")

    def __repr__(self) -> str:
        return "CustomerAddAddressAction(action=%r, address=%r)" % (
            self.action,
            self.address,
        )


class CustomerAddBillingAddressIdAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``addressId`` `in Commercetools)`
    address_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: typing.Optional[str]

    def __init__(
        self,
        *,
        address_id: typing.Optional[str] = None,
        address_key: typing.Optional[str] = None
    ) -> None:
        self.address_id = address_id
        self.address_key = address_key
        super().__init__(action="addBillingAddressId")

    def __repr__(self) -> str:
        return (
            "CustomerAddBillingAddressIdAction(action=%r, address_id=%r, address_key=%r)"
            % (self.action, self.address_id, self.address_key)
        )


class CustomerAddShippingAddressIdAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``addressId`` `in Commercetools)`
    address_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: typing.Optional[str]

    def __init__(
        self,
        *,
        address_id: typing.Optional[str] = None,
        address_key: typing.Optional[str] = None
    ) -> None:
        self.address_id = address_id
        self.address_key = address_key
        super().__init__(action="addShippingAddressId")

    def __repr__(self) -> str:
        return (
            "CustomerAddShippingAddressIdAction(action=%r, address_id=%r, address_key=%r)"
            % (self.action, self.address_id, self.address_key)
        )


class CustomerAddStoreAction(CustomerUpdateAction):
    #: :class:`commercetools.types.StoreResourceIdentifier`
    store: "StoreResourceIdentifier"

    def __init__(self, *, store: "StoreResourceIdentifier") -> None:
        self.store = store
        super().__init__(action="addStore")

    def __repr__(self) -> str:
        return "CustomerAddStoreAction(action=%r, store=%r)" % (self.action, self.store)


class CustomerChangeAddressAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``addressId`` `in Commercetools)`
    address_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: typing.Optional[str]
    #: :class:`commercetools.types.Address`
    address: "Address"

    def __init__(
        self,
        *,
        address: "Address",
        address_id: typing.Optional[str] = None,
        address_key: typing.Optional[str] = None
    ) -> None:
        self.address_id = address_id
        self.address_key = address_key
        self.address = address
        super().__init__(action="changeAddress")

    def __repr__(self) -> str:
        return (
            "CustomerChangeAddressAction(action=%r, address_id=%r, address_key=%r, address=%r)"
            % (self.action, self.address_id, self.address_key, self.address)
        )


class CustomerChangeEmailAction(CustomerUpdateAction):
    #: :class:`str`
    email: str

    def __init__(self, *, email: str) -> None:
        self.email = email
        super().__init__(action="changeEmail")

    def __repr__(self) -> str:
        return "CustomerChangeEmailAction(action=%r, email=%r)" % (
            self.action,
            self.email,
        )


class CustomerRemoveAddressAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``addressId`` `in Commercetools)`
    address_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: typing.Optional[str]

    def __init__(
        self,
        *,
        address_id: typing.Optional[str] = None,
        address_key: typing.Optional[str] = None
    ) -> None:
        self.address_id = address_id
        self.address_key = address_key
        super().__init__(action="removeAddress")

    def __repr__(self) -> str:
        return (
            "CustomerRemoveAddressAction(action=%r, address_id=%r, address_key=%r)"
            % (self.action, self.address_id, self.address_key)
        )


class CustomerRemoveBillingAddressIdAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``addressId`` `in Commercetools)`
    address_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: typing.Optional[str]

    def __init__(
        self,
        *,
        address_id: typing.Optional[str] = None,
        address_key: typing.Optional[str] = None
    ) -> None:
        self.address_id = address_id
        self.address_key = address_key
        super().__init__(action="removeBillingAddressId")

    def __repr__(self) -> str:
        return (
            "CustomerRemoveBillingAddressIdAction(action=%r, address_id=%r, address_key=%r)"
            % (self.action, self.address_id, self.address_key)
        )


class CustomerRemoveShippingAddressIdAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``addressId`` `in Commercetools)`
    address_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: typing.Optional[str]

    def __init__(
        self,
        *,
        address_id: typing.Optional[str] = None,
        address_key: typing.Optional[str] = None
    ) -> None:
        self.address_id = address_id
        self.address_key = address_key
        super().__init__(action="removeShippingAddressId")

    def __repr__(self) -> str:
        return (
            "CustomerRemoveShippingAddressIdAction(action=%r, address_id=%r, address_key=%r)"
            % (self.action, self.address_id, self.address_key)
        )


class CustomerRemoveStoreAction(CustomerUpdateAction):
    #: :class:`commercetools.types.StoreResourceIdentifier`
    store: "StoreResourceIdentifier"

    def __init__(self, *, store: "StoreResourceIdentifier") -> None:
        self.store = store
        super().__init__(action="removeStore")

    def __repr__(self) -> str:
        return "CustomerRemoveStoreAction(action=%r, store=%r)" % (
            self.action,
            self.store,
        )


class CustomerSetCompanyNameAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``companyName`` `in Commercetools)`
    company_name: typing.Optional[str]

    def __init__(self, *, company_name: typing.Optional[str] = None) -> None:
        self.company_name = company_name
        super().__init__(action="setCompanyName")

    def __repr__(self) -> str:
        return "CustomerSetCompanyNameAction(action=%r, company_name=%r)" % (
            self.action,
            self.company_name,
        )


class CustomerSetCustomFieldAction(CustomerUpdateAction):
    #: :class:`str`
    name: str
    #: Optional :class:`typing.Any`
    value: typing.Optional[typing.Any]

    def __init__(self, *, name: str, value: typing.Optional[typing.Any] = None) -> None:
        self.name = name
        self.value = value
        super().__init__(action="setCustomField")

    def __repr__(self) -> str:
        return "CustomerSetCustomFieldAction(action=%r, name=%r, value=%r)" % (
            self.action,
            self.name,
            self.value,
        )


class CustomerSetCustomTypeAction(CustomerUpdateAction):
    #: Optional :class:`commercetools.types.TypeResourceIdentifier`
    type: typing.Optional["TypeResourceIdentifier"]
    #: Optional :class:`commercetools.types.FieldContainer`
    fields: typing.Optional["FieldContainer"]

    def __init__(
        self,
        *,
        type: typing.Optional["TypeResourceIdentifier"] = None,
        fields: typing.Optional["FieldContainer"] = None
    ) -> None:
        self.type = type
        self.fields = fields
        super().__init__(action="setCustomType")

    def __repr__(self) -> str:
        return "CustomerSetCustomTypeAction(action=%r, type=%r, fields=%r)" % (
            self.action,
            self.type,
            self.fields,
        )


class CustomerSetCustomerGroupAction(CustomerUpdateAction):
    #: Optional :class:`commercetools.types.CustomerGroupResourceIdentifier` `(Named` ``customerGroup`` `in Commercetools)`
    customer_group: typing.Optional["CustomerGroupResourceIdentifier"]

    def __init__(
        self,
        *,
        customer_group: typing.Optional["CustomerGroupResourceIdentifier"] = None
    ) -> None:
        self.customer_group = customer_group
        super().__init__(action="setCustomerGroup")

    def __repr__(self) -> str:
        return "CustomerSetCustomerGroupAction(action=%r, customer_group=%r)" % (
            self.action,
            self.customer_group,
        )


class CustomerSetCustomerNumberAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``customerNumber`` `in Commercetools)`
    customer_number: typing.Optional[str]

    def __init__(self, *, customer_number: typing.Optional[str] = None) -> None:
        self.customer_number = customer_number
        super().__init__(action="setCustomerNumber")

    def __repr__(self) -> str:
        return "CustomerSetCustomerNumberAction(action=%r, customer_number=%r)" % (
            self.action,
            self.customer_number,
        )


class CustomerSetDateOfBirthAction(CustomerUpdateAction):
    #: Optional :class:`datetime.date` `(Named` ``dateOfBirth`` `in Commercetools)`
    date_of_birth: typing.Optional[datetime.date]

    def __init__(self, *, date_of_birth: typing.Optional[datetime.date] = None) -> None:
        self.date_of_birth = date_of_birth
        super().__init__(action="setDateOfBirth")

    def __repr__(self) -> str:
        return "CustomerSetDateOfBirthAction(action=%r, date_of_birth=%r)" % (
            self.action,
            self.date_of_birth,
        )


class CustomerSetDefaultBillingAddressAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``addressId`` `in Commercetools)`
    address_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: typing.Optional[str]

    def __init__(
        self,
        *,
        address_id: typing.Optional[str] = None,
        address_key: typing.Optional[str] = None
    ) -> None:
        self.address_id = address_id
        self.address_key = address_key
        super().__init__(action="setDefaultBillingAddress")

    def __repr__(self) -> str:
        return (
            "CustomerSetDefaultBillingAddressAction(action=%r, address_id=%r, address_key=%r)"
            % (self.action, self.address_id, self.address_key)
        )


class CustomerSetDefaultShippingAddressAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``addressId`` `in Commercetools)`
    address_id: typing.Optional[str]
    #: Optional :class:`str` `(Named` ``addressKey`` `in Commercetools)`
    address_key: typing.Optional[str]

    def __init__(
        self,
        *,
        address_id: typing.Optional[str] = None,
        address_key: typing.Optional[str] = None
    ) -> None:
        self.address_id = address_id
        self.address_key = address_key
        super().__init__(action="setDefaultShippingAddress")

    def __repr__(self) -> str:
        return (
            "CustomerSetDefaultShippingAddressAction(action=%r, address_id=%r, address_key=%r)"
            % (self.action, self.address_id, self.address_key)
        )


class CustomerSetExternalIdAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``externalId`` `in Commercetools)`
    external_id: typing.Optional[str]

    def __init__(self, *, external_id: typing.Optional[str] = None) -> None:
        self.external_id = external_id
        super().__init__(action="setExternalId")

    def __repr__(self) -> str:
        return "CustomerSetExternalIdAction(action=%r, external_id=%r)" % (
            self.action,
            self.external_id,
        )


class CustomerSetFirstNameAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``firstName`` `in Commercetools)`
    first_name: typing.Optional[str]

    def __init__(self, *, first_name: typing.Optional[str] = None) -> None:
        self.first_name = first_name
        super().__init__(action="setFirstName")

    def __repr__(self) -> str:
        return "CustomerSetFirstNameAction(action=%r, first_name=%r)" % (
            self.action,
            self.first_name,
        )


class CustomerSetKeyAction(CustomerUpdateAction):
    #: Optional :class:`str`
    key: typing.Optional[str]

    def __init__(self, *, key: typing.Optional[str] = None) -> None:
        self.key = key
        super().__init__(action="setKey")

    def __repr__(self) -> str:
        return "CustomerSetKeyAction(action=%r, key=%r)" % (self.action, self.key)


class CustomerSetLastNameAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``lastName`` `in Commercetools)`
    last_name: typing.Optional[str]

    def __init__(self, *, last_name: typing.Optional[str] = None) -> None:
        self.last_name = last_name
        super().__init__(action="setLastName")

    def __repr__(self) -> str:
        return "CustomerSetLastNameAction(action=%r, last_name=%r)" % (
            self.action,
            self.last_name,
        )


class CustomerSetLocaleAction(CustomerUpdateAction):
    #: Optional :class:`str`
    locale: typing.Optional[str]

    def __init__(self, *, locale: typing.Optional[str] = None) -> None:
        self.locale = locale
        super().__init__(action="setLocale")

    def __repr__(self) -> str:
        return "CustomerSetLocaleAction(action=%r, locale=%r)" % (
            self.action,
            self.locale,
        )


class CustomerSetMiddleNameAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``middleName`` `in Commercetools)`
    middle_name: typing.Optional[str]

    def __init__(self, *, middle_name: typing.Optional[str] = None) -> None:
        self.middle_name = middle_name
        super().__init__(action="setMiddleName")

    def __repr__(self) -> str:
        return "CustomerSetMiddleNameAction(action=%r, middle_name=%r)" % (
            self.action,
            self.middle_name,
        )


class CustomerSetSalutationAction(CustomerUpdateAction):
    #: Optional :class:`str`
    salutation: typing.Optional[str]

    def __init__(self, *, salutation: typing.Optional[str] = None) -> None:
        self.salutation = salutation
        super().__init__(action="setSalutation")

    def __repr__(self) -> str:
        return "CustomerSetSalutationAction(action=%r, salutation=%r)" % (
            self.action,
            self.salutation,
        )


class CustomerSetStoresAction(CustomerUpdateAction):
    #: Optional list of :class:`commercetools.types.StoreResourceIdentifier`
    stores: typing.Optional[typing.List["StoreResourceIdentifier"]]

    def __init__(
        self, *, stores: typing.Optional[typing.List["StoreResourceIdentifier"]] = None
    ) -> None:
        self.stores = stores
        super().__init__(action="setStores")

    def __repr__(self) -> str:
        return "CustomerSetStoresAction(action=%r, stores=%r)" % (
            self.action,
            self.stores,
        )


class CustomerSetTitleAction(CustomerUpdateAction):
    #: Optional :class:`str`
    title: typing.Optional[str]

    def __init__(self, *, title: typing.Optional[str] = None) -> None:
        self.title = title
        super().__init__(action="setTitle")

    def __repr__(self) -> str:
        return "CustomerSetTitleAction(action=%r, title=%r)" % (self.action, self.title)


class CustomerSetVatIdAction(CustomerUpdateAction):
    #: Optional :class:`str` `(Named` ``vatId`` `in Commercetools)`
    vat_id: typing.Optional[str]

    def __init__(self, *, vat_id: typing.Optional[str] = None) -> None:
        self.vat_id = vat_id
        super().__init__(action="setVatId")

    def __repr__(self) -> str:
        return "CustomerSetVatIdAction(action=%r, vat_id=%r)" % (
            self.action,
            self.vat_id,
        )
