# DO NOT EDIT! This file is automatically generated
import marshmallow
from marshmallow import fields

from commercetools.helpers import OptionalList, RemoveEmptyValuesMixin


class ExpandableSchema(marshmallow.Schema, RemoveEmptyValuesMixin):
    expand = OptionalList(fields.String(), required=False)


class QuerySchema(marshmallow.Schema, RemoveEmptyValuesMixin):
    where = OptionalList(fields.String(), required=False)
    predicate_var = fields.Dict()

    @marshmallow.post_dump
    def _predicate_var_post_dump(self, data, **kwrags):
        values = data.pop("predicate_var")
        if not values:
            return data
        for key, val in values.items():
            data[f"var.{key}"] = val
        return data

    @marshmallow.pre_load
    def _predicate_var_post_load(self, data, **kwrags):
        items = {}
        for key in list(data.keys()):
            if key.startswith("var."):
                items[key[4:]] = data[key]
                del data[key]
        data["predicate_var"] = items
        return data


class SortableSchema(marshmallow.Schema, RemoveEmptyValuesMixin):
    sort = OptionalList(fields.String(), required=False)


class PagingSchema(marshmallow.Schema, RemoveEmptyValuesMixin):
    limit = fields.Int(required=False)
    offset = fields.Int(required=False)
    with_total = fields.Bool(data_key="withTotal", required=False, missing=False)


class VersionedSchema(marshmallow.Schema, RemoveEmptyValuesMixin):
    version = fields.Int()


class PriceSelectingSchema(marshmallow.Schema, RemoveEmptyValuesMixin):
    price_currency = OptionalList(
        fields.String(), data_key="priceCurrency", required=False
    )
    price_country = OptionalList(
        fields.String(), data_key="priceCountry", required=False
    )
    price_customer_group = OptionalList(
        fields.String(), data_key="priceCustomerGroup", required=False
    )
    price_channel = OptionalList(
        fields.String(), data_key="priceChannel", required=False
    )
    locale_projection = OptionalList(
        fields.String(), data_key="localeProjection", required=False
    )
    store_projection = OptionalList(
        fields.String(), data_key="storeProjection", required=False
    )


class DataErasureSchema(marshmallow.Schema, RemoveEmptyValuesMixin):
    data_erasure = fields.Bool(data_key="dataErasure", required=False, missing=False)
