"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnAction = exports.PropsUtil = exports.DeploymentPlan = exports.DeploymentPlanStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_stepfunctions_1 = require("aws-cdk-lib/aws-stepfunctions");
const constructs_1 = require("constructs");
class DeploymentPlanStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.addTransform('AttiniDeploymentPlan');
        this.addTransform('AWS::Serverless-2016-10-31');
    }
}
exports.DeploymentPlanStack = DeploymentPlanStack;
_a = JSII_RTTI_SYMBOL_1;
DeploymentPlanStack[_a] = { fqn: "@attini/cdk.DeploymentPlanStack", version: "1.0.0-beta.0" };
class DeploymentPlan extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new aws_cdk_lib_1.CfnResource(this, id, {
            type: 'Attini::Deploy::DeploymentPlan',
            properties: {
                DeploymentPlan: new aws_stepfunctions_1.StateGraph(props.definition.startState, 'not important').toGraphJson(),
            },
        });
    }
}
exports.DeploymentPlan = DeploymentPlan;
_b = JSII_RTTI_SYMBOL_1;
DeploymentPlan[_b] = { fqn: "@attini/cdk.DeploymentPlan", version: "1.0.0-beta.0" };
class PropsUtil {
    static fixCase(props) {
        let copy = {};
        Object.entries(props).forEach(([key, value]) => {
            copy[key.charAt(0).toUpperCase() + key.slice(1)] = value;
        });
        return copy;
    }
}
exports.PropsUtil = PropsUtil;
_c = JSII_RTTI_SYMBOL_1;
PropsUtil[_c] = { fqn: "@attini/cdk.PropsUtil", version: "1.0.0-beta.0" };
var CfnAction;
(function (CfnAction) {
    CfnAction[CfnAction["DEPLOY"] = 0] = "DEPLOY";
    CfnAction[CfnAction["DELETE"] = 1] = "DELETE";
})(CfnAction = exports.CfnAction || (exports.CfnAction = {}));
__exportStar(require("./attini-state"), exports);
__exportStar(require("./attini-merge"), exports);
__exportStar(require("./attini-runner-job"), exports);
__exportStar(require("./attini-cfn"), exports);
__exportStar(require("./attini-manual-approval"), exports);
__exportStar(require("./attini-import"), exports);
__exportStar(require("./attini-lambda-invoke"), exports);
__exportStar(require("./attini-sam"), exports);
__exportStar(require("./attini-task"), exports);
__exportStar(require("./attini-runner"), exports);
//# sourceMappingURL=data:application/json;base64,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