/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of SMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package smt.iter.eig;

import java.io.OutputStream;
import java.io.PrintWriter;

import mt.Vector;

/**
 * Outputs the iteration progress to a stream
 */
public class OutputEigenvalueIterationReporter implements
        EigenvalueIterationReporter {

    /**
     * Platform-dependent output
     */
    private PrintWriter out;

    /**
     * Constructor for OutputEigenvalueIterationReporter
     * 
     * @param out
     *            Where to output information
     */
    public OutputEigenvalueIterationReporter(OutputStream out) {
        this.out = new PrintWriter(out, true);
    }

    /**
     * Constructor for OutputEigenvalueIterationReporter. Uses
     * <code>System.err</code>
     */
    public OutputEigenvalueIterationReporter() {
        this(System.err);
    }

    public void monitor(double r, double v, Vector x, int i) {
        monitor(r, i);
    }

    public void monitor(double r, double v, int i) {
        monitor(r, i);
    }

    public void monitor(double r, int i) {
        out.format("%10d % .12e\n", i, r);
    }

}
