/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of SMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package smt.iter.eig;

import mt.Matrix;
import mt.Vector;
import smt.iter.IterativeSolverNotConvergedException;

/**
 * Inverted spectral transformation with a locked initial shift. In other
 * aspects, it is the same as
 * {@link smt.iter.eig.ShiftInvertEigenvalueTransformation ShiftInvertEigenvalueTransformation}.
 */
public class LockShiftInvertEigenvalueTransformation extends
        ShiftInvertEigenvalueTransformation {

    /**
     * Constructor for LockShiftInvertEigenvalueTransformation
     * 
     * @param A
     *            Matrix to apply transformation to. Used to create the locked
     *            shift/invert matrix by copying
     * @param sigma
     *            Shift to apply
     * @param template
     *            Vector to use as template for the work vectors needed in the
     *            underlying iterative solver
     */
    public LockShiftInvertEigenvalueTransformation(Matrix A, double sigma,
            Vector template) {
        super(A, template);
        this.sigma = sigma;
        Am.addDiagonal(-sigma);
    }

    public Vector apply(Matrix A, Vector x, Vector y) {
        try {
            solver.solve(Am, x, y);
        } catch (IterativeSolverNotConvergedException e) {
            // Wrap the exception, pass it along
            throw new RuntimeException(e);
        }

        return y;
    }

    public void setShift(double sigma) {
    }

}
