/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of SMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package smt.iter.eig;

import mt.Matrix;
import mt.Vector;

/**
 * Iterative solver for large scale eigenvalue problems
 */
public interface IterativeEigenvalueSolver {

    /**
     * Solves the eigenvalue problem for the supplied matrix
     * 
     * @param A
     *            Matrix to solve for. Must be square
     * @param v
     *            Initial eigenvalue estimate
     * @param x
     *            Initial eigenvector estimate. Overwritten with computed
     *            eigenvector
     */
    double solve(Matrix A, double v, Vector x)
            throws IterativeEigenvalueSolverNotConvergedException;

    /**
     * Sets the eigenvalue transformation
     * 
     * @param et
     *            The eigenvalue transformation to use in sucessive solves
     */
    void setEigenvalueTransformation(EigenvalueTransformation et);

    /**
     * Returns the current eigenvalue transformation
     * 
     * @return Current eigenvalue transformation
     */
    EigenvalueTransformation getEigenvalueTransformation();

    /**
     * Sets iteration monitor
     * 
     * @param iter
     *            Eigenvalue iteration monitor
     */
    void setIterationMonitor(EigenvalueIterationMonitor iter);

    /**
     * Gets the iteration monitor
     * 
     * @return Current iteration monitor
     */
    EigenvalueIterationMonitor getIterationMonitor();

}
