/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

/**
 * Test of symmetrical matrices
 */
public abstract class SymmetricMatrixTest extends MatrixTest {

	public SymmetricMatrixTest(String arg0) {
		super(arg0);
	}

	public void testMatrixAdd() {
		// Not supported
	}

	public void testMatrixSet() {
		// Not supported
	}

	public void testOneMatrixAdd() {
		// Not supported
	}

	public void testOneMatrixSet() {
		// Not supported
	}

	public void testRandomMatrixAdd() {
		// Not supported
	}

	public void testRandomMatrixSet() {
		// Not supported
	}

	public void testRank1doubleVectorVector() {
		if (A.isSquare()) {
			double alpha = Math.random();
			assertEquals(rank1(alpha, xdR, xdR), A.rank1(alpha, xR, xR));
		}
	}

	public void testRank1doubleVectorVectorDense() {
		if (A.isSquare()) {
			double alpha = Math.random();
			assertEquals(
				rank1(alpha, xdR, xdR),
				A.rank1(alpha, xDenseR, xDenseR));
		}
	}

}
