/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of DMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package dmt.prec;

import mt.Matrix;
import mt.Vector;
import smt.iter.IterativeSolver;
import smt.iter.IterativeSolverNotConvergedException;
import smt.iter.prec.Preconditioner;

/**
 * Preconditioner using an iterative solver. Useful as a subdomain
 * preconditioner
 */
public class IterativeSolverPreconditioner implements Preconditioner {

    private IterativeSolver solver;

    private Matrix A;

    /**
     * Constructor for IterativeSolverPreconditioner
     * 
     * @param solver
     *            Solver to apply
     * @param A
     *            Matrix to solve for
     */
    public IterativeSolverPreconditioner(IterativeSolver solver, Matrix A) {
        this.solver = solver;
        this.A = A;
    }

    public Vector apply(Vector b, Vector x) {
        try {
            solver.solve(A, b, x);
        } catch (IterativeSolverNotConvergedException e) {
            // Ignored, the solver need not converge at this inner stage
        }
        return x;
    }

    public Vector transApply(Vector b, Vector x) {
        try {
            solver.transSolve(A, b, x);
        } catch (IterativeSolverNotConvergedException e) {
            // Ignored, the solver need not converge at this inner stage
        }
        return x;
    }

    public void setMatrix(Matrix A) {
        this.A = A;
    }

}
