/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import ru.sscc.util.data.DoublePointer;
import ru.sscc.util.data.FloatPointer;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealVector;

public abstract class RealPointer
implements Cloneable {
    protected int index;
    protected int step;
    private final int baseIndex;
    private final int baseStep;

    protected RealPointer(int n, int n2) {
        this.index = n;
        this.step = n2;
        this.baseIndex = n;
        this.baseStep = n2;
    }

    public abstract double add(double var1);

    public static RealPointer by(Object object) {
        return object == null ? null : (object instanceof double[] ? new DoublePointer((double[])object) : (object instanceof float[] ? new FloatPointer((float[])object) : (object instanceof RealContainer ? ((RealContainer)object).getPointer() : (object instanceof RealVector ? ((RealVector)object).getPointer() : (RealPointer)((RealPointer)object).clone()))));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract double get();

    public final RealPointer invert() {
        this.step = -this.step;
        return this;
    }

    public abstract double mul(double var1);

    public final RealPointer next() {
        this.index += this.step;
        return this;
    }

    public final RealPointer previous() {
        this.index -= this.step;
        return this;
    }

    public RealPointer reset(int n, int n2) {
        this.index = this.baseIndex + this.baseStep * n;
        this.step = this.baseStep * n2;
        return this;
    }

    public void restore(long l) {
        this.index = (int)(l >> 32);
        this.step = (int)l;
    }

    public long save() {
        return (long)this.index << 32 | (long)this.step & 0xFFFFFFFFL;
    }

    public abstract double set(double var1);

    public final RealPointer shift(int n) {
        this.index += this.step * n;
        return this;
    }
}

