/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import java.io.Serializable;
import ru.sscc.util.data.DoubleContainer;
import ru.sscc.util.data.FloatContainer;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public abstract class RealContainer
implements Cloneable,
Serializable {
    protected static final String CANT_MOVE_VECTOR = "Cannot move an alien vector";

    public abstract double add(int var1, double var2);

    public abstract void addVector(int var1, int var2, int var3, int var4, double var5, int var7);

    public abstract void assign(int var1, int var2, int var3, int var4, int var5);

    public static RealContainer by(Object object) {
        return object == null ? null : (object instanceof double[] ? new DoubleContainer((double[])object) : (object instanceof float[] ? new FloatContainer((float[])object) : (RealContainer)object));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final void ensureSize(int n) {
        if (this.size() < n) {
            throw new IllegalArgumentException("Container size is less than " + n);
        }
    }

    public abstract double get(int var1);

    public abstract Object getContainer();

    public abstract RealPointer getPointer();

    public final RealPointer getPointer(int n, int n2) {
        return this.getPointer().reset(n, n2);
    }

    public final RealVector getVector() {
        return this.getVector(0, 1, this.size());
    }

    public abstract RealVector getVector(int var1, int var2, int var3);

    public abstract int indexOfNormMax(int var1, int var2, int var3);

    public abstract void moveVector(RealVector var1, int var2);

    public abstract double mul(int var1, double var2);

    public abstract void multiply(int var1, int var2, double var3, int var5);

    public abstract RealContainer newContainer(int var1);

    public abstract double normMax(int var1, int var2, int var3);

    public abstract double normSum(int var1, int var2, int var3);

    public abstract double normalize(int var1, int var2, double var3, int var5);

    public abstract double postProduct(int var1, int var2, int var3, int var4, int var5);

    public abstract double postProduct(int var1, int var2, RealPointer var3, int var4);

    public abstract double preProduct(int var1, int var2, int var3, int var4, int var5);

    public abstract double preProduct(int var1, int var2, RealPointer var3, int var4);

    public abstract double relativeAccuracy();

    public abstract void resize(int var1);

    public abstract void rotate(double var1, double var3, int var5, int var6, int var7, int var8, int var9);

    public abstract double set(int var1, double var2);

    public final void shiftVector(RealVector realVector, int n) {
        this.moveVector(realVector, realVector.index + n);
    }

    public abstract int size();

    public abstract void swap(int var1, int var2, int var3, int var4, int var5);

    public abstract double weightedNormMax(int var1, int var2, RealPointer var3, int var4);

    public abstract double weightedNormSum(int var1, int var2, RealPointer var3, int var4);

    public abstract double weightedProduct(int var1, int var2, int var3, int var4, RealPointer var5, int var6);
}

