/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.util.data;

import ru.sscc.util.data.FloatPointer;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public final class FloatVector
extends RealVector {
    float[] data;

    public FloatVector(int n) {
        this(new float[n]);
    }

    public FloatVector(float[] fArray) {
        this(fArray, fArray.length, 0, 1);
    }

    public FloatVector(float[] fArray, int n, int n2, int n3) {
        super(n, n2, n3);
        this.data = fArray;
    }

    public double add(int n, double d) {
        int n2 = this.pos(n);
        float f = (float)((double)this.data[n2] + d);
        this.data[n2] = f;
        return f;
    }

    public double get(int n) {
        return this.data[this.pos(n)];
    }

    public RealPointer getPointer() {
        return new FloatPointer(this.data, this.index, this.step);
    }

    public double mul(int n, double d) {
        int n2 = this.pos(n);
        float f = (float)((double)this.data[n2] * d);
        this.data[n2] = f;
        return f;
    }

    public double set(int n, double d) {
        this.data[this.pos((int)n)] = (float)d;
        return d;
    }

    public RealVector subvector(int n, int n2, int n3) {
        return new FloatVector(this.data, n3, this.pos(n), this.inc(n2));
    }
}

