/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.polynomial;

import ru.sscc.spline.Spline;
import ru.sscc.spline.base.NonuniformMesh;
import ru.sscc.spline.base.OrderedMesh;
import ru.sscc.spline.base.SplineCreator;
import ru.sscc.spline.base.UniformMesh;
import ru.sscc.spline.polynomial.OddSplinePreparator;
import ru.sscc.spline.polynomial.PSplineBody;
import ru.sscc.spline.polynomial.PSplineCalculator;
import ru.sscc.util.CalculatingException;
import ru.sscc.util.data.DoubleVector;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class POddSplineCreator
extends SplineCreator {
    protected OddSplinePreparator preparator;
    protected PSplineCalculator calculator;
    protected transient RealVector lambda = null;
    protected transient RealVector f = null;

    public POddSplineCreator(int n, double d, double d2, int n2) {
        this(n, new UniformMesh(d, d2, n2));
    }

    public POddSplineCreator(int n, OrderedMesh orderedMesh) {
        super(new PSplineBody(orderedMesh, 2 * n - 1, n - 1));
        this.preparator = new OddSplinePreparator(orderedMesh, n);
        this.calculator = new PSplineCalculator((PSplineBody)this.body, this.preparator.getH());
    }

    public POddSplineCreator(int n, RealVector realVector) {
        this(n, new NonuniformMesh(realVector));
    }

    public void calculate(RealVector realVector, RealVector realVector2) {
        if (this.preparator.getAlpha() == 0.0) {
            this.preparator.solve(realVector, this.getLambda(), null);
            this.calculator.calculate(this.lambda, realVector, realVector2);
        } else {
            this.preparator.solve(realVector, this.getLambda(), this.getF());
            this.smoothingCalculate(realVector, realVector2);
        }
    }

    public double calculate(RealVector realVector, RealVector realVector2, double d) throws CalculatingException {
        double d2 = this.preparator.selectAlpha(realVector, d, 1.0, this.getLambda(), this.getF());
        this.smoothingCalculate(realVector, realVector2);
        return d2;
    }

    public double calculationCost() {
        return this.preparator.calculationCost() + this.calculator.calculationCost();
    }

    public Spline constructSpline(RealVector realVector, double d) throws CalculatingException {
        Spline spline = new Spline(this.body);
        this.calculate(realVector, spline.getVector(), d);
        return spline;
    }

    public static final Spline createSpline(int n, double d, double d2, int n2, Object object) throws CalculatingException {
        return POddSplineCreator.createSpline(n, d, d2, n2, object, 0.0, null);
    }

    public static final Spline createSpline(int n, double d, double d2, int n2, Object object, double d3) throws CalculatingException {
        return POddSplineCreator.createSpline(n, d, d2, n2, object, d3, null);
    }

    public static final Spline createSpline(int n, double d, double d2, int n2, Object object, double d3, Object object2) throws CalculatingException {
        return POddSplineCreator.createSpline(n, new UniformMesh(d, d2, n2), object, d3, object2);
    }

    public static final Spline createSpline(int n, Object object, Object object2) throws CalculatingException {
        return POddSplineCreator.createSpline(n, object, object2, 0.0, null);
    }

    public static final Spline createSpline(int n, Object object, Object object2, double d) throws CalculatingException {
        return POddSplineCreator.createSpline(n, object, object2, d, null);
    }

    public static Spline createSpline(int n, Object object, Object object2, double d, Object object3) throws CalculatingException {
        POddSplineCreator pOddSplineCreator;
        POddSplineCreator pOddSplineCreator2 = pOddSplineCreator = object instanceof OrderedMesh ? new POddSplineCreator(n, (OrderedMesh)object) : new POddSplineCreator(n, RealVector.by(object));
        if (d <= 0.0) {
            pOddSplineCreator.prepareSolver(0.0);
            return pOddSplineCreator.constructSpline(RealVector.by(object2));
        }
        pOddSplineCreator.prepareWeights(object3);
        return pOddSplineCreator.constructSpline(RealVector.by(object2), d);
    }

    public double getAlpha() {
        return this.preparator.getAlpha();
    }

    public final PSplineCalculator getCalculator() {
        return this.calculator;
    }

    protected RealVector getF() {
        if (this.f == null) {
            this.f = new DoubleVector(this.preparator.getH().nColumns);
        }
        return this.f;
    }

    protected RealVector getLambda() {
        if (this.lambda == null) {
            this.lambda = new DoubleVector(this.preparator.getH().nRows);
        }
        return this.lambda;
    }

    public final OddSplinePreparator getPreparator() {
        return this.preparator;
    }

    public void prepareSolver(double d) throws CalculatingException {
        this.preparator.prepareSolver(d);
    }

    public void prepareWeights(Object object) {
        this.preparator.prepareWeights(object);
    }

    private void smoothingCalculate(RealVector realVector, RealVector realVector2) {
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = this.f.getPointer();
        int n = this.preparator.sourceSize;
        while (n > 0) {
            realPointer2.set(realPointer.get() - realPointer2.get());
            --n;
            realPointer.next();
            realPointer2.next();
        }
        this.calculator.calculate(this.lambda, this.f, realVector2);
    }

    public int sourceSize() {
        return this.preparator.sourceSize;
    }
}

