/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.base;

import ru.sscc.matrix.RectBandedMatrix;
import ru.sscc.matrix.SymBandedMatrix;
import ru.sscc.spline.base.OrderedPreparator;
import ru.sscc.util.data.DoubleContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;

public class UniformPreparator
extends OrderedPreparator {
    public UniformPreparator(int n, int n2) {
        this.h = this.calculateH(n, n2);
    }

    public void calculateA(SymBandedMatrix symBandedMatrix) {
        this.ensureValidMatrix(symBandedMatrix, true);
        if (symBandedMatrix.nRows == 0) {
            return;
        }
        int n = this.h.bandWidth - 1;
        int n2 = 2 * n - 1;
        double d = (double)(1 - 2 * (n & 1)) / RealMath.factorial(n2);
        RealPointer realPointer = symBandedMatrix.getContainer().getPointer();
        RealPointer realPointer2 = this.h.getContainer().getPointer(0, -1);
        RealMath.assign(realPointer, 0.0, symBandedMatrix.halfWidth);
        int n3 = 0;
        while (n3 < n) {
            RealMath.addVector(realPointer, realPointer2, RealMath.power(n - n3, n2) * d, n3 + 1);
            ++n3;
            realPointer2.previous();
        }
        n3 = n;
        while (n3 > 0) {
            realPointer.set(RealMath.innerProduct(realPointer, realPointer2, n3));
            --n3;
            realPointer.next();
        }
    }

    private RectBandedMatrix calculateH(int n, int n2) {
        if (n2 <= 0 || n2 > n) {
            throw new IllegalArgumentException("Nonpositive difference order");
        }
        double[] dArray = new double[n2 + 1];
        double d = n2 % 2 != 0 ? -1 : 1;
        int n3 = 0;
        while (n3 <= n2) {
            dArray[n3] = d;
            d *= (double)(n3 - n2) / (double)(n3 + 1);
            ++n3;
        }
        return new RectBandedMatrix(new DoubleContainer(dArray), n - n2, n2 + 1, true);
    }
}

