/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.spline.base;

import java.io.Serializable;
import ru.sscc.spline.Spline;
import ru.sscc.spline.SplineBody;
import ru.sscc.spline.Splines;
import ru.sscc.util.data.RealVector;
import ru.sscc.util.data.RealVectors;

public abstract class SplineCreator
implements Serializable {
    protected SplineBody body;

    protected SplineCreator(SplineBody splineBody) {
        this.body = splineBody;
    }

    public abstract void calculate(RealVector var1, RealVector var2);

    public abstract double calculationCost();

    public final Spline constructSpline(RealVector realVector) {
        realVector.ensureLength(this.sourceSize());
        Spline spline = new Spline(this.body);
        this.calculate(realVector, spline.getVector());
        return spline;
    }

    public final Splines constructSplinesByColumns(RealVectors realVectors) {
        realVectors.ensureSize(this.sourceSize());
        int n = realVectors.dimension;
        Splines splines = new Splines(this.body, n);
        int n2 = 0;
        while (n2 < n) {
            this.calculate(realVectors.getComponent(n2), splines.getVector(n2));
            ++n2;
        }
        return splines;
    }

    public final Splines constructSplinesByRows(RealVectors realVectors) {
        realVectors.ensureDimension(this.sourceSize());
        int n = realVectors.size;
        Splines splines = new Splines(this.body, n);
        int n2 = 0;
        while (n2 < n) {
            this.calculate(realVectors.getVector(n2), splines.getVector(n2));
            ++n2;
        }
        return splines;
    }

    public final SplineBody getBody() {
        return this.body;
    }

    public abstract int sourceSize();

    public final int targetSize() {
        return this.body.getVectorLength();
    }
}

