/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix.solve;

import ru.sscc.matrix.DenseMatrix;
import ru.sscc.matrix.solve.RealSquareSolver;
import ru.sscc.util.CalculatingException;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class CholeskySolver
extends RealSquareSolver {
    public CholeskySolver() {
    }

    public CholeskySolver(int n) {
        super(new DenseMatrix(n, n));
    }

    public CholeskySolver(DenseMatrix denseMatrix) {
        super(denseMatrix);
    }

    public CholeskySolver(RealContainer realContainer, int n) {
        super(new DenseMatrix(realContainer, n, n));
    }

    public void factorize() throws CalculatingException {
        int n;
        if (this.isFactorized()) {
            return;
        }
        this.matrix.lock();
        int n2 = this.matrix.nRows;
        if (n2 == 0) {
            this.setFactorized(true);
            return;
        }
        int n3 = this.matrix.columnStep;
        int n4 = this.matrix.rowStep;
        int n5 = this.matrix.startIndex;
        double d = this.matrix.relativeAccuracy() * 8.0;
        RealContainer realContainer = this.matrix.getContainer();
        int n6 = n = n5;
        int n7 = 0;
        while (n7 < n2) {
            double d2;
            double d3 = realContainer.get(n6);
            if (d3 < 0.0) {
                d2 = 0.0;
            } else {
                d2 = d3 * d;
                d3 -= realContainer.postProduct(n, n3, n, n3, n7);
            }
            if (d3 <= d2) {
                throw new CalculatingException(d3 < -d2 ? "Nonpositive matrix" : "Ill-posed matrix");
            }
            d3 = Math.sqrt(d3);
            realContainer.set(n6, d3);
            int n8 = n6;
            int n9 = n;
            int n10 = n7 + 1;
            while (n10 < n2) {
                realContainer.set(n8 += n4, (realContainer.get(n8) - realContainer.postProduct(n9 += n4, n3, n, n3, n7)) / d3);
                ++n10;
            }
            ++n7;
            n6 += n4 + n3;
            n += n4;
        }
        this.setFactorized(true);
    }

    public void solve(RealVector realVector, RealVector realVector2) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        if (n == 0) {
            return;
        }
        realVector.ensureLength(n);
        realVector2.ensureLength(n);
        int n2 = this.matrix.columnStep;
        int n3 = this.matrix.rowStep;
        int n4 = this.matrix.startIndex;
        RealContainer realContainer = this.matrix.getContainer();
        RealPointer realPointer = realContainer.getPointer(n4, n2 + n3);
        RealPointer realPointer2 = realVector.getPointer();
        RealPointer realPointer3 = realVector2.getPointer();
        RealSquareSolver.forwardSubstitution(realContainer, n4, n3, n2, realPointer, realPointer2, realPointer3, n);
        realPointer.reset(n4 += (n - 1) * (n3 + n2), -n2 - n3);
        realPointer3.reset(n - 1, -1);
        RealSquareSolver.forwardSubstitution(realContainer, n4, -n2, -n3, realPointer, realPointer3, realPointer3, n);
    }
}

