/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix.solve;

import ru.sscc.matrix.SymBandedMatrix;
import ru.sscc.matrix.solve.RealDirectSolver;
import ru.sscc.util.CalculatingException;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class CholeskyBandSolver
extends RealDirectSolver {
    protected SymBandedMatrix matrix = null;

    public CholeskyBandSolver() {
    }

    public CholeskyBandSolver(int n, int n2, boolean bl) {
        this(new SymBandedMatrix(n, n2, bl));
    }

    public CholeskyBandSolver(SymBandedMatrix symBandedMatrix) {
        this.attach(symBandedMatrix);
    }

    public CholeskyBandSolver(RealContainer realContainer, int n, int n2, boolean bl) {
        this(new SymBandedMatrix(realContainer, n, n2, bl));
    }

    public void attach(SymBandedMatrix symBandedMatrix) {
        this.matrix = symBandedMatrix;
        this.setFactorized(false);
        if (symBandedMatrix != null) {
            symBandedMatrix.reuse(symBandedMatrix.isToeplitz());
        }
    }

    public void factorize() throws CalculatingException {
        if (this.isFactorized()) {
            return;
        }
        this.matrix.expand();
        this.matrix.lock();
        int n = this.matrix.nRows;
        if (n == 0) {
            this.setFactorized(true);
            return;
        }
        int n2 = this.matrix.halfWidth;
        int n3 = n2 - 1;
        double d = this.matrix.relativeAccuracy() * 8.0;
        RealContainer realContainer = this.matrix.getContainer();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            double d2;
            double d3 = realContainer.get(n4);
            if (d3 < 0.0) {
                d2 = 0.0;
            } else {
                d2 = d3 * d;
                d3 -= realContainer.preProduct(n4, -n3, n4, -n3, Math.min(n5, n3));
            }
            if (d3 <= d2) {
                throw new CalculatingException(d3 < -d2 ? "Nonpositive matrix" : "Ill-posed matrix");
            }
            d3 = 1.0 / Math.sqrt(d3);
            realContainer.set(n4, d3);
            int n6 = Math.min(n2, n - n5);
            int n7 = 1;
            while (n7 < n6) {
                int n8 = n4 + n7;
                realContainer.set(n8, (realContainer.get(n8) - realContainer.preProduct(n4, -n3, n8, -n3, Math.min(n5, n3 - n7))) * d3);
                ++n7;
            }
            ++n5;
            n4 += n2;
        }
        this.setFactorized(true);
    }

    public final SymBandedMatrix getMatrix() {
        return this.matrix;
    }

    public final void reuse(boolean bl) {
        this.setFactorized(false);
        this.matrix.reuse(bl);
    }

    public void solve(RealVector realVector, RealVector realVector2) {
        this.ensureFactorized();
        int n = this.matrix.nRows;
        if (n == 0) {
            return;
        }
        realVector.ensureLength(n);
        realVector2.ensureLength(n);
        RealContainer realContainer = this.matrix.getContainer();
        int n2 = this.matrix.halfWidth;
        int n3 = n2 - 1;
        RealPointer realPointer = realVector.getPointer();
        RealPointer realPointer2 = realVector2.getPointer(0, -1);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            realPointer2.set((realPointer.get() - realContainer.preProduct(n4, -n3, realPointer2, Math.min(n5, n3))) * realContainer.get(n4));
            ++n5;
            n4 += n2;
            realPointer.next();
            realPointer2.previous();
        }
        realPointer2.invert();
        while (n5 > 0) {
            realPointer2.previous();
            realPointer2.set((realPointer2.get() - realContainer.preProduct(n4 -= n2, 1, realPointer2, Math.min(n - n5, n3))) * realContainer.get(n4));
            --n5;
        }
    }

    public final int sourceSize() {
        return this.matrix.nRows;
    }

    public final int targetSize() {
        return this.matrix.nColumns;
    }
}

