/*
 * Decompiled with CFR 0.152.
 */
package ru.sscc.matrix;

import ru.sscc.matrix.RealMatrix;
import ru.sscc.util.data.DoubleContainer;
import ru.sscc.util.data.RealContainer;
import ru.sscc.util.data.RealMath;
import ru.sscc.util.data.RealPointer;
import ru.sscc.util.data.RealVector;

public class SymBandedMatrix
extends RealMatrix {
    private boolean toeplitz = false;
    public final int halfWidth;

    public SymBandedMatrix(int n, int n2, boolean bl) {
        this(new DoubleContainer(bl ? n2 : n * n2), n, n2, bl);
    }

    public SymBandedMatrix(RealContainer realContainer, int n, int n2, boolean bl) {
        super(realContainer, n, n);
        realContainer.ensureSize(bl ? n2 : n * n2);
        this.halfWidth = n2;
        this.toeplitz = bl;
    }

    public double add(int n, int n2, double d) {
        if (n2 < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if ((n2 -= n) >= this.halfWidth) {
            throw new IllegalArgumentException("Cannot set a value of the matrix entry");
        }
        return this.entries.add(this.toeplitz ? n2 : n * this.halfWidth + n2, d);
    }

    public void expand() {
        this.ensureAlgebraic();
        if (this.nRows == 0) {
            this.toeplitz = false;
            return;
        }
        if (!this.toeplitz) {
            return;
        }
        if (this.entries.size() < this.nRows * this.halfWidth) {
            this.entries.resize(this.nRows * this.halfWidth);
        }
        RealPointer realPointer = this.entries.getPointer();
        int n = 0;
        while (n < this.halfWidth) {
            double d = realPointer.reset(n, this.halfWidth).get();
            RealMath.assign(realPointer.next(), d, this.nRows - 1);
            ++n;
        }
        this.toeplitz = false;
    }

    public double get(int n, int n2) {
        if (n2 < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        return (n2 -= n) < this.halfWidth ? this.entries.get(this.toeplitz ? n2 : n * this.halfWidth + n2) : 0.0;
    }

    public final boolean isToeplitz() {
        return this.toeplitz;
    }

    public double mul(int n, int n2, double d) {
        if (n2 < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if ((n2 -= n) >= this.halfWidth) {
            throw new IllegalArgumentException("Cannot set a value of the matrix entry");
        }
        return this.entries.mul(this.toeplitz ? n2 : n * this.halfWidth + n2, d);
    }

    public void multiply(RealVector realVector, RealVector realVector2) {
        this.ensureAlgebraic();
        if (this.nRows == 0) {
            return;
        }
        realVector.ensureLength(this.nRows);
        realVector2.ensureLength(this.nRows);
        RealPointer realPointer = realVector2.getPointer();
        RealPointer realPointer2 = realVector.getPointer(0, -1);
        int n = this.toeplitz ? 0 : this.halfWidth;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.nRows) {
            int n4 = Math.min(this.halfWidth, this.nRows - n3) - 1;
            realPointer.set(this.entries.postProduct(n2 + n4, -1, realPointer2.shift(-n4), n4) + this.entries.postProduct(n2, 1 - n, realPointer2.shift(n4), Math.min(n3 + 1, this.halfWidth)));
            ++n3;
            n2 += n;
            realPointer.next();
            realPointer2.previous();
        }
    }

    public final void multiplyT(RealVector realVector, RealVector realVector2) {
        this.multiply(realVector, realVector2);
    }

    public void reuse(boolean bl) {
        this.unlock();
        if (!bl && this.toeplitz) {
            this.expand();
        }
        this.toeplitz = bl;
    }

    public double set(int n, int n2, double d) {
        if (n2 < n) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if ((n2 -= n) >= this.halfWidth) {
            throw new IllegalArgumentException("Cannot set a value of the matrix entry");
        }
        return this.entries.set(this.toeplitz ? n2 : n * this.halfWidth + n2, d);
    }
}

