/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.xml.config;

import ch.javasoft.xml.config.FileConfigParser;
import ch.javasoft.xml.config.URLConfigParser;
import ch.javasoft.xml.config.XmlConfigException;
import ch.javasoft.xml.config.XmlNode;
import ch.javasoft.xml.config.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.Element;

public class StreamConfigParser {
    private static final String LOG_PRINT_STREAM_CLASSNAME = "ch.javasoft.util.logging.LogPrintStream";

    public static OutputStream parseOutputStream(Element streamElement) throws XmlConfigException {
        String typeName = streamElement.attributeValue(XmlAttribute.type.getXmlName());
        XmlOutputStreamType type = XmlOutputStreamType.find(typeName);
        if (type == null) {
            throw new XmlConfigException("unknown stream type '" + typeName + "'", streamElement);
        }
        switch (type) {
            case file: {
                return StreamConfigParser.parseFileOutputStream(streamElement);
            }
            case console: {
                return StreamConfigParser.parseConsolePrintStream(streamElement);
            }
            case logger: {
                return StreamConfigParser.parseLoggerStream(streamElement);
            }
        }
        throw new XmlConfigException("internal error, unknown stream type " + (Object)((Object)type), streamElement);
    }

    public static FileOutputStream parseFileOutputStream(Element streamElement) throws XmlConfigException {
        Element elFile = XmlUtil.getRequiredSingleChildElement(streamElement, XmlElement.file);
        File file = FileConfigParser.parseFile(elFile);
        try {
            return new FileOutputStream(file);
        }
        catch (IOException ex) {
            throw new XmlConfigException("cannot open file output stream for file '" + file.getAbsolutePath() + "'", streamElement, (Throwable)ex);
        }
    }

    public static PrintStream parseConsolePrintStream(Element streamElement) throws XmlConfigException {
        Element elConsole = XmlUtil.getRequiredSingleChildElement(streamElement, XmlElement.console);
        String consoleName = elConsole.attributeValue(XmlAttribute.type.getXmlName());
        ConsoleType type = ConsoleType.find(consoleName);
        if (type == null) {
            throw new XmlConfigException("Unknown console type '" + consoleName + "' for " + XmlElement.console.getXmlName() + " element", streamElement);
        }
        return type.getStream();
    }

    public static PrintStream parseLoggerStream(Element streamElement) throws XmlConfigException {
        Level logLevel;
        Element elLogLevel = XmlUtil.getRequiredSingleChildElement(streamElement, XmlElement.logger);
        String loggerName = elLogLevel.attributeValue(XmlAttribute.name.getXmlName());
        String levelName = elLogLevel.attributeValue(XmlAttribute.level.getXmlName());
        try {
            logLevel = Level.parse(levelName);
        }
        catch (Exception ex) {
            throw new XmlConfigException("invalid log level: " + levelName, elLogLevel);
        }
        Logger logger = Logger.getLogger(loggerName == null ? "" : loggerName);
        try {
            Class<?> streamClass = Class.forName(LOG_PRINT_STREAM_CLASSNAME);
            Constructor<?> cons = streamClass.getConstructor(Logger.class, Level.class);
            return (PrintStream)cons.newInstance(logger, logLevel);
        }
        catch (Exception ex) {
            throw new XmlConfigException("cannot instantiate log print stream, e=" + ex, elLogLevel);
        }
    }

    public static InputStream parseInputStream(Element streamElement) throws XmlConfigException {
        String typeName = streamElement.attributeValue(XmlAttribute.type.getXmlName());
        XmlInputStreamType type = XmlInputStreamType.find(typeName);
        if (type == null) {
            throw new XmlConfigException("unknown stream type '" + typeName + "'", streamElement);
        }
        switch (type) {
            case file: {
                return StreamConfigParser.parseFileInputStream(streamElement);
            }
            case url: {
                return StreamConfigParser.parseURLInputStream(streamElement);
            }
        }
        throw new XmlConfigException("internal error, unknown stream type " + (Object)((Object)type), streamElement);
    }

    public static FileInputStream parseFileInputStream(Element streamElement) throws XmlConfigException {
        Element elFile = XmlUtil.getRequiredSingleChildElement(streamElement, XmlElement.file);
        File file = FileConfigParser.parseFile(elFile);
        try {
            return new FileInputStream(file);
        }
        catch (IOException ex) {
            throw new XmlConfigException("cannot open file input stream for file '" + file.getAbsolutePath() + "'", streamElement, (Throwable)ex);
        }
    }

    public static InputStream parseURLInputStream(Element streamElement) throws XmlConfigException {
        Element elURL = XmlUtil.getRequiredSingleChildElement(streamElement, XmlElement.url);
        URL url = URLConfigParser.parseURL(elURL);
        try {
            return url.openStream();
        }
        catch (IOException ex) {
            throw new XmlConfigException("cannot open URL input stream url '" + url.toExternalForm() + "', e=" + ex, streamElement, (Throwable)ex);
        }
    }

    private StreamConfigParser() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConsoleType {
        out,
        err;


        public static ConsoleType find(String typeAttributeValue) {
            ConsoleType[] consoleTypeArray = ConsoleType.values();
            int n = consoleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleType type = consoleTypeArray[n2];
                if (type.name().equalsIgnoreCase(typeAttributeValue)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }

        public PrintStream getStream() {
            return this == err ? System.err : System.out;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlAttribute implements XmlNode
    {
        name,
        type,
        value,
        level;


        @Override
        public String getXmlName() {
            return this.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlElement implements XmlNode
    {
        stream,
        console,
        file,
        url,
        logger;


        @Override
        public String getXmlName() {
            return this.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlInputStreamType {
        file,
        url;


        public String xmlName() {
            return this.name();
        }

        public static XmlInputStreamType find(String typeAttributeValue) {
            XmlInputStreamType[] xmlInputStreamTypeArray = XmlInputStreamType.values();
            int n = xmlInputStreamTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlInputStreamType type = xmlInputStreamTypeArray[n2];
                if (type.xmlName().equals(typeAttributeValue)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlOutputStreamType {
        file,
        console,
        logger;


        public String xmlName() {
            return this.name();
        }

        public static XmlOutputStreamType find(String typeAttributeValue) {
            XmlOutputStreamType[] xmlOutputStreamTypeArray = XmlOutputStreamType.values();
            int n = xmlOutputStreamTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlOutputStreamType type = xmlOutputStreamTypeArray[n2];
                if (type.xmlName().equals(typeAttributeValue)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }
}

