/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.numeric;

public class IntegerUtil {
    public static int signum(long value) {
        return value == 0L ? 0 : (value > 0L ? 1 : -1);
    }

    public static int signum(int value) {
        return value == 0 ? 0 : (value > 0 ? 1 : -1);
    }

    public static int gcd(Integer ... values) {
        if (values.length == 0) {
            return 1;
        }
        int allSgn = IntegerUtil.signum(values[0]);
        int gcd = values[0];
        int i = 1;
        while (i < values.length) {
            if (allSgn != IntegerUtil.signum(values[i])) {
                allSgn = 1;
            }
            if (gcd == 0 || gcd == 1) break;
            gcd = IntegerUtil.gcd(gcd, (int)values[i]);
            ++i;
        }
        return allSgn == 0 ? 0 : allSgn * gcd;
    }

    public static int gcd(int ... values) {
        if (values.length == 0) {
            return 1;
        }
        int allSgn = IntegerUtil.signum(values[0]);
        int gcd = values[0];
        int i = 1;
        while (i < values.length) {
            if (allSgn != IntegerUtil.signum(values[i])) {
                allSgn = 1;
            }
            if (gcd == 0 || gcd == 1) break;
            gcd = IntegerUtil.gcd(gcd, values[i]);
            ++i;
        }
        return allSgn == 0 ? 0 : allSgn * gcd;
    }

    public static long gcd(Long ... values) {
        if (values.length == 0) {
            return 1L;
        }
        int allSgn = IntegerUtil.signum(values[0]);
        long gcd = values[0];
        int i = 1;
        while (i < values.length) {
            if (allSgn != IntegerUtil.signum(values[i])) {
                allSgn = 1;
            }
            if (gcd == 0L || gcd == 1L) break;
            gcd = IntegerUtil.gcd(gcd, (long)values[i]);
            ++i;
        }
        return allSgn == 0 ? 0L : (long)allSgn * gcd;
    }

    public static long gcd(long ... values) {
        if (values.length == 0) {
            return 1L;
        }
        int allSgn = IntegerUtil.signum(values[0]);
        long gcd = values[0];
        int i = 1;
        while (i < values.length) {
            if (allSgn != IntegerUtil.signum(values[i])) {
                allSgn = 1;
            }
            if (gcd == 0L || gcd == 1L) break;
            gcd = IntegerUtil.gcd(gcd, values[i]);
            ++i;
        }
        return allSgn == 0 ? 0L : (long)allSgn * gcd;
    }

    public static int gcd(int iA, int iB) {
        iA = Math.abs(iA);
        iB = Math.abs(iB);
        if (iA == 0) {
            return iB;
        }
        if (iB == 0) {
            return iA;
        }
        if (iA < 0 || iB < 0) {
            if (((iA | iB) & 1) != 0) {
                return 1;
            }
            iA = Math.abs(iA >>> 1);
            iB = Math.abs(iB >>> 1);
        }
        int iMax = Math.max(iA, iB);
        int iMin = Math.min(iA, iB);
        while (iMax != iMin) {
            if (iMax % iMin == 0) {
                return iMin;
            }
            int tmp = iMin;
            iMin = iMax - iMax / iMin * iMin;
            iMax = tmp;
        }
        return iMin;
    }

    public static int[] extendedEuclidean(int a, int b) {
        int x = 0;
        int y = 1;
        int lastx = 1;
        int lasty = 0;
        while (b != 0) {
            int temp = b;
            int quotient = a / b;
            b = a % b;
            a = temp;
            temp = x;
            x = lastx - quotient * x;
            lastx = temp;
            temp = y;
            y = lasty - quotient * y;
            lasty = temp;
        }
        return new int[]{lastx, lasty, a};
    }

    public static int modularReciprocal(int a, int mod) {
        int origA = a;
        int origMod = mod;
        int x = 0;
        int y = 1;
        int lastx = 1;
        int lasty = 0;
        while (mod != 0) {
            int temp = mod;
            int quotient = a / mod;
            mod = a % mod;
            a = temp;
            temp = x;
            x = lastx - quotient * x;
            lastx = temp;
            temp = y;
            y = lasty - quotient * y;
            lasty = temp;
        }
        if (a != 1 && a != -1) {
            throw new ArithmeticException(String.valueOf(origA) + " is not invertible (mod " + origMod + ") " + "since gcd(" + origA + ", " + origMod + ") = " + a + " != 1");
        }
        return lastx;
    }

    public static long gcd(long iA, long iB) {
        iA = Math.abs(iA);
        iB = Math.abs(iB);
        if (iA == 0L) {
            return iB;
        }
        if (iB == 0L) {
            return iA;
        }
        if (iA < 0L || iB < 0L) {
            if (0L != ((iA | iB) & 1L)) {
                return 1L;
            }
            iA = Math.abs(iA >>> 1);
            iB = Math.abs(iB >>> 1);
        }
        long iMax = Math.max(iA, iB);
        long iMin = Math.min(iA, iB);
        while (iMax != iMin) {
            if (iMax % iMin == 0L) {
                return iMin;
            }
            long tmp = iMin;
            iMin = iMax - iMax / iMin * iMin;
            iMax = tmp;
        }
        return iMin;
    }

    public static long[] extendedEuclidean(long a, long b) {
        long x = 0L;
        long y = 1L;
        long lastx = 1L;
        long lasty = 0L;
        while (b != 0L) {
            long temp = b;
            long quotient = a / b;
            b = a % b;
            a = temp;
            temp = x;
            x = lastx - quotient * x;
            lastx = temp;
            temp = y;
            y = lasty - quotient * y;
            lasty = temp;
        }
        return new long[]{lastx, lasty, a};
    }

    public static long modularReciprocal(long a, long mod) {
        long origA = a;
        long origMod = mod;
        long x = 0L;
        long y = 1L;
        long lastx = 1L;
        long lasty = 0L;
        while (mod != 0L) {
            long temp = mod;
            long quotient = a / mod;
            mod = a % mod;
            a = temp;
            temp = x;
            x = lastx - quotient * x;
            lastx = temp;
            temp = y;
            y = lasty - quotient * y;
            lasty = temp;
        }
        if (a != 1L && a != -1L) {
            throw new ArithmeticException(String.valueOf(origA) + " is not invertible (mod " + origMod + ") " + "since gcd(" + origA + ", " + origMod + ") = " + a + " != 1");
        }
        return lastx;
    }

    public static int modularReciprocal2pow32(int a) {
        int x1 = IntegerUtil.modularReciprocal(a, Integer.MIN_VALUE);
        return a * x1 * x1;
    }

    public static long modularReciprocal2pow64(long a) {
        long x1 = IntegerUtil.modularReciprocal(a, Long.MIN_VALUE);
        return a * x1 * x1;
    }

    private IntegerUtil() {
    }
}

