/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.map;

import ch.javasoft.util.map.AbstractMultiValueMap;
import ch.javasoft.util.map.DefaultMultiValueMap;
import ch.javasoft.util.map.MultiValueMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleValueMap<K, V>
extends AbstractMultiValueMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 3091457636828431277L;
    private final Map<K, V> map;

    public SingleValueMap(Map<K, V> map) {
        this.map = map;
    }

    @Override
    public boolean contains(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public int count(Object key) {
        return this.map.containsKey(key) ? 1 : 0;
    }

    @Override
    public boolean contains(Object key, V value) {
        V myval = this.map.get(key);
        return myval != null && myval.equals(value);
    }

    @Override
    public Collection<V> get(Object key) {
        return Collections.singleton(this.map.get(key));
    }

    @Override
    public V getFirst(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Map<K, V> asSingleValueMap() {
        return this.map;
    }

    @Override
    public MultiValueMap<V, K> invert() {
        LinkedHashMap<V, K> hinv = new LinkedHashMap<V, K>();
        AbstractMultiValueMap minv = null;
        for (K key : this.keySet()) {
            V value = this.map.get(key);
            if (minv == null) {
                K pkey = hinv.put(value, key);
                if (pkey != null) {
                    hinv.put(value, pkey);
                    minv = DefaultMultiValueMap.createFromSingleValueMap(hinv);
                    minv.add(value, pkey);
                    continue;
                }
                hinv.put(value, key);
                continue;
            }
            minv.add(value, key);
        }
        if (minv == null) {
            minv = new SingleValueMap<V, K>(hinv);
        }
        return minv;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int keySize() {
        return this.map.size();
    }

    @Override
    public int valueSize() {
        return this.map.size();
    }

    @Override
    public Iterable<V> values() {
        return this.map.values();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            return this.map.equals(((SingleValueMap)obj).map);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }
}

