/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.map;

import ch.javasoft.util.map.AbstractMultiValueMap;
import ch.javasoft.util.map.MultiValueMap;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableMultiValueMap<K, V>
extends AbstractMultiValueMap<K, V> {
    public AbstractMutableMultiValueMap() {
    }

    public AbstractMutableMultiValueMap(MultiValueMap<? extends K, ? extends V> copy) {
        this();
        this.addAll(copy);
    }

    @Override
    public boolean addAll(K key, V ... values) {
        boolean any = false;
        V[] VArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            V value = VArray[n2];
            any |= this.add(key, value);
            ++n2;
        }
        return any;
    }

    @Override
    public boolean addAll(K key, Collection<? extends V> values) {
        boolean any = false;
        for (V value : values) {
            any |= this.add(key, value);
        }
        return any;
    }

    @Override
    public boolean addAll(Map<? extends K, ? extends V> map) {
        boolean any = false;
        for (K key : map.keySet()) {
            any |= this.add(key, map.get(key));
        }
        return any;
    }

    @Override
    public boolean addAllNested(Map<? extends K, ? extends Collection<? extends V>> map) {
        boolean any = false;
        for (K key : map.keySet()) {
            any |= this.addAll(key, map.get(key));
        }
        return any;
    }

    @Override
    public boolean addAll(MultiValueMap<? extends K, ? extends V> mapping) {
        boolean any = false;
        for (K key : mapping.keySet()) {
            any |= this.addAll(key, mapping.get(key));
        }
        return any;
    }
}

