/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util.longs;

import ch.javasoft.util.LongArray;
import ch.javasoft.util.Unsigned;
import ch.javasoft.util.longs.AbstractLongList;
import ch.javasoft.util.longs.AbstractLongListIterator;
import ch.javasoft.util.longs.AbstractSortedLongSet;
import ch.javasoft.util.longs.LongIterable;
import ch.javasoft.util.longs.LongIterator;
import ch.javasoft.util.longs.LongList;
import ch.javasoft.util.longs.LongListIterator;
import ch.javasoft.util.longs.SortedLongSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExactMembershipLongSet
extends AbstractSortedLongSet
implements LongList {
    protected abstract Storage getStorage();

    @Override
    public int size() {
        return this.getStorage().size();
    }

    @Override
    public long getLong(int index) {
        Storage storage = this.getStorage();
        int unsignedIndex = storage.convertSignedToUnsignedIndex(index);
        return storage.get(unsignedIndex);
    }

    @Override
    public LongListIterator listIterator(int index) {
        return this.listIterator(index, this.size());
    }

    @Override
    public LongListIterator listIterator(int start, int end) {
        return this.getStorage().listIterator(start, end);
    }

    @Override
    public Long get(int index) {
        return this.getLong(index);
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return this.indexOfLong(((Number)o).longValue());
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return this.lastIndexOfLong(((Number)o).longValue());
        }
        return -1;
    }

    @Override
    public int lastIndexOfLong(long value) {
        return this.indexOfLong(value);
    }

    @Override
    public int indexOfLong(long value) {
        Storage storage = this.getStorage();
        int unsignedIndex = storage.indexOf(value);
        return unsignedIndex < 0 ? -1 : storage.convertUnsignedToSignedIndex(unsignedIndex);
    }

    public int binarySearch(long value) {
        Storage storage = this.getStorage();
        int unsignedIndex = storage.indexOf(value);
        return unsignedIndex >= 0 ? storage.convertSignedToUnsignedIndex(unsignedIndex) : -storage.convertUnsignedToSignedIndex(-unsignedIndex - 1) - 1;
    }

    @Override
    public boolean containsLong(long value) {
        return this.indexOfLong(value) != -1;
    }

    @Override
    public LongList subList(final int fromIndex, final int toIndex) {
        return new AbstractLongList(){

            public LongList subList(int newfromIndex, int newtoIndex) {
                return AbstractExactMembershipLongSet.this.subList(fromIndex + newfromIndex, Math.min(fromIndex + newtoIndex, toIndex));
            }

            public LongListIterator listIterator(int start, int end) {
                return AbstractExactMembershipLongSet.this.listIterator(fromIndex + start, Math.min(fromIndex + end, toIndex));
            }

            public long getLong(int index) {
                return AbstractExactMembershipLongSet.this.getLong(fromIndex + index);
            }

            public int size() {
                return toIndex - fromIndex;
            }

            public int setLong(int index, long value) {
                throw new UnsupportedOperationException("unmodifiable set");
            }

            public long removeLongAt(int index) {
                throw new UnsupportedOperationException("unmodifiable set");
            }

            public boolean addLong(int index, long value) {
                throw new UnsupportedOperationException("unmodifiable set");
            }

            public void clear() {
                throw new UnsupportedOperationException("unmodifiable set");
            }
        };
    }

    @Override
    public SortedLongSet subSet(long fromElement, long toElement) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public Comparator<? super Long> comparator() {
        return null;
    }

    @Override
    public LongIterator iterator() {
        return this.listIterator();
    }

    @Override
    public LongListIterator listIterator() {
        return this.listIterator(0, this.size());
    }

    public abstract AbstractExactMembershipLongSet intersect(AbstractExactMembershipLongSet var1);

    public long bytesSize() {
        return this.getStorage().bytesSize();
    }

    @Override
    public boolean addLong(long value) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public boolean addLong(int index, long value) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public void add(int index, Long element) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public int setLong(int index, long value) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public boolean removeLong(long value) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public Long set(int index, Long element) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public long removeLongAt(int index) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public Long remove(int index) {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("unmodifiable set");
    }

    protected static abstract class AbstractStorage
    implements Storage {
        private final int negStart;
        private final int k;

        public AbstractStorage(int k, int negStart) {
            this.k = k;
            this.negStart = negStart;
        }

        public int getK() {
            return this.k;
        }

        public int indexOfFirstNegativeValue() {
            return this.negStart;
        }

        public int convertSignedToUnsignedIndex(int signedIndex) {
            return (this.negStart + signedIndex) % this.size();
        }

        public int convertUnsignedToSignedIndex(int unsignedIndex) {
            int size = this.size();
            return (unsignedIndex + this.negStart + size) % size;
        }

        public LongListIterator listIterator(final int start, final int end) {
            return new AbstractLongListIterator(){
                int current;
                {
                    this.current = n;
                }

                public long previousLong() {
                    if (this.current <= start) {
                        throw new NoSuchElementException();
                    }
                    return AbstractStorage.this.get(AbstractStorage.this.convertSignedToUnsignedIndex(--this.current));
                }

                public int previousIndex() {
                    return this.current <= start ? -1 : this.current;
                }

                public long nextLong() {
                    if (this.current >= end) {
                        throw new NoSuchElementException();
                    }
                    return AbstractStorage.this.get(AbstractStorage.this.convertSignedToUnsignedIndex(this.current++));
                }

                public int nextIndex() {
                    return this.current < end ? this.current : end;
                }

                public boolean hasPrevious() {
                    return this.current > start;
                }

                public boolean hasNext() {
                    return this.current < end;
                }
            };
        }
    }

    protected static interface Storage {
        public int size();

        public int getK();

        public int indexOfFirstNegativeValue();

        public int convertSignedToUnsignedIndex(int var1);

        public int convertUnsignedToSignedIndex(int var1);

        public long get(int var1);

        public int indexOf(long var1);

        public LongListIterator listIterator(int var1, int var2);

        public Storage intersect(Storage var1);

        public long bytesSize();
    }

    protected static class Storage64
    extends AbstractStorage {
        private final long[] y;

        public Storage64(long[] sorted, int negStart) {
            super(64, negStart);
            this.y = sorted;
        }

        public Storage64(LongIterable sorted, int negStart) {
            super(64, negStart);
            LongArray arr = sorted instanceof Collection ? new LongArray(((Collection)((Object)sorted)).size()) : new LongArray();
            LongIterator it = sorted.iterator();
            while (it.hasNext()) {
                arr.add(it.nextLong());
            }
            this.y = arr.yieldArray();
        }

        public int size() {
            return this.y.length;
        }

        public long get(int index) {
            return this.y[index];
        }

        public int indexOf(long value) {
            return Unsigned.binarySearch(this.y, 0, this.y.length, value);
        }

        public Storage64 intersect(Storage with) {
            int mylen = this.y.length;
            int otlen = with.size();
            LongArray inter = new LongArray();
            int i = 0;
            int j = 0;
            int n = -1;
            while (i < mylen && j < otlen) {
                long me = this.y[i];
                long ot = with.get(j);
                int cmp = Unsigned.compare(me, ot);
                if (cmp < 0) {
                    ++i;
                    continue;
                }
                if (cmp > 0) {
                    ++j;
                    continue;
                }
                if (n < 0 && me < 0L) {
                    n = inter.length();
                }
                inter.add(me);
                ++i;
                ++j;
            }
            return new Storage64(inter.toArray(), n < 0 ? inter.length() : n);
        }

        public long bytesSize() {
            return 8L * (long)this.y.length;
        }
    }
}

