/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.util;

import ch.javasoft.util.Arrays;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArray
implements Iterable<Integer>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7927213642550265076L;
    public static final int[] EMPTY_ARRAY = new int[0];
    private static final int DEFAULT_CAPACITY = 7;
    private int mLength = 0;
    private int[] mArray;

    public IntArray() {
        this(7);
    }

    public IntArray(int capacity) {
        this.mArray = new int[capacity];
        this.initialize(this.mArray, 0, capacity, false);
    }

    public IntArray(int[] initialValues) {
        this.mArray = initialValues;
        this.mLength = initialValues.length;
    }

    public IntArray(int[] original, int from, int to) {
        this.mArray = Arrays.copyOfRange(original, from, to);
        this.mLength = to - from;
    }

    public int length() {
        return this.mLength;
    }

    public boolean isEmpty() {
        return this.mLength == 0;
    }

    public int get(int index) throws IndexOutOfBoundsException {
        if (index >= this.mLength) {
            throw new IndexOutOfBoundsException("index not in [0, " + (this.mLength - 1) + "]: " + index);
        }
        return this.mArray[index];
    }

    public int indexOf(int value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int fromIndex, int value) {
        int i = fromIndex;
        while (i < this.mLength) {
            if (value == this.mArray[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int set(int index, int value) throws IndexOutOfBoundsException {
        int old;
        if (index >= this.mLength) {
            this.ensureCapacity(index + 1);
            old = this.initialValue();
        } else {
            old = this.mArray[index];
        }
        this.mArray[index] = value;
        this.mLength = Math.max(this.mLength, index + 1);
        return old;
    }

    public void add(int value) {
        this.set(this.mLength, value);
    }

    public void addAll(IntArray array) {
        this.addAll(0, this.mLength, array.mArray);
    }

    public void addAll(int from, int to, IntArray array) {
        if (to > array.mLength) {
            throw new IndexOutOfBoundsException("to index after length: " + to + " > " + array.mLength);
        }
        this.addAll(from, to, array.mArray);
    }

    public void addAll(int ... values) {
        this.addAll(0, values.length, values);
    }

    public void addAll(int from, int to, int ... values) {
        if (from < 0) {
            throw new IndexOutOfBoundsException("from must be non-negative: " + from);
        }
        if (to < from) {
            throw new IndexOutOfBoundsException("to must not be smaller than from: " + to + " < " + from);
        }
        this.ensureCapacity(this.mLength + to - from);
        System.arraycopy(values, from, this.mArray, this.mLength, to - from);
        this.mLength += to - from;
    }

    public boolean add(int index, int value) {
        if (index < 0 || index > this.mLength) {
            throw new IndexOutOfBoundsException("index must be >=0 and <= length, but was " + index);
        }
        this.ensureCapacity(this.mLength + 1);
        System.arraycopy(this.mArray, index, this.mArray, index + 1, this.mLength - index);
        this.mArray[index] = value;
        ++this.mLength;
        return true;
    }

    public int removeLast() {
        return this.remove(this.mLength - 1);
    }

    public int remove(int index) {
        if (index >= this.mLength) {
            throw new IndexOutOfBoundsException("index not in [0, " + (this.mLength - 1) + "]: " + index);
        }
        int old = this.mArray[index];
        --this.mLength;
        System.arraycopy(this.mArray, index + 1, this.mArray, index, this.mLength - index);
        return old;
    }

    public void clear() {
        this.initialize(this.mArray, 0, this.mLength, true);
        this.mLength = 0;
    }

    public int first() {
        return this.get(0);
    }

    public int last() {
        return this.get(this.mLength - 1);
    }

    public void swap(int indexA, int indexB) {
        if (indexA < 0 || indexA >= this.mLength) {
            throw new IndexOutOfBoundsException("index " + indexA + " not in [0, " + (this.mLength - 1) + "]");
        }
        if (indexB < 0 || indexB >= this.mLength) {
            throw new IndexOutOfBoundsException("index " + indexB + " not in [0, " + (this.mLength - 1) + "]");
        }
        int tmp = this.mArray[indexA];
        this.mArray[indexA] = this.mArray[indexB];
        this.mArray[indexB] = tmp;
    }

    protected void ensureCapacity(int size) {
        if (size >= this.mArray.length) {
            int newSize = Math.max(size, this.mArray.length * 2);
            int[] newArr = new int[newSize];
            System.arraycopy(this.mArray, 0, newArr, 0, this.mLength);
            this.initialize(newArr, this.mLength, newSize, false);
            this.mArray = newArr;
        }
    }

    protected int initialValue() {
        return 0;
    }

    private void initialize(int[] array, int from, int to, boolean force) {
        int initialValue = this.initialValue();
        if ((force || initialValue != 0) && from < to) {
            java.util.Arrays.fill(array, from, to, initialValue);
        }
    }

    public int[] toArray() {
        int[] arr = new int[this.mLength];
        System.arraycopy(this.mArray, 0, arr, 0, this.mLength);
        return arr;
    }

    public int[] yieldArray() {
        this.trimToLength();
        int[] arr = this.mArray;
        this.mArray = new int[7];
        this.initialize(this.mArray, 0, 7, false);
        this.mLength = 0;
        return arr;
    }

    public IntArray clone() {
        return new IntArray(this.mArray, 0, this.mLength);
    }

    public IntArray subRange(int from) {
        return this.subRange(from, this.mLength);
    }

    public IntArray subRange(int from, int to) {
        return new IntArray(this.mArray, from, to);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < IntArray.this.length();
            }

            @Override
            public Integer next() {
                return IntArray.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("immutable iterator");
            }
        };
    }

    public static int[][] toMatrix(IntArray[] mx) {
        int[][] res = new int[mx.length][];
        int i = 0;
        while (i < mx.length) {
            res[i] = mx[i].toArray();
            ++i;
        }
        return res;
    }

    public static int[][] toMatrix(Collection<IntArray> mx) {
        int[][] res = new int[mx.size()][];
        int ri = 0;
        for (IntArray row : mx) {
            res[ri++] = row.toArray();
        }
        return res;
    }

    public static int[][] toMatrix(Collection<int[]> mx, boolean cloneArrays) {
        int[][] res = new int[mx.size()][];
        int ri = 0;
        if (cloneArrays) {
            for (int[] row : mx) {
                res[ri++] = (int[])row.clone();
            }
        } else {
            for (int[] row : mx) {
                res[ri++] = row;
            }
        }
        return res;
    }

    public static void swap(int[] arr, int indexA, int indexB) {
        int tmp = arr[indexA];
        arr[indexA] = arr[indexB];
        arr[indexB] = tmp;
    }

    public static int[][] clone(int[][] arr) {
        int[][] clone = new int[arr.length][];
        int i = 0;
        while (i < clone.length) {
            int len = arr[i].length;
            clone[i] = new int[len];
            System.arraycopy(arr[i], 0, clone[i], 0, len);
            ++i;
        }
        return clone;
    }

    public void trimToLength() {
        if (this.mLength < this.mArray.length) {
            int[] arr = new int[this.mLength];
            System.arraycopy(this.mArray, 0, arr, 0, this.mLength);
            this.mArray = arr;
        }
    }

    public int binarySearch(int key) throws IllegalStateException {
        return this.binarySearch(key, 0, this.mLength);
    }

    public int binarySearch(int key, int fromIndex, int toIndex) throws IllegalStateException {
        return Arrays.binarySearch(this.mArray, fromIndex, toIndex, key);
    }

    public int addToSorted(int value) {
        int pos = this.binarySearch(value);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        this.add(pos, value);
        return pos;
    }

    public void sort(boolean ascending) {
        this.sort(ascending, 0, this.mLength);
    }

    public void sort(boolean ascending, int start, int end) {
        java.util.Arrays.sort(this.mArray, start, end);
        if (!ascending) {
            int ii = start;
            while (ii < end / 2) {
                int tmp = this.mArray[ii];
                this.mArray[ii] = this.mArray[end - ii - 1];
                this.mArray[end - ii - 1] = tmp;
                ++ii;
            }
        }
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.mLength) {
            hash ^= this.mArray[i];
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntArray) {
            IntArray other = (IntArray)obj;
            if (this.mLength != other.mLength) {
                return false;
            }
            int i = 0;
            while (i < this.mLength) {
                if (this.mArray[i] != other.mArray[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int ii = 0;
        while (ii < this.mLength) {
            if (ii > 0) {
                sb.append(", ");
            }
            sb.append(this.mArray[ii]);
            ++ii;
        }
        sb.append(']');
        return sb.toString();
    }
}

